"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var d3_shape_1 = require("d3-shape");
var canvas_text_bbox_calculator_1 = require("../axes/canvas_text_bbox_calculator");
var scale_continuous_1 = require("../utils/scales/scale_continuous");
var curves_1 = require("./curves");
var series_utils_1 = require("./series_utils");
function isPointGeometry(ig) {
    return ig.hasOwnProperty('radius');
}
exports.isPointGeometry = isPointGeometry;
function isBarGeometry(ig) {
    return ig.hasOwnProperty('width') && ig.hasOwnProperty('height');
}
exports.isBarGeometry = isBarGeometry;
function mutableIndexedGeometryMapUpsert(mutableGeometriesIndex, key, geometry) {
    var existing = mutableGeometriesIndex.get(key);
    var upsertGeometry = Array.isArray(geometry) ? geometry : [geometry];
    if (existing === undefined) {
        mutableGeometriesIndex.set(key, upsertGeometry);
    }
    else {
        mutableGeometriesIndex.set(key, __spread(upsertGeometry, existing));
    }
}
exports.mutableIndexedGeometryMapUpsert = mutableIndexedGeometryMapUpsert;
function renderPoints(shift, dataset, xScale, yScale, color, specId, hasY0Accessors, seriesKey) {
    var indexedGeometries = new Map();
    var isLogScale = scale_continuous_1.isLogarithmicScale(yScale);
    var pointGeometries = dataset.reduce(function (acc, datum) {
        var x = xScale.scale(datum.x);
        var points = [];
        var yDatums = [datum.y1];
        if (hasY0Accessors) {
            yDatums.unshift(datum.y0);
        }
        yDatums.forEach(function (yDatum, index) {
            // skip rendering point if y1 is null
            if (datum.y1 === null) {
                return;
            }
            var y;
            var radius = 10;
            var isHidden = yDatum === null || (isLogScale && yDatum <= 0);
            // we fix 0 and negative values at y = 0
            if (isHidden) {
                y = yScale.range[0];
                radius = 0;
            }
            else {
                y = yScale.scale(yDatum);
            }
            var originalY = hasY0Accessors && index === 0 ? datum.initialY0 : datum.initialY1;
            var pointGeometry = {
                radius: radius,
                x: x,
                y: y,
                color: color,
                value: {
                    x: datum.x,
                    y: originalY,
                    accessor: hasY0Accessors && index === 0 ? 'y0' : 'y1',
                },
                transform: {
                    x: shift,
                    y: 0,
                },
                geometryId: {
                    specId: specId,
                    seriesKey: seriesKey,
                },
            };
            mutableIndexedGeometryMapUpsert(indexedGeometries, datum.x, pointGeometry);
            if (!isHidden) {
                points.push(pointGeometry);
            }
        });
        return __spread(acc, points);
    }, []);
    return {
        pointGeometries: pointGeometries,
        indexedGeometries: indexedGeometries,
    };
}
exports.renderPoints = renderPoints;
function renderBars(orderIndex, dataset, xScale, yScale, color, specId, seriesKey, displayValueSettings, seriesStyle) {
    var indexedGeometries = new Map();
    var xDomain = xScale.domain;
    var xScaleType = xScale.type;
    var barGeometries = [];
    var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
    var fontSize = seriesStyle && seriesStyle.displayValue ? seriesStyle.displayValue.fontSize : undefined;
    var fontFamily = seriesStyle && seriesStyle.displayValue ? seriesStyle.displayValue.fontFamily : undefined;
    dataset.forEach(function (datum) {
        var y0 = datum.y0, y1 = datum.y1, initialY1 = datum.initialY1;
        // don't create a bar if the initialY1 value is null.
        if (initialY1 === null) {
            return;
        }
        // don't create a bar if the x value is not part of the ordinal scale
        if (xScaleType === "ordinal" /* Ordinal */ && !xDomain.includes(datum.x)) {
            return;
        }
        var height = 0;
        var y = 0;
        if (yScale.type === "log" /* Log */) {
            y = y1 === 0 ? yScale.range[0] : yScale.scale(y1);
            var y0Scaled = void 0;
            if (yScale.isInverted) {
                y0Scaled = y0 === 0 ? yScale.range[1] : yScale.scale(y0);
            }
            else {
                y0Scaled = y0 === 0 ? yScale.range[0] : yScale.scale(y0);
            }
            height = y0Scaled - y;
        }
        else {
            y = yScale.scale(y1);
            height = yScale.scale(y0) - y;
        }
        var x = xScale.scale(datum.x) + xScale.bandwidth * orderIndex;
        var width = xScale.bandwidth;
        var formattedDisplayValue = displayValueSettings && displayValueSettings.valueFormatter
            ? displayValueSettings.valueFormatter(initialY1)
            : undefined;
        // only show displayValue for even bars if showOverlappingValue
        var displayValueText = displayValueSettings && displayValueSettings.isAlternatingValueLabel
            ? barGeometries.length % 2 === 0
                ? formattedDisplayValue
                : undefined
            : formattedDisplayValue;
        var computedDisplayValueWidth = bboxCalculator.compute(displayValueText || '', fontSize, fontFamily).getOrElse({
            width: 0,
            height: 0,
        }).width;
        var displayValueWidth = displayValueSettings && displayValueSettings.isValueContainedInElement ? width : computedDisplayValueWidth;
        var hideClippedValue = displayValueSettings ? displayValueSettings.hideClippedValue : undefined;
        var displayValue = displayValueSettings && displayValueSettings.showValueLabel
            ? {
                text: displayValueText,
                width: displayValueWidth,
                height: fontSize || 0,
                hideClippedValue: hideClippedValue,
                isValueContainedInElement: displayValueSettings.isValueContainedInElement,
            }
            : undefined;
        var barGeometry = {
            displayValue: displayValue,
            x: x,
            y: y,
            width: width,
            height: height,
            color: color,
            value: {
                x: datum.x,
                y: initialY1,
                accessor: 'y1',
            },
            geometryId: {
                specId: specId,
                seriesKey: seriesKey,
            },
            seriesStyle: seriesStyle,
        };
        mutableIndexedGeometryMapUpsert(indexedGeometries, datum.x, barGeometry);
        barGeometries.push(barGeometry);
    });
    bboxCalculator.destroy();
    return {
        barGeometries: barGeometries,
        indexedGeometries: indexedGeometries,
    };
}
exports.renderBars = renderBars;
function renderLine(shift, dataset, xScale, yScale, color, curve, specId, hasY0Accessors, seriesKey, xScaleOffset, seriesStyle) {
    var isLogScale = scale_continuous_1.isLogarithmicScale(yScale);
    var pathGenerator = d3_shape_1.line()
        .x(function (datum) { return xScale.scale(datum.x) - xScaleOffset; })
        .y(function (datum) { return yScale.scale(datum.y1); })
        .defined(function (datum) { return datum.y1 !== null && !(isLogScale && datum.y1 <= 0); })
        .curve(curves_1.getCurveFactory(curve));
    var y = 0;
    var x = shift;
    var seriesPointStyle = seriesStyle ? seriesStyle.point : undefined;
    var seriesLineStyle = seriesStyle ? seriesStyle.line : undefined;
    var _a = renderPoints(shift - xScaleOffset, dataset, xScale, yScale, color, specId, hasY0Accessors, seriesKey), pointGeometries = _a.pointGeometries, indexedGeometries = _a.indexedGeometries;
    var lineGeometry = {
        line: pathGenerator(dataset) || '',
        points: pointGeometries,
        color: color,
        transform: {
            x: x,
            y: y,
        },
        geometryId: {
            specId: specId,
            seriesKey: seriesKey,
        },
        seriesLineStyle: seriesLineStyle,
        seriesPointStyle: seriesPointStyle,
    };
    return {
        lineGeometry: lineGeometry,
        indexedGeometries: indexedGeometries,
    };
}
exports.renderLine = renderLine;
function renderArea(shift, dataset, xScale, yScale, color, curve, specId, hasY0Accessors, seriesKey, xScaleOffset, seriesStyle) {
    var isLogScale = scale_continuous_1.isLogarithmicScale(yScale);
    var pathGenerator = d3_shape_1.area()
        .x(function (datum) { return xScale.scale(datum.x) - xScaleOffset; })
        .y1(function (datum) { return yScale.scale(datum.y1); })
        .y0(function (datum) {
        if (datum.y0 === null || (isLogScale && datum.y0 <= 0)) {
            return yScale.range[0];
        }
        return yScale.scale(datum.y0);
    })
        .defined(function (datum) { return datum.y1 !== null && !(isLogScale && datum.y1 <= 0); })
        .curve(curves_1.getCurveFactory(curve));
    var y1Line = pathGenerator.lineY1()(dataset);
    var lines = [];
    if (y1Line) {
        lines.push(y1Line);
    }
    if (hasY0Accessors) {
        var y0Line = pathGenerator.lineY0()(dataset);
        if (y0Line) {
            lines.push(y0Line);
        }
    }
    var seriesPointStyle = seriesStyle ? seriesStyle.point : undefined;
    var seriesAreaStyle = seriesStyle ? seriesStyle.area : undefined;
    var seriesAreaLineStyle = seriesStyle ? seriesStyle.line : undefined;
    var _a = renderPoints(shift - xScaleOffset, dataset, xScale, yScale, color, specId, hasY0Accessors, seriesKey), pointGeometries = _a.pointGeometries, indexedGeometries = _a.indexedGeometries;
    var areaGeometry = {
        area: pathGenerator(dataset) || '',
        lines: lines,
        points: pointGeometries,
        color: color,
        transform: {
            y: 0,
            x: shift,
        },
        geometryId: {
            specId: specId,
            seriesKey: seriesKey,
        },
        seriesAreaStyle: seriesAreaStyle,
        seriesAreaLineStyle: seriesAreaLineStyle,
        seriesPointStyle: seriesPointStyle,
    };
    return {
        areaGeometry: areaGeometry,
        indexedGeometries: indexedGeometries,
    };
}
exports.renderArea = renderArea;
function getGeometryStyle(geometryId, highlightedLegendItem, sharedThemeStyle, specOpacity, individualHighlight) {
    var sharedStyle = specOpacity == null
        ? sharedThemeStyle
        : __assign({}, sharedThemeStyle, { highlighted: { opacity: specOpacity }, default: { opacity: specOpacity } });
    if (highlightedLegendItem != null) {
        var isPartOfHighlightedSeries = series_utils_1.belongsToDataSeries(geometryId, highlightedLegendItem.value);
        return isPartOfHighlightedSeries ? sharedStyle.highlighted : sharedStyle.unhighlighted;
    }
    if (individualHighlight) {
        var hasHighlight = individualHighlight.hasHighlight, hasGeometryHover = individualHighlight.hasGeometryHover;
        if (!hasGeometryHover) {
            return sharedStyle.highlighted;
        }
        return hasHighlight ? sharedStyle.highlighted : sharedStyle.unhighlighted;
    }
    return sharedStyle.default;
}
exports.getGeometryStyle = getGeometryStyle;
function isPointOnGeometry(xCoordinate, yCoordinate, indexedGeometry) {
    var x = indexedGeometry.x, y = indexedGeometry.y;
    if (isPointGeometry(indexedGeometry)) {
        var radius = indexedGeometry.radius, transform = indexedGeometry.transform;
        return (yCoordinate >= y - radius &&
            yCoordinate <= y + radius &&
            xCoordinate >= x + transform.x - radius &&
            xCoordinate <= x + transform.x + radius);
    }
    var width = indexedGeometry.width, height = indexedGeometry.height;
    return yCoordinate >= y && yCoordinate <= y + height && xCoordinate >= x && xCoordinate <= x + width;
}
exports.isPointOnGeometry = isPointOnGeometry;
//# sourceMappingURL=rendering.js.map