/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg.test;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import java.io.File;
import java.io.FileInputStream;
import junit.framework.TestCase;

public class JpegSegmentReaderTest
extends TestCase {
    public JpegSegmentReaderTest(String s) {
        super(s);
    }

    public void testIsJpegWithJpegFile() throws Exception {
        File jpeg = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        try {
            new JpegSegmentReader(jpeg);
        }
        catch (JpegProcessingException e) {
            JpegSegmentReaderTest.fail((String)"Error creating JpegSegmentReader");
        }
    }

    public void testIsJpegWithNonJpegFile() throws Exception {
        File nonJpeg = new File("src/com/drew/metadata/test/AllTests.java");
        try {
            new JpegSegmentReader(nonJpeg);
            JpegSegmentReaderTest.fail((String)"shouldn't be able to construct JpegSegmentReader with non-jpeg file");
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
    }

    public void testReadApp1Segment() throws Exception {
        File jpeg = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        JpegSegmentReader segmentReader = new JpegSegmentReader(jpeg);
        byte[] exifData = segmentReader.readSegment((byte)-31);
        JpegSegmentReaderTest.assertTrue((String)"exif data too short", (exifData.length > 4 ? 1 : 0) != 0);
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(exifData, 0, 4));
    }

    public void testReadDQTSegment() throws Exception {
        File jpeg = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        JpegSegmentReader segmentReader = new JpegSegmentReader(jpeg);
        byte[] quantizationTableData = segmentReader.readSegment((byte)-37);
        JpegSegmentReaderTest.assertTrue((String)"shouldn't have zero length quantizationTableData", (quantizationTableData.length > 0 ? 1 : 0) != 0);
        JpegSegmentReaderTest.assertTrue((String)"quantizationTableData shouldn't start with 'Exif'", (!"Exif".equals(new String(quantizationTableData, 0, 4)) ? 1 : 0) != 0);
    }

    public void testReadJpegByteArray() throws Exception {
        File jpeg = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        byte[] fileContents = new byte[(int)jpeg.length()];
        new FileInputStream(jpeg).read(fileContents);
        new JpegSegmentReader(fileContents).readSegment((byte)-31);
    }

    public void testCreateWithInputStream() throws Exception {
        File jpeg = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        FileInputStream in = new FileInputStream(jpeg);
        JpegSegmentReader reader = null;
        try {
            reader = new JpegSegmentReader(in);
        }
        catch (JpegProcessingException e) {
            JpegSegmentReaderTest.fail((String)"Error constructing JpegSegmentReader using InputStream");
        }
        if (reader == null) {
            return;
        }
        byte[] exifData = reader.readSegment((byte)-31);
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(exifData, 0, 4));
    }

    public void testReadSecondSegmentInstanace() throws Exception {
        File jpeg = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader reader = new JpegSegmentReader(jpeg);
        byte[] exifData0 = reader.readSegment((byte)-31, 0);
        byte[] exifData1 = reader.readSegment((byte)-31, 1);
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(exifData0, 0, 4));
        JpegSegmentReaderTest.assertEquals((String)"http", (String)new String(exifData1, 0, 4));
    }

    public void testReadNonExistantSegmentInstance() throws Exception {
        File jpeg = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader reader = new JpegSegmentReader(jpeg);
        JpegSegmentReaderTest.assertNull((String)"third exif segment shouldn't exist", (Object)reader.readSegment((byte)-31, 3));
    }

    public void testGetSegmentCount() throws Exception {
        File jpeg = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader reader = new JpegSegmentReader(jpeg);
        JpegSegmentReaderTest.assertEquals((int)2, (int)reader.getSegmentCount((byte)-31));
        JpegSegmentReaderTest.assertEquals((int)1, (int)reader.getSegmentCount((byte)-30));
        JpegSegmentReaderTest.assertEquals((int)0, (int)reader.getSegmentCount((byte)-29));
    }

    public void testCreateWithFileAndReadMultipleSegments() throws Exception {
        File jpeg = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader reader = new JpegSegmentReader(jpeg);
        this.validateMultipleSegmentRead(reader);
    }

    public void testCreateWithInputStreamAndReadMultipleSegments() throws Exception {
        File jpeg = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        FileInputStream in = new FileInputStream(jpeg);
        JpegSegmentReader reader = new JpegSegmentReader(in);
        this.validateMultipleSegmentRead(reader);
    }

    private void validateMultipleSegmentRead(JpegSegmentReader reader) throws JpegProcessingException {
        byte[] iptcData = reader.readSegment((byte)-19);
        byte[] exifData = reader.readSegment((byte)-31);
        JpegSegmentReaderTest.assertTrue((String)"exif data too short", (exifData.length > 4 ? 1 : 0) != 0);
        new ExifReader(exifData).extract();
        new IptcReader(iptcData).extract();
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(exifData, 0, 4));
    }
}

