/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "matrix.h"
/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: tr_pose_mat.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ matrix_TYP *tr_pose(mat)
@ matrix_TYP *mat;
@
@ calculates the tansposed of mat.
@---------------------------------------------------------------------------
@
\**************************************************************************/

/*{{{}}}*/
/*{{{  tr_pose*/
matrix_TYP *tr_pose(mat)
matrix_TYP *mat;
{
int i,j;
matrix_TYP *cmat;
int  **cZ, **cN, **Z, **N;

  if (mat->array.N != NULL ) {
    cmat = init_mat(mat->cols,mat->rows,"r");
    N  =  mat->array.N;
    cN = cmat->array.N;
  } else{
    cmat = init_mat(mat->cols,mat->rows,"");
  }
  Z  =  mat->array.SZ;
  cZ = cmat->array.SZ;

  cmat->flags = mat->flags;

  cmat->kgv= mat->kgv;
  cmat->prime = mat->prime;

  for(i = 0; i < cmat->rows; i++) {
    for(j = 0; j < cmat->cols; j++) {
      cZ[i][j] = Z[j][i];
    }
  }
  if( cmat->array.N != NULL) {
    for(i = 0; i < cmat->rows; i++) {
      for(j = 0; j < cmat->cols; j++) {
        cN[i][j] = N[j][i];
      }
    }
  }
  return cmat;
}

/*}}}  */

