/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.interpreters;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.debug.ui.interpreters.Messages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.osgi.util.NLS;

public class EnvironmentVariablesFileUtils {
    public static void save(EnvironmentVariable[] variables, String file) throws Exception {
        Writer writer = null;
        try {
            try {
                writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(new File(file)), 4096));
                int i = 0;
                while (i < variables.length) {
                    writer.write(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue() + "\n");
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                throw new Exception(e.getMessage());
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                throw new Exception(e.getMessage());
            }
        }
        finally {
            block15: {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static EnvironmentVariable[] load(String file) throws Exception {
        BufferedReader reader = null;
        ArrayList<EnvironmentVariable> results = new ArrayList<EnvironmentVariable>();
        try {
            String line;
            reader = new LineNumberReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(new File(file)))));
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                if (line.length() <= 0) continue;
                int pos = line.indexOf(61);
                if (pos == -1) {
                    String template = Messages.EnvironmentVariablesFileUtils_incorrectFormat;
                    throw new Exception(NLS.bind((String)template, (Object)Integer.toString(((LineNumberReader)reader).getLineNumber())));
                }
                String varName = line.substring(0, pos).trim();
                if (varName.length() == 0) {
                    String template = Messages.EnvironmentVariablesFileUtils_incorrectFormat;
                    throw new Exception(NLS.bind((String)template, (Object)Integer.toString(((LineNumberReader)reader).getLineNumber())));
                }
                String value = line.substring(pos + 1).trim();
                results.add(new EnvironmentVariable(varName, value));
            }
            if (results.size() > 0) {
                EnvironmentVariable[] environmentVariableArray = results.toArray(new EnvironmentVariable[results.size()]);
                return environmentVariableArray;
            }
        }
        catch (FileNotFoundException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new Exception(e.getMessage());
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new Exception("IOError:" + e.getMessage());
        }
        finally {
            block20: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block20;
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }
}

