/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectNetworkProfiles
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.project.settings.networkProfiles";
    private static final Log log = Log.getLog(PrefPageProjectNetworkProfiles.class);
    private IProject project;
    private DBPProject projectMeta;
    private Table profilesTable;
    private TabFolder handlersFolder;
    private List<NetworkHandlerDescriptor> allHandlers = new ArrayList<NetworkHandlerDescriptor>();
    private DBWNetworkProfile selectedProfile;
    private Map<NetworkHandlerDescriptor, HandlerBlock> configurations = new HashMap<NetworkHandlerDescriptor, HandlerBlock>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        CustomSashForm divider = UIUtils.createPartDivider(null, (Composite)parent, (int)256);
        Composite profilesGroup = new Composite((Composite)divider, 2048);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        profilesGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        profilesGroup.setLayoutData((Object)gd);
        this.profilesTable = new Table(profilesGroup, 4);
        gd = new GridData(1808);
        gd.minimumWidth = 150;
        this.profilesTable.setLayoutData((Object)gd);
        this.profilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectNetworkProfiles.this.saveHandlerSettings();
                Object[] selection = PrefPageProjectNetworkProfiles.this.profilesTable.getSelection();
                if (ArrayUtils.isEmpty((Object[])selection)) {
                    PrefPageProjectNetworkProfiles.this.selectedProfile = null;
                } else {
                    PrefPageProjectNetworkProfiles.this.selectedProfile = (DBWNetworkProfile)selection[0].getData();
                }
                PrefPageProjectNetworkProfiles.this.updateControlsState();
            }
        });
        ToolBar toolbar = new ToolBar(profilesGroup, 256);
        ToolItem createItem = new ToolItem(toolbar, 0);
        createItem.setToolTipText("Create new profile");
        createItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD));
        createItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String profileName = "";
                while (true) {
                    if (CommonUtils.isEmptyTrimmed((String)(profileName = EnterNameDialog.chooseName((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)"Profile name", (String)profileName)))) {
                        return;
                    }
                    if (PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().getNetworkProfile(profileName) == null) break;
                    UIUtils.showMessageBox((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)"Wrong profile name", (String)("Profile '" + profileName + "' already exist in project '" + PrefPageProjectNetworkProfiles.this.projectMeta.getName() + "'"), (int)1);
                }
                DBWNetworkProfile newProfile = new DBWNetworkProfile();
                newProfile.setProfileName(profileName);
                PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().updateNetworkProfile(newProfile);
                PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().flushConfig();
                TableItem item = new TableItem(PrefPageProjectNetworkProfiles.this.profilesTable, 0);
                item.setText(newProfile.getProfileName());
                item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_DOCUMENT));
                item.setData((Object)newProfile);
                if (PrefPageProjectNetworkProfiles.this.profilesTable.getItemCount() == 1) {
                    PrefPageProjectNetworkProfiles.this.selectedProfile = newProfile;
                    PrefPageProjectNetworkProfiles.this.profilesTable.select(0);
                    PrefPageProjectNetworkProfiles.this.updateControlsState();
                }
            }
        });
        ToolItem deleteItem = new ToolItem(toolbar, 0);
        deleteItem.setToolTipText("Delete profile");
        deleteItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE));
        deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageProjectNetworkProfiles.this.selectedProfile != null) {
                    List usedBy = PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().getDataSourcesByProfile(PrefPageProjectNetworkProfiles.this.selectedProfile);
                    if (!usedBy.isEmpty()) {
                        UIUtils.showMessageBox((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)"Can't delete profile", (String)("Configuration profile '" + PrefPageProjectNetworkProfiles.this.selectedProfile.getProfileName() + "' used by " + usedBy.size() + " connections:\n" + usedBy), (int)1);
                        return;
                    }
                    if (!UIUtils.confirmAction((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)"Delete profile", (String)("Are you sure you want to delete configuration profile '" + PrefPageProjectNetworkProfiles.this.selectedProfile.getProfileName() + "'?"))) {
                        return;
                    }
                    PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().removeNetworkProfile(PrefPageProjectNetworkProfiles.this.selectedProfile);
                    PrefPageProjectNetworkProfiles.this.projectMeta.getDataSourceRegistry().flushConfig();
                    PrefPageProjectNetworkProfiles.this.profilesTable.remove(PrefPageProjectNetworkProfiles.this.profilesTable.getSelectionIndex());
                    PrefPageProjectNetworkProfiles.this.selectedProfile = null;
                    PrefPageProjectNetworkProfiles.this.updateControlsState();
                } else {
                    UIUtils.showMessageBox((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)"No profile", (String)"Select profile first", (int)1);
                }
            }
        });
        this.handlersFolder = new TabFolder((Composite)divider, 0x800080);
        this.handlersFolder.setLayoutData((Object)new GridData(1808));
        for (NetworkHandlerDescriptor nhd : NetworkHandlerRegistry.getInstance().getDescriptors()) {
            if (nhd.hasObjectTypes()) continue;
            this.createHandlerTab(nhd);
        }
        this.handlersFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectNetworkProfiles.this.updateControlsState();
            }
        });
        divider.setWeights(new int[]{300, 700});
        this.performDefaults();
        return divider;
    }

    private void saveHandlerSettings() {
        if (this.selectedProfile == null) {
            return;
        }
        TabItem[] tabItemArray = this.handlersFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem handlerTab = tabItemArray[n2];
            NetworkHandlerDescriptor handler = (NetworkHandlerDescriptor)handlerTab.getData();
            HandlerBlock handlerBlock = this.configurations.get(handler);
            DBWHandlerConfiguration handlerConfiguration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(this.selectedProfile);
            if (handlerBlock.useHandlerCheck.getSelection()) {
                if (handlerConfiguration == null) {
                    handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)handler, null);
                }
                handlerBlock.configurator.saveSettings((Object)handlerConfiguration);
            }
            ++n2;
        }
    }

    private void updateControlsState() {
        NetworkHandlerDescriptor descriptor = this.getSelectedHandler();
        this.enableHandlerContent(descriptor);
        if (descriptor != null) {
            HandlerBlock handlerBlock = this.configurations.get(descriptor);
            DBWHandlerConfiguration handlerConfiguration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(this.selectedProfile);
            if (handlerConfiguration == null) {
                handlerBlock.configurator.loadSettings((Object)new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, null));
            } else {
                handlerBlock.configurator.loadSettings((Object)handlerConfiguration);
            }
        }
    }

    @Nullable
    private NetworkHandlerDescriptor getSelectedHandler() {
        Object[] selection = this.handlersFolder.getSelection();
        return ArrayUtils.isEmpty((Object[])selection) ? null : (NetworkHandlerDescriptor)selection[0].getData();
    }

    private void createHandlerTab(final NetworkHandlerDescriptor descriptor) {
        IObjectPropertyConfigurator configurator;
        try {
            String implName = descriptor.getHandlerType().getImplName();
            UIPropertyConfiguratorDescriptor configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(implName);
            if (configDescriptor == null) {
                return;
            }
            configurator = configDescriptor.createConfigurator();
        }
        catch (DBException e) {
            log.error((Object)("Can't create network configurator '" + descriptor.getId() + "'"), (Throwable)e);
            return;
        }
        this.allHandlers.add(descriptor);
        TabItem tabItem = new TabItem(this.handlersFolder, 0);
        tabItem.setText(descriptor.getLabel());
        tabItem.setToolTipText(descriptor.getDescription());
        tabItem.setData((Object)descriptor);
        Composite composite = new Composite((Composite)this.handlersFolder, 0);
        tabItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        final Button useHandlerCheck = UIUtils.createCheckbox((Composite)composite, (String)NLS.bind((String)CoreMessages.dialog_tunnel_checkbox_use_handler, (Object)descriptor.getLabel()), (boolean)false);
        useHandlerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageProjectNetworkProfiles.this.selectedProfile == null) {
                    useHandlerCheck.setSelection(false);
                    UIUtils.showMessageBox((Shell)PrefPageProjectNetworkProfiles.this.getShell(), (String)"No profile", (String)"Select existing profile or create a new one", (int)2);
                    return;
                }
                HandlerBlock handlerBlock = (HandlerBlock)PrefPageProjectNetworkProfiles.this.configurations.get(descriptor);
                DBWHandlerConfiguration handlerConfiguration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(PrefPageProjectNetworkProfiles.this.selectedProfile);
                if (handlerConfiguration == null) {
                    handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, null);
                    handlerBlock.loadedConfigs.put(PrefPageProjectNetworkProfiles.this.selectedProfile, handlerConfiguration);
                }
                handlerConfiguration.setEnabled(useHandlerCheck.getSelection());
                PrefPageProjectNetworkProfiles.this.enableHandlerContent(descriptor);
            }
        });
        Composite handlerComposite = UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.configurations.put(descriptor, new HandlerBlock(configurator, handlerComposite, useHandlerCheck));
        handlerComposite.setLayoutData((Object)new GridData(1808));
        configurator.createControl(handlerComposite);
        this.enableHandlerContent(descriptor);
    }

    private void enableHandlerContent(NetworkHandlerDescriptor descriptor) {
        HandlerBlock handlerBlock = this.configurations.get(descriptor);
        DBWHandlerConfiguration handlerConfiguration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(this.selectedProfile);
        handlerBlock.useHandlerCheck.setSelection(handlerConfiguration != null && handlerConfiguration.isEnabled());
        if (handlerConfiguration != null && handlerConfiguration.isEnabled()) {
            if (handlerBlock.blockEnableState != null) {
                handlerBlock.blockEnableState.restore();
                handlerBlock.blockEnableState = null;
            }
        } else if (handlerBlock.blockEnableState == null) {
            handlerBlock.blockEnableState = ControlEnableState.disable((Control)handlerBlock.blockControl);
        }
    }

    public void saveSettings(DBWNetworkProfile profile) {
        for (HandlerBlock handlerBlock : this.configurations.values()) {
            DBWHandlerConfiguration configuration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(profile);
            if (configuration == null) continue;
            profile.updateConfiguration(configuration);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.profilesTable.removeAll();
        if (this.projectMeta != null) {
            for (DBWNetworkProfile profile : this.projectMeta.getDataSourceRegistry().getNetworkProfiles()) {
                TableItem item = new TableItem(this.profilesTable, 0);
                item.setText(profile.getProfileName());
                item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_DOCUMENT));
                item.setData((Object)profile);
                if (this.selectedProfile == null) {
                    this.selectedProfile = profile;
                    this.profilesTable.select(0);
                }
                for (NetworkHandlerDescriptor nhd : this.allHandlers) {
                    HandlerBlock handlerBlock = this.configurations.get(nhd);
                    DBWHandlerConfiguration configuration = profile.getConfiguration((DBWHandlerDescriptor)nhd);
                    if (configuration == null) continue;
                    handlerBlock.loadedConfigs.put(profile, configuration);
                }
            }
        }
        this.updateControlsState();
    }

    public boolean performOk() {
        this.saveHandlerSettings();
        TableItem[] tableItemArray = this.profilesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DBWNetworkProfile profile = (DBWNetworkProfile)item.getData();
            this.saveSettings(profile);
            this.projectMeta.getDataSourceRegistry().updateNetworkProfile(profile);
            ++n2;
        }
        this.projectMeta.getDataSourceRegistry().flushConfig();
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)GeneralUtils.adapt((Object)element, IProject.class);
        this.projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(this.project);
    }

    private static class HandlerBlock {
        private final IObjectPropertyConfigurator<DBWHandlerConfiguration> configurator;
        private final Composite blockControl;
        private final Button useHandlerCheck;
        private ControlEnableState blockEnableState;
        private final Map<DBWNetworkProfile, DBWHandlerConfiguration> loadedConfigs = new HashMap<DBWNetworkProfile, DBWHandlerConfiguration>();

        private HandlerBlock(IObjectPropertyConfigurator<DBWHandlerConfiguration> configurator, Composite blockControl, Button useHandlerCheck) {
            this.configurator = configurator;
            this.blockControl = blockControl;
            this.useHandlerCheck = useHandlerCheck;
        }
    }
}

