/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.configurators;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTriggerManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;

public class OracleTableTriggerConfigurator
extends SQLTriggerManager<OracleTableTrigger, OracleTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTableTrigger> getObjectsCache(OracleTableTrigger object) {
        return object.getTable().triggerCache;
    }

    protected OracleTableTrigger createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        final OracleTableBase table = (OracleTableBase)container;
        return (OracleTableTrigger)new UITask<OracleTableTrigger>(){

            protected OracleTableTrigger runTask() {
                EntityEditPage editPage = new EntityEditPage(table.getDataSource(), DBSEntityType.TRIGGER);
                if (!editPage.edit()) {
                    return null;
                }
                OracleTableTrigger newTrigger = new OracleTableTrigger(table, editPage.getEntityName());
                newTrigger.setObjectDefinitionText("TRIGGER " + editPage.getEntityName() + "\n" + "BEGIN\n" + "END;");
                return newTrigger;
            }
        }.execute();
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop trigger", "DROP TRIGGER " + ((OracleTableTrigger)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void createOrReplaceTriggerQuery(List<DBEPersistAction> actions, OracleTableTrigger trigger, boolean create) {
        String source = OracleUtils.normalizeSourceName((OracleSourceObject)trigger, (boolean)false);
        if (source == null) {
            return;
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", "CREATE OR REPLACE " + source, true));
        OracleUtils.addSchemaChangeActions(actions, (OracleSourceObject)trigger);
    }
}

