/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.configurators;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectValidateAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureStandalone;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;

public class OracleProcedureConfigurator
extends SQLObjectEditor<OracleProcedureStandalone, OracleSchema> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleProcedureStandalone> getObjectsCache(OracleProcedureStandalone object) {
        return object.getSchema().proceduresCache;
    }

    protected OracleProcedureStandalone createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        final OracleProcedureStandalone procedure = new OracleProcedureStandalone((OracleSchema)container, "PROC", DBSProcedureType.PROCEDURE);
        return (OracleProcedureStandalone)new UITask<OracleProcedureStandalone>(){

            protected OracleProcedureStandalone runTask() {
                CreateProcedurePage editPage = new CreateProcedurePage((DBSProcedure)procedure);
                if (!editPage.edit()) {
                    return null;
                }
                procedure.setName(editPage.getProcedureName());
                procedure.setProcedureType(editPage.getProcedureType());
                return procedure;
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectCreateCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (OracleProcedureStandalone)objectCreateCommand.getObject());
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand objectDeleteCommand, Map<String, Object> options) {
        OracleProcedureStandalone object = (OracleProcedureStandalone)objectDeleteCommand.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop procedure", "DROP " + object.getProcedureType().name() + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand objectChangeCommand, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actionList, (OracleProcedureStandalone)objectChangeCommand.getObject());
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actionList, OracleProcedureStandalone procedure) {
        String source = OracleUtils.normalizeSourceName((OracleSourceObject)procedure, (boolean)false);
        if (source == null) {
            return;
        }
        actionList.add((DBEPersistAction)new OracleObjectValidateAction((OracleSourceObject)procedure, OracleObjectType.PROCEDURE, "Create procedure", source));
        OracleUtils.addSchemaChangeActions(actionList, (OracleSourceObject)procedure);
    }
}

