/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePartition;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class PostgrePartitionManager
extends PostgreTableManager {
    private static final Log log = Log.getLog(PostgrePartitionManager.class);
    private static final Class<?>[] CHILD_TYPES_PART = new Class[]{PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreIndex.class};

    @Override
    protected PostgreTablePartition createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        PostgreTable owner = (PostgreTable)container;
        PostgreTablePartition table = new PostgreTablePartition(owner);
        return table;
    }

    private String getParentTable(PostgreTablePartition partition) {
        List<PostgreTableBase> superTables;
        try {
            superTables = partition.getSuperTables((DBRProgressMonitor)new VoidProgressMonitor());
        }
        catch (DBException e) {
            log.error((Object)"Unable to get parent", (Throwable)e);
            return "";
        }
        if (superTables == null && partition.getPartitionOf() != null) {
            return String.valueOf(partition.getPartitionOf().getSchema().getName()) + "." + partition.getPartitionOf().getName();
        }
        if (superTables == null || superTables.size() > 1) {
            log.error((Object)"Unable to get parent");
            return "";
        }
        return String.valueOf(superTables.get(0).getSchema().getName()) + "." + superTables.get(0).getName();
    }

    protected String beginCreateTableStatement(PostgreTableBase table, String tableName) {
        return "CREATE " + this.getCreateTableType(table) + " " + tableName + " PARTITION OF " + this.getParentTable((PostgreTablePartition)table) + " ";
    }

    protected boolean hasAttrDeclarations() {
        return false;
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        return !(command.getObject() instanceof PostgreTableConstraint);
    }

    public boolean canEditObject(PostgreTableBase object) {
        return object instanceof PostgreTablePartition;
    }

    public boolean canCreateObject(Object container) {
        return container instanceof PostgreTable;
    }

    public boolean canDeleteObject(PostgreTableBase object) {
        return true;
    }

    @Override
    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES_PART;
    }
}

