/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GreenplumTable
extends PostgreTable {
    private static final Log log = Log.getLog(GreenplumTable.class);
    private int[] distributionColumns;
    private boolean unloggedTable = false;
    private boolean supportsReplicatedDistribution = false;

    public GreenplumTable(PostgreSchema catalog) {
        super((PostgreTableContainer)catalog);
    }

    public GreenplumTable(PostgreSchema catalog, ResultSet dbResult) {
        super((PostgreTableContainer)catalog, dbResult);
        if (catalog.getDataSource().isServerVersionAtLeast(9, 1)) {
            this.supportsReplicatedDistribution = true;
            if ("u".equalsIgnoreCase(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relpersistence"))) {
                this.unloggedTable = true;
            }
        }
    }

    public boolean isUnloggedTable() {
        return this.unloggedTable;
    }

    private List<PostgreTableColumn> getDistributionPolicy(DBRProgressMonitor monitor) throws DBException {
        if (this.distributionColumns == null) {
            try {
                this.distributionColumns = this.readDistributedColumns(monitor);
            }
            catch (Throwable e) {
                log.error((Object)"Error reading distribution policy", e);
            }
            if (this.distributionColumns == null) {
                this.distributionColumns = new int[0];
            }
        }
        if (this.distributionColumns.length == 0) {
            return null;
        }
        ArrayList<PostgreTableColumn> columns = new ArrayList<PostgreTableColumn>(this.distributionColumns.length);
        int i = 0;
        while (i < this.distributionColumns.length) {
            PostgreTableColumn attr = this.getAttributeByPos(monitor, this.distributionColumns[i]);
            if (attr == null) {
                log.debug((Object)("Bad policy attribute position: " + this.distributionColumns[i]));
            } else {
                columns.add(attr);
            }
            ++i;
        }
        return columns;
    }

    private List<PostgreTableColumn> getDistributionTableColumns(DBRProgressMonitor monitor, List<PostgreTableColumn> distributionColumns) throws DBException {
        List pkAttrs;
        PostgreTableConstraint pk = null;
        for (PostgreTableConstraint tc : this.getConstraints(monitor)) {
            if (tc.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) continue;
            pk = tc;
            break;
        }
        if (pk != null && !CommonUtils.isEmpty((Collection)(pkAttrs = DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, pk)))) {
            distributionColumns = new ArrayList<PostgreTableColumn>(pkAttrs.size());
            for (DBSEntityAttribute attr : pkAttrs) {
                distributionColumns.add((PostgreTableColumn)attr);
            }
        }
        return distributionColumns;
    }

    @Nullable
    private int[] readDistributedColumns(DBRProgressMonitor monitor) throws DBCException {
        JDBCResultSet dbResult;
        JDBCStatement dbStat;
        JDBCSession session;
        block39: {
            int[] nArray;
            block40: {
                Throwable throwable = null;
                Object var3_5 = null;
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read Greenplum table distributed columns");
                Throwable throwable2 = null;
                Object var6_10 = null;
                dbStat = session.createStatement();
                Throwable throwable3 = null;
                Object var9_15 = null;
                dbResult = dbStat.executeQuery("SELECT attrnums FROM pg_catalog.gp_distribution_policy WHERE localoid=" + this.getObjectId());
                try {
                    if (!dbResult.next()) break block39;
                    nArray = PostgreUtils.getIntVector((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (int)1));
                    if (dbResult == null) break block40;
                }
                catch (Throwable throwable4) {
                    try {
                        if (dbResult != null) {
                            dbResult.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable6) {
                            try {
                                if (dbStat != null) {
                                    dbStat.close();
                                }
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                try {
                                    if (throwable2 == null) {
                                        throwable2 = throwable7;
                                    } else if (throwable2 != throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable8) {
                                    try {
                                        if (session != null) {
                                            session.close();
                                        }
                                        throw throwable8;
                                    }
                                    catch (Throwable throwable9) {
                                        try {
                                            if (throwable == null) {
                                                throwable = throwable9;
                                            } else if (throwable != throwable9) {
                                                throwable.addSuppressed(throwable9);
                                            }
                                            throw throwable;
                                        }
                                        catch (SQLException e) {
                                            throw new DBCException(e, this.getDataSource());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                dbResult.close();
            }
            if (dbStat != null) {
                dbStat.close();
            }
            if (session != null) {
                session.close();
            }
            return nArray;
        }
        if (dbResult != null) {
            dbResult.close();
        }
        if (dbStat != null) {
            dbStat.close();
        }
        if (session != null) {
            session.close();
        }
        return null;
    }

    private boolean isDistributedByReplicated(DBRProgressMonitor monitor) throws DBCException {
        JDBCResultSet dbResult;
        JDBCStatement dbStat;
        JDBCSession session;
        block39: {
            boolean bl;
            block40: {
                Throwable throwable = null;
                Object var3_5 = null;
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read Greenplum table distributed columns");
                Throwable throwable2 = null;
                Object var6_10 = null;
                dbStat = session.createStatement();
                Throwable throwable3 = null;
                Object var9_15 = null;
                dbResult = dbStat.executeQuery("SELECT policytype FROM pg_catalog.gp_distribution_policy WHERE localoid=" + this.getObjectId());
                try {
                    if (!dbResult.next()) break block39;
                    bl = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1).equals("r");
                    if (dbResult == null) break block40;
                }
                catch (Throwable throwable4) {
                    try {
                        if (dbResult != null) {
                            dbResult.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable6) {
                            try {
                                if (dbStat != null) {
                                    dbStat.close();
                                }
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                try {
                                    if (throwable2 == null) {
                                        throwable2 = throwable7;
                                    } else if (throwable2 != throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable8) {
                                    try {
                                        if (session != null) {
                                            session.close();
                                        }
                                        throw throwable8;
                                    }
                                    catch (Throwable throwable9) {
                                        try {
                                            if (throwable == null) {
                                                throwable = throwable9;
                                            } else if (throwable != throwable9) {
                                                throwable.addSuppressed(throwable9);
                                            }
                                            throw throwable;
                                        }
                                        catch (SQLException e) {
                                            throw new DBCException(e, this.getDataSource());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                dbResult.close();
            }
            if (dbStat != null) {
                dbStat.close();
            }
            if (session != null) {
                session.close();
            }
            return bl;
        }
        if (dbResult != null) {
            dbResult.close();
        }
        if (dbStat != null) {
            dbStat.close();
        }
        if (session != null) {
            session.close();
        }
        return false;
    }

    public void appendTableModifiers(DBRProgressMonitor monitor, StringBuilder ddl) {
        try {
            List<PostgreTableColumn> distributionColumns = this.getDistributionPolicy(monitor);
            if (CommonUtils.isEmpty(distributionColumns)) {
                distributionColumns = this.getDistributionTableColumns(monitor, distributionColumns);
            }
            ddl.append("\nDISTRIBUTED ");
            if (CommonUtils.isEmpty(distributionColumns)) {
                ddl.append(this.supportsReplicatedDistribution && this.isDistributedByReplicated(monitor) ? "REPLICATED" : "RANDOMLY");
            } else {
                ddl.append("BY (");
                int i = 0;
                while (i < distributionColumns.size()) {
                    if (i > 0) {
                        ddl.append(", ");
                    }
                    ddl.append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)distributionColumns.get(i))));
                    ++i;
                }
                ddl.append(")");
            }
        }
        catch (DBException e) {
            log.error((Object)"Error reading Greenplum table properties", (Throwable)e);
        }
    }

    public String addUnloggedClause(String tableddl) {
        return tableddl.replaceFirst("CREATE", "CREATE UNLOGGED");
    }
}

