/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.lock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.lock.OracleLock;
import org.jkiss.dbeaver.ext.oracle.model.lock.OracleLockItem;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLockManager;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraphManager;

public class OracleLockManager
extends LockGraphManager
implements DBAServerLockManager<OracleLock, OracleLockItem> {
    public static final String sidHold = "hsid";
    public static final String sidWait = "wsid";
    private static final String LOCK_QUERY = "select wsession.sid waiting_session, wsession.serial# serial, wsession.logon_time, wsession.blocking_session_status, wsession.event, wsession.username waiting_user, wprocess.pid wait_pid, nvl(obj.object_name,'-') oname, nvl(obj.owner,'-') owner, wsession.row_wait_block# row_lock, wsession.blocking_session holding_session, hprocess.pid hold_pid, hsession.username holding_user   from v$session wsession join v$session hsession on wsession.blocking_session = hsession.sid join v$process  wprocess on wprocess.addr = wsession.paddr join v$process  hprocess on hprocess.addr = hsession.paddr left join dba_objects obj on obj.object_id = wsession.row_wait_obj# where  wsession.blocking_session is not NULL union    select wsession.sid waiting_session, wsession.serial# serial, wsession.logon_time, wsession.blocking_session_status, wsession.event, wsession.username waiting_user, wprocess.pid wait_pid, nvl(obj.object_name,'-') oname, nvl(obj.owner,'-') owner, wsession.row_wait_block# row_lock, nvl(wsession.blocking_session,0) holding_session, nvl(hprocess.pid,0) hold_pid, nvl(hsession.username,'-') holding_user   from v$session wsession left join v$session hsession on wsession.blocking_session = hsession.sid join v$process  wprocess on wprocess.addr = wsession.paddr left join v$process  hprocess on hprocess.addr = hsession.paddr left join dba_objects obj on obj.object_id = wsession.row_wait_obj# where  wsession.sid IN (SELECT blocking_session FROM v$session)";
    public static final String LOCK_ITEM_QUERY = "select lock_type,mode_held,mode_requested,lock_id1,lock_id2,last_convert,blocking_others from dba_lock where session_id = ?";
    private final OracleDataSource dataSource;

    public OracleLockManager(OracleDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public Map<Object, OracleLock> getLocks(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            HashMap<Object, OracleLock> locks = new HashMap<Object, OracleLock>(10);
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(LOCK_QUERY);){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        OracleLock l = new OracleLock((ResultSet)dbResult);
                        locks.put(l.getId(), l);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            super.buildGraphs(locks);
            return locks;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(DBCSession session, OracleLock lock, Map<String, Object> options) throws DBException {
        try {
            String sql = "ALTER SYSTEM KILL SESSION '" + lock.getWait_sid() + ',' + lock.getSerial() + "'" + " IMMEDIATE";
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(sql);){
                dbStat.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }

    public Class<OracleLock> getLocksType() {
        return OracleLock.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<OracleLockItem> getLockItems(DBCSession session, Map<String, Object> options) throws DBException {
        try {
            ArrayList<OracleLockItem> locks = new ArrayList<OracleLockItem>();
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(LOCK_ITEM_QUERY);
                try {
                    String otype;
                    switch (otype = (String)options.get("type")) {
                        case "wait": {
                            dbStat.setInt(1, ((Integer)options.get(sidWait)).intValue());
                            break;
                        }
                        case "hold": {
                            dbStat.setInt(1, ((Integer)options.get(sidHold)).intValue());
                            break;
                        }
                        default: {
                            return locks;
                        }
                    }
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (true) {
                            if (!dbResult.next()) {
                                return locks;
                            }
                            locks.add(new OracleLockItem((ResultSet)dbResult));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
                finally {
                    if (dbStat == null) return locks;
                    dbStat.close();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, session.getDataSource());
        }
    }
}

