/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.sql.SQLException;
import java.sql.Struct;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.data.OracleObjectValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStructValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleObjectValueHandler
extends JDBCStructValueHandler {
    public static final OracleObjectValueHandler INSTANCE = new OracleObjectValueHandler();

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value != null) {
            return "[OBJECT]";
        }
        return super.getValueDisplayString(column, value, format);
    }

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object object = resultSet.getObject(index);
        return this.getValueFromObject(session, type, object, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        throw new DBCException("Parameter bind is not implemented");
    }

    @NotNull
    public Class<Object> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return new OracleObjectValue(null);
        }
        if (object instanceof Struct) {
            return super.getValueFromObject(session, type, object, copy);
        }
        if (object instanceof OracleObjectValue) {
            return copy ? new OracleObjectValue(((OracleObjectValue)object).getValue()) : (OracleObjectValue)object;
        }
        return new OracleObjectValue(object);
    }
}

