/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.utils.ArrayUtils;

public class MultiPageWizardDialog
extends TitleAreaDialog
implements IWizardContainer,
IPreferencePageContainer {
    private IWizard wizard;
    private Composite pageArea;
    private Tree pagesTree;
    private IDialogPage prevPage;
    private ProgressMonitorPart monitorPart;
    private SashForm wizardSash;
    private volatile int runningOperations = 0;

    public MultiPageWizardDialog(IWorkbenchWindow window, IWizard wizard) {
        this(window, wizard, null);
    }

    public MultiPageWizardDialog(IWorkbenchWindow window, IWizard wizard, IStructuredSelection selection) {
        super(window.getShell());
        this.wizard = wizard;
        this.wizard.setContainer((IWizardContainer)this);
        if (wizard instanceof IWorkbenchWizard) {
            if (selection == null && window.getSelectionService().getSelection() instanceof IStructuredSelection) {
                selection = (IStructuredSelection)window.getSelectionService().getSelection();
            }
            ((IWorkbenchWizard)wizard).init(window.getWorkbench(), selection);
        }
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    protected boolean isResizable() {
        return true;
    }

    protected int getShellStyle() {
        return 66608;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtons();
        this.updateWindowTitle();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        IWizardPage[] pages;
        Composite composite = (Composite)super.createDialogArea(parent);
        this.wizard.addPages();
        this.wizardSash = new SashForm(composite, 256);
        this.wizardSash.setLayoutData((Object)new GridData(1808));
        this.pagesTree = new Tree((Composite)this.wizardSash, 4);
        this.pagesTree.setLayoutData((Object)new GridData(1808));
        Composite pageContainer = UIUtils.createPlaceholder((Composite)this.wizardSash, 2);
        new Label(pageContainer, 514).setLayoutData((Object)new GridData(16384, 4, false, true));
        this.pageArea = UIUtils.createPlaceholder(pageContainer, 1);
        GridData gd = new GridData(1808);
        this.pageArea.setLayoutData((Object)gd);
        this.pageArea.setLayout((Layout)new GridLayout(1, true));
        this.wizardSash.setWeights(new int[]{300, 700});
        Point maxSize = new Point(0, 0);
        IWizardPage[] iWizardPageArray = pages = this.wizard.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            this.addPage(null, (IDialogPage)page, maxSize);
            ++n2;
        }
        this.pagesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiPageWizardDialog.this.changePage();
            }
        });
        this.pagesTree.select(this.pagesTree.getItem(0));
        this.changePage();
        IDialogPage firstPage = (IDialogPage)this.pagesTree.getItem(0).getData();
        this.setTitle(firstPage.getTitle());
        this.setTitleImage(firstPage.getImage());
        this.setMessage(firstPage.getDescription());
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        this.monitorPart = new ProgressMonitorPart(composite, null, true){

            public void setCanceled(boolean b) {
                super.setCanceled(b);
                if (b) {
                    MultiPageWizardDialog.this.cancelCurrentOperation();
                }
            }
        };
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 0;
        this.monitorPart.setLayoutData((Object)gd);
        this.monitorPart.setVisible(false);
        return composite;
    }

    protected void cancelCurrentOperation() {
    }

    private TreeItem addPage(TreeItem parentItem, IDialogPage page, Point maxSize) {
        Object[] subPages;
        TreeItem item = parentItem == null ? new TreeItem(this.pagesTree, 0) : new TreeItem(parentItem, 0);
        item.setText(page.getTitle());
        item.setData((Object)page);
        if (page instanceof ICompositeDialogPage && !ArrayUtils.isEmpty((Object[])(subPages = ((ICompositeDialogPage)page).getSubPages(true)))) {
            Object[] objectArray = subPages;
            int n = subPages.length;
            int n2 = 0;
            while (n2 < n) {
                Object subPage = objectArray[n2];
                this.addPage(item, (IDialogPage)subPage, maxSize);
                ++n2;
            }
            item.setExpanded(true);
        }
        return item;
    }

    private void changePage() {
        this.pageArea.setRedraw(false);
        try {
            GridData gd;
            TreeItem[] selection = this.pagesTree.getSelection();
            if (selection.length != 1) {
                return;
            }
            TreeItem newItem = selection[0];
            if (this.prevPage == newItem.getData()) {
                return;
            }
            if (this.prevPage != null) {
                gd = (GridData)this.prevPage.getControl().getLayoutData();
                gd.exclude = true;
                this.prevPage.setVisible(false);
                if (this.prevPage instanceof ActiveWizardPage) {
                    ((ActiveWizardPage)this.prevPage).deactivatePage();
                }
            }
            boolean pageCreated = false;
            IDialogPage page = (IDialogPage)newItem.getData();
            Control pageControl = page.getControl();
            if (pageControl == null) {
                page.createControl(this.pageArea);
                pageControl = page.getControl();
                gd = (GridData)pageControl.getLayoutData();
                if (gd == null) {
                    gd = new GridData(1808);
                    pageControl.setLayoutData((Object)gd);
                }
                gd.exclude = false;
                pageCreated = true;
            }
            gd = (GridData)pageControl.getLayoutData();
            gd.exclude = false;
            page.setVisible(true);
            if (page instanceof ActiveWizardPage) {
                ((ActiveWizardPage)page).activatePage();
            }
            this.setTitle(page.getTitle());
            this.setMessage(page.getDescription());
            this.prevPage = page;
            this.pageArea.layout();
            if (pageCreated && this.isAutoLayoutAvailable()) {
                UIUtils.asyncExec(() -> UIUtils.resizeShell(this.getWizard().getContainer().getShell()));
            }
        }
        finally {
            this.pageArea.setRedraw(true);
        }
    }

    protected boolean isAutoLayoutAvailable() {
        return true;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.getWizard().performCancel();
        } else if (buttonId == 0 && !this.getWizard().performFinish()) {
            return;
        }
        super.buttonPressed(buttonId);
    }

    public IWizardPage getCurrentPage() {
        Object[] selection = this.pagesTree.getSelection();
        if (ArrayUtils.isEmpty((Object[])selection)) {
            return null;
        }
        IDialogPage page = (IDialogPage)selection[0].getData();
        return page instanceof IWizardPage ? (IWizardPage)page : null;
    }

    public void showPage(IWizardPage page) {
        TreeItem[] treeItemArray = this.pagesTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == page) {
                this.pagesTree.setSelection(item);
                this.changePage();
                break;
            }
            TreeItem[] treeItemArray2 = item.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem child = treeItemArray2[n4];
                if (child.getData() == page) {
                    this.pagesTree.setSelection(child);
                    this.changePage();
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore());
    }

    public void updateButtons() {
        boolean complete = true;
        TreeItem[] treeItemArray = this.pagesTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page;
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof IWizardPage && (page = (IWizardPage)item.getData()).getControl() != null && !page.isPageComplete()) {
                complete = false;
                break;
            }
            ++n2;
        }
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(complete);
        }
    }

    public void updateMessage() {
    }

    public void updateTitle() {
        this.updateWindowTitle();
    }

    public void updateTitleBar() {
        this.setTitleImage(this.getCurrentPage().getImage());
    }

    public void updateWindowTitle() {
        this.getShell().setText(this.getWizard().getWindowTitle());
        this.getShell().setImage(this.getWizard().getDefaultPageImage());
        this.updateMessage();
    }

    public boolean close() {
        if (this.runningOperations > 0) {
            return false;
        }
        return super.close();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.monitorPart != null) {
            this.monitorPart.setVisible(true);
            this.monitorPart.layout();
            this.monitorPart.attachToCancelComponent(null);
        }
        ControlEnableState pageEnableState = ControlEnableState.disable((Control)this.wizardSash);
        ControlEnableState buttonsEnableState = ControlEnableState.disable((Control)this.getButtonBar());
        try {
            ++this.runningOperations;
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitorPart, (Display)this.getShell().getDisplay());
        }
        finally {
            --this.runningOperations;
            buttonsEnableState.restore();
            pageEnableState.restore();
            if (this.monitorPart != null) {
                this.monitorPart.done();
                this.monitorPart.setVisible(false);
            }
        }
    }
}

