/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableColumnSortListener
implements Listener {
    private final Table table;
    private final int columnIndex;
    private int sortDirection = 1024;
    private TableColumn prevColumn = null;

    public TableColumnSortListener(Table table, int columnIndex) {
        this.table = table;
        this.columnIndex = columnIndex;
    }

    private static void sortTable(Table table, Comparator<TableItem> comparator) {
        int columnCount = table.getColumnCount();
        String[] values = new String[columnCount];
        Color[] foregrounds = new Color[columnCount];
        Color[] backgrounds = new Color[columnCount];
        TableItem[] items = table.getItems();
        int i = 1;
        while (i < items.length) {
            int j = 0;
            while (j < i) {
                TableItem item = items[i];
                if (comparator.compare(item, items[j]) < 0) {
                    int k = 0;
                    while (k < columnCount) {
                        values[k] = item.getText(k);
                        foregrounds[k] = item.getForeground(k);
                        backgrounds[k] = item.getBackground(k);
                        ++k;
                    }
                    Object data = item.getData();
                    boolean checked = item.getChecked();
                    item.dispose();
                    item = new TableItem(table, 0, j);
                    item.setText(values);
                    item.setData(data);
                    item.setChecked(checked);
                    int k2 = 0;
                    while (k2 < columnCount) {
                        if (foregrounds[k2] != null) {
                            item.setForeground(k2, foregrounds[k2]);
                        }
                        if (backgrounds[k2] != null) {
                            item.setBackground(k2, backgrounds[k2]);
                        }
                        ++k2;
                    }
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void handleEvent(Event e) {
        Collator collator = Collator.getInstance(Locale.getDefault());
        TableColumn column = (TableColumn)e.widget;
        if (this.prevColumn == column) {
            this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
        }
        this.prevColumn = column;
        this.table.setSortColumn(column);
        this.table.setSortDirection(this.sortDirection);
        TableColumnSortListener.sortTable(this.table, (e1, e2) -> {
            int mul = this.sortDirection == 128 ? 1 : -1;
            String text1 = e1.getText(this.columnIndex);
            String text2 = e2.getText(this.columnIndex);
            try {
                Double num2;
                Double num1 = TableColumnSortListener.getNumberFromString(text1);
                if (num1 != null && (num2 = TableColumnSortListener.getNumberFromString(text2)) != null) {
                    return (int)(num1 - num2) * mul;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return collator.compare(text1, text2) * mul;
        });
    }

    private static Double getNumberFromString(String str) {
        if (str.isEmpty()) {
            return null;
        }
        if (!Character.isDigit(str.charAt(0))) {
            return null;
        }
        int numLength = 1;
        while (numLength < str.length()) {
            if (Character.isWhitespace(str.charAt(numLength))) break;
            ++numLength;
        }
        if (numLength == str.length()) {
            return Double.parseDouble(str);
        }
        return Double.parseDouble(str.substring(0, numLength));
    }
}

