/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceHandler;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDPreferences;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceOrigin;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterProfile;
import org.jkiss.dbeaver.registry.internal.RegistryMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class DataSourceDescriptor
implements DBPDataSourceContainer,
DBPImageProvider,
IAdaptable,
DBPStatefulObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(DataSourceDescriptor.class);
    public static final String[] CONNECT_PATTERNS = new String[]{"host", "port", "server", "database", "user", "password", "url", "workspace", "home", "dbeaver_home", "application.name", "application.version", "local.ip"};
    public static final String[][] CONNECT_VARIABLES = new String[][]{{"host", "target host"}, {"port", "target port"}, {"server", "target server name"}, {"database", "target database"}, {"user", "user name"}, {"password", "password (plain)"}, {"url", "JDBC URL"}, {"workspace", "workspace path"}, {"home", "user home path"}, {"dbeaver_home", "application install path"}, {"application.name", "application name"}, {"application.version", "application version"}, {"local.ip", "local IP address"}};
    @NotNull
    private final DBPDataSourceRegistry registry;
    @NotNull
    private final DataSourceOrigin origin;
    @NotNull
    private DriverDescriptor driver;
    @NotNull
    private DBPConnectionConfiguration connectionInfo;
    private DBPConnectionConfiguration tunnelConnectionInfo;
    private DBPConnectionConfiguration resolvedConnectionInfo;
    @NotNull
    private String id;
    private String name;
    private String description;
    private boolean savePassword;
    private boolean showSystemObjects;
    private boolean showUtilityObjects;
    private boolean connectionReadOnly;
    private final Map<String, FilterMapping> filterMap = new HashMap<String, FilterMapping>();
    private DBDDataFormatterProfile formatterProfile;
    @Nullable
    private DBPNativeClientLocation clientHome;
    @Nullable
    private String lockPasswordHash;
    @Nullable
    private DataSourceFolder folder;
    @NotNull
    private DataSourcePreferenceStore preferenceStore;
    @Nullable
    private DBPDataSource dataSource;
    private final List<DBPDataSourceTask> users = new ArrayList<DBPDataSourceTask>();
    private volatile boolean connectFailed = false;
    private volatile Date connectTime = null;
    private volatile boolean disposed = false;
    private volatile boolean connecting = false;
    private boolean temporary;
    private final List<DBRProcessDescriptor> childProcesses = new ArrayList<DBRProcessDescriptor>();
    private DBWNetworkHandler proxyHandler;
    private DBWTunnel tunnelHandler;
    @NotNull
    private DBVModel virtualModel;

    public DataSourceDescriptor(@NotNull DBPDataSourceRegistry registry, @NotNull String id, @NotNull DriverDescriptor driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        this(registry, ((DataSourceRegistry)registry).getDefaultOrigin(), id, driver, connectionInfo);
    }

    DataSourceDescriptor(@NotNull DBPDataSourceRegistry registry, @NotNull DataSourceOrigin origin, @NotNull String id, @NotNull DriverDescriptor driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        this.registry = registry;
        this.origin = origin;
        this.id = id;
        this.driver = driver;
        this.connectionInfo = connectionInfo;
        this.preferenceStore = new DataSourcePreferenceStore(this);
        this.virtualModel = new DBVModel((DBPDataSourceContainer)this);
    }

    public DataSourceDescriptor(@NotNull DataSourceDescriptor source) {
        this(source, source.registry);
    }

    public DataSourceDescriptor(@NotNull DataSourceDescriptor source, @NotNull DBPDataSourceRegistry registry) {
        this.registry = registry;
        this.origin = source.origin;
        this.id = source.id;
        this.name = source.name;
        this.description = source.description;
        this.savePassword = source.savePassword;
        this.showSystemObjects = source.showSystemObjects;
        this.showUtilityObjects = source.showUtilityObjects;
        this.connectionReadOnly = source.connectionReadOnly;
        this.driver = source.driver;
        this.connectionInfo = source.connectionInfo;
        this.formatterProfile = source.formatterProfile;
        this.clientHome = source.clientHome;
        this.connectionInfo = new DBPConnectionConfiguration(source.connectionInfo);
        for (Map.Entry<String, FilterMapping> fe : source.filterMap.entrySet()) {
            this.filterMap.put(fe.getKey(), new FilterMapping(fe.getValue()));
        }
        this.lockPasswordHash = source.lockPasswordHash;
        this.folder = source.folder;
        this.preferenceStore = new DataSourcePreferenceStore(this);
        this.virtualModel = new DBVModel((DBPDataSourceContainer)this, source.virtualModel);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            log.warn((Object)"Dispose of already disposed data source");
            return;
        }
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            this.users.clear();
        }
        this.disposed = true;
    }

    @Property(name="ID", viewable=false, order=0)
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @NotNull
    public DriverDescriptor getDriver() {
        return this.driver;
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.registry.getPlatform();
    }

    public void setDriver(@NotNull DriverDescriptor driver) {
        this.driver = driver;
    }

    @NotNull
    public DBPConnectionConfiguration getConnectionConfiguration() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(@NotNull DBPConnectionConfiguration connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    @NotNull
    public DBPConnectionConfiguration getActualConnectionConfiguration() {
        return this.resolvedConnectionInfo != null ? this.resolvedConnectionInfo : (this.tunnelConnectionInfo != null ? this.tunnelConnectionInfo : this.connectionInfo);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, multiline=true, order=2)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public boolean isShowSystemObjects() {
        return this.showSystemObjects;
    }

    public void setShowSystemObjects(boolean showSystemObjects) {
        this.showSystemObjects = showSystemObjects;
    }

    public boolean isShowUtilityObjects() {
        return this.showUtilityObjects;
    }

    public void setShowUtilityObjects(boolean showUtilityObjects) {
        this.showUtilityObjects = showUtilityObjects;
    }

    public boolean isConnectionReadOnly() {
        return this.connectionReadOnly;
    }

    public void setConnectionReadOnly(boolean connectionReadOnly) {
        this.connectionReadOnly = connectionReadOnly;
    }

    public boolean isDefaultAutoCommit() {
        if (this.connectionInfo.getBootstrap().getDefaultAutoCommit() != null) {
            return this.connectionInfo.getBootstrap().getDefaultAutoCommit();
        }
        return this.getConnectionConfiguration().getConnectionType().isAutocommit();
    }

    public void setDefaultAutoCommit(boolean autoCommit, @Nullable DBCExecutionContext updateContext, boolean updateConnection, @Nullable Runnable onFinish) throws DBException {
        if (updateContext != null) {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)updateContext);
            if (updateConnection && txnManager != null) {
                TasksJob.runTask((String)"Set auto-commit mode", monitor -> {
                    try {
                        try {
                            txnManager.setAutoCommit(monitor, autoCommit);
                        }
                        catch (DBCException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                        if (onFinish != null) {
                            onFinish.run();
                        }
                    }
                });
            }
        }
        if (autoCommit == this.getConnectionConfiguration().getConnectionType().isAutocommit()) {
            this.connectionInfo.getBootstrap().setDefaultAutoCommit(null);
        } else {
            this.connectionInfo.getBootstrap().setDefaultAutoCommit(Boolean.valueOf(autoCommit));
        }
    }

    @Nullable
    public DBPTransactionIsolation getActiveTransactionsIsolation() {
        DBCTransactionManager txnManager;
        DBSInstance defaultInstance;
        if (this.dataSource != null && (defaultInstance = this.dataSource.getDefaultInstance()) != null && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)defaultInstance.getDefaultContext(false))) != null) {
            try {
                return txnManager.getTransactionIsolation();
            }
            catch (DBCException e) {
                log.debug((Object)"Can't determine isolation level", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public Integer getDefaultTransactionsIsolation() {
        return this.connectionInfo.getBootstrap().getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionsIsolation(@Nullable DBPTransactionIsolation isolationLevel) throws DBException {
        if (isolationLevel == null) {
            this.connectionInfo.getBootstrap().setDefaultTransactionIsolation(null);
        } else {
            this.connectionInfo.getBootstrap().setDefaultTransactionIsolation(Integer.valueOf(isolationLevel.getCode()));
            if (this.dataSource != null) {
                TasksJob.runTask((String)"Set transactions isolation level", monitor -> {
                    DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.dataSource.getDefaultInstance().getDefaultContext(false));
                    if (txnManager != null) {
                        try {
                            if (!txnManager.getTransactionIsolation().equals(isolationLevel)) {
                                txnManager.setTransactionIsolation(monitor, isolationLevel);
                            }
                        }
                        catch (DBCException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
        }
    }

    public Collection<FilterMapping> getObjectFilters() {
        return this.filterMap.values();
    }

    @Nullable
    public DBSObjectFilter getObjectFilter(Class<?> type, @Nullable DBSObject parentObject, boolean firstMatch) {
        FilterMapping filterMapping = this.getFilterMapping(type, parentObject, firstMatch);
        if (filterMapping != null) {
            return filterMapping.getFilter(parentObject, firstMatch);
        }
        return null;
    }

    @Nullable
    private FilterMapping getFilterMapping(Class<?> type, @Nullable DBSObject parentObject, boolean firstMatch) {
        if (this.filterMap.isEmpty()) {
            return null;
        }
        Class<?> testType = type;
        while (testType != null) {
            FilterMapping filterMapping = this.getTypeFilterMapping(parentObject, firstMatch, testType);
            if (filterMapping != null) {
                return filterMapping;
            }
            testType = testType.getSuperclass();
        }
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            testType = classArray[n2];
            FilterMapping filterMapping = this.getTypeFilterMapping(parentObject, firstMatch, testType);
            if (filterMapping != null) {
                return filterMapping;
            }
            ++n2;
        }
        return null;
    }

    private FilterMapping getTypeFilterMapping(@Nullable DBSObject parentObject, boolean firstMatch, Class<?> testType) {
        DBSObjectFilter filter;
        FilterMapping filterMapping = this.filterMap.get(testType.getName());
        if (filterMapping == null) {
            Class<?>[] classArray = testType.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> it = classArray[n2];
                filterMapping = this.filterMap.get(it.getName());
                if (filterMapping != null && (filter = filterMapping.getFilter(parentObject, firstMatch)) != null && (firstMatch || filter.isEnabled())) {
                    return filterMapping;
                }
                ++n2;
            }
        }
        if (filterMapping != null && (filter = filterMapping.getFilter(parentObject, firstMatch)) != null && (firstMatch || !filter.isNotApplicable())) {
            return filterMapping;
        }
        return null;
    }

    public void setObjectFilter(Class<?> type, DBSObject parentObject, DBSObjectFilter filter) {
        FilterMapping filterMapping = this.getFilterMapping(type, parentObject, true);
        if (filterMapping != null) {
            if (parentObject == null) {
                filterMapping.defaultFilter = filter;
            } else {
                filterMapping.customFilters.put(FilterMapping.getFilterContainerUniqueID(parentObject), filter);
            }
        }
        this.updateObjectFilter(type.getName(), parentObject == null ? null : FilterMapping.getFilterContainerUniqueID(parentObject), filter);
    }

    void clearFilters() {
        this.filterMap.clear();
    }

    void updateObjectFilter(String typeName, @Nullable String objectID, DBSObjectFilter filter) {
        FilterMapping filterMapping = this.filterMap.get(typeName);
        if (filterMapping == null) {
            filterMapping = new FilterMapping(typeName);
            this.filterMap.put(typeName, filterMapping);
        }
        if (objectID == null) {
            filterMapping.defaultFilter = filter;
        } else {
            filterMapping.customFilters.put(objectID, filter);
        }
    }

    @NotNull
    public DBVModel getVirtualModel() {
        return this.virtualModel;
    }

    public boolean hasSharedVirtualModel() {
        return !CommonUtils.equalObjects((Object)this.virtualModel.getId(), (Object)this.getId());
    }

    public void setVirtualModel(@NotNull DBVModel virtualModel) {
        if (virtualModel.getId().equals(this.getId())) {
            this.virtualModel = virtualModel;
            this.virtualModel.setDataSourceContainer((DBPDataSourceContainer)this);
        } else {
            this.virtualModel = new DBVModel((DBPDataSourceContainer)this, virtualModel);
            this.virtualModel.setId(virtualModel.getId());
        }
    }

    public DBPNativeClientLocation getClientHome() {
        if (this.clientHome == null && !CommonUtils.isEmpty((String)this.connectionInfo.getClientHomeId())) {
            this.clientHome = (DBPNativeClientLocation)DBUtils.findObject(this.driver.getNativeClientLocations(), (String)this.connectionInfo.getClientHomeId());
        }
        return this.clientHome;
    }

    public DBWNetworkHandler[] getActiveNetworkHandlers() {
        DBWNetworkHandler[] dBWNetworkHandlerArray;
        if (this.proxyHandler == null && this.tunnelHandler == null) {
            return new DBWNetworkHandler[0];
        }
        if (this.proxyHandler == null) {
            DBWNetworkHandler[] dBWNetworkHandlerArray2 = new DBWNetworkHandler[1];
            dBWNetworkHandlerArray = dBWNetworkHandlerArray2;
            dBWNetworkHandlerArray2[0] = this.tunnelHandler;
        } else if (this.tunnelHandler == null) {
            DBWNetworkHandler[] dBWNetworkHandlerArray3 = new DBWNetworkHandler[1];
            dBWNetworkHandlerArray = dBWNetworkHandlerArray3;
            dBWNetworkHandlerArray3[0] = this.proxyHandler;
        } else {
            DBWNetworkHandler[] dBWNetworkHandlerArray4 = new DBWNetworkHandler[2];
            dBWNetworkHandlerArray4[0] = this.proxyHandler;
            dBWNetworkHandlerArray = dBWNetworkHandlerArray4;
            dBWNetworkHandlerArray4[1] = this.tunnelHandler;
        }
        return dBWNetworkHandlerArray;
    }

    @NotNull
    DataSourceOrigin getOrigin() {
        return this.origin;
    }

    public boolean isProvided() {
        return !this.origin.isDefault();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public DBSObject getParentObject() {
        return null;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.dataSource instanceof DBPRefreshableObject) {
            this.dataSource = (DBPDataSource)((DBPRefreshableObject)this.dataSource).refreshObject(monitor);
        } else {
            this.reconnect(monitor, false);
        }
        this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this));
        return this;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Date getConnectTime() {
        return this.connectTime;
    }

    public boolean isLocked() {
        return !CommonUtils.isEmpty((String)this.lockPasswordHash);
    }

    @Nullable
    public String getLockPasswordHash() {
        return this.lockPasswordHash;
    }

    void setLockPasswordHash(@Nullable String lockPasswordHash) {
        this.lockPasswordHash = lockPasswordHash;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public DataSourceFolder getFolder() {
        return this.folder;
    }

    public void setFolder(@Nullable DBPDataSourceFolder folder) {
        this.folder = (DataSourceFolder)folder;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public DBPDataSourceRegistry getRegistry() {
        return this.registry;
    }

    public void persistConfiguration() {
        this.registry.flushConfig();
    }

    public boolean isConnected() {
        return this.dataSource != null;
    }

    public boolean connect(DBRProgressMonitor monitor, boolean initialize, boolean reflect) throws DBException {
        if (this.connecting) {
            log.debug((Object)"Can't connect - connect/disconnect is in progress");
            return false;
        }
        if (this.isConnected()) {
            log.debug((Object)"Can't connect - already connected");
            return false;
        }
        log.debug((Object)("Connect with '" + this.getName() + "' (" + this.getId() + ")"));
        if (!(this.isSavePassword() || this.getDriver().isAnonymousAccess() || DataSourceDescriptor.askForPassword(this, null, false))) {
            this.updateDataSourceObject(this);
            return false;
        }
        this.processEvents(monitor, DBPConnectionEventType.BEFORE_CONNECT);
        this.connecting = true;
        this.tunnelConnectionInfo = null;
        this.resolvedConnectionInfo = null;
        try {
            this.proxyHandler = null;
            this.tunnelHandler = null;
            DBWHandlerConfiguration tunnelConfiguration = null;
            DBWHandlerConfiguration proxyConfiguration = null;
            for (DBWHandlerConfiguration handler : this.connectionInfo.getHandlers()) {
                if (!handler.isEnabled()) continue;
                handler.setDriver((DBPDriver)this.getDriver());
                if (handler.getType() == DBWHandlerType.TUNNEL) {
                    tunnelConfiguration = handler;
                    continue;
                }
                if (handler.getType() != DBWHandlerType.PROXY) continue;
                proxyConfiguration = handler;
            }
            monitor.beginTask("Connect to " + this.getName(), tunnelConfiguration != null ? 3 : 2);
            if (proxyConfiguration != null) {
                monitor.subTask("Initialize proxy");
                this.proxyHandler = proxyConfiguration.createHandler(DBWNetworkHandler.class);
                this.proxyHandler.initializeHandler(monitor, this.registry.getPlatform(), proxyConfiguration, this.connectionInfo);
            }
            if (tunnelConfiguration != null) {
                block36: {
                    monitor.subTask("Initialize tunnel");
                    this.tunnelHandler = (DBWTunnel)tunnelConfiguration.createHandler(DBWTunnel.class);
                    try {
                        DBWTunnel.AuthCredentials rc;
                        if (tunnelConfiguration.isSavePassword() || (rc = this.tunnelHandler.getRequiredCredentials(tunnelConfiguration)) == DBWTunnel.AuthCredentials.NONE || DataSourceDescriptor.askForPassword(this, tunnelConfiguration, rc == DBWTunnel.AuthCredentials.PASSWORD)) break block36;
                        this.updateDataSourceObject(this);
                        this.tunnelHandler = null;
                        return false;
                    }
                    catch (Exception e) {
                        throw new DBCException("Can't initialize tunnel", (Throwable)e);
                    }
                }
                if (this.preferenceStore.getBoolean("database.connect.processEnvVars")) {
                    tunnelConfiguration = new DBWHandlerConfiguration(tunnelConfiguration);
                    tunnelConfiguration.resolveSystemEnvironmentVariables();
                }
                DBExecUtils.startContextInitiation((DBPDataSourceContainer)this);
                try {
                    this.tunnelConnectionInfo = this.tunnelHandler.initializeHandler(monitor, this.registry.getPlatform(), tunnelConfiguration, this.connectionInfo);
                }
                finally {
                    DBExecUtils.finishContextInitiation((DBPDataSourceContainer)this);
                }
                monitor.worked(1);
            }
            monitor.subTask("Connect to data source");
            if (this.preferenceStore.getBoolean("database.connect.processEnvVars") || !CommonUtils.isEmpty((String)this.connectionInfo.getConfigProfileName()) || !CommonUtils.isEmpty((String)this.connectionInfo.getUserProfileName())) {
                DBWNetworkProfile profile;
                this.resolvedConnectionInfo = new DBPConnectionConfiguration(this.tunnelConnectionInfo != null ? this.tunnelConnectionInfo : this.connectionInfo);
                if (this.preferenceStore.getBoolean("database.connect.processEnvVars")) {
                    this.resolvedConnectionInfo.resolveDynamicVariables();
                }
                if (!CommonUtils.isEmpty((String)this.connectionInfo.getConfigProfileName()) && (profile = this.registry.getNetworkProfile(this.connectionInfo.getConfigProfileName())) != null) {
                    for (DBWHandlerConfiguration handlerCfg : profile.getConfigurations()) {
                        if (!handlerCfg.isEnabled()) continue;
                        this.resolvedConnectionInfo.updateHandler(handlerCfg);
                    }
                }
                CommonUtils.isEmpty((String)this.connectionInfo.getUserProfileName());
            }
            this.dataSource = this.getDriver().getDataSourceProvider().openDataSource(monitor, (DBPDataSourceContainer)this);
            this.connectTime = new Date();
            monitor.worked(1);
            if (initialize) {
                monitor.subTask("Initialize data source");
                try {
                    this.dataSource.initialize(monitor);
                }
                catch (Throwable e) {
                    log.error((Object)"Error initializing datasource", e);
                }
                this.initConnectionState(monitor);
            }
            this.connectFailed = false;
            this.processEvents(monitor, DBPConnectionEventType.AFTER_CONNECT);
            if (reflect) {
                this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this, true));
            }
            try {
                log.debug((Object)("Connected (" + this.getId() + ", " + this.getPropertyDriver() + ")"));
            }
            catch (Throwable throwable) {
                log.debug((Object)("Connected (" + this.getId() + ", driver unknown)"));
            }
            return true;
        }
        catch (Exception e) {
            block39: {
                log.debug((Object)("Connection failed (" + this.getId() + ")"));
                if (this.tunnelHandler != null) {
                    try {
                        try {
                            this.tunnelHandler.closeTunnel(monitor);
                        }
                        catch (IOException iOException) {
                            log.error((Object)"Error closing tunnel", (Throwable)e);
                            this.tunnelHandler = null;
                            this.tunnelConnectionInfo = null;
                            break block39;
                        }
                    }
                    catch (Throwable throwable) {
                        this.tunnelHandler = null;
                        this.tunnelConnectionInfo = null;
                        throw throwable;
                    }
                    this.tunnelHandler = null;
                    this.tunnelConnectionInfo = null;
                }
            }
            this.proxyHandler = null;
            this.connectFailed = true;
            this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this, false));
            if (e instanceof DBException) {
                throw (DBException)((Object)e);
            }
            throw new DBException("Internal error connecting to " + this.getName(), (Throwable)e);
        }
        finally {
            monitor.done();
            this.connecting = false;
        }
    }

    private void initConnectionState(DBRProgressMonitor monitor) throws DBException {
        DBSObjectContainer schemaContainer;
        String activeObject;
        if (this.dataSource == null) {
            return;
        }
        if (this.dataSource instanceof DBSObjectContainer && !CommonUtils.isEmptyTrimmed((String)(activeObject = this.getConnectionConfiguration().getBootstrap().getDefaultObjectName())) && (schemaContainer = DBUtils.getChangeableObjectContainer((DBSObjectContainer)((DBSObjectContainer)this.dataSource))) != null && schemaContainer instanceof DBSObjectSelector) {
            DBSObject child = schemaContainer.getChild(monitor, activeObject);
            if (child != null) {
                try {
                    ((DBSObjectSelector)schemaContainer).setDefaultObject(monitor, child);
                }
                catch (DBException e) {
                    log.warn((Object)"Can't select active object", (Throwable)e);
                }
            } else {
                log.debug((Object)("Object '" + activeObject + "' not found"));
            }
        }
    }

    private void processEvents(DBRProgressMonitor monitor, DBPConnectionEventType eventType) {
        DBPConnectionConfiguration info = this.getActualConnectionConfiguration();
        DBRShellCommand command = info.getEvent(eventType);
        if (command != null && command.isEnabled()) {
            final DBRProcessDescriptor processDescriptor = new DBRProcessDescriptor(command, this.getVariablesResolver());
            monitor.subTask("Execute process " + processDescriptor.getName());
            DBWorkbench.getPlatformUI().executeProcess(processDescriptor);
            new AbstractJob(String.valueOf(processDescriptor.getName()) + ": output reader"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        String output = processDescriptor.dumpErrors();
                        log.debug((Object)("Process error output:\n" + output));
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (command.isWaitProcessFinish()) {
                int resultCode = command.getWaitProcessTimeoutMs() >= 0 ? processDescriptor.waitFor(command.getWaitProcessTimeoutMs()) : processDescriptor.waitFor();
                log.debug((Object)(String.valueOf(processDescriptor.getName()) + " result code: " + resultCode));
            }
            this.addChildProcess(processDescriptor);
        }
    }

    public boolean disconnect(DBRProgressMonitor monitor) throws DBException {
        return this.disconnect(monitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnect(DBRProgressMonitor monitor, boolean reflect) throws DBException {
        if (this.dataSource == null) {
            log.error((Object)"Datasource is not connected");
            return true;
        }
        if (this.connecting) {
            log.error((Object)"Connect/disconnect is in progress");
            return false;
        }
        this.connecting = true;
        try {
            this.releaseDataSourceUsers(monitor);
            monitor.beginTask("Disconnect from '" + this.getName() + "'", 5 + this.dataSource.getAvailableInstances().size());
            this.processEvents(monitor, DBPConnectionEventType.BEFORE_DISCONNECT);
            monitor.worked(1);
            monitor.subTask("Close connection");
            if (this.dataSource != null) {
                this.dataSource.shutdown(monitor);
            }
            monitor.worked(1);
            if (this.tunnelHandler != null) {
                monitor.subTask("Close tunnel");
                try {
                    this.tunnelHandler.closeTunnel(monitor);
                }
                catch (Throwable e) {
                    log.error((Object)"Error closing tunnel", e);
                }
            }
            monitor.worked(1);
            this.proxyHandler = null;
            this.processEvents(monitor, DBPConnectionEventType.AFTER_DISCONNECT);
            monitor.worked(1);
            monitor.done();
            List<DBRProcessDescriptor> list = this.childProcesses;
            synchronized (list) {
                Iterator<DBRProcessDescriptor> iter = this.childProcesses.iterator();
                while (iter.hasNext()) {
                    DBRProcessDescriptor process = iter.next();
                    if (process.isRunning() && process.getCommand().isTerminateAtDisconnect()) {
                        process.terminate();
                    }
                    iter.remove();
                }
            }
            this.dataSource = null;
            this.tunnelConnectionInfo = null;
            this.resolvedConnectionInfo = null;
            this.connectTime = null;
            if (reflect) {
                this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this, false));
            }
            return true;
        }
        finally {
            this.connecting = false;
            log.debug((Object)("Disconnected (" + this.getId() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDataSourceUsers(DBRProgressMonitor monitor) {
        ArrayList<DBPDataSourceTask> usersStamp;
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            usersStamp = new ArrayList<DBPDataSourceTask>(this.users);
        }
        int jobCount = 0;
        for (DBPDataSourceTask user : usersStamp) {
            if (user instanceof Job) {
                ++jobCount;
            }
            if (!(user instanceof DBPDataSourceHandler)) continue;
            ((DBPDataSourceHandler)user).beforeDisconnect();
        }
        if (jobCount > 0) {
            monitor.beginTask("Waiting for all active tasks to finish", jobCount);
            for (DBPDataSourceTask user : usersStamp) {
                if (!(user instanceof Job)) continue;
                Job job = (Job)user;
                monitor.subTask("Stop '" + job.getName() + "'");
                if (job.getState() == 4) {
                    job.cancel();
                    try {
                        int i = 0;
                        while (i < 30) {
                            Thread.sleep(100L);
                            if (job.getState() == 4) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                monitor.worked(1);
            }
            monitor.done();
        }
    }

    public boolean reconnect(DBRProgressMonitor monitor) throws DBException {
        return this.reconnect(monitor, true);
    }

    public boolean reconnect(DBRProgressMonitor monitor, boolean reflect) throws DBException {
        if (this.connecting) {
            log.debug((Object)"Can't reconnect - connect/disconnect is in progress");
            return false;
        }
        if (this.isConnected() && !this.disconnect(monitor, reflect)) {
            return false;
        }
        return this.connect(monitor, true, reflect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBPDataSourceTask> getTasks() {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            return new ArrayList<DBPDataSourceTask>(this.users);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(DBPDataSourceTask user) {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            if (this.users.contains(user)) {
                log.warn((Object)("Datasource user '" + user + "' already registered in datasource '" + this.getName() + "'"));
            } else {
                this.users.add(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DBPDataSourceTask user) {
        List<DBPDataSourceTask> list = this.users;
        synchronized (list) {
            if (!this.users.remove(user) && !this.isDisposed()) {
                log.warn((Object)("Datasource user '" + user + "' is not registered in datasource '" + this.getName() + "'"));
            }
        }
    }

    public void fireEvent(DBPEvent event) {
        this.registry.notifyDataSourceListeners(event);
    }

    public DBDDataFormatterProfile getDataFormatterProfile() {
        if (this.formatterProfile == null) {
            this.formatterProfile = new DataFormatterProfile(this.getId(), (DBPPreferenceStore)this.preferenceStore);
        }
        return this.formatterProfile;
    }

    public void setDataFormatterProfile(DBDDataFormatterProfile formatterProfile) {
        this.formatterProfile = formatterProfile;
    }

    @NotNull
    public DBDValueHandler getDefaultValueHandler() {
        if (this.dataSource instanceof DBDPreferences) {
            return ((DBDPreferences)this.dataSource).getDefaultValueHandler();
        }
        return DefaultValueHandler.INSTANCE;
    }

    @NotNull
    public DataSourcePreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void resetPassword() {
        this.connectionInfo.setUserPassword(null);
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (DBPDataSourceContainer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        if (adapter == DBPPropertySource.class) {
            PropertyCollector coll = new PropertyCollector((Object)this, true);
            coll.collectProperties();
            if (this.dataSource != null) {
                int conIndex = 0;
                for (DBSInstance instance : this.dataSource.getAvailableInstances()) {
                    DBCExecutionContext[] dBCExecutionContextArray = instance.getAllContexts();
                    int n = dBCExecutionContextArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBCExecutionContext context = dBCExecutionContextArray[n2];
                        coll.addProperty("Connections", (Object)(++conIndex), String.valueOf(conIndex), (Object)new ContextInfo(context));
                        ++n2;
                    }
                }
            }
            return adapter.cast(coll);
        }
        return null;
    }

    @NotNull
    public DBPImage getObjectImage() {
        return this.driver.getPlainIcon();
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this.isConnected()) {
            return DBSObjectState.ACTIVE;
        }
        if (this.connectFailed) {
            return DBSObjectState.INVALID;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    public static String generateNewId(DBPDriver driver) {
        long rnd = new Random().nextLong();
        if (rnd < 0L) {
            rnd = -rnd;
        }
        return String.valueOf(driver.getId()) + "-" + Long.toHexString(System.currentTimeMillis()) + "-" + Long.toHexString(rnd);
    }

    @Property(viewable=true, order=20, category="Driver")
    public String getPropertyDriverType() {
        return this.driver.getName();
    }

    @Property(order=3, category="Server")
    public String getPropertyAddress() {
        StringBuilder addr = new StringBuilder();
        if (!CommonUtils.isEmpty((String)this.connectionInfo.getHostName())) {
            addr.append(this.connectionInfo.getHostName());
        }
        if (!CommonUtils.isEmpty((String)this.connectionInfo.getHostPort())) {
            addr.append(':').append(this.connectionInfo.getHostPort());
        }
        return addr.toString();
    }

    @Property(order=4, category="Server")
    public String getPropertyDatabase() {
        return this.connectionInfo.getDatabaseName();
    }

    @Property(order=5, category="Server")
    public String getPropertyURL() {
        return this.connectionInfo.getUrl();
    }

    @Property(order=6, category="Server")
    @Nullable
    public String getPropertyServerName() {
        if (this.dataSource != null) {
            String serverName = this.dataSource.getInfo().getDatabaseProductName();
            String serverVersion = this.dataSource.getInfo().getDatabaseProductVersion();
            if (serverName != null) {
                return String.valueOf(serverName) + (serverVersion == null ? "" : " [" + serverVersion + "]");
            }
        }
        return null;
    }

    @Property(order=7, category="Server")
    @Nullable
    public Map<String, Object> getPropertyServerDetails() {
        if (this.dataSource != null) {
            return this.dataSource.getInfo().getDatabaseProductDetails();
        }
        return null;
    }

    @Property(order=21, category="Driver")
    @Nullable
    public String getPropertyDriver() {
        if (this.dataSource != null) {
            String driverName = this.dataSource.getInfo().getDriverName();
            String driverVersion = this.dataSource.getInfo().getDriverVersion();
            if (driverName != null) {
                return String.valueOf(driverName) + (driverVersion == null ? "" : " [" + driverVersion + "]");
            }
        }
        return null;
    }

    @Property(order=8)
    @Nullable
    public String getPropertyConnectTime() {
        if (this.connectTime != null) {
            return DateFormat.getDateTimeInstance(3, 3).format(this.connectTime);
        }
        return null;
    }

    @Property(order=9)
    public String getPropertyConnectType() {
        return this.connectionInfo.getConnectionType().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildProcess(DBRProcessDescriptor process) {
        List<DBRProcessDescriptor> list = this.childProcesses;
        synchronized (list) {
            this.childProcesses.add(process);
        }
    }

    public void copyFrom(DataSourceDescriptor descriptor) {
        this.filterMap.clear();
        for (FilterMapping mapping : descriptor.getObjectFilters()) {
            this.filterMap.put(mapping.typeName, new FilterMapping(mapping));
        }
        this.virtualModel.copyFrom(descriptor.getVirtualModel());
        this.setDescription(descriptor.getDescription());
        this.setSavePassword(descriptor.isSavePassword());
        this.setShowSystemObjects(descriptor.isShowSystemObjects());
        this.setShowUtilityObjects(descriptor.isShowUtilityObjects());
        this.setConnectionReadOnly(descriptor.isConnectionReadOnly());
    }

    @NotNull
    public ISecurePreferences getSecurePreferences() {
        return this.registry.getSecurePreferences().node(this.id);
    }

    public String toString() {
        return String.valueOf(this.name) + " [" + (Object)((Object)this.driver) + "]";
    }

    public boolean equalSettings(Object obj) {
        if (!(obj instanceof DataSourceDescriptor)) {
            return false;
        }
        DataSourceDescriptor source = (DataSourceDescriptor)obj;
        return CommonUtils.equalOrEmptyStrings((String)this.name, (String)source.name) && CommonUtils.equalOrEmptyStrings((String)this.description, (String)source.description) && CommonUtils.equalObjects((Object)this.savePassword, (Object)source.savePassword) && CommonUtils.equalObjects((Object)this.showSystemObjects, (Object)source.showSystemObjects) && CommonUtils.equalObjects((Object)this.showUtilityObjects, (Object)source.showUtilityObjects) && CommonUtils.equalObjects((Object)this.connectionReadOnly, (Object)source.connectionReadOnly) && CommonUtils.equalObjects((Object)((Object)this.driver), (Object)((Object)source.driver)) && CommonUtils.equalObjects((Object)this.connectionInfo, (Object)source.connectionInfo) && CommonUtils.equalObjects(this.filterMap, source.filterMap) && CommonUtils.equalObjects((Object)this.formatterProfile, (Object)source.formatterProfile) && CommonUtils.equalObjects((Object)this.clientHome, (Object)source.clientHome) && CommonUtils.equalObjects((Object)this.lockPasswordHash, (Object)source.lockPasswordHash) && CommonUtils.equalObjects((Object)this.folder, (Object)source.folder);
    }

    public GeneralUtils.IVariableResolver getVariablesResolver() {
        return name -> {
            String propValue = (String)this.getActualConnectionConfiguration().getProperties().get(name);
            if (propValue != null) {
                return propValue;
            }
            switch (name = name.toLowerCase(Locale.ENGLISH)) {
                case "host": {
                    return this.getActualConnectionConfiguration().getHostName();
                }
                case "port": {
                    return this.getActualConnectionConfiguration().getHostPort();
                }
                case "server": {
                    return this.getActualConnectionConfiguration().getServerName();
                }
                case "database": {
                    return this.getActualConnectionConfiguration().getDatabaseName();
                }
                case "user": {
                    return this.getActualConnectionConfiguration().getUserName();
                }
                case "password": {
                    return this.getActualConnectionConfiguration().getUserPassword();
                }
                case "url": {
                    return this.getActualConnectionConfiguration().getUrl();
                }
            }
            return SystemVariablesResolver.INSTANCE.get(name);
        };
    }

    public static boolean askForPassword(@NotNull DataSourceDescriptor dataSourceContainer, @Nullable DBWHandlerConfiguration networkHandler, boolean passwordOnly) {
        String prompt = networkHandler != null ? NLS.bind((String)RegistryMessages.dialog_connection_auth_title_for_handler, (Object)networkHandler.getTitle()) : "'" + dataSourceContainer.getName() + RegistryMessages.dialog_connection_auth_title;
        String user = networkHandler != null ? networkHandler.getUserName() : dataSourceContainer.getConnectionConfiguration().getUserName();
        String password = networkHandler != null ? networkHandler.getPassword() : dataSourceContainer.getConnectionConfiguration().getUserPassword();
        DBPAuthInfo authInfo = DBWorkbench.getPlatformUI().promptUserCredentials(prompt, user, password, passwordOnly, !dataSourceContainer.isTemporary());
        if (authInfo == null) {
            return false;
        }
        if (networkHandler != null) {
            if (!passwordOnly) {
                networkHandler.setUserName(authInfo.getUserName());
            }
            networkHandler.setPassword(authInfo.getUserPassword());
            networkHandler.setSavePassword(authInfo.isSavePassword());
        } else {
            if (!passwordOnly) {
                dataSourceContainer.getConnectionConfiguration().setUserName(authInfo.getUserName());
            }
            dataSourceContainer.getConnectionConfiguration().setUserPassword(authInfo.getUserPassword());
            dataSourceContainer.setSavePassword(authInfo.isSavePassword());
        }
        if (authInfo.isSavePassword()) {
            dataSourceContainer.getRegistry().updateDataSource((DBPDataSourceContainer)dataSourceContainer);
        }
        return true;
    }

    public void updateDataSourceObject(DataSourceDescriptor dataSourceDescriptor) {
        this.getRegistry().notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)dataSourceDescriptor, false));
    }

    public static class ContextInfo
    implements DBPObject {
        private final DBCExecutionContext context;

        public ContextInfo(DBCExecutionContext context) {
            this.context = context;
        }

        @Property(viewable=true, order=1)
        public String getName() {
            return this.context.getContextName();
        }

        public String toString() {
            return this.getName();
        }
    }
}

