/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ColorSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.TransformerSettingsDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

class EditVirtualEntityDialog
extends BaseDialog {
    private static final Log log = Log.getLog(EditVirtualEntityDialog.class);
    private static final String DIALOG_ID = "DBeaver.EditVirtualEntityDialog";
    public static final int ID_CREATE_UNIQUE_KEY = 1000;
    public static final int ID_REMOVE_UNIQUE_KEY = 1001;
    public static final int ID_CREATE_FOREIGN_KEY = 2000;
    public static final int ID_REMOVE_FOREIGN_KEY = 2001;
    private static final int ID_CONFIGURE_TRANSFORMS = 3001;
    private static final int ID_CONFIGURE_COLORS = 3002;
    private ResultSetViewer viewer;
    private DBSEntity entity;
    private DBVEntity vEntity;
    private EditDictionaryPage editDictionaryPage;
    private EditConstraintPage editUniqueKeyPage;
    private DBVEntityConstraint uniqueConstraint;
    private InitPage initPage = InitPage.ATTRIBUTES;

    public EditVirtualEntityDialog(ResultSetViewer viewer, @Nullable DBSEntity entity, @NotNull DBVEntity vEntity) {
        super(viewer.getControl().getShell(), "Edit logical structure / presentation", null);
        this.viewer = viewer;
        this.entity = entity;
        this.vEntity = vEntity;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    public InitPage getInitPage() {
        return this.initPage;
    }

    public void setInitPage(InitPage initPage) {
        this.initPage = initPage;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        TabFolder tabFolder = new TabFolder(composite, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createColumnsPage(tabFolder);
        this.createUniqueKeysPage(tabFolder);
        this.createForeignKeysPage(tabFolder);
        this.createDictionaryPage(tabFolder);
        TabItem[] tabItemArray = tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            if (item.getData() == this.initPage) {
                tabFolder.setSelection(item);
                break;
            }
            ++n2;
        }
        UIUtils.createInfoLabel((Composite)composite, (String)"Entity logical structure is defined on client-side.\nYou can define virtual unique/foreign keys even if physical database\ndoesn't have or doesn't support them. Also you can define how to view column values.");
        return parent;
    }

    private void createDictionaryPage(TabFolder tabFolder) {
        if (this.entity != null) {
            this.editDictionaryPage = new EditDictionaryPage(this.entity);
            this.editDictionaryPage.createControl((Composite)tabFolder);
            TabItem dictItem = new TabItem(tabFolder, 0);
            dictItem.setText("Dictionary");
            dictItem.setControl(this.editDictionaryPage.getControl());
            dictItem.setData((Object)InitPage.DICTIONARY);
        }
    }

    private void createUniqueKeysPage(TabFolder tabFolder) {
        DBDRowIdentifier virtualEntityIdentifier = this.viewer.getVirtualEntityIdentifier();
        if (virtualEntityIdentifier == null) {
            return;
        }
        TabItem ukItem = new TabItem(tabFolder, 0);
        ukItem.setText("Virtual Unique Key");
        ukItem.setData((Object)InitPage.UNIQUE_KEY);
        this.uniqueConstraint = (DBVEntityConstraint)virtualEntityIdentifier.getUniqueKey();
        this.editUniqueKeyPage = new EditConstraintPage("Define unique identifier", (DBSEntityReferrer)this.uniqueConstraint);
        this.editUniqueKeyPage.createControl((Composite)tabFolder);
        ukItem.setControl(this.editUniqueKeyPage.getControl());
    }

    private void createForeignKeysPage(TabFolder tabFolder) {
        TabItem fkItem = new TabItem(tabFolder, 0);
        fkItem.setText("Virtual Foreign Keys");
        fkItem.setData((Object)InitPage.FOREIGN_KEYS);
        Composite panel = new Composite((Composite)tabFolder, 1);
        panel.setLayout((Layout)new GridLayout(1, false));
        fkItem.setControl((Control)panel);
        final Table fkTable = new Table(panel, 67584);
        fkTable.setLayoutData((Object)new GridData(1808));
        fkTable.setHeaderVisible(true);
        UIUtils.executeOnResize((Control)fkTable, () -> UIUtils.packColumns((Table)fkTable, (boolean)true));
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)"Ref Table");
        UIUtils.createTableColumn((Table)fkTable, (int)16384, (String)"Columns");
        for (DBVEntityForeignKey fk : this.vEntity.getForeignKeys()) {
            this.createForeignKeyItem(fkTable, fk);
        }
        Composite buttonsPanel = UIUtils.createComposite((Composite)panel, (int)2);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        Button btnAdd = this.createButton(buttonsPanel, 2000, "Add", false);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = new DBVEntityForeignKey(EditVirtualEntityDialog.this.vEntity);
                EditForeignKeyPage editDialog = new EditForeignKeyPage("Define virtual foreign keys", (DBSEntityAssociation)virtualFK, new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION});
                editDialog.setEnableCustomKeys(true);
                if (!editDialog.edit()) {
                    return;
                }
                try {
                    virtualFK.setReferencedConstraint((DBRProgressMonitor)new VoidProgressMonitor(), editDialog.getUniqueConstraint());
                }
                catch (DBException e1) {
                    log.error((Object)e1);
                    return;
                }
                ArrayList<DBVEntityForeignKeyColumn> columns = new ArrayList<DBVEntityForeignKeyColumn>();
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editDialog.getColumns()) {
                    columns.add(new DBVEntityForeignKeyColumn(virtualFK, tableColumn.getOwnColumn().getName(), tableColumn.getRefColumn().getName()));
                }
                virtualFK.setAttributes(columns);
                EditVirtualEntityDialog.this.vEntity.addForeignKey(virtualFK);
                EditVirtualEntityDialog.this.createForeignKeyItem(fkTable, virtualFK);
            }
        });
        Button btnRemove = this.createButton(buttonsPanel, 2001, "Remove", false);
        btnRemove.setEnabled(false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBVEntityForeignKey virtualFK = (DBVEntityForeignKey)fkTable.getSelection()[0].getData();
                if (!UIUtils.confirmAction((Shell)EditVirtualEntityDialog.this.getShell(), (String)"Delete virtual FK", (String)("Are you sure you want to delete virtual foreign key '" + virtualFK.getName() + "'?"))) {
                    return;
                }
                EditVirtualEntityDialog.this.vEntity.removeForeignKey(virtualFK);
                fkTable.remove(fkTable.getSelectionIndices());
            }
        });
        fkTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hasSelection = fkTable.getSelectionIndex() >= 0;
                EditVirtualEntityDialog.this.getButton(2001).setEnabled(hasSelection);
            }
        });
    }

    private void createForeignKeyItem(Table fkTable, DBVEntityForeignKey fk) {
        TableItem item = new TableItem(fkTable, 0);
        item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        if (fk.getReferencedConstraint() != null) {
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)fk.getReferencedConstraint().getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.UI));
        }
        String ownAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getAttributeName).collect(Collectors.joining(","));
        String refAttrNames = fk.getAttributes().stream().map(DBVEntityForeignKeyColumn::getRefAttributeName).collect(Collectors.joining(","));
        item.setText(1, "(" + ownAttrNames + ") -> (" + refAttrNames + ")");
        item.setData((Object)fk);
    }

    private void createColumnsPage(TabFolder tabFolder) {
        TabItem colItem = new TabItem(tabFolder, 0);
        colItem.setText("Columns view");
        colItem.setData((Object)InitPage.ATTRIBUTES);
        Composite panel = new Composite((Composite)tabFolder, 1);
        panel.setLayout((Layout)new GridLayout(1, false));
        colItem.setControl((Control)panel);
        final Table colTable = new Table(panel, 67584);
        colTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        colTable.setLayoutData((Object)gd);
        UIUtils.executeOnResize((Control)colTable, () -> UIUtils.packColumns((Table)colTable, (boolean)true));
        UIUtils.createTableColumn((Table)colTable, (int)16384, (String)"Name");
        UIUtils.createTableColumn((Table)colTable, (int)16384, (String)"Transforms");
        UIUtils.createTableColumn((Table)colTable, (int)16384, (String)"Colors");
        for (DBDAttributeBinding attr : this.viewer.getModel().getVisibleAttributes()) {
            TableItem attrItem = new TableItem(colTable, 0);
            attrItem.setData((Object)attr);
            attrItem.setText(0, attr.getName());
            attrItem.setImage(0, DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)attr, (boolean)true)));
            this.updateColumnItem(attrItem);
        }
        Composite buttonsPanel = UIUtils.createComposite((Composite)panel, (int)2);
        buttonsPanel.setLayoutData((Object)new GridData(32));
        Button btnTransforms = this.createButton(buttonsPanel, 3001, "Transforms ...", false);
        btnTransforms.setEnabled(false);
        btnTransforms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformerSettingsDialog dialog;
                TableItem item = colTable.getItem(colTable.getSelectionIndex());
                DBDAttributeBinding attr = (DBDAttributeBinding)item.getData();
                DBVEntityAttribute vAttr = EditVirtualEntityDialog.this.vEntity.getVirtualAttribute(attr, true);
                if (!$assertionsDisabled && vAttr == null) {
                    throw new AssertionError();
                }
                DBVTransformSettings transformSettings = vAttr.getTransformSettings();
                if (transformSettings == null) {
                    transformSettings = new DBVTransformSettings();
                }
                if ((dialog = new TransformerSettingsDialog(EditVirtualEntityDialog.this.viewer, attr, transformSettings, true)).open() == 0) {
                    vAttr.setTransformSettings(transformSettings);
                }
                EditVirtualEntityDialog.this.updateColumnItem(item);
            }
        });
        Button btnColors = this.createButton(buttonsPanel, 3002, "Colors ...", false);
        btnColors.setEnabled(false);
        btnColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = colTable.getItem(colTable.getSelectionIndex());
                DBDAttributeBinding attr = (DBDAttributeBinding)item.getData();
                EditVirtualEntityDialog.this.vEntity.getVirtualAttribute(attr, true);
                ColorSettingsDialog dialog = new ColorSettingsDialog(EditVirtualEntityDialog.this.viewer, attr, null);
                dialog.open();
                EditVirtualEntityDialog.this.updateColumnItem(item);
            }
        });
        colTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean hasSelection = colTable.getSelectionIndex() >= 0;
                EditVirtualEntityDialog.this.getButton(3001).setEnabled(hasSelection);
                EditVirtualEntityDialog.this.getButton(3002).setEnabled(hasSelection);
            }
        });
    }

    private void updateColumnItem(TableItem attrItem) {
        DBVTransformSettings transformSettings;
        DBDAttributeBinding attr = (DBDAttributeBinding)attrItem.getData();
        String transformStr = "";
        DBVEntityAttribute vAttr = this.vEntity.getVirtualAttribute(attr, false);
        if (vAttr != null && (transformSettings = vAttr.getTransformSettings()) != null) {
            DBDAttributeTransformerDescriptor td;
            if (!CommonUtils.isEmpty((Collection)transformSettings.getIncludedTransformers())) {
                transformStr = String.join((CharSequence)",", transformSettings.getIncludedTransformers());
            } else if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer()) && (td = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(transformSettings.getCustomTransformer())) != null) {
                transformStr = td.getName();
            }
        }
        attrItem.setText(1, transformStr);
        String colorSettings = "";
        List coList = this.vEntity.getColorOverrides(attr.getName());
        if (!coList.isEmpty()) {
            ArrayList<String> coStrings = new ArrayList<String>();
            for (DBVColorOverride co : coList) {
                if (co.getAttributeValues() == null) continue;
                Object[] objectArray = co.getAttributeValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    coStrings.add(CommonUtils.toString((Object)value));
                    ++n2;
                }
            }
            colorSettings = String.join((CharSequence)",", coStrings);
        }
        attrItem.setText(2, colorSettings);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.editUniqueKeyPage != null) {
            Collection uniqueAttrs = this.editUniqueKeyPage.getSelectedAttributes();
            this.uniqueConstraint.setAttributes(uniqueAttrs);
            DBDRowIdentifier virtualEntityIdentifier = this.viewer.getVirtualEntityIdentifier();
            if (virtualEntityIdentifier != null) {
                try {
                    virtualEntityIdentifier.reloadAttributes((DBRProgressMonitor)new VoidProgressMonitor(), this.viewer.getModel().getAttributes());
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
        }
        if (this.editDictionaryPage != null) {
            this.editDictionaryPage.saveDictionarySettings();
        }
        this.viewer.persistConfig();
        super.okPressed();
    }

    public static enum InitPage {
        ATTRIBUTES,
        UNIQUE_KEY,
        FOREIGN_KEYS,
        DICTIONARY;

    }
}

