/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 20 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 24 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  RELEASE_OR_BETA:
//@line 29 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 31 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 34 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 38 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 46 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 48 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 53 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 55 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_DEV_EDITION:
//@line 60 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 62 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 67 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 69 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 74 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 76 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 81 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 83 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_CONTENT_SANDBOX:
//@line 88 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 90 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 95 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 97 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 102 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 104 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 109 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 111 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 116 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 118 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 123 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 125 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 130 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 132 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_WIDGET_GTK:
//@line 135 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 139 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

//@line 141 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 145 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 147 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  XP_UNIX:
//@line 150 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 154 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

//@line 157 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  platform:
//@line 159 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 173 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 190 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 192 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 197 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 199 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 204 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 206 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 209 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 213 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 218 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 220 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  ASAN:
//@line 225 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 227 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 232 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 234 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 239 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 241 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_SYSTEM_NSS:
//@line 244 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 248 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 253 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 255 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_REQUIRE_SIGNING:
//@line 260 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 262 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  INSTALL_COMPACT_THEMES:
//@line 265 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 269 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MENUBAR_CAN_AUTOHIDE:
//@line 272 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 276 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  CAN_DRAW_IN_TITLEBAR:
//@line 281 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 283 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 288 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 290 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_TOOLKIT_SEARCH:
//@line 293 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 297 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_GECKO_PROFILER:
//@line 300 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  true,
//@line 304 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_ACTIVITY_STREAM:
//@line 309 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  false,
//@line 311 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "bluegriffon",
  MOZ_APP_VERSION: "3.1",
  MOZ_APP_VERSION_DISPLAY: "3.1",
  MOZ_BUILD_APP: "bluegriffon",
  MOZ_MACBUNDLE_NAME: "BlueGriffon.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk3",
  ANDROID_PACKAGE_NAME: "org.mozilla.bluegriffon",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
//@line 335 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
  SOURCE_REVISION_URL: "",

  HAVE_USR_LIB64_DIR:
//@line 341 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
    false,
//@line 343 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"

  HAVE_SHELL_SERVICE:
//@line 346 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
    true,
//@line 350 "/build/bluegriffon/src/gecko-dev-042b84af6020b1f2d8029a0dc36ac5955b7f325f/toolkit/modules/AppConstants.jsm"
});
