Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _fuzzaldrin = require('fuzzaldrin');

var SymbolsView = (function () {
  _createClass(SymbolsView, null, [{
    key: 'highlightMatches',
    value: function highlightMatches(context, name, matches, offsetIndex) {
      if (!offsetIndex) {
        offsetIndex = 0;
      }
      var lastIndex = 0;
      var matchedChars = []; // Build up a set of matched chars to be more semantic
      var fragment = document.createDocumentFragment();

      for (var matchIndex of Array.from(matches)) {
        matchIndex -= offsetIndex;
        if (matchIndex < 0) {
          continue; // If marking up the basename, omit name matches
        }
        var unmatched = name.substring(lastIndex, matchIndex);
        if (unmatched) {
          if (matchedChars.length) {
            var span = document.createElement('span');
            span.classList.add('character-match');
            span.textContent = matchedChars.join('');
            fragment.appendChild(span);
          }
          matchedChars = [];
          fragment.appendChild(document.createTextNode(unmatched));
        }
        matchedChars.push(name[matchIndex]);
        lastIndex = matchIndex + 1;
      }

      if (matchedChars.length) {
        var span = document.createElement('span');
        span.classList.add('character-match');
        span.textContent = matchedChars.join('');
        fragment.appendChild(span);
      }

      // Remaining characters are plain text
      fragment.appendChild(document.createTextNode(name.substring(lastIndex)));

      return fragment;
    }
  }]);

  function SymbolsView(stack) {
    var emptyMessage = arguments.length <= 1 || arguments[1] === undefined ? 'No symbols found' : arguments[1];
    var maxResults = arguments.length <= 2 || arguments[2] === undefined ? null : arguments[2];

    _classCallCheck(this, SymbolsView);

    this.stack = stack;
    this.selectListView = new _atomSelectList2['default']({
      maxResults: maxResults,
      emptyMessage: emptyMessage,
      items: [],
      filterKeyForItem: function filterKeyForItem(item) {
        return item.name;
      },
      elementForItem: this.elementForItem.bind(this),
      didChangeSelection: this.didChangeSelection.bind(this),
      didConfirmSelection: this.didConfirmSelection.bind(this),
      didConfirmEmptySelection: this.didConfirmEmptySelection.bind(this),
      didCancelSelection: this.didCancelSelection.bind(this)
    });
    this.element = this.selectListView.element;
    this.element.classList.add('symbols-view');
    this.panel = atom.workspace.addModalPanel({ item: this, visible: false });
  }

  _createClass(SymbolsView, [{
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      yield this.cancel();
      this.panel.destroy();
      return this.selectListView.destroy();
    })
  }, {
    key: 'getFilterKey',
    value: function getFilterKey() {
      return 'name';
    }
  }, {
    key: 'elementForItem',
    value: function elementForItem(_ref) {
      var position = _ref.position;
      var name = _ref.name;
      var file = _ref.file;
      var directory = _ref.directory;

      // Style matched characters in search results
      var matches = (0, _fuzzaldrin.match)(name, this.selectListView.getFilterQuery());

      if (atom.project.getPaths().length > 1) {
        file = _path2['default'].join(_path2['default'].basename(directory), file);
      }

      var li = document.createElement('li');
      li.classList.add('two-lines');

      var primaryLine = document.createElement('div');
      primaryLine.classList.add('primary-line');
      if (position) {
        primaryLine.textContent = name + ':' + (position.row + 1);
      } else {
        primaryLine.appendChild(SymbolsView.highlightMatches(this, name, matches));
      }
      li.appendChild(primaryLine);

      var secondaryLine = document.createElement('div');
      secondaryLine.classList.add('secondary-line');
      secondaryLine.textContent = file;
      li.appendChild(secondaryLine);

      return li;
    }
  }, {
    key: 'cancel',
    value: _asyncToGenerator(function* () {
      if (!this.isCanceling) {
        this.isCanceling = true;
        yield this.selectListView.update({ items: [] });
        this.panel.hide();
        if (this.previouslyFocusedElement) {
          this.previouslyFocusedElement.focus();
          this.previouslyFocusedElement = null;
        }
        this.isCanceling = false;
      }
    })
  }, {
    key: 'didCancelSelection',
    value: function didCancelSelection() {
      this.cancel();
    }
  }, {
    key: 'didConfirmEmptySelection',
    value: function didConfirmEmptySelection() {
      this.cancel();
    }
  }, {
    key: 'didConfirmSelection',
    value: _asyncToGenerator(function* (tag) {
      var _this = this;

      if (tag.file && !_fsPlus2['default'].isFileSync(_path2['default'].join(tag.directory, tag.file))) {
        yield this.selectListView.update({ errorMessage: 'Selected file does not exist' });
        setTimeout(function () {
          _this.selectListView.update({ errorMessage: null });
        }, 2000);
      } else {
        yield this.cancel();
        this.openTag(tag);
      }
    })
  }, {
    key: 'didChangeSelection',
    value: function didChangeSelection(tag) {
      // no-op
    }
  }, {
    key: 'openTag',
    value: function openTag(tag) {
      var _this2 = this;

      var editor = atom.workspace.getActiveTextEditor();
      var previous = undefined;
      if (editor) {
        previous = {
          editorId: editor.id,
          position: editor.getCursorBufferPosition(),
          file: editor.getURI()
        };
      }

      var position = tag.position;

      if (!position) {
        position = this.getTagLine(tag);
      }
      if (tag.file) {
        atom.workspace.open(_path2['default'].join(tag.directory, tag.file)).then(function () {
          if (position) {
            return _this2.moveToPosition(position);
          }
          return undefined;
        });
      } else if (position && previous && !previous.position.isEqual(position)) {
        this.moveToPosition(position);
      }

      this.stack.push(previous);
    }
  }, {
    key: 'moveToPosition',
    value: function moveToPosition(position, beginningOfLine) {
      var editor = atom.workspace.getActiveTextEditor();
      if (beginningOfLine == null) {
        beginningOfLine = true;
      }
      if (editor) {
        editor.setCursorBufferPosition(position, { autoscroll: false });
        if (beginningOfLine) {
          editor.moveToFirstCharacterOfLine();
        }
        editor.scrollToCursorPosition({ center: true });
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      this.panel.show();
      this.selectListView.reset();
      this.selectListView.focus();
    }
  }, {
    key: 'getTagLine',
    value: function getTagLine(tag) {
      if (!tag) {
        return undefined;
      }

      if (tag.lineNumber) {
        return new _atom.Point(tag.lineNumber - 1, 0);
      }

      // Remove leading /^ and trailing $/
      if (!tag.pattern) {
        return undefined;
      }
      var pattern = tag.pattern.replace(/(^\/\^)|(\$\/$)/g, '').trim();

      if (!pattern) {
        return undefined;
      }
      var file = _path2['default'].join(tag.directory, tag.file);
      if (!_fsPlus2['default'].isFileSync(file)) {
        return undefined;
      }
      var iterable = _fsPlus2['default'].readFileSync(file, 'utf8').split('\n');
      for (var index = 0; index < iterable.length; index++) {
        var line = iterable[index];
        if (pattern === line.trim()) {
          return new _atom.Point(index, 0);
        }
      }

      return undefined;
    }
  }]);

  return SymbolsView;
})();

exports['default'] = SymbolsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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