"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InitDialog extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'init', 'cancel', 'editorRef', 'setInitEnablement');
    this.state = {
      initDisabled: false
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.initPath || this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.projectPathElement) {
      setTimeout(() => this.projectPathElement.focus());
    }
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Dialog github-Init modal"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-Init"
    }, _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.init
    })), _react["default"].createElement("main", {
      className: "github-DialogInputs"
    }, _react["default"].createElement("label", {
      className: "github-DialogLabel github-ProjectPath"
    }, "Initialize git repository in directory", _react["default"].createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRef(),
      tabIndex: "2"
    }))), _react["default"].createElement("div", {
      className: "github-DialogButtons"
    }, _react["default"].createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react["default"].createElement("button", {
      className: "btn btn-primary icon icon-repo-create",
      onClick: this.init,
      disabled: this.state.initDisabled,
      tabIndex: "4"
    }, "Init")));
  }

  init() {
    if (this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  editorRef() {
    return element => {
      if (!element) {
        return;
      }

      this.projectPathElement = element;
      const editor = element.getModel();

      if (this.projectPathEditor !== editor) {
        this.projectPathEditor = editor;

        if (this.projectPathSubs) {
          this.projectPathSubs.dispose();
          this.subs.remove(this.projectPathSubs);
        }

        this.projectPathSubs = editor.onDidChange(this.setInitEnablement);
        this.subs.add(this.projectPathSubs);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setInitEnablement() {
    this.setState({
      initDisabled: this.getProjectPath().length === 0
    });
  }

}

exports["default"] = InitDialog;

_defineProperty(InitDialog, "propTypes", {
  config: _propTypes["default"].object.isRequired,
  commandRegistry: _propTypes["default"].object.isRequired,
  didAccept: _propTypes["default"].func,
  didCancel: _propTypes["default"].func,
  initPath: _propTypes["default"].string
});

_defineProperty(InitDialog, "defaultProps", {
  didAccept: () => {},
  didCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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