"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _loadingView = _interopRequireDefault(require("./loading-view"));

var _remoteSelectorView = _interopRequireDefault(require("./remote-selector-view"));

var _remoteContainer = _interopRequireDefault(require("../containers/remote-container"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabView extends _react["default"].Component {
  render() {
    return _react["default"].createElement("div", {
      className: "github-GitHub",
      ref: this.props.rootHolder.setter
    }, _react["default"].createElement("div", {
      className: "github-GitHub-content"
    }, this.renderRemote()));
  }

  renderRemote() {
    if (this.props.isLoading) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    if (this.props.currentRemote.isPresent()) {
      // Single, chosen or unambiguous remote
      return _react["default"].createElement(_remoteContainer["default"], {
        loginModel: this.props.loginModel,
        endpoint: this.props.currentRemote.getEndpoint(),
        remoteOperationObserver: this.props.remoteOperationObserver,
        pushInProgress: this.props.pushInProgress,
        workingDirectory: this.props.workingDirectory,
        workspace: this.props.workspace,
        remote: this.props.currentRemote,
        remotes: this.props.remotes,
        branches: this.props.branches,
        aheadCount: this.props.aheadCount,
        onPushBranch: () => this.props.handlePushBranch(this.props.currentBranch, this.props.currentRemote)
      });
    }

    if (this.props.manyRemotesAvailable) {
      // No chosen remote, multiple remotes hosted on GitHub instances
      return _react["default"].createElement(_remoteSelectorView["default"], {
        remotes: this.props.remotes,
        currentBranch: this.props.currentBranch,
        selectRemote: this.props.handleRemoteSelect
      });
    } // No remotes available
    // TODO: display a view that lets you create a repository on GitHub


    return _react["default"].createElement("div", {
      className: "github-GitHub-noRemotes"
    }, _react["default"].createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mark-github"
    }), _react["default"].createElement("h1", null, "No Remotes"), _react["default"].createElement("div", {
      className: "initialize-repo-description"
    }, _react["default"].createElement("span", null, "This repository does not have any remotes hosted at GitHub.com.")));
  }

}

exports["default"] = GitHubTabView;

_defineProperty(GitHubTabView, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  branches: _propTypes2.BranchSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  currentRemote: _propTypes2.RemotePropType.isRequired,
  manyRemotesAvailable: _propTypes["default"].bool.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  handlePushBranch: _propTypes["default"].func.isRequired,
  handleRemoteSelect: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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