"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/resolveReviewThreadMutation.graphql");

  if (node.hash && node.hash !== "6947ef6710d494dc52fba1a5b532cd76") {
    console.error("The definition of 'resolveReviewThreadMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/resolveReviewThreadMutation.graphql");
};

var _default = (environment, {
  threadID,
  viewerID,
  viewerLogin
}) => {
  const variables = {
    input: {
      threadId: threadID
    }
  };
  const optimisticResponse = {
    resolveReviewThread: {
      thread: {
        id: threadID,
        isResolved: true,
        viewerCanResolve: false,
        viewerCanUnresolve: true,
        resolvedBy: {
          id: viewerID,
          login: viewerLogin || 'you'
        }
      }
    }
  };
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticResponse,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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