"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/deletePrReviewMutation.graphql");

  if (node.hash && node.hash !== "768b81334e225cb5d15c0508d2bd4b1f") {
    console.error("The definition of 'deletePrReviewMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/deletePrReviewMutation.graphql");
};

var _default = (environment, {
  reviewID,
  pullRequestID
}) => {
  const variables = {
    input: {
      pullRequestReviewId: reviewID
    }
  };
  const configs = [{
    type: 'NODE_DELETE',
    deletedIDFieldName: 'id'
  }, {
    type: 'RANGE_DELETE',
    parentID: pullRequestID,
    connectionKeys: [{
      key: 'ReviewSummariesAccumulator_reviews'
    }],
    pathToConnection: ['pullRequest', 'reviews'],
    deletedIDFieldName: 'id'
  }];
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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