"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCommentDecorationsController = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _reactRelay = require("react-relay");

var _path = _interopRequireDefault(require("path"));

var _editorCommentDecorationsController = _interopRequireDefault(require("./editor-comment-decorations-controller"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _gutter = _interopRequireDefault(require("../atom/gutter"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommentDecorationsController extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "updateOpenEditors", () => {
      return new Promise(resolve => {
        this.setState({
          openEditors: this.props.workspace.getTextEditors()
        }, resolve);
      });
    });

    _defineProperty(this, "openReviewsTab", () => {
      const [pullRequest] = this.props.pullRequests;
      /* istanbul ignore if */

      if (!pullRequest) {
        return null;
      }

      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: pullRequest.number,
        workdir: this.props.repoData.workingDirectoryPath
      });

      return this.props.workspace.open(uri, {
        searchAllPanes: true
      });
    });

    this.subscriptions = new _eventKit.CompositeDisposable();
    this.state = {
      openEditors: this.props.workspace.getTextEditors()
    };
  }

  componentDidMount() {
    this.subscriptions.add(this.props.workspace.observeTextEditors(this.updateOpenEditors), this.props.workspace.onDidDestroyPaneItem(this.updateOpenEditors));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  render() {
    if (this.props.pullRequests.length === 0) {
      return null;
    }

    const pullRequest = this.props.pullRequests[0]; // only show comment decorations if we're on a checked out pull request
    // otherwise, we'd have no way of knowing which comments to show.

    if (!this.isCheckedOutPullRequest(this.props.repoData.branches, this.props.repoData.remotes, pullRequest)) {
      return null;
    }

    const threadDataByPath = new Map();
    const workdirPath = this.props.repoData.workingDirectoryPath;

    for (const _ref of this.props.commentThreads) {
      const {
        comments,
        thread
      } = _ref;

      // Skip comment threads that are entirely minimized.
      if (comments.every(comment => comment.isMinimized)) {
        continue;
      } // There may be multiple comments in the thread, but we really only care about the root comment when rendering
      // decorations.


      const threadData = {
        rootCommentID: comments[0].id,
        threadID: thread.id,
        position: comments[0].position,
        nativeRelPath: (0, _helpers.toNativePathSep)(comments[0].path),
        fullPath: _path["default"].join(workdirPath, (0, _helpers.toNativePathSep)(comments[0].path))
      };

      if (threadDataByPath.get(threadData.fullPath)) {
        threadDataByPath.get(threadData.fullPath).push(threadData);
      } else {
        threadDataByPath.set(threadData.fullPath, [threadData]);
      }
    }

    const openEditorsWithCommentThreads = this.getOpenEditorsWithCommentThreads(threadDataByPath);
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: "atom-workspace"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:open-reviews-tab",
      callback: this.openReviewsTab
    })), openEditorsWithCommentThreads.map(editor => {
      const threadData = threadDataByPath.get(editor.getPath());
      const translations = this.props.commentTranslations.get(threadData[0].nativeRelPath);
      return _react["default"].createElement(_react.Fragment, {
        key: `github-editor-decoration-${editor.id}`
      }, _react["default"].createElement(_gutter["default"], {
        name: "github-comment-icon",
        priority: 1,
        className: "comment",
        editor: editor,
        type: "decorated"
      }), _react["default"].createElement(_editorCommentDecorationsController["default"], {
        endpoint: this.props.endpoint,
        owner: this.props.owner,
        repo: this.props.repo,
        number: pullRequest.number,
        workdir: workdirPath,
        workspace: this.props.workspace,
        editor: editor,
        fileName: editor.getPath(),
        headSha: pullRequest.headRefOid,
        threadsForPath: threadData,
        commentTranslationsForPath: translations
      }));
    }));
  }

  getOpenEditorsWithCommentThreads(threadDataByPath) {
    const haveThreads = [];

    for (const editor of this.state.openEditors) {
      if (threadDataByPath.has(editor.getPath())) {
        haveThreads.push(editor);
      }
    }

    return haveThreads;
  } // Determine if we already have this PR checked out.
  // todo: if this is similar enough to pr-checkout-controller, extract a single
  // helper function to do this check.


  isCheckedOutPullRequest(branches, remotes, pullRequest) {
    // determine if pullRequest.headRepository is null
    // this can happen if a repository has been deleted.
    if (!pullRequest.headRepository) {
      return false;
    }

    const {
      repository
    } = pullRequest;
    const headPush = branches.getHeadBranch().getPush();
    const headRemote = remotes.withName(headPush.getRemoteName()); // (detect checkout from pull/### refspec)

    const fromPullRefspec = headRemote.getOwner() === repository.owner.login && headRemote.getRepo() === repository.name && headPush.getShortRemoteRef() === `pull/${pullRequest.number}/head`; // (detect checkout from head repository)

    const fromHeadRepo = headRemote.getOwner() === pullRequest.headRepository.owner.login && headRemote.getRepo() === pullRequest.headRepository.name && headPush.getShortRemoteRef() === pullRequest.headRefName;

    if (fromPullRefspec || fromHeadRepo) {
      return true;
    }

    return false;
  }

}

exports.BareCommentDecorationsController = BareCommentDecorationsController;

_defineProperty(BareCommentDecorationsController, "propTypes", {
  // Relay response
  relay: _propTypes["default"].object.isRequired,
  pullRequests: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    number: _propTypes["default"].number.isRequired,
    headRefName: _propTypes["default"].string.isRequired,
    headRefOid: _propTypes["default"].string.isRequired,
    headRepository: _propTypes["default"].shape({
      name: _propTypes["default"].string.isRequired,
      owner: _propTypes["default"].shape({
        login: _propTypes["default"].string.isRequired
      }).isRequired
    }),
    repository: _propTypes["default"].shape({
      name: _propTypes["default"].string.isRequired,
      owner: _propTypes["default"].shape({
        login: _propTypes["default"].string.isRequired
      }).isRequired
    }).isRequired
  })),
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  // Models
  repoData: _propTypes["default"].shape({
    branches: _propTypes2.BranchSetPropType.isRequired,
    remotes: _propTypes2.RemoteSetPropType.isRequired,
    currentRemote: _propTypes2.RemotePropType.isRequired,
    workingDirectoryPath: _propTypes["default"].string.isRequired
  }).isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
    thread: _propTypes["default"].shape({
      id: _propTypes["default"].string.isRequired
    }).isRequired
  })).isRequired,
  commentTranslations: _propTypes["default"].shape({
    get: _propTypes["default"].func.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommentDecorationsController, {
  pullRequests: function () {
    const node = require("./__generated__/commentDecorationsController_pullRequests.graphql");

    if (node.hash && node.hash !== "62f96ccd13dfc2649112a7b4afaf4ba2") {
      console.error("The definition of 'commentDecorationsController_pullRequests' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commentDecorationsController_pullRequests.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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