"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _os = _interopRequireDefault(require("os"));

var _helpers = require("./helpers");

var _asyncQueue = _interopRequireDefault(require("./async-queue"));

var _gitShellOutStrategy = _interopRequireDefault(require("./git-shell-out-strategy"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = {
  create(workingDir, options = {}) {
    return this.withStrategies([_gitShellOutStrategy["default"]])(workingDir, options);
  },

  withStrategies(strategies) {
    return function createForStrategies(workingDir, options = {}) {
      const parallelism = options.parallelism || Math.max(3, _os["default"].cpus().length);
      const commandQueue = new _asyncQueue["default"]({
        parallelism
      });

      const strategyOptions = _objectSpread({}, options, {
        queue: commandQueue
      });

      const strategyInstances = strategies.map(Strategy => new Strategy(workingDir, strategyOptions));
      return (0, _helpers.firstImplementer)(...strategyInstances);
    };
  }

};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbXBvc2l0ZS1naXQtc3RyYXRlZ3kuanMiXSwibmFtZXMiOlsiY3JlYXRlIiwid29ya2luZ0RpciIsIm9wdGlvbnMiLCJ3aXRoU3RyYXRlZ2llcyIsIkdpdFNoZWxsT3V0U3RyYXRlZ3kiLCJzdHJhdGVnaWVzIiwiY3JlYXRlRm9yU3RyYXRlZ2llcyIsInBhcmFsbGVsaXNtIiwiTWF0aCIsIm1heCIsIm9zIiwiY3B1cyIsImxlbmd0aCIsImNvbW1hbmRRdWV1ZSIsIkFzeW5jUXVldWUiLCJzdHJhdGVneU9wdGlvbnMiLCJxdWV1ZSIsInN0cmF0ZWd5SW5zdGFuY2VzIiwibWFwIiwiU3RyYXRlZ3kiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFFQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7ZUFFZTtBQUNiQSxFQUFBQSxNQUFNLENBQUNDLFVBQUQsRUFBYUMsT0FBTyxHQUFHLEVBQXZCLEVBQTJCO0FBQy9CLFdBQU8sS0FBS0MsY0FBTCxDQUFvQixDQUFDQywrQkFBRCxDQUFwQixFQUEyQ0gsVUFBM0MsRUFBdURDLE9BQXZELENBQVA7QUFDRCxHQUhZOztBQUtiQyxFQUFBQSxjQUFjLENBQUNFLFVBQUQsRUFBYTtBQUN6QixXQUFPLFNBQVNDLG1CQUFULENBQTZCTCxVQUE3QixFQUF5Q0MsT0FBTyxHQUFHLEVBQW5ELEVBQXVEO0FBQzVELFlBQU1LLFdBQVcsR0FBR0wsT0FBTyxDQUFDSyxXQUFSLElBQXVCQyxJQUFJLENBQUNDLEdBQUwsQ0FBUyxDQUFULEVBQVlDLGVBQUdDLElBQUgsR0FBVUMsTUFBdEIsQ0FBM0M7QUFDQSxZQUFNQyxZQUFZLEdBQUcsSUFBSUMsc0JBQUosQ0FBZTtBQUFDUCxRQUFBQTtBQUFELE9BQWYsQ0FBckI7O0FBQ0EsWUFBTVEsZUFBZSxxQkFBT2IsT0FBUDtBQUFnQmMsUUFBQUEsS0FBSyxFQUFFSDtBQUF2QixRQUFyQjs7QUFFQSxZQUFNSSxpQkFBaUIsR0FBR1osVUFBVSxDQUFDYSxHQUFYLENBQWVDLFFBQVEsSUFBSSxJQUFJQSxRQUFKLENBQWFsQixVQUFiLEVBQXlCYyxlQUF6QixDQUEzQixDQUExQjtBQUNBLGFBQU8sK0JBQWlCLEdBQUdFLGlCQUFwQixDQUFQO0FBQ0QsS0FQRDtBQVFEOztBQWRZLEMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zOS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBvcyBmcm9tICdvcyc7XG5cbmltcG9ydCB7Zmlyc3RJbXBsZW1lbnRlcn0gZnJvbSAnLi9oZWxwZXJzJztcbmltcG9ydCBBc3luY1F1ZXVlIGZyb20gJy4vYXN5bmMtcXVldWUnO1xuaW1wb3J0IEdpdFNoZWxsT3V0U3RyYXRlZ3kgZnJvbSAnLi9naXQtc2hlbGwtb3V0LXN0cmF0ZWd5JztcblxuZXhwb3J0IGRlZmF1bHQge1xuICBjcmVhdGUod29ya2luZ0Rpciwgb3B0aW9ucyA9IHt9KSB7XG4gICAgcmV0dXJuIHRoaXMud2l0aFN0cmF0ZWdpZXMoW0dpdFNoZWxsT3V0U3RyYXRlZ3ldKSh3b3JraW5nRGlyLCBvcHRpb25zKTtcbiAgfSxcblxuICB3aXRoU3RyYXRlZ2llcyhzdHJhdGVnaWVzKSB7XG4gICAgcmV0dXJuIGZ1bmN0aW9uIGNyZWF0ZUZvclN0cmF0ZWdpZXMod29ya2luZ0Rpciwgb3B0aW9ucyA9IHt9KSB7XG4gICAgICBjb25zdCBwYXJhbGxlbGlzbSA9IG9wdGlvbnMucGFyYWxsZWxpc20gfHwgTWF0aC5tYXgoMywgb3MuY3B1cygpLmxlbmd0aCk7XG4gICAgICBjb25zdCBjb21tYW5kUXVldWUgPSBuZXcgQXN5bmNRdWV1ZSh7cGFyYWxsZWxpc219KTtcbiAgICAgIGNvbnN0IHN0cmF0ZWd5T3B0aW9ucyA9IHsuLi5vcHRpb25zLCBxdWV1ZTogY29tbWFuZFF1ZXVlfTtcblxuICAgICAgY29uc3Qgc3RyYXRlZ3lJbnN0YW5jZXMgPSBzdHJhdGVnaWVzLm1hcChTdHJhdGVneSA9PiBuZXcgU3RyYXRlZ3kod29ya2luZ0Rpciwgc3RyYXRlZ3lPcHRpb25zKSk7XG4gICAgICByZXR1cm4gZmlyc3RJbXBsZW1lbnRlciguLi5zdHJhdGVneUluc3RhbmNlcyk7XG4gICAgfTtcbiAgfSxcbn07XG4iXX0=