function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var assert = require('assert');
var fs = require('fs');
var sinon = require('sinon');
var path = require('path');

var dalek = require('../lib/dalek');

describe('dalek', function () {
  describe('enumerate', function () {
    var availablePackages = {};
    var realPaths = {};
    var bundledPackages = [];
    var packageDirPaths = [];
    var sandbox = null;

    beforeEach(function () {
      availablePackages = {
        'an-unduplicated-installed-package': path.join('Users', 'username', '.atom', 'packages', 'an-unduplicated-installed-package'),
        'duplicated-package': path.join('Users', 'username', '.atom', 'packages', 'duplicated-package'),
        'unduplicated-package': path.join('' + atom.getLoadSettings().resourcePath, 'node_modules', 'unduplicated-package')
      };

      atom.devMode = false;
      bundledPackages = ['duplicated-package', 'unduplicated-package'];
      packageDirPaths = [path.join('Users', 'username', '.atom', 'packages')];
      sandbox = sinon.sandbox.create();
      sandbox.stub(dalek, 'realpath').callsFake(function (filePath) {
        return Promise.resolve(realPaths[filePath] || filePath);
      });
      sandbox.stub(atom.packages, 'isBundledPackage').callsFake(function (packageName) {
        return bundledPackages.includes(packageName);
      });
      sandbox.stub(atom.packages, 'getAvailablePackageNames').callsFake(function () {
        return Object.keys(availablePackages);
      });
      sandbox.stub(atom.packages, 'getPackageDirPaths').callsFake(function () {
        return packageDirPaths;
      });
      sandbox.stub(fs, 'existsSync').callsFake(function (candidate) {
        return Object.values(availablePackages).includes(candidate) && !candidate.includes(atom.getLoadSettings().resourcePath);
      });
    });

    afterEach(function () {
      sandbox.restore();
    });

    it('returns a list of duplicate names', _asyncToGenerator(function* () {
      assert.deepEqual((yield dalek.enumerate()), ['duplicated-package']);
    }));

    describe('when in dev mode', function () {
      beforeEach(function () {
        atom.devMode = true;
      });

      it('always returns an empty list', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    });

    describe('when a package is symlinked into the package directory', _asyncToGenerator(function* () {
      beforeEach(function () {
        var realPath = path.join('Users', 'username', 'duplicated-package');
        var packagePath = path.join('Users', 'username', '.atom', 'packages', 'duplicated-package');
        realPaths[packagePath] = realPath;
      });

      it('is not included in the list of duplicate names', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    }));
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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