# coding: us-ascii
# frozen_string_literal: true

# automatically generated by template/unicode_norm_gen.tmpl

module UnicodeNormalize  # :nodoc:
  accents = "" \
    "[\u0300-\u034E" \
    "\u0350-\u036F" \
    "\u0483-\u0487" \
    "\u0591-\u05BD" \
    "\u05BF" \
    "\u05C1\u05C2" \
    "\u05C4\u05C5" \
    "\u05C7" \
    "\u0610-\u061A" \
    "\u064B-\u065F" \
    "\u0670" \
    "\u06D6-\u06DC" \
    "\u06DF-\u06E4" \
    "\u06E7\u06E8" \
    "\u06EA-\u06ED" \
    "\u0711" \
    "\u0730-\u074A" \
    "\u07EB-\u07F3" \
    "\u07FD" \
    "\u0816-\u0819" \
    "\u081B-\u0823" \
    "\u0825-\u0827" \
    "\u0829-\u082D" \
    "\u0859-\u085B" \
    "\u08D3-\u08E1" \
    "\u08E3-\u08FF" \
    "\u093C" \
    "\u094D" \
    "\u0951-\u0954" \
    "\u09BC" \
    "\u09BE" \
    "\u09CD" \
    "\u09D7" \
    "\u09FE" \
    "\u0A3C" \
    "\u0A4D" \
    "\u0ABC" \
    "\u0ACD" \
    "\u0B3C" \
    "\u0B3E" \
    "\u0B4D" \
    "\u0B56\u0B57" \
    "\u0BBE" \
    "\u0BCD" \
    "\u0BD7" \
    "\u0C4D" \
    "\u0C55\u0C56" \
    "\u0CBC" \
    "\u0CC2" \
    "\u0CCD" \
    "\u0CD5\u0CD6" \
    "\u0D3B\u0D3C" \
    "\u0D3E" \
    "\u0D4D" \
    "\u0D57" \
    "\u0DCA" \
    "\u0DCF" \
    "\u0DDF" \
    "\u0E38-\u0E3A" \
    "\u0E48-\u0E4B" \
    "\u0EB8-\u0EBA" \
    "\u0EC8-\u0ECB" \
    "\u0F18\u0F19" \
    "\u0F35" \
    "\u0F37" \
    "\u0F39" \
    "\u0F71\u0F72" \
    "\u0F74" \
    "\u0F7A-\u0F7D" \
    "\u0F80" \
    "\u0F82-\u0F84" \
    "\u0F86\u0F87" \
    "\u0FC6" \
    "\u102E" \
    "\u1037" \
    "\u1039\u103A" \
    "\u108D" \
    "\u135D-\u135F" \
    "\u1714" \
    "\u1734" \
    "\u17D2" \
    "\u17DD" \
    "\u18A9" \
    "\u1939-\u193B" \
    "\u1A17\u1A18" \
    "\u1A60" \
    "\u1A75-\u1A7C" \
    "\u1A7F" \
    "\u1AB0-\u1ABD" \
    "\u1B34\u1B35" \
    "\u1B44" \
    "\u1B6B-\u1B73" \
    "\u1BAA\u1BAB" \
    "\u1BE6" \
    "\u1BF2\u1BF3" \
    "\u1C37" \
    "\u1CD0-\u1CD2" \
    "\u1CD4-\u1CE0" \
    "\u1CE2-\u1CE8" \
    "\u1CED" \
    "\u1CF4" \
    "\u1CF8\u1CF9" \
    "\u1DC0-\u1DF9" \
    "\u1DFB-\u1DFF" \
    "\u20D0-\u20DC" \
    "\u20E1" \
    "\u20E5-\u20F0" \
    "\u2CEF-\u2CF1" \
    "\u2D7F" \
    "\u2DE0-\u2DFF" \
    "\u302A-\u302F" \
    "\u3099\u309A" \
    "\uA66F" \
    "\uA674-\uA67D" \
    "\uA69E\uA69F" \
    "\uA6F0\uA6F1" \
    "\uA806" \
    "\uA8C4" \
    "\uA8E0-\uA8F1" \
    "\uA92B-\uA92D" \
    "\uA953" \
    "\uA9B3" \
    "\uA9C0" \
    "\uAAB0" \
    "\uAAB2-\uAAB4" \
    "\uAAB7\uAAB8" \
    "\uAABE\uAABF" \
    "\uAAC1" \
    "\uAAF6" \
    "\uABED" \
    "\uFB1E" \
    "\uFE20-\uFE2F" \
    "\u{101FD}" \
    "\u{102E0}" \
    "\u{10376}-\u{1037A}" \
    "\u{10A0D}" \
    "\u{10A0F}" \
    "\u{10A38}-\u{10A3A}" \
    "\u{10A3F}" \
    "\u{10AE5}\u{10AE6}" \
    "\u{10D24}-\u{10D27}" \
    "\u{10F46}-\u{10F50}" \
    "\u{11046}" \
    "\u{1107F}" \
    "\u{110B9}\u{110BA}" \
    "\u{11100}-\u{11102}" \
    "\u{11127}" \
    "\u{11133}\u{11134}" \
    "\u{11173}" \
    "\u{111C0}" \
    "\u{111CA}" \
    "\u{11235}\u{11236}" \
    "\u{112E9}\u{112EA}" \
    "\u{1133B}\u{1133C}" \
    "\u{1133E}" \
    "\u{1134D}" \
    "\u{11357}" \
    "\u{11366}-\u{1136C}" \
    "\u{11370}-\u{11374}" \
    "\u{11442}" \
    "\u{11446}" \
    "\u{1145E}" \
    "\u{114B0}" \
    "\u{114BA}" \
    "\u{114BD}" \
    "\u{114C2}\u{114C3}" \
    "\u{115AF}" \
    "\u{115BF}\u{115C0}" \
    "\u{1163F}" \
    "\u{116B6}\u{116B7}" \
    "\u{1172B}" \
    "\u{11839}\u{1183A}" \
    "\u{119E0}" \
    "\u{11A34}" \
    "\u{11A47}" \
    "\u{11A99}" \
    "\u{11C3F}" \
    "\u{11D42}" \
    "\u{11D44}\u{11D45}" \
    "\u{11D97}" \
    "\u{16AF0}-\u{16AF4}" \
    "\u{16B30}-\u{16B36}" \
    "\u{1BC9E}" \
    "\u{1D165}-\u{1D169}" \
    "\u{1D16D}-\u{1D172}" \
    "\u{1D17B}-\u{1D182}" \
    "\u{1D185}-\u{1D18B}" \
    "\u{1D1AA}-\u{1D1AD}" \
    "\u{1D242}-\u{1D244}" \
    "\u{1E000}-\u{1E006}" \
    "\u{1E008}-\u{1E018}" \
    "\u{1E01B}-\u{1E021}" \
    "\u{1E023}\u{1E024}" \
    "\u{1E026}-\u{1E02A}" \
    "\u{1E130}-\u{1E136}" \
    "\u{1E2EC}-\u{1E2EF}" \
    "\u{1E8D0}-\u{1E8D6}" \
    "\u{1E944}-\u{1E94A}" \
    "]"
  ACCENTS = accents
  REGEXP_D_STRING = "#{''  # composition starters and composition exclusions
    }" \
    "[\u00C0-\u00C5" \
    "\u00C7-\u00CF" \
    "\u00D1-\u00D6" \
    "\u00D9-\u00DD" \
    "\u00E0-\u00E5" \
    "\u00E7-\u00EF" \
    "\u00F1-\u00F6" \
    "\u00F9-\u00FD" \
    "\u00FF-\u010F" \
    "\u0112-\u0125" \
    "\u0128-\u0130" \
    "\u0134-\u0137" \
    "\u0139-\u013E" \
    "\u0143-\u0148" \
    "\u014C-\u0151" \
    "\u0154-\u0165" \
    "\u0168-\u017E" \
    "\u01A0\u01A1" \
    "\u01AF\u01B0" \
    "\u01CD-\u01DC" \
    "\u01DE-\u01E3" \
    "\u01E6-\u01F0" \
    "\u01F4\u01F5" \
    "\u01F8-\u021B" \
    "\u021E\u021F" \
    "\u0226-\u0233" \
    "\u0340\u0341" \
    "\u0343\u0344" \
    "\u0374" \
    "\u037E" \
    "\u0385-\u038A" \
    "\u038C" \
    "\u038E-\u0390" \
    "\u03AA-\u03B0" \
    "\u03CA-\u03CE" \
    "\u03D3\u03D4" \
    "\u0400\u0401" \
    "\u0403" \
    "\u0407" \
    "\u040C-\u040E" \
    "\u0419" \
    "\u0439" \
    "\u0450\u0451" \
    "\u0453" \
    "\u0457" \
    "\u045C-\u045E" \
    "\u0476\u0477" \
    "\u04C1\u04C2" \
    "\u04D0-\u04D3" \
    "\u04D6\u04D7" \
    "\u04DA-\u04DF" \
    "\u04E2-\u04E7" \
    "\u04EA-\u04F5" \
    "\u04F8\u04F9" \
    "\u0622-\u0626" \
    "\u06C0" \
    "\u06C2" \
    "\u06D3" \
    "\u0929" \
    "\u0931" \
    "\u0934" \
    "\u0958-\u095F" \
    "\u09CB\u09CC" \
    "\u09DC\u09DD" \
    "\u09DF" \
    "\u0A33" \
    "\u0A36" \
    "\u0A59-\u0A5B" \
    "\u0A5E" \
    "\u0B48" \
    "\u0B4B\u0B4C" \
    "\u0B5C\u0B5D" \
    "\u0B94" \
    "\u0BCA-\u0BCC" \
    "\u0C48" \
    "\u0CC0" \
    "\u0CC7\u0CC8" \
    "\u0CCA\u0CCB" \
    "\u0D4A-\u0D4C" \
    "\u0DDA" \
    "\u0DDC-\u0DDE" \
    "\u0F43" \
    "\u0F4D" \
    "\u0F52" \
    "\u0F57" \
    "\u0F5C" \
    "\u0F69" \
    "\u0F73" \
    "\u0F75\u0F76" \
    "\u0F78" \
    "\u0F81" \
    "\u0F93" \
    "\u0F9D" \
    "\u0FA2" \
    "\u0FA7" \
    "\u0FAC" \
    "\u0FB9" \
    "\u1026" \
    "\u1B06" \
    "\u1B08" \
    "\u1B0A" \
    "\u1B0C" \
    "\u1B0E" \
    "\u1B12" \
    "\u1B3B" \
    "\u1B3D" \
    "\u1B40\u1B41" \
    "\u1B43" \
    "\u1E00-\u1E99" \
    "\u1E9B" \
    "\u1EA0-\u1EF9" \
    "\u1F00-\u1F15" \
    "\u1F18-\u1F1D" \
    "\u1F20-\u1F45" \
    "\u1F48-\u1F4D" \
    "\u1F50-\u1F57" \
    "\u1F59" \
    "\u1F5B" \
    "\u1F5D" \
    "\u1F5F-\u1F7D" \
    "\u1F80-\u1FB4" \
    "\u1FB6-\u1FBC" \
    "\u1FBE" \
    "\u1FC1-\u1FC4" \
    "\u1FC6-\u1FD3" \
    "\u1FD6-\u1FDB" \
    "\u1FDD-\u1FEF" \
    "\u1FF2-\u1FF4" \
    "\u1FF6-\u1FFD" \
    "\u2000\u2001" \
    "\u2126" \
    "\u212A\u212B" \
    "\u219A\u219B" \
    "\u21AE" \
    "\u21CD-\u21CF" \
    "\u2204" \
    "\u2209" \
    "\u220C" \
    "\u2224" \
    "\u2226" \
    "\u2241" \
    "\u2244" \
    "\u2247" \
    "\u2249" \
    "\u2260" \
    "\u2262" \
    "\u226D-\u2271" \
    "\u2274\u2275" \
    "\u2278\u2279" \
    "\u2280\u2281" \
    "\u2284\u2285" \
    "\u2288\u2289" \
    "\u22AC-\u22AF" \
    "\u22E0-\u22E3" \
    "\u22EA-\u22ED" \
    "\u2329\u232A" \
    "\u2ADC" \
    "\u304C" \
    "\u304E" \
    "\u3050" \
    "\u3052" \
    "\u3054" \
    "\u3056" \
    "\u3058" \
    "\u305A" \
    "\u305C" \
    "\u305E" \
    "\u3060" \
    "\u3062" \
    "\u3065" \
    "\u3067" \
    "\u3069" \
    "\u3070\u3071" \
    "\u3073\u3074" \
    "\u3076\u3077" \
    "\u3079\u307A" \
    "\u307C\u307D" \
    "\u3094" \
    "\u309E" \
    "\u30AC" \
    "\u30AE" \
    "\u30B0" \
    "\u30B2" \
    "\u30B4" \
    "\u30B6" \
    "\u30B8" \
    "\u30BA" \
    "\u30BC" \
    "\u30BE" \
    "\u30C0" \
    "\u30C2" \
    "\u30C5" \
    "\u30C7" \
    "\u30C9" \
    "\u30D0\u30D1" \
    "\u30D3\u30D4" \
    "\u30D6\u30D7" \
    "\u30D9\u30DA" \
    "\u30DC\u30DD" \
    "\u30F4" \
    "\u30F7-\u30FA" \
    "\u30FE" \
    "\uF900-\uFA0D" \
    "\uFA10" \
    "\uFA12" \
    "\uFA15-\uFA1E" \
    "\uFA20" \
    "\uFA22" \
    "\uFA25\uFA26" \
    "\uFA2A-\uFA6D" \
    "\uFA70-\uFAD9" \
    "\uFB1D" \
    "\uFB1F" \
    "\uFB2A-\uFB36" \
    "\uFB38-\uFB3C" \
    "\uFB3E" \
    "\uFB40\uFB41" \
    "\uFB43\uFB44" \
    "\uFB46-\uFB4E" \
    "\u{1109A}" \
    "\u{1109C}" \
    "\u{110AB}" \
    "\u{1112E}\u{1112F}" \
    "\u{1134B}\u{1134C}" \
    "\u{114BB}\u{114BC}" \
    "\u{114BE}" \
    "\u{115BA}\u{115BB}" \
    "\u{1D15E}-\u{1D164}" \
    "\u{1D1BB}-\u{1D1C0}" \
    "\u{2F800}-\u{2FA1D}" \
    "]#{accents}*" \
    "|#{''  # characters that can be the result of a composition, except composition starters
    }" \
    "[<->" \
    "A-P" \
    "R-Z" \
    "a-p" \
    "r-z" \
    "\u00A8" \
    "\u00C6" \
    "\u00D8" \
    "\u00E6" \
    "\u00F8" \
    "\u017F" \
    "\u01B7" \
    "\u0292" \
    "\u0391" \
    "\u0395" \
    "\u0397" \
    "\u0399" \
    "\u039F" \
    "\u03A1" \
    "\u03A5" \
    "\u03A9" \
    "\u03B1" \
    "\u03B5" \
    "\u03B7" \
    "\u03B9" \
    "\u03BF" \
    "\u03C1" \
    "\u03C5" \
    "\u03C9" \
    "\u03D2" \
    "\u0406" \
    "\u0410" \
    "\u0413" \
    "\u0415-\u0418" \
    "\u041A" \
    "\u041E" \
    "\u0423" \
    "\u0427" \
    "\u042B" \
    "\u042D" \
    "\u0430" \
    "\u0433" \
    "\u0435-\u0438" \
    "\u043A" \
    "\u043E" \
    "\u0443" \
    "\u0447" \
    "\u044B" \
    "\u044D" \
    "\u0456" \
    "\u0474\u0475" \
    "\u04D8\u04D9" \
    "\u04E8\u04E9" \
    "\u0627" \
    "\u0648" \
    "\u064A" \
    "\u06C1" \
    "\u06D2" \
    "\u06D5" \
    "\u0928" \
    "\u0930" \
    "\u0933" \
    "\u09C7" \
    "\u0B47" \
    "\u0B92" \
    "\u0BC6\u0BC7" \
    "\u0C46" \
    "\u0CBF" \
    "\u0CC6" \
    "\u0D46\u0D47" \
    "\u0DD9" \
    "\u1025" \
    "\u1B05" \
    "\u1B07" \
    "\u1B09" \
    "\u1B0B" \
    "\u1B0D" \
    "\u1B11" \
    "\u1B3A" \
    "\u1B3C" \
    "\u1B3E\u1B3F" \
    "\u1B42" \
    "\u1FBF" \
    "\u1FFE" \
    "\u2190" \
    "\u2192" \
    "\u2194" \
    "\u21D0" \
    "\u21D2" \
    "\u21D4" \
    "\u2203" \
    "\u2208" \
    "\u220B" \
    "\u2223" \
    "\u2225" \
    "\u223C" \
    "\u2243" \
    "\u2245" \
    "\u2248" \
    "\u224D" \
    "\u2261" \
    "\u2264\u2265" \
    "\u2272\u2273" \
    "\u2276\u2277" \
    "\u227A-\u227D" \
    "\u2282\u2283" \
    "\u2286\u2287" \
    "\u2291\u2292" \
    "\u22A2" \
    "\u22A8\u22A9" \
    "\u22AB" \
    "\u22B2-\u22B5" \
    "\u3046" \
    "\u304B" \
    "\u304D" \
    "\u304F" \
    "\u3051" \
    "\u3053" \
    "\u3055" \
    "\u3057" \
    "\u3059" \
    "\u305B" \
    "\u305D" \
    "\u305F" \
    "\u3061" \
    "\u3064" \
    "\u3066" \
    "\u3068" \
    "\u306F" \
    "\u3072" \
    "\u3075" \
    "\u3078" \
    "\u307B" \
    "\u309D" \
    "\u30A6" \
    "\u30AB" \
    "\u30AD" \
    "\u30AF" \
    "\u30B1" \
    "\u30B3" \
    "\u30B5" \
    "\u30B7" \
    "\u30B9" \
    "\u30BB" \
    "\u30BD" \
    "\u30BF" \
    "\u30C1" \
    "\u30C4" \
    "\u30C6" \
    "\u30C8" \
    "\u30CF" \
    "\u30D2" \
    "\u30D5" \
    "\u30D8" \
    "\u30DB" \
    "\u30EF-\u30F2" \
    "\u30FD" \
    "\u{11099}" \
    "\u{1109B}" \
    "\u{110A5}" \
    "\u{11131}\u{11132}" \
    "\u{11347}" \
    "\u{114B9}" \
    "\u{115B8}\u{115B9}" \
    "]?#{accents}+" \
    "|#{''  # precomposed Hangul syllables
    }" \
    "[\u{AC00}-\u{D7A4}]"
  REGEXP_C_STRING = "#{''  # composition exclusions
    }" \
    "[\u0340\u0341" \
    "\u0343\u0344" \
    "\u0374" \
    "\u037E" \
    "\u0387" \
    "\u0958-\u095F" \
    "\u09DC\u09DD" \
    "\u09DF" \
    "\u0A33" \
    "\u0A36" \
    "\u0A59-\u0A5B" \
    "\u0A5E" \
    "\u0B5C\u0B5D" \
    "\u0F43" \
    "\u0F4D" \
    "\u0F52" \
    "\u0F57" \
    "\u0F5C" \
    "\u0F69" \
    "\u0F73" \
    "\u0F75\u0F76" \
    "\u0F78" \
    "\u0F81" \
    "\u0F93" \
    "\u0F9D" \
    "\u0FA2" \
    "\u0FA7" \
    "\u0FAC" \
    "\u0FB9" \
    "\u1F71" \
    "\u1F73" \
    "\u1F75" \
    "\u1F77" \
    "\u1F79" \
    "\u1F7B" \
    "\u1F7D" \
    "\u1FBB" \
    "\u1FBE" \
    "\u1FC9" \
    "\u1FCB" \
    "\u1FD3" \
    "\u1FDB" \
    "\u1FE3" \
    "\u1FEB" \
    "\u1FEE\u1FEF" \
    "\u1FF9" \
    "\u1FFB" \
    "\u1FFD" \
    "\u2000\u2001" \
    "\u2126" \
    "\u212A\u212B" \
    "\u2329\u232A" \
    "\u2ADC" \
    "\uF900-\uFA0D" \
    "\uFA10" \
    "\uFA12" \
    "\uFA15-\uFA1E" \
    "\uFA20" \
    "\uFA22" \
    "\uFA25\uFA26" \
    "\uFA2A-\uFA6D" \
    "\uFA70-\uFAD9" \
    "\uFB1D" \
    "\uFB1F" \
    "\uFB2A-\uFB36" \
    "\uFB38-\uFB3C" \
    "\uFB3E" \
    "\uFB40\uFB41" \
    "\uFB43\uFB44" \
    "\uFB46-\uFB4E" \
    "\u{1D15E}-\u{1D164}" \
    "\u{1D1BB}-\u{1D1C0}" \
    "\u{2F800}-\u{2FA1D}" \
    "]#{accents}*" \
    "|#{''  # composition starters and characters that can be the result of a composition
    }" \
    "[<->" \
    "A-P" \
    "R-Z" \
    "a-p" \
    "r-z" \
    "\u00A8" \
    "\u00C0-\u00CF" \
    "\u00D1-\u00D6" \
    "\u00D8-\u00DD" \
    "\u00E0-\u00EF" \
    "\u00F1-\u00F6" \
    "\u00F8-\u00FD" \
    "\u00FF-\u010F" \
    "\u0112-\u0125" \
    "\u0128-\u0130" \
    "\u0134-\u0137" \
    "\u0139-\u013E" \
    "\u0143-\u0148" \
    "\u014C-\u0151" \
    "\u0154-\u0165" \
    "\u0168-\u017F" \
    "\u01A0\u01A1" \
    "\u01AF\u01B0" \
    "\u01B7" \
    "\u01CD-\u01DC" \
    "\u01DE-\u01E3" \
    "\u01E6-\u01F0" \
    "\u01F4\u01F5" \
    "\u01F8-\u021B" \
    "\u021E\u021F" \
    "\u0226-\u0233" \
    "\u0292" \
    "\u0385\u0386" \
    "\u0388-\u038A" \
    "\u038C" \
    "\u038E-\u0391" \
    "\u0395" \
    "\u0397" \
    "\u0399" \
    "\u039F" \
    "\u03A1" \
    "\u03A5" \
    "\u03A9-\u03B1" \
    "\u03B5" \
    "\u03B7" \
    "\u03B9" \
    "\u03BF" \
    "\u03C1" \
    "\u03C5" \
    "\u03C9-\u03CE" \
    "\u03D2-\u03D4" \
    "\u0400\u0401" \
    "\u0403" \
    "\u0406\u0407" \
    "\u040C-\u040E" \
    "\u0410" \
    "\u0413" \
    "\u0415-\u041A" \
    "\u041E" \
    "\u0423" \
    "\u0427" \
    "\u042B" \
    "\u042D" \
    "\u0430" \
    "\u0433" \
    "\u0435-\u043A" \
    "\u043E" \
    "\u0443" \
    "\u0447" \
    "\u044B" \
    "\u044D" \
    "\u0450\u0451" \
    "\u0453" \
    "\u0456\u0457" \
    "\u045C-\u045E" \
    "\u0474-\u0477" \
    "\u04C1\u04C2" \
    "\u04D0-\u04D3" \
    "\u04D6-\u04DF" \
    "\u04E2-\u04F5" \
    "\u04F8\u04F9" \
    "\u0622-\u0627" \
    "\u0648" \
    "\u064A" \
    "\u06C0-\u06C2" \
    "\u06D2\u06D3" \
    "\u06D5" \
    "\u0928\u0929" \
    "\u0930\u0931" \
    "\u0933\u0934" \
    "\u09C7" \
    "\u09CB\u09CC" \
    "\u0B47\u0B48" \
    "\u0B4B\u0B4C" \
    "\u0B92" \
    "\u0B94" \
    "\u0BC6\u0BC7" \
    "\u0BCA-\u0BCC" \
    "\u0C46" \
    "\u0C48" \
    "\u0CBF\u0CC0" \
    "\u0CC6-\u0CC8" \
    "\u0CCA\u0CCB" \
    "\u0D46\u0D47" \
    "\u0D4A-\u0D4C" \
    "\u0DD9\u0DDA" \
    "\u0DDC-\u0DDE" \
    "\u1025\u1026" \
    "\u1B05-\u1B0E" \
    "\u1B11\u1B12" \
    "\u1B3A-\u1B43" \
    "\u1E00-\u1E99" \
    "\u1E9B" \
    "\u1EA0-\u1EF9" \
    "\u1F00-\u1F15" \
    "\u1F18-\u1F1D" \
    "\u1F20-\u1F45" \
    "\u1F48-\u1F4D" \
    "\u1F50-\u1F57" \
    "\u1F59" \
    "\u1F5B" \
    "\u1F5D" \
    "\u1F5F-\u1F70" \
    "\u1F72" \
    "\u1F74" \
    "\u1F76" \
    "\u1F78" \
    "\u1F7A" \
    "\u1F7C" \
    "\u1F80-\u1FB4" \
    "\u1FB6-\u1FBA" \
    "\u1FBC" \
    "\u1FBF" \
    "\u1FC1-\u1FC4" \
    "\u1FC6-\u1FC8" \
    "\u1FCA" \
    "\u1FCC-\u1FD2" \
    "\u1FD6-\u1FDA" \
    "\u1FDD-\u1FE2" \
    "\u1FE4-\u1FEA" \
    "\u1FEC\u1FED" \
    "\u1FF2-\u1FF4" \
    "\u1FF6-\u1FF8" \
    "\u1FFA" \
    "\u1FFC" \
    "\u1FFE" \
    "\u2190" \
    "\u2192" \
    "\u2194" \
    "\u219A\u219B" \
    "\u21AE" \
    "\u21CD-\u21D0" \
    "\u21D2" \
    "\u21D4" \
    "\u2203\u2204" \
    "\u2208\u2209" \
    "\u220B\u220C" \
    "\u2223-\u2226" \
    "\u223C" \
    "\u2241" \
    "\u2243-\u2245" \
    "\u2247-\u2249" \
    "\u224D" \
    "\u2260-\u2262" \
    "\u2264\u2265" \
    "\u226D-\u227D" \
    "\u2280-\u2289" \
    "\u2291\u2292" \
    "\u22A2" \
    "\u22A8\u22A9" \
    "\u22AB-\u22AF" \
    "\u22B2-\u22B5" \
    "\u22E0-\u22E3" \
    "\u22EA-\u22ED" \
    "\u3046" \
    "\u304B-\u3062" \
    "\u3064-\u3069" \
    "\u306F-\u307D" \
    "\u3094" \
    "\u309D\u309E" \
    "\u30A6" \
    "\u30AB-\u30C2" \
    "\u30C4-\u30C9" \
    "\u30CF-\u30DD" \
    "\u30EF-\u30F2" \
    "\u30F4" \
    "\u30F7-\u30FA" \
    "\u30FD\u30FE" \
    "\u{11099}-\u{1109C}" \
    "\u{110A5}" \
    "\u{110AB}" \
    "\u{1112E}\u{1112F}" \
    "\u{11131}\u{11132}" \
    "\u{11347}" \
    "\u{1134B}\u{1134C}" \
    "\u{114B9}" \
    "\u{114BB}\u{114BC}" \
    "\u{114BE}" \
    "\u{115B8}-\u{115BB}" \
    "]?#{accents}+" \
    "|#{''  # Hangul syllables with separate trailer
    }" \
    "[\uAC00" \
    "\uAC1C" \
    "\uAC38" \
    "\uAC54" \
    "\uAC70" \
    "\uAC8C" \
    "\uACA8" \
    "\uACC4" \
    "\uACE0" \
    "\uACFC" \
    "\uAD18" \
    "\uAD34" \
    "\uAD50" \
    "\uAD6C" \
    "\uAD88" \
    "\uADA4" \
    "\uADC0" \
    "\uADDC" \
    "\uADF8" \
    "\uAE14" \
    "\uAE30" \
    "\uAE4C" \
    "\uAE68" \
    "\uAE84" \
    "\uAEA0" \
    "\uAEBC" \
    "\uAED8" \
    "\uAEF4" \
    "\uAF10" \
    "\uAF2C" \
    "\uAF48" \
    "\uAF64" \
    "\uAF80" \
    "\uAF9C" \
    "\uAFB8" \
    "\uAFD4" \
    "\uAFF0" \
    "\uB00C" \
    "\uB028" \
    "\uB044" \
    "\uB060" \
    "\uB07C" \
    "\uB098" \
    "\uB0B4" \
    "\uB0D0" \
    "\uB0EC" \
    "\uB108" \
    "\uB124" \
    "\uB140" \
    "\uB15C" \
    "\uB178" \
    "\uB194" \
    "\uB1B0" \
    "\uB1CC" \
    "\uB1E8" \
    "\uB204" \
    "\uB220" \
    "\uB23C" \
    "\uB258" \
    "\uB274" \
    "\uB290" \
    "\uB2AC" \
    "\uB2C8" \
    "\uB2E4" \
    "\uB300" \
    "\uB31C" \
    "\uB338" \
    "\uB354" \
    "\uB370" \
    "\uB38C" \
    "\uB3A8" \
    "\uB3C4" \
    "\uB3E0" \
    "\uB3FC" \
    "\uB418" \
    "\uB434" \
    "\uB450" \
    "\uB46C" \
    "\uB488" \
    "\uB4A4" \
    "\uB4C0" \
    "\uB4DC" \
    "\uB4F8" \
    "\uB514" \
    "\uB530" \
    "\uB54C" \
    "\uB568" \
    "\uB584" \
    "\uB5A0" \
    "\uB5BC" \
    "\uB5D8" \
    "\uB5F4" \
    "\uB610" \
    "\uB62C" \
    "\uB648" \
    "\uB664" \
    "\uB680" \
    "\uB69C" \
    "\uB6B8" \
    "\uB6D4" \
    "\uB6F0" \
    "\uB70C" \
    "\uB728" \
    "\uB744" \
    "\uB760" \
    "\uB77C" \
    "\uB798" \
    "\uB7B4" \
    "\uB7D0" \
    "\uB7EC" \
    "\uB808" \
    "\uB824" \
    "\uB840" \
    "\uB85C" \
    "\uB878" \
    "\uB894" \
    "\uB8B0" \
    "\uB8CC" \
    "\uB8E8" \
    "\uB904" \
    "\uB920" \
    "\uB93C" \
    "\uB958" \
    "\uB974" \
    "\uB990" \
    "\uB9AC" \
    "\uB9C8" \
    "\uB9E4" \
    "\uBA00" \
    "\uBA1C" \
    "\uBA38" \
    "\uBA54" \
    "\uBA70" \
    "\uBA8C" \
    "\uBAA8" \
    "\uBAC4" \
    "\uBAE0" \
    "\uBAFC" \
    "\uBB18" \
    "\uBB34" \
    "\uBB50" \
    "\uBB6C" \
    "\uBB88" \
    "\uBBA4" \
    "\uBBC0" \
    "\uBBDC" \
    "\uBBF8" \
    "\uBC14" \
    "\uBC30" \
    "\uBC4C" \
    "\uBC68" \
    "\uBC84" \
    "\uBCA0" \
    "\uBCBC" \
    "\uBCD8" \
    "\uBCF4" \
    "\uBD10" \
    "\uBD2C" \
    "\uBD48" \
    "\uBD64" \
    "\uBD80" \
    "\uBD9C" \
    "\uBDB8" \
    "\uBDD4" \
    "\uBDF0" \
    "\uBE0C" \
    "\uBE28" \
    "\uBE44" \
    "\uBE60" \
    "\uBE7C" \
    "\uBE98" \
    "\uBEB4" \
    "\uBED0" \
    "\uBEEC" \
    "\uBF08" \
    "\uBF24" \
    "\uBF40" \
    "\uBF5C" \
    "\uBF78" \
    "\uBF94" \
    "\uBFB0" \
    "\uBFCC" \
    "\uBFE8" \
    "\uC004" \
    "\uC020" \
    "\uC03C" \
    "\uC058" \
    "\uC074" \
    "\uC090" \
    "\uC0AC" \
    "\uC0C8" \
    "\uC0E4" \
    "\uC100" \
    "\uC11C" \
    "\uC138" \
    "\uC154" \
    "\uC170" \
    "\uC18C" \
    "\uC1A8" \
    "\uC1C4" \
    "\uC1E0" \
    "\uC1FC" \
    "\uC218" \
    "\uC234" \
    "\uC250" \
    "\uC26C" \
    "\uC288" \
    "\uC2A4" \
    "\uC2C0" \
    "\uC2DC" \
    "\uC2F8" \
    "\uC314" \
    "\uC330" \
    "\uC34C" \
    "\uC368" \
    "\uC384" \
    "\uC3A0" \
    "\uC3BC" \
    "\uC3D8" \
    "\uC3F4" \
    "\uC410" \
    "\uC42C" \
    "\uC448" \
    "\uC464" \
    "\uC480" \
    "\uC49C" \
    "\uC4B8" \
    "\uC4D4" \
    "\uC4F0" \
    "\uC50C" \
    "\uC528" \
    "\uC544" \
    "\uC560" \
    "\uC57C" \
    "\uC598" \
    "\uC5B4" \
    "\uC5D0" \
    "\uC5EC" \
    "\uC608" \
    "\uC624" \
    "\uC640" \
    "\uC65C" \
    "\uC678" \
    "\uC694" \
    "\uC6B0" \
    "\uC6CC" \
    "\uC6E8" \
    "\uC704" \
    "\uC720" \
    "\uC73C" \
    "\uC758" \
    "\uC774" \
    "\uC790" \
    "\uC7AC" \
    "\uC7C8" \
    "\uC7E4" \
    "\uC800" \
    "\uC81C" \
    "\uC838" \
    "\uC854" \
    "\uC870" \
    "\uC88C" \
    "\uC8A8" \
    "\uC8C4" \
    "\uC8E0" \
    "\uC8FC" \
    "\uC918" \
    "\uC934" \
    "\uC950" \
    "\uC96C" \
    "\uC988" \
    "\uC9A4" \
    "\uC9C0" \
    "\uC9DC" \
    "\uC9F8" \
    "\uCA14" \
    "\uCA30" \
    "\uCA4C" \
    "\uCA68" \
    "\uCA84" \
    "\uCAA0" \
    "\uCABC" \
    "\uCAD8" \
    "\uCAF4" \
    "\uCB10" \
    "\uCB2C" \
    "\uCB48" \
    "\uCB64" \
    "\uCB80" \
    "\uCB9C" \
    "\uCBB8" \
    "\uCBD4" \
    "\uCBF0" \
    "\uCC0C" \
    "\uCC28" \
    "\uCC44" \
    "\uCC60" \
    "\uCC7C" \
    "\uCC98" \
    "\uCCB4" \
    "\uCCD0" \
    "\uCCEC" \
    "\uCD08" \
    "\uCD24" \
    "\uCD40" \
    "\uCD5C" \
    "\uCD78" \
    "\uCD94" \
    "\uCDB0" \
    "\uCDCC" \
    "\uCDE8" \
    "\uCE04" \
    "\uCE20" \
    "\uCE3C" \
    "\uCE58" \
    "\uCE74" \
    "\uCE90" \
    "\uCEAC" \
    "\uCEC8" \
    "\uCEE4" \
    "\uCF00" \
    "\uCF1C" \
    "\uCF38" \
    "\uCF54" \
    "\uCF70" \
    "\uCF8C" \
    "\uCFA8" \
    "\uCFC4" \
    "\uCFE0" \
    "\uCFFC" \
    "\uD018" \
    "\uD034" \
    "\uD050" \
    "\uD06C" \
    "\uD088" \
    "\uD0A4" \
    "\uD0C0" \
    "\uD0DC" \
    "\uD0F8" \
    "\uD114" \
    "\uD130" \
    "\uD14C" \
    "\uD168" \
    "\uD184" \
    "\uD1A0" \
    "\uD1BC" \
    "\uD1D8" \
    "\uD1F4" \
    "\uD210" \
    "\uD22C" \
    "\uD248" \
    "\uD264" \
    "\uD280" \
    "\uD29C" \
    "\uD2B8" \
    "\uD2D4" \
    "\uD2F0" \
    "\uD30C" \
    "\uD328" \
    "\uD344" \
    "\uD360" \
    "\uD37C" \
    "\uD398" \
    "\uD3B4" \
    "\uD3D0" \
    "\uD3EC" \
    "\uD408" \
    "\uD424" \
    "\uD440" \
    "\uD45C" \
    "\uD478" \
    "\uD494" \
    "\uD4B0" \
    "\uD4CC" \
    "\uD4E8" \
    "\uD504" \
    "\uD520" \
    "\uD53C" \
    "\uD558" \
    "\uD574" \
    "\uD590" \
    "\uD5AC" \
    "\uD5C8" \
    "\uD5E4" \
    "\uD600" \
    "\uD61C" \
    "\uD638" \
    "\uD654" \
    "\uD670" \
    "\uD68C" \
    "\uD6A8" \
    "\uD6C4" \
    "\uD6E0" \
    "\uD6FC" \
    "\uD718" \
    "\uD734" \
    "\uD750" \
    "\uD76C" \
    "\uD788" \
    "][\u11A8-\u11C2]" \
    "|#{''  # decomposed Hangul syllables
    }" \
    "[\u1100-\u1112][\u1161-\u1175][\u11A8-\u11C2]?"
  REGEXP_K_STRING = "" \
    "[\u00A0" \
    "\u00A8" \
    "\u00AA" \
    "\u00AF" \
    "\u00B2-\u00B5" \
    "\u00B8-\u00BA" \
    "\u00BC-\u00BE" \
    "\u0132\u0133" \
    "\u013F\u0140" \
    "\u0149" \
    "\u017F" \
    "\u01C4-\u01CC" \
    "\u01F1-\u01F3" \
    "\u02B0-\u02B8" \
    "\u02D8-\u02DD" \
    "\u02E0-\u02E4" \
    "\u037A" \
    "\u0384\u0385" \
    "\u03D0-\u03D6" \
    "\u03F0-\u03F2" \
    "\u03F4\u03F5" \
    "\u03F9" \
    "\u0587" \
    "\u0675-\u0678" \
    "\u0E33" \
    "\u0EB3" \
    "\u0EDC\u0EDD" \
    "\u0F0C" \
    "\u0F77" \
    "\u0F79" \
    "\u10FC" \
    "\u1D2C-\u1D2E" \
    "\u1D30-\u1D3A" \
    "\u1D3C-\u1D4D" \
    "\u1D4F-\u1D6A" \
    "\u1D78" \
    "\u1D9B-\u1DBF" \
    "\u1E9A\u1E9B" \
    "\u1FBD" \
    "\u1FBF-\u1FC1" \
    "\u1FCD-\u1FCF" \
    "\u1FDD-\u1FDF" \
    "\u1FED\u1FEE" \
    "\u1FFD\u1FFE" \
    "\u2000-\u200A" \
    "\u2011" \
    "\u2017" \
    "\u2024-\u2026" \
    "\u202F" \
    "\u2033\u2034" \
    "\u2036\u2037" \
    "\u203C" \
    "\u203E" \
    "\u2047-\u2049" \
    "\u2057" \
    "\u205F" \
    "\u2070\u2071" \
    "\u2074-\u208E" \
    "\u2090-\u209C" \
    "\u20A8" \
    "\u2100-\u2103" \
    "\u2105-\u2107" \
    "\u2109-\u2113" \
    "\u2115\u2116" \
    "\u2119-\u211D" \
    "\u2120-\u2122" \
    "\u2124" \
    "\u2128" \
    "\u212C\u212D" \
    "\u212F-\u2131" \
    "\u2133-\u2139" \
    "\u213B-\u2140" \
    "\u2145-\u2149" \
    "\u2150-\u217F" \
    "\u2189" \
    "\u222C\u222D" \
    "\u222F\u2230" \
    "\u2460-\u24EA" \
    "\u2A0C" \
    "\u2A74-\u2A76" \
    "\u2C7C\u2C7D" \
    "\u2D6F" \
    "\u2E9F" \
    "\u2EF3" \
    "\u2F00-\u2FD5" \
    "\u3000" \
    "\u3036" \
    "\u3038-\u303A" \
    "\u309B\u309C" \
    "\u309F" \
    "\u30FF" \
    "\u3131-\u318E" \
    "\u3192-\u319F" \
    "\u3200-\u321E" \
    "\u3220-\u3247" \
    "\u3250-\u327E" \
    "\u3280-\u33FF" \
    "\uA69C\uA69D" \
    "\uA770" \
    "\uA7F8\uA7F9" \
    "\uAB5C-\uAB5F" \
    "\uFB00-\uFB06" \
    "\uFB13-\uFB17" \
    "\uFB20-\uFB29" \
    "\uFB4F-\uFBB1" \
    "\uFBD3-\uFD3D" \
    "\uFD50-\uFD8F" \
    "\uFD92-\uFDC7" \
    "\uFDF0-\uFDFC" \
    "\uFE10-\uFE19" \
    "\uFE30-\uFE44" \
    "\uFE47-\uFE52" \
    "\uFE54-\uFE66" \
    "\uFE68-\uFE6B" \
    "\uFE70-\uFE72" \
    "\uFE74" \
    "\uFE76-\uFEFC" \
    "\uFF01-\uFFBE" \
    "\uFFC2-\uFFC7" \
    "\uFFCA-\uFFCF" \
    "\uFFD2-\uFFD7" \
    "\uFFDA-\uFFDC" \
    "\uFFE0-\uFFE6" \
    "\uFFE8-\uFFEE" \
    "\u{1D400}-\u{1D454}" \
    "\u{1D456}-\u{1D49C}" \
    "\u{1D49E}\u{1D49F}" \
    "\u{1D4A2}" \
    "\u{1D4A5}\u{1D4A6}" \
    "\u{1D4A9}-\u{1D4AC}" \
    "\u{1D4AE}-\u{1D4B9}" \
    "\u{1D4BB}" \
    "\u{1D4BD}-\u{1D4C3}" \
    "\u{1D4C5}-\u{1D505}" \
    "\u{1D507}-\u{1D50A}" \
    "\u{1D50D}-\u{1D514}" \
    "\u{1D516}-\u{1D51C}" \
    "\u{1D51E}-\u{1D539}" \
    "\u{1D53B}-\u{1D53E}" \
    "\u{1D540}-\u{1D544}" \
    "\u{1D546}" \
    "\u{1D54A}-\u{1D550}" \
    "\u{1D552}-\u{1D6A5}" \
    "\u{1D6A8}-\u{1D7CB}" \
    "\u{1D7CE}-\u{1D7FF}" \
    "\u{1EE00}-\u{1EE03}" \
    "\u{1EE05}-\u{1EE1F}" \
    "\u{1EE21}\u{1EE22}" \
    "\u{1EE24}" \
    "\u{1EE27}" \
    "\u{1EE29}-\u{1EE32}" \
    "\u{1EE34}-\u{1EE37}" \
    "\u{1EE39}" \
    "\u{1EE3B}" \
    "\u{1EE42}" \
    "\u{1EE47}" \
    "\u{1EE49}" \
    "\u{1EE4B}" \
    "\u{1EE4D}-\u{1EE4F}" \
    "\u{1EE51}\u{1EE52}" \
    "\u{1EE54}" \
    "\u{1EE57}" \
    "\u{1EE59}" \
    "\u{1EE5B}" \
    "\u{1EE5D}" \
    "\u{1EE5F}" \
    "\u{1EE61}\u{1EE62}" \
    "\u{1EE64}" \
    "\u{1EE67}-\u{1EE6A}" \
    "\u{1EE6C}-\u{1EE72}" \
    "\u{1EE74}-\u{1EE77}" \
    "\u{1EE79}-\u{1EE7C}" \
    "\u{1EE7E}" \
    "\u{1EE80}-\u{1EE89}" \
    "\u{1EE8B}-\u{1EE9B}" \
    "\u{1EEA1}-\u{1EEA3}" \
    "\u{1EEA5}-\u{1EEA9}" \
    "\u{1EEAB}-\u{1EEBB}" \
    "\u{1F100}-\u{1F10A}" \
    "\u{1F110}-\u{1F12E}" \
    "\u{1F130}-\u{1F14F}" \
    "\u{1F16A}-\u{1F16C}" \
    "\u{1F190}" \
    "\u{1F200}-\u{1F202}" \
    "\u{1F210}-\u{1F23B}" \
    "\u{1F240}-\u{1F248}" \
    "\u{1F250}\u{1F251}" \
    "]"

  class_table = {
    "\u0300"=>230,
    "\u0301"=>230,
    "\u0302"=>230,
    "\u0303"=>230,
    "\u0304"=>230,
    "\u0305"=>230,
    "\u0306"=>230,
    "\u0307"=>230,
    "\u0308"=>230,
    "\u0309"=>230,
    "\u030A"=>230,
    "\u030B"=>230,
    "\u030C"=>230,
    "\u030D"=>230,
    "\u030E"=>230,
    "\u030F"=>230,
    "\u0310"=>230,
    "\u0311"=>230,
    "\u0312"=>230,
    "\u0313"=>230,
    "\u0314"=>230,
    "\u0315"=>232,
    "\u0316"=>220,
    "\u0317"=>220,
    "\u0318"=>220,
    "\u0319"=>220,
    "\u031A"=>232,
    "\u031B"=>216,
    "\u031C"=>220,
    "\u031D"=>220,
    "\u031E"=>220,
    "\u031F"=>220,
    "\u0320"=>220,
    "\u0321"=>202,
    "\u0322"=>202,
    "\u0323"=>220,
    "\u0324"=>220,
    "\u0325"=>220,
    "\u0326"=>220,
    "\u0327"=>202,
    "\u0328"=>202,
    "\u0329"=>220,
    "\u032A"=>220,
    "\u032B"=>220,
    "\u032C"=>220,
    "\u032D"=>220,
    "\u032E"=>220,
    "\u032F"=>220,
    "\u0330"=>220,
    "\u0331"=>220,
    "\u0332"=>220,
    "\u0333"=>220,
    "\u0334"=>1,
    "\u0335"=>1,
    "\u0336"=>1,
    "\u0337"=>1,
    "\u0338"=>1,
    "\u0339"=>220,
    "\u033A"=>220,
    "\u033B"=>220,
    "\u033C"=>220,
    "\u033D"=>230,
    "\u033E"=>230,
    "\u033F"=>230,
    "\u0340"=>230,
    "\u0341"=>230,
    "\u0342"=>230,
    "\u0343"=>230,
    "\u0344"=>230,
    "\u0345"=>240,
    "\u0346"=>230,
    "\u0347"=>220,
    "\u0348"=>220,
    "\u0349"=>220,
    "\u034A"=>230,
    "\u034B"=>230,
    "\u034C"=>230,
    "\u034D"=>220,
    "\u034E"=>220,
    "\u0350"=>230,
    "\u0351"=>230,
    "\u0352"=>230,
    "\u0353"=>220,
    "\u0354"=>220,
    "\u0355"=>220,
    "\u0356"=>220,
    "\u0357"=>230,
    "\u0358"=>232,
    "\u0359"=>220,
    "\u035A"=>220,
    "\u035B"=>230,
    "\u035C"=>233,
    "\u035D"=>234,
    "\u035E"=>234,
    "\u035F"=>233,
    "\u0360"=>234,
    "\u0361"=>234,
    "\u0362"=>233,
    "\u0363"=>230,
    "\u0364"=>230,
    "\u0365"=>230,
    "\u0366"=>230,
    "\u0367"=>230,
    "\u0368"=>230,
    "\u0369"=>230,
    "\u036A"=>230,
    "\u036B"=>230,
    "\u036C"=>230,
    "\u036D"=>230,
    "\u036E"=>230,
    "\u036F"=>230,
    "\u0483"=>230,
    "\u0484"=>230,
    "\u0485"=>230,
    "\u0486"=>230,
    "\u0487"=>230,
    "\u0591"=>220,
    "\u0592"=>230,
    "\u0593"=>230,
    "\u0594"=>230,
    "\u0595"=>230,
    "\u0596"=>220,
    "\u0597"=>230,
    "\u0598"=>230,
    "\u0599"=>230,
    "\u059A"=>222,
    "\u059B"=>220,
    "\u059C"=>230,
    "\u059D"=>230,
    "\u059E"=>230,
    "\u059F"=>230,
    "\u05A0"=>230,
    "\u05A1"=>230,
    "\u05A2"=>220,
    "\u05A3"=>220,
    "\u05A4"=>220,
    "\u05A5"=>220,
    "\u05A6"=>220,
    "\u05A7"=>220,
    "\u05A8"=>230,
    "\u05A9"=>230,
    "\u05AA"=>220,
    "\u05AB"=>230,
    "\u05AC"=>230,
    "\u05AD"=>222,
    "\u05AE"=>228,
    "\u05AF"=>230,
    "\u05B0"=>10,
    "\u05B1"=>11,
    "\u05B2"=>12,
    "\u05B3"=>13,
    "\u05B4"=>14,
    "\u05B5"=>15,
    "\u05B6"=>16,
    "\u05B7"=>17,
    "\u05B8"=>18,
    "\u05B9"=>19,
    "\u05BA"=>19,
    "\u05BB"=>20,
    "\u05BC"=>21,
    "\u05BD"=>22,
    "\u05BF"=>23,
    "\u05C1"=>24,
    "\u05C2"=>25,
    "\u05C4"=>230,
    "\u05C5"=>220,
    "\u05C7"=>18,
    "\u0610"=>230,
    "\u0611"=>230,
    "\u0612"=>230,
    "\u0613"=>230,
    "\u0614"=>230,
    "\u0615"=>230,
    "\u0616"=>230,
    "\u0617"=>230,
    "\u0618"=>30,
    "\u0619"=>31,
    "\u061A"=>32,
    "\u064B"=>27,
    "\u064C"=>28,
    "\u064D"=>29,
    "\u064E"=>30,
    "\u064F"=>31,
    "\u0650"=>32,
    "\u0651"=>33,
    "\u0652"=>34,
    "\u0653"=>230,
    "\u0654"=>230,
    "\u0655"=>220,
    "\u0656"=>220,
    "\u0657"=>230,
    "\u0658"=>230,
    "\u0659"=>230,
    "\u065A"=>230,
    "\u065B"=>230,
    "\u065C"=>220,
    "\u065D"=>230,
    "\u065E"=>230,
    "\u065F"=>220,
    "\u0670"=>35,
    "\u06D6"=>230,
    "\u06D7"=>230,
    "\u06D8"=>230,
    "\u06D9"=>230,
    "\u06DA"=>230,
    "\u06DB"=>230,
    "\u06DC"=>230,
    "\u06DF"=>230,
    "\u06E0"=>230,
    "\u06E1"=>230,
    "\u06E2"=>230,
    "\u06E3"=>220,
    "\u06E4"=>230,
    "\u06E7"=>230,
    "\u06E8"=>230,
    "\u06EA"=>220,
    "\u06EB"=>230,
    "\u06EC"=>230,
    "\u06ED"=>220,
    "\u0711"=>36,
    "\u0730"=>230,
    "\u0731"=>220,
    "\u0732"=>230,
    "\u0733"=>230,
    "\u0734"=>220,
    "\u0735"=>230,
    "\u0736"=>230,
    "\u0737"=>220,
    "\u0738"=>220,
    "\u0739"=>220,
    "\u073A"=>230,
    "\u073B"=>220,
    "\u073C"=>220,
    "\u073D"=>230,
    "\u073E"=>220,
    "\u073F"=>230,
    "\u0740"=>230,
    "\u0741"=>230,
    "\u0742"=>220,
    "\u0743"=>230,
    "\u0744"=>220,
    "\u0745"=>230,
    "\u0746"=>220,
    "\u0747"=>230,
    "\u0748"=>220,
    "\u0749"=>230,
    "\u074A"=>230,
    "\u07EB"=>230,
    "\u07EC"=>230,
    "\u07ED"=>230,
    "\u07EE"=>230,
    "\u07EF"=>230,
    "\u07F0"=>230,
    "\u07F1"=>230,
    "\u07F2"=>220,
    "\u07F3"=>230,
    "\u07FD"=>220,
    "\u0816"=>230,
    "\u0817"=>230,
    "\u0818"=>230,
    "\u0819"=>230,
    "\u081B"=>230,
    "\u081C"=>230,
    "\u081D"=>230,
    "\u081E"=>230,
    "\u081F"=>230,
    "\u0820"=>230,
    "\u0821"=>230,
    "\u0822"=>230,
    "\u0823"=>230,
    "\u0825"=>230,
    "\u0826"=>230,
    "\u0827"=>230,
    "\u0829"=>230,
    "\u082A"=>230,
    "\u082B"=>230,
    "\u082C"=>230,
    "\u082D"=>230,
    "\u0859"=>220,
    "\u085A"=>220,
    "\u085B"=>220,
    "\u08D3"=>220,
    "\u08D4"=>230,
    "\u08D5"=>230,
    "\u08D6"=>230,
    "\u08D7"=>230,
    "\u08D8"=>230,
    "\u08D9"=>230,
    "\u08DA"=>230,
    "\u08DB"=>230,
    "\u08DC"=>230,
    "\u08DD"=>230,
    "\u08DE"=>230,
    "\u08DF"=>230,
    "\u08E0"=>230,
    "\u08E1"=>230,
    "\u08E3"=>220,
    "\u08E4"=>230,
    "\u08E5"=>230,
    "\u08E6"=>220,
    "\u08E7"=>230,
    "\u08E8"=>230,
    "\u08E9"=>220,
    "\u08EA"=>230,
    "\u08EB"=>230,
    "\u08EC"=>230,
    "\u08ED"=>220,
    "\u08EE"=>220,
    "\u08EF"=>220,
    "\u08F0"=>27,
    "\u08F1"=>28,
    "\u08F2"=>29,
    "\u08F3"=>230,
    "\u08F4"=>230,
    "\u08F5"=>230,
    "\u08F6"=>220,
    "\u08F7"=>230,
    "\u08F8"=>230,
    "\u08F9"=>220,
    "\u08FA"=>220,
    "\u08FB"=>230,
    "\u08FC"=>230,
    "\u08FD"=>230,
    "\u08FE"=>230,
    "\u08FF"=>230,
    "\u093C"=>7,
    "\u094D"=>9,
    "\u0951"=>230,
    "\u0952"=>220,
    "\u0953"=>230,
    "\u0954"=>230,
    "\u09BC"=>7,
    "\u09CD"=>9,
    "\u09FE"=>230,
    "\u0A3C"=>7,
    "\u0A4D"=>9,
    "\u0ABC"=>7,
    "\u0ACD"=>9,
    "\u0B3C"=>7,
    "\u0B4D"=>9,
    "\u0BCD"=>9,
    "\u0C4D"=>9,
    "\u0C55"=>84,
    "\u0C56"=>91,
    "\u0CBC"=>7,
    "\u0CCD"=>9,
    "\u0D3B"=>9,
    "\u0D3C"=>9,
    "\u0D4D"=>9,
    "\u0DCA"=>9,
    "\u0E38"=>103,
    "\u0E39"=>103,
    "\u0E3A"=>9,
    "\u0E48"=>107,
    "\u0E49"=>107,
    "\u0E4A"=>107,
    "\u0E4B"=>107,
    "\u0EB8"=>118,
    "\u0EB9"=>118,
    "\u0EBA"=>9,
    "\u0EC8"=>122,
    "\u0EC9"=>122,
    "\u0ECA"=>122,
    "\u0ECB"=>122,
    "\u0F18"=>220,
    "\u0F19"=>220,
    "\u0F35"=>220,
    "\u0F37"=>220,
    "\u0F39"=>216,
    "\u0F71"=>129,
    "\u0F72"=>130,
    "\u0F74"=>132,
    "\u0F7A"=>130,
    "\u0F7B"=>130,
    "\u0F7C"=>130,
    "\u0F7D"=>130,
    "\u0F80"=>130,
    "\u0F82"=>230,
    "\u0F83"=>230,
    "\u0F84"=>9,
    "\u0F86"=>230,
    "\u0F87"=>230,
    "\u0FC6"=>220,
    "\u1037"=>7,
    "\u1039"=>9,
    "\u103A"=>9,
    "\u108D"=>220,
    "\u135D"=>230,
    "\u135E"=>230,
    "\u135F"=>230,
    "\u1714"=>9,
    "\u1734"=>9,
    "\u17D2"=>9,
    "\u17DD"=>230,
    "\u18A9"=>228,
    "\u1939"=>222,
    "\u193A"=>230,
    "\u193B"=>220,
    "\u1A17"=>230,
    "\u1A18"=>220,
    "\u1A60"=>9,
    "\u1A75"=>230,
    "\u1A76"=>230,
    "\u1A77"=>230,
    "\u1A78"=>230,
    "\u1A79"=>230,
    "\u1A7A"=>230,
    "\u1A7B"=>230,
    "\u1A7C"=>230,
    "\u1A7F"=>220,
    "\u1AB0"=>230,
    "\u1AB1"=>230,
    "\u1AB2"=>230,
    "\u1AB3"=>230,
    "\u1AB4"=>230,
    "\u1AB5"=>220,
    "\u1AB6"=>220,
    "\u1AB7"=>220,
    "\u1AB8"=>220,
    "\u1AB9"=>220,
    "\u1ABA"=>220,
    "\u1ABB"=>230,
    "\u1ABC"=>230,
    "\u1ABD"=>220,
    "\u1B34"=>7,
    "\u1B44"=>9,
    "\u1B6B"=>230,
    "\u1B6C"=>220,
    "\u1B6D"=>230,
    "\u1B6E"=>230,
    "\u1B6F"=>230,
    "\u1B70"=>230,
    "\u1B71"=>230,
    "\u1B72"=>230,
    "\u1B73"=>230,
    "\u1BAA"=>9,
    "\u1BAB"=>9,
    "\u1BE6"=>7,
    "\u1BF2"=>9,
    "\u1BF3"=>9,
    "\u1C37"=>7,
    "\u1CD0"=>230,
    "\u1CD1"=>230,
    "\u1CD2"=>230,
    "\u1CD4"=>1,
    "\u1CD5"=>220,
    "\u1CD6"=>220,
    "\u1CD7"=>220,
    "\u1CD8"=>220,
    "\u1CD9"=>220,
    "\u1CDA"=>230,
    "\u1CDB"=>230,
    "\u1CDC"=>220,
    "\u1CDD"=>220,
    "\u1CDE"=>220,
    "\u1CDF"=>220,
    "\u1CE0"=>230,
    "\u1CE2"=>1,
    "\u1CE3"=>1,
    "\u1CE4"=>1,
    "\u1CE5"=>1,
    "\u1CE6"=>1,
    "\u1CE7"=>1,
    "\u1CE8"=>1,
    "\u1CED"=>220,
    "\u1CF4"=>230,
    "\u1CF8"=>230,
    "\u1CF9"=>230,
    "\u1DC0"=>230,
    "\u1DC1"=>230,
    "\u1DC2"=>220,
    "\u1DC3"=>230,
    "\u1DC4"=>230,
    "\u1DC5"=>230,
    "\u1DC6"=>230,
    "\u1DC7"=>230,
    "\u1DC8"=>230,
    "\u1DC9"=>230,
    "\u1DCA"=>220,
    "\u1DCB"=>230,
    "\u1DCC"=>230,
    "\u1DCD"=>234,
    "\u1DCE"=>214,
    "\u1DCF"=>220,
    "\u1DD0"=>202,
    "\u1DD1"=>230,
    "\u1DD2"=>230,
    "\u1DD3"=>230,
    "\u1DD4"=>230,
    "\u1DD5"=>230,
    "\u1DD6"=>230,
    "\u1DD7"=>230,
    "\u1DD8"=>230,
    "\u1DD9"=>230,
    "\u1DDA"=>230,
    "\u1DDB"=>230,
    "\u1DDC"=>230,
    "\u1DDD"=>230,
    "\u1DDE"=>230,
    "\u1DDF"=>230,
    "\u1DE0"=>230,
    "\u1DE1"=>230,
    "\u1DE2"=>230,
    "\u1DE3"=>230,
    "\u1DE4"=>230,
    "\u1DE5"=>230,
    "\u1DE6"=>230,
    "\u1DE7"=>230,
    "\u1DE8"=>230,
    "\u1DE9"=>230,
    "\u1DEA"=>230,
    "\u1DEB"=>230,
    "\u1DEC"=>230,
    "\u1DED"=>230,
    "\u1DEE"=>230,
    "\u1DEF"=>230,
    "\u1DF0"=>230,
    "\u1DF1"=>230,
    "\u1DF2"=>230,
    "\u1DF3"=>230,
    "\u1DF4"=>230,
    "\u1DF5"=>230,
    "\u1DF6"=>232,
    "\u1DF7"=>228,
    "\u1DF8"=>228,
    "\u1DF9"=>220,
    "\u1DFB"=>230,
    "\u1DFC"=>233,
    "\u1DFD"=>220,
    "\u1DFE"=>230,
    "\u1DFF"=>220,
    "\u20D0"=>230,
    "\u20D1"=>230,
    "\u20D2"=>1,
    "\u20D3"=>1,
    "\u20D4"=>230,
    "\u20D5"=>230,
    "\u20D6"=>230,
    "\u20D7"=>230,
    "\u20D8"=>1,
    "\u20D9"=>1,
    "\u20DA"=>1,
    "\u20DB"=>230,
    "\u20DC"=>230,
    "\u20E1"=>230,
    "\u20E5"=>1,
    "\u20E6"=>1,
    "\u20E7"=>230,
    "\u20E8"=>220,
    "\u20E9"=>230,
    "\u20EA"=>1,
    "\u20EB"=>1,
    "\u20EC"=>220,
    "\u20ED"=>220,
    "\u20EE"=>220,
    "\u20EF"=>220,
    "\u20F0"=>230,
    "\u2CEF"=>230,
    "\u2CF0"=>230,
    "\u2CF1"=>230,
    "\u2D7F"=>9,
    "\u2DE0"=>230,
    "\u2DE1"=>230,
    "\u2DE2"=>230,
    "\u2DE3"=>230,
    "\u2DE4"=>230,
    "\u2DE5"=>230,
    "\u2DE6"=>230,
    "\u2DE7"=>230,
    "\u2DE8"=>230,
    "\u2DE9"=>230,
    "\u2DEA"=>230,
    "\u2DEB"=>230,
    "\u2DEC"=>230,
    "\u2DED"=>230,
    "\u2DEE"=>230,
    "\u2DEF"=>230,
    "\u2DF0"=>230,
    "\u2DF1"=>230,
    "\u2DF2"=>230,
    "\u2DF3"=>230,
    "\u2DF4"=>230,
    "\u2DF5"=>230,
    "\u2DF6"=>230,
    "\u2DF7"=>230,
    "\u2DF8"=>230,
    "\u2DF9"=>230,
    "\u2DFA"=>230,
    "\u2DFB"=>230,
    "\u2DFC"=>230,
    "\u2DFD"=>230,
    "\u2DFE"=>230,
    "\u2DFF"=>230,
    "\u302A"=>218,
    "\u302B"=>228,
    "\u302C"=>232,
    "\u302D"=>222,
    "\u302E"=>224,
    "\u302F"=>224,
    "\u3099"=>8,
    "\u309A"=>8,
    "\uA66F"=>230,
    "\uA674"=>230,
    "\uA675"=>230,
    "\uA676"=>230,
    "\uA677"=>230,
    "\uA678"=>230,
    "\uA679"=>230,
    "\uA67A"=>230,
    "\uA67B"=>230,
    "\uA67C"=>230,
    "\uA67D"=>230,
    "\uA69E"=>230,
    "\uA69F"=>230,
    "\uA6F0"=>230,
    "\uA6F1"=>230,
    "\uA806"=>9,
    "\uA8C4"=>9,
    "\uA8E0"=>230,
    "\uA8E1"=>230,
    "\uA8E2"=>230,
    "\uA8E3"=>230,
    "\uA8E4"=>230,
    "\uA8E5"=>230,
    "\uA8E6"=>230,
    "\uA8E7"=>230,
    "\uA8E8"=>230,
    "\uA8E9"=>230,
    "\uA8EA"=>230,
    "\uA8EB"=>230,
    "\uA8EC"=>230,
    "\uA8ED"=>230,
    "\uA8EE"=>230,
    "\uA8EF"=>230,
    "\uA8F0"=>230,
    "\uA8F1"=>230,
    "\uA92B"=>220,
    "\uA92C"=>220,
    "\uA92D"=>220,
    "\uA953"=>9,
    "\uA9B3"=>7,
    "\uA9C0"=>9,
    "\uAAB0"=>230,
    "\uAAB2"=>230,
    "\uAAB3"=>230,
    "\uAAB4"=>220,
    "\uAAB7"=>230,
    "\uAAB8"=>230,
    "\uAABE"=>230,
    "\uAABF"=>230,
    "\uAAC1"=>230,
    "\uAAF6"=>9,
    "\uABED"=>9,
    "\uFB1E"=>26,
    "\uFE20"=>230,
    "\uFE21"=>230,
    "\uFE22"=>230,
    "\uFE23"=>230,
    "\uFE24"=>230,
    "\uFE25"=>230,
    "\uFE26"=>230,
    "\uFE27"=>220,
    "\uFE28"=>220,
    "\uFE29"=>220,
    "\uFE2A"=>220,
    "\uFE2B"=>220,
    "\uFE2C"=>220,
    "\uFE2D"=>220,
    "\uFE2E"=>230,
    "\uFE2F"=>230,
    "\u{101FD}"=>220,
    "\u{102E0}"=>220,
    "\u{10376}"=>230,
    "\u{10377}"=>230,
    "\u{10378}"=>230,
    "\u{10379}"=>230,
    "\u{1037A}"=>230,
    "\u{10A0D}"=>220,
    "\u{10A0F}"=>230,
    "\u{10A38}"=>230,
    "\u{10A39}"=>1,
    "\u{10A3A}"=>220,
    "\u{10A3F}"=>9,
    "\u{10AE5}"=>230,
    "\u{10AE6}"=>220,
    "\u{10D24}"=>230,
    "\u{10D25}"=>230,
    "\u{10D26}"=>230,
    "\u{10D27}"=>230,
    "\u{10F46}"=>220,
    "\u{10F47}"=>220,
    "\u{10F48}"=>230,
    "\u{10F49}"=>230,
    "\u{10F4A}"=>230,
    "\u{10F4B}"=>220,
    "\u{10F4C}"=>230,
    "\u{10F4D}"=>220,
    "\u{10F4E}"=>220,
    "\u{10F4F}"=>220,
    "\u{10F50}"=>220,
    "\u{11046}"=>9,
    "\u{1107F}"=>9,
    "\u{110B9}"=>9,
    "\u{110BA}"=>7,
    "\u{11100}"=>230,
    "\u{11101}"=>230,
    "\u{11102}"=>230,
    "\u{11133}"=>9,
    "\u{11134}"=>9,
    "\u{11173}"=>7,
    "\u{111C0}"=>9,
    "\u{111CA}"=>7,
    "\u{11235}"=>9,
    "\u{11236}"=>7,
    "\u{112E9}"=>7,
    "\u{112EA}"=>9,
    "\u{1133B}"=>7,
    "\u{1133C}"=>7,
    "\u{1134D}"=>9,
    "\u{11366}"=>230,
    "\u{11367}"=>230,
    "\u{11368}"=>230,
    "\u{11369}"=>230,
    "\u{1136A}"=>230,
    "\u{1136B}"=>230,
    "\u{1136C}"=>230,
    "\u{11370}"=>230,
    "\u{11371}"=>230,
    "\u{11372}"=>230,
    "\u{11373}"=>230,
    "\u{11374}"=>230,
    "\u{11442}"=>9,
    "\u{11446}"=>7,
    "\u{1145E}"=>230,
    "\u{114C2}"=>9,
    "\u{114C3}"=>7,
    "\u{115BF}"=>9,
    "\u{115C0}"=>7,
    "\u{1163F}"=>9,
    "\u{116B6}"=>9,
    "\u{116B7}"=>7,
    "\u{1172B}"=>9,
    "\u{11839}"=>9,
    "\u{1183A}"=>7,
    "\u{119E0}"=>9,
    "\u{11A34}"=>9,
    "\u{11A47}"=>9,
    "\u{11A99}"=>9,
    "\u{11C3F}"=>9,
    "\u{11D42}"=>7,
    "\u{11D44}"=>9,
    "\u{11D45}"=>9,
    "\u{11D97}"=>9,
    "\u{16AF0}"=>1,
    "\u{16AF1}"=>1,
    "\u{16AF2}"=>1,
    "\u{16AF3}"=>1,
    "\u{16AF4}"=>1,
    "\u{16B30}"=>230,
    "\u{16B31}"=>230,
    "\u{16B32}"=>230,
    "\u{16B33}"=>230,
    "\u{16B34}"=>230,
    "\u{16B35}"=>230,
    "\u{16B36}"=>230,
    "\u{1BC9E}"=>1,
    "\u{1D165}"=>216,
    "\u{1D166}"=>216,
    "\u{1D167}"=>1,
    "\u{1D168}"=>1,
    "\u{1D169}"=>1,
    "\u{1D16D}"=>226,
    "\u{1D16E}"=>216,
    "\u{1D16F}"=>216,
    "\u{1D170}"=>216,
    "\u{1D171}"=>216,
    "\u{1D172}"=>216,
    "\u{1D17B}"=>220,
    "\u{1D17C}"=>220,
    "\u{1D17D}"=>220,
    "\u{1D17E}"=>220,
    "\u{1D17F}"=>220,
    "\u{1D180}"=>220,
    "\u{1D181}"=>220,
    "\u{1D182}"=>220,
    "\u{1D185}"=>230,
    "\u{1D186}"=>230,
    "\u{1D187}"=>230,
    "\u{1D188}"=>230,
    "\u{1D189}"=>230,
    "\u{1D18A}"=>220,
    "\u{1D18B}"=>220,
    "\u{1D1AA}"=>230,
    "\u{1D1AB}"=>230,
    "\u{1D1AC}"=>230,
    "\u{1D1AD}"=>230,
    "\u{1D242}"=>230,
    "\u{1D243}"=>230,
    "\u{1D244}"=>230,
    "\u{1E000}"=>230,
    "\u{1E001}"=>230,
    "\u{1E002}"=>230,
    "\u{1E003}"=>230,
    "\u{1E004}"=>230,
    "\u{1E005}"=>230,
    "\u{1E006}"=>230,
    "\u{1E008}"=>230,
    "\u{1E009}"=>230,
    "\u{1E00A}"=>230,
    "\u{1E00B}"=>230,
    "\u{1E00C}"=>230,
    "\u{1E00D}"=>230,
    "\u{1E00E}"=>230,
    "\u{1E00F}"=>230,
    "\u{1E010}"=>230,
    "\u{1E011}"=>230,
    "\u{1E012}"=>230,
    "\u{1E013}"=>230,
    "\u{1E014}"=>230,
    "\u{1E015}"=>230,
    "\u{1E016}"=>230,
    "\u{1E017}"=>230,
    "\u{1E018}"=>230,
    "\u{1E01B}"=>230,
    "\u{1E01C}"=>230,
    "\u{1E01D}"=>230,
    "\u{1E01E}"=>230,
    "\u{1E01F}"=>230,
    "\u{1E020}"=>230,
    "\u{1E021}"=>230,
    "\u{1E023}"=>230,
    "\u{1E024}"=>230,
    "\u{1E026}"=>230,
    "\u{1E027}"=>230,
    "\u{1E028}"=>230,
    "\u{1E029}"=>230,
    "\u{1E02A}"=>230,
    "\u{1E130}"=>230,
    "\u{1E131}"=>230,
    "\u{1E132}"=>230,
    "\u{1E133}"=>230,
    "\u{1E134}"=>230,
    "\u{1E135}"=>230,
    "\u{1E136}"=>230,
    "\u{1E2EC}"=>230,
    "\u{1E2ED}"=>230,
    "\u{1E2EE}"=>230,
    "\u{1E2EF}"=>230,
    "\u{1E8D0}"=>220,
    "\u{1E8D1}"=>220,
    "\u{1E8D2}"=>220,
    "\u{1E8D3}"=>220,
    "\u{1E8D4}"=>220,
    "\u{1E8D5}"=>220,
    "\u{1E8D6}"=>220,
    "\u{1E944}"=>230,
    "\u{1E945}"=>230,
    "\u{1E946}"=>230,
    "\u{1E947}"=>230,
    "\u{1E948}"=>230,
    "\u{1E949}"=>230,
    "\u{1E94A}"=>7,
  }
  class_table.default = 0
  CLASS_TABLE = class_table.freeze

  DECOMPOSITION_TABLE = {
    "\u00C0"=>"A\u0300",
    "\u00C1"=>"A\u0301",
    "\u00C2"=>"A\u0302",
    "\u00C3"=>"A\u0303",
    "\u00C4"=>"A\u0308",
    "\u00C5"=>"A\u030A",
    "\u00C7"=>"C\u0327",
    "\u00C8"=>"E\u0300",
    "\u00C9"=>"E\u0301",
    "\u00CA"=>"E\u0302",
    "\u00CB"=>"E\u0308",
    "\u00CC"=>"I\u0300",
    "\u00CD"=>"I\u0301",
    "\u00CE"=>"I\u0302",
    "\u00CF"=>"I\u0308",
    "\u00D1"=>"N\u0303",
    "\u00D2"=>"O\u0300",
    "\u00D3"=>"O\u0301",
    "\u00D4"=>"O\u0302",
    "\u00D5"=>"O\u0303",
    "\u00D6"=>"O\u0308",
    "\u00D9"=>"U\u0300",
    "\u00DA"=>"U\u0301",
    "\u00DB"=>"U\u0302",
    "\u00DC"=>"U\u0308",
    "\u00DD"=>"Y\u0301",
    "\u00E0"=>"a\u0300",
    "\u00E1"=>"a\u0301",
    "\u00E2"=>"a\u0302",
    "\u00E3"=>"a\u0303",
    "\u00E4"=>"a\u0308",
    "\u00E5"=>"a\u030A",
    "\u00E7"=>"c\u0327",
    "\u00E8"=>"e\u0300",
    "\u00E9"=>"e\u0301",
    "\u00EA"=>"e\u0302",
    "\u00EB"=>"e\u0308",
    "\u00EC"=>"i\u0300",
    "\u00ED"=>"i\u0301",
    "\u00EE"=>"i\u0302",
    "\u00EF"=>"i\u0308",
    "\u00F1"=>"n\u0303",
    "\u00F2"=>"o\u0300",
    "\u00F3"=>"o\u0301",
    "\u00F4"=>"o\u0302",
    "\u00F5"=>"o\u0303",
    "\u00F6"=>"o\u0308",
    "\u00F9"=>"u\u0300",
    "\u00FA"=>"u\u0301",
    "\u00FB"=>"u\u0302",
    "\u00FC"=>"u\u0308",
    "\u00FD"=>"y\u0301",
    "\u00FF"=>"y\u0308",
    "\u0100"=>"A\u0304",
    "\u0101"=>"a\u0304",
    "\u0102"=>"A\u0306",
    "\u0103"=>"a\u0306",
    "\u0104"=>"A\u0328",
    "\u0105"=>"a\u0328",
    "\u0106"=>"C\u0301",
    "\u0107"=>"c\u0301",
    "\u0108"=>"C\u0302",
    "\u0109"=>"c\u0302",
    "\u010A"=>"C\u0307",
    "\u010B"=>"c\u0307",
    "\u010C"=>"C\u030C",
    "\u010D"=>"c\u030C",
    "\u010E"=>"D\u030C",
    "\u010F"=>"d\u030C",
    "\u0112"=>"E\u0304",
    "\u0113"=>"e\u0304",
    "\u0114"=>"E\u0306",
    "\u0115"=>"e\u0306",
    "\u0116"=>"E\u0307",
    "\u0117"=>"e\u0307",
    "\u0118"=>"E\u0328",
    "\u0119"=>"e\u0328",
    "\u011A"=>"E\u030C",
    "\u011B"=>"e\u030C",
    "\u011C"=>"G\u0302",
    "\u011D"=>"g\u0302",
    "\u011E"=>"G\u0306",
    "\u011F"=>"g\u0306",
    "\u0120"=>"G\u0307",
    "\u0121"=>"g\u0307",
    "\u0122"=>"G\u0327",
    "\u0123"=>"g\u0327",
    "\u0124"=>"H\u0302",
    "\u0125"=>"h\u0302",
    "\u0128"=>"I\u0303",
    "\u0129"=>"i\u0303",
    "\u012A"=>"I\u0304",
    "\u012B"=>"i\u0304",
    "\u012C"=>"I\u0306",
    "\u012D"=>"i\u0306",
    "\u012E"=>"I\u0328",
    "\u012F"=>"i\u0328",
    "\u0130"=>"I\u0307",
    "\u0134"=>"J\u0302",
    "\u0135"=>"j\u0302",
    "\u0136"=>"K\u0327",
    "\u0137"=>"k\u0327",
    "\u0139"=>"L\u0301",
    "\u013A"=>"l\u0301",
    "\u013B"=>"L\u0327",
    "\u013C"=>"l\u0327",
    "\u013D"=>"L\u030C",
    "\u013E"=>"l\u030C",
    "\u0143"=>"N\u0301",
    "\u0144"=>"n\u0301",
    "\u0145"=>"N\u0327",
    "\u0146"=>"n\u0327",
    "\u0147"=>"N\u030C",
    "\u0148"=>"n\u030C",
    "\u014C"=>"O\u0304",
    "\u014D"=>"o\u0304",
    "\u014E"=>"O\u0306",
    "\u014F"=>"o\u0306",
    "\u0150"=>"O\u030B",
    "\u0151"=>"o\u030B",
    "\u0154"=>"R\u0301",
    "\u0155"=>"r\u0301",
    "\u0156"=>"R\u0327",
    "\u0157"=>"r\u0327",
    "\u0158"=>"R\u030C",
    "\u0159"=>"r\u030C",
    "\u015A"=>"S\u0301",
    "\u015B"=>"s\u0301",
    "\u015C"=>"S\u0302",
    "\u015D"=>"s\u0302",
    "\u015E"=>"S\u0327",
    "\u015F"=>"s\u0327",
    "\u0160"=>"S\u030C",
    "\u0161"=>"s\u030C",
    "\u0162"=>"T\u0327",
    "\u0163"=>"t\u0327",
    "\u0164"=>"T\u030C",
    "\u0165"=>"t\u030C",
    "\u0168"=>"U\u0303",
    "\u0169"=>"u\u0303",
    "\u016A"=>"U\u0304",
    "\u016B"=>"u\u0304",
    "\u016C"=>"U\u0306",
    "\u016D"=>"u\u0306",
    "\u016E"=>"U\u030A",
    "\u016F"=>"u\u030A",
    "\u0170"=>"U\u030B",
    "\u0171"=>"u\u030B",
    "\u0172"=>"U\u0328",
    "\u0173"=>"u\u0328",
    "\u0174"=>"W\u0302",
    "\u0175"=>"w\u0302",
    "\u0176"=>"Y\u0302",
    "\u0177"=>"y\u0302",
    "\u0178"=>"Y\u0308",
    "\u0179"=>"Z\u0301",
    "\u017A"=>"z\u0301",
    "\u017B"=>"Z\u0307",
    "\u017C"=>"z\u0307",
    "\u017D"=>"Z\u030C",
    "\u017E"=>"z\u030C",
    "\u01A0"=>"O\u031B",
    "\u01A1"=>"o\u031B",
    "\u01AF"=>"U\u031B",
    "\u01B0"=>"u\u031B",
    "\u01CD"=>"A\u030C",
    "\u01CE"=>"a\u030C",
    "\u01CF"=>"I\u030C",
    "\u01D0"=>"i\u030C",
    "\u01D1"=>"O\u030C",
    "\u01D2"=>"o\u030C",
    "\u01D3"=>"U\u030C",
    "\u01D4"=>"u\u030C",
    "\u01D5"=>"U\u0308\u0304",
    "\u01D6"=>"u\u0308\u0304",
    "\u01D7"=>"U\u0308\u0301",
    "\u01D8"=>"u\u0308\u0301",
    "\u01D9"=>"U\u0308\u030C",
    "\u01DA"=>"u\u0308\u030C",
    "\u01DB"=>"U\u0308\u0300",
    "\u01DC"=>"u\u0308\u0300",
    "\u01DE"=>"A\u0308\u0304",
    "\u01DF"=>"a\u0308\u0304",
    "\u01E0"=>"A\u0307\u0304",
    "\u01E1"=>"a\u0307\u0304",
    "\u01E2"=>"\u00C6\u0304",
    "\u01E3"=>"\u00E6\u0304",
    "\u01E6"=>"G\u030C",
    "\u01E7"=>"g\u030C",
    "\u01E8"=>"K\u030C",
    "\u01E9"=>"k\u030C",
    "\u01EA"=>"O\u0328",
    "\u01EB"=>"o\u0328",
    "\u01EC"=>"O\u0328\u0304",
    "\u01ED"=>"o\u0328\u0304",
    "\u01EE"=>"\u01B7\u030C",
    "\u01EF"=>"\u0292\u030C",
    "\u01F0"=>"j\u030C",
    "\u01F4"=>"G\u0301",
    "\u01F5"=>"g\u0301",
    "\u01F8"=>"N\u0300",
    "\u01F9"=>"n\u0300",
    "\u01FA"=>"A\u030A\u0301",
    "\u01FB"=>"a\u030A\u0301",
    "\u01FC"=>"\u00C6\u0301",
    "\u01FD"=>"\u00E6\u0301",
    "\u01FE"=>"\u00D8\u0301",
    "\u01FF"=>"\u00F8\u0301",
    "\u0200"=>"A\u030F",
    "\u0201"=>"a\u030F",
    "\u0202"=>"A\u0311",
    "\u0203"=>"a\u0311",
    "\u0204"=>"E\u030F",
    "\u0205"=>"e\u030F",
    "\u0206"=>"E\u0311",
    "\u0207"=>"e\u0311",
    "\u0208"=>"I\u030F",
    "\u0209"=>"i\u030F",
    "\u020A"=>"I\u0311",
    "\u020B"=>"i\u0311",
    "\u020C"=>"O\u030F",
    "\u020D"=>"o\u030F",
    "\u020E"=>"O\u0311",
    "\u020F"=>"o\u0311",
    "\u0210"=>"R\u030F",
    "\u0211"=>"r\u030F",
    "\u0212"=>"R\u0311",
    "\u0213"=>"r\u0311",
    "\u0214"=>"U\u030F",
    "\u0215"=>"u\u030F",
    "\u0216"=>"U\u0311",
    "\u0217"=>"u\u0311",
    "\u0218"=>"S\u0326",
    "\u0219"=>"s\u0326",
    "\u021A"=>"T\u0326",
    "\u021B"=>"t\u0326",
    "\u021E"=>"H\u030C",
    "\u021F"=>"h\u030C",
    "\u0226"=>"A\u0307",
    "\u0227"=>"a\u0307",
    "\u0228"=>"E\u0327",
    "\u0229"=>"e\u0327",
    "\u022A"=>"O\u0308\u0304",
    "\u022B"=>"o\u0308\u0304",
    "\u022C"=>"O\u0303\u0304",
    "\u022D"=>"o\u0303\u0304",
    "\u022E"=>"O\u0307",
    "\u022F"=>"o\u0307",
    "\u0230"=>"O\u0307\u0304",
    "\u0231"=>"o\u0307\u0304",
    "\u0232"=>"Y\u0304",
    "\u0233"=>"y\u0304",
    "\u0340"=>"\u0300",
    "\u0341"=>"\u0301",
    "\u0343"=>"\u0313",
    "\u0344"=>"\u0308\u0301",
    "\u0374"=>"\u02B9",
    "\u037E"=>";",
    "\u0385"=>"\u00A8\u0301",
    "\u0386"=>"\u0391\u0301",
    "\u0387"=>"\u00B7",
    "\u0388"=>"\u0395\u0301",
    "\u0389"=>"\u0397\u0301",
    "\u038A"=>"\u0399\u0301",
    "\u038C"=>"\u039F\u0301",
    "\u038E"=>"\u03A5\u0301",
    "\u038F"=>"\u03A9\u0301",
    "\u0390"=>"\u03B9\u0308\u0301",
    "\u03AA"=>"\u0399\u0308",
    "\u03AB"=>"\u03A5\u0308",
    "\u03AC"=>"\u03B1\u0301",
    "\u03AD"=>"\u03B5\u0301",
    "\u03AE"=>"\u03B7\u0301",
    "\u03AF"=>"\u03B9\u0301",
    "\u03B0"=>"\u03C5\u0308\u0301",
    "\u03CA"=>"\u03B9\u0308",
    "\u03CB"=>"\u03C5\u0308",
    "\u03CC"=>"\u03BF\u0301",
    "\u03CD"=>"\u03C5\u0301",
    "\u03CE"=>"\u03C9\u0301",
    "\u03D3"=>"\u03D2\u0301",
    "\u03D4"=>"\u03D2\u0308",
    "\u0400"=>"\u0415\u0300",
    "\u0401"=>"\u0415\u0308",
    "\u0403"=>"\u0413\u0301",
    "\u0407"=>"\u0406\u0308",
    "\u040C"=>"\u041A\u0301",
    "\u040D"=>"\u0418\u0300",
    "\u040E"=>"\u0423\u0306",
    "\u0419"=>"\u0418\u0306",
    "\u0439"=>"\u0438\u0306",
    "\u0450"=>"\u0435\u0300",
    "\u0451"=>"\u0435\u0308",
    "\u0453"=>"\u0433\u0301",
    "\u0457"=>"\u0456\u0308",
    "\u045C"=>"\u043A\u0301",
    "\u045D"=>"\u0438\u0300",
    "\u045E"=>"\u0443\u0306",
    "\u0476"=>"\u0474\u030F",
    "\u0477"=>"\u0475\u030F",
    "\u04C1"=>"\u0416\u0306",
    "\u04C2"=>"\u0436\u0306",
    "\u04D0"=>"\u0410\u0306",
    "\u04D1"=>"\u0430\u0306",
    "\u04D2"=>"\u0410\u0308",
    "\u04D3"=>"\u0430\u0308",
    "\u04D6"=>"\u0415\u0306",
    "\u04D7"=>"\u0435\u0306",
    "\u04DA"=>"\u04D8\u0308",
    "\u04DB"=>"\u04D9\u0308",
    "\u04DC"=>"\u0416\u0308",
    "\u04DD"=>"\u0436\u0308",
    "\u04DE"=>"\u0417\u0308",
    "\u04DF"=>"\u0437\u0308",
    "\u04E2"=>"\u0418\u0304",
    "\u04E3"=>"\u0438\u0304",
    "\u04E4"=>"\u0418\u0308",
    "\u04E5"=>"\u0438\u0308",
    "\u04E6"=>"\u041E\u0308",
    "\u04E7"=>"\u043E\u0308",
    "\u04EA"=>"\u04E8\u0308",
    "\u04EB"=>"\u04E9\u0308",
    "\u04EC"=>"\u042D\u0308",
    "\u04ED"=>"\u044D\u0308",
    "\u04EE"=>"\u0423\u0304",
    "\u04EF"=>"\u0443\u0304",
    "\u04F0"=>"\u0423\u0308",
    "\u04F1"=>"\u0443\u0308",
    "\u04F2"=>"\u0423\u030B",
    "\u04F3"=>"\u0443\u030B",
    "\u04F4"=>"\u0427\u0308",
    "\u04F5"=>"\u0447\u0308",
    "\u04F8"=>"\u042B\u0308",
    "\u04F9"=>"\u044B\u0308",
    "\u0622"=>"\u0627\u0653",
    "\u0623"=>"\u0627\u0654",
    "\u0624"=>"\u0648\u0654",
    "\u0625"=>"\u0627\u0655",
    "\u0626"=>"\u064A\u0654",
    "\u06C0"=>"\u06D5\u0654",
    "\u06C2"=>"\u06C1\u0654",
    "\u06D3"=>"\u06D2\u0654",
    "\u0929"=>"\u0928\u093C",
    "\u0931"=>"\u0930\u093C",
    "\u0934"=>"\u0933\u093C",
    "\u0958"=>"\u0915\u093C",
    "\u0959"=>"\u0916\u093C",
    "\u095A"=>"\u0917\u093C",
    "\u095B"=>"\u091C\u093C",
    "\u095C"=>"\u0921\u093C",
    "\u095D"=>"\u0922\u093C",
    "\u095E"=>"\u092B\u093C",
    "\u095F"=>"\u092F\u093C",
    "\u09CB"=>"\u09C7\u09BE",
    "\u09CC"=>"\u09C7\u09D7",
    "\u09DC"=>"\u09A1\u09BC",
    "\u09DD"=>"\u09A2\u09BC",
    "\u09DF"=>"\u09AF\u09BC",
    "\u0A33"=>"\u0A32\u0A3C",
    "\u0A36"=>"\u0A38\u0A3C",
    "\u0A59"=>"\u0A16\u0A3C",
    "\u0A5A"=>"\u0A17\u0A3C",
    "\u0A5B"=>"\u0A1C\u0A3C",
    "\u0A5E"=>"\u0A2B\u0A3C",
    "\u0B48"=>"\u0B47\u0B56",
    "\u0B4B"=>"\u0B47\u0B3E",
    "\u0B4C"=>"\u0B47\u0B57",
    "\u0B5C"=>"\u0B21\u0B3C",
    "\u0B5D"=>"\u0B22\u0B3C",
    "\u0B94"=>"\u0B92\u0BD7",
    "\u0BCA"=>"\u0BC6\u0BBE",
    "\u0BCB"=>"\u0BC7\u0BBE",
    "\u0BCC"=>"\u0BC6\u0BD7",
    "\u0C48"=>"\u0C46\u0C56",
    "\u0CC0"=>"\u0CBF\u0CD5",
    "\u0CC7"=>"\u0CC6\u0CD5",
    "\u0CC8"=>"\u0CC6\u0CD6",
    "\u0CCA"=>"\u0CC6\u0CC2",
    "\u0CCB"=>"\u0CC6\u0CC2\u0CD5",
    "\u0D4A"=>"\u0D46\u0D3E",
    "\u0D4B"=>"\u0D47\u0D3E",
    "\u0D4C"=>"\u0D46\u0D57",
    "\u0DDA"=>"\u0DD9\u0DCA",
    "\u0DDC"=>"\u0DD9\u0DCF",
    "\u0DDD"=>"\u0DD9\u0DCF\u0DCA",
    "\u0DDE"=>"\u0DD9\u0DDF",
    "\u0F43"=>"\u0F42\u0FB7",
    "\u0F4D"=>"\u0F4C\u0FB7",
    "\u0F52"=>"\u0F51\u0FB7",
    "\u0F57"=>"\u0F56\u0FB7",
    "\u0F5C"=>"\u0F5B\u0FB7",
    "\u0F69"=>"\u0F40\u0FB5",
    "\u0F73"=>"\u0F71\u0F72",
    "\u0F75"=>"\u0F71\u0F74",
    "\u0F76"=>"\u0FB2\u0F80",
    "\u0F78"=>"\u0FB3\u0F80",
    "\u0F81"=>"\u0F71\u0F80",
    "\u0F93"=>"\u0F92\u0FB7",
    "\u0F9D"=>"\u0F9C\u0FB7",
    "\u0FA2"=>"\u0FA1\u0FB7",
    "\u0FA7"=>"\u0FA6\u0FB7",
    "\u0FAC"=>"\u0FAB\u0FB7",
    "\u0FB9"=>"\u0F90\u0FB5",
    "\u1026"=>"\u1025\u102E",
    "\u1B06"=>"\u1B05\u1B35",
    "\u1B08"=>"\u1B07\u1B35",
    "\u1B0A"=>"\u1B09\u1B35",
    "\u1B0C"=>"\u1B0B\u1B35",
    "\u1B0E"=>"\u1B0D\u1B35",
    "\u1B12"=>"\u1B11\u1B35",
    "\u1B3B"=>"\u1B3A\u1B35",
    "\u1B3D"=>"\u1B3C\u1B35",
    "\u1B40"=>"\u1B3E\u1B35",
    "\u1B41"=>"\u1B3F\u1B35",
    "\u1B43"=>"\u1B42\u1B35",
    "\u1E00"=>"A\u0325",
    "\u1E01"=>"a\u0325",
    "\u1E02"=>"B\u0307",
    "\u1E03"=>"b\u0307",
    "\u1E04"=>"B\u0323",
    "\u1E05"=>"b\u0323",
    "\u1E06"=>"B\u0331",
    "\u1E07"=>"b\u0331",
    "\u1E08"=>"C\u0327\u0301",
    "\u1E09"=>"c\u0327\u0301",
    "\u1E0A"=>"D\u0307",
    "\u1E0B"=>"d\u0307",
    "\u1E0C"=>"D\u0323",
    "\u1E0D"=>"d\u0323",
    "\u1E0E"=>"D\u0331",
    "\u1E0F"=>"d\u0331",
    "\u1E10"=>"D\u0327",
    "\u1E11"=>"d\u0327",
    "\u1E12"=>"D\u032D",
    "\u1E13"=>"d\u032D",
    "\u1E14"=>"E\u0304\u0300",
    "\u1E15"=>"e\u0304\u0300",
    "\u1E16"=>"E\u0304\u0301",
    "\u1E17"=>"e\u0304\u0301",
    "\u1E18"=>"E\u032D",
    "\u1E19"=>"e\u032D",
    "\u1E1A"=>"E\u0330",
    "\u1E1B"=>"e\u0330",
    "\u1E1C"=>"E\u0327\u0306",
    "\u1E1D"=>"e\u0327\u0306",
    "\u1E1E"=>"F\u0307",
    "\u1E1F"=>"f\u0307",
    "\u1E20"=>"G\u0304",
    "\u1E21"=>"g\u0304",
    "\u1E22"=>"H\u0307",
    "\u1E23"=>"h\u0307",
    "\u1E24"=>"H\u0323",
    "\u1E25"=>"h\u0323",
    "\u1E26"=>"H\u0308",
    "\u1E27"=>"h\u0308",
    "\u1E28"=>"H\u0327",
    "\u1E29"=>"h\u0327",
    "\u1E2A"=>"H\u032E",
    "\u1E2B"=>"h\u032E",
    "\u1E2C"=>"I\u0330",
    "\u1E2D"=>"i\u0330",
    "\u1E2E"=>"I\u0308\u0301",
    "\u1E2F"=>"i\u0308\u0301",
    "\u1E30"=>"K\u0301",
    "\u1E31"=>"k\u0301",
    "\u1E32"=>"K\u0323",
    "\u1E33"=>"k\u0323",
    "\u1E34"=>"K\u0331",
    "\u1E35"=>"k\u0331",
    "\u1E36"=>"L\u0323",
    "\u1E37"=>"l\u0323",
    "\u1E38"=>"L\u0323\u0304",
    "\u1E39"=>"l\u0323\u0304",
    "\u1E3A"=>"L\u0331",
    "\u1E3B"=>"l\u0331",
    "\u1E3C"=>"L\u032D",
    "\u1E3D"=>"l\u032D",
    "\u1E3E"=>"M\u0301",
    "\u1E3F"=>"m\u0301",
    "\u1E40"=>"M\u0307",
    "\u1E41"=>"m\u0307",
    "\u1E42"=>"M\u0323",
    "\u1E43"=>"m\u0323",
    "\u1E44"=>"N\u0307",
    "\u1E45"=>"n\u0307",
    "\u1E46"=>"N\u0323",
    "\u1E47"=>"n\u0323",
    "\u1E48"=>"N\u0331",
    "\u1E49"=>"n\u0331",
    "\u1E4A"=>"N\u032D",
    "\u1E4B"=>"n\u032D",
    "\u1E4C"=>"O\u0303\u0301",
    "\u1E4D"=>"o\u0303\u0301",
    "\u1E4E"=>"O\u0303\u0308",
    "\u1E4F"=>"o\u0303\u0308",
    "\u1E50"=>"O\u0304\u0300",
    "\u1E51"=>"o\u0304\u0300",
    "\u1E52"=>"O\u0304\u0301",
    "\u1E53"=>"o\u0304\u0301",
    "\u1E54"=>"P\u0301",
    "\u1E55"=>"p\u0301",
    "\u1E56"=>"P\u0307",
    "\u1E57"=>"p\u0307",
    "\u1E58"=>"R\u0307",
    "\u1E59"=>"r\u0307",
    "\u1E5A"=>"R\u0323",
    "\u1E5B"=>"r\u0323",
    "\u1E5C"=>"R\u0323\u0304",
    "\u1E5D"=>"r\u0323\u0304",
    "\u1E5E"=>"R\u0331",
    "\u1E5F"=>"r\u0331",
    "\u1E60"=>"S\u0307",
    "\u1E61"=>"s\u0307",
    "\u1E62"=>"S\u0323",
    "\u1E63"=>"s\u0323",
    "\u1E64"=>"S\u0301\u0307",
    "\u1E65"=>"s\u0301\u0307",
    "\u1E66"=>"S\u030C\u0307",
    "\u1E67"=>"s\u030C\u0307",
    "\u1E68"=>"S\u0323\u0307",
    "\u1E69"=>"s\u0323\u0307",
    "\u1E6A"=>"T\u0307",
    "\u1E6B"=>"t\u0307",
    "\u1E6C"=>"T\u0323",
    "\u1E6D"=>"t\u0323",
    "\u1E6E"=>"T\u0331",
    "\u1E6F"=>"t\u0331",
    "\u1E70"=>"T\u032D",
    "\u1E71"=>"t\u032D",
    "\u1E72"=>"U\u0324",
    "\u1E73"=>"u\u0324",
    "\u1E74"=>"U\u0330",
    "\u1E75"=>"u\u0330",
    "\u1E76"=>"U\u032D",
    "\u1E77"=>"u\u032D",
    "\u1E78"=>"U\u0303\u0301",
    "\u1E79"=>"u\u0303\u0301",
    "\u1E7A"=>"U\u0304\u0308",
    "\u1E7B"=>"u\u0304\u0308",
    "\u1E7C"=>"V\u0303",
    "\u1E7D"=>"v\u0303",
    "\u1E7E"=>"V\u0323",
    "\u1E7F"=>"v\u0323",
    "\u1E80"=>"W\u0300",
    "\u1E81"=>"w\u0300",
    "\u1E82"=>"W\u0301",
    "\u1E83"=>"w\u0301",
    "\u1E84"=>"W\u0308",
    "\u1E85"=>"w\u0308",
    "\u1E86"=>"W\u0307",
    "\u1E87"=>"w\u0307",
    "\u1E88"=>"W\u0323",
    "\u1E89"=>"w\u0323",
    "\u1E8A"=>"X\u0307",
    "\u1E8B"=>"x\u0307",
    "\u1E8C"=>"X\u0308",
    "\u1E8D"=>"x\u0308",
    "\u1E8E"=>"Y\u0307",
    "\u1E8F"=>"y\u0307",
    "\u1E90"=>"Z\u0302",
    "\u1E91"=>"z\u0302",
    "\u1E92"=>"Z\u0323",
    "\u1E93"=>"z\u0323",
    "\u1E94"=>"Z\u0331",
    "\u1E95"=>"z\u0331",
    "\u1E96"=>"h\u0331",
    "\u1E97"=>"t\u0308",
    "\u1E98"=>"w\u030A",
    "\u1E99"=>"y\u030A",
    "\u1E9B"=>"\u017F\u0307",
    "\u1EA0"=>"A\u0323",
    "\u1EA1"=>"a\u0323",
    "\u1EA2"=>"A\u0309",
    "\u1EA3"=>"a\u0309",
    "\u1EA4"=>"A\u0302\u0301",
    "\u1EA5"=>"a\u0302\u0301",
    "\u1EA6"=>"A\u0302\u0300",
    "\u1EA7"=>"a\u0302\u0300",
    "\u1EA8"=>"A\u0302\u0309",
    "\u1EA9"=>"a\u0302\u0309",
    "\u1EAA"=>"A\u0302\u0303",
    "\u1EAB"=>"a\u0302\u0303",
    "\u1EAC"=>"A\u0323\u0302",
    "\u1EAD"=>"a\u0323\u0302",
    "\u1EAE"=>"A\u0306\u0301",
    "\u1EAF"=>"a\u0306\u0301",
    "\u1EB0"=>"A\u0306\u0300",
    "\u1EB1"=>"a\u0306\u0300",
    "\u1EB2"=>"A\u0306\u0309",
    "\u1EB3"=>"a\u0306\u0309",
    "\u1EB4"=>"A\u0306\u0303",
    "\u1EB5"=>"a\u0306\u0303",
    "\u1EB6"=>"A\u0323\u0306",
    "\u1EB7"=>"a\u0323\u0306",
    "\u1EB8"=>"E\u0323",
    "\u1EB9"=>"e\u0323",
    "\u1EBA"=>"E\u0309",
    "\u1EBB"=>"e\u0309",
    "\u1EBC"=>"E\u0303",
    "\u1EBD"=>"e\u0303",
    "\u1EBE"=>"E\u0302\u0301",
    "\u1EBF"=>"e\u0302\u0301",
    "\u1EC0"=>"E\u0302\u0300",
    "\u1EC1"=>"e\u0302\u0300",
    "\u1EC2"=>"E\u0302\u0309",
    "\u1EC3"=>"e\u0302\u0309",
    "\u1EC4"=>"E\u0302\u0303",
    "\u1EC5"=>"e\u0302\u0303",
    "\u1EC6"=>"E\u0323\u0302",
    "\u1EC7"=>"e\u0323\u0302",
    "\u1EC8"=>"I\u0309",
    "\u1EC9"=>"i\u0309",
    "\u1ECA"=>"I\u0323",
    "\u1ECB"=>"i\u0323",
    "\u1ECC"=>"O\u0323",
    "\u1ECD"=>"o\u0323",
    "\u1ECE"=>"O\u0309",
    "\u1ECF"=>"o\u0309",
    "\u1ED0"=>"O\u0302\u0301",
    "\u1ED1"=>"o\u0302\u0301",
    "\u1ED2"=>"O\u0302\u0300",
    "\u1ED3"=>"o\u0302\u0300",
    "\u1ED4"=>"O\u0302\u0309",
    "\u1ED5"=>"o\u0302\u0309",
    "\u1ED6"=>"O\u0302\u0303",
    "\u1ED7"=>"o\u0302\u0303",
    "\u1ED8"=>"O\u0323\u0302",
    "\u1ED9"=>"o\u0323\u0302",
    "\u1EDA"=>"O\u031B\u0301",
    "\u1EDB"=>"o\u031B\u0301",
    "\u1EDC"=>"O\u031B\u0300",
    "\u1EDD"=>"o\u031B\u0300",
    "\u1EDE"=>"O\u031B\u0309",
    "\u1EDF"=>"o\u031B\u0309",
    "\u1EE0"=>"O\u031B\u0303",
    "\u1EE1"=>"o\u031B\u0303",
    "\u1EE2"=>"O\u031B\u0323",
    "\u1EE3"=>"o\u031B\u0323",
    "\u1EE4"=>"U\u0323",
    "\u1EE5"=>"u\u0323",
    "\u1EE6"=>"U\u0309",
    "\u1EE7"=>"u\u0309",
    "\u1EE8"=>"U\u031B\u0301",
    "\u1EE9"=>"u\u031B\u0301",
    "\u1EEA"=>"U\u031B\u0300",
    "\u1EEB"=>"u\u031B\u0300",
    "\u1EEC"=>"U\u031B\u0309",
    "\u1EED"=>"u\u031B\u0309",
    "\u1EEE"=>"U\u031B\u0303",
    "\u1EEF"=>"u\u031B\u0303",
    "\u1EF0"=>"U\u031B\u0323",
    "\u1EF1"=>"u\u031B\u0323",
    "\u1EF2"=>"Y\u0300",
    "\u1EF3"=>"y\u0300",
    "\u1EF4"=>"Y\u0323",
    "\u1EF5"=>"y\u0323",
    "\u1EF6"=>"Y\u0309",
    "\u1EF7"=>"y\u0309",
    "\u1EF8"=>"Y\u0303",
    "\u1EF9"=>"y\u0303",
    "\u1F00"=>"\u03B1\u0313",
    "\u1F01"=>"\u03B1\u0314",
    "\u1F02"=>"\u03B1\u0313\u0300",
    "\u1F03"=>"\u03B1\u0314\u0300",
    "\u1F04"=>"\u03B1\u0313\u0301",
    "\u1F05"=>"\u03B1\u0314\u0301",
    "\u1F06"=>"\u03B1\u0313\u0342",
    "\u1F07"=>"\u03B1\u0314\u0342",
    "\u1F08"=>"\u0391\u0313",
    "\u1F09"=>"\u0391\u0314",
    "\u1F0A"=>"\u0391\u0313\u0300",
    "\u1F0B"=>"\u0391\u0314\u0300",
    "\u1F0C"=>"\u0391\u0313\u0301",
    "\u1F0D"=>"\u0391\u0314\u0301",
    "\u1F0E"=>"\u0391\u0313\u0342",
    "\u1F0F"=>"\u0391\u0314\u0342",
    "\u1F10"=>"\u03B5\u0313",
    "\u1F11"=>"\u03B5\u0314",
    "\u1F12"=>"\u03B5\u0313\u0300",
    "\u1F13"=>"\u03B5\u0314\u0300",
    "\u1F14"=>"\u03B5\u0313\u0301",
    "\u1F15"=>"\u03B5\u0314\u0301",
    "\u1F18"=>"\u0395\u0313",
    "\u1F19"=>"\u0395\u0314",
    "\u1F1A"=>"\u0395\u0313\u0300",
    "\u1F1B"=>"\u0395\u0314\u0300",
    "\u1F1C"=>"\u0395\u0313\u0301",
    "\u1F1D"=>"\u0395\u0314\u0301",
    "\u1F20"=>"\u03B7\u0313",
    "\u1F21"=>"\u03B7\u0314",
    "\u1F22"=>"\u03B7\u0313\u0300",
    "\u1F23"=>"\u03B7\u0314\u0300",
    "\u1F24"=>"\u03B7\u0313\u0301",
    "\u1F25"=>"\u03B7\u0314\u0301",
    "\u1F26"=>"\u03B7\u0313\u0342",
    "\u1F27"=>"\u03B7\u0314\u0342",
    "\u1F28"=>"\u0397\u0313",
    "\u1F29"=>"\u0397\u0314",
    "\u1F2A"=>"\u0397\u0313\u0300",
    "\u1F2B"=>"\u0397\u0314\u0300",
    "\u1F2C"=>"\u0397\u0313\u0301",
    "\u1F2D"=>"\u0397\u0314\u0301",
    "\u1F2E"=>"\u0397\u0313\u0342",
    "\u1F2F"=>"\u0397\u0314\u0342",
    "\u1F30"=>"\u03B9\u0313",
    "\u1F31"=>"\u03B9\u0314",
    "\u1F32"=>"\u03B9\u0313\u0300",
    "\u1F33"=>"\u03B9\u0314\u0300",
    "\u1F34"=>"\u03B9\u0313\u0301",
    "\u1F35"=>"\u03B9\u0314\u0301",
    "\u1F36"=>"\u03B9\u0313\u0342",
    "\u1F37"=>"\u03B9\u0314\u0342",
    "\u1F38"=>"\u0399\u0313",
    "\u1F39"=>"\u0399\u0314",
    "\u1F3A"=>"\u0399\u0313\u0300",
    "\u1F3B"=>"\u0399\u0314\u0300",
    "\u1F3C"=>"\u0399\u0313\u0301",
    "\u1F3D"=>"\u0399\u0314\u0301",
    "\u1F3E"=>"\u0399\u0313\u0342",
    "\u1F3F"=>"\u0399\u0314\u0342",
    "\u1F40"=>"\u03BF\u0313",
    "\u1F41"=>"\u03BF\u0314",
    "\u1F42"=>"\u03BF\u0313\u0300",
    "\u1F43"=>"\u03BF\u0314\u0300",
    "\u1F44"=>"\u03BF\u0313\u0301",
    "\u1F45"=>"\u03BF\u0314\u0301",
    "\u1F48"=>"\u039F\u0313",
    "\u1F49"=>"\u039F\u0314",
    "\u1F4A"=>"\u039F\u0313\u0300",
    "\u1F4B"=>"\u039F\u0314\u0300",
    "\u1F4C"=>"\u039F\u0313\u0301",
    "\u1F4D"=>"\u039F\u0314\u0301",
    "\u1F50"=>"\u03C5\u0313",
    "\u1F51"=>"\u03C5\u0314",
    "\u1F52"=>"\u03C5\u0313\u0300",
    "\u1F53"=>"\u03C5\u0314\u0300",
    "\u1F54"=>"\u03C5\u0313\u0301",
    "\u1F55"=>"\u03C5\u0314\u0301",
    "\u1F56"=>"\u03C5\u0313\u0342",
    "\u1F57"=>"\u03C5\u0314\u0342",
    "\u1F59"=>"\u03A5\u0314",
    "\u1F5B"=>"\u03A5\u0314\u0300",
    "\u1F5D"=>"\u03A5\u0314\u0301",
    "\u1F5F"=>"\u03A5\u0314\u0342",
    "\u1F60"=>"\u03C9\u0313",
    "\u1F61"=>"\u03C9\u0314",
    "\u1F62"=>"\u03C9\u0313\u0300",
    "\u1F63"=>"\u03C9\u0314\u0300",
    "\u1F64"=>"\u03C9\u0313\u0301",
    "\u1F65"=>"\u03C9\u0314\u0301",
    "\u1F66"=>"\u03C9\u0313\u0342",
    "\u1F67"=>"\u03C9\u0314\u0342",
    "\u1F68"=>"\u03A9\u0313",
    "\u1F69"=>"\u03A9\u0314",
    "\u1F6A"=>"\u03A9\u0313\u0300",
    "\u1F6B"=>"\u03A9\u0314\u0300",
    "\u1F6C"=>"\u03A9\u0313\u0301",
    "\u1F6D"=>"\u03A9\u0314\u0301",
    "\u1F6E"=>"\u03A9\u0313\u0342",
    "\u1F6F"=>"\u03A9\u0314\u0342",
    "\u1F70"=>"\u03B1\u0300",
    "\u1F71"=>"\u03B1\u0301",
    "\u1F72"=>"\u03B5\u0300",
    "\u1F73"=>"\u03B5\u0301",
    "\u1F74"=>"\u03B7\u0300",
    "\u1F75"=>"\u03B7\u0301",
    "\u1F76"=>"\u03B9\u0300",
    "\u1F77"=>"\u03B9\u0301",
    "\u1F78"=>"\u03BF\u0300",
    "\u1F79"=>"\u03BF\u0301",
    "\u1F7A"=>"\u03C5\u0300",
    "\u1F7B"=>"\u03C5\u0301",
    "\u1F7C"=>"\u03C9\u0300",
    "\u1F7D"=>"\u03C9\u0301",
    "\u1F80"=>"\u03B1\u0313\u0345",
    "\u1F81"=>"\u03B1\u0314\u0345",
    "\u1F82"=>"\u03B1\u0313\u0300\u0345",
    "\u1F83"=>"\u03B1\u0314\u0300\u0345",
    "\u1F84"=>"\u03B1\u0313\u0301\u0345",
    "\u1F85"=>"\u03B1\u0314\u0301\u0345",
    "\u1F86"=>"\u03B1\u0313\u0342\u0345",
    "\u1F87"=>"\u03B1\u0314\u0342\u0345",
    "\u1F88"=>"\u0391\u0313\u0345",
    "\u1F89"=>"\u0391\u0314\u0345",
    "\u1F8A"=>"\u0391\u0313\u0300\u0345",
    "\u1F8B"=>"\u0391\u0314\u0300\u0345",
    "\u1F8C"=>"\u0391\u0313\u0301\u0345",
    "\u1F8D"=>"\u0391\u0314\u0301\u0345",
    "\u1F8E"=>"\u0391\u0313\u0342\u0345",
    "\u1F8F"=>"\u0391\u0314\u0342\u0345",
    "\u1F90"=>"\u03B7\u0313\u0345",
    "\u1F91"=>"\u03B7\u0314\u0345",
    "\u1F92"=>"\u03B7\u0313\u0300\u0345",
    "\u1F93"=>"\u03B7\u0314\u0300\u0345",
    "\u1F94"=>"\u03B7\u0313\u0301\u0345",
    "\u1F95"=>"\u03B7\u0314\u0301\u0345",
    "\u1F96"=>"\u03B7\u0313\u0342\u0345",
    "\u1F97"=>"\u03B7\u0314\u0342\u0345",
    "\u1F98"=>"\u0397\u0313\u0345",
    "\u1F99"=>"\u0397\u0314\u0345",
    "\u1F9A"=>"\u0397\u0313\u0300\u0345",
    "\u1F9B"=>"\u0397\u0314\u0300\u0345",
    "\u1F9C"=>"\u0397\u0313\u0301\u0345",
    "\u1F9D"=>"\u0397\u0314\u0301\u0345",
    "\u1F9E"=>"\u0397\u0313\u0342\u0345",
    "\u1F9F"=>"\u0397\u0314\u0342\u0345",
    "\u1FA0"=>"\u03C9\u0313\u0345",
    "\u1FA1"=>"\u03C9\u0314\u0345",
    "\u1FA2"=>"\u03C9\u0313\u0300\u0345",
    "\u1FA3"=>"\u03C9\u0314\u0300\u0345",
    "\u1FA4"=>"\u03C9\u0313\u0301\u0345",
    "\u1FA5"=>"\u03C9\u0314\u0301\u0345",
    "\u1FA6"=>"\u03C9\u0313\u0342\u0345",
    "\u1FA7"=>"\u03C9\u0314\u0342\u0345",
    "\u1FA8"=>"\u03A9\u0313\u0345",
    "\u1FA9"=>"\u03A9\u0314\u0345",
    "\u1FAA"=>"\u03A9\u0313\u0300\u0345",
    "\u1FAB"=>"\u03A9\u0314\u0300\u0345",
    "\u1FAC"=>"\u03A9\u0313\u0301\u0345",
    "\u1FAD"=>"\u03A9\u0314\u0301\u0345",
    "\u1FAE"=>"\u03A9\u0313\u0342\u0345",
    "\u1FAF"=>"\u03A9\u0314\u0342\u0345",
    "\u1FB0"=>"\u03B1\u0306",
    "\u1FB1"=>"\u03B1\u0304",
    "\u1FB2"=>"\u03B1\u0300\u0345",
    "\u1FB3"=>"\u03B1\u0345",
    "\u1FB4"=>"\u03B1\u0301\u0345",
    "\u1FB6"=>"\u03B1\u0342",
    "\u1FB7"=>"\u03B1\u0342\u0345",
    "\u1FB8"=>"\u0391\u0306",
    "\u1FB9"=>"\u0391\u0304",
    "\u1FBA"=>"\u0391\u0300",
    "\u1FBB"=>"\u0391\u0301",
    "\u1FBC"=>"\u0391\u0345",
    "\u1FBE"=>"\u03B9",
    "\u1FC1"=>"\u00A8\u0342",
    "\u1FC2"=>"\u03B7\u0300\u0345",
    "\u1FC3"=>"\u03B7\u0345",
    "\u1FC4"=>"\u03B7\u0301\u0345",
    "\u1FC6"=>"\u03B7\u0342",
    "\u1FC7"=>"\u03B7\u0342\u0345",
    "\u1FC8"=>"\u0395\u0300",
    "\u1FC9"=>"\u0395\u0301",
    "\u1FCA"=>"\u0397\u0300",
    "\u1FCB"=>"\u0397\u0301",
    "\u1FCC"=>"\u0397\u0345",
    "\u1FCD"=>"\u1FBF\u0300",
    "\u1FCE"=>"\u1FBF\u0301",
    "\u1FCF"=>"\u1FBF\u0342",
    "\u1FD0"=>"\u03B9\u0306",
    "\u1FD1"=>"\u03B9\u0304",
    "\u1FD2"=>"\u03B9\u0308\u0300",
    "\u1FD3"=>"\u03B9\u0308\u0301",
    "\u1FD6"=>"\u03B9\u0342",
    "\u1FD7"=>"\u03B9\u0308\u0342",
    "\u1FD8"=>"\u0399\u0306",
    "\u1FD9"=>"\u0399\u0304",
    "\u1FDA"=>"\u0399\u0300",
    "\u1FDB"=>"\u0399\u0301",
    "\u1FDD"=>"\u1FFE\u0300",
    "\u1FDE"=>"\u1FFE\u0301",
    "\u1FDF"=>"\u1FFE\u0342",
    "\u1FE0"=>"\u03C5\u0306",
    "\u1FE1"=>"\u03C5\u0304",
    "\u1FE2"=>"\u03C5\u0308\u0300",
    "\u1FE3"=>"\u03C5\u0308\u0301",
    "\u1FE4"=>"\u03C1\u0313",
    "\u1FE5"=>"\u03C1\u0314",
    "\u1FE6"=>"\u03C5\u0342",
    "\u1FE7"=>"\u03C5\u0308\u0342",
    "\u1FE8"=>"\u03A5\u0306",
    "\u1FE9"=>"\u03A5\u0304",
    "\u1FEA"=>"\u03A5\u0300",
    "\u1FEB"=>"\u03A5\u0301",
    "\u1FEC"=>"\u03A1\u0314",
    "\u1FED"=>"\u00A8\u0300",
    "\u1FEE"=>"\u00A8\u0301",
    "\u1FEF"=>"`",
    "\u1FF2"=>"\u03C9\u0300\u0345",
    "\u1FF3"=>"\u03C9\u0345",
    "\u1FF4"=>"\u03C9\u0301\u0345",
    "\u1FF6"=>"\u03C9\u0342",
    "\u1FF7"=>"\u03C9\u0342\u0345",
    "\u1FF8"=>"\u039F\u0300",
    "\u1FF9"=>"\u039F\u0301",
    "\u1FFA"=>"\u03A9\u0300",
    "\u1FFB"=>"\u03A9\u0301",
    "\u1FFC"=>"\u03A9\u0345",
    "\u1FFD"=>"\u00B4",
    "\u2000"=>"\u2002",
    "\u2001"=>"\u2003",
    "\u2126"=>"\u03A9",
    "\u212A"=>"K",
    "\u212B"=>"A\u030A",
    "\u219A"=>"\u2190\u0338",
    "\u219B"=>"\u2192\u0338",
    "\u21AE"=>"\u2194\u0338",
    "\u21CD"=>"\u21D0\u0338",
    "\u21CE"=>"\u21D4\u0338",
    "\u21CF"=>"\u21D2\u0338",
    "\u2204"=>"\u2203\u0338",
    "\u2209"=>"\u2208\u0338",
    "\u220C"=>"\u220B\u0338",
    "\u2224"=>"\u2223\u0338",
    "\u2226"=>"\u2225\u0338",
    "\u2241"=>"\u223C\u0338",
    "\u2244"=>"\u2243\u0338",
    "\u2247"=>"\u2245\u0338",
    "\u2249"=>"\u2248\u0338",
    "\u2260"=>"=\u0338",
    "\u2262"=>"\u2261\u0338",
    "\u226D"=>"\u224D\u0338",
    "\u226E"=>"<\u0338",
    "\u226F"=>">\u0338",
    "\u2270"=>"\u2264\u0338",
    "\u2271"=>"\u2265\u0338",
    "\u2274"=>"\u2272\u0338",
    "\u2275"=>"\u2273\u0338",
    "\u2278"=>"\u2276\u0338",
    "\u2279"=>"\u2277\u0338",
    "\u2280"=>"\u227A\u0338",
    "\u2281"=>"\u227B\u0338",
    "\u2284"=>"\u2282\u0338",
    "\u2285"=>"\u2283\u0338",
    "\u2288"=>"\u2286\u0338",
    "\u2289"=>"\u2287\u0338",
    "\u22AC"=>"\u22A2\u0338",
    "\u22AD"=>"\u22A8\u0338",
    "\u22AE"=>"\u22A9\u0338",
    "\u22AF"=>"\u22AB\u0338",
    "\u22E0"=>"\u227C\u0338",
    "\u22E1"=>"\u227D\u0338",
    "\u22E2"=>"\u2291\u0338",
    "\u22E3"=>"\u2292\u0338",
    "\u22EA"=>"\u22B2\u0338",
    "\u22EB"=>"\u22B3\u0338",
    "\u22EC"=>"\u22B4\u0338",
    "\u22ED"=>"\u22B5\u0338",
    "\u2329"=>"\u3008",
    "\u232A"=>"\u3009",
    "\u2ADC"=>"\u2ADD\u0338",
    "\u304C"=>"\u304B\u3099",
    "\u304E"=>"\u304D\u3099",
    "\u3050"=>"\u304F\u3099",
    "\u3052"=>"\u3051\u3099",
    "\u3054"=>"\u3053\u3099",
    "\u3056"=>"\u3055\u3099",
    "\u3058"=>"\u3057\u3099",
    "\u305A"=>"\u3059\u3099",
    "\u305C"=>"\u305B\u3099",
    "\u305E"=>"\u305D\u3099",
    "\u3060"=>"\u305F\u3099",
    "\u3062"=>"\u3061\u3099",
    "\u3065"=>"\u3064\u3099",
    "\u3067"=>"\u3066\u3099",
    "\u3069"=>"\u3068\u3099",
    "\u3070"=>"\u306F\u3099",
    "\u3071"=>"\u306F\u309A",
    "\u3073"=>"\u3072\u3099",
    "\u3074"=>"\u3072\u309A",
    "\u3076"=>"\u3075\u3099",
    "\u3077"=>"\u3075\u309A",
    "\u3079"=>"\u3078\u3099",
    "\u307A"=>"\u3078\u309A",
    "\u307C"=>"\u307B\u3099",
    "\u307D"=>"\u307B\u309A",
    "\u3094"=>"\u3046\u3099",
    "\u309E"=>"\u309D\u3099",
    "\u30AC"=>"\u30AB\u3099",
    "\u30AE"=>"\u30AD\u3099",
    "\u30B0"=>"\u30AF\u3099",
    "\u30B2"=>"\u30B1\u3099",
    "\u30B4"=>"\u30B3\u3099",
    "\u30B6"=>"\u30B5\u3099",
    "\u30B8"=>"\u30B7\u3099",
    "\u30BA"=>"\u30B9\u3099",
    "\u30BC"=>"\u30BB\u3099",
    "\u30BE"=>"\u30BD\u3099",
    "\u30C0"=>"\u30BF\u3099",
    "\u30C2"=>"\u30C1\u3099",
    "\u30C5"=>"\u30C4\u3099",
    "\u30C7"=>"\u30C6\u3099",
    "\u30C9"=>"\u30C8\u3099",
    "\u30D0"=>"\u30CF\u3099",
    "\u30D1"=>"\u30CF\u309A",
    "\u30D3"=>"\u30D2\u3099",
    "\u30D4"=>"\u30D2\u309A",
    "\u30D6"=>"\u30D5\u3099",
    "\u30D7"=>"\u30D5\u309A",
    "\u30D9"=>"\u30D8\u3099",
    "\u30DA"=>"\u30D8\u309A",
    "\u30DC"=>"\u30DB\u3099",
    "\u30DD"=>"\u30DB\u309A",
    "\u30F4"=>"\u30A6\u3099",
    "\u30F7"=>"\u30EF\u3099",
    "\u30F8"=>"\u30F0\u3099",
    "\u30F9"=>"\u30F1\u3099",
    "\u30FA"=>"\u30F2\u3099",
    "\u30FE"=>"\u30FD\u3099",
    "\uF900"=>"\u8C48",
    "\uF901"=>"\u66F4",
    "\uF902"=>"\u8ECA",
    "\uF903"=>"\u8CC8",
    "\uF904"=>"\u6ED1",
    "\uF905"=>"\u4E32",
    "\uF906"=>"\u53E5",
    "\uF907"=>"\u9F9C",
    "\uF908"=>"\u9F9C",
    "\uF909"=>"\u5951",
    "\uF90A"=>"\u91D1",
    "\uF90B"=>"\u5587",
    "\uF90C"=>"\u5948",
    "\uF90D"=>"\u61F6",
    "\uF90E"=>"\u7669",
    "\uF90F"=>"\u7F85",
    "\uF910"=>"\u863F",
    "\uF911"=>"\u87BA",
    "\uF912"=>"\u88F8",
    "\uF913"=>"\u908F",
    "\uF914"=>"\u6A02",
    "\uF915"=>"\u6D1B",
    "\uF916"=>"\u70D9",
    "\uF917"=>"\u73DE",
    "\uF918"=>"\u843D",
    "\uF919"=>"\u916A",
    "\uF91A"=>"\u99F1",
    "\uF91B"=>"\u4E82",
    "\uF91C"=>"\u5375",
    "\uF91D"=>"\u6B04",
    "\uF91E"=>"\u721B",
    "\uF91F"=>"\u862D",
    "\uF920"=>"\u9E1E",
    "\uF921"=>"\u5D50",
    "\uF922"=>"\u6FEB",
    "\uF923"=>"\u85CD",
    "\uF924"=>"\u8964",
    "\uF925"=>"\u62C9",
    "\uF926"=>"\u81D8",
    "\uF927"=>"\u881F",
    "\uF928"=>"\u5ECA",
    "\uF929"=>"\u6717",
    "\uF92A"=>"\u6D6A",
    "\uF92B"=>"\u72FC",
    "\uF92C"=>"\u90CE",
    "\uF92D"=>"\u4F86",
    "\uF92E"=>"\u51B7",
    "\uF92F"=>"\u52DE",
    "\uF930"=>"\u64C4",
    "\uF931"=>"\u6AD3",
    "\uF932"=>"\u7210",
    "\uF933"=>"\u76E7",
    "\uF934"=>"\u8001",
    "\uF935"=>"\u8606",
    "\uF936"=>"\u865C",
    "\uF937"=>"\u8DEF",
    "\uF938"=>"\u9732",
    "\uF939"=>"\u9B6F",
    "\uF93A"=>"\u9DFA",
    "\uF93B"=>"\u788C",
    "\uF93C"=>"\u797F",
    "\uF93D"=>"\u7DA0",
    "\uF93E"=>"\u83C9",
    "\uF93F"=>"\u9304",
    "\uF940"=>"\u9E7F",
    "\uF941"=>"\u8AD6",
    "\uF942"=>"\u58DF",
    "\uF943"=>"\u5F04",
    "\uF944"=>"\u7C60",
    "\uF945"=>"\u807E",
    "\uF946"=>"\u7262",
    "\uF947"=>"\u78CA",
    "\uF948"=>"\u8CC2",
    "\uF949"=>"\u96F7",
    "\uF94A"=>"\u58D8",
    "\uF94B"=>"\u5C62",
    "\uF94C"=>"\u6A13",
    "\uF94D"=>"\u6DDA",
    "\uF94E"=>"\u6F0F",
    "\uF94F"=>"\u7D2F",
    "\uF950"=>"\u7E37",
    "\uF951"=>"\u964B",
    "\uF952"=>"\u52D2",
    "\uF953"=>"\u808B",
    "\uF954"=>"\u51DC",
    "\uF955"=>"\u51CC",
    "\uF956"=>"\u7A1C",
    "\uF957"=>"\u7DBE",
    "\uF958"=>"\u83F1",
    "\uF959"=>"\u9675",
    "\uF95A"=>"\u8B80",
    "\uF95B"=>"\u62CF",
    "\uF95C"=>"\u6A02",
    "\uF95D"=>"\u8AFE",
    "\uF95E"=>"\u4E39",
    "\uF95F"=>"\u5BE7",
    "\uF960"=>"\u6012",
    "\uF961"=>"\u7387",
    "\uF962"=>"\u7570",
    "\uF963"=>"\u5317",
    "\uF964"=>"\u78FB",
    "\uF965"=>"\u4FBF",
    "\uF966"=>"\u5FA9",
    "\uF967"=>"\u4E0D",
    "\uF968"=>"\u6CCC",
    "\uF969"=>"\u6578",
    "\uF96A"=>"\u7D22",
    "\uF96B"=>"\u53C3",
    "\uF96C"=>"\u585E",
    "\uF96D"=>"\u7701",
    "\uF96E"=>"\u8449",
    "\uF96F"=>"\u8AAA",
    "\uF970"=>"\u6BBA",
    "\uF971"=>"\u8FB0",
    "\uF972"=>"\u6C88",
    "\uF973"=>"\u62FE",
    "\uF974"=>"\u82E5",
    "\uF975"=>"\u63A0",
    "\uF976"=>"\u7565",
    "\uF977"=>"\u4EAE",
    "\uF978"=>"\u5169",
    "\uF979"=>"\u51C9",
    "\uF97A"=>"\u6881",
    "\uF97B"=>"\u7CE7",
    "\uF97C"=>"\u826F",
    "\uF97D"=>"\u8AD2",
    "\uF97E"=>"\u91CF",
    "\uF97F"=>"\u52F5",
    "\uF980"=>"\u5442",
    "\uF981"=>"\u5973",
    "\uF982"=>"\u5EEC",
    "\uF983"=>"\u65C5",
    "\uF984"=>"\u6FFE",
    "\uF985"=>"\u792A",
    "\uF986"=>"\u95AD",
    "\uF987"=>"\u9A6A",
    "\uF988"=>"\u9E97",
    "\uF989"=>"\u9ECE",
    "\uF98A"=>"\u529B",
    "\uF98B"=>"\u66C6",
    "\uF98C"=>"\u6B77",
    "\uF98D"=>"\u8F62",
    "\uF98E"=>"\u5E74",
    "\uF98F"=>"\u6190",
    "\uF990"=>"\u6200",
    "\uF991"=>"\u649A",
    "\uF992"=>"\u6F23",
    "\uF993"=>"\u7149",
    "\uF994"=>"\u7489",
    "\uF995"=>"\u79CA",
    "\uF996"=>"\u7DF4",
    "\uF997"=>"\u806F",
    "\uF998"=>"\u8F26",
    "\uF999"=>"\u84EE",
    "\uF99A"=>"\u9023",
    "\uF99B"=>"\u934A",
    "\uF99C"=>"\u5217",
    "\uF99D"=>"\u52A3",
    "\uF99E"=>"\u54BD",
    "\uF99F"=>"\u70C8",
    "\uF9A0"=>"\u88C2",
    "\uF9A1"=>"\u8AAA",
    "\uF9A2"=>"\u5EC9",
    "\uF9A3"=>"\u5FF5",
    "\uF9A4"=>"\u637B",
    "\uF9A5"=>"\u6BAE",
    "\uF9A6"=>"\u7C3E",
    "\uF9A7"=>"\u7375",
    "\uF9A8"=>"\u4EE4",
    "\uF9A9"=>"\u56F9",
    "\uF9AA"=>"\u5BE7",
    "\uF9AB"=>"\u5DBA",
    "\uF9AC"=>"\u601C",
    "\uF9AD"=>"\u73B2",
    "\uF9AE"=>"\u7469",
    "\uF9AF"=>"\u7F9A",
    "\uF9B0"=>"\u8046",
    "\uF9B1"=>"\u9234",
    "\uF9B2"=>"\u96F6",
    "\uF9B3"=>"\u9748",
    "\uF9B4"=>"\u9818",
    "\uF9B5"=>"\u4F8B",
    "\uF9B6"=>"\u79AE",
    "\uF9B7"=>"\u91B4",
    "\uF9B8"=>"\u96B8",
    "\uF9B9"=>"\u60E1",
    "\uF9BA"=>"\u4E86",
    "\uF9BB"=>"\u50DA",
    "\uF9BC"=>"\u5BEE",
    "\uF9BD"=>"\u5C3F",
    "\uF9BE"=>"\u6599",
    "\uF9BF"=>"\u6A02",
    "\uF9C0"=>"\u71CE",
    "\uF9C1"=>"\u7642",
    "\uF9C2"=>"\u84FC",
    "\uF9C3"=>"\u907C",
    "\uF9C4"=>"\u9F8D",
    "\uF9C5"=>"\u6688",
    "\uF9C6"=>"\u962E",
    "\uF9C7"=>"\u5289",
    "\uF9C8"=>"\u677B",
    "\uF9C9"=>"\u67F3",
    "\uF9CA"=>"\u6D41",
    "\uF9CB"=>"\u6E9C",
    "\uF9CC"=>"\u7409",
    "\uF9CD"=>"\u7559",
    "\uF9CE"=>"\u786B",
    "\uF9CF"=>"\u7D10",
    "\uF9D0"=>"\u985E",
    "\uF9D1"=>"\u516D",
    "\uF9D2"=>"\u622E",
    "\uF9D3"=>"\u9678",
    "\uF9D4"=>"\u502B",
    "\uF9D5"=>"\u5D19",
    "\uF9D6"=>"\u6DEA",
    "\uF9D7"=>"\u8F2A",
    "\uF9D8"=>"\u5F8B",
    "\uF9D9"=>"\u6144",
    "\uF9DA"=>"\u6817",
    "\uF9DB"=>"\u7387",
    "\uF9DC"=>"\u9686",
    "\uF9DD"=>"\u5229",
    "\uF9DE"=>"\u540F",
    "\uF9DF"=>"\u5C65",
    "\uF9E0"=>"\u6613",
    "\uF9E1"=>"\u674E",
    "\uF9E2"=>"\u68A8",
    "\uF9E3"=>"\u6CE5",
    "\uF9E4"=>"\u7406",
    "\uF9E5"=>"\u75E2",
    "\uF9E6"=>"\u7F79",
    "\uF9E7"=>"\u88CF",
    "\uF9E8"=>"\u88E1",
    "\uF9E9"=>"\u91CC",
    "\uF9EA"=>"\u96E2",
    "\uF9EB"=>"\u533F",
    "\uF9EC"=>"\u6EBA",
    "\uF9ED"=>"\u541D",
    "\uF9EE"=>"\u71D0",
    "\uF9EF"=>"\u7498",
    "\uF9F0"=>"\u85FA",
    "\uF9F1"=>"\u96A3",
    "\uF9F2"=>"\u9C57",
    "\uF9F3"=>"\u9E9F",
    "\uF9F4"=>"\u6797",
    "\uF9F5"=>"\u6DCB",
    "\uF9F6"=>"\u81E8",
    "\uF9F7"=>"\u7ACB",
    "\uF9F8"=>"\u7B20",
    "\uF9F9"=>"\u7C92",
    "\uF9FA"=>"\u72C0",
    "\uF9FB"=>"\u7099",
    "\uF9FC"=>"\u8B58",
    "\uF9FD"=>"\u4EC0",
    "\uF9FE"=>"\u8336",
    "\uF9FF"=>"\u523A",
    "\uFA00"=>"\u5207",
    "\uFA01"=>"\u5EA6",
    "\uFA02"=>"\u62D3",
    "\uFA03"=>"\u7CD6",
    "\uFA04"=>"\u5B85",
    "\uFA05"=>"\u6D1E",
    "\uFA06"=>"\u66B4",
    "\uFA07"=>"\u8F3B",
    "\uFA08"=>"\u884C",
    "\uFA09"=>"\u964D",
    "\uFA0A"=>"\u898B",
    "\uFA0B"=>"\u5ED3",
    "\uFA0C"=>"\u5140",
    "\uFA0D"=>"\u55C0",
    "\uFA10"=>"\u585A",
    "\uFA12"=>"\u6674",
    "\uFA15"=>"\u51DE",
    "\uFA16"=>"\u732A",
    "\uFA17"=>"\u76CA",
    "\uFA18"=>"\u793C",
    "\uFA19"=>"\u795E",
    "\uFA1A"=>"\u7965",
    "\uFA1B"=>"\u798F",
    "\uFA1C"=>"\u9756",
    "\uFA1D"=>"\u7CBE",
    "\uFA1E"=>"\u7FBD",
    "\uFA20"=>"\u8612",
    "\uFA22"=>"\u8AF8",
    "\uFA25"=>"\u9038",
    "\uFA26"=>"\u90FD",
    "\uFA2A"=>"\u98EF",
    "\uFA2B"=>"\u98FC",
    "\uFA2C"=>"\u9928",
    "\uFA2D"=>"\u9DB4",
    "\uFA2E"=>"\u90DE",
    "\uFA2F"=>"\u96B7",
    "\uFA30"=>"\u4FAE",
    "\uFA31"=>"\u50E7",
    "\uFA32"=>"\u514D",
    "\uFA33"=>"\u52C9",
    "\uFA34"=>"\u52E4",
    "\uFA35"=>"\u5351",
    "\uFA36"=>"\u559D",
    "\uFA37"=>"\u5606",
    "\uFA38"=>"\u5668",
    "\uFA39"=>"\u5840",
    "\uFA3A"=>"\u58A8",
    "\uFA3B"=>"\u5C64",
    "\uFA3C"=>"\u5C6E",
    "\uFA3D"=>"\u6094",
    "\uFA3E"=>"\u6168",
    "\uFA3F"=>"\u618E",
    "\uFA40"=>"\u61F2",
    "\uFA41"=>"\u654F",
    "\uFA42"=>"\u65E2",
    "\uFA43"=>"\u6691",
    "\uFA44"=>"\u6885",
    "\uFA45"=>"\u6D77",
    "\uFA46"=>"\u6E1A",
    "\uFA47"=>"\u6F22",
    "\uFA48"=>"\u716E",
    "\uFA49"=>"\u722B",
    "\uFA4A"=>"\u7422",
    "\uFA4B"=>"\u7891",
    "\uFA4C"=>"\u793E",
    "\uFA4D"=>"\u7949",
    "\uFA4E"=>"\u7948",
    "\uFA4F"=>"\u7950",
    "\uFA50"=>"\u7956",
    "\uFA51"=>"\u795D",
    "\uFA52"=>"\u798D",
    "\uFA53"=>"\u798E",
    "\uFA54"=>"\u7A40",
    "\uFA55"=>"\u7A81",
    "\uFA56"=>"\u7BC0",
    "\uFA57"=>"\u7DF4",
    "\uFA58"=>"\u7E09",
    "\uFA59"=>"\u7E41",
    "\uFA5A"=>"\u7F72",
    "\uFA5B"=>"\u8005",
    "\uFA5C"=>"\u81ED",
    "\uFA5D"=>"\u8279",
    "\uFA5E"=>"\u8279",
    "\uFA5F"=>"\u8457",
    "\uFA60"=>"\u8910",
    "\uFA61"=>"\u8996",
    "\uFA62"=>"\u8B01",
    "\uFA63"=>"\u8B39",
    "\uFA64"=>"\u8CD3",
    "\uFA65"=>"\u8D08",
    "\uFA66"=>"\u8FB6",
    "\uFA67"=>"\u9038",
    "\uFA68"=>"\u96E3",
    "\uFA69"=>"\u97FF",
    "\uFA6A"=>"\u983B",
    "\uFA6B"=>"\u6075",
    "\uFA6C"=>"\u{242EE}",
    "\uFA6D"=>"\u8218",
    "\uFA70"=>"\u4E26",
    "\uFA71"=>"\u51B5",
    "\uFA72"=>"\u5168",
    "\uFA73"=>"\u4F80",
    "\uFA74"=>"\u5145",
    "\uFA75"=>"\u5180",
    "\uFA76"=>"\u52C7",
    "\uFA77"=>"\u52FA",
    "\uFA78"=>"\u559D",
    "\uFA79"=>"\u5555",
    "\uFA7A"=>"\u5599",
    "\uFA7B"=>"\u55E2",
    "\uFA7C"=>"\u585A",
    "\uFA7D"=>"\u58B3",
    "\uFA7E"=>"\u5944",
    "\uFA7F"=>"\u5954",
    "\uFA80"=>"\u5A62",
    "\uFA81"=>"\u5B28",
    "\uFA82"=>"\u5ED2",
    "\uFA83"=>"\u5ED9",
    "\uFA84"=>"\u5F69",
    "\uFA85"=>"\u5FAD",
    "\uFA86"=>"\u60D8",
    "\uFA87"=>"\u614E",
    "\uFA88"=>"\u6108",
    "\uFA89"=>"\u618E",
    "\uFA8A"=>"\u6160",
    "\uFA8B"=>"\u61F2",
    "\uFA8C"=>"\u6234",
    "\uFA8D"=>"\u63C4",
    "\uFA8E"=>"\u641C",
    "\uFA8F"=>"\u6452",
    "\uFA90"=>"\u6556",
    "\uFA91"=>"\u6674",
    "\uFA92"=>"\u6717",
    "\uFA93"=>"\u671B",
    "\uFA94"=>"\u6756",
    "\uFA95"=>"\u6B79",
    "\uFA96"=>"\u6BBA",
    "\uFA97"=>"\u6D41",
    "\uFA98"=>"\u6EDB",
    "\uFA99"=>"\u6ECB",
    "\uFA9A"=>"\u6F22",
    "\uFA9B"=>"\u701E",
    "\uFA9C"=>"\u716E",
    "\uFA9D"=>"\u77A7",
    "\uFA9E"=>"\u7235",
    "\uFA9F"=>"\u72AF",
    "\uFAA0"=>"\u732A",
    "\uFAA1"=>"\u7471",
    "\uFAA2"=>"\u7506",
    "\uFAA3"=>"\u753B",
    "\uFAA4"=>"\u761D",
    "\uFAA5"=>"\u761F",
    "\uFAA6"=>"\u76CA",
    "\uFAA7"=>"\u76DB",
    "\uFAA8"=>"\u76F4",
    "\uFAA9"=>"\u774A",
    "\uFAAA"=>"\u7740",
    "\uFAAB"=>"\u78CC",
    "\uFAAC"=>"\u7AB1",
    "\uFAAD"=>"\u7BC0",
    "\uFAAE"=>"\u7C7B",
    "\uFAAF"=>"\u7D5B",
    "\uFAB0"=>"\u7DF4",
    "\uFAB1"=>"\u7F3E",
    "\uFAB2"=>"\u8005",
    "\uFAB3"=>"\u8352",
    "\uFAB4"=>"\u83EF",
    "\uFAB5"=>"\u8779",
    "\uFAB6"=>"\u8941",
    "\uFAB7"=>"\u8986",
    "\uFAB8"=>"\u8996",
    "\uFAB9"=>"\u8ABF",
    "\uFABA"=>"\u8AF8",
    "\uFABB"=>"\u8ACB",
    "\uFABC"=>"\u8B01",
    "\uFABD"=>"\u8AFE",
    "\uFABE"=>"\u8AED",
    "\uFABF"=>"\u8B39",
    "\uFAC0"=>"\u8B8A",
    "\uFAC1"=>"\u8D08",
    "\uFAC2"=>"\u8F38",
    "\uFAC3"=>"\u9072",
    "\uFAC4"=>"\u9199",
    "\uFAC5"=>"\u9276",
    "\uFAC6"=>"\u967C",
    "\uFAC7"=>"\u96E3",
    "\uFAC8"=>"\u9756",
    "\uFAC9"=>"\u97DB",
    "\uFACA"=>"\u97FF",
    "\uFACB"=>"\u980B",
    "\uFACC"=>"\u983B",
    "\uFACD"=>"\u9B12",
    "\uFACE"=>"\u9F9C",
    "\uFACF"=>"\u{2284A}",
    "\uFAD0"=>"\u{22844}",
    "\uFAD1"=>"\u{233D5}",
    "\uFAD2"=>"\u3B9D",
    "\uFAD3"=>"\u4018",
    "\uFAD4"=>"\u4039",
    "\uFAD5"=>"\u{25249}",
    "\uFAD6"=>"\u{25CD0}",
    "\uFAD7"=>"\u{27ED3}",
    "\uFAD8"=>"\u9F43",
    "\uFAD9"=>"\u9F8E",
    "\uFB1D"=>"\u05D9\u05B4",
    "\uFB1F"=>"\u05F2\u05B7",
    "\uFB2A"=>"\u05E9\u05C1",
    "\uFB2B"=>"\u05E9\u05C2",
    "\uFB2C"=>"\u05E9\u05BC\u05C1",
    "\uFB2D"=>"\u05E9\u05BC\u05C2",
    "\uFB2E"=>"\u05D0\u05B7",
    "\uFB2F"=>"\u05D0\u05B8",
    "\uFB30"=>"\u05D0\u05BC",
    "\uFB31"=>"\u05D1\u05BC",
    "\uFB32"=>"\u05D2\u05BC",
    "\uFB33"=>"\u05D3\u05BC",
    "\uFB34"=>"\u05D4\u05BC",
    "\uFB35"=>"\u05D5\u05BC",
    "\uFB36"=>"\u05D6\u05BC",
    "\uFB38"=>"\u05D8\u05BC",
    "\uFB39"=>"\u05D9\u05BC",
    "\uFB3A"=>"\u05DA\u05BC",
    "\uFB3B"=>"\u05DB\u05BC",
    "\uFB3C"=>"\u05DC\u05BC",
    "\uFB3E"=>"\u05DE\u05BC",
    "\uFB40"=>"\u05E0\u05BC",
    "\uFB41"=>"\u05E1\u05BC",
    "\uFB43"=>"\u05E3\u05BC",
    "\uFB44"=>"\u05E4\u05BC",
    "\uFB46"=>"\u05E6\u05BC",
    "\uFB47"=>"\u05E7\u05BC",
    "\uFB48"=>"\u05E8\u05BC",
    "\uFB49"=>"\u05E9\u05BC",
    "\uFB4A"=>"\u05EA\u05BC",
    "\uFB4B"=>"\u05D5\u05B9",
    "\uFB4C"=>"\u05D1\u05BF",
    "\uFB4D"=>"\u05DB\u05BF",
    "\uFB4E"=>"\u05E4\u05BF",
    "\u{1109A}"=>"\u{11099}\u{110BA}",
    "\u{1109C}"=>"\u{1109B}\u{110BA}",
    "\u{110AB}"=>"\u{110A5}\u{110BA}",
    "\u{1112E}"=>"\u{11131}\u{11127}",
    "\u{1112F}"=>"\u{11132}\u{11127}",
    "\u{1134B}"=>"\u{11347}\u{1133E}",
    "\u{1134C}"=>"\u{11347}\u{11357}",
    "\u{114BB}"=>"\u{114B9}\u{114BA}",
    "\u{114BC}"=>"\u{114B9}\u{114B0}",
    "\u{114BE}"=>"\u{114B9}\u{114BD}",
    "\u{115BA}"=>"\u{115B8}\u{115AF}",
    "\u{115BB}"=>"\u{115B9}\u{115AF}",
    "\u{1D15E}"=>"\u{1D157}\u{1D165}",
    "\u{1D15F}"=>"\u{1D158}\u{1D165}",
    "\u{1D160}"=>"\u{1D158}\u{1D165}\u{1D16E}",
    "\u{1D161}"=>"\u{1D158}\u{1D165}\u{1D16F}",
    "\u{1D162}"=>"\u{1D158}\u{1D165}\u{1D170}",
    "\u{1D163}"=>"\u{1D158}\u{1D165}\u{1D171}",
    "\u{1D164}"=>"\u{1D158}\u{1D165}\u{1D172}",
    "\u{1D1BB}"=>"\u{1D1B9}\u{1D165}",
    "\u{1D1BC}"=>"\u{1D1BA}\u{1D165}",
    "\u{1D1BD}"=>"\u{1D1B9}\u{1D165}\u{1D16E}",
    "\u{1D1BE}"=>"\u{1D1BA}\u{1D165}\u{1D16E}",
    "\u{1D1BF}"=>"\u{1D1B9}\u{1D165}\u{1D16F}",
    "\u{1D1C0}"=>"\u{1D1BA}\u{1D165}\u{1D16F}",
    "\u{2F800}"=>"\u4E3D",
    "\u{2F801}"=>"\u4E38",
    "\u{2F802}"=>"\u4E41",
    "\u{2F803}"=>"\u{20122}",
    "\u{2F804}"=>"\u4F60",
    "\u{2F805}"=>"\u4FAE",
    "\u{2F806}"=>"\u4FBB",
    "\u{2F807}"=>"\u5002",
    "\u{2F808}"=>"\u507A",
    "\u{2F809}"=>"\u5099",
    "\u{2F80A}"=>"\u50E7",
    "\u{2F80B}"=>"\u50CF",
    "\u{2F80C}"=>"\u349E",
    "\u{2F80D}"=>"\u{2063A}",
    "\u{2F80E}"=>"\u514D",
    "\u{2F80F}"=>"\u5154",
    "\u{2F810}"=>"\u5164",
    "\u{2F811}"=>"\u5177",
    "\u{2F812}"=>"\u{2051C}",
    "\u{2F813}"=>"\u34B9",
    "\u{2F814}"=>"\u5167",
    "\u{2F815}"=>"\u518D",
    "\u{2F816}"=>"\u{2054B}",
    "\u{2F817}"=>"\u5197",
    "\u{2F818}"=>"\u51A4",
    "\u{2F819}"=>"\u4ECC",
    "\u{2F81A}"=>"\u51AC",
    "\u{2F81B}"=>"\u51B5",
    "\u{2F81C}"=>"\u{291DF}",
    "\u{2F81D}"=>"\u51F5",
    "\u{2F81E}"=>"\u5203",
    "\u{2F81F}"=>"\u34DF",
    "\u{2F820}"=>"\u523B",
    "\u{2F821}"=>"\u5246",
    "\u{2F822}"=>"\u5272",
    "\u{2F823}"=>"\u5277",
    "\u{2F824}"=>"\u3515",
    "\u{2F825}"=>"\u52C7",
    "\u{2F826}"=>"\u52C9",
    "\u{2F827}"=>"\u52E4",
    "\u{2F828}"=>"\u52FA",
    "\u{2F829}"=>"\u5305",
    "\u{2F82A}"=>"\u5306",
    "\u{2F82B}"=>"\u5317",
    "\u{2F82C}"=>"\u5349",
    "\u{2F82D}"=>"\u5351",
    "\u{2F82E}"=>"\u535A",
    "\u{2F82F}"=>"\u5373",
    "\u{2F830}"=>"\u537D",
    "\u{2F831}"=>"\u537F",
    "\u{2F832}"=>"\u537F",
    "\u{2F833}"=>"\u537F",
    "\u{2F834}"=>"\u{20A2C}",
    "\u{2F835}"=>"\u7070",
    "\u{2F836}"=>"\u53CA",
    "\u{2F837}"=>"\u53DF",
    "\u{2F838}"=>"\u{20B63}",
    "\u{2F839}"=>"\u53EB",
    "\u{2F83A}"=>"\u53F1",
    "\u{2F83B}"=>"\u5406",
    "\u{2F83C}"=>"\u549E",
    "\u{2F83D}"=>"\u5438",
    "\u{2F83E}"=>"\u5448",
    "\u{2F83F}"=>"\u5468",
    "\u{2F840}"=>"\u54A2",
    "\u{2F841}"=>"\u54F6",
    "\u{2F842}"=>"\u5510",
    "\u{2F843}"=>"\u5553",
    "\u{2F844}"=>"\u5563",
    "\u{2F845}"=>"\u5584",
    "\u{2F846}"=>"\u5584",
    "\u{2F847}"=>"\u5599",
    "\u{2F848}"=>"\u55AB",
    "\u{2F849}"=>"\u55B3",
    "\u{2F84A}"=>"\u55C2",
    "\u{2F84B}"=>"\u5716",
    "\u{2F84C}"=>"\u5606",
    "\u{2F84D}"=>"\u5717",
    "\u{2F84E}"=>"\u5651",
    "\u{2F84F}"=>"\u5674",
    "\u{2F850}"=>"\u5207",
    "\u{2F851}"=>"\u58EE",
    "\u{2F852}"=>"\u57CE",
    "\u{2F853}"=>"\u57F4",
    "\u{2F854}"=>"\u580D",
    "\u{2F855}"=>"\u578B",
    "\u{2F856}"=>"\u5832",
    "\u{2F857}"=>"\u5831",
    "\u{2F858}"=>"\u58AC",
    "\u{2F859}"=>"\u{214E4}",
    "\u{2F85A}"=>"\u58F2",
    "\u{2F85B}"=>"\u58F7",
    "\u{2F85C}"=>"\u5906",
    "\u{2F85D}"=>"\u591A",
    "\u{2F85E}"=>"\u5922",
    "\u{2F85F}"=>"\u5962",
    "\u{2F860}"=>"\u{216A8}",
    "\u{2F861}"=>"\u{216EA}",
    "\u{2F862}"=>"\u59EC",
    "\u{2F863}"=>"\u5A1B",
    "\u{2F864}"=>"\u5A27",
    "\u{2F865}"=>"\u59D8",
    "\u{2F866}"=>"\u5A66",
    "\u{2F867}"=>"\u36EE",
    "\u{2F868}"=>"\u36FC",
    "\u{2F869}"=>"\u5B08",
    "\u{2F86A}"=>"\u5B3E",
    "\u{2F86B}"=>"\u5B3E",
    "\u{2F86C}"=>"\u{219C8}",
    "\u{2F86D}"=>"\u5BC3",
    "\u{2F86E}"=>"\u5BD8",
    "\u{2F86F}"=>"\u5BE7",
    "\u{2F870}"=>"\u5BF3",
    "\u{2F871}"=>"\u{21B18}",
    "\u{2F872}"=>"\u5BFF",
    "\u{2F873}"=>"\u5C06",
    "\u{2F874}"=>"\u5F53",
    "\u{2F875}"=>"\u5C22",
    "\u{2F876}"=>"\u3781",
    "\u{2F877}"=>"\u5C60",
    "\u{2F878}"=>"\u5C6E",
    "\u{2F879}"=>"\u5CC0",
    "\u{2F87A}"=>"\u5C8D",
    "\u{2F87B}"=>"\u{21DE4}",
    "\u{2F87C}"=>"\u5D43",
    "\u{2F87D}"=>"\u{21DE6}",
    "\u{2F87E}"=>"\u5D6E",
    "\u{2F87F}"=>"\u5D6B",
    "\u{2F880}"=>"\u5D7C",
    "\u{2F881}"=>"\u5DE1",
    "\u{2F882}"=>"\u5DE2",
    "\u{2F883}"=>"\u382F",
    "\u{2F884}"=>"\u5DFD",
    "\u{2F885}"=>"\u5E28",
    "\u{2F886}"=>"\u5E3D",
    "\u{2F887}"=>"\u5E69",
    "\u{2F888}"=>"\u3862",
    "\u{2F889}"=>"\u{22183}",
    "\u{2F88A}"=>"\u387C",
    "\u{2F88B}"=>"\u5EB0",
    "\u{2F88C}"=>"\u5EB3",
    "\u{2F88D}"=>"\u5EB6",
    "\u{2F88E}"=>"\u5ECA",
    "\u{2F88F}"=>"\u{2A392}",
    "\u{2F890}"=>"\u5EFE",
    "\u{2F891}"=>"\u{22331}",
    "\u{2F892}"=>"\u{22331}",
    "\u{2F893}"=>"\u8201",
    "\u{2F894}"=>"\u5F22",
    "\u{2F895}"=>"\u5F22",
    "\u{2F896}"=>"\u38C7",
    "\u{2F897}"=>"\u{232B8}",
    "\u{2F898}"=>"\u{261DA}",
    "\u{2F899}"=>"\u5F62",
    "\u{2F89A}"=>"\u5F6B",
    "\u{2F89B}"=>"\u38E3",
    "\u{2F89C}"=>"\u5F9A",
    "\u{2F89D}"=>"\u5FCD",
    "\u{2F89E}"=>"\u5FD7",
    "\u{2F89F}"=>"\u5FF9",
    "\u{2F8A0}"=>"\u6081",
    "\u{2F8A1}"=>"\u393A",
    "\u{2F8A2}"=>"\u391C",
    "\u{2F8A3}"=>"\u6094",
    "\u{2F8A4}"=>"\u{226D4}",
    "\u{2F8A5}"=>"\u60C7",
    "\u{2F8A6}"=>"\u6148",
    "\u{2F8A7}"=>"\u614C",
    "\u{2F8A8}"=>"\u614E",
    "\u{2F8A9}"=>"\u614C",
    "\u{2F8AA}"=>"\u617A",
    "\u{2F8AB}"=>"\u618E",
    "\u{2F8AC}"=>"\u61B2",
    "\u{2F8AD}"=>"\u61A4",
    "\u{2F8AE}"=>"\u61AF",
    "\u{2F8AF}"=>"\u61DE",
    "\u{2F8B0}"=>"\u61F2",
    "\u{2F8B1}"=>"\u61F6",
    "\u{2F8B2}"=>"\u6210",
    "\u{2F8B3}"=>"\u621B",
    "\u{2F8B4}"=>"\u625D",
    "\u{2F8B5}"=>"\u62B1",
    "\u{2F8B6}"=>"\u62D4",
    "\u{2F8B7}"=>"\u6350",
    "\u{2F8B8}"=>"\u{22B0C}",
    "\u{2F8B9}"=>"\u633D",
    "\u{2F8BA}"=>"\u62FC",
    "\u{2F8BB}"=>"\u6368",
    "\u{2F8BC}"=>"\u6383",
    "\u{2F8BD}"=>"\u63E4",
    "\u{2F8BE}"=>"\u{22BF1}",
    "\u{2F8BF}"=>"\u6422",
    "\u{2F8C0}"=>"\u63C5",
    "\u{2F8C1}"=>"\u63A9",
    "\u{2F8C2}"=>"\u3A2E",
    "\u{2F8C3}"=>"\u6469",
    "\u{2F8C4}"=>"\u647E",
    "\u{2F8C5}"=>"\u649D",
    "\u{2F8C6}"=>"\u6477",
    "\u{2F8C7}"=>"\u3A6C",
    "\u{2F8C8}"=>"\u654F",
    "\u{2F8C9}"=>"\u656C",
    "\u{2F8CA}"=>"\u{2300A}",
    "\u{2F8CB}"=>"\u65E3",
    "\u{2F8CC}"=>"\u66F8",
    "\u{2F8CD}"=>"\u6649",
    "\u{2F8CE}"=>"\u3B19",
    "\u{2F8CF}"=>"\u6691",
    "\u{2F8D0}"=>"\u3B08",
    "\u{2F8D1}"=>"\u3AE4",
    "\u{2F8D2}"=>"\u5192",
    "\u{2F8D3}"=>"\u5195",
    "\u{2F8D4}"=>"\u6700",
    "\u{2F8D5}"=>"\u669C",
    "\u{2F8D6}"=>"\u80AD",
    "\u{2F8D7}"=>"\u43D9",
    "\u{2F8D8}"=>"\u6717",
    "\u{2F8D9}"=>"\u671B",
    "\u{2F8DA}"=>"\u6721",
    "\u{2F8DB}"=>"\u675E",
    "\u{2F8DC}"=>"\u6753",
    "\u{2F8DD}"=>"\u{233C3}",
    "\u{2F8DE}"=>"\u3B49",
    "\u{2F8DF}"=>"\u67FA",
    "\u{2F8E0}"=>"\u6785",
    "\u{2F8E1}"=>"\u6852",
    "\u{2F8E2}"=>"\u6885",
    "\u{2F8E3}"=>"\u{2346D}",
    "\u{2F8E4}"=>"\u688E",
    "\u{2F8E5}"=>"\u681F",
    "\u{2F8E6}"=>"\u6914",
    "\u{2F8E7}"=>"\u3B9D",
    "\u{2F8E8}"=>"\u6942",
    "\u{2F8E9}"=>"\u69A3",
    "\u{2F8EA}"=>"\u69EA",
    "\u{2F8EB}"=>"\u6AA8",
    "\u{2F8EC}"=>"\u{236A3}",
    "\u{2F8ED}"=>"\u6ADB",
    "\u{2F8EE}"=>"\u3C18",
    "\u{2F8EF}"=>"\u6B21",
    "\u{2F8F0}"=>"\u{238A7}",
    "\u{2F8F1}"=>"\u6B54",
    "\u{2F8F2}"=>"\u3C4E",
    "\u{2F8F3}"=>"\u6B72",
    "\u{2F8F4}"=>"\u6B9F",
    "\u{2F8F5}"=>"\u6BBA",
    "\u{2F8F6}"=>"\u6BBB",
    "\u{2F8F7}"=>"\u{23A8D}",
    "\u{2F8F8}"=>"\u{21D0B}",
    "\u{2F8F9}"=>"\u{23AFA}",
    "\u{2F8FA}"=>"\u6C4E",
    "\u{2F8FB}"=>"\u{23CBC}",
    "\u{2F8FC}"=>"\u6CBF",
    "\u{2F8FD}"=>"\u6CCD",
    "\u{2F8FE}"=>"\u6C67",
    "\u{2F8FF}"=>"\u6D16",
    "\u{2F900}"=>"\u6D3E",
    "\u{2F901}"=>"\u6D77",
    "\u{2F902}"=>"\u6D41",
    "\u{2F903}"=>"\u6D69",
    "\u{2F904}"=>"\u6D78",
    "\u{2F905}"=>"\u6D85",
    "\u{2F906}"=>"\u{23D1E}",
    "\u{2F907}"=>"\u6D34",
    "\u{2F908}"=>"\u6E2F",
    "\u{2F909}"=>"\u6E6E",
    "\u{2F90A}"=>"\u3D33",
    "\u{2F90B}"=>"\u6ECB",
    "\u{2F90C}"=>"\u6EC7",
    "\u{2F90D}"=>"\u{23ED1}",
    "\u{2F90E}"=>"\u6DF9",
    "\u{2F90F}"=>"\u6F6E",
    "\u{2F910}"=>"\u{23F5E}",
    "\u{2F911}"=>"\u{23F8E}",
    "\u{2F912}"=>"\u6FC6",
    "\u{2F913}"=>"\u7039",
    "\u{2F914}"=>"\u701E",
    "\u{2F915}"=>"\u701B",
    "\u{2F916}"=>"\u3D96",
    "\u{2F917}"=>"\u704A",
    "\u{2F918}"=>"\u707D",
    "\u{2F919}"=>"\u7077",
    "\u{2F91A}"=>"\u70AD",
    "\u{2F91B}"=>"\u{20525}",
    "\u{2F91C}"=>"\u7145",
    "\u{2F91D}"=>"\u{24263}",
    "\u{2F91E}"=>"\u719C",
    "\u{2F91F}"=>"\u{243AB}",
    "\u{2F920}"=>"\u7228",
    "\u{2F921}"=>"\u7235",
    "\u{2F922}"=>"\u7250",
    "\u{2F923}"=>"\u{24608}",
    "\u{2F924}"=>"\u7280",
    "\u{2F925}"=>"\u7295",
    "\u{2F926}"=>"\u{24735}",
    "\u{2F927}"=>"\u{24814}",
    "\u{2F928}"=>"\u737A",
    "\u{2F929}"=>"\u738B",
    "\u{2F92A}"=>"\u3EAC",
    "\u{2F92B}"=>"\u73A5",
    "\u{2F92C}"=>"\u3EB8",
    "\u{2F92D}"=>"\u3EB8",
    "\u{2F92E}"=>"\u7447",
    "\u{2F92F}"=>"\u745C",
    "\u{2F930}"=>"\u7471",
    "\u{2F931}"=>"\u7485",
    "\u{2F932}"=>"\u74CA",
    "\u{2F933}"=>"\u3F1B",
    "\u{2F934}"=>"\u7524",
    "\u{2F935}"=>"\u{24C36}",
    "\u{2F936}"=>"\u753E",
    "\u{2F937}"=>"\u{24C92}",
    "\u{2F938}"=>"\u7570",
    "\u{2F939}"=>"\u{2219F}",
    "\u{2F93A}"=>"\u7610",
    "\u{2F93B}"=>"\u{24FA1}",
    "\u{2F93C}"=>"\u{24FB8}",
    "\u{2F93D}"=>"\u{25044}",
    "\u{2F93E}"=>"\u3FFC",
    "\u{2F93F}"=>"\u4008",
    "\u{2F940}"=>"\u76F4",
    "\u{2F941}"=>"\u{250F3}",
    "\u{2F942}"=>"\u{250F2}",
    "\u{2F943}"=>"\u{25119}",
    "\u{2F944}"=>"\u{25133}",
    "\u{2F945}"=>"\u771E",
    "\u{2F946}"=>"\u771F",
    "\u{2F947}"=>"\u771F",
    "\u{2F948}"=>"\u774A",
    "\u{2F949}"=>"\u4039",
    "\u{2F94A}"=>"\u778B",
    "\u{2F94B}"=>"\u4046",
    "\u{2F94C}"=>"\u4096",
    "\u{2F94D}"=>"\u{2541D}",
    "\u{2F94E}"=>"\u784E",
    "\u{2F94F}"=>"\u788C",
    "\u{2F950}"=>"\u78CC",
    "\u{2F951}"=>"\u40E3",
    "\u{2F952}"=>"\u{25626}",
    "\u{2F953}"=>"\u7956",
    "\u{2F954}"=>"\u{2569A}",
    "\u{2F955}"=>"\u{256C5}",
    "\u{2F956}"=>"\u798F",
    "\u{2F957}"=>"\u79EB",
    "\u{2F958}"=>"\u412F",
    "\u{2F959}"=>"\u7A40",
    "\u{2F95A}"=>"\u7A4A",
    "\u{2F95B}"=>"\u7A4F",
    "\u{2F95C}"=>"\u{2597C}",
    "\u{2F95D}"=>"\u{25AA7}",
    "\u{2F95E}"=>"\u{25AA7}",
    "\u{2F95F}"=>"\u7AEE",
    "\u{2F960}"=>"\u4202",
    "\u{2F961}"=>"\u{25BAB}",
    "\u{2F962}"=>"\u7BC6",
    "\u{2F963}"=>"\u7BC9",
    "\u{2F964}"=>"\u4227",
    "\u{2F965}"=>"\u{25C80}",
    "\u{2F966}"=>"\u7CD2",
    "\u{2F967}"=>"\u42A0",
    "\u{2F968}"=>"\u7CE8",
    "\u{2F969}"=>"\u7CE3",
    "\u{2F96A}"=>"\u7D00",
    "\u{2F96B}"=>"\u{25F86}",
    "\u{2F96C}"=>"\u7D63",
    "\u{2F96D}"=>"\u4301",
    "\u{2F96E}"=>"\u7DC7",
    "\u{2F96F}"=>"\u7E02",
    "\u{2F970}"=>"\u7E45",
    "\u{2F971}"=>"\u4334",
    "\u{2F972}"=>"\u{26228}",
    "\u{2F973}"=>"\u{26247}",
    "\u{2F974}"=>"\u4359",
    "\u{2F975}"=>"\u{262D9}",
    "\u{2F976}"=>"\u7F7A",
    "\u{2F977}"=>"\u{2633E}",
    "\u{2F978}"=>"\u7F95",
    "\u{2F979}"=>"\u7FFA",
    "\u{2F97A}"=>"\u8005",
    "\u{2F97B}"=>"\u{264DA}",
    "\u{2F97C}"=>"\u{26523}",
    "\u{2F97D}"=>"\u8060",
    "\u{2F97E}"=>"\u{265A8}",
    "\u{2F97F}"=>"\u8070",
    "\u{2F980}"=>"\u{2335F}",
    "\u{2F981}"=>"\u43D5",
    "\u{2F982}"=>"\u80B2",
    "\u{2F983}"=>"\u8103",
    "\u{2F984}"=>"\u440B",
    "\u{2F985}"=>"\u813E",
    "\u{2F986}"=>"\u5AB5",
    "\u{2F987}"=>"\u{267A7}",
    "\u{2F988}"=>"\u{267B5}",
    "\u{2F989}"=>"\u{23393}",
    "\u{2F98A}"=>"\u{2339C}",
    "\u{2F98B}"=>"\u8201",
    "\u{2F98C}"=>"\u8204",
    "\u{2F98D}"=>"\u8F9E",
    "\u{2F98E}"=>"\u446B",
    "\u{2F98F}"=>"\u8291",
    "\u{2F990}"=>"\u828B",
    "\u{2F991}"=>"\u829D",
    "\u{2F992}"=>"\u52B3",
    "\u{2F993}"=>"\u82B1",
    "\u{2F994}"=>"\u82B3",
    "\u{2F995}"=>"\u82BD",
    "\u{2F996}"=>"\u82E6",
    "\u{2F997}"=>"\u{26B3C}",
    "\u{2F998}"=>"\u82E5",
    "\u{2F999}"=>"\u831D",
    "\u{2F99A}"=>"\u8363",
    "\u{2F99B}"=>"\u83AD",
    "\u{2F99C}"=>"\u8323",
    "\u{2F99D}"=>"\u83BD",
    "\u{2F99E}"=>"\u83E7",
    "\u{2F99F}"=>"\u8457",
    "\u{2F9A0}"=>"\u8353",
    "\u{2F9A1}"=>"\u83CA",
    "\u{2F9A2}"=>"\u83CC",
    "\u{2F9A3}"=>"\u83DC",
    "\u{2F9A4}"=>"\u{26C36}",
    "\u{2F9A5}"=>"\u{26D6B}",
    "\u{2F9A6}"=>"\u{26CD5}",
    "\u{2F9A7}"=>"\u452B",
    "\u{2F9A8}"=>"\u84F1",
    "\u{2F9A9}"=>"\u84F3",
    "\u{2F9AA}"=>"\u8516",
    "\u{2F9AB}"=>"\u{273CA}",
    "\u{2F9AC}"=>"\u8564",
    "\u{2F9AD}"=>"\u{26F2C}",
    "\u{2F9AE}"=>"\u455D",
    "\u{2F9AF}"=>"\u4561",
    "\u{2F9B0}"=>"\u{26FB1}",
    "\u{2F9B1}"=>"\u{270D2}",
    "\u{2F9B2}"=>"\u456B",
    "\u{2F9B3}"=>"\u8650",
    "\u{2F9B4}"=>"\u865C",
    "\u{2F9B5}"=>"\u8667",
    "\u{2F9B6}"=>"\u8669",
    "\u{2F9B7}"=>"\u86A9",
    "\u{2F9B8}"=>"\u8688",
    "\u{2F9B9}"=>"\u870E",
    "\u{2F9BA}"=>"\u86E2",
    "\u{2F9BB}"=>"\u8779",
    "\u{2F9BC}"=>"\u8728",
    "\u{2F9BD}"=>"\u876B",
    "\u{2F9BE}"=>"\u8786",
    "\u{2F9BF}"=>"\u45D7",
    "\u{2F9C0}"=>"\u87E1",
    "\u{2F9C1}"=>"\u8801",
    "\u{2F9C2}"=>"\u45F9",
    "\u{2F9C3}"=>"\u8860",
    "\u{2F9C4}"=>"\u8863",
    "\u{2F9C5}"=>"\u{27667}",
    "\u{2F9C6}"=>"\u88D7",
    "\u{2F9C7}"=>"\u88DE",
    "\u{2F9C8}"=>"\u4635",
    "\u{2F9C9}"=>"\u88FA",
    "\u{2F9CA}"=>"\u34BB",
    "\u{2F9CB}"=>"\u{278AE}",
    "\u{2F9CC}"=>"\u{27966}",
    "\u{2F9CD}"=>"\u46BE",
    "\u{2F9CE}"=>"\u46C7",
    "\u{2F9CF}"=>"\u8AA0",
    "\u{2F9D0}"=>"\u8AED",
    "\u{2F9D1}"=>"\u8B8A",
    "\u{2F9D2}"=>"\u8C55",
    "\u{2F9D3}"=>"\u{27CA8}",
    "\u{2F9D4}"=>"\u8CAB",
    "\u{2F9D5}"=>"\u8CC1",
    "\u{2F9D6}"=>"\u8D1B",
    "\u{2F9D7}"=>"\u8D77",
    "\u{2F9D8}"=>"\u{27F2F}",
    "\u{2F9D9}"=>"\u{20804}",
    "\u{2F9DA}"=>"\u8DCB",
    "\u{2F9DB}"=>"\u8DBC",
    "\u{2F9DC}"=>"\u8DF0",
    "\u{2F9DD}"=>"\u{208DE}",
    "\u{2F9DE}"=>"\u8ED4",
    "\u{2F9DF}"=>"\u8F38",
    "\u{2F9E0}"=>"\u{285D2}",
    "\u{2F9E1}"=>"\u{285ED}",
    "\u{2F9E2}"=>"\u9094",
    "\u{2F9E3}"=>"\u90F1",
    "\u{2F9E4}"=>"\u9111",
    "\u{2F9E5}"=>"\u{2872E}",
    "\u{2F9E6}"=>"\u911B",
    "\u{2F9E7}"=>"\u9238",
    "\u{2F9E8}"=>"\u92D7",
    "\u{2F9E9}"=>"\u92D8",
    "\u{2F9EA}"=>"\u927C",
    "\u{2F9EB}"=>"\u93F9",
    "\u{2F9EC}"=>"\u9415",
    "\u{2F9ED}"=>"\u{28BFA}",
    "\u{2F9EE}"=>"\u958B",
    "\u{2F9EF}"=>"\u4995",
    "\u{2F9F0}"=>"\u95B7",
    "\u{2F9F1}"=>"\u{28D77}",
    "\u{2F9F2}"=>"\u49E6",
    "\u{2F9F3}"=>"\u96C3",
    "\u{2F9F4}"=>"\u5DB2",
    "\u{2F9F5}"=>"\u9723",
    "\u{2F9F6}"=>"\u{29145}",
    "\u{2F9F7}"=>"\u{2921A}",
    "\u{2F9F8}"=>"\u4A6E",
    "\u{2F9F9}"=>"\u4A76",
    "\u{2F9FA}"=>"\u97E0",
    "\u{2F9FB}"=>"\u{2940A}",
    "\u{2F9FC}"=>"\u4AB2",
    "\u{2F9FD}"=>"\u{29496}",
    "\u{2F9FE}"=>"\u980B",
    "\u{2F9FF}"=>"\u980B",
    "\u{2FA00}"=>"\u9829",
    "\u{2FA01}"=>"\u{295B6}",
    "\u{2FA02}"=>"\u98E2",
    "\u{2FA03}"=>"\u4B33",
    "\u{2FA04}"=>"\u9929",
    "\u{2FA05}"=>"\u99A7",
    "\u{2FA06}"=>"\u99C2",
    "\u{2FA07}"=>"\u99FE",
    "\u{2FA08}"=>"\u4BCE",
    "\u{2FA09}"=>"\u{29B30}",
    "\u{2FA0A}"=>"\u9B12",
    "\u{2FA0B}"=>"\u9C40",
    "\u{2FA0C}"=>"\u9CFD",
    "\u{2FA0D}"=>"\u4CCE",
    "\u{2FA0E}"=>"\u4CED",
    "\u{2FA0F}"=>"\u9D67",
    "\u{2FA10}"=>"\u{2A0CE}",
    "\u{2FA11}"=>"\u4CF8",
    "\u{2FA12}"=>"\u{2A105}",
    "\u{2FA13}"=>"\u{2A20E}",
    "\u{2FA14}"=>"\u{2A291}",
    "\u{2FA15}"=>"\u9EBB",
    "\u{2FA16}"=>"\u4D56",
    "\u{2FA17}"=>"\u9EF9",
    "\u{2FA18}"=>"\u9EFE",
    "\u{2FA19}"=>"\u9F05",
    "\u{2FA1A}"=>"\u9F0F",
    "\u{2FA1B}"=>"\u9F16",
    "\u{2FA1C}"=>"\u9F3B",
    "\u{2FA1D}"=>"\u{2A600}",
  }.freeze

  KOMPATIBLE_TABLE = {
    "\u00A0"=>" ",
    "\u00A8"=>" \u0308",
    "\u00AA"=>"a",
    "\u00AF"=>" \u0304",
    "\u00B2"=>"2",
    "\u00B3"=>"3",
    "\u00B4"=>" \u0301",
    "\u00B5"=>"\u03BC",
    "\u00B8"=>" \u0327",
    "\u00B9"=>"1",
    "\u00BA"=>"o",
    "\u00BC"=>"1\u20444",
    "\u00BD"=>"1\u20442",
    "\u00BE"=>"3\u20444",
    "\u0132"=>"IJ",
    "\u0133"=>"ij",
    "\u013F"=>"L\u00B7",
    "\u0140"=>"l\u00B7",
    "\u0149"=>"\u02BCn",
    "\u017F"=>"s",
    "\u01C4"=>"D\u017D",
    "\u01C5"=>"D\u017E",
    "\u01C6"=>"d\u017E",
    "\u01C7"=>"LJ",
    "\u01C8"=>"Lj",
    "\u01C9"=>"lj",
    "\u01CA"=>"NJ",
    "\u01CB"=>"Nj",
    "\u01CC"=>"nj",
    "\u01F1"=>"DZ",
    "\u01F2"=>"Dz",
    "\u01F3"=>"dz",
    "\u02B0"=>"h",
    "\u02B1"=>"\u0266",
    "\u02B2"=>"j",
    "\u02B3"=>"r",
    "\u02B4"=>"\u0279",
    "\u02B5"=>"\u027B",
    "\u02B6"=>"\u0281",
    "\u02B7"=>"w",
    "\u02B8"=>"y",
    "\u02D8"=>" \u0306",
    "\u02D9"=>" \u0307",
    "\u02DA"=>" \u030A",
    "\u02DB"=>" \u0328",
    "\u02DC"=>" \u0303",
    "\u02DD"=>" \u030B",
    "\u02E0"=>"\u0263",
    "\u02E1"=>"l",
    "\u02E2"=>"s",
    "\u02E3"=>"x",
    "\u02E4"=>"\u0295",
    "\u037A"=>" \u0345",
    "\u0384"=>" \u0301",
    "\u03D0"=>"\u03B2",
    "\u03D1"=>"\u03B8",
    "\u03D2"=>"\u03A5",
    "\u03D5"=>"\u03C6",
    "\u03D6"=>"\u03C0",
    "\u03F0"=>"\u03BA",
    "\u03F1"=>"\u03C1",
    "\u03F2"=>"\u03C2",
    "\u03F4"=>"\u0398",
    "\u03F5"=>"\u03B5",
    "\u03F9"=>"\u03A3",
    "\u0587"=>"\u0565\u0582",
    "\u0675"=>"\u0627\u0674",
    "\u0676"=>"\u0648\u0674",
    "\u0677"=>"\u06C7\u0674",
    "\u0678"=>"\u064A\u0674",
    "\u0E33"=>"\u0E4D\u0E32",
    "\u0EB3"=>"\u0ECD\u0EB2",
    "\u0EDC"=>"\u0EAB\u0E99",
    "\u0EDD"=>"\u0EAB\u0EA1",
    "\u0F0C"=>"\u0F0B",
    "\u0F77"=>"\u0FB2\u0F81",
    "\u0F79"=>"\u0FB3\u0F81",
    "\u10FC"=>"\u10DC",
    "\u1D2C"=>"A",
    "\u1D2D"=>"\u00C6",
    "\u1D2E"=>"B",
    "\u1D30"=>"D",
    "\u1D31"=>"E",
    "\u1D32"=>"\u018E",
    "\u1D33"=>"G",
    "\u1D34"=>"H",
    "\u1D35"=>"I",
    "\u1D36"=>"J",
    "\u1D37"=>"K",
    "\u1D38"=>"L",
    "\u1D39"=>"M",
    "\u1D3A"=>"N",
    "\u1D3C"=>"O",
    "\u1D3D"=>"\u0222",
    "\u1D3E"=>"P",
    "\u1D3F"=>"R",
    "\u1D40"=>"T",
    "\u1D41"=>"U",
    "\u1D42"=>"W",
    "\u1D43"=>"a",
    "\u1D44"=>"\u0250",
    "\u1D45"=>"\u0251",
    "\u1D46"=>"\u1D02",
    "\u1D47"=>"b",
    "\u1D48"=>"d",
    "\u1D49"=>"e",
    "\u1D4A"=>"\u0259",
    "\u1D4B"=>"\u025B",
    "\u1D4C"=>"\u025C",
    "\u1D4D"=>"g",
    "\u1D4F"=>"k",
    "\u1D50"=>"m",
    "\u1D51"=>"\u014B",
    "\u1D52"=>"o",
    "\u1D53"=>"\u0254",
    "\u1D54"=>"\u1D16",
    "\u1D55"=>"\u1D17",
    "\u1D56"=>"p",
    "\u1D57"=>"t",
    "\u1D58"=>"u",
    "\u1D59"=>"\u1D1D",
    "\u1D5A"=>"\u026F",
    "\u1D5B"=>"v",
    "\u1D5C"=>"\u1D25",
    "\u1D5D"=>"\u03B2",
    "\u1D5E"=>"\u03B3",
    "\u1D5F"=>"\u03B4",
    "\u1D60"=>"\u03C6",
    "\u1D61"=>"\u03C7",
    "\u1D62"=>"i",
    "\u1D63"=>"r",
    "\u1D64"=>"u",
    "\u1D65"=>"v",
    "\u1D66"=>"\u03B2",
    "\u1D67"=>"\u03B3",
    "\u1D68"=>"\u03C1",
    "\u1D69"=>"\u03C6",
    "\u1D6A"=>"\u03C7",
    "\u1D78"=>"\u043D",
    "\u1D9B"=>"\u0252",
    "\u1D9C"=>"c",
    "\u1D9D"=>"\u0255",
    "\u1D9E"=>"\u00F0",
    "\u1D9F"=>"\u025C",
    "\u1DA0"=>"f",
    "\u1DA1"=>"\u025F",
    "\u1DA2"=>"\u0261",
    "\u1DA3"=>"\u0265",
    "\u1DA4"=>"\u0268",
    "\u1DA5"=>"\u0269",
    "\u1DA6"=>"\u026A",
    "\u1DA7"=>"\u1D7B",
    "\u1DA8"=>"\u029D",
    "\u1DA9"=>"\u026D",
    "\u1DAA"=>"\u1D85",
    "\u1DAB"=>"\u029F",
    "\u1DAC"=>"\u0271",
    "\u1DAD"=>"\u0270",
    "\u1DAE"=>"\u0272",
    "\u1DAF"=>"\u0273",
    "\u1DB0"=>"\u0274",
    "\u1DB1"=>"\u0275",
    "\u1DB2"=>"\u0278",
    "\u1DB3"=>"\u0282",
    "\u1DB4"=>"\u0283",
    "\u1DB5"=>"\u01AB",
    "\u1DB6"=>"\u0289",
    "\u1DB7"=>"\u028A",
    "\u1DB8"=>"\u1D1C",
    "\u1DB9"=>"\u028B",
    "\u1DBA"=>"\u028C",
    "\u1DBB"=>"z",
    "\u1DBC"=>"\u0290",
    "\u1DBD"=>"\u0291",
    "\u1DBE"=>"\u0292",
    "\u1DBF"=>"\u03B8",
    "\u1E9A"=>"a\u02BE",
    "\u1FBD"=>" \u0313",
    "\u1FBF"=>" \u0313",
    "\u1FC0"=>" \u0342",
    "\u1FFE"=>" \u0314",
    "\u2002"=>" ",
    "\u2003"=>" ",
    "\u2004"=>" ",
    "\u2005"=>" ",
    "\u2006"=>" ",
    "\u2007"=>" ",
    "\u2008"=>" ",
    "\u2009"=>" ",
    "\u200A"=>" ",
    "\u2011"=>"\u2010",
    "\u2017"=>" \u0333",
    "\u2024"=>".",
    "\u2025"=>"..",
    "\u2026"=>"...",
    "\u202F"=>" ",
    "\u2033"=>"\u2032\u2032",
    "\u2034"=>"\u2032\u2032\u2032",
    "\u2036"=>"\u2035\u2035",
    "\u2037"=>"\u2035\u2035\u2035",
    "\u203C"=>"!!",
    "\u203E"=>" \u0305",
    "\u2047"=>"??",
    "\u2048"=>"?!",
    "\u2049"=>"!?",
    "\u2057"=>"\u2032\u2032\u2032\u2032",
    "\u205F"=>" ",
    "\u2070"=>"0",
    "\u2071"=>"i",
    "\u2074"=>"4",
    "\u2075"=>"5",
    "\u2076"=>"6",
    "\u2077"=>"7",
    "\u2078"=>"8",
    "\u2079"=>"9",
    "\u207A"=>"+",
    "\u207B"=>"\u2212",
    "\u207C"=>"=",
    "\u207D"=>"(",
    "\u207E"=>")",
    "\u207F"=>"n",
    "\u2080"=>"0",
    "\u2081"=>"1",
    "\u2082"=>"2",
    "\u2083"=>"3",
    "\u2084"=>"4",
    "\u2085"=>"5",
    "\u2086"=>"6",
    "\u2087"=>"7",
    "\u2088"=>"8",
    "\u2089"=>"9",
    "\u208A"=>"+",
    "\u208B"=>"\u2212",
    "\u208C"=>"=",
    "\u208D"=>"(",
    "\u208E"=>")",
    "\u2090"=>"a",
    "\u2091"=>"e",
    "\u2092"=>"o",
    "\u2093"=>"x",
    "\u2094"=>"\u0259",
    "\u2095"=>"h",
    "\u2096"=>"k",
    "\u2097"=>"l",
    "\u2098"=>"m",
    "\u2099"=>"n",
    "\u209A"=>"p",
    "\u209B"=>"s",
    "\u209C"=>"t",
    "\u20A8"=>"Rs",
    "\u2100"=>"a/c",
    "\u2101"=>"a/s",
    "\u2102"=>"C",
    "\u2103"=>"\u00B0C",
    "\u2105"=>"c/o",
    "\u2106"=>"c/u",
    "\u2107"=>"\u0190",
    "\u2109"=>"\u00B0F",
    "\u210A"=>"g",
    "\u210B"=>"H",
    "\u210C"=>"H",
    "\u210D"=>"H",
    "\u210E"=>"h",
    "\u210F"=>"\u0127",
    "\u2110"=>"I",
    "\u2111"=>"I",
    "\u2112"=>"L",
    "\u2113"=>"l",
    "\u2115"=>"N",
    "\u2116"=>"No",
    "\u2119"=>"P",
    "\u211A"=>"Q",
    "\u211B"=>"R",
    "\u211C"=>"R",
    "\u211D"=>"R",
    "\u2120"=>"SM",
    "\u2121"=>"TEL",
    "\u2122"=>"TM",
    "\u2124"=>"Z",
    "\u2128"=>"Z",
    "\u212C"=>"B",
    "\u212D"=>"C",
    "\u212F"=>"e",
    "\u2130"=>"E",
    "\u2131"=>"F",
    "\u2133"=>"M",
    "\u2134"=>"o",
    "\u2135"=>"\u05D0",
    "\u2136"=>"\u05D1",
    "\u2137"=>"\u05D2",
    "\u2138"=>"\u05D3",
    "\u2139"=>"i",
    "\u213B"=>"FAX",
    "\u213C"=>"\u03C0",
    "\u213D"=>"\u03B3",
    "\u213E"=>"\u0393",
    "\u213F"=>"\u03A0",
    "\u2140"=>"\u2211",
    "\u2145"=>"D",
    "\u2146"=>"d",
    "\u2147"=>"e",
    "\u2148"=>"i",
    "\u2149"=>"j",
    "\u2150"=>"1\u20447",
    "\u2151"=>"1\u20449",
    "\u2152"=>"1\u204410",
    "\u2153"=>"1\u20443",
    "\u2154"=>"2\u20443",
    "\u2155"=>"1\u20445",
    "\u2156"=>"2\u20445",
    "\u2157"=>"3\u20445",
    "\u2158"=>"4\u20445",
    "\u2159"=>"1\u20446",
    "\u215A"=>"5\u20446",
    "\u215B"=>"1\u20448",
    "\u215C"=>"3\u20448",
    "\u215D"=>"5\u20448",
    "\u215E"=>"7\u20448",
    "\u215F"=>"1\u2044",
    "\u2160"=>"I",
    "\u2161"=>"II",
    "\u2162"=>"III",
    "\u2163"=>"IV",
    "\u2164"=>"V",
    "\u2165"=>"VI",
    "\u2166"=>"VII",
    "\u2167"=>"VIII",
    "\u2168"=>"IX",
    "\u2169"=>"X",
    "\u216A"=>"XI",
    "\u216B"=>"XII",
    "\u216C"=>"L",
    "\u216D"=>"C",
    "\u216E"=>"D",
    "\u216F"=>"M",
    "\u2170"=>"i",
    "\u2171"=>"ii",
    "\u2172"=>"iii",
    "\u2173"=>"iv",
    "\u2174"=>"v",
    "\u2175"=>"vi",
    "\u2176"=>"vii",
    "\u2177"=>"viii",
    "\u2178"=>"ix",
    "\u2179"=>"x",
    "\u217A"=>"xi",
    "\u217B"=>"xii",
    "\u217C"=>"l",
    "\u217D"=>"c",
    "\u217E"=>"d",
    "\u217F"=>"m",
    "\u2189"=>"0\u20443",
    "\u222C"=>"\u222B\u222B",
    "\u222D"=>"\u222B\u222B\u222B",
    "\u222F"=>"\u222E\u222E",
    "\u2230"=>"\u222E\u222E\u222E",
    "\u2460"=>"1",
    "\u2461"=>"2",
    "\u2462"=>"3",
    "\u2463"=>"4",
    "\u2464"=>"5",
    "\u2465"=>"6",
    "\u2466"=>"7",
    "\u2467"=>"8",
    "\u2468"=>"9",
    "\u2469"=>"10",
    "\u246A"=>"11",
    "\u246B"=>"12",
    "\u246C"=>"13",
    "\u246D"=>"14",
    "\u246E"=>"15",
    "\u246F"=>"16",
    "\u2470"=>"17",
    "\u2471"=>"18",
    "\u2472"=>"19",
    "\u2473"=>"20",
    "\u2474"=>"(1)",
    "\u2475"=>"(2)",
    "\u2476"=>"(3)",
    "\u2477"=>"(4)",
    "\u2478"=>"(5)",
    "\u2479"=>"(6)",
    "\u247A"=>"(7)",
    "\u247B"=>"(8)",
    "\u247C"=>"(9)",
    "\u247D"=>"(10)",
    "\u247E"=>"(11)",
    "\u247F"=>"(12)",
    "\u2480"=>"(13)",
    "\u2481"=>"(14)",
    "\u2482"=>"(15)",
    "\u2483"=>"(16)",
    "\u2484"=>"(17)",
    "\u2485"=>"(18)",
    "\u2486"=>"(19)",
    "\u2487"=>"(20)",
    "\u2488"=>"1.",
    "\u2489"=>"2.",
    "\u248A"=>"3.",
    "\u248B"=>"4.",
    "\u248C"=>"5.",
    "\u248D"=>"6.",
    "\u248E"=>"7.",
    "\u248F"=>"8.",
    "\u2490"=>"9.",
    "\u2491"=>"10.",
    "\u2492"=>"11.",
    "\u2493"=>"12.",
    "\u2494"=>"13.",
    "\u2495"=>"14.",
    "\u2496"=>"15.",
    "\u2497"=>"16.",
    "\u2498"=>"17.",
    "\u2499"=>"18.",
    "\u249A"=>"19.",
    "\u249B"=>"20.",
    "\u249C"=>"(a)",
    "\u249D"=>"(b)",
    "\u249E"=>"(c)",
    "\u249F"=>"(d)",
    "\u24A0"=>"(e)",
    "\u24A1"=>"(f)",
    "\u24A2"=>"(g)",
    "\u24A3"=>"(h)",
    "\u24A4"=>"(i)",
    "\u24A5"=>"(j)",
    "\u24A6"=>"(k)",
    "\u24A7"=>"(l)",
    "\u24A8"=>"(m)",
    "\u24A9"=>"(n)",
    "\u24AA"=>"(o)",
    "\u24AB"=>"(p)",
    "\u24AC"=>"(q)",
    "\u24AD"=>"(r)",
    "\u24AE"=>"(s)",
    "\u24AF"=>"(t)",
    "\u24B0"=>"(u)",
    "\u24B1"=>"(v)",
    "\u24B2"=>"(w)",
    "\u24B3"=>"(x)",
    "\u24B4"=>"(y)",
    "\u24B5"=>"(z)",
    "\u24B6"=>"A",
    "\u24B7"=>"B",
    "\u24B8"=>"C",
    "\u24B9"=>"D",
    "\u24BA"=>"E",
    "\u24BB"=>"F",
    "\u24BC"=>"G",
    "\u24BD"=>"H",
    "\u24BE"=>"I",
    "\u24BF"=>"J",
    "\u24C0"=>"K",
    "\u24C1"=>"L",
    "\u24C2"=>"M",
    "\u24C3"=>"N",
    "\u24C4"=>"O",
    "\u24C5"=>"P",
    "\u24C6"=>"Q",
    "\u24C7"=>"R",
    "\u24C8"=>"S",
    "\u24C9"=>"T",
    "\u24CA"=>"U",
    "\u24CB"=>"V",
    "\u24CC"=>"W",
    "\u24CD"=>"X",
    "\u24CE"=>"Y",
    "\u24CF"=>"Z",
    "\u24D0"=>"a",
    "\u24D1"=>"b",
    "\u24D2"=>"c",
    "\u24D3"=>"d",
    "\u24D4"=>"e",
    "\u24D5"=>"f",
    "\u24D6"=>"g",
    "\u24D7"=>"h",
    "\u24D8"=>"i",
    "\u24D9"=>"j",
    "\u24DA"=>"k",
    "\u24DB"=>"l",
    "\u24DC"=>"m",
    "\u24DD"=>"n",
    "\u24DE"=>"o",
    "\u24DF"=>"p",
    "\u24E0"=>"q",
    "\u24E1"=>"r",
    "\u24E2"=>"s",
    "\u24E3"=>"t",
    "\u24E4"=>"u",
    "\u24E5"=>"v",
    "\u24E6"=>"w",
    "\u24E7"=>"x",
    "\u24E8"=>"y",
    "\u24E9"=>"z",
    "\u24EA"=>"0",
    "\u2A0C"=>"\u222B\u222B\u222B\u222B",
    "\u2A74"=>"::=",
    "\u2A75"=>"==",
    "\u2A76"=>"===",
    "\u2C7C"=>"j",
    "\u2C7D"=>"V",
    "\u2D6F"=>"\u2D61",
    "\u2E9F"=>"\u6BCD",
    "\u2EF3"=>"\u9F9F",
    "\u2F00"=>"\u4E00",
    "\u2F01"=>"\u4E28",
    "\u2F02"=>"\u4E36",
    "\u2F03"=>"\u4E3F",
    "\u2F04"=>"\u4E59",
    "\u2F05"=>"\u4E85",
    "\u2F06"=>"\u4E8C",
    "\u2F07"=>"\u4EA0",
    "\u2F08"=>"\u4EBA",
    "\u2F09"=>"\u513F",
    "\u2F0A"=>"\u5165",
    "\u2F0B"=>"\u516B",
    "\u2F0C"=>"\u5182",
    "\u2F0D"=>"\u5196",
    "\u2F0E"=>"\u51AB",
    "\u2F0F"=>"\u51E0",
    "\u2F10"=>"\u51F5",
    "\u2F11"=>"\u5200",
    "\u2F12"=>"\u529B",
    "\u2F13"=>"\u52F9",
    "\u2F14"=>"\u5315",
    "\u2F15"=>"\u531A",
    "\u2F16"=>"\u5338",
    "\u2F17"=>"\u5341",
    "\u2F18"=>"\u535C",
    "\u2F19"=>"\u5369",
    "\u2F1A"=>"\u5382",
    "\u2F1B"=>"\u53B6",
    "\u2F1C"=>"\u53C8",
    "\u2F1D"=>"\u53E3",
    "\u2F1E"=>"\u56D7",
    "\u2F1F"=>"\u571F",
    "\u2F20"=>"\u58EB",
    "\u2F21"=>"\u5902",
    "\u2F22"=>"\u590A",
    "\u2F23"=>"\u5915",
    "\u2F24"=>"\u5927",
    "\u2F25"=>"\u5973",
    "\u2F26"=>"\u5B50",
    "\u2F27"=>"\u5B80",
    "\u2F28"=>"\u5BF8",
    "\u2F29"=>"\u5C0F",
    "\u2F2A"=>"\u5C22",
    "\u2F2B"=>"\u5C38",
    "\u2F2C"=>"\u5C6E",
    "\u2F2D"=>"\u5C71",
    "\u2F2E"=>"\u5DDB",
    "\u2F2F"=>"\u5DE5",
    "\u2F30"=>"\u5DF1",
    "\u2F31"=>"\u5DFE",
    "\u2F32"=>"\u5E72",
    "\u2F33"=>"\u5E7A",
    "\u2F34"=>"\u5E7F",
    "\u2F35"=>"\u5EF4",
    "\u2F36"=>"\u5EFE",
    "\u2F37"=>"\u5F0B",
    "\u2F38"=>"\u5F13",
    "\u2F39"=>"\u5F50",
    "\u2F3A"=>"\u5F61",
    "\u2F3B"=>"\u5F73",
    "\u2F3C"=>"\u5FC3",
    "\u2F3D"=>"\u6208",
    "\u2F3E"=>"\u6236",
    "\u2F3F"=>"\u624B",
    "\u2F40"=>"\u652F",
    "\u2F41"=>"\u6534",
    "\u2F42"=>"\u6587",
    "\u2F43"=>"\u6597",
    "\u2F44"=>"\u65A4",
    "\u2F45"=>"\u65B9",
    "\u2F46"=>"\u65E0",
    "\u2F47"=>"\u65E5",
    "\u2F48"=>"\u66F0",
    "\u2F49"=>"\u6708",
    "\u2F4A"=>"\u6728",
    "\u2F4B"=>"\u6B20",
    "\u2F4C"=>"\u6B62",
    "\u2F4D"=>"\u6B79",
    "\u2F4E"=>"\u6BB3",
    "\u2F4F"=>"\u6BCB",
    "\u2F50"=>"\u6BD4",
    "\u2F51"=>"\u6BDB",
    "\u2F52"=>"\u6C0F",
    "\u2F53"=>"\u6C14",
    "\u2F54"=>"\u6C34",
    "\u2F55"=>"\u706B",
    "\u2F56"=>"\u722A",
    "\u2F57"=>"\u7236",
    "\u2F58"=>"\u723B",
    "\u2F59"=>"\u723F",
    "\u2F5A"=>"\u7247",
    "\u2F5B"=>"\u7259",
    "\u2F5C"=>"\u725B",
    "\u2F5D"=>"\u72AC",
    "\u2F5E"=>"\u7384",
    "\u2F5F"=>"\u7389",
    "\u2F60"=>"\u74DC",
    "\u2F61"=>"\u74E6",
    "\u2F62"=>"\u7518",
    "\u2F63"=>"\u751F",
    "\u2F64"=>"\u7528",
    "\u2F65"=>"\u7530",
    "\u2F66"=>"\u758B",
    "\u2F67"=>"\u7592",
    "\u2F68"=>"\u7676",
    "\u2F69"=>"\u767D",
    "\u2F6A"=>"\u76AE",
    "\u2F6B"=>"\u76BF",
    "\u2F6C"=>"\u76EE",
    "\u2F6D"=>"\u77DB",
    "\u2F6E"=>"\u77E2",
    "\u2F6F"=>"\u77F3",
    "\u2F70"=>"\u793A",
    "\u2F71"=>"\u79B8",
    "\u2F72"=>"\u79BE",
    "\u2F73"=>"\u7A74",
    "\u2F74"=>"\u7ACB",
    "\u2F75"=>"\u7AF9",
    "\u2F76"=>"\u7C73",
    "\u2F77"=>"\u7CF8",
    "\u2F78"=>"\u7F36",
    "\u2F79"=>"\u7F51",
    "\u2F7A"=>"\u7F8A",
    "\u2F7B"=>"\u7FBD",
    "\u2F7C"=>"\u8001",
    "\u2F7D"=>"\u800C",
    "\u2F7E"=>"\u8012",
    "\u2F7F"=>"\u8033",
    "\u2F80"=>"\u807F",
    "\u2F81"=>"\u8089",
    "\u2F82"=>"\u81E3",
    "\u2F83"=>"\u81EA",
    "\u2F84"=>"\u81F3",
    "\u2F85"=>"\u81FC",
    "\u2F86"=>"\u820C",
    "\u2F87"=>"\u821B",
    "\u2F88"=>"\u821F",
    "\u2F89"=>"\u826E",
    "\u2F8A"=>"\u8272",
    "\u2F8B"=>"\u8278",
    "\u2F8C"=>"\u864D",
    "\u2F8D"=>"\u866B",
    "\u2F8E"=>"\u8840",
    "\u2F8F"=>"\u884C",
    "\u2F90"=>"\u8863",
    "\u2F91"=>"\u897E",
    "\u2F92"=>"\u898B",
    "\u2F93"=>"\u89D2",
    "\u2F94"=>"\u8A00",
    "\u2F95"=>"\u8C37",
    "\u2F96"=>"\u8C46",
    "\u2F97"=>"\u8C55",
    "\u2F98"=>"\u8C78",
    "\u2F99"=>"\u8C9D",
    "\u2F9A"=>"\u8D64",
    "\u2F9B"=>"\u8D70",
    "\u2F9C"=>"\u8DB3",
    "\u2F9D"=>"\u8EAB",
    "\u2F9E"=>"\u8ECA",
    "\u2F9F"=>"\u8F9B",
    "\u2FA0"=>"\u8FB0",
    "\u2FA1"=>"\u8FB5",
    "\u2FA2"=>"\u9091",
    "\u2FA3"=>"\u9149",
    "\u2FA4"=>"\u91C6",
    "\u2FA5"=>"\u91CC",
    "\u2FA6"=>"\u91D1",
    "\u2FA7"=>"\u9577",
    "\u2FA8"=>"\u9580",
    "\u2FA9"=>"\u961C",
    "\u2FAA"=>"\u96B6",
    "\u2FAB"=>"\u96B9",
    "\u2FAC"=>"\u96E8",
    "\u2FAD"=>"\u9751",
    "\u2FAE"=>"\u975E",
    "\u2FAF"=>"\u9762",
    "\u2FB0"=>"\u9769",
    "\u2FB1"=>"\u97CB",
    "\u2FB2"=>"\u97ED",
    "\u2FB3"=>"\u97F3",
    "\u2FB4"=>"\u9801",
    "\u2FB5"=>"\u98A8",
    "\u2FB6"=>"\u98DB",
    "\u2FB7"=>"\u98DF",
    "\u2FB8"=>"\u9996",
    "\u2FB9"=>"\u9999",
    "\u2FBA"=>"\u99AC",
    "\u2FBB"=>"\u9AA8",
    "\u2FBC"=>"\u9AD8",
    "\u2FBD"=>"\u9ADF",
    "\u2FBE"=>"\u9B25",
    "\u2FBF"=>"\u9B2F",
    "\u2FC0"=>"\u9B32",
    "\u2FC1"=>"\u9B3C",
    "\u2FC2"=>"\u9B5A",
    "\u2FC3"=>"\u9CE5",
    "\u2FC4"=>"\u9E75",
    "\u2FC5"=>"\u9E7F",
    "\u2FC6"=>"\u9EA5",
    "\u2FC7"=>"\u9EBB",
    "\u2FC8"=>"\u9EC3",
    "\u2FC9"=>"\u9ECD",
    "\u2FCA"=>"\u9ED1",
    "\u2FCB"=>"\u9EF9",
    "\u2FCC"=>"\u9EFD",
    "\u2FCD"=>"\u9F0E",
    "\u2FCE"=>"\u9F13",
    "\u2FCF"=>"\u9F20",
    "\u2FD0"=>"\u9F3B",
    "\u2FD1"=>"\u9F4A",
    "\u2FD2"=>"\u9F52",
    "\u2FD3"=>"\u9F8D",
    "\u2FD4"=>"\u9F9C",
    "\u2FD5"=>"\u9FA0",
    "\u3000"=>" ",
    "\u3036"=>"\u3012",
    "\u3038"=>"\u5341",
    "\u3039"=>"\u5344",
    "\u303A"=>"\u5345",
    "\u309B"=>" \u3099",
    "\u309C"=>" \u309A",
    "\u309F"=>"\u3088\u308A",
    "\u30FF"=>"\u30B3\u30C8",
    "\u3131"=>"\u1100",
    "\u3132"=>"\u1101",
    "\u3133"=>"\u11AA",
    "\u3134"=>"\u1102",
    "\u3135"=>"\u11AC",
    "\u3136"=>"\u11AD",
    "\u3137"=>"\u1103",
    "\u3138"=>"\u1104",
    "\u3139"=>"\u1105",
    "\u313A"=>"\u11B0",
    "\u313B"=>"\u11B1",
    "\u313C"=>"\u11B2",
    "\u313D"=>"\u11B3",
    "\u313E"=>"\u11B4",
    "\u313F"=>"\u11B5",
    "\u3140"=>"\u111A",
    "\u3141"=>"\u1106",
    "\u3142"=>"\u1107",
    "\u3143"=>"\u1108",
    "\u3144"=>"\u1121",
    "\u3145"=>"\u1109",
    "\u3146"=>"\u110A",
    "\u3147"=>"\u110B",
    "\u3148"=>"\u110C",
    "\u3149"=>"\u110D",
    "\u314A"=>"\u110E",
    "\u314B"=>"\u110F",
    "\u314C"=>"\u1110",
    "\u314D"=>"\u1111",
    "\u314E"=>"\u1112",
    "\u314F"=>"\u1161",
    "\u3150"=>"\u1162",
    "\u3151"=>"\u1163",
    "\u3152"=>"\u1164",
    "\u3153"=>"\u1165",
    "\u3154"=>"\u1166",
    "\u3155"=>"\u1167",
    "\u3156"=>"\u1168",
    "\u3157"=>"\u1169",
    "\u3158"=>"\u116A",
    "\u3159"=>"\u116B",
    "\u315A"=>"\u116C",
    "\u315B"=>"\u116D",
    "\u315C"=>"\u116E",
    "\u315D"=>"\u116F",
    "\u315E"=>"\u1170",
    "\u315F"=>"\u1171",
    "\u3160"=>"\u1172",
    "\u3161"=>"\u1173",
    "\u3162"=>"\u1174",
    "\u3163"=>"\u1175",
    "\u3164"=>"\u1160",
    "\u3165"=>"\u1114",
    "\u3166"=>"\u1115",
    "\u3167"=>"\u11C7",
    "\u3168"=>"\u11C8",
    "\u3169"=>"\u11CC",
    "\u316A"=>"\u11CE",
    "\u316B"=>"\u11D3",
    "\u316C"=>"\u11D7",
    "\u316D"=>"\u11D9",
    "\u316E"=>"\u111C",
    "\u316F"=>"\u11DD",
    "\u3170"=>"\u11DF",
    "\u3171"=>"\u111D",
    "\u3172"=>"\u111E",
    "\u3173"=>"\u1120",
    "\u3174"=>"\u1122",
    "\u3175"=>"\u1123",
    "\u3176"=>"\u1127",
    "\u3177"=>"\u1129",
    "\u3178"=>"\u112B",
    "\u3179"=>"\u112C",
    "\u317A"=>"\u112D",
    "\u317B"=>"\u112E",
    "\u317C"=>"\u112F",
    "\u317D"=>"\u1132",
    "\u317E"=>"\u1136",
    "\u317F"=>"\u1140",
    "\u3180"=>"\u1147",
    "\u3181"=>"\u114C",
    "\u3182"=>"\u11F1",
    "\u3183"=>"\u11F2",
    "\u3184"=>"\u1157",
    "\u3185"=>"\u1158",
    "\u3186"=>"\u1159",
    "\u3187"=>"\u1184",
    "\u3188"=>"\u1185",
    "\u3189"=>"\u1188",
    "\u318A"=>"\u1191",
    "\u318B"=>"\u1192",
    "\u318C"=>"\u1194",
    "\u318D"=>"\u119E",
    "\u318E"=>"\u11A1",
    "\u3192"=>"\u4E00",
    "\u3193"=>"\u4E8C",
    "\u3194"=>"\u4E09",
    "\u3195"=>"\u56DB",
    "\u3196"=>"\u4E0A",
    "\u3197"=>"\u4E2D",
    "\u3198"=>"\u4E0B",
    "\u3199"=>"\u7532",
    "\u319A"=>"\u4E59",
    "\u319B"=>"\u4E19",
    "\u319C"=>"\u4E01",
    "\u319D"=>"\u5929",
    "\u319E"=>"\u5730",
    "\u319F"=>"\u4EBA",
    "\u3200"=>"(\u1100)",
    "\u3201"=>"(\u1102)",
    "\u3202"=>"(\u1103)",
    "\u3203"=>"(\u1105)",
    "\u3204"=>"(\u1106)",
    "\u3205"=>"(\u1107)",
    "\u3206"=>"(\u1109)",
    "\u3207"=>"(\u110B)",
    "\u3208"=>"(\u110C)",
    "\u3209"=>"(\u110E)",
    "\u320A"=>"(\u110F)",
    "\u320B"=>"(\u1110)",
    "\u320C"=>"(\u1111)",
    "\u320D"=>"(\u1112)",
    "\u320E"=>"(\u1100\u1161)",
    "\u320F"=>"(\u1102\u1161)",
    "\u3210"=>"(\u1103\u1161)",
    "\u3211"=>"(\u1105\u1161)",
    "\u3212"=>"(\u1106\u1161)",
    "\u3213"=>"(\u1107\u1161)",
    "\u3214"=>"(\u1109\u1161)",
    "\u3215"=>"(\u110B\u1161)",
    "\u3216"=>"(\u110C\u1161)",
    "\u3217"=>"(\u110E\u1161)",
    "\u3218"=>"(\u110F\u1161)",
    "\u3219"=>"(\u1110\u1161)",
    "\u321A"=>"(\u1111\u1161)",
    "\u321B"=>"(\u1112\u1161)",
    "\u321C"=>"(\u110C\u116E)",
    "\u321D"=>"(\u110B\u1169\u110C\u1165\u11AB)",
    "\u321E"=>"(\u110B\u1169\u1112\u116E)",
    "\u3220"=>"(\u4E00)",
    "\u3221"=>"(\u4E8C)",
    "\u3222"=>"(\u4E09)",
    "\u3223"=>"(\u56DB)",
    "\u3224"=>"(\u4E94)",
    "\u3225"=>"(\u516D)",
    "\u3226"=>"(\u4E03)",
    "\u3227"=>"(\u516B)",
    "\u3228"=>"(\u4E5D)",
    "\u3229"=>"(\u5341)",
    "\u322A"=>"(\u6708)",
    "\u322B"=>"(\u706B)",
    "\u322C"=>"(\u6C34)",
    "\u322D"=>"(\u6728)",
    "\u322E"=>"(\u91D1)",
    "\u322F"=>"(\u571F)",
    "\u3230"=>"(\u65E5)",
    "\u3231"=>"(\u682A)",
    "\u3232"=>"(\u6709)",
    "\u3233"=>"(\u793E)",
    "\u3234"=>"(\u540D)",
    "\u3235"=>"(\u7279)",
    "\u3236"=>"(\u8CA1)",
    "\u3237"=>"(\u795D)",
    "\u3238"=>"(\u52B4)",
    "\u3239"=>"(\u4EE3)",
    "\u323A"=>"(\u547C)",
    "\u323B"=>"(\u5B66)",
    "\u323C"=>"(\u76E3)",
    "\u323D"=>"(\u4F01)",
    "\u323E"=>"(\u8CC7)",
    "\u323F"=>"(\u5354)",
    "\u3240"=>"(\u796D)",
    "\u3241"=>"(\u4F11)",
    "\u3242"=>"(\u81EA)",
    "\u3243"=>"(\u81F3)",
    "\u3244"=>"\u554F",
    "\u3245"=>"\u5E7C",
    "\u3246"=>"\u6587",
    "\u3247"=>"\u7B8F",
    "\u3250"=>"PTE",
    "\u3251"=>"21",
    "\u3252"=>"22",
    "\u3253"=>"23",
    "\u3254"=>"24",
    "\u3255"=>"25",
    "\u3256"=>"26",
    "\u3257"=>"27",
    "\u3258"=>"28",
    "\u3259"=>"29",
    "\u325A"=>"30",
    "\u325B"=>"31",
    "\u325C"=>"32",
    "\u325D"=>"33",
    "\u325E"=>"34",
    "\u325F"=>"35",
    "\u3260"=>"\u1100",
    "\u3261"=>"\u1102",
    "\u3262"=>"\u1103",
    "\u3263"=>"\u1105",
    "\u3264"=>"\u1106",
    "\u3265"=>"\u1107",
    "\u3266"=>"\u1109",
    "\u3267"=>"\u110B",
    "\u3268"=>"\u110C",
    "\u3269"=>"\u110E",
    "\u326A"=>"\u110F",
    "\u326B"=>"\u1110",
    "\u326C"=>"\u1111",
    "\u326D"=>"\u1112",
    "\u326E"=>"\u1100\u1161",
    "\u326F"=>"\u1102\u1161",
    "\u3270"=>"\u1103\u1161",
    "\u3271"=>"\u1105\u1161",
    "\u3272"=>"\u1106\u1161",
    "\u3273"=>"\u1107\u1161",
    "\u3274"=>"\u1109\u1161",
    "\u3275"=>"\u110B\u1161",
    "\u3276"=>"\u110C\u1161",
    "\u3277"=>"\u110E\u1161",
    "\u3278"=>"\u110F\u1161",
    "\u3279"=>"\u1110\u1161",
    "\u327A"=>"\u1111\u1161",
    "\u327B"=>"\u1112\u1161",
    "\u327C"=>"\u110E\u1161\u11B7\u1100\u1169",
    "\u327D"=>"\u110C\u116E\u110B\u1174",
    "\u327E"=>"\u110B\u116E",
    "\u3280"=>"\u4E00",
    "\u3281"=>"\u4E8C",
    "\u3282"=>"\u4E09",
    "\u3283"=>"\u56DB",
    "\u3284"=>"\u4E94",
    "\u3285"=>"\u516D",
    "\u3286"=>"\u4E03",
    "\u3287"=>"\u516B",
    "\u3288"=>"\u4E5D",
    "\u3289"=>"\u5341",
    "\u328A"=>"\u6708",
    "\u328B"=>"\u706B",
    "\u328C"=>"\u6C34",
    "\u328D"=>"\u6728",
    "\u328E"=>"\u91D1",
    "\u328F"=>"\u571F",
    "\u3290"=>"\u65E5",
    "\u3291"=>"\u682A",
    "\u3292"=>"\u6709",
    "\u3293"=>"\u793E",
    "\u3294"=>"\u540D",
    "\u3295"=>"\u7279",
    "\u3296"=>"\u8CA1",
    "\u3297"=>"\u795D",
    "\u3298"=>"\u52B4",
    "\u3299"=>"\u79D8",
    "\u329A"=>"\u7537",
    "\u329B"=>"\u5973",
    "\u329C"=>"\u9069",
    "\u329D"=>"\u512A",
    "\u329E"=>"\u5370",
    "\u329F"=>"\u6CE8",
    "\u32A0"=>"\u9805",
    "\u32A1"=>"\u4F11",
    "\u32A2"=>"\u5199",
    "\u32A3"=>"\u6B63",
    "\u32A4"=>"\u4E0A",
    "\u32A5"=>"\u4E2D",
    "\u32A6"=>"\u4E0B",
    "\u32A7"=>"\u5DE6",
    "\u32A8"=>"\u53F3",
    "\u32A9"=>"\u533B",
    "\u32AA"=>"\u5B97",
    "\u32AB"=>"\u5B66",
    "\u32AC"=>"\u76E3",
    "\u32AD"=>"\u4F01",
    "\u32AE"=>"\u8CC7",
    "\u32AF"=>"\u5354",
    "\u32B0"=>"\u591C",
    "\u32B1"=>"36",
    "\u32B2"=>"37",
    "\u32B3"=>"38",
    "\u32B4"=>"39",
    "\u32B5"=>"40",
    "\u32B6"=>"41",
    "\u32B7"=>"42",
    "\u32B8"=>"43",
    "\u32B9"=>"44",
    "\u32BA"=>"45",
    "\u32BB"=>"46",
    "\u32BC"=>"47",
    "\u32BD"=>"48",
    "\u32BE"=>"49",
    "\u32BF"=>"50",
    "\u32C0"=>"1\u6708",
    "\u32C1"=>"2\u6708",
    "\u32C2"=>"3\u6708",
    "\u32C3"=>"4\u6708",
    "\u32C4"=>"5\u6708",
    "\u32C5"=>"6\u6708",
    "\u32C6"=>"7\u6708",
    "\u32C7"=>"8\u6708",
    "\u32C8"=>"9\u6708",
    "\u32C9"=>"10\u6708",
    "\u32CA"=>"11\u6708",
    "\u32CB"=>"12\u6708",
    "\u32CC"=>"Hg",
    "\u32CD"=>"erg",
    "\u32CE"=>"eV",
    "\u32CF"=>"LTD",
    "\u32D0"=>"\u30A2",
    "\u32D1"=>"\u30A4",
    "\u32D2"=>"\u30A6",
    "\u32D3"=>"\u30A8",
    "\u32D4"=>"\u30AA",
    "\u32D5"=>"\u30AB",
    "\u32D6"=>"\u30AD",
    "\u32D7"=>"\u30AF",
    "\u32D8"=>"\u30B1",
    "\u32D9"=>"\u30B3",
    "\u32DA"=>"\u30B5",
    "\u32DB"=>"\u30B7",
    "\u32DC"=>"\u30B9",
    "\u32DD"=>"\u30BB",
    "\u32DE"=>"\u30BD",
    "\u32DF"=>"\u30BF",
    "\u32E0"=>"\u30C1",
    "\u32E1"=>"\u30C4",
    "\u32E2"=>"\u30C6",
    "\u32E3"=>"\u30C8",
    "\u32E4"=>"\u30CA",
    "\u32E5"=>"\u30CB",
    "\u32E6"=>"\u30CC",
    "\u32E7"=>"\u30CD",
    "\u32E8"=>"\u30CE",
    "\u32E9"=>"\u30CF",
    "\u32EA"=>"\u30D2",
    "\u32EB"=>"\u30D5",
    "\u32EC"=>"\u30D8",
    "\u32ED"=>"\u30DB",
    "\u32EE"=>"\u30DE",
    "\u32EF"=>"\u30DF",
    "\u32F0"=>"\u30E0",
    "\u32F1"=>"\u30E1",
    "\u32F2"=>"\u30E2",
    "\u32F3"=>"\u30E4",
    "\u32F4"=>"\u30E6",
    "\u32F5"=>"\u30E8",
    "\u32F6"=>"\u30E9",
    "\u32F7"=>"\u30EA",
    "\u32F8"=>"\u30EB",
    "\u32F9"=>"\u30EC",
    "\u32FA"=>"\u30ED",
    "\u32FB"=>"\u30EF",
    "\u32FC"=>"\u30F0",
    "\u32FD"=>"\u30F1",
    "\u32FE"=>"\u30F2",
    "\u32FF"=>"\u4EE4\u548C",
    "\u3300"=>"\u30A2\u30D1\u30FC\u30C8",
    "\u3301"=>"\u30A2\u30EB\u30D5\u30A1",
    "\u3302"=>"\u30A2\u30F3\u30DA\u30A2",
    "\u3303"=>"\u30A2\u30FC\u30EB",
    "\u3304"=>"\u30A4\u30CB\u30F3\u30B0",
    "\u3305"=>"\u30A4\u30F3\u30C1",
    "\u3306"=>"\u30A6\u30A9\u30F3",
    "\u3307"=>"\u30A8\u30B9\u30AF\u30FC\u30C9",
    "\u3308"=>"\u30A8\u30FC\u30AB\u30FC",
    "\u3309"=>"\u30AA\u30F3\u30B9",
    "\u330A"=>"\u30AA\u30FC\u30E0",
    "\u330B"=>"\u30AB\u30A4\u30EA",
    "\u330C"=>"\u30AB\u30E9\u30C3\u30C8",
    "\u330D"=>"\u30AB\u30ED\u30EA\u30FC",
    "\u330E"=>"\u30AC\u30ED\u30F3",
    "\u330F"=>"\u30AC\u30F3\u30DE",
    "\u3310"=>"\u30AE\u30AC",
    "\u3311"=>"\u30AE\u30CB\u30FC",
    "\u3312"=>"\u30AD\u30E5\u30EA\u30FC",
    "\u3313"=>"\u30AE\u30EB\u30C0\u30FC",
    "\u3314"=>"\u30AD\u30ED",
    "\u3315"=>"\u30AD\u30ED\u30B0\u30E9\u30E0",
    "\u3316"=>"\u30AD\u30ED\u30E1\u30FC\u30C8\u30EB",
    "\u3317"=>"\u30AD\u30ED\u30EF\u30C3\u30C8",
    "\u3318"=>"\u30B0\u30E9\u30E0",
    "\u3319"=>"\u30B0\u30E9\u30E0\u30C8\u30F3",
    "\u331A"=>"\u30AF\u30EB\u30BC\u30A4\u30ED",
    "\u331B"=>"\u30AF\u30ED\u30FC\u30CD",
    "\u331C"=>"\u30B1\u30FC\u30B9",
    "\u331D"=>"\u30B3\u30EB\u30CA",
    "\u331E"=>"\u30B3\u30FC\u30DD",
    "\u331F"=>"\u30B5\u30A4\u30AF\u30EB",
    "\u3320"=>"\u30B5\u30F3\u30C1\u30FC\u30E0",
    "\u3321"=>"\u30B7\u30EA\u30F3\u30B0",
    "\u3322"=>"\u30BB\u30F3\u30C1",
    "\u3323"=>"\u30BB\u30F3\u30C8",
    "\u3324"=>"\u30C0\u30FC\u30B9",
    "\u3325"=>"\u30C7\u30B7",
    "\u3326"=>"\u30C9\u30EB",
    "\u3327"=>"\u30C8\u30F3",
    "\u3328"=>"\u30CA\u30CE",
    "\u3329"=>"\u30CE\u30C3\u30C8",
    "\u332A"=>"\u30CF\u30A4\u30C4",
    "\u332B"=>"\u30D1\u30FC\u30BB\u30F3\u30C8",
    "\u332C"=>"\u30D1\u30FC\u30C4",
    "\u332D"=>"\u30D0\u30FC\u30EC\u30EB",
    "\u332E"=>"\u30D4\u30A2\u30B9\u30C8\u30EB",
    "\u332F"=>"\u30D4\u30AF\u30EB",
    "\u3330"=>"\u30D4\u30B3",
    "\u3331"=>"\u30D3\u30EB",
    "\u3332"=>"\u30D5\u30A1\u30E9\u30C3\u30C9",
    "\u3333"=>"\u30D5\u30A3\u30FC\u30C8",
    "\u3334"=>"\u30D6\u30C3\u30B7\u30A7\u30EB",
    "\u3335"=>"\u30D5\u30E9\u30F3",
    "\u3336"=>"\u30D8\u30AF\u30BF\u30FC\u30EB",
    "\u3337"=>"\u30DA\u30BD",
    "\u3338"=>"\u30DA\u30CB\u30D2",
    "\u3339"=>"\u30D8\u30EB\u30C4",
    "\u333A"=>"\u30DA\u30F3\u30B9",
    "\u333B"=>"\u30DA\u30FC\u30B8",
    "\u333C"=>"\u30D9\u30FC\u30BF",
    "\u333D"=>"\u30DD\u30A4\u30F3\u30C8",
    "\u333E"=>"\u30DC\u30EB\u30C8",
    "\u333F"=>"\u30DB\u30F3",
    "\u3340"=>"\u30DD\u30F3\u30C9",
    "\u3341"=>"\u30DB\u30FC\u30EB",
    "\u3342"=>"\u30DB\u30FC\u30F3",
    "\u3343"=>"\u30DE\u30A4\u30AF\u30ED",
    "\u3344"=>"\u30DE\u30A4\u30EB",
    "\u3345"=>"\u30DE\u30C3\u30CF",
    "\u3346"=>"\u30DE\u30EB\u30AF",
    "\u3347"=>"\u30DE\u30F3\u30B7\u30E7\u30F3",
    "\u3348"=>"\u30DF\u30AF\u30ED\u30F3",
    "\u3349"=>"\u30DF\u30EA",
    "\u334A"=>"\u30DF\u30EA\u30D0\u30FC\u30EB",
    "\u334B"=>"\u30E1\u30AC",
    "\u334C"=>"\u30E1\u30AC\u30C8\u30F3",
    "\u334D"=>"\u30E1\u30FC\u30C8\u30EB",
    "\u334E"=>"\u30E4\u30FC\u30C9",
    "\u334F"=>"\u30E4\u30FC\u30EB",
    "\u3350"=>"\u30E6\u30A2\u30F3",
    "\u3351"=>"\u30EA\u30C3\u30C8\u30EB",
    "\u3352"=>"\u30EA\u30E9",
    "\u3353"=>"\u30EB\u30D4\u30FC",
    "\u3354"=>"\u30EB\u30FC\u30D6\u30EB",
    "\u3355"=>"\u30EC\u30E0",
    "\u3356"=>"\u30EC\u30F3\u30C8\u30B2\u30F3",
    "\u3357"=>"\u30EF\u30C3\u30C8",
    "\u3358"=>"0\u70B9",
    "\u3359"=>"1\u70B9",
    "\u335A"=>"2\u70B9",
    "\u335B"=>"3\u70B9",
    "\u335C"=>"4\u70B9",
    "\u335D"=>"5\u70B9",
    "\u335E"=>"6\u70B9",
    "\u335F"=>"7\u70B9",
    "\u3360"=>"8\u70B9",
    "\u3361"=>"9\u70B9",
    "\u3362"=>"10\u70B9",
    "\u3363"=>"11\u70B9",
    "\u3364"=>"12\u70B9",
    "\u3365"=>"13\u70B9",
    "\u3366"=>"14\u70B9",
    "\u3367"=>"15\u70B9",
    "\u3368"=>"16\u70B9",
    "\u3369"=>"17\u70B9",
    "\u336A"=>"18\u70B9",
    "\u336B"=>"19\u70B9",
    "\u336C"=>"20\u70B9",
    "\u336D"=>"21\u70B9",
    "\u336E"=>"22\u70B9",
    "\u336F"=>"23\u70B9",
    "\u3370"=>"24\u70B9",
    "\u3371"=>"hPa",
    "\u3372"=>"da",
    "\u3373"=>"AU",
    "\u3374"=>"bar",
    "\u3375"=>"oV",
    "\u3376"=>"pc",
    "\u3377"=>"dm",
    "\u3378"=>"dm2",
    "\u3379"=>"dm3",
    "\u337A"=>"IU",
    "\u337B"=>"\u5E73\u6210",
    "\u337C"=>"\u662D\u548C",
    "\u337D"=>"\u5927\u6B63",
    "\u337E"=>"\u660E\u6CBB",
    "\u337F"=>"\u682A\u5F0F\u4F1A\u793E",
    "\u3380"=>"pA",
    "\u3381"=>"nA",
    "\u3382"=>"\u03BCA",
    "\u3383"=>"mA",
    "\u3384"=>"kA",
    "\u3385"=>"KB",
    "\u3386"=>"MB",
    "\u3387"=>"GB",
    "\u3388"=>"cal",
    "\u3389"=>"kcal",
    "\u338A"=>"pF",
    "\u338B"=>"nF",
    "\u338C"=>"\u03BCF",
    "\u338D"=>"\u03BCg",
    "\u338E"=>"mg",
    "\u338F"=>"kg",
    "\u3390"=>"Hz",
    "\u3391"=>"kHz",
    "\u3392"=>"MHz",
    "\u3393"=>"GHz",
    "\u3394"=>"THz",
    "\u3395"=>"\u03BCl",
    "\u3396"=>"ml",
    "\u3397"=>"dl",
    "\u3398"=>"kl",
    "\u3399"=>"fm",
    "\u339A"=>"nm",
    "\u339B"=>"\u03BCm",
    "\u339C"=>"mm",
    "\u339D"=>"cm",
    "\u339E"=>"km",
    "\u339F"=>"mm2",
    "\u33A0"=>"cm2",
    "\u33A1"=>"m2",
    "\u33A2"=>"km2",
    "\u33A3"=>"mm3",
    "\u33A4"=>"cm3",
    "\u33A5"=>"m3",
    "\u33A6"=>"km3",
    "\u33A7"=>"m\u2215s",
    "\u33A8"=>"m\u2215s2",
    "\u33A9"=>"Pa",
    "\u33AA"=>"kPa",
    "\u33AB"=>"MPa",
    "\u33AC"=>"GPa",
    "\u33AD"=>"rad",
    "\u33AE"=>"rad\u2215s",
    "\u33AF"=>"rad\u2215s2",
    "\u33B0"=>"ps",
    "\u33B1"=>"ns",
    "\u33B2"=>"\u03BCs",
    "\u33B3"=>"ms",
    "\u33B4"=>"pV",
    "\u33B5"=>"nV",
    "\u33B6"=>"\u03BCV",
    "\u33B7"=>"mV",
    "\u33B8"=>"kV",
    "\u33B9"=>"MV",
    "\u33BA"=>"pW",
    "\u33BB"=>"nW",
    "\u33BC"=>"\u03BCW",
    "\u33BD"=>"mW",
    "\u33BE"=>"kW",
    "\u33BF"=>"MW",
    "\u33C0"=>"k\u03A9",
    "\u33C1"=>"M\u03A9",
    "\u33C2"=>"a.m.",
    "\u33C3"=>"Bq",
    "\u33C4"=>"cc",
    "\u33C5"=>"cd",
    "\u33C6"=>"C\u2215kg",
    "\u33C7"=>"Co.",
    "\u33C8"=>"dB",
    "\u33C9"=>"Gy",
    "\u33CA"=>"ha",
    "\u33CB"=>"HP",
    "\u33CC"=>"in",
    "\u33CD"=>"KK",
    "\u33CE"=>"KM",
    "\u33CF"=>"kt",
    "\u33D0"=>"lm",
    "\u33D1"=>"ln",
    "\u33D2"=>"log",
    "\u33D3"=>"lx",
    "\u33D4"=>"mb",
    "\u33D5"=>"mil",
    "\u33D6"=>"mol",
    "\u33D7"=>"PH",
    "\u33D8"=>"p.m.",
    "\u33D9"=>"PPM",
    "\u33DA"=>"PR",
    "\u33DB"=>"sr",
    "\u33DC"=>"Sv",
    "\u33DD"=>"Wb",
    "\u33DE"=>"V\u2215m",
    "\u33DF"=>"A\u2215m",
    "\u33E0"=>"1\u65E5",
    "\u33E1"=>"2\u65E5",
    "\u33E2"=>"3\u65E5",
    "\u33E3"=>"4\u65E5",
    "\u33E4"=>"5\u65E5",
    "\u33E5"=>"6\u65E5",
    "\u33E6"=>"7\u65E5",
    "\u33E7"=>"8\u65E5",
    "\u33E8"=>"9\u65E5",
    "\u33E9"=>"10\u65E5",
    "\u33EA"=>"11\u65E5",
    "\u33EB"=>"12\u65E5",
    "\u33EC"=>"13\u65E5",
    "\u33ED"=>"14\u65E5",
    "\u33EE"=>"15\u65E5",
    "\u33EF"=>"16\u65E5",
    "\u33F0"=>"17\u65E5",
    "\u33F1"=>"18\u65E5",
    "\u33F2"=>"19\u65E5",
    "\u33F3"=>"20\u65E5",
    "\u33F4"=>"21\u65E5",
    "\u33F5"=>"22\u65E5",
    "\u33F6"=>"23\u65E5",
    "\u33F7"=>"24\u65E5",
    "\u33F8"=>"25\u65E5",
    "\u33F9"=>"26\u65E5",
    "\u33FA"=>"27\u65E5",
    "\u33FB"=>"28\u65E5",
    "\u33FC"=>"29\u65E5",
    "\u33FD"=>"30\u65E5",
    "\u33FE"=>"31\u65E5",
    "\u33FF"=>"gal",
    "\uA69C"=>"\u044A",
    "\uA69D"=>"\u044C",
    "\uA770"=>"\uA76F",
    "\uA7F8"=>"\u0126",
    "\uA7F9"=>"\u0153",
    "\uAB5C"=>"\uA727",
    "\uAB5D"=>"\uAB37",
    "\uAB5E"=>"\u026B",
    "\uAB5F"=>"\uAB52",
    "\uFB00"=>"ff",
    "\uFB01"=>"fi",
    "\uFB02"=>"fl",
    "\uFB03"=>"ffi",
    "\uFB04"=>"ffl",
    "\uFB05"=>"st",
    "\uFB06"=>"st",
    "\uFB13"=>"\u0574\u0576",
    "\uFB14"=>"\u0574\u0565",
    "\uFB15"=>"\u0574\u056B",
    "\uFB16"=>"\u057E\u0576",
    "\uFB17"=>"\u0574\u056D",
    "\uFB20"=>"\u05E2",
    "\uFB21"=>"\u05D0",
    "\uFB22"=>"\u05D3",
    "\uFB23"=>"\u05D4",
    "\uFB24"=>"\u05DB",
    "\uFB25"=>"\u05DC",
    "\uFB26"=>"\u05DD",
    "\uFB27"=>"\u05E8",
    "\uFB28"=>"\u05EA",
    "\uFB29"=>"+",
    "\uFB4F"=>"\u05D0\u05DC",
    "\uFB50"=>"\u0671",
    "\uFB51"=>"\u0671",
    "\uFB52"=>"\u067B",
    "\uFB53"=>"\u067B",
    "\uFB54"=>"\u067B",
    "\uFB55"=>"\u067B",
    "\uFB56"=>"\u067E",
    "\uFB57"=>"\u067E",
    "\uFB58"=>"\u067E",
    "\uFB59"=>"\u067E",
    "\uFB5A"=>"\u0680",
    "\uFB5B"=>"\u0680",
    "\uFB5C"=>"\u0680",
    "\uFB5D"=>"\u0680",
    "\uFB5E"=>"\u067A",
    "\uFB5F"=>"\u067A",
    "\uFB60"=>"\u067A",
    "\uFB61"=>"\u067A",
    "\uFB62"=>"\u067F",
    "\uFB63"=>"\u067F",
    "\uFB64"=>"\u067F",
    "\uFB65"=>"\u067F",
    "\uFB66"=>"\u0679",
    "\uFB67"=>"\u0679",
    "\uFB68"=>"\u0679",
    "\uFB69"=>"\u0679",
    "\uFB6A"=>"\u06A4",
    "\uFB6B"=>"\u06A4",
    "\uFB6C"=>"\u06A4",
    "\uFB6D"=>"\u06A4",
    "\uFB6E"=>"\u06A6",
    "\uFB6F"=>"\u06A6",
    "\uFB70"=>"\u06A6",
    "\uFB71"=>"\u06A6",
    "\uFB72"=>"\u0684",
    "\uFB73"=>"\u0684",
    "\uFB74"=>"\u0684",
    "\uFB75"=>"\u0684",
    "\uFB76"=>"\u0683",
    "\uFB77"=>"\u0683",
    "\uFB78"=>"\u0683",
    "\uFB79"=>"\u0683",
    "\uFB7A"=>"\u0686",
    "\uFB7B"=>"\u0686",
    "\uFB7C"=>"\u0686",
    "\uFB7D"=>"\u0686",
    "\uFB7E"=>"\u0687",
    "\uFB7F"=>"\u0687",
    "\uFB80"=>"\u0687",
    "\uFB81"=>"\u0687",
    "\uFB82"=>"\u068D",
    "\uFB83"=>"\u068D",
    "\uFB84"=>"\u068C",
    "\uFB85"=>"\u068C",
    "\uFB86"=>"\u068E",
    "\uFB87"=>"\u068E",
    "\uFB88"=>"\u0688",
    "\uFB89"=>"\u0688",
    "\uFB8A"=>"\u0698",
    "\uFB8B"=>"\u0698",
    "\uFB8C"=>"\u0691",
    "\uFB8D"=>"\u0691",
    "\uFB8E"=>"\u06A9",
    "\uFB8F"=>"\u06A9",
    "\uFB90"=>"\u06A9",
    "\uFB91"=>"\u06A9",
    "\uFB92"=>"\u06AF",
    "\uFB93"=>"\u06AF",
    "\uFB94"=>"\u06AF",
    "\uFB95"=>"\u06AF",
    "\uFB96"=>"\u06B3",
    "\uFB97"=>"\u06B3",
    "\uFB98"=>"\u06B3",
    "\uFB99"=>"\u06B3",
    "\uFB9A"=>"\u06B1",
    "\uFB9B"=>"\u06B1",
    "\uFB9C"=>"\u06B1",
    "\uFB9D"=>"\u06B1",
    "\uFB9E"=>"\u06BA",
    "\uFB9F"=>"\u06BA",
    "\uFBA0"=>"\u06BB",
    "\uFBA1"=>"\u06BB",
    "\uFBA2"=>"\u06BB",
    "\uFBA3"=>"\u06BB",
    "\uFBA4"=>"\u06C0",
    "\uFBA5"=>"\u06C0",
    "\uFBA6"=>"\u06C1",
    "\uFBA7"=>"\u06C1",
    "\uFBA8"=>"\u06C1",
    "\uFBA9"=>"\u06C1",
    "\uFBAA"=>"\u06BE",
    "\uFBAB"=>"\u06BE",
    "\uFBAC"=>"\u06BE",
    "\uFBAD"=>"\u06BE",
    "\uFBAE"=>"\u06D2",
    "\uFBAF"=>"\u06D2",
    "\uFBB0"=>"\u06D3",
    "\uFBB1"=>"\u06D3",
    "\uFBD3"=>"\u06AD",
    "\uFBD4"=>"\u06AD",
    "\uFBD5"=>"\u06AD",
    "\uFBD6"=>"\u06AD",
    "\uFBD7"=>"\u06C7",
    "\uFBD8"=>"\u06C7",
    "\uFBD9"=>"\u06C6",
    "\uFBDA"=>"\u06C6",
    "\uFBDB"=>"\u06C8",
    "\uFBDC"=>"\u06C8",
    "\uFBDD"=>"\u06C7\u0674",
    "\uFBDE"=>"\u06CB",
    "\uFBDF"=>"\u06CB",
    "\uFBE0"=>"\u06C5",
    "\uFBE1"=>"\u06C5",
    "\uFBE2"=>"\u06C9",
    "\uFBE3"=>"\u06C9",
    "\uFBE4"=>"\u06D0",
    "\uFBE5"=>"\u06D0",
    "\uFBE6"=>"\u06D0",
    "\uFBE7"=>"\u06D0",
    "\uFBE8"=>"\u0649",
    "\uFBE9"=>"\u0649",
    "\uFBEA"=>"\u0626\u0627",
    "\uFBEB"=>"\u0626\u0627",
    "\uFBEC"=>"\u0626\u06D5",
    "\uFBED"=>"\u0626\u06D5",
    "\uFBEE"=>"\u0626\u0648",
    "\uFBEF"=>"\u0626\u0648",
    "\uFBF0"=>"\u0626\u06C7",
    "\uFBF1"=>"\u0626\u06C7",
    "\uFBF2"=>"\u0626\u06C6",
    "\uFBF3"=>"\u0626\u06C6",
    "\uFBF4"=>"\u0626\u06C8",
    "\uFBF5"=>"\u0626\u06C8",
    "\uFBF6"=>"\u0626\u06D0",
    "\uFBF7"=>"\u0626\u06D0",
    "\uFBF8"=>"\u0626\u06D0",
    "\uFBF9"=>"\u0626\u0649",
    "\uFBFA"=>"\u0626\u0649",
    "\uFBFB"=>"\u0626\u0649",
    "\uFBFC"=>"\u06CC",
    "\uFBFD"=>"\u06CC",
    "\uFBFE"=>"\u06CC",
    "\uFBFF"=>"\u06CC",
    "\uFC00"=>"\u0626\u062C",
    "\uFC01"=>"\u0626\u062D",
    "\uFC02"=>"\u0626\u0645",
    "\uFC03"=>"\u0626\u0649",
    "\uFC04"=>"\u0626\u064A",
    "\uFC05"=>"\u0628\u062C",
    "\uFC06"=>"\u0628\u062D",
    "\uFC07"=>"\u0628\u062E",
    "\uFC08"=>"\u0628\u0645",
    "\uFC09"=>"\u0628\u0649",
    "\uFC0A"=>"\u0628\u064A",
    "\uFC0B"=>"\u062A\u062C",
    "\uFC0C"=>"\u062A\u062D",
    "\uFC0D"=>"\u062A\u062E",
    "\uFC0E"=>"\u062A\u0645",
    "\uFC0F"=>"\u062A\u0649",
    "\uFC10"=>"\u062A\u064A",
    "\uFC11"=>"\u062B\u062C",
    "\uFC12"=>"\u062B\u0645",
    "\uFC13"=>"\u062B\u0649",
    "\uFC14"=>"\u062B\u064A",
    "\uFC15"=>"\u062C\u062D",
    "\uFC16"=>"\u062C\u0645",
    "\uFC17"=>"\u062D\u062C",
    "\uFC18"=>"\u062D\u0645",
    "\uFC19"=>"\u062E\u062C",
    "\uFC1A"=>"\u062E\u062D",
    "\uFC1B"=>"\u062E\u0645",
    "\uFC1C"=>"\u0633\u062C",
    "\uFC1D"=>"\u0633\u062D",
    "\uFC1E"=>"\u0633\u062E",
    "\uFC1F"=>"\u0633\u0645",
    "\uFC20"=>"\u0635\u062D",
    "\uFC21"=>"\u0635\u0645",
    "\uFC22"=>"\u0636\u062C",
    "\uFC23"=>"\u0636\u062D",
    "\uFC24"=>"\u0636\u062E",
    "\uFC25"=>"\u0636\u0645",
    "\uFC26"=>"\u0637\u062D",
    "\uFC27"=>"\u0637\u0645",
    "\uFC28"=>"\u0638\u0645",
    "\uFC29"=>"\u0639\u062C",
    "\uFC2A"=>"\u0639\u0645",
    "\uFC2B"=>"\u063A\u062C",
    "\uFC2C"=>"\u063A\u0645",
    "\uFC2D"=>"\u0641\u062C",
    "\uFC2E"=>"\u0641\u062D",
    "\uFC2F"=>"\u0641\u062E",
    "\uFC30"=>"\u0641\u0645",
    "\uFC31"=>"\u0641\u0649",
    "\uFC32"=>"\u0641\u064A",
    "\uFC33"=>"\u0642\u062D",
    "\uFC34"=>"\u0642\u0645",
    "\uFC35"=>"\u0642\u0649",
    "\uFC36"=>"\u0642\u064A",
    "\uFC37"=>"\u0643\u0627",
    "\uFC38"=>"\u0643\u062C",
    "\uFC39"=>"\u0643\u062D",
    "\uFC3A"=>"\u0643\u062E",
    "\uFC3B"=>"\u0643\u0644",
    "\uFC3C"=>"\u0643\u0645",
    "\uFC3D"=>"\u0643\u0649",
    "\uFC3E"=>"\u0643\u064A",
    "\uFC3F"=>"\u0644\u062C",
    "\uFC40"=>"\u0644\u062D",
    "\uFC41"=>"\u0644\u062E",
    "\uFC42"=>"\u0644\u0645",
    "\uFC43"=>"\u0644\u0649",
    "\uFC44"=>"\u0644\u064A",
    "\uFC45"=>"\u0645\u062C",
    "\uFC46"=>"\u0645\u062D",
    "\uFC47"=>"\u0645\u062E",
    "\uFC48"=>"\u0645\u0645",
    "\uFC49"=>"\u0645\u0649",
    "\uFC4A"=>"\u0645\u064A",
    "\uFC4B"=>"\u0646\u062C",
    "\uFC4C"=>"\u0646\u062D",
    "\uFC4D"=>"\u0646\u062E",
    "\uFC4E"=>"\u0646\u0645",
    "\uFC4F"=>"\u0646\u0649",
    "\uFC50"=>"\u0646\u064A",
    "\uFC51"=>"\u0647\u062C",
    "\uFC52"=>"\u0647\u0645",
    "\uFC53"=>"\u0647\u0649",
    "\uFC54"=>"\u0647\u064A",
    "\uFC55"=>"\u064A\u062C",
    "\uFC56"=>"\u064A\u062D",
    "\uFC57"=>"\u064A\u062E",
    "\uFC58"=>"\u064A\u0645",
    "\uFC59"=>"\u064A\u0649",
    "\uFC5A"=>"\u064A\u064A",
    "\uFC5B"=>"\u0630\u0670",
    "\uFC5C"=>"\u0631\u0670",
    "\uFC5D"=>"\u0649\u0670",
    "\uFC5E"=>" \u064C\u0651",
    "\uFC5F"=>" \u064D\u0651",
    "\uFC60"=>" \u064E\u0651",
    "\uFC61"=>" \u064F\u0651",
    "\uFC62"=>" \u0650\u0651",
    "\uFC63"=>" \u0651\u0670",
    "\uFC64"=>"\u0626\u0631",
    "\uFC65"=>"\u0626\u0632",
    "\uFC66"=>"\u0626\u0645",
    "\uFC67"=>"\u0626\u0646",
    "\uFC68"=>"\u0626\u0649",
    "\uFC69"=>"\u0626\u064A",
    "\uFC6A"=>"\u0628\u0631",
    "\uFC6B"=>"\u0628\u0632",
    "\uFC6C"=>"\u0628\u0645",
    "\uFC6D"=>"\u0628\u0646",
    "\uFC6E"=>"\u0628\u0649",
    "\uFC6F"=>"\u0628\u064A",
    "\uFC70"=>"\u062A\u0631",
    "\uFC71"=>"\u062A\u0632",
    "\uFC72"=>"\u062A\u0645",
    "\uFC73"=>"\u062A\u0646",
    "\uFC74"=>"\u062A\u0649",
    "\uFC75"=>"\u062A\u064A",
    "\uFC76"=>"\u062B\u0631",
    "\uFC77"=>"\u062B\u0632",
    "\uFC78"=>"\u062B\u0645",
    "\uFC79"=>"\u062B\u0646",
    "\uFC7A"=>"\u062B\u0649",
    "\uFC7B"=>"\u062B\u064A",
    "\uFC7C"=>"\u0641\u0649",
    "\uFC7D"=>"\u0641\u064A",
    "\uFC7E"=>"\u0642\u0649",
    "\uFC7F"=>"\u0642\u064A",
    "\uFC80"=>"\u0643\u0627",
    "\uFC81"=>"\u0643\u0644",
    "\uFC82"=>"\u0643\u0645",
    "\uFC83"=>"\u0643\u0649",
    "\uFC84"=>"\u0643\u064A",
    "\uFC85"=>"\u0644\u0645",
    "\uFC86"=>"\u0644\u0649",
    "\uFC87"=>"\u0644\u064A",
    "\uFC88"=>"\u0645\u0627",
    "\uFC89"=>"\u0645\u0645",
    "\uFC8A"=>"\u0646\u0631",
    "\uFC8B"=>"\u0646\u0632",
    "\uFC8C"=>"\u0646\u0645",
    "\uFC8D"=>"\u0646\u0646",
    "\uFC8E"=>"\u0646\u0649",
    "\uFC8F"=>"\u0646\u064A",
    "\uFC90"=>"\u0649\u0670",
    "\uFC91"=>"\u064A\u0631",
    "\uFC92"=>"\u064A\u0632",
    "\uFC93"=>"\u064A\u0645",
    "\uFC94"=>"\u064A\u0646",
    "\uFC95"=>"\u064A\u0649",
    "\uFC96"=>"\u064A\u064A",
    "\uFC97"=>"\u0626\u062C",
    "\uFC98"=>"\u0626\u062D",
    "\uFC99"=>"\u0626\u062E",
    "\uFC9A"=>"\u0626\u0645",
    "\uFC9B"=>"\u0626\u0647",
    "\uFC9C"=>"\u0628\u062C",
    "\uFC9D"=>"\u0628\u062D",
    "\uFC9E"=>"\u0628\u062E",
    "\uFC9F"=>"\u0628\u0645",
    "\uFCA0"=>"\u0628\u0647",
    "\uFCA1"=>"\u062A\u062C",
    "\uFCA2"=>"\u062A\u062D",
    "\uFCA3"=>"\u062A\u062E",
    "\uFCA4"=>"\u062A\u0645",
    "\uFCA5"=>"\u062A\u0647",
    "\uFCA6"=>"\u062B\u0645",
    "\uFCA7"=>"\u062C\u062D",
    "\uFCA8"=>"\u062C\u0645",
    "\uFCA9"=>"\u062D\u062C",
    "\uFCAA"=>"\u062D\u0645",
    "\uFCAB"=>"\u062E\u062C",
    "\uFCAC"=>"\u062E\u0645",
    "\uFCAD"=>"\u0633\u062C",
    "\uFCAE"=>"\u0633\u062D",
    "\uFCAF"=>"\u0633\u062E",
    "\uFCB0"=>"\u0633\u0645",
    "\uFCB1"=>"\u0635\u062D",
    "\uFCB2"=>"\u0635\u062E",
    "\uFCB3"=>"\u0635\u0645",
    "\uFCB4"=>"\u0636\u062C",
    "\uFCB5"=>"\u0636\u062D",
    "\uFCB6"=>"\u0636\u062E",
    "\uFCB7"=>"\u0636\u0645",
    "\uFCB8"=>"\u0637\u062D",
    "\uFCB9"=>"\u0638\u0645",
    "\uFCBA"=>"\u0639\u062C",
    "\uFCBB"=>"\u0639\u0645",
    "\uFCBC"=>"\u063A\u062C",
    "\uFCBD"=>"\u063A\u0645",
    "\uFCBE"=>"\u0641\u062C",
    "\uFCBF"=>"\u0641\u062D",
    "\uFCC0"=>"\u0641\u062E",
    "\uFCC1"=>"\u0641\u0645",
    "\uFCC2"=>"\u0642\u062D",
    "\uFCC3"=>"\u0642\u0645",
    "\uFCC4"=>"\u0643\u062C",
    "\uFCC5"=>"\u0643\u062D",
    "\uFCC6"=>"\u0643\u062E",
    "\uFCC7"=>"\u0643\u0644",
    "\uFCC8"=>"\u0643\u0645",
    "\uFCC9"=>"\u0644\u062C",
    "\uFCCA"=>"\u0644\u062D",
    "\uFCCB"=>"\u0644\u062E",
    "\uFCCC"=>"\u0644\u0645",
    "\uFCCD"=>"\u0644\u0647",
    "\uFCCE"=>"\u0645\u062C",
    "\uFCCF"=>"\u0645\u062D",
    "\uFCD0"=>"\u0645\u062E",
    "\uFCD1"=>"\u0645\u0645",
    "\uFCD2"=>"\u0646\u062C",
    "\uFCD3"=>"\u0646\u062D",
    "\uFCD4"=>"\u0646\u062E",
    "\uFCD5"=>"\u0646\u0645",
    "\uFCD6"=>"\u0646\u0647",
    "\uFCD7"=>"\u0647\u062C",
    "\uFCD8"=>"\u0647\u0645",
    "\uFCD9"=>"\u0647\u0670",
    "\uFCDA"=>"\u064A\u062C",
    "\uFCDB"=>"\u064A\u062D",
    "\uFCDC"=>"\u064A\u062E",
    "\uFCDD"=>"\u064A\u0645",
    "\uFCDE"=>"\u064A\u0647",
    "\uFCDF"=>"\u0626\u0645",
    "\uFCE0"=>"\u0626\u0647",
    "\uFCE1"=>"\u0628\u0645",
    "\uFCE2"=>"\u0628\u0647",
    "\uFCE3"=>"\u062A\u0645",
    "\uFCE4"=>"\u062A\u0647",
    "\uFCE5"=>"\u062B\u0645",
    "\uFCE6"=>"\u062B\u0647",
    "\uFCE7"=>"\u0633\u0645",
    "\uFCE8"=>"\u0633\u0647",
    "\uFCE9"=>"\u0634\u0645",
    "\uFCEA"=>"\u0634\u0647",
    "\uFCEB"=>"\u0643\u0644",
    "\uFCEC"=>"\u0643\u0645",
    "\uFCED"=>"\u0644\u0645",
    "\uFCEE"=>"\u0646\u0645",
    "\uFCEF"=>"\u0646\u0647",
    "\uFCF0"=>"\u064A\u0645",
    "\uFCF1"=>"\u064A\u0647",
    "\uFCF2"=>"\u0640\u064E\u0651",
    "\uFCF3"=>"\u0640\u064F\u0651",
    "\uFCF4"=>"\u0640\u0650\u0651",
    "\uFCF5"=>"\u0637\u0649",
    "\uFCF6"=>"\u0637\u064A",
    "\uFCF7"=>"\u0639\u0649",
    "\uFCF8"=>"\u0639\u064A",
    "\uFCF9"=>"\u063A\u0649",
    "\uFCFA"=>"\u063A\u064A",
    "\uFCFB"=>"\u0633\u0649",
    "\uFCFC"=>"\u0633\u064A",
    "\uFCFD"=>"\u0634\u0649",
    "\uFCFE"=>"\u0634\u064A",
    "\uFCFF"=>"\u062D\u0649",
    "\uFD00"=>"\u062D\u064A",
    "\uFD01"=>"\u062C\u0649",
    "\uFD02"=>"\u062C\u064A",
    "\uFD03"=>"\u062E\u0649",
    "\uFD04"=>"\u062E\u064A",
    "\uFD05"=>"\u0635\u0649",
    "\uFD06"=>"\u0635\u064A",
    "\uFD07"=>"\u0636\u0649",
    "\uFD08"=>"\u0636\u064A",
    "\uFD09"=>"\u0634\u062C",
    "\uFD0A"=>"\u0634\u062D",
    "\uFD0B"=>"\u0634\u062E",
    "\uFD0C"=>"\u0634\u0645",
    "\uFD0D"=>"\u0634\u0631",
    "\uFD0E"=>"\u0633\u0631",
    "\uFD0F"=>"\u0635\u0631",
    "\uFD10"=>"\u0636\u0631",
    "\uFD11"=>"\u0637\u0649",
    "\uFD12"=>"\u0637\u064A",
    "\uFD13"=>"\u0639\u0649",
    "\uFD14"=>"\u0639\u064A",
    "\uFD15"=>"\u063A\u0649",
    "\uFD16"=>"\u063A\u064A",
    "\uFD17"=>"\u0633\u0649",
    "\uFD18"=>"\u0633\u064A",
    "\uFD19"=>"\u0634\u0649",
    "\uFD1A"=>"\u0634\u064A",
    "\uFD1B"=>"\u062D\u0649",
    "\uFD1C"=>"\u062D\u064A",
    "\uFD1D"=>"\u062C\u0649",
    "\uFD1E"=>"\u062C\u064A",
    "\uFD1F"=>"\u062E\u0649",
    "\uFD20"=>"\u062E\u064A",
    "\uFD21"=>"\u0635\u0649",
    "\uFD22"=>"\u0635\u064A",
    "\uFD23"=>"\u0636\u0649",
    "\uFD24"=>"\u0636\u064A",
    "\uFD25"=>"\u0634\u062C",
    "\uFD26"=>"\u0634\u062D",
    "\uFD27"=>"\u0634\u062E",
    "\uFD28"=>"\u0634\u0645",
    "\uFD29"=>"\u0634\u0631",
    "\uFD2A"=>"\u0633\u0631",
    "\uFD2B"=>"\u0635\u0631",
    "\uFD2C"=>"\u0636\u0631",
    "\uFD2D"=>"\u0634\u062C",
    "\uFD2E"=>"\u0634\u062D",
    "\uFD2F"=>"\u0634\u062E",
    "\uFD30"=>"\u0634\u0645",
    "\uFD31"=>"\u0633\u0647",
    "\uFD32"=>"\u0634\u0647",
    "\uFD33"=>"\u0637\u0645",
    "\uFD34"=>"\u0633\u062C",
    "\uFD35"=>"\u0633\u062D",
    "\uFD36"=>"\u0633\u062E",
    "\uFD37"=>"\u0634\u062C",
    "\uFD38"=>"\u0634\u062D",
    "\uFD39"=>"\u0634\u062E",
    "\uFD3A"=>"\u0637\u0645",
    "\uFD3B"=>"\u0638\u0645",
    "\uFD3C"=>"\u0627\u064B",
    "\uFD3D"=>"\u0627\u064B",
    "\uFD50"=>"\u062A\u062C\u0645",
    "\uFD51"=>"\u062A\u062D\u062C",
    "\uFD52"=>"\u062A\u062D\u062C",
    "\uFD53"=>"\u062A\u062D\u0645",
    "\uFD54"=>"\u062A\u062E\u0645",
    "\uFD55"=>"\u062A\u0645\u062C",
    "\uFD56"=>"\u062A\u0645\u062D",
    "\uFD57"=>"\u062A\u0645\u062E",
    "\uFD58"=>"\u062C\u0645\u062D",
    "\uFD59"=>"\u062C\u0645\u062D",
    "\uFD5A"=>"\u062D\u0645\u064A",
    "\uFD5B"=>"\u062D\u0645\u0649",
    "\uFD5C"=>"\u0633\u062D\u062C",
    "\uFD5D"=>"\u0633\u062C\u062D",
    "\uFD5E"=>"\u0633\u062C\u0649",
    "\uFD5F"=>"\u0633\u0645\u062D",
    "\uFD60"=>"\u0633\u0645\u062D",
    "\uFD61"=>"\u0633\u0645\u062C",
    "\uFD62"=>"\u0633\u0645\u0645",
    "\uFD63"=>"\u0633\u0645\u0645",
    "\uFD64"=>"\u0635\u062D\u062D",
    "\uFD65"=>"\u0635\u062D\u062D",
    "\uFD66"=>"\u0635\u0645\u0645",
    "\uFD67"=>"\u0634\u062D\u0645",
    "\uFD68"=>"\u0634\u062D\u0645",
    "\uFD69"=>"\u0634\u062C\u064A",
    "\uFD6A"=>"\u0634\u0645\u062E",
    "\uFD6B"=>"\u0634\u0645\u062E",
    "\uFD6C"=>"\u0634\u0645\u0645",
    "\uFD6D"=>"\u0634\u0645\u0645",
    "\uFD6E"=>"\u0636\u062D\u0649",
    "\uFD6F"=>"\u0636\u062E\u0645",
    "\uFD70"=>"\u0636\u062E\u0645",
    "\uFD71"=>"\u0637\u0645\u062D",
    "\uFD72"=>"\u0637\u0645\u062D",
    "\uFD73"=>"\u0637\u0645\u0645",
    "\uFD74"=>"\u0637\u0645\u064A",
    "\uFD75"=>"\u0639\u062C\u0645",
    "\uFD76"=>"\u0639\u0645\u0645",
    "\uFD77"=>"\u0639\u0645\u0645",
    "\uFD78"=>"\u0639\u0645\u0649",
    "\uFD79"=>"\u063A\u0645\u0645",
    "\uFD7A"=>"\u063A\u0645\u064A",
    "\uFD7B"=>"\u063A\u0645\u0649",
    "\uFD7C"=>"\u0641\u062E\u0645",
    "\uFD7D"=>"\u0641\u062E\u0645",
    "\uFD7E"=>"\u0642\u0645\u062D",
    "\uFD7F"=>"\u0642\u0645\u0645",
    "\uFD80"=>"\u0644\u062D\u0645",
    "\uFD81"=>"\u0644\u062D\u064A",
    "\uFD82"=>"\u0644\u062D\u0649",
    "\uFD83"=>"\u0644\u062C\u062C",
    "\uFD84"=>"\u0644\u062C\u062C",
    "\uFD85"=>"\u0644\u062E\u0645",
    "\uFD86"=>"\u0644\u062E\u0645",
    "\uFD87"=>"\u0644\u0645\u062D",
    "\uFD88"=>"\u0644\u0645\u062D",
    "\uFD89"=>"\u0645\u062D\u062C",
    "\uFD8A"=>"\u0645\u062D\u0645",
    "\uFD8B"=>"\u0645\u062D\u064A",
    "\uFD8C"=>"\u0645\u062C\u062D",
    "\uFD8D"=>"\u0645\u062C\u0645",
    "\uFD8E"=>"\u0645\u062E\u062C",
    "\uFD8F"=>"\u0645\u062E\u0645",
    "\uFD92"=>"\u0645\u062C\u062E",
    "\uFD93"=>"\u0647\u0645\u062C",
    "\uFD94"=>"\u0647\u0645\u0645",
    "\uFD95"=>"\u0646\u062D\u0645",
    "\uFD96"=>"\u0646\u062D\u0649",
    "\uFD97"=>"\u0646\u062C\u0645",
    "\uFD98"=>"\u0646\u062C\u0645",
    "\uFD99"=>"\u0646\u062C\u0649",
    "\uFD9A"=>"\u0646\u0645\u064A",
    "\uFD9B"=>"\u0646\u0645\u0649",
    "\uFD9C"=>"\u064A\u0645\u0645",
    "\uFD9D"=>"\u064A\u0645\u0645",
    "\uFD9E"=>"\u0628\u062E\u064A",
    "\uFD9F"=>"\u062A\u062C\u064A",
    "\uFDA0"=>"\u062A\u062C\u0649",
    "\uFDA1"=>"\u062A\u062E\u064A",
    "\uFDA2"=>"\u062A\u062E\u0649",
    "\uFDA3"=>"\u062A\u0645\u064A",
    "\uFDA4"=>"\u062A\u0645\u0649",
    "\uFDA5"=>"\u062C\u0645\u064A",
    "\uFDA6"=>"\u062C\u062D\u0649",
    "\uFDA7"=>"\u062C\u0645\u0649",
    "\uFDA8"=>"\u0633\u062E\u0649",
    "\uFDA9"=>"\u0635\u062D\u064A",
    "\uFDAA"=>"\u0634\u062D\u064A",
    "\uFDAB"=>"\u0636\u062D\u064A",
    "\uFDAC"=>"\u0644\u062C\u064A",
    "\uFDAD"=>"\u0644\u0645\u064A",
    "\uFDAE"=>"\u064A\u062D\u064A",
    "\uFDAF"=>"\u064A\u062C\u064A",
    "\uFDB0"=>"\u064A\u0645\u064A",
    "\uFDB1"=>"\u0645\u0645\u064A",
    "\uFDB2"=>"\u0642\u0645\u064A",
    "\uFDB3"=>"\u0646\u062D\u064A",
    "\uFDB4"=>"\u0642\u0645\u062D",
    "\uFDB5"=>"\u0644\u062D\u0645",
    "\uFDB6"=>"\u0639\u0645\u064A",
    "\uFDB7"=>"\u0643\u0645\u064A",
    "\uFDB8"=>"\u0646\u062C\u062D",
    "\uFDB9"=>"\u0645\u062E\u064A",
    "\uFDBA"=>"\u0644\u062C\u0645",
    "\uFDBB"=>"\u0643\u0645\u0645",
    "\uFDBC"=>"\u0644\u062C\u0645",
    "\uFDBD"=>"\u0646\u062C\u062D",
    "\uFDBE"=>"\u062C\u062D\u064A",
    "\uFDBF"=>"\u062D\u062C\u064A",
    "\uFDC0"=>"\u0645\u062C\u064A",
    "\uFDC1"=>"\u0641\u0645\u064A",
    "\uFDC2"=>"\u0628\u062D\u064A",
    "\uFDC3"=>"\u0643\u0645\u0645",
    "\uFDC4"=>"\u0639\u062C\u0645",
    "\uFDC5"=>"\u0635\u0645\u0645",
    "\uFDC6"=>"\u0633\u062E\u064A",
    "\uFDC7"=>"\u0646\u062C\u064A",
    "\uFDF0"=>"\u0635\u0644\u06D2",
    "\uFDF1"=>"\u0642\u0644\u06D2",
    "\uFDF2"=>"\u0627\u0644\u0644\u0647",
    "\uFDF3"=>"\u0627\u0643\u0628\u0631",
    "\uFDF4"=>"\u0645\u062D\u0645\u062F",
    "\uFDF5"=>"\u0635\u0644\u0639\u0645",
    "\uFDF6"=>"\u0631\u0633\u0648\u0644",
    "\uFDF7"=>"\u0639\u0644\u064A\u0647",
    "\uFDF8"=>"\u0648\u0633\u0644\u0645",
    "\uFDF9"=>"\u0635\u0644\u0649",
    "\uFDFA"=>"\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064A\u0647 \u0648\u0633\u0644\u0645",
    "\uFDFB"=>"\u062C\u0644 \u062C\u0644\u0627\u0644\u0647",
    "\uFDFC"=>"\u0631\u06CC\u0627\u0644",
    "\uFE10"=>",",
    "\uFE11"=>"\u3001",
    "\uFE12"=>"\u3002",
    "\uFE13"=>":",
    "\uFE14"=>";",
    "\uFE15"=>"!",
    "\uFE16"=>"?",
    "\uFE17"=>"\u3016",
    "\uFE18"=>"\u3017",
    "\uFE19"=>"...",
    "\uFE30"=>"..",
    "\uFE31"=>"\u2014",
    "\uFE32"=>"\u2013",
    "\uFE33"=>"_",
    "\uFE34"=>"_",
    "\uFE35"=>"(",
    "\uFE36"=>")",
    "\uFE37"=>"{",
    "\uFE38"=>"}",
    "\uFE39"=>"\u3014",
    "\uFE3A"=>"\u3015",
    "\uFE3B"=>"\u3010",
    "\uFE3C"=>"\u3011",
    "\uFE3D"=>"\u300A",
    "\uFE3E"=>"\u300B",
    "\uFE3F"=>"\u3008",
    "\uFE40"=>"\u3009",
    "\uFE41"=>"\u300C",
    "\uFE42"=>"\u300D",
    "\uFE43"=>"\u300E",
    "\uFE44"=>"\u300F",
    "\uFE47"=>"[",
    "\uFE48"=>"]",
    "\uFE49"=>" \u0305",
    "\uFE4A"=>" \u0305",
    "\uFE4B"=>" \u0305",
    "\uFE4C"=>" \u0305",
    "\uFE4D"=>"_",
    "\uFE4E"=>"_",
    "\uFE4F"=>"_",
    "\uFE50"=>",",
    "\uFE51"=>"\u3001",
    "\uFE52"=>".",
    "\uFE54"=>";",
    "\uFE55"=>":",
    "\uFE56"=>"?",
    "\uFE57"=>"!",
    "\uFE58"=>"\u2014",
    "\uFE59"=>"(",
    "\uFE5A"=>")",
    "\uFE5B"=>"{",
    "\uFE5C"=>"}",
    "\uFE5D"=>"\u3014",
    "\uFE5E"=>"\u3015",
    "\uFE5F"=>"#",
    "\uFE60"=>"&",
    "\uFE61"=>"*",
    "\uFE62"=>"+",
    "\uFE63"=>"-",
    "\uFE64"=>"<",
    "\uFE65"=>">",
    "\uFE66"=>"=",
    "\uFE68"=>"\\",
    "\uFE69"=>"$",
    "\uFE6A"=>"%",
    "\uFE6B"=>"@",
    "\uFE70"=>" \u064B",
    "\uFE71"=>"\u0640\u064B",
    "\uFE72"=>" \u064C",
    "\uFE74"=>" \u064D",
    "\uFE76"=>" \u064E",
    "\uFE77"=>"\u0640\u064E",
    "\uFE78"=>" \u064F",
    "\uFE79"=>"\u0640\u064F",
    "\uFE7A"=>" \u0650",
    "\uFE7B"=>"\u0640\u0650",
    "\uFE7C"=>" \u0651",
    "\uFE7D"=>"\u0640\u0651",
    "\uFE7E"=>" \u0652",
    "\uFE7F"=>"\u0640\u0652",
    "\uFE80"=>"\u0621",
    "\uFE81"=>"\u0622",
    "\uFE82"=>"\u0622",
    "\uFE83"=>"\u0623",
    "\uFE84"=>"\u0623",
    "\uFE85"=>"\u0624",
    "\uFE86"=>"\u0624",
    "\uFE87"=>"\u0625",
    "\uFE88"=>"\u0625",
    "\uFE89"=>"\u0626",
    "\uFE8A"=>"\u0626",
    "\uFE8B"=>"\u0626",
    "\uFE8C"=>"\u0626",
    "\uFE8D"=>"\u0627",
    "\uFE8E"=>"\u0627",
    "\uFE8F"=>"\u0628",
    "\uFE90"=>"\u0628",
    "\uFE91"=>"\u0628",
    "\uFE92"=>"\u0628",
    "\uFE93"=>"\u0629",
    "\uFE94"=>"\u0629",
    "\uFE95"=>"\u062A",
    "\uFE96"=>"\u062A",
    "\uFE97"=>"\u062A",
    "\uFE98"=>"\u062A",
    "\uFE99"=>"\u062B",
    "\uFE9A"=>"\u062B",
    "\uFE9B"=>"\u062B",
    "\uFE9C"=>"\u062B",
    "\uFE9D"=>"\u062C",
    "\uFE9E"=>"\u062C",
    "\uFE9F"=>"\u062C",
    "\uFEA0"=>"\u062C",
    "\uFEA1"=>"\u062D",
    "\uFEA2"=>"\u062D",
    "\uFEA3"=>"\u062D",
    "\uFEA4"=>"\u062D",
    "\uFEA5"=>"\u062E",
    "\uFEA6"=>"\u062E",
    "\uFEA7"=>"\u062E",
    "\uFEA8"=>"\u062E",
    "\uFEA9"=>"\u062F",
    "\uFEAA"=>"\u062F",
    "\uFEAB"=>"\u0630",
    "\uFEAC"=>"\u0630",
    "\uFEAD"=>"\u0631",
    "\uFEAE"=>"\u0631",
    "\uFEAF"=>"\u0632",
    "\uFEB0"=>"\u0632",
    "\uFEB1"=>"\u0633",
    "\uFEB2"=>"\u0633",
    "\uFEB3"=>"\u0633",
    "\uFEB4"=>"\u0633",
    "\uFEB5"=>"\u0634",
    "\uFEB6"=>"\u0634",
    "\uFEB7"=>"\u0634",
    "\uFEB8"=>"\u0634",
    "\uFEB9"=>"\u0635",
    "\uFEBA"=>"\u0635",
    "\uFEBB"=>"\u0635",
    "\uFEBC"=>"\u0635",
    "\uFEBD"=>"\u0636",
    "\uFEBE"=>"\u0636",
    "\uFEBF"=>"\u0636",
    "\uFEC0"=>"\u0636",
    "\uFEC1"=>"\u0637",
    "\uFEC2"=>"\u0637",
    "\uFEC3"=>"\u0637",
    "\uFEC4"=>"\u0637",
    "\uFEC5"=>"\u0638",
    "\uFEC6"=>"\u0638",
    "\uFEC7"=>"\u0638",
    "\uFEC8"=>"\u0638",
    "\uFEC9"=>"\u0639",
    "\uFECA"=>"\u0639",
    "\uFECB"=>"\u0639",
    "\uFECC"=>"\u0639",
    "\uFECD"=>"\u063A",
    "\uFECE"=>"\u063A",
    "\uFECF"=>"\u063A",
    "\uFED0"=>"\u063A",
    "\uFED1"=>"\u0641",
    "\uFED2"=>"\u0641",
    "\uFED3"=>"\u0641",
    "\uFED4"=>"\u0641",
    "\uFED5"=>"\u0642",
    "\uFED6"=>"\u0642",
    "\uFED7"=>"\u0642",
    "\uFED8"=>"\u0642",
    "\uFED9"=>"\u0643",
    "\uFEDA"=>"\u0643",
    "\uFEDB"=>"\u0643",
    "\uFEDC"=>"\u0643",
    "\uFEDD"=>"\u0644",
    "\uFEDE"=>"\u0644",
    "\uFEDF"=>"\u0644",
    "\uFEE0"=>"\u0644",
    "\uFEE1"=>"\u0645",
    "\uFEE2"=>"\u0645",
    "\uFEE3"=>"\u0645",
    "\uFEE4"=>"\u0645",
    "\uFEE5"=>"\u0646",
    "\uFEE6"=>"\u0646",
    "\uFEE7"=>"\u0646",
    "\uFEE8"=>"\u0646",
    "\uFEE9"=>"\u0647",
    "\uFEEA"=>"\u0647",
    "\uFEEB"=>"\u0647",
    "\uFEEC"=>"\u0647",
    "\uFEED"=>"\u0648",
    "\uFEEE"=>"\u0648",
    "\uFEEF"=>"\u0649",
    "\uFEF0"=>"\u0649",
    "\uFEF1"=>"\u064A",
    "\uFEF2"=>"\u064A",
    "\uFEF3"=>"\u064A",
    "\uFEF4"=>"\u064A",
    "\uFEF5"=>"\u0644\u0622",
    "\uFEF6"=>"\u0644\u0622",
    "\uFEF7"=>"\u0644\u0623",
    "\uFEF8"=>"\u0644\u0623",
    "\uFEF9"=>"\u0644\u0625",
    "\uFEFA"=>"\u0644\u0625",
    "\uFEFB"=>"\u0644\u0627",
    "\uFEFC"=>"\u0644\u0627",
    "\uFF01"=>"!",
    "\uFF02"=>"\"",
    "\uFF03"=>"#",
    "\uFF04"=>"$",
    "\uFF05"=>"%",
    "\uFF06"=>"&",
    "\uFF07"=>"'",
    "\uFF08"=>"(",
    "\uFF09"=>")",
    "\uFF0A"=>"*",
    "\uFF0B"=>"+",
    "\uFF0C"=>",",
    "\uFF0D"=>"-",
    "\uFF0E"=>".",
    "\uFF0F"=>"/",
    "\uFF10"=>"0",
    "\uFF11"=>"1",
    "\uFF12"=>"2",
    "\uFF13"=>"3",
    "\uFF14"=>"4",
    "\uFF15"=>"5",
    "\uFF16"=>"6",
    "\uFF17"=>"7",
    "\uFF18"=>"8",
    "\uFF19"=>"9",
    "\uFF1A"=>":",
    "\uFF1B"=>";",
    "\uFF1C"=>"<",
    "\uFF1D"=>"=",
    "\uFF1E"=>">",
    "\uFF1F"=>"?",
    "\uFF20"=>"@",
    "\uFF21"=>"A",
    "\uFF22"=>"B",
    "\uFF23"=>"C",
    "\uFF24"=>"D",
    "\uFF25"=>"E",
    "\uFF26"=>"F",
    "\uFF27"=>"G",
    "\uFF28"=>"H",
    "\uFF29"=>"I",
    "\uFF2A"=>"J",
    "\uFF2B"=>"K",
    "\uFF2C"=>"L",
    "\uFF2D"=>"M",
    "\uFF2E"=>"N",
    "\uFF2F"=>"O",
    "\uFF30"=>"P",
    "\uFF31"=>"Q",
    "\uFF32"=>"R",
    "\uFF33"=>"S",
    "\uFF34"=>"T",
    "\uFF35"=>"U",
    "\uFF36"=>"V",
    "\uFF37"=>"W",
    "\uFF38"=>"X",
    "\uFF39"=>"Y",
    "\uFF3A"=>"Z",
    "\uFF3B"=>"[",
    "\uFF3C"=>"\\",
    "\uFF3D"=>"]",
    "\uFF3E"=>"^",
    "\uFF3F"=>"_",
    "\uFF40"=>"`",
    "\uFF41"=>"a",
    "\uFF42"=>"b",
    "\uFF43"=>"c",
    "\uFF44"=>"d",
    "\uFF45"=>"e",
    "\uFF46"=>"f",
    "\uFF47"=>"g",
    "\uFF48"=>"h",
    "\uFF49"=>"i",
    "\uFF4A"=>"j",
    "\uFF4B"=>"k",
    "\uFF4C"=>"l",
    "\uFF4D"=>"m",
    "\uFF4E"=>"n",
    "\uFF4F"=>"o",
    "\uFF50"=>"p",
    "\uFF51"=>"q",
    "\uFF52"=>"r",
    "\uFF53"=>"s",
    "\uFF54"=>"t",
    "\uFF55"=>"u",
    "\uFF56"=>"v",
    "\uFF57"=>"w",
    "\uFF58"=>"x",
    "\uFF59"=>"y",
    "\uFF5A"=>"z",
    "\uFF5B"=>"{",
    "\uFF5C"=>"|",
    "\uFF5D"=>"}",
    "\uFF5E"=>"~",
    "\uFF5F"=>"\u2985",
    "\uFF60"=>"\u2986",
    "\uFF61"=>"\u3002",
    "\uFF62"=>"\u300C",
    "\uFF63"=>"\u300D",
    "\uFF64"=>"\u3001",
    "\uFF65"=>"\u30FB",
    "\uFF66"=>"\u30F2",
    "\uFF67"=>"\u30A1",
    "\uFF68"=>"\u30A3",
    "\uFF69"=>"\u30A5",
    "\uFF6A"=>"\u30A7",
    "\uFF6B"=>"\u30A9",
    "\uFF6C"=>"\u30E3",
    "\uFF6D"=>"\u30E5",
    "\uFF6E"=>"\u30E7",
    "\uFF6F"=>"\u30C3",
    "\uFF70"=>"\u30FC",
    "\uFF71"=>"\u30A2",
    "\uFF72"=>"\u30A4",
    "\uFF73"=>"\u30A6",
    "\uFF74"=>"\u30A8",
    "\uFF75"=>"\u30AA",
    "\uFF76"=>"\u30AB",
    "\uFF77"=>"\u30AD",
    "\uFF78"=>"\u30AF",
    "\uFF79"=>"\u30B1",
    "\uFF7A"=>"\u30B3",
    "\uFF7B"=>"\u30B5",
    "\uFF7C"=>"\u30B7",
    "\uFF7D"=>"\u30B9",
    "\uFF7E"=>"\u30BB",
    "\uFF7F"=>"\u30BD",
    "\uFF80"=>"\u30BF",
    "\uFF81"=>"\u30C1",
    "\uFF82"=>"\u30C4",
    "\uFF83"=>"\u30C6",
    "\uFF84"=>"\u30C8",
    "\uFF85"=>"\u30CA",
    "\uFF86"=>"\u30CB",
    "\uFF87"=>"\u30CC",
    "\uFF88"=>"\u30CD",
    "\uFF89"=>"\u30CE",
    "\uFF8A"=>"\u30CF",
    "\uFF8B"=>"\u30D2",
    "\uFF8C"=>"\u30D5",
    "\uFF8D"=>"\u30D8",
    "\uFF8E"=>"\u30DB",
    "\uFF8F"=>"\u30DE",
    "\uFF90"=>"\u30DF",
    "\uFF91"=>"\u30E0",
    "\uFF92"=>"\u30E1",
    "\uFF93"=>"\u30E2",
    "\uFF94"=>"\u30E4",
    "\uFF95"=>"\u30E6",
    "\uFF96"=>"\u30E8",
    "\uFF97"=>"\u30E9",
    "\uFF98"=>"\u30EA",
    "\uFF99"=>"\u30EB",
    "\uFF9A"=>"\u30EC",
    "\uFF9B"=>"\u30ED",
    "\uFF9C"=>"\u30EF",
    "\uFF9D"=>"\u30F3",
    "\uFF9E"=>"\u3099",
    "\uFF9F"=>"\u309A",
    "\uFFA0"=>"\u1160",
    "\uFFA1"=>"\u1100",
    "\uFFA2"=>"\u1101",
    "\uFFA3"=>"\u11AA",
    "\uFFA4"=>"\u1102",
    "\uFFA5"=>"\u11AC",
    "\uFFA6"=>"\u11AD",
    "\uFFA7"=>"\u1103",
    "\uFFA8"=>"\u1104",
    "\uFFA9"=>"\u1105",
    "\uFFAA"=>"\u11B0",
    "\uFFAB"=>"\u11B1",
    "\uFFAC"=>"\u11B2",
    "\uFFAD"=>"\u11B3",
    "\uFFAE"=>"\u11B4",
    "\uFFAF"=>"\u11B5",
    "\uFFB0"=>"\u111A",
    "\uFFB1"=>"\u1106",
    "\uFFB2"=>"\u1107",
    "\uFFB3"=>"\u1108",
    "\uFFB4"=>"\u1121",
    "\uFFB5"=>"\u1109",
    "\uFFB6"=>"\u110A",
    "\uFFB7"=>"\u110B",
    "\uFFB8"=>"\u110C",
    "\uFFB9"=>"\u110D",
    "\uFFBA"=>"\u110E",
    "\uFFBB"=>"\u110F",
    "\uFFBC"=>"\u1110",
    "\uFFBD"=>"\u1111",
    "\uFFBE"=>"\u1112",
    "\uFFC2"=>"\u1161",
    "\uFFC3"=>"\u1162",
    "\uFFC4"=>"\u1163",
    "\uFFC5"=>"\u1164",
    "\uFFC6"=>"\u1165",
    "\uFFC7"=>"\u1166",
    "\uFFCA"=>"\u1167",
    "\uFFCB"=>"\u1168",
    "\uFFCC"=>"\u1169",
    "\uFFCD"=>"\u116A",
    "\uFFCE"=>"\u116B",
    "\uFFCF"=>"\u116C",
    "\uFFD2"=>"\u116D",
    "\uFFD3"=>"\u116E",
    "\uFFD4"=>"\u116F",
    "\uFFD5"=>"\u1170",
    "\uFFD6"=>"\u1171",
    "\uFFD7"=>"\u1172",
    "\uFFDA"=>"\u1173",
    "\uFFDB"=>"\u1174",
    "\uFFDC"=>"\u1175",
    "\uFFE0"=>"\u00A2",
    "\uFFE1"=>"\u00A3",
    "\uFFE2"=>"\u00AC",
    "\uFFE3"=>" \u0304",
    "\uFFE4"=>"\u00A6",
    "\uFFE5"=>"\u00A5",
    "\uFFE6"=>"\u20A9",
    "\uFFE8"=>"\u2502",
    "\uFFE9"=>"\u2190",
    "\uFFEA"=>"\u2191",
    "\uFFEB"=>"\u2192",
    "\uFFEC"=>"\u2193",
    "\uFFED"=>"\u25A0",
    "\uFFEE"=>"\u25CB",
    "\u{1D400}"=>"A",
    "\u{1D401}"=>"B",
    "\u{1D402}"=>"C",
    "\u{1D403}"=>"D",
    "\u{1D404}"=>"E",
    "\u{1D405}"=>"F",
    "\u{1D406}"=>"G",
    "\u{1D407}"=>"H",
    "\u{1D408}"=>"I",
    "\u{1D409}"=>"J",
    "\u{1D40A}"=>"K",
    "\u{1D40B}"=>"L",
    "\u{1D40C}"=>"M",
    "\u{1D40D}"=>"N",
    "\u{1D40E}"=>"O",
    "\u{1D40F}"=>"P",
    "\u{1D410}"=>"Q",
    "\u{1D411}"=>"R",
    "\u{1D412}"=>"S",
    "\u{1D413}"=>"T",
    "\u{1D414}"=>"U",
    "\u{1D415}"=>"V",
    "\u{1D416}"=>"W",
    "\u{1D417}"=>"X",
    "\u{1D418}"=>"Y",
    "\u{1D419}"=>"Z",
    "\u{1D41A}"=>"a",
    "\u{1D41B}"=>"b",
    "\u{1D41C}"=>"c",
    "\u{1D41D}"=>"d",
    "\u{1D41E}"=>"e",
    "\u{1D41F}"=>"f",
    "\u{1D420}"=>"g",
    "\u{1D421}"=>"h",
    "\u{1D422}"=>"i",
    "\u{1D423}"=>"j",
    "\u{1D424}"=>"k",
    "\u{1D425}"=>"l",
    "\u{1D426}"=>"m",
    "\u{1D427}"=>"n",
    "\u{1D428}"=>"o",
    "\u{1D429}"=>"p",
    "\u{1D42A}"=>"q",
    "\u{1D42B}"=>"r",
    "\u{1D42C}"=>"s",
    "\u{1D42D}"=>"t",
    "\u{1D42E}"=>"u",
    "\u{1D42F}"=>"v",
    "\u{1D430}"=>"w",
    "\u{1D431}"=>"x",
    "\u{1D432}"=>"y",
    "\u{1D433}"=>"z",
    "\u{1D434}"=>"A",
    "\u{1D435}"=>"B",
    "\u{1D436}"=>"C",
    "\u{1D437}"=>"D",
    "\u{1D438}"=>"E",
    "\u{1D439}"=>"F",
    "\u{1D43A}"=>"G",
    "\u{1D43B}"=>"H",
    "\u{1D43C}"=>"I",
    "\u{1D43D}"=>"J",
    "\u{1D43E}"=>"K",
    "\u{1D43F}"=>"L",
    "\u{1D440}"=>"M",
    "\u{1D441}"=>"N",
    "\u{1D442}"=>"O",
    "\u{1D443}"=>"P",
    "\u{1D444}"=>"Q",
    "\u{1D445}"=>"R",
    "\u{1D446}"=>"S",
    "\u{1D447}"=>"T",
    "\u{1D448}"=>"U",
    "\u{1D449}"=>"V",
    "\u{1D44A}"=>"W",
    "\u{1D44B}"=>"X",
    "\u{1D44C}"=>"Y",
    "\u{1D44D}"=>"Z",
    "\u{1D44E}"=>"a",
    "\u{1D44F}"=>"b",
    "\u{1D450}"=>"c",
    "\u{1D451}"=>"d",
    "\u{1D452}"=>"e",
    "\u{1D453}"=>"f",
    "\u{1D454}"=>"g",
    "\u{1D456}"=>"i",
    "\u{1D457}"=>"j",
    "\u{1D458}"=>"k",
    "\u{1D459}"=>"l",
    "\u{1D45A}"=>"m",
    "\u{1D45B}"=>"n",
    "\u{1D45C}"=>"o",
    "\u{1D45D}"=>"p",
    "\u{1D45E}"=>"q",
    "\u{1D45F}"=>"r",
    "\u{1D460}"=>"s",
    "\u{1D461}"=>"t",
    "\u{1D462}"=>"u",
    "\u{1D463}"=>"v",
    "\u{1D464}"=>"w",
    "\u{1D465}"=>"x",
    "\u{1D466}"=>"y",
    "\u{1D467}"=>"z",
    "\u{1D468}"=>"A",
    "\u{1D469}"=>"B",
    "\u{1D46A}"=>"C",
    "\u{1D46B}"=>"D",
    "\u{1D46C}"=>"E",
    "\u{1D46D}"=>"F",
    "\u{1D46E}"=>"G",
    "\u{1D46F}"=>"H",
    "\u{1D470}"=>"I",
    "\u{1D471}"=>"J",
    "\u{1D472}"=>"K",
    "\u{1D473}"=>"L",
    "\u{1D474}"=>"M",
    "\u{1D475}"=>"N",
    "\u{1D476}"=>"O",
    "\u{1D477}"=>"P",
    "\u{1D478}"=>"Q",
    "\u{1D479}"=>"R",
    "\u{1D47A}"=>"S",
    "\u{1D47B}"=>"T",
    "\u{1D47C}"=>"U",
    "\u{1D47D}"=>"V",
    "\u{1D47E}"=>"W",
    "\u{1D47F}"=>"X",
    "\u{1D480}"=>"Y",
    "\u{1D481}"=>"Z",
    "\u{1D482}"=>"a",
    "\u{1D483}"=>"b",
    "\u{1D484}"=>"c",
    "\u{1D485}"=>"d",
    "\u{1D486}"=>"e",
    "\u{1D487}"=>"f",
    "\u{1D488}"=>"g",
    "\u{1D489}"=>"h",
    "\u{1D48A}"=>"i",
    "\u{1D48B}"=>"j",
    "\u{1D48C}"=>"k",
    "\u{1D48D}"=>"l",
    "\u{1D48E}"=>"m",
    "\u{1D48F}"=>"n",
    "\u{1D490}"=>"o",
    "\u{1D491}"=>"p",
    "\u{1D492}"=>"q",
    "\u{1D493}"=>"r",
    "\u{1D494}"=>"s",
    "\u{1D495}"=>"t",
    "\u{1D496}"=>"u",
    "\u{1D497}"=>"v",
    "\u{1D498}"=>"w",
    "\u{1D499}"=>"x",
    "\u{1D49A}"=>"y",
    "\u{1D49B}"=>"z",
    "\u{1D49C}"=>"A",
    "\u{1D49E}"=>"C",
    "\u{1D49F}"=>"D",
    "\u{1D4A2}"=>"G",
    "\u{1D4A5}"=>"J",
    "\u{1D4A6}"=>"K",
    "\u{1D4A9}"=>"N",
    "\u{1D4AA}"=>"O",
    "\u{1D4AB}"=>"P",
    "\u{1D4AC}"=>"Q",
    "\u{1D4AE}"=>"S",
    "\u{1D4AF}"=>"T",
    "\u{1D4B0}"=>"U",
    "\u{1D4B1}"=>"V",
    "\u{1D4B2}"=>"W",
    "\u{1D4B3}"=>"X",
    "\u{1D4B4}"=>"Y",
    "\u{1D4B5}"=>"Z",
    "\u{1D4B6}"=>"a",
    "\u{1D4B7}"=>"b",
    "\u{1D4B8}"=>"c",
    "\u{1D4B9}"=>"d",
    "\u{1D4BB}"=>"f",
    "\u{1D4BD}"=>"h",
    "\u{1D4BE}"=>"i",
    "\u{1D4BF}"=>"j",
    "\u{1D4C0}"=>"k",
    "\u{1D4C1}"=>"l",
    "\u{1D4C2}"=>"m",
    "\u{1D4C3}"=>"n",
    "\u{1D4C5}"=>"p",
    "\u{1D4C6}"=>"q",
    "\u{1D4C7}"=>"r",
    "\u{1D4C8}"=>"s",
    "\u{1D4C9}"=>"t",
    "\u{1D4CA}"=>"u",
    "\u{1D4CB}"=>"v",
    "\u{1D4CC}"=>"w",
    "\u{1D4CD}"=>"x",
    "\u{1D4CE}"=>"y",
    "\u{1D4CF}"=>"z",
    "\u{1D4D0}"=>"A",
    "\u{1D4D1}"=>"B",
    "\u{1D4D2}"=>"C",
    "\u{1D4D3}"=>"D",
    "\u{1D4D4}"=>"E",
    "\u{1D4D5}"=>"F",
    "\u{1D4D6}"=>"G",
    "\u{1D4D7}"=>"H",
    "\u{1D4D8}"=>"I",
    "\u{1D4D9}"=>"J",
    "\u{1D4DA}"=>"K",
    "\u{1D4DB}"=>"L",
    "\u{1D4DC}"=>"M",
    "\u{1D4DD}"=>"N",
    "\u{1D4DE}"=>"O",
    "\u{1D4DF}"=>"P",
    "\u{1D4E0}"=>"Q",
    "\u{1D4E1}"=>"R",
    "\u{1D4E2}"=>"S",
    "\u{1D4E3}"=>"T",
    "\u{1D4E4}"=>"U",
    "\u{1D4E5}"=>"V",
    "\u{1D4E6}"=>"W",
    "\u{1D4E7}"=>"X",
    "\u{1D4E8}"=>"Y",
    "\u{1D4E9}"=>"Z",
    "\u{1D4EA}"=>"a",
    "\u{1D4EB}"=>"b",
    "\u{1D4EC}"=>"c",
    "\u{1D4ED}"=>"d",
    "\u{1D4EE}"=>"e",
    "\u{1D4EF}"=>"f",
    "\u{1D4F0}"=>"g",
    "\u{1D4F1}"=>"h",
    "\u{1D4F2}"=>"i",
    "\u{1D4F3}"=>"j",
    "\u{1D4F4}"=>"k",
    "\u{1D4F5}"=>"l",
    "\u{1D4F6}"=>"m",
    "\u{1D4F7}"=>"n",
    "\u{1D4F8}"=>"o",
    "\u{1D4F9}"=>"p",
    "\u{1D4FA}"=>"q",
    "\u{1D4FB}"=>"r",
    "\u{1D4FC}"=>"s",
    "\u{1D4FD}"=>"t",
    "\u{1D4FE}"=>"u",
    "\u{1D4FF}"=>"v",
    "\u{1D500}"=>"w",
    "\u{1D501}"=>"x",
    "\u{1D502}"=>"y",
    "\u{1D503}"=>"z",
    "\u{1D504}"=>"A",
    "\u{1D505}"=>"B",
    "\u{1D507}"=>"D",
    "\u{1D508}"=>"E",
    "\u{1D509}"=>"F",
    "\u{1D50A}"=>"G",
    "\u{1D50D}"=>"J",
    "\u{1D50E}"=>"K",
    "\u{1D50F}"=>"L",
    "\u{1D510}"=>"M",
    "\u{1D511}"=>"N",
    "\u{1D512}"=>"O",
    "\u{1D513}"=>"P",
    "\u{1D514}"=>"Q",
    "\u{1D516}"=>"S",
    "\u{1D517}"=>"T",
    "\u{1D518}"=>"U",
    "\u{1D519}"=>"V",
    "\u{1D51A}"=>"W",
    "\u{1D51B}"=>"X",
    "\u{1D51C}"=>"Y",
    "\u{1D51E}"=>"a",
    "\u{1D51F}"=>"b",
    "\u{1D520}"=>"c",
    "\u{1D521}"=>"d",
    "\u{1D522}"=>"e",
    "\u{1D523}"=>"f",
    "\u{1D524}"=>"g",
    "\u{1D525}"=>"h",
    "\u{1D526}"=>"i",
    "\u{1D527}"=>"j",
    "\u{1D528}"=>"k",
    "\u{1D529}"=>"l",
    "\u{1D52A}"=>"m",
    "\u{1D52B}"=>"n",
    "\u{1D52C}"=>"o",
    "\u{1D52D}"=>"p",
    "\u{1D52E}"=>"q",
    "\u{1D52F}"=>"r",
    "\u{1D530}"=>"s",
    "\u{1D531}"=>"t",
    "\u{1D532}"=>"u",
    "\u{1D533}"=>"v",
    "\u{1D534}"=>"w",
    "\u{1D535}"=>"x",
    "\u{1D536}"=>"y",
    "\u{1D537}"=>"z",
    "\u{1D538}"=>"A",
    "\u{1D539}"=>"B",
    "\u{1D53B}"=>"D",
    "\u{1D53C}"=>"E",
    "\u{1D53D}"=>"F",
    "\u{1D53E}"=>"G",
    "\u{1D540}"=>"I",
    "\u{1D541}"=>"J",
    "\u{1D542}"=>"K",
    "\u{1D543}"=>"L",
    "\u{1D544}"=>"M",
    "\u{1D546}"=>"O",
    "\u{1D54A}"=>"S",
    "\u{1D54B}"=>"T",
    "\u{1D54C}"=>"U",
    "\u{1D54D}"=>"V",
    "\u{1D54E}"=>"W",
    "\u{1D54F}"=>"X",
    "\u{1D550}"=>"Y",
    "\u{1D552}"=>"a",
    "\u{1D553}"=>"b",
    "\u{1D554}"=>"c",
    "\u{1D555}"=>"d",
    "\u{1D556}"=>"e",
    "\u{1D557}"=>"f",
    "\u{1D558}"=>"g",
    "\u{1D559}"=>"h",
    "\u{1D55A}"=>"i",
    "\u{1D55B}"=>"j",
    "\u{1D55C}"=>"k",
    "\u{1D55D}"=>"l",
    "\u{1D55E}"=>"m",
    "\u{1D55F}"=>"n",
    "\u{1D560}"=>"o",
    "\u{1D561}"=>"p",
    "\u{1D562}"=>"q",
    "\u{1D563}"=>"r",
    "\u{1D564}"=>"s",
    "\u{1D565}"=>"t",
    "\u{1D566}"=>"u",
    "\u{1D567}"=>"v",
    "\u{1D568}"=>"w",
    "\u{1D569}"=>"x",
    "\u{1D56A}"=>"y",
    "\u{1D56B}"=>"z",
    "\u{1D56C}"=>"A",
    "\u{1D56D}"=>"B",
    "\u{1D56E}"=>"C",
    "\u{1D56F}"=>"D",
    "\u{1D570}"=>"E",
    "\u{1D571}"=>"F",
    "\u{1D572}"=>"G",
    "\u{1D573}"=>"H",
    "\u{1D574}"=>"I",
    "\u{1D575}"=>"J",
    "\u{1D576}"=>"K",
    "\u{1D577}"=>"L",
    "\u{1D578}"=>"M",
    "\u{1D579}"=>"N",
    "\u{1D57A}"=>"O",
    "\u{1D57B}"=>"P",
    "\u{1D57C}"=>"Q",
    "\u{1D57D}"=>"R",
    "\u{1D57E}"=>"S",
    "\u{1D57F}"=>"T",
    "\u{1D580}"=>"U",
    "\u{1D581}"=>"V",
    "\u{1D582}"=>"W",
    "\u{1D583}"=>"X",
    "\u{1D584}"=>"Y",
    "\u{1D585}"=>"Z",
    "\u{1D586}"=>"a",
    "\u{1D587}"=>"b",
    "\u{1D588}"=>"c",
    "\u{1D589}"=>"d",
    "\u{1D58A}"=>"e",
    "\u{1D58B}"=>"f",
    "\u{1D58C}"=>"g",
    "\u{1D58D}"=>"h",
    "\u{1D58E}"=>"i",
    "\u{1D58F}"=>"j",
    "\u{1D590}"=>"k",
    "\u{1D591}"=>"l",
    "\u{1D592}"=>"m",
    "\u{1D593}"=>"n",
    "\u{1D594}"=>"o",
    "\u{1D595}"=>"p",
    "\u{1D596}"=>"q",
    "\u{1D597}"=>"r",
    "\u{1D598}"=>"s",
    "\u{1D599}"=>"t",
    "\u{1D59A}"=>"u",
    "\u{1D59B}"=>"v",
    "\u{1D59C}"=>"w",
    "\u{1D59D}"=>"x",
    "\u{1D59E}"=>"y",
    "\u{1D59F}"=>"z",
    "\u{1D5A0}"=>"A",
    "\u{1D5A1}"=>"B",
    "\u{1D5A2}"=>"C",
    "\u{1D5A3}"=>"D",
    "\u{1D5A4}"=>"E",
    "\u{1D5A5}"=>"F",
    "\u{1D5A6}"=>"G",
    "\u{1D5A7}"=>"H",
    "\u{1D5A8}"=>"I",
    "\u{1D5A9}"=>"J",
    "\u{1D5AA}"=>"K",
    "\u{1D5AB}"=>"L",
    "\u{1D5AC}"=>"M",
    "\u{1D5AD}"=>"N",
    "\u{1D5AE}"=>"O",
    "\u{1D5AF}"=>"P",
    "\u{1D5B0}"=>"Q",
    "\u{1D5B1}"=>"R",
    "\u{1D5B2}"=>"S",
    "\u{1D5B3}"=>"T",
    "\u{1D5B4}"=>"U",
    "\u{1D5B5}"=>"V",
    "\u{1D5B6}"=>"W",
    "\u{1D5B7}"=>"X",
    "\u{1D5B8}"=>"Y",
    "\u{1D5B9}"=>"Z",
    "\u{1D5BA}"=>"a",
    "\u{1D5BB}"=>"b",
    "\u{1D5BC}"=>"c",
    "\u{1D5BD}"=>"d",
    "\u{1D5BE}"=>"e",
    "\u{1D5BF}"=>"f",
    "\u{1D5C0}"=>"g",
    "\u{1D5C1}"=>"h",
    "\u{1D5C2}"=>"i",
    "\u{1D5C3}"=>"j",
    "\u{1D5C4}"=>"k",
    "\u{1D5C5}"=>"l",
    "\u{1D5C6}"=>"m",
    "\u{1D5C7}"=>"n",
    "\u{1D5C8}"=>"o",
    "\u{1D5C9}"=>"p",
    "\u{1D5CA}"=>"q",
    "\u{1D5CB}"=>"r",
    "\u{1D5CC}"=>"s",
    "\u{1D5CD}"=>"t",
    "\u{1D5CE}"=>"u",
    "\u{1D5CF}"=>"v",
    "\u{1D5D0}"=>"w",
    "\u{1D5D1}"=>"x",
    "\u{1D5D2}"=>"y",
    "\u{1D5D3}"=>"z",
    "\u{1D5D4}"=>"A",
    "\u{1D5D5}"=>"B",
    "\u{1D5D6}"=>"C",
    "\u{1D5D7}"=>"D",
    "\u{1D5D8}"=>"E",
    "\u{1D5D9}"=>"F",
    "\u{1D5DA}"=>"G",
    "\u{1D5DB}"=>"H",
    "\u{1D5DC}"=>"I",
    "\u{1D5DD}"=>"J",
    "\u{1D5DE}"=>"K",
    "\u{1D5DF}"=>"L",
    "\u{1D5E0}"=>"M",
    "\u{1D5E1}"=>"N",
    "\u{1D5E2}"=>"O",
    "\u{1D5E3}"=>"P",
    "\u{1D5E4}"=>"Q",
    "\u{1D5E5}"=>"R",
    "\u{1D5E6}"=>"S",
    "\u{1D5E7}"=>"T",
    "\u{1D5E8}"=>"U",
    "\u{1D5E9}"=>"V",
    "\u{1D5EA}"=>"W",
    "\u{1D5EB}"=>"X",
    "\u{1D5EC}"=>"Y",
    "\u{1D5ED}"=>"Z",
    "\u{1D5EE}"=>"a",
    "\u{1D5EF}"=>"b",
    "\u{1D5F0}"=>"c",
    "\u{1D5F1}"=>"d",
    "\u{1D5F2}"=>"e",
    "\u{1D5F3}"=>"f",
    "\u{1D5F4}"=>"g",
    "\u{1D5F5}"=>"h",
    "\u{1D5F6}"=>"i",
    "\u{1D5F7}"=>"j",
    "\u{1D5F8}"=>"k",
    "\u{1D5F9}"=>"l",
    "\u{1D5FA}"=>"m",
    "\u{1D5FB}"=>"n",
    "\u{1D5FC}"=>"o",
    "\u{1D5FD}"=>"p",
    "\u{1D5FE}"=>"q",
    "\u{1D5FF}"=>"r",
    "\u{1D600}"=>"s",
    "\u{1D601}"=>"t",
    "\u{1D602}"=>"u",
    "\u{1D603}"=>"v",
    "\u{1D604}"=>"w",
    "\u{1D605}"=>"x",
    "\u{1D606}"=>"y",
    "\u{1D607}"=>"z",
    "\u{1D608}"=>"A",
    "\u{1D609}"=>"B",
    "\u{1D60A}"=>"C",
    "\u{1D60B}"=>"D",
    "\u{1D60C}"=>"E",
    "\u{1D60D}"=>"F",
    "\u{1D60E}"=>"G",
    "\u{1D60F}"=>"H",
    "\u{1D610}"=>"I",
    "\u{1D611}"=>"J",
    "\u{1D612}"=>"K",
    "\u{1D613}"=>"L",
    "\u{1D614}"=>"M",
    "\u{1D615}"=>"N",
    "\u{1D616}"=>"O",
    "\u{1D617}"=>"P",
    "\u{1D618}"=>"Q",
    "\u{1D619}"=>"R",
    "\u{1D61A}"=>"S",
    "\u{1D61B}"=>"T",
    "\u{1D61C}"=>"U",
    "\u{1D61D}"=>"V",
    "\u{1D61E}"=>"W",
    "\u{1D61F}"=>"X",
    "\u{1D620}"=>"Y",
    "\u{1D621}"=>"Z",
    "\u{1D622}"=>"a",
    "\u{1D623}"=>"b",
    "\u{1D624}"=>"c",
    "\u{1D625}"=>"d",
    "\u{1D626}"=>"e",
    "\u{1D627}"=>"f",
    "\u{1D628}"=>"g",
    "\u{1D629}"=>"h",
    "\u{1D62A}"=>"i",
    "\u{1D62B}"=>"j",
    "\u{1D62C}"=>"k",
    "\u{1D62D}"=>"l",
    "\u{1D62E}"=>"m",
    "\u{1D62F}"=>"n",
    "\u{1D630}"=>"o",
    "\u{1D631}"=>"p",
    "\u{1D632}"=>"q",
    "\u{1D633}"=>"r",
    "\u{1D634}"=>"s",
    "\u{1D635}"=>"t",
    "\u{1D636}"=>"u",
    "\u{1D637}"=>"v",
    "\u{1D638}"=>"w",
    "\u{1D639}"=>"x",
    "\u{1D63A}"=>"y",
    "\u{1D63B}"=>"z",
    "\u{1D63C}"=>"A",
    "\u{1D63D}"=>"B",
    "\u{1D63E}"=>"C",
    "\u{1D63F}"=>"D",
    "\u{1D640}"=>"E",
    "\u{1D641}"=>"F",
    "\u{1D642}"=>"G",
    "\u{1D643}"=>"H",
    "\u{1D644}"=>"I",
    "\u{1D645}"=>"J",
    "\u{1D646}"=>"K",
    "\u{1D647}"=>"L",
    "\u{1D648}"=>"M",
    "\u{1D649}"=>"N",
    "\u{1D64A}"=>"O",
    "\u{1D64B}"=>"P",
    "\u{1D64C}"=>"Q",
    "\u{1D64D}"=>"R",
    "\u{1D64E}"=>"S",
    "\u{1D64F}"=>"T",
    "\u{1D650}"=>"U",
    "\u{1D651}"=>"V",
    "\u{1D652}"=>"W",
    "\u{1D653}"=>"X",
    "\u{1D654}"=>"Y",
    "\u{1D655}"=>"Z",
    "\u{1D656}"=>"a",
    "\u{1D657}"=>"b",
    "\u{1D658}"=>"c",
    "\u{1D659}"=>"d",
    "\u{1D65A}"=>"e",
    "\u{1D65B}"=>"f",
    "\u{1D65C}"=>"g",
    "\u{1D65D}"=>"h",
    "\u{1D65E}"=>"i",
    "\u{1D65F}"=>"j",
    "\u{1D660}"=>"k",
    "\u{1D661}"=>"l",
    "\u{1D662}"=>"m",
    "\u{1D663}"=>"n",
    "\u{1D664}"=>"o",
    "\u{1D665}"=>"p",
    "\u{1D666}"=>"q",
    "\u{1D667}"=>"r",
    "\u{1D668}"=>"s",
    "\u{1D669}"=>"t",
    "\u{1D66A}"=>"u",
    "\u{1D66B}"=>"v",
    "\u{1D66C}"=>"w",
    "\u{1D66D}"=>"x",
    "\u{1D66E}"=>"y",
    "\u{1D66F}"=>"z",
    "\u{1D670}"=>"A",
    "\u{1D671}"=>"B",
    "\u{1D672}"=>"C",
    "\u{1D673}"=>"D",
    "\u{1D674}"=>"E",
    "\u{1D675}"=>"F",
    "\u{1D676}"=>"G",
    "\u{1D677}"=>"H",
    "\u{1D678}"=>"I",
    "\u{1D679}"=>"J",
    "\u{1D67A}"=>"K",
    "\u{1D67B}"=>"L",
    "\u{1D67C}"=>"M",
    "\u{1D67D}"=>"N",
    "\u{1D67E}"=>"O",
    "\u{1D67F}"=>"P",
    "\u{1D680}"=>"Q",
    "\u{1D681}"=>"R",
    "\u{1D682}"=>"S",
    "\u{1D683}"=>"T",
    "\u{1D684}"=>"U",
    "\u{1D685}"=>"V",
    "\u{1D686}"=>"W",
    "\u{1D687}"=>"X",
    "\u{1D688}"=>"Y",
    "\u{1D689}"=>"Z",
    "\u{1D68A}"=>"a",
    "\u{1D68B}"=>"b",
    "\u{1D68C}"=>"c",
    "\u{1D68D}"=>"d",
    "\u{1D68E}"=>"e",
    "\u{1D68F}"=>"f",
    "\u{1D690}"=>"g",
    "\u{1D691}"=>"h",
    "\u{1D692}"=>"i",
    "\u{1D693}"=>"j",
    "\u{1D694}"=>"k",
    "\u{1D695}"=>"l",
    "\u{1D696}"=>"m",
    "\u{1D697}"=>"n",
    "\u{1D698}"=>"o",
    "\u{1D699}"=>"p",
    "\u{1D69A}"=>"q",
    "\u{1D69B}"=>"r",
    "\u{1D69C}"=>"s",
    "\u{1D69D}"=>"t",
    "\u{1D69E}"=>"u",
    "\u{1D69F}"=>"v",
    "\u{1D6A0}"=>"w",
    "\u{1D6A1}"=>"x",
    "\u{1D6A2}"=>"y",
    "\u{1D6A3}"=>"z",
    "\u{1D6A4}"=>"\u0131",
    "\u{1D6A5}"=>"\u0237",
    "\u{1D6A8}"=>"\u0391",
    "\u{1D6A9}"=>"\u0392",
    "\u{1D6AA}"=>"\u0393",
    "\u{1D6AB}"=>"\u0394",
    "\u{1D6AC}"=>"\u0395",
    "\u{1D6AD}"=>"\u0396",
    "\u{1D6AE}"=>"\u0397",
    "\u{1D6AF}"=>"\u0398",
    "\u{1D6B0}"=>"\u0399",
    "\u{1D6B1}"=>"\u039A",
    "\u{1D6B2}"=>"\u039B",
    "\u{1D6B3}"=>"\u039C",
    "\u{1D6B4}"=>"\u039D",
    "\u{1D6B5}"=>"\u039E",
    "\u{1D6B6}"=>"\u039F",
    "\u{1D6B7}"=>"\u03A0",
    "\u{1D6B8}"=>"\u03A1",
    "\u{1D6B9}"=>"\u0398",
    "\u{1D6BA}"=>"\u03A3",
    "\u{1D6BB}"=>"\u03A4",
    "\u{1D6BC}"=>"\u03A5",
    "\u{1D6BD}"=>"\u03A6",
    "\u{1D6BE}"=>"\u03A7",
    "\u{1D6BF}"=>"\u03A8",
    "\u{1D6C0}"=>"\u03A9",
    "\u{1D6C1}"=>"\u2207",
    "\u{1D6C2}"=>"\u03B1",
    "\u{1D6C3}"=>"\u03B2",
    "\u{1D6C4}"=>"\u03B3",
    "\u{1D6C5}"=>"\u03B4",
    "\u{1D6C6}"=>"\u03B5",
    "\u{1D6C7}"=>"\u03B6",
    "\u{1D6C8}"=>"\u03B7",
    "\u{1D6C9}"=>"\u03B8",
    "\u{1D6CA}"=>"\u03B9",
    "\u{1D6CB}"=>"\u03BA",
    "\u{1D6CC}"=>"\u03BB",
    "\u{1D6CD}"=>"\u03BC",
    "\u{1D6CE}"=>"\u03BD",
    "\u{1D6CF}"=>"\u03BE",
    "\u{1D6D0}"=>"\u03BF",
    "\u{1D6D1}"=>"\u03C0",
    "\u{1D6D2}"=>"\u03C1",
    "\u{1D6D3}"=>"\u03C2",
    "\u{1D6D4}"=>"\u03C3",
    "\u{1D6D5}"=>"\u03C4",
    "\u{1D6D6}"=>"\u03C5",
    "\u{1D6D7}"=>"\u03C6",
    "\u{1D6D8}"=>"\u03C7",
    "\u{1D6D9}"=>"\u03C8",
    "\u{1D6DA}"=>"\u03C9",
    "\u{1D6DB}"=>"\u2202",
    "\u{1D6DC}"=>"\u03B5",
    "\u{1D6DD}"=>"\u03B8",
    "\u{1D6DE}"=>"\u03BA",
    "\u{1D6DF}"=>"\u03C6",
    "\u{1D6E0}"=>"\u03C1",
    "\u{1D6E1}"=>"\u03C0",
    "\u{1D6E2}"=>"\u0391",
    "\u{1D6E3}"=>"\u0392",
    "\u{1D6E4}"=>"\u0393",
    "\u{1D6E5}"=>"\u0394",
    "\u{1D6E6}"=>"\u0395",
    "\u{1D6E7}"=>"\u0396",
    "\u{1D6E8}"=>"\u0397",
    "\u{1D6E9}"=>"\u0398",
    "\u{1D6EA}"=>"\u0399",
    "\u{1D6EB}"=>"\u039A",
    "\u{1D6EC}"=>"\u039B",
    "\u{1D6ED}"=>"\u039C",
    "\u{1D6EE}"=>"\u039D",
    "\u{1D6EF}"=>"\u039E",
    "\u{1D6F0}"=>"\u039F",
    "\u{1D6F1}"=>"\u03A0",
    "\u{1D6F2}"=>"\u03A1",
    "\u{1D6F3}"=>"\u0398",
    "\u{1D6F4}"=>"\u03A3",
    "\u{1D6F5}"=>"\u03A4",
    "\u{1D6F6}"=>"\u03A5",
    "\u{1D6F7}"=>"\u03A6",
    "\u{1D6F8}"=>"\u03A7",
    "\u{1D6F9}"=>"\u03A8",
    "\u{1D6FA}"=>"\u03A9",
    "\u{1D6FB}"=>"\u2207",
    "\u{1D6FC}"=>"\u03B1",
    "\u{1D6FD}"=>"\u03B2",
    "\u{1D6FE}"=>"\u03B3",
    "\u{1D6FF}"=>"\u03B4",
    "\u{1D700}"=>"\u03B5",
    "\u{1D701}"=>"\u03B6",
    "\u{1D702}"=>"\u03B7",
    "\u{1D703}"=>"\u03B8",
    "\u{1D704}"=>"\u03B9",
    "\u{1D705}"=>"\u03BA",
    "\u{1D706}"=>"\u03BB",
    "\u{1D707}"=>"\u03BC",
    "\u{1D708}"=>"\u03BD",
    "\u{1D709}"=>"\u03BE",
    "\u{1D70A}"=>"\u03BF",
    "\u{1D70B}"=>"\u03C0",
    "\u{1D70C}"=>"\u03C1",
    "\u{1D70D}"=>"\u03C2",
    "\u{1D70E}"=>"\u03C3",
    "\u{1D70F}"=>"\u03C4",
    "\u{1D710}"=>"\u03C5",
    "\u{1D711}"=>"\u03C6",
    "\u{1D712}"=>"\u03C7",
    "\u{1D713}"=>"\u03C8",
    "\u{1D714}"=>"\u03C9",
    "\u{1D715}"=>"\u2202",
    "\u{1D716}"=>"\u03B5",
    "\u{1D717}"=>"\u03B8",
    "\u{1D718}"=>"\u03BA",
    "\u{1D719}"=>"\u03C6",
    "\u{1D71A}"=>"\u03C1",
    "\u{1D71B}"=>"\u03C0",
    "\u{1D71C}"=>"\u0391",
    "\u{1D71D}"=>"\u0392",
    "\u{1D71E}"=>"\u0393",
    "\u{1D71F}"=>"\u0394",
    "\u{1D720}"=>"\u0395",
    "\u{1D721}"=>"\u0396",
    "\u{1D722}"=>"\u0397",
    "\u{1D723}"=>"\u0398",
    "\u{1D724}"=>"\u0399",
    "\u{1D725}"=>"\u039A",
    "\u{1D726}"=>"\u039B",
    "\u{1D727}"=>"\u039C",
    "\u{1D728}"=>"\u039D",
    "\u{1D729}"=>"\u039E",
    "\u{1D72A}"=>"\u039F",
    "\u{1D72B}"=>"\u03A0",
    "\u{1D72C}"=>"\u03A1",
    "\u{1D72D}"=>"\u0398",
    "\u{1D72E}"=>"\u03A3",
    "\u{1D72F}"=>"\u03A4",
    "\u{1D730}"=>"\u03A5",
    "\u{1D731}"=>"\u03A6",
    "\u{1D732}"=>"\u03A7",
    "\u{1D733}"=>"\u03A8",
    "\u{1D734}"=>"\u03A9",
    "\u{1D735}"=>"\u2207",
    "\u{1D736}"=>"\u03B1",
    "\u{1D737}"=>"\u03B2",
    "\u{1D738}"=>"\u03B3",
    "\u{1D739}"=>"\u03B4",
    "\u{1D73A}"=>"\u03B5",
    "\u{1D73B}"=>"\u03B6",
    "\u{1D73C}"=>"\u03B7",
    "\u{1D73D}"=>"\u03B8",
    "\u{1D73E}"=>"\u03B9",
    "\u{1D73F}"=>"\u03BA",
    "\u{1D740}"=>"\u03BB",
    "\u{1D741}"=>"\u03BC",
    "\u{1D742}"=>"\u03BD",
    "\u{1D743}"=>"\u03BE",
    "\u{1D744}"=>"\u03BF",
    "\u{1D745}"=>"\u03C0",
    "\u{1D746}"=>"\u03C1",
    "\u{1D747}"=>"\u03C2",
    "\u{1D748}"=>"\u03C3",
    "\u{1D749}"=>"\u03C4",
    "\u{1D74A}"=>"\u03C5",
    "\u{1D74B}"=>"\u03C6",
    "\u{1D74C}"=>"\u03C7",
    "\u{1D74D}"=>"\u03C8",
    "\u{1D74E}"=>"\u03C9",
    "\u{1D74F}"=>"\u2202",
    "\u{1D750}"=>"\u03B5",
    "\u{1D751}"=>"\u03B8",
    "\u{1D752}"=>"\u03BA",
    "\u{1D753}"=>"\u03C6",
    "\u{1D754}"=>"\u03C1",
    "\u{1D755}"=>"\u03C0",
    "\u{1D756}"=>"\u0391",
    "\u{1D757}"=>"\u0392",
    "\u{1D758}"=>"\u0393",
    "\u{1D759}"=>"\u0394",
    "\u{1D75A}"=>"\u0395",
    "\u{1D75B}"=>"\u0396",
    "\u{1D75C}"=>"\u0397",
    "\u{1D75D}"=>"\u0398",
    "\u{1D75E}"=>"\u0399",
    "\u{1D75F}"=>"\u039A",
    "\u{1D760}"=>"\u039B",
    "\u{1D761}"=>"\u039C",
    "\u{1D762}"=>"\u039D",
    "\u{1D763}"=>"\u039E",
    "\u{1D764}"=>"\u039F",
    "\u{1D765}"=>"\u03A0",
    "\u{1D766}"=>"\u03A1",
    "\u{1D767}"=>"\u0398",
    "\u{1D768}"=>"\u03A3",
    "\u{1D769}"=>"\u03A4",
    "\u{1D76A}"=>"\u03A5",
    "\u{1D76B}"=>"\u03A6",
    "\u{1D76C}"=>"\u03A7",
    "\u{1D76D}"=>"\u03A8",
    "\u{1D76E}"=>"\u03A9",
    "\u{1D76F}"=>"\u2207",
    "\u{1D770}"=>"\u03B1",
    "\u{1D771}"=>"\u03B2",
    "\u{1D772}"=>"\u03B3",
    "\u{1D773}"=>"\u03B4",
    "\u{1D774}"=>"\u03B5",
    "\u{1D775}"=>"\u03B6",
    "\u{1D776}"=>"\u03B7",
    "\u{1D777}"=>"\u03B8",
    "\u{1D778}"=>"\u03B9",
    "\u{1D779}"=>"\u03BA",
    "\u{1D77A}"=>"\u03BB",
    "\u{1D77B}"=>"\u03BC",
    "\u{1D77C}"=>"\u03BD",
    "\u{1D77D}"=>"\u03BE",
    "\u{1D77E}"=>"\u03BF",
    "\u{1D77F}"=>"\u03C0",
    "\u{1D780}"=>"\u03C1",
    "\u{1D781}"=>"\u03C2",
    "\u{1D782}"=>"\u03C3",
    "\u{1D783}"=>"\u03C4",
    "\u{1D784}"=>"\u03C5",
    "\u{1D785}"=>"\u03C6",
    "\u{1D786}"=>"\u03C7",
    "\u{1D787}"=>"\u03C8",
    "\u{1D788}"=>"\u03C9",
    "\u{1D789}"=>"\u2202",
    "\u{1D78A}"=>"\u03B5",
    "\u{1D78B}"=>"\u03B8",
    "\u{1D78C}"=>"\u03BA",
    "\u{1D78D}"=>"\u03C6",
    "\u{1D78E}"=>"\u03C1",
    "\u{1D78F}"=>"\u03C0",
    "\u{1D790}"=>"\u0391",
    "\u{1D791}"=>"\u0392",
    "\u{1D792}"=>"\u0393",
    "\u{1D793}"=>"\u0394",
    "\u{1D794}"=>"\u0395",
    "\u{1D795}"=>"\u0396",
    "\u{1D796}"=>"\u0397",
    "\u{1D797}"=>"\u0398",
    "\u{1D798}"=>"\u0399",
    "\u{1D799}"=>"\u039A",
    "\u{1D79A}"=>"\u039B",
    "\u{1D79B}"=>"\u039C",
    "\u{1D79C}"=>"\u039D",
    "\u{1D79D}"=>"\u039E",
    "\u{1D79E}"=>"\u039F",
    "\u{1D79F}"=>"\u03A0",
    "\u{1D7A0}"=>"\u03A1",
    "\u{1D7A1}"=>"\u0398",
    "\u{1D7A2}"=>"\u03A3",
    "\u{1D7A3}"=>"\u03A4",
    "\u{1D7A4}"=>"\u03A5",
    "\u{1D7A5}"=>"\u03A6",
    "\u{1D7A6}"=>"\u03A7",
    "\u{1D7A7}"=>"\u03A8",
    "\u{1D7A8}"=>"\u03A9",
    "\u{1D7A9}"=>"\u2207",
    "\u{1D7AA}"=>"\u03B1",
    "\u{1D7AB}"=>"\u03B2",
    "\u{1D7AC}"=>"\u03B3",
    "\u{1D7AD}"=>"\u03B4",
    "\u{1D7AE}"=>"\u03B5",
    "\u{1D7AF}"=>"\u03B6",
    "\u{1D7B0}"=>"\u03B7",
    "\u{1D7B1}"=>"\u03B8",
    "\u{1D7B2}"=>"\u03B9",
    "\u{1D7B3}"=>"\u03BA",
    "\u{1D7B4}"=>"\u03BB",
    "\u{1D7B5}"=>"\u03BC",
    "\u{1D7B6}"=>"\u03BD",
    "\u{1D7B7}"=>"\u03BE",
    "\u{1D7B8}"=>"\u03BF",
    "\u{1D7B9}"=>"\u03C0",
    "\u{1D7BA}"=>"\u03C1",
    "\u{1D7BB}"=>"\u03C2",
    "\u{1D7BC}"=>"\u03C3",
    "\u{1D7BD}"=>"\u03C4",
    "\u{1D7BE}"=>"\u03C5",
    "\u{1D7BF}"=>"\u03C6",
    "\u{1D7C0}"=>"\u03C7",
    "\u{1D7C1}"=>"\u03C8",
    "\u{1D7C2}"=>"\u03C9",
    "\u{1D7C3}"=>"\u2202",
    "\u{1D7C4}"=>"\u03B5",
    "\u{1D7C5}"=>"\u03B8",
    "\u{1D7C6}"=>"\u03BA",
    "\u{1D7C7}"=>"\u03C6",
    "\u{1D7C8}"=>"\u03C1",
    "\u{1D7C9}"=>"\u03C0",
    "\u{1D7CA}"=>"\u03DC",
    "\u{1D7CB}"=>"\u03DD",
    "\u{1D7CE}"=>"0",
    "\u{1D7CF}"=>"1",
    "\u{1D7D0}"=>"2",
    "\u{1D7D1}"=>"3",
    "\u{1D7D2}"=>"4",
    "\u{1D7D3}"=>"5",
    "\u{1D7D4}"=>"6",
    "\u{1D7D5}"=>"7",
    "\u{1D7D6}"=>"8",
    "\u{1D7D7}"=>"9",
    "\u{1D7D8}"=>"0",
    "\u{1D7D9}"=>"1",
    "\u{1D7DA}"=>"2",
    "\u{1D7DB}"=>"3",
    "\u{1D7DC}"=>"4",
    "\u{1D7DD}"=>"5",
    "\u{1D7DE}"=>"6",
    "\u{1D7DF}"=>"7",
    "\u{1D7E0}"=>"8",
    "\u{1D7E1}"=>"9",
    "\u{1D7E2}"=>"0",
    "\u{1D7E3}"=>"1",
    "\u{1D7E4}"=>"2",
    "\u{1D7E5}"=>"3",
    "\u{1D7E6}"=>"4",
    "\u{1D7E7}"=>"5",
    "\u{1D7E8}"=>"6",
    "\u{1D7E9}"=>"7",
    "\u{1D7EA}"=>"8",
    "\u{1D7EB}"=>"9",
    "\u{1D7EC}"=>"0",
    "\u{1D7ED}"=>"1",
    "\u{1D7EE}"=>"2",
    "\u{1D7EF}"=>"3",
    "\u{1D7F0}"=>"4",
    "\u{1D7F1}"=>"5",
    "\u{1D7F2}"=>"6",
    "\u{1D7F3}"=>"7",
    "\u{1D7F4}"=>"8",
    "\u{1D7F5}"=>"9",
    "\u{1D7F6}"=>"0",
    "\u{1D7F7}"=>"1",
    "\u{1D7F8}"=>"2",
    "\u{1D7F9}"=>"3",
    "\u{1D7FA}"=>"4",
    "\u{1D7FB}"=>"5",
    "\u{1D7FC}"=>"6",
    "\u{1D7FD}"=>"7",
    "\u{1D7FE}"=>"8",
    "\u{1D7FF}"=>"9",
    "\u{1EE00}"=>"\u0627",
    "\u{1EE01}"=>"\u0628",
    "\u{1EE02}"=>"\u062C",
    "\u{1EE03}"=>"\u062F",
    "\u{1EE05}"=>"\u0648",
    "\u{1EE06}"=>"\u0632",
    "\u{1EE07}"=>"\u062D",
    "\u{1EE08}"=>"\u0637",
    "\u{1EE09}"=>"\u064A",
    "\u{1EE0A}"=>"\u0643",
    "\u{1EE0B}"=>"\u0644",
    "\u{1EE0C}"=>"\u0645",
    "\u{1EE0D}"=>"\u0646",
    "\u{1EE0E}"=>"\u0633",
    "\u{1EE0F}"=>"\u0639",
    "\u{1EE10}"=>"\u0641",
    "\u{1EE11}"=>"\u0635",
    "\u{1EE12}"=>"\u0642",
    "\u{1EE13}"=>"\u0631",
    "\u{1EE14}"=>"\u0634",
    "\u{1EE15}"=>"\u062A",
    "\u{1EE16}"=>"\u062B",
    "\u{1EE17}"=>"\u062E",
    "\u{1EE18}"=>"\u0630",
    "\u{1EE19}"=>"\u0636",
    "\u{1EE1A}"=>"\u0638",
    "\u{1EE1B}"=>"\u063A",
    "\u{1EE1C}"=>"\u066E",
    "\u{1EE1D}"=>"\u06BA",
    "\u{1EE1E}"=>"\u06A1",
    "\u{1EE1F}"=>"\u066F",
    "\u{1EE21}"=>"\u0628",
    "\u{1EE22}"=>"\u062C",
    "\u{1EE24}"=>"\u0647",
    "\u{1EE27}"=>"\u062D",
    "\u{1EE29}"=>"\u064A",
    "\u{1EE2A}"=>"\u0643",
    "\u{1EE2B}"=>"\u0644",
    "\u{1EE2C}"=>"\u0645",
    "\u{1EE2D}"=>"\u0646",
    "\u{1EE2E}"=>"\u0633",
    "\u{1EE2F}"=>"\u0639",
    "\u{1EE30}"=>"\u0641",
    "\u{1EE31}"=>"\u0635",
    "\u{1EE32}"=>"\u0642",
    "\u{1EE34}"=>"\u0634",
    "\u{1EE35}"=>"\u062A",
    "\u{1EE36}"=>"\u062B",
    "\u{1EE37}"=>"\u062E",
    "\u{1EE39}"=>"\u0636",
    "\u{1EE3B}"=>"\u063A",
    "\u{1EE42}"=>"\u062C",
    "\u{1EE47}"=>"\u062D",
    "\u{1EE49}"=>"\u064A",
    "\u{1EE4B}"=>"\u0644",
    "\u{1EE4D}"=>"\u0646",
    "\u{1EE4E}"=>"\u0633",
    "\u{1EE4F}"=>"\u0639",
    "\u{1EE51}"=>"\u0635",
    "\u{1EE52}"=>"\u0642",
    "\u{1EE54}"=>"\u0634",
    "\u{1EE57}"=>"\u062E",
    "\u{1EE59}"=>"\u0636",
    "\u{1EE5B}"=>"\u063A",
    "\u{1EE5D}"=>"\u06BA",
    "\u{1EE5F}"=>"\u066F",
    "\u{1EE61}"=>"\u0628",
    "\u{1EE62}"=>"\u062C",
    "\u{1EE64}"=>"\u0647",
    "\u{1EE67}"=>"\u062D",
    "\u{1EE68}"=>"\u0637",
    "\u{1EE69}"=>"\u064A",
    "\u{1EE6A}"=>"\u0643",
    "\u{1EE6C}"=>"\u0645",
    "\u{1EE6D}"=>"\u0646",
    "\u{1EE6E}"=>"\u0633",
    "\u{1EE6F}"=>"\u0639",
    "\u{1EE70}"=>"\u0641",
    "\u{1EE71}"=>"\u0635",
    "\u{1EE72}"=>"\u0642",
    "\u{1EE74}"=>"\u0634",
    "\u{1EE75}"=>"\u062A",
    "\u{1EE76}"=>"\u062B",
    "\u{1EE77}"=>"\u062E",
    "\u{1EE79}"=>"\u0636",
    "\u{1EE7A}"=>"\u0638",
    "\u{1EE7B}"=>"\u063A",
    "\u{1EE7C}"=>"\u066E",
    "\u{1EE7E}"=>"\u06A1",
    "\u{1EE80}"=>"\u0627",
    "\u{1EE81}"=>"\u0628",
    "\u{1EE82}"=>"\u062C",
    "\u{1EE83}"=>"\u062F",
    "\u{1EE84}"=>"\u0647",
    "\u{1EE85}"=>"\u0648",
    "\u{1EE86}"=>"\u0632",
    "\u{1EE87}"=>"\u062D",
    "\u{1EE88}"=>"\u0637",
    "\u{1EE89}"=>"\u064A",
    "\u{1EE8B}"=>"\u0644",
    "\u{1EE8C}"=>"\u0645",
    "\u{1EE8D}"=>"\u0646",
    "\u{1EE8E}"=>"\u0633",
    "\u{1EE8F}"=>"\u0639",
    "\u{1EE90}"=>"\u0641",
    "\u{1EE91}"=>"\u0635",
    "\u{1EE92}"=>"\u0642",
    "\u{1EE93}"=>"\u0631",
    "\u{1EE94}"=>"\u0634",
    "\u{1EE95}"=>"\u062A",
    "\u{1EE96}"=>"\u062B",
    "\u{1EE97}"=>"\u062E",
    "\u{1EE98}"=>"\u0630",
    "\u{1EE99}"=>"\u0636",
    "\u{1EE9A}"=>"\u0638",
    "\u{1EE9B}"=>"\u063A",
    "\u{1EEA1}"=>"\u0628",
    "\u{1EEA2}"=>"\u062C",
    "\u{1EEA3}"=>"\u062F",
    "\u{1EEA5}"=>"\u0648",
    "\u{1EEA6}"=>"\u0632",
    "\u{1EEA7}"=>"\u062D",
    "\u{1EEA8}"=>"\u0637",
    "\u{1EEA9}"=>"\u064A",
    "\u{1EEAB}"=>"\u0644",
    "\u{1EEAC}"=>"\u0645",
    "\u{1EEAD}"=>"\u0646",
    "\u{1EEAE}"=>"\u0633",
    "\u{1EEAF}"=>"\u0639",
    "\u{1EEB0}"=>"\u0641",
    "\u{1EEB1}"=>"\u0635",
    "\u{1EEB2}"=>"\u0642",
    "\u{1EEB3}"=>"\u0631",
    "\u{1EEB4}"=>"\u0634",
    "\u{1EEB5}"=>"\u062A",
    "\u{1EEB6}"=>"\u062B",
    "\u{1EEB7}"=>"\u062E",
    "\u{1EEB8}"=>"\u0630",
    "\u{1EEB9}"=>"\u0636",
    "\u{1EEBA}"=>"\u0638",
    "\u{1EEBB}"=>"\u063A",
    "\u{1F100}"=>"0.",
    "\u{1F101}"=>"0,",
    "\u{1F102}"=>"1,",
    "\u{1F103}"=>"2,",
    "\u{1F104}"=>"3,",
    "\u{1F105}"=>"4,",
    "\u{1F106}"=>"5,",
    "\u{1F107}"=>"6,",
    "\u{1F108}"=>"7,",
    "\u{1F109}"=>"8,",
    "\u{1F10A}"=>"9,",
    "\u{1F110}"=>"(A)",
    "\u{1F111}"=>"(B)",
    "\u{1F112}"=>"(C)",
    "\u{1F113}"=>"(D)",
    "\u{1F114}"=>"(E)",
    "\u{1F115}"=>"(F)",
    "\u{1F116}"=>"(G)",
    "\u{1F117}"=>"(H)",
    "\u{1F118}"=>"(I)",
    "\u{1F119}"=>"(J)",
    "\u{1F11A}"=>"(K)",
    "\u{1F11B}"=>"(L)",
    "\u{1F11C}"=>"(M)",
    "\u{1F11D}"=>"(N)",
    "\u{1F11E}"=>"(O)",
    "\u{1F11F}"=>"(P)",
    "\u{1F120}"=>"(Q)",
    "\u{1F121}"=>"(R)",
    "\u{1F122}"=>"(S)",
    "\u{1F123}"=>"(T)",
    "\u{1F124}"=>"(U)",
    "\u{1F125}"=>"(V)",
    "\u{1F126}"=>"(W)",
    "\u{1F127}"=>"(X)",
    "\u{1F128}"=>"(Y)",
    "\u{1F129}"=>"(Z)",
    "\u{1F12A}"=>"\u3014S\u3015",
    "\u{1F12B}"=>"C",
    "\u{1F12C}"=>"R",
    "\u{1F12D}"=>"CD",
    "\u{1F12E}"=>"WZ",
    "\u{1F130}"=>"A",
    "\u{1F131}"=>"B",
    "\u{1F132}"=>"C",
    "\u{1F133}"=>"D",
    "\u{1F134}"=>"E",
    "\u{1F135}"=>"F",
    "\u{1F136}"=>"G",
    "\u{1F137}"=>"H",
    "\u{1F138}"=>"I",
    "\u{1F139}"=>"J",
    "\u{1F13A}"=>"K",
    "\u{1F13B}"=>"L",
    "\u{1F13C}"=>"M",
    "\u{1F13D}"=>"N",
    "\u{1F13E}"=>"O",
    "\u{1F13F}"=>"P",
    "\u{1F140}"=>"Q",
    "\u{1F141}"=>"R",
    "\u{1F142}"=>"S",
    "\u{1F143}"=>"T",
    "\u{1F144}"=>"U",
    "\u{1F145}"=>"V",
    "\u{1F146}"=>"W",
    "\u{1F147}"=>"X",
    "\u{1F148}"=>"Y",
    "\u{1F149}"=>"Z",
    "\u{1F14A}"=>"HV",
    "\u{1F14B}"=>"MV",
    "\u{1F14C}"=>"SD",
    "\u{1F14D}"=>"SS",
    "\u{1F14E}"=>"PPV",
    "\u{1F14F}"=>"WC",
    "\u{1F16A}"=>"MC",
    "\u{1F16B}"=>"MD",
    "\u{1F16C}"=>"MR",
    "\u{1F190}"=>"DJ",
    "\u{1F200}"=>"\u307B\u304B",
    "\u{1F201}"=>"\u30B3\u30B3",
    "\u{1F202}"=>"\u30B5",
    "\u{1F210}"=>"\u624B",
    "\u{1F211}"=>"\u5B57",
    "\u{1F212}"=>"\u53CC",
    "\u{1F213}"=>"\u30C7",
    "\u{1F214}"=>"\u4E8C",
    "\u{1F215}"=>"\u591A",
    "\u{1F216}"=>"\u89E3",
    "\u{1F217}"=>"\u5929",
    "\u{1F218}"=>"\u4EA4",
    "\u{1F219}"=>"\u6620",
    "\u{1F21A}"=>"\u7121",
    "\u{1F21B}"=>"\u6599",
    "\u{1F21C}"=>"\u524D",
    "\u{1F21D}"=>"\u5F8C",
    "\u{1F21E}"=>"\u518D",
    "\u{1F21F}"=>"\u65B0",
    "\u{1F220}"=>"\u521D",
    "\u{1F221}"=>"\u7D42",
    "\u{1F222}"=>"\u751F",
    "\u{1F223}"=>"\u8CA9",
    "\u{1F224}"=>"\u58F0",
    "\u{1F225}"=>"\u5439",
    "\u{1F226}"=>"\u6F14",
    "\u{1F227}"=>"\u6295",
    "\u{1F228}"=>"\u6355",
    "\u{1F229}"=>"\u4E00",
    "\u{1F22A}"=>"\u4E09",
    "\u{1F22B}"=>"\u904A",
    "\u{1F22C}"=>"\u5DE6",
    "\u{1F22D}"=>"\u4E2D",
    "\u{1F22E}"=>"\u53F3",
    "\u{1F22F}"=>"\u6307",
    "\u{1F230}"=>"\u8D70",
    "\u{1F231}"=>"\u6253",
    "\u{1F232}"=>"\u7981",
    "\u{1F233}"=>"\u7A7A",
    "\u{1F234}"=>"\u5408",
    "\u{1F235}"=>"\u6E80",
    "\u{1F236}"=>"\u6709",
    "\u{1F237}"=>"\u6708",
    "\u{1F238}"=>"\u7533",
    "\u{1F239}"=>"\u5272",
    "\u{1F23A}"=>"\u55B6",
    "\u{1F23B}"=>"\u914D",
    "\u{1F240}"=>"\u3014\u672C\u3015",
    "\u{1F241}"=>"\u3014\u4E09\u3015",
    "\u{1F242}"=>"\u3014\u4E8C\u3015",
    "\u{1F243}"=>"\u3014\u5B89\u3015",
    "\u{1F244}"=>"\u3014\u70B9\u3015",
    "\u{1F245}"=>"\u3014\u6253\u3015",
    "\u{1F246}"=>"\u3014\u76D7\u3015",
    "\u{1F247}"=>"\u3014\u52DD\u3015",
    "\u{1F248}"=>"\u3014\u6557\u3015",
    "\u{1F250}"=>"\u5F97",
    "\u{1F251}"=>"\u53EF",
    "\u0385"=>" \u0308\u0301",
    "\u03D3"=>"\u03A5\u0301",
    "\u03D4"=>"\u03A5\u0308",
    "\u1E9B"=>"s\u0307",
    "\u1FC1"=>" \u0308\u0342",
    "\u1FCD"=>" \u0313\u0300",
    "\u1FCE"=>" \u0313\u0301",
    "\u1FCF"=>" \u0313\u0342",
    "\u1FDD"=>" \u0314\u0300",
    "\u1FDE"=>" \u0314\u0301",
    "\u1FDF"=>" \u0314\u0342",
    "\u1FED"=>" \u0308\u0300",
    "\u1FEE"=>" \u0308\u0301",
    "\u1FFD"=>" \u0301",
    "\u2000"=>" ",
    "\u2001"=>" ",
  }.freeze

  COMPOSITION_TABLE = {
    "A\u0300"=>"\u00C0",
    "A\u0301"=>"\u00C1",
    "A\u0302"=>"\u00C2",
    "A\u0303"=>"\u00C3",
    "A\u0308"=>"\u00C4",
    "A\u030A"=>"\u00C5",
    "C\u0327"=>"\u00C7",
    "E\u0300"=>"\u00C8",
    "E\u0301"=>"\u00C9",
    "E\u0302"=>"\u00CA",
    "E\u0308"=>"\u00CB",
    "I\u0300"=>"\u00CC",
    "I\u0301"=>"\u00CD",
    "I\u0302"=>"\u00CE",
    "I\u0308"=>"\u00CF",
    "N\u0303"=>"\u00D1",
    "O\u0300"=>"\u00D2",
    "O\u0301"=>"\u00D3",
    "O\u0302"=>"\u00D4",
    "O\u0303"=>"\u00D5",
    "O\u0308"=>"\u00D6",
    "U\u0300"=>"\u00D9",
    "U\u0301"=>"\u00DA",
    "U\u0302"=>"\u00DB",
    "U\u0308"=>"\u00DC",
    "Y\u0301"=>"\u00DD",
    "a\u0300"=>"\u00E0",
    "a\u0301"=>"\u00E1",
    "a\u0302"=>"\u00E2",
    "a\u0303"=>"\u00E3",
    "a\u0308"=>"\u00E4",
    "a\u030A"=>"\u00E5",
    "c\u0327"=>"\u00E7",
    "e\u0300"=>"\u00E8",
    "e\u0301"=>"\u00E9",
    "e\u0302"=>"\u00EA",
    "e\u0308"=>"\u00EB",
    "i\u0300"=>"\u00EC",
    "i\u0301"=>"\u00ED",
    "i\u0302"=>"\u00EE",
    "i\u0308"=>"\u00EF",
    "n\u0303"=>"\u00F1",
    "o\u0300"=>"\u00F2",
    "o\u0301"=>"\u00F3",
    "o\u0302"=>"\u00F4",
    "o\u0303"=>"\u00F5",
    "o\u0308"=>"\u00F6",
    "u\u0300"=>"\u00F9",
    "u\u0301"=>"\u00FA",
    "u\u0302"=>"\u00FB",
    "u\u0308"=>"\u00FC",
    "y\u0301"=>"\u00FD",
    "y\u0308"=>"\u00FF",
    "A\u0304"=>"\u0100",
    "a\u0304"=>"\u0101",
    "A\u0306"=>"\u0102",
    "a\u0306"=>"\u0103",
    "A\u0328"=>"\u0104",
    "a\u0328"=>"\u0105",
    "C\u0301"=>"\u0106",
    "c\u0301"=>"\u0107",
    "C\u0302"=>"\u0108",
    "c\u0302"=>"\u0109",
    "C\u0307"=>"\u010A",
    "c\u0307"=>"\u010B",
    "C\u030C"=>"\u010C",
    "c\u030C"=>"\u010D",
    "D\u030C"=>"\u010E",
    "d\u030C"=>"\u010F",
    "E\u0304"=>"\u0112",
    "e\u0304"=>"\u0113",
    "E\u0306"=>"\u0114",
    "e\u0306"=>"\u0115",
    "E\u0307"=>"\u0116",
    "e\u0307"=>"\u0117",
    "E\u0328"=>"\u0118",
    "e\u0328"=>"\u0119",
    "E\u030C"=>"\u011A",
    "e\u030C"=>"\u011B",
    "G\u0302"=>"\u011C",
    "g\u0302"=>"\u011D",
    "G\u0306"=>"\u011E",
    "g\u0306"=>"\u011F",
    "G\u0307"=>"\u0120",
    "g\u0307"=>"\u0121",
    "G\u0327"=>"\u0122",
    "g\u0327"=>"\u0123",
    "H\u0302"=>"\u0124",
    "h\u0302"=>"\u0125",
    "I\u0303"=>"\u0128",
    "i\u0303"=>"\u0129",
    "I\u0304"=>"\u012A",
    "i\u0304"=>"\u012B",
    "I\u0306"=>"\u012C",
    "i\u0306"=>"\u012D",
    "I\u0328"=>"\u012E",
    "i\u0328"=>"\u012F",
    "I\u0307"=>"\u0130",
    "J\u0302"=>"\u0134",
    "j\u0302"=>"\u0135",
    "K\u0327"=>"\u0136",
    "k\u0327"=>"\u0137",
    "L\u0301"=>"\u0139",
    "l\u0301"=>"\u013A",
    "L\u0327"=>"\u013B",
    "l\u0327"=>"\u013C",
    "L\u030C"=>"\u013D",
    "l\u030C"=>"\u013E",
    "N\u0301"=>"\u0143",
    "n\u0301"=>"\u0144",
    "N\u0327"=>"\u0145",
    "n\u0327"=>"\u0146",
    "N\u030C"=>"\u0147",
    "n\u030C"=>"\u0148",
    "O\u0304"=>"\u014C",
    "o\u0304"=>"\u014D",
    "O\u0306"=>"\u014E",
    "o\u0306"=>"\u014F",
    "O\u030B"=>"\u0150",
    "o\u030B"=>"\u0151",
    "R\u0301"=>"\u0154",
    "r\u0301"=>"\u0155",
    "R\u0327"=>"\u0156",
    "r\u0327"=>"\u0157",
    "R\u030C"=>"\u0158",
    "r\u030C"=>"\u0159",
    "S\u0301"=>"\u015A",
    "s\u0301"=>"\u015B",
    "S\u0302"=>"\u015C",
    "s\u0302"=>"\u015D",
    "S\u0327"=>"\u015E",
    "s\u0327"=>"\u015F",
    "S\u030C"=>"\u0160",
    "s\u030C"=>"\u0161",
    "T\u0327"=>"\u0162",
    "t\u0327"=>"\u0163",
    "T\u030C"=>"\u0164",
    "t\u030C"=>"\u0165",
    "U\u0303"=>"\u0168",
    "u\u0303"=>"\u0169",
    "U\u0304"=>"\u016A",
    "u\u0304"=>"\u016B",
    "U\u0306"=>"\u016C",
    "u\u0306"=>"\u016D",
    "U\u030A"=>"\u016E",
    "u\u030A"=>"\u016F",
    "U\u030B"=>"\u0170",
    "u\u030B"=>"\u0171",
    "U\u0328"=>"\u0172",
    "u\u0328"=>"\u0173",
    "W\u0302"=>"\u0174",
    "w\u0302"=>"\u0175",
    "Y\u0302"=>"\u0176",
    "y\u0302"=>"\u0177",
    "Y\u0308"=>"\u0178",
    "Z\u0301"=>"\u0179",
    "z\u0301"=>"\u017A",
    "Z\u0307"=>"\u017B",
    "z\u0307"=>"\u017C",
    "Z\u030C"=>"\u017D",
    "z\u030C"=>"\u017E",
    "O\u031B"=>"\u01A0",
    "o\u031B"=>"\u01A1",
    "U\u031B"=>"\u01AF",
    "u\u031B"=>"\u01B0",
    "A\u030C"=>"\u01CD",
    "a\u030C"=>"\u01CE",
    "I\u030C"=>"\u01CF",
    "i\u030C"=>"\u01D0",
    "O\u030C"=>"\u01D1",
    "o\u030C"=>"\u01D2",
    "U\u030C"=>"\u01D3",
    "u\u030C"=>"\u01D4",
    "\u00DC\u0304"=>"\u01D5",
    "\u00FC\u0304"=>"\u01D6",
    "\u00DC\u0301"=>"\u01D7",
    "\u00FC\u0301"=>"\u01D8",
    "\u00DC\u030C"=>"\u01D9",
    "\u00FC\u030C"=>"\u01DA",
    "\u00DC\u0300"=>"\u01DB",
    "\u00FC\u0300"=>"\u01DC",
    "\u00C4\u0304"=>"\u01DE",
    "\u00E4\u0304"=>"\u01DF",
    "\u0226\u0304"=>"\u01E0",
    "\u0227\u0304"=>"\u01E1",
    "\u00C6\u0304"=>"\u01E2",
    "\u00E6\u0304"=>"\u01E3",
    "G\u030C"=>"\u01E6",
    "g\u030C"=>"\u01E7",
    "K\u030C"=>"\u01E8",
    "k\u030C"=>"\u01E9",
    "O\u0328"=>"\u01EA",
    "o\u0328"=>"\u01EB",
    "\u01EA\u0304"=>"\u01EC",
    "\u01EB\u0304"=>"\u01ED",
    "\u01B7\u030C"=>"\u01EE",
    "\u0292\u030C"=>"\u01EF",
    "j\u030C"=>"\u01F0",
    "G\u0301"=>"\u01F4",
    "g\u0301"=>"\u01F5",
    "N\u0300"=>"\u01F8",
    "n\u0300"=>"\u01F9",
    "\u00C5\u0301"=>"\u01FA",
    "\u00E5\u0301"=>"\u01FB",
    "\u00C6\u0301"=>"\u01FC",
    "\u00E6\u0301"=>"\u01FD",
    "\u00D8\u0301"=>"\u01FE",
    "\u00F8\u0301"=>"\u01FF",
    "A\u030F"=>"\u0200",
    "a\u030F"=>"\u0201",
    "A\u0311"=>"\u0202",
    "a\u0311"=>"\u0203",
    "E\u030F"=>"\u0204",
    "e\u030F"=>"\u0205",
    "E\u0311"=>"\u0206",
    "e\u0311"=>"\u0207",
    "I\u030F"=>"\u0208",
    "i\u030F"=>"\u0209",
    "I\u0311"=>"\u020A",
    "i\u0311"=>"\u020B",
    "O\u030F"=>"\u020C",
    "o\u030F"=>"\u020D",
    "O\u0311"=>"\u020E",
    "o\u0311"=>"\u020F",
    "R\u030F"=>"\u0210",
    "r\u030F"=>"\u0211",
    "R\u0311"=>"\u0212",
    "r\u0311"=>"\u0213",
    "U\u030F"=>"\u0214",
    "u\u030F"=>"\u0215",
    "U\u0311"=>"\u0216",
    "u\u0311"=>"\u0217",
    "S\u0326"=>"\u0218",
    "s\u0326"=>"\u0219",
    "T\u0326"=>"\u021A",
    "t\u0326"=>"\u021B",
    "H\u030C"=>"\u021E",
    "h\u030C"=>"\u021F",
    "A\u0307"=>"\u0226",
    "a\u0307"=>"\u0227",
    "E\u0327"=>"\u0228",
    "e\u0327"=>"\u0229",
    "\u00D6\u0304"=>"\u022A",
    "\u00F6\u0304"=>"\u022B",
    "\u00D5\u0304"=>"\u022C",
    "\u00F5\u0304"=>"\u022D",
    "O\u0307"=>"\u022E",
    "o\u0307"=>"\u022F",
    "\u022E\u0304"=>"\u0230",
    "\u022F\u0304"=>"\u0231",
    "Y\u0304"=>"\u0232",
    "y\u0304"=>"\u0233",
    "\u00A8\u0301"=>"\u0385",
    "\u0391\u0301"=>"\u0386",
    "\u0395\u0301"=>"\u0388",
    "\u0397\u0301"=>"\u0389",
    "\u0399\u0301"=>"\u038A",
    "\u039F\u0301"=>"\u038C",
    "\u03A5\u0301"=>"\u038E",
    "\u03A9\u0301"=>"\u038F",
    "\u03CA\u0301"=>"\u0390",
    "\u0399\u0308"=>"\u03AA",
    "\u03A5\u0308"=>"\u03AB",
    "\u03B1\u0301"=>"\u03AC",
    "\u03B5\u0301"=>"\u03AD",
    "\u03B7\u0301"=>"\u03AE",
    "\u03B9\u0301"=>"\u03AF",
    "\u03CB\u0301"=>"\u03B0",
    "\u03B9\u0308"=>"\u03CA",
    "\u03C5\u0308"=>"\u03CB",
    "\u03BF\u0301"=>"\u03CC",
    "\u03C5\u0301"=>"\u03CD",
    "\u03C9\u0301"=>"\u03CE",
    "\u03D2\u0301"=>"\u03D3",
    "\u03D2\u0308"=>"\u03D4",
    "\u0415\u0300"=>"\u0400",
    "\u0415\u0308"=>"\u0401",
    "\u0413\u0301"=>"\u0403",
    "\u0406\u0308"=>"\u0407",
    "\u041A\u0301"=>"\u040C",
    "\u0418\u0300"=>"\u040D",
    "\u0423\u0306"=>"\u040E",
    "\u0418\u0306"=>"\u0419",
    "\u0438\u0306"=>"\u0439",
    "\u0435\u0300"=>"\u0450",
    "\u0435\u0308"=>"\u0451",
    "\u0433\u0301"=>"\u0453",
    "\u0456\u0308"=>"\u0457",
    "\u043A\u0301"=>"\u045C",
    "\u0438\u0300"=>"\u045D",
    "\u0443\u0306"=>"\u045E",
    "\u0474\u030F"=>"\u0476",
    "\u0475\u030F"=>"\u0477",
    "\u0416\u0306"=>"\u04C1",
    "\u0436\u0306"=>"\u04C2",
    "\u0410\u0306"=>"\u04D0",
    "\u0430\u0306"=>"\u04D1",
    "\u0410\u0308"=>"\u04D2",
    "\u0430\u0308"=>"\u04D3",
    "\u0415\u0306"=>"\u04D6",
    "\u0435\u0306"=>"\u04D7",
    "\u04D8\u0308"=>"\u04DA",
    "\u04D9\u0308"=>"\u04DB",
    "\u0416\u0308"=>"\u04DC",
    "\u0436\u0308"=>"\u04DD",
    "\u0417\u0308"=>"\u04DE",
    "\u0437\u0308"=>"\u04DF",
    "\u0418\u0304"=>"\u04E2",
    "\u0438\u0304"=>"\u04E3",
    "\u0418\u0308"=>"\u04E4",
    "\u0438\u0308"=>"\u04E5",
    "\u041E\u0308"=>"\u04E6",
    "\u043E\u0308"=>"\u04E7",
    "\u04E8\u0308"=>"\u04EA",
    "\u04E9\u0308"=>"\u04EB",
    "\u042D\u0308"=>"\u04EC",
    "\u044D\u0308"=>"\u04ED",
    "\u0423\u0304"=>"\u04EE",
    "\u0443\u0304"=>"\u04EF",
    "\u0423\u0308"=>"\u04F0",
    "\u0443\u0308"=>"\u04F1",
    "\u0423\u030B"=>"\u04F2",
    "\u0443\u030B"=>"\u04F3",
    "\u0427\u0308"=>"\u04F4",
    "\u0447\u0308"=>"\u04F5",
    "\u042B\u0308"=>"\u04F8",
    "\u044B\u0308"=>"\u04F9",
    "\u0627\u0653"=>"\u0622",
    "\u0627\u0654"=>"\u0623",
    "\u0648\u0654"=>"\u0624",
    "\u0627\u0655"=>"\u0625",
    "\u064A\u0654"=>"\u0626",
    "\u06D5\u0654"=>"\u06C0",
    "\u06C1\u0654"=>"\u06C2",
    "\u06D2\u0654"=>"\u06D3",
    "\u0928\u093C"=>"\u0929",
    "\u0930\u093C"=>"\u0931",
    "\u0933\u093C"=>"\u0934",
    "\u09C7\u09BE"=>"\u09CB",
    "\u09C7\u09D7"=>"\u09CC",
    "\u0B47\u0B56"=>"\u0B48",
    "\u0B47\u0B3E"=>"\u0B4B",
    "\u0B47\u0B57"=>"\u0B4C",
    "\u0B92\u0BD7"=>"\u0B94",
    "\u0BC6\u0BBE"=>"\u0BCA",
    "\u0BC7\u0BBE"=>"\u0BCB",
    "\u0BC6\u0BD7"=>"\u0BCC",
    "\u0C46\u0C56"=>"\u0C48",
    "\u0CBF\u0CD5"=>"\u0CC0",
    "\u0CC6\u0CD5"=>"\u0CC7",
    "\u0CC6\u0CD6"=>"\u0CC8",
    "\u0CC6\u0CC2"=>"\u0CCA",
    "\u0CCA\u0CD5"=>"\u0CCB",
    "\u0D46\u0D3E"=>"\u0D4A",
    "\u0D47\u0D3E"=>"\u0D4B",
    "\u0D46\u0D57"=>"\u0D4C",
    "\u0DD9\u0DCA"=>"\u0DDA",
    "\u0DD9\u0DCF"=>"\u0DDC",
    "\u0DDC\u0DCA"=>"\u0DDD",
    "\u0DD9\u0DDF"=>"\u0DDE",
    "\u1025\u102E"=>"\u1026",
    "\u1B05\u1B35"=>"\u1B06",
    "\u1B07\u1B35"=>"\u1B08",
    "\u1B09\u1B35"=>"\u1B0A",
    "\u1B0B\u1B35"=>"\u1B0C",
    "\u1B0D\u1B35"=>"\u1B0E",
    "\u1B11\u1B35"=>"\u1B12",
    "\u1B3A\u1B35"=>"\u1B3B",
    "\u1B3C\u1B35"=>"\u1B3D",
    "\u1B3E\u1B35"=>"\u1B40",
    "\u1B3F\u1B35"=>"\u1B41",
    "\u1B42\u1B35"=>"\u1B43",
    "A\u0325"=>"\u1E00",
    "a\u0325"=>"\u1E01",
    "B\u0307"=>"\u1E02",
    "b\u0307"=>"\u1E03",
    "B\u0323"=>"\u1E04",
    "b\u0323"=>"\u1E05",
    "B\u0331"=>"\u1E06",
    "b\u0331"=>"\u1E07",
    "\u00C7\u0301"=>"\u1E08",
    "\u00E7\u0301"=>"\u1E09",
    "D\u0307"=>"\u1E0A",
    "d\u0307"=>"\u1E0B",
    "D\u0323"=>"\u1E0C",
    "d\u0323"=>"\u1E0D",
    "D\u0331"=>"\u1E0E",
    "d\u0331"=>"\u1E0F",
    "D\u0327"=>"\u1E10",
    "d\u0327"=>"\u1E11",
    "D\u032D"=>"\u1E12",
    "d\u032D"=>"\u1E13",
    "\u0112\u0300"=>"\u1E14",
    "\u0113\u0300"=>"\u1E15",
    "\u0112\u0301"=>"\u1E16",
    "\u0113\u0301"=>"\u1E17",
    "E\u032D"=>"\u1E18",
    "e\u032D"=>"\u1E19",
    "E\u0330"=>"\u1E1A",
    "e\u0330"=>"\u1E1B",
    "\u0228\u0306"=>"\u1E1C",
    "\u0229\u0306"=>"\u1E1D",
    "F\u0307"=>"\u1E1E",
    "f\u0307"=>"\u1E1F",
    "G\u0304"=>"\u1E20",
    "g\u0304"=>"\u1E21",
    "H\u0307"=>"\u1E22",
    "h\u0307"=>"\u1E23",
    "H\u0323"=>"\u1E24",
    "h\u0323"=>"\u1E25",
    "H\u0308"=>"\u1E26",
    "h\u0308"=>"\u1E27",
    "H\u0327"=>"\u1E28",
    "h\u0327"=>"\u1E29",
    "H\u032E"=>"\u1E2A",
    "h\u032E"=>"\u1E2B",
    "I\u0330"=>"\u1E2C",
    "i\u0330"=>"\u1E2D",
    "\u00CF\u0301"=>"\u1E2E",
    "\u00EF\u0301"=>"\u1E2F",
    "K\u0301"=>"\u1E30",
    "k\u0301"=>"\u1E31",
    "K\u0323"=>"\u1E32",
    "k\u0323"=>"\u1E33",
    "K\u0331"=>"\u1E34",
    "k\u0331"=>"\u1E35",
    "L\u0323"=>"\u1E36",
    "l\u0323"=>"\u1E37",
    "\u1E36\u0304"=>"\u1E38",
    "\u1E37\u0304"=>"\u1E39",
    "L\u0331"=>"\u1E3A",
    "l\u0331"=>"\u1E3B",
    "L\u032D"=>"\u1E3C",
    "l\u032D"=>"\u1E3D",
    "M\u0301"=>"\u1E3E",
    "m\u0301"=>"\u1E3F",
    "M\u0307"=>"\u1E40",
    "m\u0307"=>"\u1E41",
    "M\u0323"=>"\u1E42",
    "m\u0323"=>"\u1E43",
    "N\u0307"=>"\u1E44",
    "n\u0307"=>"\u1E45",
    "N\u0323"=>"\u1E46",
    "n\u0323"=>"\u1E47",
    "N\u0331"=>"\u1E48",
    "n\u0331"=>"\u1E49",
    "N\u032D"=>"\u1E4A",
    "n\u032D"=>"\u1E4B",
    "\u00D5\u0301"=>"\u1E4C",
    "\u00F5\u0301"=>"\u1E4D",
    "\u00D5\u0308"=>"\u1E4E",
    "\u00F5\u0308"=>"\u1E4F",
    "\u014C\u0300"=>"\u1E50",
    "\u014D\u0300"=>"\u1E51",
    "\u014C\u0301"=>"\u1E52",
    "\u014D\u0301"=>"\u1E53",
    "P\u0301"=>"\u1E54",
    "p\u0301"=>"\u1E55",
    "P\u0307"=>"\u1E56",
    "p\u0307"=>"\u1E57",
    "R\u0307"=>"\u1E58",
    "r\u0307"=>"\u1E59",
    "R\u0323"=>"\u1E5A",
    "r\u0323"=>"\u1E5B",
    "\u1E5A\u0304"=>"\u1E5C",
    "\u1E5B\u0304"=>"\u1E5D",
    "R\u0331"=>"\u1E5E",
    "r\u0331"=>"\u1E5F",
    "S\u0307"=>"\u1E60",
    "s\u0307"=>"\u1E61",
    "S\u0323"=>"\u1E62",
    "s\u0323"=>"\u1E63",
    "\u015A\u0307"=>"\u1E64",
    "\u015B\u0307"=>"\u1E65",
    "\u0160\u0307"=>"\u1E66",
    "\u0161\u0307"=>"\u1E67",
    "\u1E62\u0307"=>"\u1E68",
    "\u1E63\u0307"=>"\u1E69",
    "T\u0307"=>"\u1E6A",
    "t\u0307"=>"\u1E6B",
    "T\u0323"=>"\u1E6C",
    "t\u0323"=>"\u1E6D",
    "T\u0331"=>"\u1E6E",
    "t\u0331"=>"\u1E6F",
    "T\u032D"=>"\u1E70",
    "t\u032D"=>"\u1E71",
    "U\u0324"=>"\u1E72",
    "u\u0324"=>"\u1E73",
    "U\u0330"=>"\u1E74",
    "u\u0330"=>"\u1E75",
    "U\u032D"=>"\u1E76",
    "u\u032D"=>"\u1E77",
    "\u0168\u0301"=>"\u1E78",
    "\u0169\u0301"=>"\u1E79",
    "\u016A\u0308"=>"\u1E7A",
    "\u016B\u0308"=>"\u1E7B",
    "V\u0303"=>"\u1E7C",
    "v\u0303"=>"\u1E7D",
    "V\u0323"=>"\u1E7E",
    "v\u0323"=>"\u1E7F",
    "W\u0300"=>"\u1E80",
    "w\u0300"=>"\u1E81",
    "W\u0301"=>"\u1E82",
    "w\u0301"=>"\u1E83",
    "W\u0308"=>"\u1E84",
    "w\u0308"=>"\u1E85",
    "W\u0307"=>"\u1E86",
    "w\u0307"=>"\u1E87",
    "W\u0323"=>"\u1E88",
    "w\u0323"=>"\u1E89",
    "X\u0307"=>"\u1E8A",
    "x\u0307"=>"\u1E8B",
    "X\u0308"=>"\u1E8C",
    "x\u0308"=>"\u1E8D",
    "Y\u0307"=>"\u1E8E",
    "y\u0307"=>"\u1E8F",
    "Z\u0302"=>"\u1E90",
    "z\u0302"=>"\u1E91",
    "Z\u0323"=>"\u1E92",
    "z\u0323"=>"\u1E93",
    "Z\u0331"=>"\u1E94",
    "z\u0331"=>"\u1E95",
    "h\u0331"=>"\u1E96",
    "t\u0308"=>"\u1E97",
    "w\u030A"=>"\u1E98",
    "y\u030A"=>"\u1E99",
    "\u017F\u0307"=>"\u1E9B",
    "A\u0323"=>"\u1EA0",
    "a\u0323"=>"\u1EA1",
    "A\u0309"=>"\u1EA2",
    "a\u0309"=>"\u1EA3",
    "\u00C2\u0301"=>"\u1EA4",
    "\u00E2\u0301"=>"\u1EA5",
    "\u00C2\u0300"=>"\u1EA6",
    "\u00E2\u0300"=>"\u1EA7",
    "\u00C2\u0309"=>"\u1EA8",
    "\u00E2\u0309"=>"\u1EA9",
    "\u00C2\u0303"=>"\u1EAA",
    "\u00E2\u0303"=>"\u1EAB",
    "\u1EA0\u0302"=>"\u1EAC",
    "\u1EA1\u0302"=>"\u1EAD",
    "\u0102\u0301"=>"\u1EAE",
    "\u0103\u0301"=>"\u1EAF",
    "\u0102\u0300"=>"\u1EB0",
    "\u0103\u0300"=>"\u1EB1",
    "\u0102\u0309"=>"\u1EB2",
    "\u0103\u0309"=>"\u1EB3",
    "\u0102\u0303"=>"\u1EB4",
    "\u0103\u0303"=>"\u1EB5",
    "\u1EA0\u0306"=>"\u1EB6",
    "\u1EA1\u0306"=>"\u1EB7",
    "E\u0323"=>"\u1EB8",
    "e\u0323"=>"\u1EB9",
    "E\u0309"=>"\u1EBA",
    "e\u0309"=>"\u1EBB",
    "E\u0303"=>"\u1EBC",
    "e\u0303"=>"\u1EBD",
    "\u00CA\u0301"=>"\u1EBE",
    "\u00EA\u0301"=>"\u1EBF",
    "\u00CA\u0300"=>"\u1EC0",
    "\u00EA\u0300"=>"\u1EC1",
    "\u00CA\u0309"=>"\u1EC2",
    "\u00EA\u0309"=>"\u1EC3",
    "\u00CA\u0303"=>"\u1EC4",
    "\u00EA\u0303"=>"\u1EC5",
    "\u1EB8\u0302"=>"\u1EC6",
    "\u1EB9\u0302"=>"\u1EC7",
    "I\u0309"=>"\u1EC8",
    "i\u0309"=>"\u1EC9",
    "I\u0323"=>"\u1ECA",
    "i\u0323"=>"\u1ECB",
    "O\u0323"=>"\u1ECC",
    "o\u0323"=>"\u1ECD",
    "O\u0309"=>"\u1ECE",
    "o\u0309"=>"\u1ECF",
    "\u00D4\u0301"=>"\u1ED0",
    "\u00F4\u0301"=>"\u1ED1",
    "\u00D4\u0300"=>"\u1ED2",
    "\u00F4\u0300"=>"\u1ED3",
    "\u00D4\u0309"=>"\u1ED4",
    "\u00F4\u0309"=>"\u1ED5",
    "\u00D4\u0303"=>"\u1ED6",
    "\u00F4\u0303"=>"\u1ED7",
    "\u1ECC\u0302"=>"\u1ED8",
    "\u1ECD\u0302"=>"\u1ED9",
    "\u01A0\u0301"=>"\u1EDA",
    "\u01A1\u0301"=>"\u1EDB",
    "\u01A0\u0300"=>"\u1EDC",
    "\u01A1\u0300"=>"\u1EDD",
    "\u01A0\u0309"=>"\u1EDE",
    "\u01A1\u0309"=>"\u1EDF",
    "\u01A0\u0303"=>"\u1EE0",
    "\u01A1\u0303"=>"\u1EE1",
    "\u01A0\u0323"=>"\u1EE2",
    "\u01A1\u0323"=>"\u1EE3",
    "U\u0323"=>"\u1EE4",
    "u\u0323"=>"\u1EE5",
    "U\u0309"=>"\u1EE6",
    "u\u0309"=>"\u1EE7",
    "\u01AF\u0301"=>"\u1EE8",
    "\u01B0\u0301"=>"\u1EE9",
    "\u01AF\u0300"=>"\u1EEA",
    "\u01B0\u0300"=>"\u1EEB",
    "\u01AF\u0309"=>"\u1EEC",
    "\u01B0\u0309"=>"\u1EED",
    "\u01AF\u0303"=>"\u1EEE",
    "\u01B0\u0303"=>"\u1EEF",
    "\u01AF\u0323"=>"\u1EF0",
    "\u01B0\u0323"=>"\u1EF1",
    "Y\u0300"=>"\u1EF2",
    "y\u0300"=>"\u1EF3",
    "Y\u0323"=>"\u1EF4",
    "y\u0323"=>"\u1EF5",
    "Y\u0309"=>"\u1EF6",
    "y\u0309"=>"\u1EF7",
    "Y\u0303"=>"\u1EF8",
    "y\u0303"=>"\u1EF9",
    "\u03B1\u0313"=>"\u1F00",
    "\u03B1\u0314"=>"\u1F01",
    "\u1F00\u0300"=>"\u1F02",
    "\u1F01\u0300"=>"\u1F03",
    "\u1F00\u0301"=>"\u1F04",
    "\u1F01\u0301"=>"\u1F05",
    "\u1F00\u0342"=>"\u1F06",
    "\u1F01\u0342"=>"\u1F07",
    "\u0391\u0313"=>"\u1F08",
    "\u0391\u0314"=>"\u1F09",
    "\u1F08\u0300"=>"\u1F0A",
    "\u1F09\u0300"=>"\u1F0B",
    "\u1F08\u0301"=>"\u1F0C",
    "\u1F09\u0301"=>"\u1F0D",
    "\u1F08\u0342"=>"\u1F0E",
    "\u1F09\u0342"=>"\u1F0F",
    "\u03B5\u0313"=>"\u1F10",
    "\u03B5\u0314"=>"\u1F11",
    "\u1F10\u0300"=>"\u1F12",
    "\u1F11\u0300"=>"\u1F13",
    "\u1F10\u0301"=>"\u1F14",
    "\u1F11\u0301"=>"\u1F15",
    "\u0395\u0313"=>"\u1F18",
    "\u0395\u0314"=>"\u1F19",
    "\u1F18\u0300"=>"\u1F1A",
    "\u1F19\u0300"=>"\u1F1B",
    "\u1F18\u0301"=>"\u1F1C",
    "\u1F19\u0301"=>"\u1F1D",
    "\u03B7\u0313"=>"\u1F20",
    "\u03B7\u0314"=>"\u1F21",
    "\u1F20\u0300"=>"\u1F22",
    "\u1F21\u0300"=>"\u1F23",
    "\u1F20\u0301"=>"\u1F24",
    "\u1F21\u0301"=>"\u1F25",
    "\u1F20\u0342"=>"\u1F26",
    "\u1F21\u0342"=>"\u1F27",
    "\u0397\u0313"=>"\u1F28",
    "\u0397\u0314"=>"\u1F29",
    "\u1F28\u0300"=>"\u1F2A",
    "\u1F29\u0300"=>"\u1F2B",
    "\u1F28\u0301"=>"\u1F2C",
    "\u1F29\u0301"=>"\u1F2D",
    "\u1F28\u0342"=>"\u1F2E",
    "\u1F29\u0342"=>"\u1F2F",
    "\u03B9\u0313"=>"\u1F30",
    "\u03B9\u0314"=>"\u1F31",
    "\u1F30\u0300"=>"\u1F32",
    "\u1F31\u0300"=>"\u1F33",
    "\u1F30\u0301"=>"\u1F34",
    "\u1F31\u0301"=>"\u1F35",
    "\u1F30\u0342"=>"\u1F36",
    "\u1F31\u0342"=>"\u1F37",
    "\u0399\u0313"=>"\u1F38",
    "\u0399\u0314"=>"\u1F39",
    "\u1F38\u0300"=>"\u1F3A",
    "\u1F39\u0300"=>"\u1F3B",
    "\u1F38\u0301"=>"\u1F3C",
    "\u1F39\u0301"=>"\u1F3D",
    "\u1F38\u0342"=>"\u1F3E",
    "\u1F39\u0342"=>"\u1F3F",
    "\u03BF\u0313"=>"\u1F40",
    "\u03BF\u0314"=>"\u1F41",
    "\u1F40\u0300"=>"\u1F42",
    "\u1F41\u0300"=>"\u1F43",
    "\u1F40\u0301"=>"\u1F44",
    "\u1F41\u0301"=>"\u1F45",
    "\u039F\u0313"=>"\u1F48",
    "\u039F\u0314"=>"\u1F49",
    "\u1F48\u0300"=>"\u1F4A",
    "\u1F49\u0300"=>"\u1F4B",
    "\u1F48\u0301"=>"\u1F4C",
    "\u1F49\u0301"=>"\u1F4D",
    "\u03C5\u0313"=>"\u1F50",
    "\u03C5\u0314"=>"\u1F51",
    "\u1F50\u0300"=>"\u1F52",
    "\u1F51\u0300"=>"\u1F53",
    "\u1F50\u0301"=>"\u1F54",
    "\u1F51\u0301"=>"\u1F55",
    "\u1F50\u0342"=>"\u1F56",
    "\u1F51\u0342"=>"\u1F57",
    "\u03A5\u0314"=>"\u1F59",
    "\u1F59\u0300"=>"\u1F5B",
    "\u1F59\u0301"=>"\u1F5D",
    "\u1F59\u0342"=>"\u1F5F",
    "\u03C9\u0313"=>"\u1F60",
    "\u03C9\u0314"=>"\u1F61",
    "\u1F60\u0300"=>"\u1F62",
    "\u1F61\u0300"=>"\u1F63",
    "\u1F60\u0301"=>"\u1F64",
    "\u1F61\u0301"=>"\u1F65",
    "\u1F60\u0342"=>"\u1F66",
    "\u1F61\u0342"=>"\u1F67",
    "\u03A9\u0313"=>"\u1F68",
    "\u03A9\u0314"=>"\u1F69",
    "\u1F68\u0300"=>"\u1F6A",
    "\u1F69\u0300"=>"\u1F6B",
    "\u1F68\u0301"=>"\u1F6C",
    "\u1F69\u0301"=>"\u1F6D",
    "\u1F68\u0342"=>"\u1F6E",
    "\u1F69\u0342"=>"\u1F6F",
    "\u03B1\u0300"=>"\u1F70",
    "\u03B5\u0300"=>"\u1F72",
    "\u03B7\u0300"=>"\u1F74",
    "\u03B9\u0300"=>"\u1F76",
    "\u03BF\u0300"=>"\u1F78",
    "\u03C5\u0300"=>"\u1F7A",
    "\u03C9\u0300"=>"\u1F7C",
    "\u1F00\u0345"=>"\u1F80",
    "\u1F01\u0345"=>"\u1F81",
    "\u1F02\u0345"=>"\u1F82",
    "\u1F03\u0345"=>"\u1F83",
    "\u1F04\u0345"=>"\u1F84",
    "\u1F05\u0345"=>"\u1F85",
    "\u1F06\u0345"=>"\u1F86",
    "\u1F07\u0345"=>"\u1F87",
    "\u1F08\u0345"=>"\u1F88",
    "\u1F09\u0345"=>"\u1F89",
    "\u1F0A\u0345"=>"\u1F8A",
    "\u1F0B\u0345"=>"\u1F8B",
    "\u1F0C\u0345"=>"\u1F8C",
    "\u1F0D\u0345"=>"\u1F8D",
    "\u1F0E\u0345"=>"\u1F8E",
    "\u1F0F\u0345"=>"\u1F8F",
    "\u1F20\u0345"=>"\u1F90",
    "\u1F21\u0345"=>"\u1F91",
    "\u1F22\u0345"=>"\u1F92",
    "\u1F23\u0345"=>"\u1F93",
    "\u1F24\u0345"=>"\u1F94",
    "\u1F25\u0345"=>"\u1F95",
    "\u1F26\u0345"=>"\u1F96",
    "\u1F27\u0345"=>"\u1F97",
    "\u1F28\u0345"=>"\u1F98",
    "\u1F29\u0345"=>"\u1F99",
    "\u1F2A\u0345"=>"\u1F9A",
    "\u1F2B\u0345"=>"\u1F9B",
    "\u1F2C\u0345"=>"\u1F9C",
    "\u1F2D\u0345"=>"\u1F9D",
    "\u1F2E\u0345"=>"\u1F9E",
    "\u1F2F\u0345"=>"\u1F9F",
    "\u1F60\u0345"=>"\u1FA0",
    "\u1F61\u0345"=>"\u1FA1",
    "\u1F62\u0345"=>"\u1FA2",
    "\u1F63\u0345"=>"\u1FA3",
    "\u1F64\u0345"=>"\u1FA4",
    "\u1F65\u0345"=>"\u1FA5",
    "\u1F66\u0345"=>"\u1FA6",
    "\u1F67\u0345"=>"\u1FA7",
    "\u1F68\u0345"=>"\u1FA8",
    "\u1F69\u0345"=>"\u1FA9",
    "\u1F6A\u0345"=>"\u1FAA",
    "\u1F6B\u0345"=>"\u1FAB",
    "\u1F6C\u0345"=>"\u1FAC",
    "\u1F6D\u0345"=>"\u1FAD",
    "\u1F6E\u0345"=>"\u1FAE",
    "\u1F6F\u0345"=>"\u1FAF",
    "\u03B1\u0306"=>"\u1FB0",
    "\u03B1\u0304"=>"\u1FB1",
    "\u1F70\u0345"=>"\u1FB2",
    "\u03B1\u0345"=>"\u1FB3",
    "\u03AC\u0345"=>"\u1FB4",
    "\u03B1\u0342"=>"\u1FB6",
    "\u1FB6\u0345"=>"\u1FB7",
    "\u0391\u0306"=>"\u1FB8",
    "\u0391\u0304"=>"\u1FB9",
    "\u0391\u0300"=>"\u1FBA",
    "\u0391\u0345"=>"\u1FBC",
    "\u00A8\u0342"=>"\u1FC1",
    "\u1F74\u0345"=>"\u1FC2",
    "\u03B7\u0345"=>"\u1FC3",
    "\u03AE\u0345"=>"\u1FC4",
    "\u03B7\u0342"=>"\u1FC6",
    "\u1FC6\u0345"=>"\u1FC7",
    "\u0395\u0300"=>"\u1FC8",
    "\u0397\u0300"=>"\u1FCA",
    "\u0397\u0345"=>"\u1FCC",
    "\u1FBF\u0300"=>"\u1FCD",
    "\u1FBF\u0301"=>"\u1FCE",
    "\u1FBF\u0342"=>"\u1FCF",
    "\u03B9\u0306"=>"\u1FD0",
    "\u03B9\u0304"=>"\u1FD1",
    "\u03CA\u0300"=>"\u1FD2",
    "\u03B9\u0342"=>"\u1FD6",
    "\u03CA\u0342"=>"\u1FD7",
    "\u0399\u0306"=>"\u1FD8",
    "\u0399\u0304"=>"\u1FD9",
    "\u0399\u0300"=>"\u1FDA",
    "\u1FFE\u0300"=>"\u1FDD",
    "\u1FFE\u0301"=>"\u1FDE",
    "\u1FFE\u0342"=>"\u1FDF",
    "\u03C5\u0306"=>"\u1FE0",
    "\u03C5\u0304"=>"\u1FE1",
    "\u03CB\u0300"=>"\u1FE2",
    "\u03C1\u0313"=>"\u1FE4",
    "\u03C1\u0314"=>"\u1FE5",
    "\u03C5\u0342"=>"\u1FE6",
    "\u03CB\u0342"=>"\u1FE7",
    "\u03A5\u0306"=>"\u1FE8",
    "\u03A5\u0304"=>"\u1FE9",
    "\u03A5\u0300"=>"\u1FEA",
    "\u03A1\u0314"=>"\u1FEC",
    "\u00A8\u0300"=>"\u1FED",
    "\u1F7C\u0345"=>"\u1FF2",
    "\u03C9\u0345"=>"\u1FF3",
    "\u03CE\u0345"=>"\u1FF4",
    "\u03C9\u0342"=>"\u1FF6",
    "\u1FF6\u0345"=>"\u1FF7",
    "\u039F\u0300"=>"\u1FF8",
    "\u03A9\u0300"=>"\u1FFA",
    "\u03A9\u0345"=>"\u1FFC",
    "\u2190\u0338"=>"\u219A",
    "\u2192\u0338"=>"\u219B",
    "\u2194\u0338"=>"\u21AE",
    "\u21D0\u0338"=>"\u21CD",
    "\u21D4\u0338"=>"\u21CE",
    "\u21D2\u0338"=>"\u21CF",
    "\u2203\u0338"=>"\u2204",
    "\u2208\u0338"=>"\u2209",
    "\u220B\u0338"=>"\u220C",
    "\u2223\u0338"=>"\u2224",
    "\u2225\u0338"=>"\u2226",
    "\u223C\u0338"=>"\u2241",
    "\u2243\u0338"=>"\u2244",
    "\u2245\u0338"=>"\u2247",
    "\u2248\u0338"=>"\u2249",
    "=\u0338"=>"\u2260",
    "\u2261\u0338"=>"\u2262",
    "\u224D\u0338"=>"\u226D",
    "<\u0338"=>"\u226E",
    ">\u0338"=>"\u226F",
    "\u2264\u0338"=>"\u2270",
    "\u2265\u0338"=>"\u2271",
    "\u2272\u0338"=>"\u2274",
    "\u2273\u0338"=>"\u2275",
    "\u2276\u0338"=>"\u2278",
    "\u2277\u0338"=>"\u2279",
    "\u227A\u0338"=>"\u2280",
    "\u227B\u0338"=>"\u2281",
    "\u2282\u0338"=>"\u2284",
    "\u2283\u0338"=>"\u2285",
    "\u2286\u0338"=>"\u2288",
    "\u2287\u0338"=>"\u2289",
    "\u22A2\u0338"=>"\u22AC",
    "\u22A8\u0338"=>"\u22AD",
    "\u22A9\u0338"=>"\u22AE",
    "\u22AB\u0338"=>"\u22AF",
    "\u227C\u0338"=>"\u22E0",
    "\u227D\u0338"=>"\u22E1",
    "\u2291\u0338"=>"\u22E2",
    "\u2292\u0338"=>"\u22E3",
    "\u22B2\u0338"=>"\u22EA",
    "\u22B3\u0338"=>"\u22EB",
    "\u22B4\u0338"=>"\u22EC",
    "\u22B5\u0338"=>"\u22ED",
    "\u304B\u3099"=>"\u304C",
    "\u304D\u3099"=>"\u304E",
    "\u304F\u3099"=>"\u3050",
    "\u3051\u3099"=>"\u3052",
    "\u3053\u3099"=>"\u3054",
    "\u3055\u3099"=>"\u3056",
    "\u3057\u3099"=>"\u3058",
    "\u3059\u3099"=>"\u305A",
    "\u305B\u3099"=>"\u305C",
    "\u305D\u3099"=>"\u305E",
    "\u305F\u3099"=>"\u3060",
    "\u3061\u3099"=>"\u3062",
    "\u3064\u3099"=>"\u3065",
    "\u3066\u3099"=>"\u3067",
    "\u3068\u3099"=>"\u3069",
    "\u306F\u3099"=>"\u3070",
    "\u306F\u309A"=>"\u3071",
    "\u3072\u3099"=>"\u3073",
    "\u3072\u309A"=>"\u3074",
    "\u3075\u3099"=>"\u3076",
    "\u3075\u309A"=>"\u3077",
    "\u3078\u3099"=>"\u3079",
    "\u3078\u309A"=>"\u307A",
    "\u307B\u3099"=>"\u307C",
    "\u307B\u309A"=>"\u307D",
    "\u3046\u3099"=>"\u3094",
    "\u309D\u3099"=>"\u309E",
    "\u30AB\u3099"=>"\u30AC",
    "\u30AD\u3099"=>"\u30AE",
    "\u30AF\u3099"=>"\u30B0",
    "\u30B1\u3099"=>"\u30B2",
    "\u30B3\u3099"=>"\u30B4",
    "\u30B5\u3099"=>"\u30B6",
    "\u30B7\u3099"=>"\u30B8",
    "\u30B9\u3099"=>"\u30BA",
    "\u30BB\u3099"=>"\u30BC",
    "\u30BD\u3099"=>"\u30BE",
    "\u30BF\u3099"=>"\u30C0",
    "\u30C1\u3099"=>"\u30C2",
    "\u30C4\u3099"=>"\u30C5",
    "\u30C6\u3099"=>"\u30C7",
    "\u30C8\u3099"=>"\u30C9",
    "\u30CF\u3099"=>"\u30D0",
    "\u30CF\u309A"=>"\u30D1",
    "\u30D2\u3099"=>"\u30D3",
    "\u30D2\u309A"=>"\u30D4",
    "\u30D5\u3099"=>"\u30D6",
    "\u30D5\u309A"=>"\u30D7",
    "\u30D8\u3099"=>"\u30D9",
    "\u30D8\u309A"=>"\u30DA",
    "\u30DB\u3099"=>"\u30DC",
    "\u30DB\u309A"=>"\u30DD",
    "\u30A6\u3099"=>"\u30F4",
    "\u30EF\u3099"=>"\u30F7",
    "\u30F0\u3099"=>"\u30F8",
    "\u30F1\u3099"=>"\u30F9",
    "\u30F2\u3099"=>"\u30FA",
    "\u30FD\u3099"=>"\u30FE",
    "\u{11099}\u{110BA}"=>"\u{1109A}",
    "\u{1109B}\u{110BA}"=>"\u{1109C}",
    "\u{110A5}\u{110BA}"=>"\u{110AB}",
    "\u{11131}\u{11127}"=>"\u{1112E}",
    "\u{11132}\u{11127}"=>"\u{1112F}",
    "\u{11347}\u{1133E}"=>"\u{1134B}",
    "\u{11347}\u{11357}"=>"\u{1134C}",
    "\u{114B9}\u{114BA}"=>"\u{114BB}",
    "\u{114B9}\u{114B0}"=>"\u{114BC}",
    "\u{114B9}\u{114BD}"=>"\u{114BE}",
    "\u{115B8}\u{115AF}"=>"\u{115BA}",
    "\u{115B9}\u{115AF}"=>"\u{115BB}",
  }.freeze
end
