/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer;

import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public final class TracerProgressObject {
    private final int steps;
    private String text;
    private int currentStep;
    private int lastStep;
    private final Set<Listener> listeners;

    public TracerProgressObject(int n) {
        this(n, null);
    }

    public TracerProgressObject(int n, String string) {
        if (n < 1) {
            throw new IllegalArgumentException("steps value must be >= 1: " + n);
        }
        this.steps = n;
        this.text = string;
        this.currentStep = 0;
        this.lastStep = 0;
        this.listeners = new HashSet<Listener>();
    }

    public synchronized int getSteps() {
        return this.steps;
    }

    public synchronized int getCurrentStep() {
        return this.currentStep;
    }

    public synchronized String getText() {
        return this.text;
    }

    public void addStep() {
        this.addSteps(1);
    }

    public void addStep(String string) {
        this.addSteps(1, string);
    }

    public void addSteps(int n) {
        this.addSteps(n, this.text);
    }

    public synchronized void addSteps(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("steps value must be >= 0: " + n);
        }
        if (this.currentStep + n > this.steps) {
            throw new IllegalArgumentException("Total steps exceeded: " + (this.currentStep + n) + ">" + this.steps);
        }
        this.currentStep += n;
        this.text = string;
        this.fireChange();
    }

    public synchronized void setText(String string) {
        this.text = string;
        this.fireChange();
    }

    public synchronized void finish() {
        if (this.isFinished()) {
            return;
        }
        this.currentStep = this.steps;
        this.fireChange();
    }

    public synchronized boolean isFinished() {
        return this.currentStep == this.steps;
    }

    public synchronized void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireChange() {
        final int n = this.currentStep;
        final int n2 = this.currentStep - this.lastStep;
        final String string = this.text;
        final HashSet<Listener> hashSet = new HashSet<Listener>(this.listeners);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : hashSet) {
                    listener.progressChanged(n2, n, string);
                }
            }
        });
        this.lastStep = this.currentStep;
    }

    public static interface Listener {
        public void progressChanged(int var1, int var2, String var3);
    }
}

