/*
 * Decompiled with CFR 0.152.
 */
package org.linkgrammar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONReader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    public static final int FIRST = 0;
    public static final int CURRENT = 1;
    public static final int NEXT = 2;
    private static Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private StringBuffer buf = new StringBuffer();

    private void error(String msg) {
        throw new RuntimeException("JSON parse error near position " + this.it.getIndex() + ":" + msg);
    }

    private char next() {
        this.c = this.it.next();
        return this.c;
    }

    private char previous() {
        this.c = this.it.previous();
        return this.c;
    }

    private void skipWhiteSpace() {
        do {
            if (Character.isWhitespace(this.c)) continue;
            if (this.c != '/') break;
            this.next();
            if (this.c == '*') {
                while (this.c != '\uffff' && (this.next() != '*' || this.next() != '/')) {
                }
                if (this.c != '\uffff') continue;
                throw new RuntimeException("Unterminated comment while parsing JSON string.");
            }
            if (this.c == '/') {
                while (this.c != '\n' && this.c != '\uffff') {
                    this.next();
                }
            } else {
                this.previous();
                break;
            }
        } while (this.next() != '\uffff');
    }

    public Object read(CharacterIterator ci, int start) {
        this.it = ci;
        switch (start) {
            case 0: {
                this.c = this.it.first();
                break;
            }
            case 1: {
                this.c = this.it.current();
                break;
            }
            case 2: {
                this.c = this.it.next();
            }
        }
        return this.read();
    }

    public Object read(CharacterIterator it) {
        return this.read(it, 2);
    }

    public Object read(String string) {
        return this.read(new StringCharacterIterator(string), 0);
    }

    private Object read() {
        this.skipWhiteSpace();
        char ch = this.c;
        this.next();
        Object value = null;
        switch (ch) {
            case '\"': {
                value = this.string();
                break;
            }
            case '[': {
                value = this.array();
                break;
            }
            case ']': {
                value = ARRAY_END;
                break;
            }
            case ',': {
                value = COMMA;
                break;
            }
            case '{': {
                value = this.object();
                break;
            }
            case '}': {
                value = OBJECT_END;
                break;
            }
            case ':': {
                value = COLON;
                break;
            }
            case 't': {
                if (this.c != 'r' || this.next() != 'u' || this.next() != 'e') {
                    this.error("Invalid JSON token: expected 'true' keyword.");
                }
                this.next();
                value = Boolean.TRUE;
                break;
            }
            case 'f': {
                if (this.c != 'a' || this.next() != 'l' || this.next() != 's' || this.next() != 'e') {
                    this.error("Invalid JSON token: expected 'false' keyword.");
                }
                this.next();
                value = Boolean.FALSE;
                break;
            }
            case 'n': {
                if (this.c != 'u' || this.next() != 'l' || this.next() != 'l') {
                    this.error("Invalid JSON token: expected 'null' keyword.");
                }
                this.next();
                value = null;
                break;
            }
            default: {
                this.c = this.it.previous();
                if (Character.isDigit(this.c) || this.c == '-') {
                    value = this.number();
                    break;
                }
                this.error("Invalid character '" + this.c + "', expecting a JSON token.");
            }
        }
        return value;
    }

    private boolean isValue(Object x) {
        return x == null || x instanceof Boolean || x instanceof String || x instanceof Number || x instanceof Map || x instanceof List;
    }

    private Object object() {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Object key = this.read();
        while (key != OBJECT_END) {
            Object value;
            Object colon;
            if (!(key instanceof String)) {
                this.error("Expecting a string as key in object, but got '" + key + "'");
            }
            if ((colon = this.read()) != COLON) {
                this.error("Expecting a colon, but found '" + colon + "' after object key '" + key + "'");
            }
            if (!this.isValue(value = this.read())) {
                this.error("Unexpected value in object with key '" + key + "' -- '" + value + "', expecting boolean, number string, array or object.");
            }
            ret.put(key, value);
            key = this.read();
            if (key == COMMA) {
                key = this.read();
                continue;
            }
            if (key == OBJECT_END) continue;
            this.error("Unexpected token in object '" + key + "', expecting comma or }.");
        }
        return ret;
    }

    private Object array() {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object value = this.read();
        while (value != ARRAY_END) {
            if (!this.isValue(value)) {
                this.error("Unexpected value in array '" + value + "', expecting boolean, number string, array or object.");
            }
            ret.add(value);
            value = this.read();
            if (value == COMMA) {
                value = this.read();
                continue;
            }
            if (value == ARRAY_END) continue;
            this.error("Unexpected token in array '" + value + "', expecting comma or ].");
        }
        return ret;
    }

    private Object number() {
        int length = 0;
        boolean isFloatingPoint = false;
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add(this.c);
        }
        length += this.addDigits();
        if (this.c == '.') {
            this.add(this.c);
            length += this.addDigits();
            isFloatingPoint = true;
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add(this.c);
            if (this.c == '+' || this.c == '-') {
                this.add(this.c);
            }
            this.addDigits();
            isFloatingPoint = true;
        }
        String s = this.buf.toString();
        return isFloatingPoint ? (Number)(length < 17 ? Double.valueOf(s) : new BigDecimal(s)) : (Number)(length < 20 ? Long.valueOf(s) : new BigInteger(s));
    }

    private int addDigits() {
        int ret = 0;
        while (Character.isDigit(this.c)) {
            this.add(this.c);
            ++ret;
        }
        return ret;
    }

    private Object string() {
        this.buf.setLength(0);
        while (this.c != '\"') {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character value = escapes.get(new Character(this.c));
                if (value != null) {
                    this.add(value.charValue());
                    continue;
                }
                this.add(this.c);
                continue;
            }
            this.add(this.c);
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    private char unicode() {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + (this.c - 97) + 10;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + (this.c - 65) + 10;
                }
            }
        }
        return (char)value;
    }

    static {
        escapes.put(new Character('\"'), new Character('\"'));
        escapes.put(new Character('\\'), new Character('\\'));
        escapes.put(new Character('/'), new Character('/'));
        escapes.put(new Character('b'), new Character('\b'));
        escapes.put(new Character('f'), new Character('\f'));
        escapes.put(new Character('n'), new Character('\n'));
        escapes.put(new Character('r'), new Character('\r'));
        escapes.put(new Character('t'), new Character('\t'));
    }
}

