/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.TextFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.InvisibleToolbar;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class FilteringToolbar
extends InvisibleToolbar {
    private TextFilter filter;
    private final List<Component> hiddenComponents = new ArrayList<Component>();
    private final AbstractButton filterButton;

    public FilteringToolbar(String string) {
        if (!UIUtils.isNimbusLookAndFeel()) {
            this.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        }
        this.filterButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Filter")){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                if (this.isSelected()) {
                    FilteringToolbar.this.showFilter();
                } else {
                    FilteringToolbar.this.hideFilter();
                }
            }
        };
        this.filterButton.setToolTipText(string);
        this.add(this.filterButton);
    }

    protected abstract void filterChanged();

    public final boolean isAll() {
        return this.filter == null;
    }

    public final boolean passes(String string) {
        return this.filter == null ? true : this.filter.passes(string);
    }

    public final GenericFilter getFilter() {
        TextFilter textFilter = new TextFilter();
        if (this.filter != null) {
            textFilter.copyFrom(this.filter);
        }
        return textFilter;
    }

    private void filterChanged(String string) {
        if (string == null) {
            this.filter = null;
        } else {
            if (this.filter == null) {
                this.filter = new TextFilter();
            }
            this.filter.setValue(string);
        }
        this.filterChanged();
    }

    private void showFilter() {
        this.filterButton.setSelected(true);
        final JTextField jTextField = new JTextField();
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            private void changed() {
                FilteringToolbar.this.filterChanged(jTextField.getText().trim());
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (this.esc(keyEvent)) {
                    FilteringToolbar.this.hideFilter();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.esc(keyEvent);
            }

            private boolean esc(KeyEvent keyEvent) {
                boolean bl;
                boolean bl2 = bl = keyEvent.getKeyCode() == 27;
                if (bl) {
                    keyEvent.consume();
                }
                return bl;
            }
        });
        for (int i = 1; i < this.getComponentCount(); ++i) {
            this.hiddenComponents.add(this.getComponent(i));
        }
        for (Component component : this.hiddenComponents) {
            this.remove(component);
        }
        this.add(Box.createHorizontalStrut(3));
        this.add(jTextField);
        jTextField.requestFocusInWindow();
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    private void hideFilter() {
        this.filterChanged(null);
        this.remove(2);
        this.remove(1);
        for (Component component : this.hiddenComponents) {
            this.add(component);
        }
        this.filterButton.setSelected(false);
        this.filterButton.requestFocusInWindow();
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }
}

