/* libnm.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "NM", gir_namespace = "NM", gir_version = "1.0", lower_case_cprefix = "nm_")]
namespace NM {
	namespace Utils {
		[CCode (cheader_filename = "NetworkManager.h", cprefix = "NMU_SEC_", type_id = "nm_utils_security_type_get_type ()")]
		[GIR (name = "UtilsSecurityType")]
		public enum SecurityType {
			INVALID,
			NONE,
			STATIC_WEP,
			LEAP,
			DYNAMIC_WEP,
			WPA_PSK,
			WPA_ENTERPRISE,
			WPA2_PSK,
			WPA2_ENTERPRISE
		}
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_UTILS_HWADDR_LEN_MAX")]
		public const int HWADDR_LEN_MAX;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool ap_mode_security_valid (NM.Utils.SecurityType type, NM.DeviceWifiCapabilities wifi_caps);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.16")]
		public static bool base64secret_decode (string base64_key, size_t required_key_len, uint8? out_key);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string bin2hexstr ([CCode (array_length_cname = "len", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] src, int final_len);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.2")]
		public static unowned string bond_mode_int_to_string (int mode);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.2")]
		public static int bond_mode_string_to_int (string mode);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool check_virtual_device_compatibility (GLib.Type virtual_type, GLib.Type other_type);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.2")]
		public static bool enum_from_str (GLib.Type type, string str, out int out_value, out string err_token);
		[CCode (array_length = false, array_null_terminated = true, cheader_filename = "NetworkManager.h")]
		[Version (since = "1.2")]
		public static (unowned string)[] enum_get_values (GLib.Type type, int from, int to);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.2")]
		public static string enum_to_str (GLib.Type type, int value);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned string escape_ssid ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] ssid);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool file_is_certificate (string filename);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool file_is_pkcs12 (string filename);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool file_is_private_key (string filename, out bool out_encrypted);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned string file_search_in_paths (string progname, string? try_first, string? paths, GLib.FileTest file_test_flags, NM.UtilsFileSearchInPathsPredicate predicate) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string format_variant_attributes (GLib.HashTable<void*,void*> attributes, char attr_separator, char key_value_separator);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static int64 get_timestamp_msec ();
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Bytes hexstr2bin (string hex);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.ByteArray hwaddr_atoba (string asc, size_t length);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static uint8 hwaddr_aton (string asc, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] uint8[] buffer);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string hwaddr_canonical (string asc, ssize_t length);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static size_t hwaddr_len (int type);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool hwaddr_matches (void* hwaddr1, ssize_t hwaddr1_len, void* hwaddr2, ssize_t hwaddr2_len);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string hwaddr_ntoa ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] addr);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool hwaddr_valid (string asc, ssize_t length);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (deprecated = true, deprecated_since = "1.6")]
		public static bool iface_valid_name (string? name);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.GenericArray<NM.IPAddress> ip4_addresses_from_variant (GLib.Variant value, out string out_gateway);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip4_addresses_to_variant (GLib.GenericArray<NM.IPAddress> addresses, string? gateway);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string ip4_dns_from_variant (GLib.Variant value);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip4_dns_to_variant (string dns);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static uint32 ip4_get_default_prefix (uint32 ip);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static uint32 ip4_netmask_to_prefix (uint32 netmask);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static uint32 ip4_prefix_to_netmask (uint32 prefix);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.GenericArray<NM.IPRoute> ip4_routes_from_variant (GLib.Variant value);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip4_routes_to_variant (GLib.GenericArray<NM.IPRoute> routes);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.GenericArray<NM.IPAddress> ip6_addresses_from_variant (GLib.Variant value, out string out_gateway);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip6_addresses_to_variant (GLib.GenericArray<NM.IPAddress> addresses, string? gateway);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string ip6_dns_from_variant (GLib.Variant value);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip6_dns_to_variant (string dns);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.GenericArray<NM.IPRoute> ip6_routes_from_variant (GLib.Variant value);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip6_routes_to_variant (GLib.GenericArray<NM.IPRoute> routes);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.GenericArray<NM.IPAddress> ip_addresses_from_variant (GLib.Variant value, int family);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip_addresses_to_variant (GLib.GenericArray<NM.IPAddress> addresses);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.GenericArray<NM.IPRoute> ip_routes_from_variant (GLib.Variant value, int family);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned GLib.Variant ip_routes_to_variant (GLib.GenericArray<NM.IPRoute> routes);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool ipaddr_valid (int family, string ip);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool is_empty_ssid ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] ssid);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.6")]
		public static bool is_json_object (string str) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool is_uuid (string? str);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool is_valid_iface_name (string? name) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.8")]
		public static GLib.HashTable<string,GLib.Variant> parse_variant_attributes (string string, char attr_separator, char key_value_separator, bool ignore_unknown, NM.VariantAttributeSpec spec) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool same_ssid ([CCode (array_length_cname = "len1", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] ssid1, [CCode (array_length_cname = "len2", array_length_pos = 2.5, array_length_type = "gsize")] uint8[] ssid2, bool ignore_trailing_null);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool security_valid (NM.Utils.SecurityType type, NM.DeviceWifiCapabilities wifi_caps, bool have_ap, bool adhoc, NM.80211ApFlags ap_flags, NM.80211ApSecurityFlags ap_wpa, NM.80211ApSecurityFlags ap_rsn);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.14")]
		public static NM.SriovVF sriov_vf_from_str (string str) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.14")]
		public static string sriov_vf_to_str (NM.SriovVF vf, bool omit_index) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string ssid_to_utf8 ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] ssid);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.12")]
		public static NM.TCAction tc_action_from_str (string str) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.12")]
		public static string tc_action_to_str (NM.TCAction action) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.12")]
		public static NM.TCQdisc tc_qdisc_from_str (string str) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.12")]
		public static string tc_qdisc_to_str (NM.TCQdisc qdisc) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.12")]
		public static NM.TCTfilter tc_tfilter_from_str (string str) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.12")]
		public static string tc_tfilter_to_str (NM.TCTfilter tfilter) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static string uuid_generate ();
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.6.0")]
		public static uint version ();
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool wep_key_valid (string key, NM.WepKeyType wep_type);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.2")]
		public static uint wifi_2ghz_freqs ();
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.2")]
		public static uint wifi_5ghz_freqs ();
		[CCode (cheader_filename = "NetworkManager.h")]
		public static uint32 wifi_channel_to_freq (uint32 channel, string band);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static uint32 wifi_find_next_channel (uint32 channel, int direction, string band);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static uint32 wifi_freq_to_channel (uint32 freq);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool wifi_is_channel_valid (uint32 channel, string band);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static unowned string wifi_strength_bars (uint8 strength);
		[CCode (cheader_filename = "NetworkManager.h")]
		public static bool wpa_psk_valid (string psk);
	}
	namespace Vpn {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_DBUS_PLUGIN_INTERFACE")]
		public const string DBUS_PLUGIN_INTERFACE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_DBUS_PLUGIN_PATH")]
		public const string DBUS_PLUGIN_PATH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_EDITOR_PLUGIN_DESCRIPTION")]
		public const string EDITOR_PLUGIN_DESCRIPTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_EDITOR_PLUGIN_NAME")]
		public const string EDITOR_PLUGIN_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_EDITOR_PLUGIN_SERVICE")]
		public const string EDITOR_PLUGIN_SERVICE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CAN_PERSIST")]
		public const string PLUGIN_CAN_PERSIST;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CONFIG_BANNER")]
		public const string PLUGIN_CONFIG_BANNER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CONFIG_EXT_GATEWAY")]
		public const string PLUGIN_CONFIG_EXT_GATEWAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CONFIG_HAS_IP4")]
		public const string PLUGIN_CONFIG_HAS_IP4;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CONFIG_HAS_IP6")]
		public const string PLUGIN_CONFIG_HAS_IP6;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CONFIG_MTU")]
		public const string PLUGIN_CONFIG_MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CONFIG_PROXY_PAC")]
		public const string PLUGIN_CONFIG_PROXY_PAC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_CONFIG_TUNDEV")]
		public const string PLUGIN_CONFIG_TUNDEV;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_INFO_FILENAME")]
		public const string PLUGIN_INFO_FILENAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_INFO_KEYFILE")]
		public const string PLUGIN_INFO_KEYFILE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_INFO_KF_GROUP_CONNECTION")]
		public const string PLUGIN_INFO_KF_GROUP_CONNECTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_INFO_KF_GROUP_GNOME")]
		public const string PLUGIN_INFO_KF_GROUP_GNOME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_INFO_KF_GROUP_LIBNM")]
		public const string PLUGIN_INFO_KF_GROUP_LIBNM;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_INFO_NAME")]
		public const string PLUGIN_INFO_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_ADDRESS")]
		public const string PLUGIN_IP4_CONFIG_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_DNS")]
		public const string PLUGIN_IP4_CONFIG_DNS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_DOMAIN")]
		public const string PLUGIN_IP4_CONFIG_DOMAIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_DOMAINS")]
		public const string PLUGIN_IP4_CONFIG_DOMAINS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_INT_GATEWAY")]
		public const string PLUGIN_IP4_CONFIG_INT_GATEWAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_MSS")]
		public const string PLUGIN_IP4_CONFIG_MSS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_NBNS")]
		public const string PLUGIN_IP4_CONFIG_NBNS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_NEVER_DEFAULT")]
		public const string PLUGIN_IP4_CONFIG_NEVER_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_PREFIX")]
		public const string PLUGIN_IP4_CONFIG_PREFIX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_PRESERVE_ROUTES")]
		public const string PLUGIN_IP4_CONFIG_PRESERVE_ROUTES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_PTP")]
		public const string PLUGIN_IP4_CONFIG_PTP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP4_CONFIG_ROUTES")]
		public const string PLUGIN_IP4_CONFIG_ROUTES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_ADDRESS")]
		public const string PLUGIN_IP6_CONFIG_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_DNS")]
		public const string PLUGIN_IP6_CONFIG_DNS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_DOMAIN")]
		public const string PLUGIN_IP6_CONFIG_DOMAIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_DOMAINS")]
		public const string PLUGIN_IP6_CONFIG_DOMAINS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_INT_GATEWAY")]
		public const string PLUGIN_IP6_CONFIG_INT_GATEWAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_MSS")]
		public const string PLUGIN_IP6_CONFIG_MSS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_NEVER_DEFAULT")]
		public const string PLUGIN_IP6_CONFIG_NEVER_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_PREFIX")]
		public const string PLUGIN_IP6_CONFIG_PREFIX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_PRESERVE_ROUTES")]
		public const string PLUGIN_IP6_CONFIG_PRESERVE_ROUTES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_PTP")]
		public const string PLUGIN_IP6_CONFIG_PTP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_IP6_CONFIG_ROUTES")]
		public const string PLUGIN_IP6_CONFIG_ROUTES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_OLD_DBUS_SERVICE_NAME")]
		public const string PLUGIN_OLD_DBUS_SERVICE_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_PLUGIN_OLD_STATE")]
		public const string PLUGIN_OLD_STATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_SERVICE_PLUGIN_DBUS_SERVICE_NAME")]
		public const string SERVICE_PLUGIN_DBUS_SERVICE_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_SERVICE_PLUGIN_DBUS_WATCH_PEER")]
		public const string SERVICE_PLUGIN_DBUS_WATCH_PEER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_SERVICE_PLUGIN_STATE")]
		public const string SERVICE_PLUGIN_STATE;
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_access_point_get_type ()")]
	public class AccessPoint : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_BSSID")]
		public const string BSSID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_FLAGS")]
		public const string FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_FREQUENCY")]
		public const string FREQUENCY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_LAST_SEEN")]
		public const string LAST_SEEN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_MAX_BITRATE")]
		public const string MAX_BITRATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_RSN_FLAGS")]
		public const string RSN_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_SSID")]
		public const string SSID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_STRENGTH")]
		public const string STRENGTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACCESS_POINT_WPA_FLAGS")]
		public const string WPA_FLAGS;
		[CCode (has_construct_function = false)]
		protected AccessPoint ();
		public bool connection_valid (NM.Connection connection);
		public GLib.GenericArray<NM.Connection> filter_connections (GLib.GenericArray<NM.Connection> connections);
		public unowned string get_bssid ();
		public NM.80211ApFlags get_flags ();
		public uint32 get_frequency ();
		[Version (since = "1.2")]
		public int get_last_seen ();
		public uint32 get_max_bitrate ();
		public NM.80211Mode get_mode ();
		public NM.80211ApSecurityFlags get_rsn_flags ();
		public unowned GLib.Bytes get_ssid ();
		public uint8 get_strength ();
		public NM.80211ApSecurityFlags get_wpa_flags ();
		public string bssid { get; }
		public NM.80211ApFlags flags { get; }
		public uint frequency { get; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.0")]
		public string hw_address { owned get; }
		[Version (since = "1.2")]
		public int last_seen { get; }
		public uint max_bitrate { get; }
		public NM.80211Mode mode { get; }
		public NM.80211ApSecurityFlags rsn_flags { get; }
		public GLib.Bytes ssid { get; }
		public uint8 strength { get; }
		public NM.80211ApSecurityFlags wpa_flags { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_active_connection_get_type ()")]
	public class ActiveConnection : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_CONNECTION")]
		public const string CONNECTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_DEFAULT")]
		public const string DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_DEFAULT6")]
		public const string DEFAULT6;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_DEVICES")]
		public const string DEVICES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_DHCP4_CONFIG")]
		public const string DHCP4_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_DHCP6_CONFIG")]
		public const string DHCP6_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_ID")]
		public const string ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_IP4_CONFIG")]
		public const string IP4_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_IP6_CONFIG")]
		public const string IP6_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_MASTER")]
		public const string MASTER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_SPECIFIC_OBJECT_PATH")]
		public const string SPECIFIC_OBJECT_PATH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_STATE")]
		public const string STATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_STATE_FLAGS")]
		public const string STATE_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_TYPE")]
		public const string TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_UUID")]
		public const string UUID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ACTIVE_CONNECTION_VPN")]
		public const string VPN;
		[CCode (has_construct_function = false)]
		protected ActiveConnection ();
		public unowned NM.RemoteConnection get_connection ();
		public unowned string get_connection_type ();
		public bool get_default ();
		public bool get_default6 ();
		public unowned GLib.GenericArray<NM.Device> get_devices ();
		public unowned NM.DhcpConfig get_dhcp4_config ();
		public unowned NM.DhcpConfig get_dhcp6_config ();
		public unowned string get_id ();
		public unowned NM.IPConfig get_ip4_config ();
		public unowned NM.IPConfig get_ip6_config ();
		public unowned NM.Device get_master ();
		public unowned string get_specific_object_path ();
		public NM.ActiveConnectionState get_state ();
		[Version (since = "1.10")]
		public NM.ActivationStateFlags get_state_flags ();
		[Version (since = "1.8")]
		public NM.ActiveConnectionStateReason get_state_reason ();
		public unowned string get_uuid ();
		public bool get_vpn ();
		public NM.RemoteConnection connection { get; }
		public bool @default { get; }
		public bool default6 { get; }
		public GLib.GenericArray<NM.Device> devices { get; }
		public NM.DhcpConfig dhcp4_config { get; }
		public NM.DhcpConfig dhcp6_config { get; }
		public string id { get; }
		public NM.IPConfig ip4_config { get; }
		public NM.IPConfig ip6_config { get; }
		public NM.Device master { get; }
		public string specific_object_path { get; }
		public NM.ActiveConnectionState state { get; }
		[Version (since = "1.10")]
		public uint state_flags { get; }
		[NoAccessorMethod]
		public string type { owned get; }
		public string uuid { get; }
		public bool vpn { get; }
		public signal void state_changed (uint state, uint reason);
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_bridge_vlan_ref", type_id = "nm_bridge_vlan_get_type ()", unref_function = "nm_bridge_vlan_unref")]
	[Compact]
	public class BridgeVlan {
		[CCode (has_construct_function = false)]
		[Version (since = "1.18")]
		public BridgeVlan (uint16 vid_start, uint16 vid_end);
		[Version (since = "1.18")]
		public int cmp (NM.BridgeVlan b);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.18")]
		public static NM.BridgeVlan from_str (string str) throws GLib.Error;
		[Version (since = "1.18")]
		public bool get_vid_range (uint16 vid_start, uint16 vid_end);
		[Version (since = "1.18")]
		public bool is_pvid ();
		[Version (since = "1.18")]
		public bool is_sealed ();
		[Version (since = "1.18")]
		public bool is_untagged ();
		[Version (since = "1.18")]
		public NM.BridgeVlan new_clone ();
		[Version (since = "1.18")]
		public NM.BridgeVlan @ref ();
		[Version (since = "1.18")]
		public void seal ();
		[Version (since = "1.18")]
		public void set_pvid (bool value);
		[Version (since = "1.18")]
		public void set_untagged (bool value);
		[Version (since = "1.18")]
		public string to_str () throws GLib.Error;
		[Version (since = "1.18")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_checkpoint_get_type ()")]
	public class Checkpoint : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Checkpoint ();
		[Version (since = "1.12")]
		public int64 get_created ();
		[Version (since = "1.12")]
		public unowned GLib.GenericArray<NM.Device> get_devices ();
		[Version (since = "1.12")]
		public uint32 get_rollback_timeout ();
		[Version (since = "1.12")]
		public int64 created { get; }
		[Version (since = "1.12")]
		public GLib.GenericArray<NM.Device> devices { get; }
		[Version (since = "1.12")]
		public uint rollback_timeout { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_client_get_type ()")]
	public class Client : GLib.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_ACTIVATING_CONNECTION")]
		public const string ACTIVATING_CONNECTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_ACTIVE_CONNECTIONS")]
		public const string ACTIVE_CONNECTIONS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_ACTIVE_CONNECTION_ADDED")]
		public const string ACTIVE_CONNECTION_ADDED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_ACTIVE_CONNECTION_REMOVED")]
		public const string ACTIVE_CONNECTION_REMOVED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_ALL_DEVICES")]
		public const string ALL_DEVICES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_ANY_DEVICE_ADDED")]
		public const string ANY_DEVICE_ADDED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_ANY_DEVICE_REMOVED")]
		public const string ANY_DEVICE_REMOVED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_CAN_MODIFY")]
		public const string CAN_MODIFY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_CONNECTIONS")]
		public const string CONNECTIONS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_CONNECTION_ADDED")]
		public const string CONNECTION_ADDED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_CONNECTION_REMOVED")]
		public const string CONNECTION_REMOVED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_CONNECTIVITY")]
		public const string CONNECTIVITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_CONNECTIVITY_CHECK_AVAILABLE")]
		public const string CONNECTIVITY_CHECK_AVAILABLE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_CONNECTIVITY_CHECK_ENABLED")]
		public const string CONNECTIVITY_CHECK_ENABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_DEVICES")]
		public const string DEVICES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_DEVICE_ADDED")]
		public const string DEVICE_ADDED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_DEVICE_REMOVED")]
		public const string DEVICE_REMOVED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_DNS_CONFIGURATION")]
		public const string DNS_CONFIGURATION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_DNS_MODE")]
		public const string DNS_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_DNS_RC_MANAGER")]
		public const string DNS_RC_MANAGER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_HOSTNAME")]
		public const string HOSTNAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_METERED")]
		public const string METERED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_NETWORKING_ENABLED")]
		public const string NETWORKING_ENABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_NM_RUNNING")]
		public const string NM_RUNNING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_PERMISSION_CHANGED")]
		public const string PERMISSION_CHANGED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_PRIMARY_CONNECTION")]
		public const string PRIMARY_CONNECTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_STARTUP")]
		public const string STARTUP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_STATE")]
		public const string STATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_VERSION")]
		public const string VERSION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_WIMAX_ENABLED")]
		public const string WIMAX_ENABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_WIMAX_HARDWARE_ENABLED")]
		public const string WIMAX_HARDWARE_ENABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_WIRELESS_ENABLED")]
		public const string WIRELESS_ENABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_WIRELESS_HARDWARE_ENABLED")]
		public const string WIRELESS_HARDWARE_ENABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_WWAN_ENABLED")]
		public const string WWAN_ENABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CLIENT_WWAN_HARDWARE_ENABLED")]
		public const string WWAN_HARDWARE_ENABLED;
		[CCode (has_construct_function = false)]
		public Client (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async NM.ActiveConnection activate_connection_async (NM.Connection? connection, NM.Device? device, string? specific_object, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.16")]
		public async NM.ActiveConnection add_and_activate_connection2 (NM.Connection? partial, NM.Device device, string? specific_object, GLib.Variant options, GLib.Cancellable? cancellable) throws GLib.Error;
		public async NM.ActiveConnection add_and_activate_connection_async (NM.Connection? partial, NM.Device device, string? specific_object, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.20")]
		public async NM.RemoteConnection add_connection2 (GLib.Variant settings, NM.SettingsAddConnection2Flags flags, GLib.Variant? args, bool ignore_out_result, GLib.Cancellable? cancellable, out GLib.Variant out_result) throws GLib.Error;
		public async NM.RemoteConnection add_connection_async (NM.Connection connection, bool save_to_disk, GLib.Cancellable? cancellable) throws GLib.Error;
		public NM.ConnectivityState check_connectivity (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async NM.ConnectivityState check_connectivity_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.12")]
		public async bool checkpoint_adjust_rollback_timeout (string checkpoint_path, uint32 add_timeout, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.12")]
		public async NM.Checkpoint checkpoint_create (GLib.GenericArray<NM.Device> devices, uint32 rollback_timeout, NM.CheckpointCreateFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.12")]
		public async bool checkpoint_destroy (string checkpoint_path, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.12")]
		public async GLib.HashTable<string,uint32> checkpoint_rollback (string checkpoint_path, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.10")]
		public bool connectivity_check_get_available ();
		[Version (since = "1.10")]
		public bool connectivity_check_get_enabled ();
		[Version (since = "1.20")]
		public unowned string connectivity_check_get_uri ();
		[Version (since = "1.10")]
		public void connectivity_check_set_enabled (bool enabled);
		public bool deactivate_connection (NM.ActiveConnection active, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool deactivate_connection_async (NM.ActiveConnection active, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned NM.ActiveConnection get_activating_connection ();
		public unowned GLib.GenericArray<NM.ActiveConnection> get_active_connections ();
		[Version (since = "1.2")]
		public unowned GLib.GenericArray<NM.Device> get_all_devices ();
		[Version (since = "1.12")]
		public unowned GLib.GenericArray<NM.Checkpoint> get_checkpoints ();
		public unowned NM.RemoteConnection get_connection_by_id (string id);
		public unowned NM.RemoteConnection get_connection_by_path (string path);
		public unowned NM.RemoteConnection get_connection_by_uuid (string uuid);
		public unowned GLib.GenericArray<NM.RemoteConnection> get_connections ();
		public NM.ConnectivityState get_connectivity ();
		public unowned NM.Device get_device_by_iface (string iface);
		public unowned NM.Device get_device_by_path (string object_path);
		public unowned GLib.GenericArray<NM.Device> get_devices ();
		[Version (since = "1.6")]
		public unowned GLib.GenericArray<NM.DnsEntry> get_dns_configuration ();
		[Version (since = "1.6")]
		public unowned string get_dns_mode ();
		[Version (since = "1.6")]
		public unowned string get_dns_rc_manager ();
		public bool get_logging (string? level, string? domains) throws GLib.Error;
		public bool get_nm_running ();
		public NM.ClientPermissionResult get_permission_result (NM.ClientPermission permission);
		public unowned NM.ActiveConnection get_primary_connection ();
		public bool get_startup ();
		public NM.State get_state ();
		public unowned string get_version ();
		public bool load_connections ([CCode (array_length = false, array_null_terminated = true)] string[] filenames, out string failures, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (async_result_pos = 2.1)]
		public async bool load_connections_async ([CCode (array_length = false, array_null_terminated = true)] string[] filenames, GLib.Cancellable? cancellable, [CCode (array_length = false, array_null_terminated = true)] out string[] failures) throws GLib.Error;
		public bool networking_get_enabled ();
		public bool networking_set_enabled (bool enabled) throws GLib.Error;
		public static async NM.Client new_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool reload_connections (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool reload_connections_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool save_hostname (string? hostname, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool save_hostname_async (string? hostname, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_logging (string? level, string? domains) throws GLib.Error;
		public bool wimax_get_enabled ();
		public bool wimax_hardware_get_enabled ();
		public void wimax_set_enabled (bool enabled);
		public bool wireless_get_enabled ();
		public bool wireless_hardware_get_enabled ();
		public void wireless_set_enabled (bool enabled);
		public bool wwan_get_enabled ();
		public bool wwan_hardware_get_enabled ();
		public void wwan_set_enabled (bool enabled);
		public NM.ActiveConnection activating_connection { get; }
		public GLib.GenericArray<NM.ActiveConnection> active_connections { get; }
		[Version (since = "1.2")]
		public GLib.GenericArray<NM.Device> all_devices { get; }
		[NoAccessorMethod]
		public bool can_modify { get; }
		[Version (since = "1.12")]
		public GLib.GenericArray<NM.Checkpoint> checkpoints { get; }
		public GLib.GenericArray<NM.RemoteConnection> connections { get; }
		public NM.ConnectivityState connectivity { get; }
		[NoAccessorMethod]
		public bool connectivity_check_available { get; }
		[NoAccessorMethod]
		public bool connectivity_check_enabled { get; set; }
		public GLib.GenericArray<NM.Device> devices { get; }
		[Version (since = "1.6")]
		public GLib.GenericArray<NM.DnsEntry> dns_configuration { get; }
		[Version (since = "1.6")]
		public string dns_mode { get; }
		[Version (since = "1.6")]
		public string dns_rc_manager { get; }
		[NoAccessorMethod]
		public string hostname { owned get; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint metered { get; }
		[NoAccessorMethod]
		public bool networking_enabled { get; set; }
		public bool nm_running { get; }
		public NM.ActiveConnection primary_connection { get; }
		public bool startup { get; }
		public NM.State state { get; }
		public string version { get; }
		[NoAccessorMethod]
		public bool wimax_enabled { get; set; }
		[NoAccessorMethod]
		public bool wimax_hardware_enabled { get; }
		[NoAccessorMethod]
		public bool wireless_enabled { get; set; }
		[NoAccessorMethod]
		public bool wireless_hardware_enabled { get; }
		[NoAccessorMethod]
		public bool wwan_enabled { get; set; }
		[NoAccessorMethod]
		public bool wwan_hardware_enabled { get; }
		public signal void active_connection_added (NM.ActiveConnection active_connection);
		public signal void active_connection_removed (NM.ActiveConnection active_connection);
		public virtual signal void any_device_added (NM.Device device);
		public virtual signal void any_device_removed (NM.Device device);
		public virtual signal void connection_added (NM.RemoteConnection connection);
		public virtual signal void connection_removed (NM.RemoteConnection connection);
		public virtual signal void device_added (NM.Device device);
		public virtual signal void device_removed (NM.Device device);
		public virtual signal void permission_changed (uint permission, uint result);
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_get_type ()")]
	public abstract class Device : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_6LOWPAN_HW_ADDRESS")]
		public const string @6LOWPAN_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_6LOWPAN_PARENT")]
		public const string @6LOWPAN_PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_ACTIVE_CONNECTION")]
		public const string ACTIVE_CONNECTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_AUTOCONNECT")]
		public const string AUTOCONNECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_AVAILABLE_CONNECTIONS")]
		public const string AVAILABLE_CONNECTIONS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_CAPABILITIES")]
		public const string CAPABILITIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_DEVICE_TYPE")]
		public const string DEVICE_TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_DHCP4_CONFIG")]
		public const string DHCP4_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_DHCP6_CONFIG")]
		public const string DHCP6_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_DRIVER")]
		public const string DRIVER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_DRIVER_VERSION")]
		public const string DRIVER_VERSION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_DUMMY_HW_ADDRESS")]
		public const string DUMMY_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_FIRMWARE_MISSING")]
		public const string FIRMWARE_MISSING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_FIRMWARE_VERSION")]
		public const string FIRMWARE_VERSION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_INTERFACE")]
		public const string INTERFACE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP4_CONFIG")]
		public const string IP4_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP4_CONNECTIVITY")]
		public const string IP4_CONNECTIVITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP6_CONFIG")]
		public const string IP6_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP6_CONNECTIVITY")]
		public const string IP6_CONNECTIVITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_INTERFACE")]
		public const string IP_INTERFACE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_ENCAPSULATION_LIMIT")]
		public const string IP_TUNNEL_ENCAPSULATION_LIMIT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_FLAGS")]
		public const string IP_TUNNEL_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_FLOW_LABEL")]
		public const string IP_TUNNEL_FLOW_LABEL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_INPUT_KEY")]
		public const string IP_TUNNEL_INPUT_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_LOCAL")]
		public const string IP_TUNNEL_LOCAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_MODE")]
		public const string IP_TUNNEL_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_OUTPUT_KEY")]
		public const string IP_TUNNEL_OUTPUT_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_PARENT")]
		public const string IP_TUNNEL_PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_PATH_MTU_DISCOVERY")]
		public const string IP_TUNNEL_PATH_MTU_DISCOVERY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_REMOTE")]
		public const string IP_TUNNEL_REMOTE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_TOS")]
		public const string IP_TUNNEL_TOS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_IP_TUNNEL_TTL")]
		public const string IP_TUNNEL_TTL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_LLDP_NEIGHBORS")]
		public const string LLDP_NEIGHBORS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_CIPHER_SUITE")]
		public const string MACSEC_CIPHER_SUITE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_ENCODING_SA")]
		public const string MACSEC_ENCODING_SA;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_ENCRYPT")]
		public const string MACSEC_ENCRYPT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_ES")]
		public const string MACSEC_ES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_HW_ADDRESS")]
		public const string MACSEC_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_ICV_LENGTH")]
		public const string MACSEC_ICV_LENGTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_INCLUDE_SCI")]
		public const string MACSEC_INCLUDE_SCI;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_PARENT")]
		public const string MACSEC_PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_PROTECT")]
		public const string MACSEC_PROTECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_REPLAY_PROTECT")]
		public const string MACSEC_REPLAY_PROTECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_SCB")]
		public const string MACSEC_SCB;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_SCI")]
		public const string MACSEC_SCI;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_VALIDATION")]
		public const string MACSEC_VALIDATION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACSEC_WINDOW")]
		public const string MACSEC_WINDOW;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACVLAN_HW_ADDRESS")]
		public const string MACVLAN_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACVLAN_MODE")]
		public const string MACVLAN_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACVLAN_NO_PROMISC")]
		public const string MACVLAN_NO_PROMISC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACVLAN_PARENT")]
		public const string MACVLAN_PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MACVLAN_TAP")]
		public const string MACVLAN_TAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MANAGED")]
		public const string MANAGED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_METERED")]
		public const string METERED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_NM_PLUGIN_MISSING")]
		public const string NM_PLUGIN_MISSING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_OVS_BRIDGE_SLAVES")]
		public const string OVS_BRIDGE_SLAVES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_OVS_PORT_SLAVES")]
		public const string OVS_PORT_SLAVES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_PHYSICAL_PORT_ID")]
		public const string PHYSICAL_PORT_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_PRODUCT")]
		public const string PRODUCT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_REAL")]
		public const string REAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_STATE")]
		public const string STATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_STATE_REASON")]
		public const string STATE_REASON;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TUN_GROUP")]
		public const string TUN_GROUP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TUN_HW_ADDRESS")]
		public const string TUN_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TUN_MODE")]
		public const string TUN_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TUN_MULTI_QUEUE")]
		public const string TUN_MULTI_QUEUE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TUN_NO_PI")]
		public const string TUN_NO_PI;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TUN_OWNER")]
		public const string TUN_OWNER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TUN_VNET_HDR")]
		public const string TUN_VNET_HDR;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_UDI")]
		public const string UDI;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VENDOR")]
		public const string VENDOR;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_AGEING")]
		public const string VXLAN_AGEING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_CARRIER")]
		public const string VXLAN_CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_DST_PORT")]
		public const string VXLAN_DST_PORT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_GROUP")]
		public const string VXLAN_GROUP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_HW_ADDRESS")]
		public const string VXLAN_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_ID")]
		public const string VXLAN_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_L2MISS")]
		public const string VXLAN_L2MISS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_L3MISS")]
		public const string VXLAN_L3MISS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_LEARNING")]
		public const string VXLAN_LEARNING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_LIMIT")]
		public const string VXLAN_LIMIT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_LOCAL")]
		public const string VXLAN_LOCAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_PARENT")]
		public const string VXLAN_PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_PROXY")]
		public const string VXLAN_PROXY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_RSC")]
		public const string VXLAN_RSC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_SRC_PORT_MAX")]
		public const string VXLAN_SRC_PORT_MAX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_SRC_PORT_MIN")]
		public const string VXLAN_SRC_PORT_MIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_TOS")]
		public const string VXLAN_TOS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VXLAN_TTL")]
		public const string VXLAN_TTL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIREGUARD_FWMARK")]
		public const string WIREGUARD_FWMARK;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIREGUARD_LISTEN_PORT")]
		public const string WIREGUARD_LISTEN_PORT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIREGUARD_PUBLIC_KEY")]
		public const string WIREGUARD_PUBLIC_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WPAN_HW_ADDRESS")]
		public const string WPAN_HW_ADDRESS;
		[CCode (has_construct_function = false)]
		protected Device ();
		public virtual bool connection_compatible (NM.Connection connection) throws GLib.Error;
		public bool connection_valid (NM.Connection connection);
		public bool @delete (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool delete_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] disambiguate_names ([CCode (array_length_cname = "num_devices", array_length_pos = 1.1)] NM.Device[] devices);
		public bool disconnect (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool disconnect_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<NM.Connection> filter_connections (GLib.GenericArray<NM.Connection> connections);
		public unowned NM.ActiveConnection get_active_connection ();
		[Version (since = "1.2")]
		public NM.Connection get_applied_connection (uint32 flags, out uint64 version_id, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.2")]
		public async NM.Connection get_applied_connection_async (uint32 flags, GLib.Cancellable? cancellable, out uint64 version_id) throws GLib.Error;
		public bool get_autoconnect ();
		public unowned GLib.GenericArray<NM.RemoteConnection> get_available_connections ();
		public NM.DeviceCapabilities get_capabilities ();
		[Version (since = "1.16")]
		public NM.ConnectivityState get_connectivity (int addr_family);
		public unowned string get_description ();
		public NM.DeviceType get_device_type ();
		public unowned NM.DhcpConfig get_dhcp4_config ();
		public unowned NM.DhcpConfig get_dhcp6_config ();
		public unowned string get_driver ();
		public unowned string get_driver_version ();
		public bool get_firmware_missing ();
		public unowned string get_firmware_version ();
		public virtual unowned string get_hw_address ();
		public unowned string get_iface ();
		public unowned NM.IPConfig get_ip4_config ();
		public unowned NM.IPConfig get_ip6_config ();
		public unowned string get_ip_iface ();
		[Version (since = "1.2")]
		public unowned GLib.GenericArray<NM.LldpNeighbor> get_lldp_neighbors ();
		public bool get_managed ();
		[Version (since = "1.2")]
		public NM.Metered get_metered ();
		public uint32 get_mtu ();
		[Version (since = "1.2")]
		public bool get_nm_plugin_missing ();
		public unowned string get_physical_port_id ();
		public unowned string get_product ();
		public virtual GLib.Type get_setting_type ();
		public NM.DeviceState get_state ();
		public NM.DeviceStateReason get_state_reason ();
		public virtual unowned string get_type_description ();
		public unowned string get_udi ();
		public unowned string get_vendor ();
		[Version (since = "1.2")]
		public bool is_real ();
		public bool is_software ();
		[Version (since = "1.2")]
		public bool reapply (NM.Connection? connection, uint64 version_id, uint32 flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.2")]
		public async bool reapply_async (NM.Connection? connection, uint64 version_id, uint32 flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_autoconnect (bool autoconnect);
		[Version (since = "1.2")]
		public void set_managed (bool managed);
		public NM.ActiveConnection active_connection { get; }
		public bool autoconnect { get; set; }
		public GLib.GenericArray<NM.RemoteConnection> available_connections { get; }
		public NM.DeviceCapabilities capabilities { get; }
		public NM.DeviceType device_type { get; }
		public NM.DhcpConfig dhcp4_config { get; }
		public NM.DhcpConfig dhcp6_config { get; }
		public string driver { get; }
		public string driver_version { get; }
		public bool firmware_missing { get; }
		public string firmware_version { get; }
		[NoAccessorMethod]
		public string @interface { owned get; }
		public NM.IPConfig ip4_config { get; }
		[NoAccessorMethod]
		[Version (since = "1.16")]
		public NM.ConnectivityState ip4_connectivity { get; }
		public NM.IPConfig ip6_config { get; }
		[NoAccessorMethod]
		[Version (since = "1.16")]
		public NM.ConnectivityState ip6_connectivity { get; }
		[NoAccessorMethod]
		public string ip_interface { owned get; }
		public GLib.GenericArray<void*> lldp_neighbors { get; }
		public bool managed { get; }
		[Version (since = "1.2")]
		public uint metered { get; }
		public uint mtu { get; }
		[Version (since = "1.2")]
		public bool nm_plugin_missing { get; }
		public string physical_port_id { get; }
		public string product { get; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool real { get; }
		public NM.DeviceState state { get; }
		public uint state_reason { get; }
		public string udi { get; }
		public string vendor { get; }
		public virtual signal void state_changed (uint new_state, uint old_state, uint reason);
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "device_6lowpan", type_id = "nm_device_6lowpan_get_type ()")]
	public class Device6Lowpan : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Device6Lowpan ();
		[Version (since = "1.14")]
		public unowned string get_hw_address ();
		[Version (since = "1.14")]
		public unowned NM.Device get_parent ();
		[Version (since = "1.14")]
		public string hw_address { get; }
		[Version (since = "1.14")]
		public NM.Device parent { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_adsl_get_type ()")]
	public class DeviceAdsl : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_ADSL_CARRIER")]
		public const string CARRIER;
		[CCode (has_construct_function = false)]
		protected DeviceAdsl ();
		public bool get_carrier ();
		public bool carrier { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_bond_get_type ()")]
	public class DeviceBond : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BOND_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BOND_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BOND_SLAVES")]
		public const string SLAVES;
		[CCode (has_construct_function = false)]
		protected DeviceBond ();
		public bool get_carrier ();
		public unowned string get_hw_address ();
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
		public bool carrier { get; }
		public string hw_address { get; }
		public GLib.GenericArray<NM.Device> slaves { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_bridge_get_type ()")]
	public class DeviceBridge : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BRIDGE_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BRIDGE_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BRIDGE_SLAVES")]
		public const string SLAVES;
		[CCode (has_construct_function = false)]
		protected DeviceBridge ();
		public bool get_carrier ();
		public unowned string get_hw_address ();
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
		public bool carrier { get; }
		public string hw_address { get; }
		public GLib.GenericArray<NM.Device> slaves { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_bt_get_type ()")]
	public class DeviceBt : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BT_CAPABILITIES")]
		public const string CAPABILITIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BT_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_BT_NAME")]
		public const string NAME;
		[CCode (has_construct_function = false)]
		protected DeviceBt ();
		public NM.BluetoothCapabilities get_capabilities ();
		public unowned string get_hw_address ();
		public unowned string get_name ();
		[NoAccessorMethod]
		public NM.BluetoothCapabilities bt_capabilities { get; }
		public string hw_address { get; }
		public string name { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_dummy_get_type ()")]
	public class DeviceDummy : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceDummy ();
		[Version (since = "1.10")]
		public unowned string get_hw_address ();
		[Version (since = "1.10")]
		public string hw_address { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_ethernet_get_type ()")]
	public class DeviceEthernet : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_ETHERNET_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_ETHERNET_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_ETHERNET_PERMANENT_HW_ADDRESS")]
		public const string PERMANENT_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_ETHERNET_S390_SUBCHANNELS")]
		public const string S390_SUBCHANNELS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_ETHERNET_SPEED")]
		public const string SPEED;
		[CCode (has_construct_function = false)]
		protected DeviceEthernet ();
		public bool get_carrier ();
		public unowned string get_hw_address ();
		public unowned string get_permanent_hw_address ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.2")]
		public unowned string[] get_s390_subchannels ();
		public uint32 get_speed ();
		public bool carrier { get; }
		public string hw_address { get; }
		[NoAccessorMethod]
		public string perm_hw_address { owned get; }
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.2")]
		public string[] s390_subchannels { get; }
		public uint speed { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_generic_get_type ()")]
	public class DeviceGeneric : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_GENERIC_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_GENERIC_TYPE_DESCRIPTION")]
		public const string TYPE_DESCRIPTION;
		[CCode (has_construct_function = false)]
		protected DeviceGeneric ();
		public unowned string get_hw_address ();
		public string hw_address { get; }
		[NoAccessorMethod]
		public string type_description { owned get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_ip_tunnel_get_type ()")]
	public class DeviceIPTunnel : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceIPTunnel ();
		[Version (since = "1.2")]
		public uint8 get_encapsulation_limit ();
		[Version (since = "1.12")]
		public NM.IPTunnelFlags get_flags ();
		[Version (since = "1.2")]
		public uint get_flow_label ();
		[Version (since = "1.2")]
		public unowned string get_input_key ();
		[Version (since = "1.2")]
		public unowned string get_local ();
		[Version (since = "1.2")]
		public NM.IPTunnelMode get_mode ();
		[Version (since = "1.2")]
		public unowned string get_output_key ();
		[Version (since = "1.2")]
		public unowned NM.Device get_parent ();
		[Version (since = "1.2")]
		public bool get_path_mtu_discovery ();
		[Version (since = "1.2")]
		public unowned string get_remote ();
		[Version (since = "1.2")]
		public uint8 get_tos ();
		[Version (since = "1.2")]
		public uint8 get_ttl ();
		[Version (since = "1.2")]
		public uint8 encapsulation_limit { get; }
		[Version (since = "1.12")]
		public uint flags { get; }
		[Version (since = "1.2")]
		public uint flow_label { get; }
		[Version (since = "1.2")]
		public string input_key { get; }
		[Version (since = "1.2")]
		public string local { get; }
		[Version (since = "1.2")]
		public uint mode { get; }
		[Version (since = "1.2")]
		public string output_key { get; }
		[Version (since = "1.2")]
		public NM.Device parent { get; }
		[Version (since = "1.2")]
		public bool path_mtu_discovery { get; }
		[Version (since = "1.2")]
		public string remote { get; }
		[Version (since = "1.2")]
		public uint8 tos { get; }
		[Version (since = "1.2")]
		public uint8 ttl { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_infiniband_get_type ()")]
	public class DeviceInfiniband : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_INFINIBAND_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_INFINIBAND_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (has_construct_function = false)]
		protected DeviceInfiniband ();
		public bool get_carrier ();
		public unowned string get_hw_address ();
		public bool carrier { get; }
		public string hw_address { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_macsec_get_type ()")]
	public class DeviceMacsec : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceMacsec ();
		[Version (since = "1.6")]
		public uint64 get_cipher_suite ();
		[Version (since = "1.6")]
		public uint8 get_encoding_sa ();
		[Version (since = "1.6")]
		public bool get_encrypt ();
		[Version (since = "1.6")]
		public bool get_es ();
		[Version (since = "1.6")]
		public unowned string get_hw_address ();
		[Version (since = "1.6")]
		public uint8 get_icv_length ();
		[Version (since = "1.6")]
		public bool get_include_sci ();
		[Version (since = "1.6")]
		public unowned NM.Device get_parent ();
		[Version (since = "1.6")]
		public bool get_protect ();
		[Version (since = "1.6")]
		public bool get_replay_protect ();
		[Version (since = "1.6")]
		public bool get_scb ();
		[Version (since = "1.6")]
		public uint64 get_sci ();
		[Version (since = "1.6")]
		public unowned string get_validation ();
		[Version (since = "1.6")]
		public uint get_window ();
		[Version (since = "1.6")]
		public uint64 cipher_suite { get; }
		[Version (since = "1.6")]
		public uint8 encoding_sa { get; }
		[Version (since = "1.6")]
		public bool encrypt { get; }
		[Version (since = "1.6")]
		public bool es { get; }
		[Version (since = "1.6")]
		public string hw_address { get; }
		[Version (since = "1.6")]
		public uint8 icv_length { get; }
		[Version (since = "1.6")]
		public bool include_sci { get; }
		[Version (since = "1.6")]
		public NM.Device parent { get; }
		[Version (since = "1.6")]
		public bool protect { get; }
		[Version (since = "1.6")]
		public bool replay_protect { get; }
		[Version (since = "1.6")]
		public bool scb { get; }
		[Version (since = "1.6")]
		public uint64 sci { get; }
		[Version (since = "1.6")]
		public string validation { get; }
		[Version (since = "1.6")]
		public uint window { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_macvlan_get_type ()")]
	public class DeviceMacvlan : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceMacvlan ();
		[Version (since = "1.2")]
		public unowned string get_hw_address ();
		[Version (since = "1.2")]
		public unowned string get_mode ();
		[Version (since = "1.2")]
		public bool get_no_promisc ();
		[Version (since = "1.2")]
		public unowned NM.Device get_parent ();
		[Version (since = "1.2")]
		public bool get_tap ();
		[Version (since = "1.2")]
		public string hw_address { get; }
		[Version (since = "1.2")]
		public string mode { get; }
		[Version (since = "1.2")]
		public bool no_promisc { get; }
		[Version (since = "1.2")]
		public NM.Device parent { get; }
		[Version (since = "1.2")]
		public bool tap { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_modem_get_type ()")]
	public class DeviceModem : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MODEM_APN")]
		public const string APN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MODEM_CURRENT_CAPABILITIES")]
		public const string CURRENT_CAPABILITIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MODEM_DEVICE_ID")]
		public const string DEVICE_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MODEM_MODEM_CAPABILITIES")]
		public const string MODEM_CAPABILITIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_MODEM_OPERATOR_CODE")]
		public const string OPERATOR_CODE;
		[CCode (has_construct_function = false)]
		protected DeviceModem ();
		[Version (since = "1.20")]
		public unowned string get_apn ();
		public NM.DeviceModemCapabilities get_current_capabilities ();
		[Version (since = "1.20")]
		public unowned string get_device_id ();
		public NM.DeviceModemCapabilities get_modem_capabilities ();
		[Version (since = "1.20")]
		public unowned string get_operator_code ();
		[Version (since = "1.20")]
		public string apn { get; }
		public NM.DeviceModemCapabilities current_capabilities { get; }
		[Version (since = "1.20")]
		public string device_id { get; }
		public NM.DeviceModemCapabilities modem_capabilities { get; }
		[Version (since = "1.20")]
		public string operator_code { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_olpc_mesh_get_type ()")]
	public class DeviceOlpcMesh : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_OLPC_MESH_ACTIVE_CHANNEL")]
		public const string MESH_ACTIVE_CHANNEL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_OLPC_MESH_COMPANION")]
		public const string MESH_COMPANION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_OLPC_MESH_HW_ADDRESS")]
		public const string MESH_HW_ADDRESS;
		[CCode (has_construct_function = false)]
		protected DeviceOlpcMesh ();
		public uint32 get_active_channel ();
		public unowned NM.DeviceWifi get_companion ();
		public unowned string get_hw_address ();
		public uint active_channel { get; }
		public NM.DeviceWifi companion { get; }
		public string hw_address { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_ovs_bridge_get_type ()")]
	public class DeviceOvsBridge : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceOvsBridge ();
		[Version (since = "1.14")]
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_ovs_interface_get_type ()")]
	public class DeviceOvsInterface : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceOvsInterface ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_ovs_port_get_type ()")]
	public class DeviceOvsPort : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceOvsPort ();
		[Version (since = "1.14")]
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_ppp_get_type ()")]
	public class DevicePpp : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DevicePpp ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_team_get_type ()")]
	public class DeviceTeam : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TEAM_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TEAM_CONFIG")]
		public const string CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TEAM_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_TEAM_SLAVES")]
		public const string SLAVES;
		[CCode (has_construct_function = false)]
		protected DeviceTeam ();
		public bool get_carrier ();
		[Version (since = "1.4")]
		public unowned string get_config ();
		public unowned string get_hw_address ();
		public unowned GLib.GenericArray<NM.Device> get_slaves ();
		public bool carrier { get; }
		[Version (since = "1.4")]
		public string config { get; }
		public string hw_address { get; }
		public GLib.GenericArray<NM.Device> slaves { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_tun_get_type ()")]
	public class DeviceTun : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceTun ();
		[Version (since = "1.2")]
		public int64 get_group ();
		[Version (since = "1.2")]
		public unowned string get_hw_address ();
		[Version (since = "1.2")]
		public unowned string get_mode ();
		[Version (since = "1.2")]
		public bool get_multi_queue ();
		public bool get_no_pi ();
		[Version (since = "1.2")]
		public int64 get_owner ();
		[Version (since = "1.2")]
		public bool get_vnet_hdr ();
		[Version (since = "1.2")]
		public int64 group { get; }
		[Version (since = "1.2")]
		public string hw_address { get; }
		[Version (since = "1.2")]
		public string mode { get; }
		[Version (since = "1.2")]
		public bool multi_queue { get; }
		[Version (since = "1.2")]
		public bool no_pi { get; }
		[Version (since = "1.2")]
		public int64 owner { get; }
		[Version (since = "1.2")]
		public bool vnet_hdr { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_vlan_get_type ()")]
	public class DeviceVlan : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VLAN_CARRIER")]
		public const string CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VLAN_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VLAN_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_VLAN_VLAN_ID")]
		public const string VLAN_ID;
		[CCode (has_construct_function = false)]
		protected DeviceVlan ();
		public bool get_carrier ();
		public unowned string get_hw_address ();
		public unowned NM.Device get_parent ();
		public uint get_vlan_id ();
		public bool carrier { get; }
		public string hw_address { get; }
		public NM.Device parent { get; }
		public uint vlan_id { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_vxlan_get_type ()")]
	public class DeviceVxlan : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceVxlan ();
		[Version (since = "1.2")]
		public uint get_ageing ();
		[Version (since = "1.2")]
		public bool get_carrier ();
		[Version (since = "1.2")]
		public uint get_dst_port ();
		[Version (since = "1.2")]
		public unowned string get_group ();
		[Version (since = "1.2")]
		public unowned string get_hw_address ();
		[Version (since = "1.2")]
		public uint get_id ();
		[Version (since = "1.2")]
		public bool get_l2miss ();
		[Version (since = "1.2")]
		public bool get_l3miss ();
		[Version (since = "1.2")]
		public bool get_learning ();
		[Version (since = "1.2")]
		public uint get_limit ();
		[Version (since = "1.2")]
		public unowned string get_local ();
		[Version (since = "1.2")]
		public unowned NM.Device get_parent ();
		[Version (since = "1.2")]
		public bool get_proxy ();
		[Version (since = "1.2")]
		public bool get_rsc ();
		[Version (since = "1.2")]
		public uint get_src_port_max ();
		[Version (since = "1.2")]
		public uint get_src_port_min ();
		[Version (since = "1.2")]
		public uint get_tos ();
		[Version (since = "1.2")]
		public uint get_ttl ();
		[Version (since = "1.2")]
		public uint ageing { get; }
		[Version (since = "1.2")]
		public bool carrier { get; }
		[Version (since = "1.2")]
		public uint dst_port { get; }
		[Version (since = "1.2")]
		public string group { get; }
		[Version (since = "1.2")]
		public string hw_address { get; }
		[Version (since = "1.2")]
		public uint id { get; }
		[Version (since = "1.2")]
		public bool l2miss { get; }
		[Version (since = "1.2")]
		public bool l3miss { get; }
		[Version (since = "1.2")]
		public bool learning { get; }
		[Version (since = "1.2")]
		public uint limit { get; }
		[Version (since = "1.2")]
		public string local { get; }
		[Version (since = "1.2")]
		public NM.Device parent { get; }
		[Version (since = "1.2")]
		public bool proxy { get; }
		[Version (since = "1.2")]
		public bool rsc { get; }
		[Version (since = "1.2")]
		public uint src_port_max { get; }
		[Version (since = "1.2")]
		public uint src_port_min { get; }
		[Version (since = "1.2")]
		public uint8 tos { get; }
		[Version (since = "1.2")]
		public uint8 ttl { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_wifi_get_type ()")]
	public class DeviceWifi : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_ACCESS_POINTS")]
		public const string ACCESS_POINTS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_ACTIVE_ACCESS_POINT")]
		public const string ACTIVE_ACCESS_POINT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_BITRATE")]
		public const string BITRATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_CAPABILITIES")]
		public const string CAPABILITIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_LAST_SCAN")]
		public const string LAST_SCAN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_P2P_HW_ADDRESS")]
		public const string P2P_HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_P2P_PEERS")]
		public const string P2P_PEERS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_P2P_WFDIES")]
		public const string P2P_WFDIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIFI_PERMANENT_HW_ADDRESS")]
		public const string PERMANENT_HW_ADDRESS;
		[CCode (has_construct_function = false)]
		protected DeviceWifi ();
		public unowned NM.AccessPoint get_access_point_by_path (string path);
		public unowned GLib.GenericArray<NM.AccessPoint> get_access_points ();
		public unowned NM.AccessPoint get_active_access_point ();
		public uint32 get_bitrate ();
		public NM.DeviceWifiCapabilities get_capabilities ();
		public unowned string get_hw_address ();
		[Version (since = "1.12")]
		public int64 get_last_scan ();
		public NM.80211Mode get_mode ();
		public unowned string get_permanent_hw_address ();
		public bool request_scan (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool request_scan_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.2")]
		public bool request_scan_options (GLib.Variant options, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "1.2")]
		public async void request_scan_options_async (GLib.Variant options, GLib.Cancellable? cancellable);
		public GLib.GenericArray<NM.AccessPoint> access_points { get; }
		public NM.AccessPoint active_access_point { get; }
		public uint bitrate { get; }
		public string hw_address { get; }
		[Version (since = "1.12")]
		public int64 last_scan { get; }
		public NM.80211Mode mode { get; }
		[NoAccessorMethod]
		public string perm_hw_address { owned get; }
		[NoAccessorMethod]
		public NM.DeviceWifiCapabilities wireless_capabilities { get; }
		public virtual signal void access_point_added (GLib.Object ap);
		public virtual signal void access_point_removed (GLib.Object ap);
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "device_wifi_p2p", type_id = "nm_device_wifi_p2p_get_type ()")]
	[Version (since = "1.16")]
	public class DeviceWifiP2P : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceWifiP2P ();
		public unowned string get_hw_address ();
		public unowned NM.WifiP2PPeer get_peer_by_path (string path);
		public unowned GLib.GenericArray<NM.WifiP2PPeer> get_peers ();
		public async bool start_find (GLib.Variant? options, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool stop_find (GLib.Cancellable? cancellable) throws GLib.Error;
		public string hw_address { get; }
		public GLib.GenericArray<NM.WifiP2PPeer> peers { get; }
		public signal void peer_added (GLib.Object peer);
		public signal void peer_removed (GLib.Object peer);
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_wimax_get_type ()")]
	public class DeviceWimax : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_ACTIVE_NSP")]
		public const string ACTIVE_NSP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_BSID")]
		public const string BSID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_CENTER_FREQUENCY")]
		public const string CENTER_FREQUENCY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_CINR")]
		public const string CINR;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_HW_ADDRESS")]
		public const string HW_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_NSPS")]
		public const string NSPS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_RSSI")]
		public const string RSSI;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DEVICE_WIMAX_TX_POWER")]
		public const string TX_POWER;
		[CCode (has_construct_function = false)]
		protected DeviceWimax ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public NM.WimaxNsp get_active_nsp ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned string get_bsid ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public uint get_center_frequency ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int get_cinr ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned string get_hw_address ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned NM.WimaxNsp get_nsp_by_path (string path);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned GLib.GenericArray<NM.WimaxNsp> get_nsps ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int get_rssi ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int get_tx_power ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public NM.WimaxNsp active_nsp { owned get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string bsid { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public uint center_frequency { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int cinr { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string hw_address { get; }
		public GLib.GenericArray<NM.WimaxNsp> nsps { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int rssi { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public int tx_power { get; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public virtual signal void nsp_added (GLib.Object nsp);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public virtual signal void nsp_removed (GLib.Object nsp);
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "device_wireguard", type_id = "nm_device_wireguard_get_type ()")]
	public class DeviceWireGuard : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceWireGuard ();
		[Version (since = "1.14")]
		public uint32 get_fwmark ();
		[Version (since = "1.14")]
		public uint16 get_listen_port ();
		[Version (since = "1.14")]
		public unowned GLib.Bytes get_public_key ();
		[Version (since = "1.14")]
		public uint fwmark { get; }
		[Version (since = "1.14")]
		public uint listen_port { get; }
		[Version (since = "1.14")]
		public GLib.Bytes public_key { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_device_wpan_get_type ()")]
	public class DeviceWpan : NM.Device, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DeviceWpan ();
		public unowned string get_hw_address ();
		public string hw_address { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_dhcp_config_get_type ()")]
	public abstract class DhcpConfig : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DHCP_CONFIG_OPTIONS")]
		public const string OPTIONS;
		[CCode (has_construct_function = false)]
		protected DhcpConfig ();
		public int get_family ();
		public unowned string get_one_option (string option);
		public unowned GLib.HashTable<string,string> get_options ();
		public int family { get; }
		public GLib.HashTable<string,string> options { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nm_dns_entry_get_type ()")]
	[Compact]
	public class DnsEntry {
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.6")]
		public unowned string[] get_domains ();
		[Version (since = "1.6")]
		public unowned string get_interface ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.6")]
		public unowned string[] get_nameservers ();
		[Version (since = "1.6")]
		public int get_priority ();
		[Version (since = "1.6")]
		public bool get_vpn ();
		[Version (since = "1.6")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_ip_address_ref", type_id = "nm_ip_address_get_type ()", unref_function = "nm_ip_address_unref")]
	[Compact]
	public class IPAddress {
		[CCode (has_construct_function = false)]
		public IPAddress (int family, string addr, uint prefix) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public IPAddress.binary (int family, void* addr, uint prefix) throws GLib.Error;
		public NM.IPAddress dup ();
		public bool equal (NM.IPAddress other);
		public unowned string get_address ();
		public unowned GLib.Variant get_attribute (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_attribute_names ();
		public int get_family ();
		public uint get_prefix ();
		public void @ref ();
		public void set_address (string addr);
		public void set_attribute (string name, GLib.Variant? value);
		public void set_prefix (uint prefix);
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_ip_config_get_type ()")]
	public abstract class IPConfig : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_ADDRESSES")]
		public const string ADDRESSES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_DOMAINS")]
		public const string DOMAINS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_FAMILY")]
		public const string FAMILY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_GATEWAY")]
		public const string GATEWAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_NAMESERVERS")]
		public const string NAMESERVERS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_ROUTES")]
		public const string ROUTES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_SEARCHES")]
		public const string SEARCHES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_CONFIG_WINS_SERVERS")]
		public const string WINS_SERVERS;
		[CCode (has_construct_function = false)]
		protected IPConfig ();
		public unowned GLib.GenericArray<NM.IPAddress> get_addresses ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_domains ();
		public int get_family ();
		public unowned string get_gateway ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_nameservers ();
		public unowned GLib.GenericArray<NM.IPRoute> get_routes ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_searches ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_wins_servers ();
		public GLib.GenericArray<void*> addresses { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] domains { get; }
		public int family { get; }
		public string gateway { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] nameservers { get; }
		public GLib.GenericArray<NM.IPRoute> routes { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] searches { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] wins_servers { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_ip_route_ref", type_id = "nm_ip_route_get_type ()", unref_function = "nm_ip_route_unref")]
	[Compact]
	public class IPRoute {
		[CCode (has_construct_function = false)]
		public IPRoute (int family, string dest, uint prefix, string? next_hop, int64 metric) throws GLib.Error;
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.8")]
		public static bool attribute_validate (string name, GLib.Variant value, int family, out bool known) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public IPRoute.binary (int family, void* dest, uint prefix, void* next_hop, int64 metric) throws GLib.Error;
		public NM.IPRoute dup ();
		public bool equal (NM.IPRoute other);
		[Version (since = "1.10")]
		public bool equal_full (NM.IPRoute other, uint cmp_flags);
		public unowned GLib.Variant get_attribute (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_attribute_names ();
		public unowned string get_dest ();
		public int get_family ();
		public int64 get_metric ();
		public unowned string get_next_hop ();
		public uint get_prefix ();
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.8")]
		public static unowned NM.VariantAttributeSpec get_variant_attribute_spec ();
		public void @ref ();
		public void set_attribute (string name, GLib.Variant? value);
		public void set_dest (string dest);
		public void set_metric (int64 metric);
		public void set_next_hop (string? next_hop);
		public void set_prefix (uint prefix);
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_ip_routing_rule_ref", type_id = "nm_ip_routing_rule_get_type ()", unref_function = "nm_ip_routing_rule_unref")]
	[Compact]
	public class IPRoutingRule {
		[CCode (has_construct_function = false)]
		[Version (since = "1.18")]
		public IPRoutingRule (int addr_family);
		[Version (since = "1.18")]
		public int cmp (NM.IPRoutingRule? other);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.18")]
		public static NM.IPRoutingRule from_string (string str, NM.IPRoutingRuleAsStringFlags to_string_flags, GLib.HashTable<void*,void*>? extra_args) throws GLib.Error;
		[Version (since = "1.18")]
		public uint8 get_action ();
		[Version (since = "1.18")]
		public int get_addr_family ();
		[Version (since = "1.18")]
		public uint16 get_destination_port_end ();
		[Version (since = "1.18")]
		public uint16 get_destination_port_start ();
		[Version (since = "1.18")]
		public unowned string get_from ();
		[Version (since = "1.18")]
		public uint8 get_from_len ();
		[Version (since = "1.18")]
		public uint32 get_fwmark ();
		[Version (since = "1.18")]
		public uint32 get_fwmask ();
		[Version (since = "1.18")]
		public unowned string get_iifname ();
		[Version (since = "1.18")]
		public bool get_invert ();
		[Version (since = "1.18")]
		public uint8 get_ipproto ();
		[Version (since = "1.18")]
		public unowned string get_oifname ();
		[Version (since = "1.18")]
		public int64 get_priority ();
		[Version (since = "1.18")]
		public uint16 get_source_port_end ();
		[Version (since = "1.18")]
		public uint16 get_source_port_start ();
		[Version (since = "1.20")]
		public int32 get_suppress_prefixlength ();
		[Version (since = "1.18")]
		public uint32 get_table ();
		[Version (since = "1.18")]
		public unowned string get_to ();
		[Version (since = "1.18")]
		public uint8 get_to_len ();
		[Version (since = "1.18")]
		public uint8 get_tos ();
		[Version (since = "1.18")]
		public bool is_sealed ();
		[Version (since = "1.18")]
		public NM.IPRoutingRule new_clone ();
		[Version (since = "1.18")]
		public NM.IPRoutingRule @ref ();
		[Version (since = "1.18")]
		public void seal ();
		[Version (since = "1.18")]
		public void set_action (uint8 action);
		[Version (since = "1.18")]
		public void set_destination_port (uint16 start, uint16 end);
		[Version (since = "1.18")]
		public void set_from (string? from, uint8 len);
		[Version (since = "1.18")]
		public void set_fwmark (uint32 fwmark, uint32 fwmask);
		[Version (since = "1.18")]
		public void set_iifname (string? iifname);
		[Version (since = "1.18")]
		public void set_invert (bool invert);
		[Version (since = "1.18")]
		public void set_ipproto (uint8 ipproto);
		[Version (since = "1.18")]
		public void set_oifname (string? oifname);
		[Version (since = "1.18")]
		public void set_priority (int64 priority);
		[Version (since = "1.18")]
		public void set_source_port (uint16 start, uint16 end);
		[Version (since = "1.20")]
		public void set_suppress_prefixlength (int32 suppress_prefixlength);
		[Version (since = "1.18")]
		public void set_table (uint32 table);
		[Version (since = "1.18")]
		public void set_to (string? to, uint8 len);
		[Version (since = "1.18")]
		public void set_tos (uint8 tos);
		[Version (since = "1.18")]
		public string to_string (NM.IPRoutingRuleAsStringFlags to_string_flags, GLib.HashTable<void*,void*>? extra_args) throws GLib.Error;
		[Version (since = "1.18")]
		public void unref ();
		[Version (since = "1.18")]
		public bool validate () throws GLib.Error;
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_lldp_neighbor_ref", type_id = "nm_lldp_neighbor_get_type ()", unref_function = "nm_lldp_neighbor_unref")]
	[Compact]
	public class LldpNeighbor {
		[CCode (has_construct_function = false)]
		[Version (since = "1.2")]
		public LldpNeighbor ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.2")]
		public string[] get_attr_names ();
		[Version (since = "1.2")]
		public bool get_attr_string_value (string name, out unowned string out_value);
		[Version (since = "1.2")]
		public unowned GLib.VariantType get_attr_type (string name);
		[Version (since = "1.2")]
		public bool get_attr_uint_value (string name, out uint out_value);
		[Version (since = "1.18")]
		public unowned GLib.Variant get_attr_value (string name);
		[Version (since = "1.2")]
		public void @ref ();
		[Version (since = "1.2")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_object_get_type ()")]
	public abstract class Object : GLib.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_OBJECT_DBUS_CONNECTION")]
		public const string DBUS_CONNECTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_OBJECT_DBUS_OBJECT")]
		public const string DBUS_OBJECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_OBJECT_DBUS_OBJECT_MANAGER")]
		public const string DBUS_OBJECT_MANAGER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_OBJECT_PATH")]
		public const string PATH;
		[CCode (has_construct_function = false)]
		protected Object ();
		public unowned string get_path ();
		[NoWrapper]
		public virtual void init_dbus ();
		[NoWrapper]
		public virtual void object_creation_failed (string failed_path);
		public string path { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_remote_connection_get_type ()")]
	public class RemoteConnection : NM.Object, GLib.AsyncInitable, GLib.Initable, NM.Connection {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_REMOTE_CONNECTION_DBUS_CONNECTION")]
		public const string DBUS_CONNECTION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_REMOTE_CONNECTION_FILENAME")]
		public const string FILENAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_REMOTE_CONNECTION_FLAGS")]
		public const string FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_REMOTE_CONNECTION_PATH")]
		public const string PATH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_REMOTE_CONNECTION_UNSAVED")]
		public const string UNSAVED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_REMOTE_CONNECTION_VISIBLE")]
		public const string VISIBLE;
		[CCode (has_construct_function = false)]
		protected RemoteConnection ();
		public bool commit_changes (bool save_to_disk, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool commit_changes_async (bool save_to_disk, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool @delete (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool delete_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.12")]
		public unowned string get_filename ();
		[Version (since = "1.12")]
		public NM.SettingsConnectionFlags get_flags ();
		public GLib.Variant get_secrets (string setting_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.Variant get_secrets_async (string setting_name, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_unsaved ();
		public bool get_visible ();
		public bool save (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.12")]
		public async GLib.Variant update2 (GLib.Variant? settings, NM.SettingsUpdate2Flags flags, GLib.Variant? args, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "1.12")]
		public string filename { get; }
		[Version (since = "1.12")]
		public uint flags { get; }
		public bool unsaved { get; }
		public bool visible { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_secret_agent_old_get_type ()")]
	public abstract class SecretAgentOld : GLib.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected SecretAgentOld ();
		[NoWrapper]
		public virtual void cancel_get_secrets (string connection_path, string setting_name);
		public virtual void delete_secrets (NM.Connection connection, string connection_path, [CCode (scope = "async")] NM.SecretAgentOldDeleteSecretsFunc callback);
		public bool get_registered ();
		public virtual void get_secrets (NM.Connection connection, string connection_path, string setting_name, [CCode (array_length = false, array_null_terminated = true)] string[] hints, NM.SecretAgentGetSecretsFlags flags, [CCode (scope = "async")] NM.SecretAgentOldGetSecretsFunc callback);
		public bool register (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool register_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void save_secrets (NM.Connection connection, string connection_path, [CCode (scope = "async")] NM.SecretAgentOldSaveSecretsFunc callback);
		public bool unregister (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool unregister_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public bool auto_register { get; set construct; }
		[NoAccessorMethod]
		public NM.SecretAgentCapabilities capabilities { get; set construct; }
		[NoAccessorMethod]
		public string identifier { owned get; construct; }
		public bool registered { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_get_type ()")]
	public abstract class Setting : GLib.Object {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PARAM_FUZZY_IGNORE")]
		public const int FUZZY_IGNORE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PARAM_REQUIRED")]
		public const int REQUIRED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PARAM_SECRET")]
		public const int SECRET;
		[CCode (has_construct_function = false)]
		protected Setting ();
		[NoWrapper]
		public virtual bool aggregate (int type_i, void* arg);
		public bool compare (NM.Setting b, NM.SettingCompareFlags flags);
		public bool diff (NM.Setting b, NM.SettingCompareFlags flags, bool invert_results, ref GLib.HashTable<string,uint32> results);
		public NM.Setting duplicate ();
		public void enumerate_values (NM.SettingValueIterFn func);
		public unowned GLib.VariantType get_dbus_property_type (string property_name);
		public unowned string get_name ();
		public bool get_secret_flags (string secret_name, NM.SettingSecretFlags out_flags) throws GLib.Error;
		[NoWrapper]
		public virtual bool init_from_dbus (GLib.HashTable<void*,void*> keys, GLib.Variant setting_dict, GLib.Variant connection_dict, uint parse_flags) throws GLib.Error;
		public static GLib.Type lookup_type (string name);
		public bool set_secret_flags (string secret_name, NM.SettingSecretFlags flags) throws GLib.Error;
		public string to_string ();
		[NoWrapper]
		public virtual int update_one_secret (string key, GLib.Variant value) throws GLib.Error;
		public bool verify (NM.Connection? connection) throws GLib.Error;
		[Version (since = "1.2")]
		public virtual bool verify_secrets (NM.Connection? connection) throws GLib.Error;
		public string name { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "setting_6lowpan", type_id = "nm_setting_6lowpan_get_type ()")]
	public class Setting6Lowpan : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.14")]
		public Setting6Lowpan ();
		[Version (since = "1.14")]
		public unowned string get_parent ();
		[NoAccessorMethod]
		[Version (since = "1.14")]
		public string parent { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "setting_802_1x", type_id = "nm_setting_802_1x_get_type ()")]
	public class Setting8021x : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_ALTSUBJECT_MATCHES")]
		public const string ALTSUBJECT_MATCHES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_ANONYMOUS_IDENTITY")]
		public const string ANONYMOUS_IDENTITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_AUTH_TIMEOUT")]
		public const string AUTH_TIMEOUT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CA_CERT")]
		public const string CA_CERT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CA_CERT_PASSWORD")]
		public const string CA_CERT_PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CA_CERT_PASSWORD_FLAGS")]
		public const string CA_CERT_PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CA_PATH")]
		public const string CA_PATH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CERT_SCHEME_PREFIX_PATH")]
		public const string CERT_SCHEME_PREFIX_PATH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CERT_SCHEME_PREFIX_PKCS11")]
		public const string CERT_SCHEME_PREFIX_PKCS11;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CLIENT_CERT")]
		public const string CLIENT_CERT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CLIENT_CERT_PASSWORD")]
		public const string CLIENT_CERT_PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_CLIENT_CERT_PASSWORD_FLAGS")]
		public const string CLIENT_CERT_PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_DOMAIN_SUFFIX_MATCH")]
		public const string DOMAIN_SUFFIX_MATCH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_EAP")]
		public const string EAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_IDENTITY")]
		public const string IDENTITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PAC_FILE")]
		public const string PAC_FILE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PASSWORD_RAW")]
		public const string PASSWORD_RAW;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PASSWORD_RAW_FLAGS")]
		public const string PASSWORD_RAW_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE1_AUTH_FLAGS")]
		public const string PHASE1_AUTH_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE1_FAST_PROVISIONING")]
		public const string PHASE1_FAST_PROVISIONING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE1_PEAPLABEL")]
		public const string PHASE1_PEAPLABEL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE1_PEAPVER")]
		public const string PHASE1_PEAPVER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_ALTSUBJECT_MATCHES")]
		public const string PHASE2_ALTSUBJECT_MATCHES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_AUTH")]
		public const string PHASE2_AUTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_AUTHEAP")]
		public const string PHASE2_AUTHEAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_CA_CERT")]
		public const string PHASE2_CA_CERT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_CA_CERT_PASSWORD")]
		public const string PHASE2_CA_CERT_PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_CA_CERT_PASSWORD_FLAGS")]
		public const string PHASE2_CA_CERT_PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_CA_PATH")]
		public const string PHASE2_CA_PATH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_CLIENT_CERT")]
		public const string PHASE2_CLIENT_CERT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_CLIENT_CERT_PASSWORD")]
		public const string PHASE2_CLIENT_CERT_PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_CLIENT_CERT_PASSWORD_FLAGS")]
		public const string PHASE2_CLIENT_CERT_PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_DOMAIN_SUFFIX_MATCH")]
		public const string PHASE2_DOMAIN_SUFFIX_MATCH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_PRIVATE_KEY")]
		public const string PHASE2_PRIVATE_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_PRIVATE_KEY_PASSWORD")]
		public const string PHASE2_PRIVATE_KEY_PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_PRIVATE_KEY_PASSWORD_FLAGS")]
		public const string PHASE2_PRIVATE_KEY_PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PHASE2_SUBJECT_MATCH")]
		public const string PHASE2_SUBJECT_MATCH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PIN")]
		public const string PIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PIN_FLAGS")]
		public const string PIN_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PRIVATE_KEY")]
		public const string PRIVATE_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PRIVATE_KEY_PASSWORD")]
		public const string PRIVATE_KEY_PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_PRIVATE_KEY_PASSWORD_FLAGS")]
		public const string PRIVATE_KEY_PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_SUBJECT_MATCH")]
		public const string SUBJECT_MATCH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_802_1X_SYSTEM_CA_CERTS")]
		public const string SYSTEM_CA_CERTS;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public Setting8021x ();
		public bool add_altsubject_match (string altsubject_match);
		public bool add_eap_method (string eap);
		public bool add_phase2_altsubject_match (string phase2_altsubject_match);
		[Version (since = "1.2")]
		public static NM.Setting8021xCKScheme check_cert_scheme (void* pdata, size_t length) throws GLib.Error;
		public void clear_altsubject_matches ();
		public void clear_eap_methods ();
		public void clear_phase2_altsubject_matches ();
		public unowned string get_altsubject_match (uint32 i);
		public unowned string get_anonymous_identity ();
		[Version (since = "1.8")]
		public int get_auth_timeout ();
		public unowned GLib.Bytes get_ca_cert_blob ();
		[Version (since = "1.8")]
		public unowned string get_ca_cert_password ();
		[Version (since = "1.8")]
		public NM.SettingSecretFlags get_ca_cert_password_flags ();
		public unowned string get_ca_cert_path ();
		public NM.Setting8021xCKScheme get_ca_cert_scheme ();
		[Version (since = "1.6")]
		public unowned string get_ca_cert_uri ();
		public unowned string get_ca_path ();
		public unowned GLib.Bytes get_client_cert_blob ();
		[Version (since = "1.8")]
		public unowned string get_client_cert_password ();
		[Version (since = "1.8")]
		public NM.SettingSecretFlags get_client_cert_password_flags ();
		public unowned string get_client_cert_path ();
		public NM.Setting8021xCKScheme get_client_cert_scheme ();
		[Version (since = "1.6")]
		public unowned string get_client_cert_uri ();
		[Version (since = "1.2")]
		public unowned string get_domain_suffix_match ();
		public unowned string get_eap_method (uint32 i);
		public unowned string get_identity ();
		public uint32 get_num_altsubject_matches ();
		public uint32 get_num_eap_methods ();
		public uint32 get_num_phase2_altsubject_matches ();
		public unowned string get_pac_file ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned GLib.Bytes get_password_raw ();
		public NM.SettingSecretFlags get_password_raw_flags ();
		[Version (since = "1.8")]
		public NM.Setting8021xAuthFlags get_phase1_auth_flags ();
		public unowned string get_phase1_fast_provisioning ();
		public unowned string get_phase1_peaplabel ();
		public unowned string get_phase1_peapver ();
		public unowned string get_phase2_altsubject_match (uint32 i);
		public unowned string get_phase2_auth ();
		public unowned string get_phase2_autheap ();
		public unowned GLib.Bytes get_phase2_ca_cert_blob ();
		[Version (since = "1.8")]
		public unowned string get_phase2_ca_cert_password ();
		[Version (since = "1.8")]
		public NM.SettingSecretFlags get_phase2_ca_cert_password_flags ();
		public unowned string get_phase2_ca_cert_path ();
		public NM.Setting8021xCKScheme get_phase2_ca_cert_scheme ();
		[Version (since = "1.6")]
		public unowned string get_phase2_ca_cert_uri ();
		public unowned string get_phase2_ca_path ();
		public unowned GLib.Bytes get_phase2_client_cert_blob ();
		[Version (since = "1.8")]
		public unowned string get_phase2_client_cert_password ();
		[Version (since = "1.8")]
		public NM.SettingSecretFlags get_phase2_client_cert_password_flags ();
		public unowned string get_phase2_client_cert_path ();
		public NM.Setting8021xCKScheme get_phase2_client_cert_scheme ();
		[Version (since = "1.6")]
		public unowned string get_phase2_client_cert_uri ();
		[Version (since = "1.2")]
		public unowned string get_phase2_domain_suffix_match ();
		public unowned GLib.Bytes get_phase2_private_key_blob ();
		public NM.Setting8021xCKFormat get_phase2_private_key_format ();
		public unowned string get_phase2_private_key_password ();
		public NM.SettingSecretFlags get_phase2_private_key_password_flags ();
		public unowned string get_phase2_private_key_path ();
		public NM.Setting8021xCKScheme get_phase2_private_key_scheme ();
		[Version (since = "1.6")]
		public unowned string get_phase2_private_key_uri ();
		public unowned string get_phase2_subject_match ();
		public unowned string get_pin ();
		public NM.SettingSecretFlags get_pin_flags ();
		public unowned GLib.Bytes get_private_key_blob ();
		public NM.Setting8021xCKFormat get_private_key_format ();
		public unowned string get_private_key_password ();
		public NM.SettingSecretFlags get_private_key_password_flags ();
		public unowned string get_private_key_path ();
		public NM.Setting8021xCKScheme get_private_key_scheme ();
		[Version (since = "1.6")]
		public unowned string get_private_key_uri ();
		public unowned string get_subject_match ();
		public bool get_system_ca_certs ();
		public void remove_altsubject_match (uint32 i);
		public bool remove_altsubject_match_by_value (string altsubject_match);
		public void remove_eap_method (uint32 i);
		public bool remove_eap_method_by_value (string eap);
		public void remove_phase2_altsubject_match (uint32 i);
		public bool remove_phase2_altsubject_match_by_value (string phase2_altsubject_match);
		public bool set_ca_cert (string value, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_client_cert (string value, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_phase2_ca_cert (string value, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_phase2_client_cert (string value, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_phase2_private_key (string value, string password, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		public bool set_private_key (string value, string password, NM.Setting8021xCKScheme scheme, NM.Setting8021xCKFormat out_format) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] altsubject_matches { owned get; set; }
		[NoAccessorMethod]
		public string anonymous_identity { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public int auth_timeout { get; set; }
		[NoAccessorMethod]
		public GLib.Bytes ca_cert { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public string ca_cert_password { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public NM.SettingSecretFlags ca_cert_password_flags { get; set; }
		[NoAccessorMethod]
		public string ca_path { owned get; set; }
		[NoAccessorMethod]
		public GLib.Bytes client_cert { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public string client_cert_password { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public NM.SettingSecretFlags client_cert_password_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string domain_suffix_match { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] eap { owned get; set; }
		[NoAccessorMethod]
		public string identity { owned get; set; }
		[NoAccessorMethod]
		public string pac_file { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags password_flags { get; set; }
		[NoAccessorMethod]
		public GLib.Bytes password_raw { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags password_raw_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public uint phase1_auth_flags { get; set construct; }
		[NoAccessorMethod]
		public string phase1_fast_provisioning { owned get; set; }
		[NoAccessorMethod]
		public string phase1_peaplabel { owned get; set; }
		[NoAccessorMethod]
		public string phase1_peapver { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] phase2_altsubject_matches { owned get; set; }
		[NoAccessorMethod]
		public string phase2_auth { owned get; set; }
		[NoAccessorMethod]
		public string phase2_autheap { owned get; set; }
		[NoAccessorMethod]
		public GLib.Bytes phase2_ca_cert { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public string phase2_ca_cert_password { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public NM.SettingSecretFlags phase2_ca_cert_password_flags { get; set; }
		[NoAccessorMethod]
		public string phase2_ca_path { owned get; set; }
		[NoAccessorMethod]
		public GLib.Bytes phase2_client_cert { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public string phase2_client_cert_password { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public NM.SettingSecretFlags phase2_client_cert_password_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string phase2_domain_suffix_match { owned get; set; }
		[NoAccessorMethod]
		public GLib.Bytes phase2_private_key { owned get; set; }
		[NoAccessorMethod]
		public string phase2_private_key_password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags phase2_private_key_password_flags { get; set; }
		[NoAccessorMethod]
		public string phase2_subject_match { owned get; set; }
		[NoAccessorMethod]
		public string pin { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags pin_flags { get; set; }
		[NoAccessorMethod]
		public GLib.Bytes private_key { owned get; set; }
		[NoAccessorMethod]
		public string private_key_password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags private_key_password_flags { get; set; }
		[NoAccessorMethod]
		public string subject_match { owned get; set; }
		[NoAccessorMethod]
		public bool system_ca_certs { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_adsl_get_type ()")]
	public class SettingAdsl : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_ENCAPSULATION")]
		public const string ENCAPSULATION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_ENCAPSULATION_LLC")]
		public const string ENCAPSULATION_LLC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_ENCAPSULATION_VCMUX")]
		public const string ENCAPSULATION_VCMUX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_PROTOCOL")]
		public const string PROTOCOL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_PROTOCOL_IPOATM")]
		public const string PROTOCOL_IPOATM;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_PROTOCOL_PPPOA")]
		public const string PROTOCOL_PPPOA;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_PROTOCOL_PPPOE")]
		public const string PROTOCOL_PPPOE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_USERNAME")]
		public const string USERNAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_VCI")]
		public const string VCI;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ADSL_VPI")]
		public const string VPI;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingAdsl ();
		public unowned string get_encapsulation ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_protocol ();
		public unowned string get_username ();
		public uint32 get_vci ();
		public uint32 get_vpi ();
		[NoAccessorMethod]
		public string encapsulation { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags password_flags { get; set; }
		[NoAccessorMethod]
		public string protocol { owned get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
		[NoAccessorMethod]
		public uint vci { get; set; }
		[NoAccessorMethod]
		public uint vpi { get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_bluetooth_get_type ()")]
	public class SettingBluetooth : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BLUETOOTH_BDADDR")]
		public const string BDADDR;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BLUETOOTH_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BLUETOOTH_TYPE")]
		public const string TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BLUETOOTH_TYPE_DUN")]
		public const string TYPE_DUN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BLUETOOTH_TYPE_NAP")]
		public const string TYPE_NAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BLUETOOTH_TYPE_PANU")]
		public const string TYPE_PANU;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingBluetooth ();
		public unowned string get_bdaddr ();
		public unowned string get_connection_type ();
		[NoAccessorMethod]
		public string bdaddr { owned get; set; }
		[NoAccessorMethod]
		public string type { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_bond_get_type ()")]
	public class SettingBond : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTIONS")]
		public const string OPTIONS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_ACTIVE_SLAVE")]
		public const string OPTION_ACTIVE_SLAVE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_AD_ACTOR_SYSTEM")]
		public const string OPTION_AD_ACTOR_SYSTEM;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_AD_ACTOR_SYS_PRIO")]
		public const string OPTION_AD_ACTOR_SYS_PRIO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_AD_SELECT")]
		public const string OPTION_AD_SELECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_AD_USER_PORT_KEY")]
		public const string OPTION_AD_USER_PORT_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_ALL_SLAVES_ACTIVE")]
		public const string OPTION_ALL_SLAVES_ACTIVE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_ARP_ALL_TARGETS")]
		public const string OPTION_ARP_ALL_TARGETS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_ARP_INTERVAL")]
		public const string OPTION_ARP_INTERVAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_ARP_IP_TARGET")]
		public const string OPTION_ARP_IP_TARGET;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_ARP_VALIDATE")]
		public const string OPTION_ARP_VALIDATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_DOWNDELAY")]
		public const string OPTION_DOWNDELAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_FAIL_OVER_MAC")]
		public const string OPTION_FAIL_OVER_MAC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_LACP_RATE")]
		public const string OPTION_LACP_RATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_LP_INTERVAL")]
		public const string OPTION_LP_INTERVAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_MIIMON")]
		public const string OPTION_MIIMON;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_MIN_LINKS")]
		public const string OPTION_MIN_LINKS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_MODE")]
		public const string OPTION_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_NUM_GRAT_ARP")]
		public const string OPTION_NUM_GRAT_ARP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_NUM_UNSOL_NA")]
		public const string OPTION_NUM_UNSOL_NA;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_PACKETS_PER_SLAVE")]
		public const string OPTION_PACKETS_PER_SLAVE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_PRIMARY")]
		public const string OPTION_PRIMARY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_PRIMARY_RESELECT")]
		public const string OPTION_PRIMARY_RESELECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_RESEND_IGMP")]
		public const string OPTION_RESEND_IGMP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_TLB_DYNAMIC_LB")]
		public const string OPTION_TLB_DYNAMIC_LB;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_UPDELAY")]
		public const string OPTION_UPDELAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_USE_CARRIER")]
		public const string OPTION_USE_CARRIER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_OPTION_XMIT_HASH_POLICY")]
		public const string OPTION_XMIT_HASH_POLICY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BOND_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingBond ();
		public bool add_option (string name, string value);
		public uint32 get_num_options ();
		public bool get_option (uint32 idx, out unowned string out_name, out unowned string out_value);
		public unowned string get_option_by_name (string name);
		public unowned string get_option_default (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_valid_options ();
		public bool remove_option (string name);
		public static bool validate_option (string name, string value);
		[NoAccessorMethod]
		public GLib.HashTable<string,string> options { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_bridge_get_type ()")]
	public class SettingBridge : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_AGEING_TIME")]
		public const string AGEING_TIME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_FORWARD_DELAY")]
		public const string FORWARD_DELAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_GROUP_FORWARD_MASK")]
		public const string GROUP_FORWARD_MASK;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_HELLO_TIME")]
		public const string HELLO_TIME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_MAX_AGE")]
		public const string MAX_AGE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_MULTICAST_SNOOPING")]
		public const string MULTICAST_SNOOPING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_PORT_HAIRPIN_MODE")]
		public const string PORT_HAIRPIN_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_PORT_PATH_COST")]
		public const string PORT_PATH_COST;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_PORT_PRIORITY")]
		public const string PORT_PRIORITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_PORT_SETTING_NAME")]
		public const string PORT_SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_PORT_VLANS")]
		public const string PORT_VLANS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_PRIORITY")]
		public const string PRIORITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_STP")]
		public const string STP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_VLANS")]
		public const string VLANS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_VLAN_DEFAULT_PVID")]
		public const string VLAN_DEFAULT_PVID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_BRIDGE_VLAN_FILTERING")]
		public const string VLAN_FILTERING;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingBridge ();
		[Version (since = "1.18")]
		public void add_vlan (NM.BridgeVlan vlan);
		[Version (since = "1.18")]
		public void clear_vlans ();
		public uint32 get_ageing_time ();
		public uint16 get_forward_delay ();
		[Version (since = "1.10")]
		public uint16 get_group_forward_mask ();
		public uint16 get_hello_time ();
		public unowned string get_mac_address ();
		public uint16 get_max_age ();
		[Version (since = "1.2")]
		public bool get_multicast_snooping ();
		[Version (since = "1.18")]
		public uint get_num_vlans ();
		public uint16 get_priority ();
		public bool get_stp ();
		[Version (since = "1.18")]
		public unowned NM.BridgeVlan get_vlan (uint idx);
		[Version (since = "1.18")]
		public uint16 get_vlan_default_pvid ();
		[Version (since = "1.18")]
		public bool get_vlan_filtering ();
		[Version (since = "1.18")]
		public void remove_vlan (uint idx);
		[Version (since = "1.18")]
		public bool remove_vlan_by_vid (uint16 vid_start, uint16 vid_end);
		[NoAccessorMethod]
		public uint ageing_time { get; set construct; }
		[NoAccessorMethod]
		public uint forward_delay { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public uint group_forward_mask { get; set construct; }
		[NoAccessorMethod]
		public uint hello_time { get; set construct; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.12")]
		public string mac_address { owned get; set; }
		[NoAccessorMethod]
		public uint max_age { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool multicast_snooping { get; set construct; }
		[NoAccessorMethod]
		public uint priority { get; set construct; }
		[NoAccessorMethod]
		public bool stp { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.18")]
		public uint vlan_default_pvid { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.18")]
		public bool vlan_filtering { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.18")]
		public GLib.GenericArray<NM.BridgeVlan> vlans { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_bridge_port_get_type ()")]
	public class SettingBridgePort : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingBridgePort ();
		[Version (since = "1.18")]
		public void add_vlan (NM.BridgeVlan vlan);
		[Version (since = "1.18")]
		public void clear_vlans ();
		public bool get_hairpin_mode ();
		[Version (since = "1.18")]
		public uint get_num_vlans ();
		public uint16 get_path_cost ();
		public uint16 get_priority ();
		[Version (since = "1.18")]
		public unowned NM.BridgeVlan get_vlan (uint idx);
		[Version (since = "1.18")]
		public void remove_vlan (uint idx);
		[Version (since = "1.18")]
		public bool remove_vlan_by_vid (uint16 vid_start, uint16 vid_end);
		[NoAccessorMethod]
		public bool hairpin_mode { get; set; }
		[NoAccessorMethod]
		public uint path_cost { get; set construct; }
		[NoAccessorMethod]
		public uint priority { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.18")]
		public GLib.GenericArray<NM.BridgeVlan> vlans { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_cdma_get_type ()")]
	public class SettingCdma : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CDMA_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CDMA_NUMBER")]
		public const string NUMBER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CDMA_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CDMA_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CDMA_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CDMA_USERNAME")]
		public const string USERNAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingCdma ();
		[Version (since = "1.8")]
		public uint32 get_mtu ();
		public unowned string get_number ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_username ();
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public string number { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags password_flags { get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_connection_get_type ()")]
	public class SettingConnection : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTH_RETRIES")]
		public const string AUTH_RETRIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT")]
		public const string AUTOCONNECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT_PRIORITY")]
		public const string AUTOCONNECT_PRIORITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT_PRIORITY_DEFAULT")]
		public const int AUTOCONNECT_PRIORITY_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT_PRIORITY_MAX")]
		public const int AUTOCONNECT_PRIORITY_MAX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT_PRIORITY_MIN")]
		public const int AUTOCONNECT_PRIORITY_MIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT_RETRIES")]
		public const string AUTOCONNECT_RETRIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_AUTOCONNECT_SLAVES")]
		public const string AUTOCONNECT_SLAVES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_GATEWAY_PING_TIMEOUT")]
		public const string GATEWAY_PING_TIMEOUT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_ID")]
		public const string ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_INTERFACE_NAME")]
		public const string INTERFACE_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_LLDP")]
		public const string LLDP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_LLMNR")]
		public const string LLMNR;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_MASTER")]
		public const string MASTER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_MDNS")]
		public const string MDNS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_METERED")]
		public const string METERED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_MULTI_CONNECT")]
		public const string MULTI_CONNECT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_PERMISSIONS")]
		public const string PERMISSIONS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_READ_ONLY")]
		public const string READ_ONLY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_SECONDARIES")]
		public const string SECONDARIES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_SLAVE_TYPE")]
		public const string SLAVE_TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_STABLE_ID")]
		public const string STABLE_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_TIMESTAMP")]
		public const string TIMESTAMP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_TYPE")]
		public const string TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_UUID")]
		public const string UUID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_WAIT_DEVICE_TIMEOUT")]
		public const string WAIT_DEVICE_TIMEOUT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_CONNECTION_ZONE")]
		public const string ZONE;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingConnection ();
		public bool add_permission (string ptype, string pitem, string? detail);
		public bool add_secondary (string sec_uuid);
		[Version (since = "1.10")]
		public int get_auth_retries ();
		public bool get_autoconnect ();
		public int get_autoconnect_priority ();
		[Version (since = "1.6")]
		public int get_autoconnect_retries ();
		[Version (since = "1.2")]
		public NM.SettingConnectionAutoconnectSlaves get_autoconnect_slaves ();
		public unowned string get_connection_type ();
		public uint32 get_gateway_ping_timeout ();
		public unowned string get_id ();
		public unowned string get_interface_name ();
		[Version (since = "1.2")]
		public NM.SettingConnectionLldp get_lldp ();
		[Version (since = "1.14")]
		public NM.SettingConnectionLlmnr get_llmnr ();
		public unowned string get_master ();
		[Version (since = "1.12")]
		public NM.SettingConnectionMdns get_mdns ();
		[Version (since = "1.2")]
		public NM.Metered get_metered ();
		[Version (since = "1.14")]
		public NM.ConnectionMultiConnect get_multi_connect ();
		public uint32 get_num_permissions ();
		public uint32 get_num_secondaries ();
		public bool get_permission (uint32 idx, string out_ptype, string out_pitem, string out_detail);
		public bool get_read_only ();
		public unowned string get_secondary (uint32 idx);
		public unowned string get_slave_type ();
		[Version (since = "1.4")]
		public unowned string get_stable_id ();
		public uint64 get_timestamp ();
		public unowned string get_uuid ();
		[Version (since = "1.20")]
		public int32 get_wait_device_timeout ();
		public unowned string get_zone ();
		public bool is_slave_type (string type);
		public bool permissions_user_allowed (string uname);
		public void remove_permission (uint32 idx);
		public bool remove_permission_by_value (string ptype, string pitem, string? detail);
		public void remove_secondary (uint32 idx);
		public bool remove_secondary_by_value (string sec_uuid);
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public int auth_retries { get; set construct; }
		[NoAccessorMethod]
		public bool autoconnect { get; set construct; }
		[NoAccessorMethod]
		public int autoconnect_priority { get; set construct; }
		[NoAccessorMethod]
		public int autoconnect_retries { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public NM.SettingConnectionAutoconnectSlaves autoconnect_slaves { get; set construct; }
		[NoAccessorMethod]
		public uint gateway_ping_timeout { get; set construct; }
		[NoAccessorMethod]
		public string id { owned get; set; }
		[NoAccessorMethod]
		public string interface_name { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public int lldp { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.14")]
		public int llmnr { get; set; }
		[NoAccessorMethod]
		public string master { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int mdns { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public NM.Metered metered { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.14")]
		public int multi_connect { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] permissions { owned get; set; }
		[NoAccessorMethod]
		public bool read_only { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] secondaries { owned get; set; }
		[NoAccessorMethod]
		public string slave_type { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.4")]
		public string stable_id { owned get; set; }
		[NoAccessorMethod]
		public uint64 timestamp { get; set construct; }
		[NoAccessorMethod]
		public string type { owned get; set; }
		[NoAccessorMethod]
		public string uuid { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.20")]
		public int wait_device_timeout { get; set; }
		[NoAccessorMethod]
		public string zone { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_dcb_get_type ()")]
	public class SettingDcb : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_APP_FCOE_FLAGS")]
		public const string APP_FCOE_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_APP_FCOE_MODE")]
		public const string APP_FCOE_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_APP_FCOE_PRIORITY")]
		public const string APP_FCOE_PRIORITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_APP_FIP_FLAGS")]
		public const string APP_FIP_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_APP_FIP_PRIORITY")]
		public const string APP_FIP_PRIORITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_APP_ISCSI_FLAGS")]
		public const string APP_ISCSI_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_APP_ISCSI_PRIORITY")]
		public const string APP_ISCSI_PRIORITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_FCOE_MODE_FABRIC")]
		public const string FCOE_MODE_FABRIC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_FCOE_MODE_VN2VN")]
		public const string FCOE_MODE_VN2VN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_BANDWIDTH")]
		public const string PRIORITY_BANDWIDTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_FLOW_CONTROL")]
		public const string PRIORITY_FLOW_CONTROL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_FLOW_CONTROL_FLAGS")]
		public const string PRIORITY_FLOW_CONTROL_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_GROUP_BANDWIDTH")]
		public const string PRIORITY_GROUP_BANDWIDTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_GROUP_FLAGS")]
		public const string PRIORITY_GROUP_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_GROUP_ID")]
		public const string PRIORITY_GROUP_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_STRICT_BANDWIDTH")]
		public const string PRIORITY_STRICT_BANDWIDTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_PRIORITY_TRAFFIC_CLASS")]
		public const string PRIORITY_TRAFFIC_CLASS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DCB_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingDcb ();
		public NM.SettingDcbFlags get_app_fcoe_flags ();
		public unowned string get_app_fcoe_mode ();
		public int get_app_fcoe_priority ();
		public NM.SettingDcbFlags get_app_fip_flags ();
		public int get_app_fip_priority ();
		public NM.SettingDcbFlags get_app_iscsi_flags ();
		public int get_app_iscsi_priority ();
		public uint get_priority_bandwidth (uint user_priority);
		public bool get_priority_flow_control (uint user_priority);
		public NM.SettingDcbFlags get_priority_flow_control_flags ();
		public uint get_priority_group_bandwidth (uint group_id);
		public NM.SettingDcbFlags get_priority_group_flags ();
		public uint get_priority_group_id (uint user_priority);
		public bool get_priority_strict_bandwidth (uint user_priority);
		public uint get_priority_traffic_class (uint user_priority);
		public void set_priority_bandwidth (uint user_priority, uint bandwidth_percent);
		public void set_priority_flow_control (uint user_priority, bool enabled);
		public void set_priority_group_bandwidth (uint group_id, uint bandwidth_percent);
		public void set_priority_group_id (uint user_priority, uint group_id);
		public void set_priority_strict_bandwidth (uint user_priority, bool strict);
		public void set_priority_traffic_class (uint user_priority, uint traffic_class);
		[NoAccessorMethod]
		public NM.SettingDcbFlags app_fcoe_flags { get; set; }
		[NoAccessorMethod]
		public string app_fcoe_mode { owned get; set construct; }
		[NoAccessorMethod]
		public int app_fcoe_priority { get; set construct; }
		[NoAccessorMethod]
		public NM.SettingDcbFlags app_fip_flags { get; set; }
		[NoAccessorMethod]
		public int app_fip_priority { get; set construct; }
		[NoAccessorMethod]
		public NM.SettingDcbFlags app_iscsi_flags { get; set; }
		[NoAccessorMethod]
		public int app_iscsi_priority { get; set construct; }
		[NoAccessorMethod]
		public GLib.Array<uint> priority_bandwidth { owned get; set; }
		[NoAccessorMethod]
		public GLib.Array<bool> priority_flow_control { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingDcbFlags priority_flow_control_flags { get; set; }
		[NoAccessorMethod]
		public GLib.Array<uint> priority_group_bandwidth { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingDcbFlags priority_group_flags { get; set; }
		[NoAccessorMethod]
		public GLib.Array<uint> priority_group_id { owned get; set; }
		[NoAccessorMethod]
		public GLib.Array<bool> priority_strict_bandwidth { owned get; set; }
		[NoAccessorMethod]
		public GLib.Array<uint> priority_traffic_class { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_dummy_get_type ()")]
	public class SettingDummy : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.8")]
		public SettingDummy ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ethtool_get_type ()")]
	[Version (since = "1.14")]
	public class SettingEthtool : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingEthtool ();
		public void clear_features ();
		public NM.Ternary get_feature (string optname);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.20")]
		public (unowned string)[] get_optnames (out uint out_length);
		public void set_feature (string optname, NM.Ternary value);
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_generic_get_type ()")]
	public class SettingGeneric : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GENERIC_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingGeneric ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_gsm_get_type ()")]
	public class SettingGsm : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_APN")]
		public const string APN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_DEVICE_ID")]
		public const string DEVICE_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_HOME_ONLY")]
		public const string HOME_ONLY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_NETWORK_ID")]
		public const string NETWORK_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_NUMBER")]
		public const string NUMBER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_PIN")]
		public const string PIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_PIN_FLAGS")]
		public const string PIN_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_SIM_ID")]
		public const string SIM_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_SIM_OPERATOR_ID")]
		public const string SIM_OPERATOR_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_GSM_USERNAME")]
		public const string USERNAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingGsm ();
		public unowned string get_apn ();
		[Version (since = "1.2")]
		public unowned string get_device_id ();
		public bool get_home_only ();
		[Version (since = "1.8")]
		public uint32 get_mtu ();
		public unowned string get_network_id ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public unowned string get_number ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_pin ();
		public NM.SettingSecretFlags get_pin_flags ();
		[Version (since = "1.2")]
		public unowned string get_sim_id ();
		[Version (since = "1.2")]
		public unowned string get_sim_operator_id ();
		public unowned string get_username ();
		[NoAccessorMethod]
		public string apn { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string device_id { owned get; set; }
		[NoAccessorMethod]
		public bool home_only { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public string network_id { owned get; set; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public string number { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags password_flags { get; set; }
		[NoAccessorMethod]
		public string pin { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags pin_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string sim_id { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string sim_operator_id { owned get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ip4_config_get_type ()")]
	public class SettingIP4Config : NM.SettingIPConfig {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_DHCP_CLIENT_ID")]
		public const string DHCP_CLIENT_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_DHCP_FQDN")]
		public const string DHCP_FQDN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_AUTO")]
		public const string METHOD_AUTO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_DISABLED")]
		public const string METHOD_DISABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_LINK_LOCAL")]
		public const string METHOD_LINK_LOCAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_MANUAL")]
		public const string METHOD_MANUAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_METHOD_SHARED")]
		public const string METHOD_SHARED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP4_CONFIG_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingIP4Config ();
		public unowned string get_dhcp_client_id ();
		[Version (since = "1.2")]
		public unowned string get_dhcp_fqdn ();
		[NoAccessorMethod]
		public string dhcp_client_id { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string dhcp_fqdn { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ip6_config_get_type ()")]
	public class SettingIP6Config : NM.SettingIPConfig {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_ADDR_GEN_MODE")]
		public const string ADDR_GEN_MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_DHCP_DUID")]
		public const string DHCP_DUID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_IP6_PRIVACY")]
		public const string IP6_PRIVACY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_AUTO")]
		public const string METHOD_AUTO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_DHCP")]
		public const string METHOD_DHCP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_DISABLED")]
		public const string METHOD_DISABLED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_IGNORE")]
		public const string METHOD_IGNORE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_LINK_LOCAL")]
		public const string METHOD_LINK_LOCAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_MANUAL")]
		public const string METHOD_MANUAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_METHOD_SHARED")]
		public const string METHOD_SHARED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP6_CONFIG_TOKEN")]
		public const string TOKEN;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingIP6Config ();
		[Version (since = "1.2")]
		public NM.SettingIP6ConfigAddrGenMode get_addr_gen_mode ();
		[Version (since = "1.12")]
		public unowned string get_dhcp_duid ();
		public NM.SettingIP6ConfigPrivacy get_ip6_privacy ();
		[Version (since = "1.4")]
		public unowned string get_token ();
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public int addr_gen_mode { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public string dhcp_duid { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingIP6ConfigPrivacy ip6_privacy { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.4")]
		public string token { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ip_config_get_type ()")]
	public abstract class SettingIPConfig : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_ADDRESSES")]
		public const string ADDRESSES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DAD_TIMEOUT")]
		public const string DAD_TIMEOUT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DAD_TIMEOUT_MAX")]
		public const int DAD_TIMEOUT_MAX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DHCP_HOSTNAME")]
		public const string DHCP_HOSTNAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DHCP_SEND_HOSTNAME")]
		public const string DHCP_SEND_HOSTNAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DHCP_TIMEOUT")]
		public const string DHCP_TIMEOUT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DNS")]
		public const string DNS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DNS_OPTIONS")]
		public const string DNS_OPTIONS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DNS_PRIORITY")]
		public const string DNS_PRIORITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_DNS_SEARCH")]
		public const string DNS_SEARCH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_GATEWAY")]
		public const string GATEWAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_IGNORE_AUTO_DNS")]
		public const string IGNORE_AUTO_DNS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_IGNORE_AUTO_ROUTES")]
		public const string IGNORE_AUTO_ROUTES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_MAY_FAIL")]
		public const string MAY_FAIL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_METHOD")]
		public const string METHOD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_NEVER_DEFAULT")]
		public const string NEVER_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_ROUTES")]
		public const string ROUTES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_ROUTE_METRIC")]
		public const string ROUTE_METRIC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_ROUTE_TABLE")]
		public const string ROUTE_TABLE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_CONFIG_ROUTING_RULES")]
		public const string ROUTING_RULES;
		[CCode (has_construct_function = false)]
		protected SettingIPConfig ();
		public bool add_address (NM.IPAddress address);
		public bool add_dns (string dns);
		[Version (since = "1.2")]
		public bool add_dns_option (string dns_option);
		public bool add_dns_search (string dns_search);
		public bool add_route (NM.IPRoute route);
		[Version (since = "1.18")]
		public void add_routing_rule (NM.IPRoutingRule routing_rule);
		public void clear_addresses ();
		public void clear_dns ();
		[Version (since = "1.2")]
		public void clear_dns_options (bool is_set);
		public void clear_dns_searches ();
		public void clear_routes ();
		[Version (since = "1.18")]
		public void clear_routing_rules ();
		public unowned NM.IPAddress get_address (int idx);
		[Version (since = "1.2")]
		public int get_dad_timeout ();
		public unowned string get_dhcp_hostname ();
		public bool get_dhcp_send_hostname ();
		[Version (since = "1.2")]
		public int get_dhcp_timeout ();
		public unowned string get_dns (int idx);
		[Version (since = "1.2")]
		public unowned string get_dns_option (uint idx);
		[Version (since = "1.4")]
		public int get_dns_priority ();
		public unowned string get_dns_search (int idx);
		public unowned string get_gateway ();
		public bool get_ignore_auto_dns ();
		public bool get_ignore_auto_routes ();
		public bool get_may_fail ();
		public unowned string get_method ();
		public bool get_never_default ();
		public uint get_num_addresses ();
		public uint get_num_dns ();
		[Version (since = "1.2")]
		public uint get_num_dns_options ();
		public uint get_num_dns_searches ();
		public uint get_num_routes ();
		[Version (since = "1.18")]
		public uint get_num_routing_rules ();
		public unowned NM.IPRoute get_route (int idx);
		public int64 get_route_metric ();
		[Version (since = "1.10")]
		public uint32 get_route_table ();
		[Version (since = "1.18")]
		public unowned NM.IPRoutingRule get_routing_rule (uint idx);
		public bool has_dns_options ();
		[Version (since = "1.2")]
		public int next_valid_dns_option (uint idx);
		public void remove_address (int idx);
		public bool remove_address_by_value (NM.IPAddress address);
		public void remove_dns (int idx);
		public bool remove_dns_by_value (string dns);
		[Version (since = "1.2")]
		public void remove_dns_option (int idx);
		[Version (since = "1.2")]
		public bool remove_dns_option_by_value (string dns_option);
		public void remove_dns_search (int idx);
		public bool remove_dns_search_by_value (string dns_search);
		public void remove_route (int idx);
		public bool remove_route_by_value (NM.IPRoute route);
		[Version (since = "1.18")]
		public void remove_routing_rule (uint idx);
		[NoAccessorMethod]
		public GLib.GenericArray<NM.IPAddress> addresses { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public int dad_timeout { get; set construct; }
		[NoAccessorMethod]
		public string dhcp_hostname { owned get; set; }
		[NoAccessorMethod]
		public bool dhcp_send_hostname { get; set construct; }
		[NoAccessorMethod]
		public int dhcp_timeout { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] dns { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string[] dns_options { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.4")]
		public int dns_priority { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] dns_search { owned get; set; }
		[NoAccessorMethod]
		public string gateway { owned get; set; }
		[NoAccessorMethod]
		public bool ignore_auto_dns { get; set construct; }
		[NoAccessorMethod]
		public bool ignore_auto_routes { get; set construct; }
		[NoAccessorMethod]
		public bool may_fail { get; set construct; }
		[NoAccessorMethod]
		public string method { owned get; set; }
		[NoAccessorMethod]
		public bool never_default { get; set construct; }
		[NoAccessorMethod]
		public int64 route_metric { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public uint route_table { get; set; }
		[NoAccessorMethod]
		public GLib.GenericArray<NM.IPRoute> routes { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ip_tunnel_get_type ()")]
	public class SettingIPTunnel : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_ENCAPSULATION_LIMIT")]
		public const string ENCAPSULATION_LIMIT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_FLAGS")]
		public const string FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_FLOW_LABEL")]
		public const string FLOW_LABEL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_INPUT_KEY")]
		public const string INPUT_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_LOCAL")]
		public const string LOCAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_OUTPUT_KEY")]
		public const string OUTPUT_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_PATH_MTU_DISCOVERY")]
		public const string PATH_MTU_DISCOVERY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_REMOTE")]
		public const string REMOTE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_TOS")]
		public const string TOS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_IP_TUNNEL_TTL")]
		public const string TTL;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.2")]
		public SettingIPTunnel ();
		[Version (since = "1.2")]
		public uint get_encapsulation_limit ();
		public NM.IPTunnelFlags get_flags ();
		[Version (since = "1.2")]
		public uint get_flow_label ();
		[Version (since = "1.2")]
		public unowned string get_input_key ();
		[Version (since = "1.2")]
		public unowned string get_local ();
		[Version (since = "1.2")]
		public NM.IPTunnelMode get_mode ();
		[Version (since = "1.2")]
		public uint get_mtu ();
		[Version (since = "1.2")]
		public unowned string get_output_key ();
		[Version (since = "1.2")]
		public unowned string get_parent ();
		[Version (since = "1.2")]
		public bool get_path_mtu_discovery ();
		[Version (since = "1.2")]
		public unowned string get_remote ();
		[Version (since = "1.2")]
		public uint get_tos ();
		[Version (since = "1.2")]
		public uint get_ttl ();
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint encapsulation_limit { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public uint flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint flow_label { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string input_key { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string local { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint mode { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string output_key { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string parent { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool path_mtu_discovery { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string remote { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint tos { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint ttl { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_infiniband_get_type ()")]
	public class SettingInfiniband : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_INFINIBAND_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_INFINIBAND_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_INFINIBAND_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_INFINIBAND_P_KEY")]
		public const string P_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_INFINIBAND_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_INFINIBAND_TRANSPORT_MODE")]
		public const string TRANSPORT_MODE;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingInfiniband ();
		public unowned string get_mac_address ();
		public uint32 get_mtu ();
		public int get_p_key ();
		public unowned string get_parent ();
		public unowned string get_transport_mode ();
		public unowned string get_virtual_interface_name ();
		[NoAccessorMethod]
		public string mac_address { owned get; set; }
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public int p_key { get; set construct; }
		[NoAccessorMethod]
		public string parent { owned get; set construct; }
		[NoAccessorMethod]
		public string transport_mode { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_macsec_get_type ()")]
	public class SettingMacsec : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.6")]
		public SettingMacsec ();
		[Version (since = "1.6")]
		public bool get_encrypt ();
		[Version (since = "1.6")]
		public unowned string get_mka_cak ();
		[Version (since = "1.6")]
		public NM.SettingSecretFlags get_mka_cak_flags ();
		[Version (since = "1.6")]
		public unowned string get_mka_ckn ();
		[Version (since = "1.6")]
		public NM.SettingMacsecMode get_mode ();
		[Version (since = "1.6")]
		public unowned string get_parent ();
		[Version (since = "1.6")]
		public int get_port ();
		[Version (since = "1.12")]
		public bool get_send_sci ();
		[Version (since = "1.6")]
		public NM.SettingMacsecValidation get_validation ();
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public bool encrypt { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public string mka_cak { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public NM.SettingSecretFlags mka_cak_flags { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public string mka_ckn { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public int mode { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public string parent { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public int port { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public bool send_sci { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public int validation { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_macvlan_get_type ()")]
	public class SettingMacvlan : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACVLAN_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACVLAN_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACVLAN_PROMISCUOUS")]
		public const string PROMISCUOUS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACVLAN_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACVLAN_TAP")]
		public const string TAP;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.2")]
		public SettingMacvlan ();
		[Version (since = "1.2")]
		public NM.SettingMacvlanMode get_mode ();
		[Version (since = "1.2")]
		public unowned string get_parent ();
		[Version (since = "1.2")]
		public bool get_promiscuous ();
		[Version (since = "1.2")]
		public bool get_tap ();
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint mode { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string parent { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool promiscuous { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool tap { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_match_get_type ()")]
	[Version (since = "1.14")]
	public class SettingMatch : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingMatch ();
		public void add_interface_name (string interface_name);
		public void clear_interface_names ();
		public unowned string get_interface_name (int idx);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_interface_names (uint length);
		public uint get_num_interface_names ();
		public void remove_interface_name (int idx);
		public bool remove_interface_name_by_value (string interface_name);
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] interface_name { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_olpc_mesh_get_type ()")]
	public class SettingOlpcMesh : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OLPC_MESH_CHANNEL")]
		public const string CHANNEL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OLPC_MESH_DHCP_ANYCAST_ADDRESS")]
		public const string DHCP_ANYCAST_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OLPC_MESH_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OLPC_MESH_SSID")]
		public const string SSID;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingOlpcMesh ();
		public uint32 get_channel ();
		public unowned string get_dhcp_anycast_address ();
		public unowned GLib.Bytes get_ssid ();
		[NoAccessorMethod]
		public uint channel { get; set construct; }
		[NoAccessorMethod]
		public string dhcp_anycast_address { owned get; set; }
		[NoAccessorMethod]
		public GLib.Bytes ssid { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ovs_bridge_get_type ()")]
	public class SettingOvsBridge : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.10")]
		public SettingOvsBridge ();
		[Version (since = "1.20")]
		public unowned string get_datapath_type ();
		[Version (since = "1.10")]
		public unowned string get_fail_mode ();
		[Version (since = "1.10")]
		public bool get_mcast_snooping_enable ();
		[Version (since = "1.10")]
		public bool get_rstp_enable ();
		[Version (since = "1.10")]
		public bool get_stp_enable ();
		[NoAccessorMethod]
		[Version (since = "1.20")]
		public string datapath_type { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public string fail_mode { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public bool mcast_snooping_enable { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public bool rstp_enable { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public bool stp_enable { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ovs_dpdk_get_type ()")]
	public class SettingOvsDpdk : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.20")]
		public SettingOvsDpdk ();
		[Version (since = "1.20")]
		public unowned string get_devargs ();
		[NoAccessorMethod]
		[Version (since = "1.20")]
		public string devargs { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ovs_interface_get_type ()")]
	public class SettingOvsInterface : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.10")]
		public SettingOvsInterface ();
		[Version (since = "1.10")]
		public unowned string get_interface_type ();
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public string type { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ovs_patch_get_type ()")]
	public class SettingOvsPatch : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.10")]
		public SettingOvsPatch ();
		[Version (since = "1.10")]
		public unowned string get_peer ();
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public string peer { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ovs_port_get_type ()")]
	public class SettingOvsPort : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.10")]
		public SettingOvsPort ();
		[Version (since = "1.10")]
		public uint get_bond_downdelay ();
		[Version (since = "1.10")]
		public unowned string get_bond_mode ();
		[Version (since = "1.10")]
		public uint get_bond_updelay ();
		[Version (since = "1.10")]
		public unowned string get_lacp ();
		[Version (since = "1.10")]
		public uint get_tag ();
		[Version (since = "1.10")]
		public unowned string get_vlan_mode ();
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public uint bond_downdelay { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public string bond_mode { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public uint bond_updelay { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public string lacp { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public uint tag { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public string vlan_mode { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_ppp_get_type ()")]
	public class SettingPpp : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_BAUD")]
		public const string BAUD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_CRTSCTS")]
		public const string CRTSCTS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_LCP_ECHO_FAILURE")]
		public const string LCP_ECHO_FAILURE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_LCP_ECHO_INTERVAL")]
		public const string LCP_ECHO_INTERVAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_MPPE_STATEFUL")]
		public const string MPPE_STATEFUL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_MRU")]
		public const string MRU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_NOAUTH")]
		public const string NOAUTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_NOBSDCOMP")]
		public const string NOBSDCOMP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_NODEFLATE")]
		public const string NODEFLATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_NO_VJ_COMP")]
		public const string NO_VJ_COMP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_REFUSE_CHAP")]
		public const string REFUSE_CHAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_REFUSE_EAP")]
		public const string REFUSE_EAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_REFUSE_MSCHAP")]
		public const string REFUSE_MSCHAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_REFUSE_MSCHAPV2")]
		public const string REFUSE_MSCHAPV2;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_REFUSE_PAP")]
		public const string REFUSE_PAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_REQUIRE_MPPE")]
		public const string REQUIRE_MPPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_REQUIRE_MPPE_128")]
		public const string REQUIRE_MPPE_128;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPP_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingPpp ();
		public uint32 get_baud ();
		public bool get_crtscts ();
		public uint32 get_lcp_echo_failure ();
		public uint32 get_lcp_echo_interval ();
		public bool get_mppe_stateful ();
		public uint32 get_mru ();
		public uint32 get_mtu ();
		public bool get_no_vj_comp ();
		public bool get_noauth ();
		public bool get_nobsdcomp ();
		public bool get_nodeflate ();
		public bool get_refuse_chap ();
		public bool get_refuse_eap ();
		public bool get_refuse_mschap ();
		public bool get_refuse_mschapv2 ();
		public bool get_refuse_pap ();
		public bool get_require_mppe ();
		public bool get_require_mppe_128 ();
		[NoAccessorMethod]
		public uint baud { get; set construct; }
		[NoAccessorMethod]
		public bool crtscts { get; set construct; }
		[NoAccessorMethod]
		public uint lcp_echo_failure { get; set construct; }
		[NoAccessorMethod]
		public uint lcp_echo_interval { get; set construct; }
		[NoAccessorMethod]
		public bool mppe_stateful { get; set construct; }
		[NoAccessorMethod]
		public uint mru { get; set construct; }
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public bool no_vj_comp { get; set construct; }
		[NoAccessorMethod]
		public bool noauth { get; set construct; }
		[NoAccessorMethod]
		public bool nobsdcomp { get; set construct; }
		[NoAccessorMethod]
		public bool nodeflate { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_chap { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_eap { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_mschap { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_mschapv2 { get; set construct; }
		[NoAccessorMethod]
		public bool refuse_pap { get; set construct; }
		[NoAccessorMethod]
		public bool require_mppe { get; set construct; }
		[NoAccessorMethod]
		public bool require_mppe_128 { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_pppoe_get_type ()")]
	public class SettingPppoe : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPPOE_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPPOE_PASSWORD")]
		public const string PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPPOE_PASSWORD_FLAGS")]
		public const string PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPPOE_SERVICE")]
		public const string SERVICE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPPOE_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PPPOE_USERNAME")]
		public const string USERNAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingPppoe ();
		[Version (since = "1.10")]
		public unowned string get_parent ();
		public unowned string get_password ();
		public NM.SettingSecretFlags get_password_flags ();
		public unowned string get_service ();
		public unowned string get_username ();
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public string parent { owned get; set construct; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags password_flags { get; set; }
		[NoAccessorMethod]
		public string service { owned get; set; }
		[NoAccessorMethod]
		public string username { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_proxy_get_type ()")]
	public class SettingProxy : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PROXY_BROWSER_ONLY")]
		public const string BROWSER_ONLY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PROXY_METHOD")]
		public const string METHOD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PROXY_PAC_SCRIPT")]
		public const string PAC_SCRIPT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PROXY_PAC_URL")]
		public const string PAC_URL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_PROXY_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.6")]
		public SettingProxy ();
		[Version (since = "1.6")]
		public bool get_browser_only ();
		[Version (since = "1.6")]
		public NM.SettingProxyMethod get_method ();
		[Version (since = "1.6")]
		public unowned string get_pac_script ();
		[Version (since = "1.6")]
		public unowned string get_pac_url ();
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public bool browser_only { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public int method { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public string pac_script { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.6")]
		public string pac_url { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_serial_get_type ()")]
	public class SettingSerial : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SERIAL_BAUD")]
		public const string BAUD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SERIAL_BITS")]
		public const string BITS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SERIAL_PARITY")]
		public const string PARITY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SERIAL_SEND_DELAY")]
		public const string SEND_DELAY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SERIAL_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SERIAL_STOPBITS")]
		public const string STOPBITS;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingSerial ();
		public uint get_baud ();
		public uint get_bits ();
		public NM.SettingSerialParity get_parity ();
		public uint64 get_send_delay ();
		public uint get_stopbits ();
		[NoAccessorMethod]
		public uint baud { get; set construct; }
		[NoAccessorMethod]
		public uint bits { get; set construct; }
		[NoAccessorMethod]
		public NM.SettingSerialParity parity { get; set construct; }
		[NoAccessorMethod]
		public uint64 send_delay { get; set construct; }
		[NoAccessorMethod]
		public uint stopbits { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_sriov_get_type ()")]
	[Version (since = "1.14")]
	public class SettingSriov : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingSriov ();
		public void add_vf (NM.SriovVF vf);
		public void clear_vfs ();
		public NM.Ternary get_autoprobe_drivers ();
		public uint get_num_vfs ();
		public uint get_total_vfs ();
		public unowned NM.SriovVF get_vf (uint idx);
		public void remove_vf (uint idx);
		public bool remove_vf_by_index (uint index);
		[NoAccessorMethod]
		public NM.Ternary autoprobe_drivers { get; set construct; }
		[NoAccessorMethod]
		public uint total_vfs { get; set construct; }
		[NoAccessorMethod]
		public GLib.GenericArray<NM.SriovVF> vfs { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_tc_config_get_type ()")]
	[Version (since = "1.12")]
	public class SettingTCConfig : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingTCConfig ();
		public bool add_qdisc (NM.TCQdisc qdisc);
		public bool add_tfilter (NM.TCTfilter tfilter);
		public void clear_qdiscs ();
		public void clear_tfilters ();
		public uint get_num_qdiscs ();
		public uint get_num_tfilters ();
		public unowned NM.TCQdisc get_qdisc (uint idx);
		public unowned NM.TCTfilter get_tfilter (uint idx);
		public void remove_qdisc (uint idx);
		public bool remove_qdisc_by_value (NM.TCQdisc qdisc);
		public void remove_tfilter (uint idx);
		public bool remove_tfilter_by_value (NM.TCTfilter tfilter);
		[NoAccessorMethod]
		public GLib.GenericArray<NM.TCQdisc> qdiscs { owned get; set; }
		[NoAccessorMethod]
		public GLib.GenericArray<NM.TCTfilter> tfilters { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_team_get_type ()")]
	public class SettingTeam : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_CONFIG")]
		public const string CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_LINK_WATCHERS")]
		public const string LINK_WATCHERS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_MCAST_REJOIN_COUNT")]
		public const string MCAST_REJOIN_COUNT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_MCAST_REJOIN_INTERVAL")]
		public const string MCAST_REJOIN_INTERVAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_NOTIFY_MCAST_COUNT_ACTIVEBACKUP_DEFAULT")]
		public const int NOTIFY_MCAST_COUNT_ACTIVEBACKUP_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_NOTIFY_PEERS_COUNT")]
		public const string NOTIFY_PEERS_COUNT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_NOTIFY_PEERS_COUNT_ACTIVEBACKUP_DEFAULT")]
		public const int NOTIFY_PEERS_COUNT_ACTIVEBACKUP_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_NOTIFY_PEERS_INTERVAL")]
		public const string NOTIFY_PEERS_INTERVAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_CONFIG")]
		public const string PORT_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_LACP_KEY")]
		public const string PORT_LACP_KEY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_LACP_PRIO")]
		public const string PORT_LACP_PRIO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_LACP_PRIO_DEFAULT")]
		public const int PORT_LACP_PRIO_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_LINK_WATCHERS")]
		public const string PORT_LINK_WATCHERS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_PRIO")]
		public const string PORT_PRIO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_QUEUE_ID")]
		public const string PORT_QUEUE_ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_QUEUE_ID_DEFAULT")]
		public const int PORT_QUEUE_ID_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_SETTING_NAME")]
		public const string PORT_SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_PORT_STICKY")]
		public const string PORT_STICKY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER")]
		public const string RUNNER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_ACTIVE")]
		public const string RUNNER_ACTIVE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_ACTIVEBACKUP")]
		public const string RUNNER_ACTIVEBACKUP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_AGG_SELECT_POLICY")]
		public const string RUNNER_AGG_SELECT_POLICY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_AGG_SELECT_POLICY_BANDWIDTH")]
		public const string RUNNER_AGG_SELECT_POLICY_BANDWIDTH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_AGG_SELECT_POLICY_COUNT")]
		public const string RUNNER_AGG_SELECT_POLICY_COUNT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_AGG_SELECT_POLICY_LACP_PRIO")]
		public const string RUNNER_AGG_SELECT_POLICY_LACP_PRIO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_AGG_SELECT_POLICY_LACP_PRIO_STABLE")]
		public const string RUNNER_AGG_SELECT_POLICY_LACP_PRIO_STABLE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_AGG_SELECT_POLICY_PORT_CONFIG")]
		public const string RUNNER_AGG_SELECT_POLICY_PORT_CONFIG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_BROADCAST")]
		public const string RUNNER_BROADCAST;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_FAST_RATE")]
		public const string RUNNER_FAST_RATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_HWADDR_POLICY")]
		public const string RUNNER_HWADDR_POLICY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_HWADDR_POLICY_BY_ACTIVE")]
		public const string RUNNER_HWADDR_POLICY_BY_ACTIVE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_HWADDR_POLICY_ONLY_ACTIVE")]
		public const string RUNNER_HWADDR_POLICY_ONLY_ACTIVE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_HWADDR_POLICY_SAME_ALL")]
		public const string RUNNER_HWADDR_POLICY_SAME_ALL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_LACP")]
		public const string RUNNER_LACP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_LOADBALANCE")]
		public const string RUNNER_LOADBALANCE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_MIN_PORTS")]
		public const string RUNNER_MIN_PORTS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_RANDOM")]
		public const string RUNNER_RANDOM;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_ROUNDROBIN")]
		public const string RUNNER_ROUNDROBIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_SYS_PRIO")]
		public const string RUNNER_SYS_PRIO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_SYS_PRIO_DEFAULT")]
		public const int RUNNER_SYS_PRIO_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_TX_BALANCER")]
		public const string RUNNER_TX_BALANCER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_TX_BALANCER_INTERVAL")]
		public const string RUNNER_TX_BALANCER_INTERVAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_TX_BALANCER_INTERVAL_DEFAULT")]
		public const int RUNNER_TX_BALANCER_INTERVAL_DEFAULT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_RUNNER_TX_HASH")]
		public const string RUNNER_TX_HASH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TEAM_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingTeam ();
		[Version (since = "1.12")]
		public bool add_link_watcher (NM.TeamLinkWatcher link_watcher);
		[Version (since = "1.12")]
		public bool add_runner_tx_hash (string txhash);
		[Version (since = "1.12")]
		public void clear_link_watchers ();
		public unowned string get_config ();
		[Version (since = "1.12")]
		public unowned NM.TeamLinkWatcher get_link_watcher (uint idx);
		[Version (since = "1.12")]
		public int get_mcast_rejoin_count ();
		[Version (since = "1.12")]
		public int get_mcast_rejoin_interval ();
		[Version (since = "1.12")]
		public int get_notify_peers_count ();
		[Version (since = "1.12")]
		public int get_notify_peers_interval ();
		[Version (since = "1.12")]
		public uint get_num_link_watchers ();
		[Version (since = "1.12")]
		public uint get_num_runner_tx_hash ();
		[Version (since = "1.12")]
		public unowned string get_runner ();
		[Version (since = "1.12")]
		public bool get_runner_active ();
		[Version (since = "1.12")]
		public unowned string get_runner_agg_select_policy ();
		[Version (since = "1.12")]
		public bool get_runner_fast_rate ();
		[Version (since = "1.12")]
		public unowned string get_runner_hwaddr_policy ();
		[Version (since = "1.12")]
		public int get_runner_min_ports ();
		[Version (since = "1.12")]
		public int get_runner_sys_prio ();
		[Version (since = "1.12")]
		public unowned string get_runner_tx_balancer ();
		[Version (since = "1.12")]
		public int get_runner_tx_balancer_interval ();
		[Version (since = "1.12")]
		public unowned string get_runner_tx_hash (uint idx);
		[Version (since = "1.12")]
		public void remove_link_watcher (uint idx);
		[Version (since = "1.12")]
		public bool remove_link_watcher_by_value (NM.TeamLinkWatcher link_watcher);
		[Version (since = "1.12")]
		public void remove_runner_tx_hash (uint idx);
		[Version (since = "1.12")]
		public bool remove_runner_tx_hash_by_value (string txhash);
		[NoAccessorMethod]
		public string config { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public GLib.GenericArray<NM.TeamLinkWatcher> link_watchers { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int mcast_rejoin_count { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int mcast_rejoin_interval { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int notify_peers_count { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int notify_peers_interval { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public string runner { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public bool runner_active { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public string runner_agg_select_policy { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public bool runner_fast_rate { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public string runner_hwaddr_policy { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int runner_min_ports { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int runner_sys_prio { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public string runner_tx_balancer { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int runner_tx_balancer_interval { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public string[] runner_tx_hash { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_team_port_get_type ()")]
	public class SettingTeamPort : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingTeamPort ();
		[Version (since = "1.12")]
		public bool add_link_watcher (NM.TeamLinkWatcher link_watcher);
		[Version (since = "1.12")]
		public void clear_link_watchers ();
		public unowned string get_config ();
		[Version (since = "1.12")]
		public int get_lacp_key ();
		[Version (since = "1.12")]
		public int get_lacp_prio ();
		[Version (since = "1.12")]
		public unowned NM.TeamLinkWatcher get_link_watcher (uint idx);
		[Version (since = "1.12")]
		public uint get_num_link_watchers ();
		[Version (since = "1.12")]
		public int get_prio ();
		[Version (since = "1.12")]
		public int get_queue_id ();
		[Version (since = "1.12")]
		public bool get_sticky ();
		[Version (since = "1.12")]
		public void remove_link_watcher (uint idx);
		[Version (since = "1.12")]
		public bool remove_link_watcher_by_value (NM.TeamLinkWatcher link_watcher);
		[NoAccessorMethod]
		public string config { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int lacp_key { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int lacp_prio { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public GLib.GenericArray<NM.TeamLinkWatcher> link_watchers { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int prio { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int queue_id { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public bool sticky { get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_tun_get_type ()")]
	public class SettingTun : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TUN_GROUP")]
		public const string GROUP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TUN_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TUN_MULTI_QUEUE")]
		public const string MULTI_QUEUE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TUN_OWNER")]
		public const string OWNER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TUN_PI")]
		public const string PI;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TUN_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TUN_VNET_HDR")]
		public const string VNET_HDR;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.2")]
		public SettingTun ();
		[Version (since = "1.2")]
		public unowned string get_group ();
		[Version (since = "1.2")]
		public NM.SettingTunMode get_mode ();
		[Version (since = "1.2")]
		public bool get_multi_queue ();
		[Version (since = "1.2")]
		public unowned string get_owner ();
		[Version (since = "1.2")]
		public bool get_pi ();
		[Version (since = "1.2")]
		public bool get_vnet_hdr ();
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string group { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint mode { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool multi_queue { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string owner { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool pi { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool vnet_hdr { get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_user_get_type ()")]
	public class SettingUser : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingUser ();
		[Version (since = "1.8")]
		public static bool check_key (string key) throws GLib.Error;
		[Version (since = "1.8")]
		public static bool check_val (string val) throws GLib.Error;
		[Version (since = "1.8")]
		public unowned string get_data (string key);
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public unowned string[] get_keys ();
		[Version (since = "1.8")]
		public bool set_data (string key, string? val) throws GLib.Error;
		[NoAccessorMethod]
		[Version (since = "1.8")]
		public GLib.HashTable<string,string> data { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_vlan_get_type ()")]
	public class SettingVlan : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VLAN_EGRESS_PRIORITY_MAP")]
		public const string EGRESS_PRIORITY_MAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VLAN_FLAGS")]
		public const string FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VLAN_ID")]
		public const string ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VLAN_INGRESS_PRIORITY_MAP")]
		public const string INGRESS_PRIORITY_MAP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VLAN_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VLAN_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingVlan ();
		public bool add_priority (NM.VlanPriorityMap map, uint32 from, uint32 to);
		public bool add_priority_str (NM.VlanPriorityMap map, string str);
		public void clear_priorities (NM.VlanPriorityMap map);
		public uint32 get_flags ();
		public uint32 get_id ();
		public int32 get_num_priorities (NM.VlanPriorityMap map);
		public unowned string get_parent ();
		public bool get_priority (NM.VlanPriorityMap map, uint32 idx, out uint32 out_from, out uint32 out_to);
		public void remove_priority (NM.VlanPriorityMap map, uint32 idx);
		public bool remove_priority_by_value (NM.VlanPriorityMap map, uint32 from, uint32 to);
		public bool remove_priority_str_by_value (NM.VlanPriorityMap map, string str);
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] egress_priority_map { owned get; set; }
		[NoAccessorMethod]
		public NM.VlanFlags flags { get; set construct; }
		[NoAccessorMethod]
		public uint id { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] ingress_priority_map { owned get; set; }
		[NoAccessorMethod]
		public string parent { owned get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_vpn_get_type ()")]
	public class SettingVpn : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VPN_DATA")]
		public const string DATA;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VPN_PERSISTENT")]
		public const string PERSISTENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VPN_SECRETS")]
		public const string SECRETS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VPN_SERVICE_TYPE")]
		public const string SERVICE_TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VPN_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VPN_TIMEOUT")]
		public const string TIMEOUT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VPN_USER_NAME")]
		public const string USER_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingVpn ();
		public void add_data_item (string key, string item);
		public void add_secret (string key, string secret);
		public void foreach_data_item (NM.VpnIterFunc func);
		public void foreach_secret (NM.VpnIterFunc func);
		public unowned string get_data_item (string key);
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		[Version (since = "1.12")]
		public (unowned string)[] get_data_keys ();
		public uint32 get_num_data_items ();
		public uint32 get_num_secrets ();
		public bool get_persistent ();
		public unowned string get_secret (string key);
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		[Version (since = "1.12")]
		public (unowned string)[] get_secret_keys ();
		public unowned string get_service_type ();
		[Version (since = "1.2")]
		public uint32 get_timeout ();
		public unowned string get_user_name ();
		public bool remove_data_item (string key);
		public bool remove_secret (string key);
		[NoAccessorMethod]
		public GLib.HashTable<string,string> data { owned get; set; }
		[NoAccessorMethod]
		public bool persistent { get; set; }
		[NoAccessorMethod]
		public GLib.HashTable<string,string> secrets { owned get; set; }
		[NoAccessorMethod]
		public string service_type { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint timeout { get; set; }
		[NoAccessorMethod]
		public string user_name { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_vxlan_get_type ()")]
	public class SettingVxlan : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_AGEING")]
		public const string AGEING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_DESTINATION_PORT")]
		public const string DESTINATION_PORT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_ID")]
		public const string ID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_L2_MISS")]
		public const string L2_MISS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_L3_MISS")]
		public const string L3_MISS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_LEARNING")]
		public const string LEARNING;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_LIMIT")]
		public const string LIMIT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_LOCAL")]
		public const string LOCAL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_PARENT")]
		public const string PARENT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_PROXY")]
		public const string PROXY;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_REMOTE")]
		public const string REMOTE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_RSC")]
		public const string RSC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_SOURCE_PORT_MAX")]
		public const string SOURCE_PORT_MAX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_SOURCE_PORT_MIN")]
		public const string SOURCE_PORT_MIN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_TOS")]
		public const string TOS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_VXLAN_TTL")]
		public const string TTL;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.2")]
		public SettingVxlan ();
		[Version (since = "1.2")]
		public uint get_ageing ();
		[Version (since = "1.2")]
		public uint get_destination_port ();
		[Version (since = "1.2")]
		public uint get_id ();
		[Version (since = "1.2")]
		public bool get_l2_miss ();
		[Version (since = "1.2")]
		public bool get_l3_miss ();
		[Version (since = "1.2")]
		public bool get_learning ();
		[Version (since = "1.2")]
		public uint get_limit ();
		[Version (since = "1.2")]
		public unowned string get_local ();
		[Version (since = "1.2")]
		public unowned string get_parent ();
		[Version (since = "1.2")]
		public bool get_proxy ();
		[Version (since = "1.2")]
		public unowned string get_remote ();
		[Version (since = "1.2")]
		public bool get_rsc ();
		[Version (since = "1.2")]
		public uint get_source_port_max ();
		[Version (since = "1.2")]
		public uint get_source_port_min ();
		[Version (since = "1.2")]
		public uint get_tos ();
		[Version (since = "1.2")]
		public uint get_ttl ();
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint ageing { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint destination_port { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint id { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool l2_miss { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool l3_miss { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool learning { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint limit { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string local { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string parent { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool proxy { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string remote { owned get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool rsc { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint source_port_max { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint source_port_min { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint tos { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint ttl { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "setting_wifi_p2p", type_id = "nm_setting_wifi_p2p_get_type ()")]
	[Version (since = "1.16")]
	public class SettingWifiP2P : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIFI_P2P_PEER")]
		public const string PEER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIFI_P2P_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIFI_P2P_WFD_IES")]
		public const string WFD_IES;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIFI_P2P_WPS_METHOD")]
		public const string WPS_METHOD;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWifiP2P ();
		public unowned string get_peer ();
		public unowned GLib.Bytes get_wfd_ies ();
		public NM.SettingWirelessSecurityWpsMethod get_wps_method ();
		[NoAccessorMethod]
		public string peer { owned get; set; }
		[NoAccessorMethod]
		public GLib.Bytes wfd_ies { owned get; set; }
		[NoAccessorMethod]
		public uint wps_method { get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_wimax_get_type ()")]
	public class SettingWimax : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIMAX_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIMAX_NETWORK_NAME")]
		public const string NETWORK_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIMAX_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public SettingWimax ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned string get_mac_address ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public unowned string get_network_name ();
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string mac_address { owned get; set; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string network_name { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "setting_wireguard", type_id = "nm_setting_wireguard_get_type ()")]
	[Version (since = "1.16")]
	public class SettingWireGuard : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWireGuard ();
		public void append_peer (NM.WireGuardPeer peer);
		public uint clear_peers ();
		public uint32 get_fwmark ();
		[Version (since = "1.20")]
		public NM.Ternary get_ip4_auto_default_route ();
		[Version (since = "1.20")]
		public NM.Ternary get_ip6_auto_default_route ();
		public uint16 get_listen_port ();
		public uint32 get_mtu ();
		public unowned NM.WireGuardPeer get_peer (uint idx);
		public unowned NM.WireGuardPeer get_peer_by_public_key (string public_key, out uint out_idx);
		public bool get_peer_routes ();
		public uint get_peers_len ();
		public unowned string get_private_key ();
		public NM.SettingSecretFlags get_private_key_flags ();
		public bool remove_peer (uint idx);
		public void set_peer (NM.WireGuardPeer peer, uint idx);
		[NoAccessorMethod]
		public uint fwmark { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.20")]
		public NM.Ternary ip4_auto_default_route { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.20")]
		public NM.Ternary ip6_auto_default_route { get; set; }
		[NoAccessorMethod]
		public uint listen_port { get; set; }
		[NoAccessorMethod]
		public uint mtu { get; set; }
		[NoAccessorMethod]
		public bool peer_routes { get; set; }
		[NoAccessorMethod]
		public string private_key { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags private_key_flags { get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_wired_get_type ()")]
	public class SettingWired : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_AUTO_NEGOTIATE")]
		public const string AUTO_NEGOTIATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_CLONED_MAC_ADDRESS")]
		public const string CLONED_MAC_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_DUPLEX")]
		public const string DUPLEX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_GENERATE_MAC_ADDRESS_MASK")]
		public const string GENERATE_MAC_ADDRESS_MASK;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_MAC_ADDRESS_BLACKLIST")]
		public const string MAC_ADDRESS_BLACKLIST;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_PORT")]
		public const string PORT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_S390_NETTYPE")]
		public const string S390_NETTYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_S390_OPTIONS")]
		public const string S390_OPTIONS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_S390_SUBCHANNELS")]
		public const string S390_SUBCHANNELS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_SPEED")]
		public const string SPEED;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_WAKE_ON_LAN")]
		public const string WAKE_ON_LAN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRED_WAKE_ON_LAN_PASSWORD")]
		public const string WAKE_ON_LAN_PASSWORD;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWired ();
		public bool add_mac_blacklist_item (string mac);
		public bool add_s390_option (string key, string value);
		public void clear_mac_blacklist_items ();
		public bool get_auto_negotiate ();
		public unowned string get_cloned_mac_address ();
		public unowned string get_duplex ();
		[Version (since = "1.4")]
		public unowned string get_generate_mac_address_mask ();
		public unowned string get_mac_address ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_mac_address_blacklist ();
		public unowned string get_mac_blacklist_item (uint32 idx);
		public uint32 get_mtu ();
		public uint32 get_num_mac_blacklist_items ();
		public uint32 get_num_s390_options ();
		public unowned string get_port ();
		public unowned string get_s390_nettype ();
		public bool get_s390_option (uint32 idx, out unowned string out_key, out unowned string out_value);
		public unowned string get_s390_option_by_key (string key);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_s390_subchannels ();
		public uint32 get_speed ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_valid_s390_options ();
		[Version (since = "1.2")]
		public NM.SettingWiredWakeOnLan get_wake_on_lan ();
		[Version (since = "1.2")]
		public unowned string get_wake_on_lan_password ();
		public void remove_mac_blacklist_item (uint32 idx);
		public bool remove_mac_blacklist_item_by_value (string mac);
		public bool remove_s390_option (string key);
		[NoAccessorMethod]
		public bool auto_negotiate { get; set construct; }
		[NoAccessorMethod]
		public string cloned_mac_address { owned get; set; }
		[NoAccessorMethod]
		public string duplex { owned get; set; }
		[NoAccessorMethod]
		public string generate_mac_address_mask { owned get; set; }
		[NoAccessorMethod]
		public string mac_address { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] mac_address_blacklist { owned get; set; }
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		public string port { owned get; set; }
		[NoAccessorMethod]
		public string s390_nettype { owned get; set; }
		[NoAccessorMethod]
		public GLib.HashTable<string,string> s390_options { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] s390_subchannels { owned get; set; }
		[NoAccessorMethod]
		public uint speed { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint wake_on_lan { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string wake_on_lan_password { owned get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_wireless_get_type ()")]
	public class SettingWireless : NM.Setting {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_BAND")]
		public const string BAND;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_BSSID")]
		public const string BSSID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_CHANNEL")]
		public const string CHANNEL;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_CLONED_MAC_ADDRESS")]
		public const string CLONED_MAC_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_GENERATE_MAC_ADDRESS_MASK")]
		public const string GENERATE_MAC_ADDRESS_MASK;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_HIDDEN")]
		public const string HIDDEN;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MAC_ADDRESS")]
		public const string MAC_ADDRESS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MAC_ADDRESS_BLACKLIST")]
		public const string MAC_ADDRESS_BLACKLIST;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MAC_ADDRESS_RANDOMIZATION")]
		public const string MAC_ADDRESS_RANDOMIZATION;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MODE")]
		public const string MODE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MODE_ADHOC")]
		public const string MODE_ADHOC;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MODE_AP")]
		public const string MODE_AP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MODE_INFRA")]
		public const string MODE_INFRA;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MODE_MESH")]
		public const string MODE_MESH;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_MTU")]
		public const string MTU;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_POWERSAVE")]
		public const string POWERSAVE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_RATE")]
		public const string RATE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_AUTH_ALG")]
		public const string SECURITY_AUTH_ALG;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_FILS")]
		public const string SECURITY_FILS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_GROUP")]
		public const string SECURITY_GROUP;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_KEY_MGMT")]
		public const string SECURITY_KEY_MGMT;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_LEAP_PASSWORD")]
		public const string SECURITY_LEAP_PASSWORD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_LEAP_PASSWORD_FLAGS")]
		public const string SECURITY_LEAP_PASSWORD_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_LEAP_USERNAME")]
		public const string SECURITY_LEAP_USERNAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_PAIRWISE")]
		public const string SECURITY_PAIRWISE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_PMF")]
		public const string SECURITY_PMF;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_PROTO")]
		public const string SECURITY_PROTO;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_PSK")]
		public const string SECURITY_PSK;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_PSK_FLAGS")]
		public const string SECURITY_PSK_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_SETTING_NAME")]
		public const string SECURITY_SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY0")]
		public const string SECURITY_WEP_KEY0;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY1")]
		public const string SECURITY_WEP_KEY1;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY2")]
		public const string SECURITY_WEP_KEY2;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY3")]
		public const string SECURITY_WEP_KEY3;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY_FLAGS")]
		public const string SECURITY_WEP_KEY_FLAGS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_KEY_TYPE")]
		public const string SECURITY_WEP_KEY_TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WEP_TX_KEYIDX")]
		public const string SECURITY_WEP_TX_KEYIDX;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SECURITY_WPS_METHOD")]
		public const string SECURITY_WPS_METHOD;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SEEN_BSSIDS")]
		public const string SEEN_BSSIDS;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SETTING_NAME")]
		public const string SETTING_NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_SSID")]
		public const string SSID;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_TX_POWER")]
		public const string TX_POWER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIRELESS_WAKE_ON_WLAN")]
		public const string WAKE_ON_WLAN;
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWireless ();
		public bool add_mac_blacklist_item (string mac);
		public bool add_seen_bssid (string bssid);
		public bool ap_security_compatible (NM.SettingWirelessSecurity s_wireless_sec, NM.80211ApFlags ap_flags, NM.80211ApSecurityFlags ap_wpa, NM.80211ApSecurityFlags ap_rsn, NM.80211Mode ap_mode);
		public void clear_mac_blacklist_items ();
		public unowned string get_band ();
		public unowned string get_bssid ();
		public uint32 get_channel ();
		public unowned string get_cloned_mac_address ();
		[Version (since = "1.4")]
		public unowned string get_generate_mac_address_mask ();
		public bool get_hidden ();
		public unowned string get_mac_address ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_mac_address_blacklist ();
		[Version (since = "1.2")]
		public NM.SettingMacRandomization get_mac_address_randomization ();
		public unowned string get_mac_blacklist_item (uint32 idx);
		public unowned string get_mode ();
		public uint32 get_mtu ();
		public uint32 get_num_mac_blacklist_items ();
		public uint32 get_num_seen_bssids ();
		[Version (since = "1.2")]
		public uint32 get_powersave ();
		public uint32 get_rate ();
		public unowned string get_seen_bssid (uint32 i);
		public unowned GLib.Bytes get_ssid ();
		public uint32 get_tx_power ();
		[Version (since = "1.12")]
		public NM.SettingWirelessWakeOnWLan get_wake_on_wlan ();
		public void remove_mac_blacklist_item (uint32 idx);
		public bool remove_mac_blacklist_item_by_value (string mac);
		[NoAccessorMethod]
		public string band { owned get; set; }
		[NoAccessorMethod]
		public string bssid { owned get; set; }
		[NoAccessorMethod]
		public uint channel { get; set construct; }
		[NoAccessorMethod]
		public string cloned_mac_address { owned get; set; }
		[NoAccessorMethod]
		public string generate_mac_address_mask { owned get; set; }
		[NoAccessorMethod]
		public bool hidden { get; set; }
		[NoAccessorMethod]
		public string mac_address { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] mac_address_blacklist { owned get; set; }
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.4", since = "1.2")]
		public uint mac_address_randomization { get; set; }
		[NoAccessorMethod]
		public string mode { owned get; set; }
		[NoAccessorMethod]
		public uint mtu { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public uint powersave { get; set; }
		[NoAccessorMethod]
		public uint rate { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] seen_bssids { owned get; set; }
		[NoAccessorMethod]
		public GLib.Bytes ssid { owned get; set; }
		[NoAccessorMethod]
		public uint tx_power { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public uint wake_on_wlan { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_wireless_security_get_type ()")]
	public class SettingWirelessSecurity : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		public SettingWirelessSecurity ();
		public bool add_group (string group);
		public bool add_pairwise (string pairwise);
		public bool add_proto (string proto);
		public void clear_groups ();
		public void clear_pairwise ();
		public void clear_protos ();
		public unowned string get_auth_alg ();
		public NM.SettingWirelessSecurityFils get_fils ();
		public unowned string get_group (uint32 i);
		public unowned string get_key_mgmt ();
		public unowned string get_leap_password ();
		public NM.SettingSecretFlags get_leap_password_flags ();
		public unowned string get_leap_username ();
		public uint32 get_num_groups ();
		public uint32 get_num_pairwise ();
		public uint32 get_num_protos ();
		public unowned string get_pairwise (uint32 i);
		public NM.SettingWirelessSecurityPmf get_pmf ();
		public unowned string get_proto (uint32 i);
		public unowned string get_psk ();
		public NM.SettingSecretFlags get_psk_flags ();
		public unowned string get_wep_key (uint32 idx);
		public NM.SettingSecretFlags get_wep_key_flags ();
		public NM.WepKeyType get_wep_key_type ();
		public uint32 get_wep_tx_keyidx ();
		[Version (since = "1.10")]
		public NM.SettingWirelessSecurityWpsMethod get_wps_method ();
		public void remove_group (uint32 i);
		public bool remove_group_by_value (string group);
		public void remove_pairwise (uint32 i);
		public bool remove_pairwise_by_value (string pairwise);
		public void remove_proto (uint32 i);
		public bool remove_proto_by_value (string proto);
		public void set_wep_key (uint32 idx, string key);
		[NoAccessorMethod]
		public string auth_alg { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.12")]
		public int fils { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] group { owned get; set; }
		[NoAccessorMethod]
		public string key_mgmt { owned get; set; }
		[NoAccessorMethod]
		public string leap_password { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags leap_password_flags { get; set; }
		[NoAccessorMethod]
		public string leap_username { owned get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] pairwise { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public int pmf { get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] proto { owned get; set; }
		[NoAccessorMethod]
		public string psk { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags psk_flags { get; set; }
		[NoAccessorMethod]
		public string wep_key0 { owned get; set; }
		[NoAccessorMethod]
		public string wep_key1 { owned get; set; }
		[NoAccessorMethod]
		public string wep_key2 { owned get; set; }
		[NoAccessorMethod]
		public string wep_key3 { owned get; set; }
		[NoAccessorMethod]
		public NM.SettingSecretFlags wep_key_flags { get; set; }
		[NoAccessorMethod]
		public NM.WepKeyType wep_key_type { get; set construct; }
		[NoAccessorMethod]
		public uint wep_tx_keyidx { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "1.10")]
		public uint wps_method { get; set construct; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_setting_wpan_get_type ()")]
	public class SettingWpan : NM.Setting {
		[CCode (has_construct_function = false, type = "NMSetting*")]
		[Version (since = "1.14")]
		public SettingWpan ();
		[Version (since = "1.16")]
		public int16 get_channel ();
		[Version (since = "1.14")]
		public unowned string get_mac_address ();
		[Version (since = "1.16")]
		public int16 get_page ();
		[Version (since = "1.14")]
		public uint16 get_pan_id ();
		[Version (since = "1.14")]
		public uint16 get_short_address ();
		[NoAccessorMethod]
		[Version (since = "1.16")]
		public int channel { get; set; }
		[NoAccessorMethod]
		public string mac_address { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "1.16")]
		public int page { get; set; }
		[NoAccessorMethod]
		public uint pan_id { get; set; }
		[NoAccessorMethod]
		public uint short_address { get; set; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_simple_connection_get_type ()")]
	public class SimpleConnection : GLib.Object, NM.Connection {
		[CCode (has_construct_function = false)]
		protected SimpleConnection ();
		public static NM.Connection @new ();
		public static NM.Connection new_clone (NM.Connection connection);
		public static NM.Connection new_from_dbus (GLib.Variant dict) throws GLib.Error;
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_sriov_vf_ref", type_id = "nm_sriov_vf_get_type ()", unref_function = "nm_sriov_vf_unref")]
	[Compact]
	public class SriovVF {
		[CCode (has_construct_function = false)]
		[Version (since = "1.14")]
		public SriovVF (uint index);
		[Version (since = "1.14")]
		public bool add_vlan (uint vlan_id);
		[CCode (cheader_filename = "NetworkManager.h")]
		[Version (since = "1.14")]
		public static bool attribute_validate (string name, GLib.Variant value, out bool known) throws GLib.Error;
		[Version (since = "1.14")]
		public NM.SriovVF dup ();
		[Version (since = "1.14")]
		public bool equal (NM.SriovVF other);
		[Version (since = "1.14")]
		public unowned GLib.Variant get_attribute (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.14")]
		public (unowned string)[] get_attribute_names ();
		[Version (since = "1.14")]
		public uint get_index ();
		[Version (since = "1.14")]
		public uint get_vlan_ids (out uint length);
		public NM.SriovVFVlanProtocol get_vlan_protocol (uint vlan_id);
		[Version (since = "1.14")]
		public uint32 get_vlan_qos (uint vlan_id);
		[Version (since = "1.14")]
		public void @ref ();
		[Version (since = "1.14")]
		public bool remove_vlan (uint vlan_id);
		[Version (since = "1.14")]
		public void set_attribute (string name, GLib.Variant? value);
		[Version (since = "1.14")]
		public void set_vlan_protocol (uint vlan_id, NM.SriovVFVlanProtocol protocol);
		[Version (since = "1.14")]
		public void set_vlan_qos (uint vlan_id, uint32 qos);
		[Version (since = "1.14")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_tc_action_ref", type_id = "nm_tc_action_get_type ()", unref_function = "nm_tc_action_unref")]
	[Compact]
	public class TCAction {
		[CCode (has_construct_function = false)]
		[Version (since = "1.12")]
		public TCAction (string kind) throws GLib.Error;
		[Version (since = "1.12")]
		public NM.TCAction dup ();
		[Version (since = "1.12")]
		public bool equal (NM.TCAction other);
		public unowned GLib.Variant get_attribute (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_attribute_names ();
		[Version (since = "1.12")]
		public unowned string get_kind ();
		[Version (since = "1.12")]
		public void @ref ();
		public void set_attribute (string name, GLib.Variant? value);
		[Version (since = "1.12")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_tc_qdisc_ref", type_id = "nm_tc_qdisc_get_type ()", unref_function = "nm_tc_qdisc_unref")]
	[Compact]
	public class TCQdisc {
		[CCode (has_construct_function = false)]
		[Version (since = "1.12")]
		public TCQdisc (string kind, uint32 parent) throws GLib.Error;
		[Version (since = "1.12")]
		public NM.TCQdisc dup ();
		[Version (since = "1.12")]
		public bool equal (NM.TCQdisc other);
		[Version (since = "1.18")]
		public unowned GLib.Variant get_attribute (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.18")]
		public (unowned string)[] get_attribute_names ();
		[Version (since = "1.12")]
		public uint32 get_handle ();
		[Version (since = "1.12")]
		public unowned string get_kind ();
		[Version (since = "1.12")]
		public uint32 get_parent ();
		[Version (since = "1.12")]
		public void @ref ();
		[Version (since = "1.18")]
		public void set_attribute (string name, GLib.Variant? value);
		[Version (since = "1.12")]
		public void set_handle (uint32 handle);
		[Version (since = "1.12")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_tc_tfilter_ref", type_id = "nm_tc_tfilter_get_type ()", unref_function = "nm_tc_tfilter_unref")]
	[Compact]
	public class TCTfilter {
		[CCode (has_construct_function = false)]
		[Version (since = "1.12")]
		public TCTfilter (string kind, uint32 parent) throws GLib.Error;
		[Version (since = "1.12")]
		public NM.TCTfilter dup ();
		[Version (since = "1.12")]
		public bool equal (NM.TCTfilter other);
		[Version (since = "1.12")]
		public NM.TCAction get_action ();
		[Version (since = "1.12")]
		public uint32 get_handle ();
		[Version (since = "1.12")]
		public unowned string get_kind ();
		[Version (since = "1.12")]
		public uint32 get_parent ();
		[Version (since = "1.12")]
		public void @ref ();
		[Version (since = "1.12")]
		public void set_action (NM.TCAction action);
		[Version (since = "1.12")]
		public void set_handle (uint32 handle);
		[Version (since = "1.12")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", ref_function = "nm_team_link_watcher_ref", type_id = "nm_team_link_watcher_get_type ()", unref_function = "nm_team_link_watcher_unref")]
	[Compact]
	public class TeamLinkWatcher {
		[CCode (has_construct_function = false)]
		[Version (since = "1.12")]
		public TeamLinkWatcher.arp_ping (int init_wait, int interval, int missed_max, string target_host, string source_host, NM.TeamLinkWatcherArpPingFlags flags) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "1.16")]
		public TeamLinkWatcher.arp_ping2 (int init_wait, int interval, int missed_max, int vlanid, string target_host, string source_host, NM.TeamLinkWatcherArpPingFlags flags) throws GLib.Error;
		[Version (since = "1.12")]
		public NM.TeamLinkWatcher dup ();
		[Version (since = "1.12")]
		public bool equal (NM.TeamLinkWatcher other);
		[CCode (has_construct_function = false)]
		[Version (since = "1.12")]
		public TeamLinkWatcher.ethtool (int delay_up, int delay_down) throws GLib.Error;
		[Version (since = "1.12")]
		public int get_delay_down ();
		[Version (since = "1.12")]
		public int get_delay_up ();
		[Version (since = "1.12")]
		public NM.TeamLinkWatcherArpPingFlags get_flags ();
		[Version (since = "1.12")]
		public int get_init_wait ();
		[Version (since = "1.12")]
		public int get_interval ();
		[Version (since = "1.12")]
		public int get_missed_max ();
		[Version (since = "1.12")]
		public unowned string get_name ();
		[Version (since = "1.12")]
		public unowned string get_source_host ();
		[Version (since = "1.12")]
		public unowned string get_target_host ();
		[Version (since = "1.16")]
		public int get_vlanid ();
		[CCode (has_construct_function = false)]
		[Version (since = "1.12")]
		public TeamLinkWatcher.nsna_ping (int init_wait, int interval, int missed_max, string target_host) throws GLib.Error;
		[Version (since = "1.12")]
		public void @ref ();
		[Version (since = "1.12")]
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", has_type_id = false)]
	[Compact]
	public class VariantAttributeSpec {
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_vpn_connection_get_type ()")]
	public class VpnConnection : NM.ActiveConnection, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_CONNECTION_BANNER")]
		public const string BANNER;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VPN_CONNECTION_VPN_STATE")]
		public const string VPN_STATE;
		[CCode (has_construct_function = false)]
		protected VpnConnection ();
		public unowned string get_banner ();
		public NM.VpnConnectionState get_vpn_state ();
		public string banner { get; }
		public NM.VpnConnectionState vpn_state { get; }
		public virtual signal void vpn_state_changed (uint state, uint reason);
	}
	[CCode (cheader_filename = "NetworkManager.h", has_type_id = false)]
	[Compact]
	public class VpnEditorPluginVT {
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_vpn_plugin_info_get_type ()")]
	public class VpnPluginInfo : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected VpnPluginInfo ();
		[CCode (has_construct_function = false)]
		[Version (since = "1.2")]
		public VpnPluginInfo.from_file (string filename) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.4")]
		public unowned string[] get_aliases ();
		[Version (since = "1.4")]
		public unowned string get_auth_dialog ();
		[Version (since = "1.2")]
		public unowned NM.VpnEditorPlugin get_editor_plugin ();
		[Version (since = "1.2")]
		public unowned string get_filename ();
		[Version (since = "1.2")]
		public unowned string get_name ();
		[Version (since = "1.2")]
		public unowned string get_plugin ();
		[Version (since = "1.2")]
		public unowned string get_program ();
		[Version (since = "1.4")]
		public unowned string get_service ();
		[Version (since = "1.2")]
		public static bool list_add (GLib.SList<NM.VpnPluginInfo> list, NM.VpnPluginInfo plugin_info) throws GLib.Error;
		[Version (since = "1.2")]
		public static unowned NM.VpnPluginInfo list_find_by_filename (GLib.SList<NM.VpnPluginInfo> list, string filename);
		[Version (since = "1.2")]
		public static unowned NM.VpnPluginInfo list_find_by_name (GLib.SList<NM.VpnPluginInfo> list, string name);
		[Version (since = "1.2")]
		public static unowned NM.VpnPluginInfo list_find_by_service (GLib.SList<NM.VpnPluginInfo> list, string service);
		[Version (since = "1.4")]
		public static string list_find_service_type (GLib.SList<NM.VpnPluginInfo> list, string name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "1.4")]
		public static string[] list_get_service_types (GLib.SList<NM.VpnPluginInfo> list, bool only_existing, bool with_abbreviations);
		[Version (since = "1.2")]
		public static GLib.SList<NM.VpnPluginInfo> list_load ();
		[Version (since = "1.2")]
		public static bool list_remove (GLib.SList<NM.VpnPluginInfo> list, NM.VpnPluginInfo plugin_info);
		[Version (since = "1.2")]
		public unowned NM.VpnEditorPlugin load_editor_plugin () throws GLib.Error;
		[Version (since = "1.2")]
		public unowned string lookup_property (string group, string key);
		[CCode (has_construct_function = false)]
		[Version (since = "1.4")]
		public VpnPluginInfo.search_file (string? name, string? service);
		[Version (since = "1.2")]
		public void set_editor_plugin (NM.VpnEditorPlugin? plugin);
		[Version (since = "1.4")]
		public bool supports_hints ();
		[Version (since = "1.2")]
		public bool supports_multiple ();
		[Version (since = "1.2")]
		public static bool validate_filename (string filename);
		[CCode (has_construct_function = false)]
		[Version (since = "1.2")]
		public VpnPluginInfo.with_data (string filename, GLib.KeyFile keyfile) throws GLib.Error;
		[Version (since = "1.2")]
		public string filename { get; construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public GLib.KeyFile keyfile { construct; }
		[Version (since = "1.2")]
		public string name { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_vpn_plugin_old_get_type ()")]
	public abstract class VpnPluginOld : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected VpnPluginOld ();
		[NoWrapper]
		public virtual bool connect (NM.Connection connection) throws GLib.Error;
		[NoWrapper]
		public virtual bool connect_interactive (NM.Connection connection, GLib.Variant details) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.2")]
		public virtual bool disconnect () throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.2")]
		public GLib.DBusConnection get_connection ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public static bool get_secret_flags (GLib.HashTable<void*,void*> data, string secret_name, out NM.SettingSecretFlags out_flags);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public NM.VpnServiceState get_state ();
		[NoWrapper]
		public virtual bool need_secrets (NM.Connection connection, string setting_name) throws GLib.Error;
		[NoWrapper]
		public virtual bool new_secrets (NM.Connection connection) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.2")]
		public static bool read_vpn_details (int fd, out GLib.HashTable<void*,void*> out_data, out GLib.HashTable<void*,void*> out_secrets);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public void set_config (GLib.Variant config);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public void set_ip4_config (GLib.Variant ip4_config);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public void set_ip6_config (GLib.Variant ip6_config);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public void set_login_banner (string banner);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public void set_state (NM.VpnServiceState state);
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "1.2")]
		public string service_name { owned get; construct; }
		[Version (deprecated = true, deprecated_since = "1.2")]
		public NM.VpnServiceState state { get; set; }
		public virtual signal void config (GLib.Variant config);
		[HasEmitter]
		public virtual signal void failure (uint reason);
		public virtual signal void ip4_config (GLib.Variant ip4_config);
		public virtual signal void ip6_config (GLib.Variant config);
		public virtual signal void login_banner (string banner);
		public virtual signal void quit ();
		[HasEmitter]
		public signal void secrets_required (string message, [CCode (array_length = false, array_null_terminated = true)] string[] hints);
		public virtual signal void state_changed (uint state);
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_vpn_service_plugin_get_type ()")]
	public abstract class VpnServicePlugin : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected VpnServicePlugin ();
		[NoWrapper]
		public virtual bool connect (NM.Connection connection) throws GLib.Error;
		[NoWrapper]
		public virtual bool connect_interactive (NM.Connection connection, GLib.Variant details) throws GLib.Error;
		public virtual bool disconnect () throws GLib.Error;
		[Version (since = "1.2")]
		public GLib.DBusConnection get_connection ();
		[Version (since = "1.2")]
		public static bool get_secret_flags (GLib.HashTable<void*,void*> data, string secret_name, out NM.SettingSecretFlags out_flags);
		[NoWrapper]
		public virtual bool need_secrets (NM.Connection connection, string setting_name) throws GLib.Error;
		[NoWrapper]
		public virtual bool new_secrets (NM.Connection connection) throws GLib.Error;
		[Version (since = "1.2")]
		public static bool read_vpn_details (int fd, out GLib.HashTable<void*,void*> out_data, out GLib.HashTable<void*,void*> out_secrets);
		public void set_config (GLib.Variant config);
		public void set_ip4_config (GLib.Variant ip4_config);
		public void set_ip6_config (GLib.Variant ip6_config);
		public void set_login_banner (string banner);
		[Version (since = "1.12")]
		public void shutdown ();
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public string service_name { owned get; construct; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public NM.VpnServiceState state { get; set; }
		[NoAccessorMethod]
		[Version (since = "1.2")]
		public bool watch_peer { get; construct; }
		public virtual signal void config (GLib.Variant config);
		[HasEmitter]
		public virtual signal void failure (uint reason);
		public virtual signal void ip4_config (GLib.Variant ip4_config);
		public virtual signal void ip6_config (GLib.Variant config);
		public virtual signal void login_banner (string banner);
		public virtual signal void quit ();
		[HasEmitter]
		public signal void secrets_required (string message, [CCode (array_length = false, array_null_terminated = true)] string[] hints);
		public virtual signal void state_changed (uint state);
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "wifi_p2p_peer", type_id = "nm_wifi_p2p_peer_get_type ()")]
	public class WifiP2PPeer : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected WifiP2PPeer ();
		[Version (since = "1.16")]
		public bool connection_valid (NM.Connection connection);
		[Version (since = "1.16")]
		public GLib.GenericArray<weak NM.Connection> filter_connections (GLib.GenericArray<NM.Connection> connections);
		[Version (since = "1.16")]
		public NM.80211ApFlags get_flags ();
		[Version (since = "1.16")]
		public unowned string get_hw_address ();
		[Version (since = "1.16")]
		public int get_last_seen ();
		[Version (since = "1.16")]
		public unowned string get_manufacturer ();
		[Version (since = "1.16")]
		public unowned string get_model ();
		[Version (since = "1.16")]
		public unowned string get_model_number ();
		[Version (since = "1.16")]
		public unowned string get_name ();
		[Version (since = "1.16")]
		public unowned string get_serial ();
		[Version (since = "1.16")]
		public uint8 get_strength ();
		[Version (since = "1.16")]
		public unowned GLib.Bytes get_wfd_ies ();
		[Version (since = "1.16")]
		public NM.80211ApFlags flags { get; }
		[Version (since = "1.16")]
		public string hw_address { get; }
		[Version (since = "1.16")]
		public int last_seen { get; }
		[Version (since = "1.16")]
		public string manufacturer { get; }
		[Version (since = "1.16")]
		public string model { get; }
		[Version (since = "1.16")]
		public string model_number { get; }
		[Version (since = "1.16")]
		public string name { get; }
		[Version (since = "1.16")]
		public string serial { get; }
		[Version (since = "1.16")]
		public uint8 strength { get; }
		[Version (since = "1.16")]
		public GLib.Bytes wfd_ies { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", type_id = "nm_wimax_nsp_get_type ()")]
	public class WimaxNsp : NM.Object, GLib.AsyncInitable, GLib.Initable {
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIMAX_NSP_NAME")]
		public const string NAME;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIMAX_NSP_NETWORK_TYPE")]
		public const string NETWORK_TYPE;
		[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIMAX_NSP_SIGNAL_QUALITY")]
		public const string SIGNAL_QUALITY;
		[CCode (has_construct_function = false)]
		protected WimaxNsp ();
		public bool connection_valid (NM.Connection connection);
		public GLib.GenericArray<NM.Connection> filter_connections (GLib.GenericArray<NM.Connection> connections);
		public unowned string get_name ();
		public NM.WimaxNspNetworkType get_network_type ();
		public uint32 get_signal_quality ();
		public string name { get; }
		public NM.WimaxNspNetworkType network_type { get; }
		public uint signal_quality { get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", lower_case_csuffix = "wireguard_peer", ref_function = "nm_wireguard_peer_ref", type_id = "nm_wireguard_peer_get_type ()", unref_function = "nm_wireguard_peer_unref")]
	[Compact]
	[Version (since = "1.16")]
	public class WireGuardPeer {
		[CCode (has_construct_function = false)]
		public WireGuardPeer ();
		public bool append_allowed_ip (string allowed_ip, bool accept_invalid);
		public void clear_allowed_ips ();
		public int cmp (NM.WireGuardPeer? b, NM.SettingCompareFlags compare_flags);
		public unowned string get_allowed_ip (uint idx, bool? out_is_valid);
		public uint get_allowed_ips_len ();
		public unowned string get_endpoint ();
		public uint16 get_persistent_keepalive ();
		public unowned string get_preshared_key ();
		public NM.SettingSecretFlags get_preshared_key_flags ();
		public unowned string get_public_key ();
		public bool is_sealed ();
		public bool is_valid (bool check_non_secrets, bool check_secrets) throws GLib.Error;
		public NM.WireGuardPeer new_clone (bool with_secrets);
		public NM.WireGuardPeer @ref ();
		public bool remove_allowed_ip (uint idx);
		public void seal ();
		public bool set_endpoint (string endpoint, bool allow_invalid);
		public void set_persistent_keepalive (uint16 persistent_keepalive);
		public bool set_preshared_key (string? preshared_key, bool accept_invalid);
		public void set_preshared_key_flags (NM.SettingSecretFlags preshared_key_flags);
		public bool set_public_key (string? public_key, bool accept_invalid);
		public void unref ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_cname = "NMConnectionInterface", type_id = "nm_connection_get_type ()")]
	public interface Connection : GLib.Object {
		public void add_setting (owned NM.Setting setting);
		public void clear_secrets ();
		public void clear_secrets_with_flags (NM.SettingClearSecretsWithFlagsFn? func);
		public void clear_settings ();
		public bool compare (NM.Connection b, NM.SettingCompareFlags flags);
		public bool diff (NM.Connection b, NM.SettingCompareFlags flags, GLib.HashTable<string,GLib.HashTable<void*,void*>> out_settings);
		public void dump ();
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark error_quark ();
		public void for_each_setting_value (NM.SettingValueIterFn func);
		public unowned string get_connection_type ();
		public unowned string get_id ();
		public unowned string get_interface_name ();
		public unowned string get_path ();
		public unowned NM.Setting get_setting (GLib.Type setting_type);
		public unowned NM.Setting8021x get_setting_802_1x ();
		public unowned NM.SettingAdsl get_setting_adsl ();
		public unowned NM.SettingBluetooth get_setting_bluetooth ();
		public unowned NM.SettingBond get_setting_bond ();
		public unowned NM.SettingBridge get_setting_bridge ();
		public unowned NM.SettingBridgePort get_setting_bridge_port ();
		public unowned NM.Setting get_setting_by_name (string name);
		public unowned NM.SettingCdma get_setting_cdma ();
		public unowned NM.SettingConnection get_setting_connection ();
		public unowned NM.SettingDcb get_setting_dcb ();
		[Version (since = "1.8")]
		public unowned NM.SettingDummy get_setting_dummy ();
		public unowned NM.SettingGeneric get_setting_generic ();
		public unowned NM.SettingGsm get_setting_gsm ();
		public unowned NM.SettingInfiniband get_setting_infiniband ();
		public unowned NM.SettingIP4Config get_setting_ip4_config ();
		public unowned NM.SettingIP6Config get_setting_ip6_config ();
		[Version (since = "1.2")]
		public unowned NM.SettingIPTunnel get_setting_ip_tunnel ();
		[Version (since = "1.6")]
		public unowned NM.SettingMacsec get_setting_macsec ();
		[Version (since = "1.2")]
		public unowned NM.SettingMacvlan get_setting_macvlan ();
		public unowned NM.SettingOlpcMesh get_setting_olpc_mesh ();
		[Version (since = "1.10")]
		public unowned NM.SettingOvsBridge get_setting_ovs_bridge ();
		[Version (since = "1.10")]
		public unowned NM.SettingOvsInterface get_setting_ovs_interface ();
		[Version (since = "1.10")]
		public unowned NM.SettingOvsPatch get_setting_ovs_patch ();
		[Version (since = "1.10")]
		public unowned NM.SettingOvsPort get_setting_ovs_port ();
		public unowned NM.SettingPpp get_setting_ppp ();
		public unowned NM.SettingPppoe get_setting_pppoe ();
		[Version (since = "1.6")]
		public unowned NM.SettingProxy get_setting_proxy ();
		public unowned NM.SettingSerial get_setting_serial ();
		[Version (since = "1.12")]
		public unowned NM.SettingTCConfig get_setting_tc_config ();
		public unowned NM.SettingTeam get_setting_team ();
		public unowned NM.SettingTeamPort get_setting_team_port ();
		[Version (since = "1.2")]
		public unowned NM.SettingTun get_setting_tun ();
		public unowned NM.SettingVlan get_setting_vlan ();
		public unowned NM.SettingVpn get_setting_vpn ();
		[Version (since = "1.2")]
		public unowned NM.SettingVxlan get_setting_vxlan ();
		public unowned NM.SettingWimax get_setting_wimax ();
		public unowned NM.SettingWired get_setting_wired ();
		public unowned NM.SettingWireless get_setting_wireless ();
		public unowned NM.SettingWirelessSecurity get_setting_wireless_security ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		[Version (since = "1.10")]
		public (unowned NM.Setting)[] get_settings ();
		public unowned string get_uuid ();
		public string get_virtual_device_description ();
		public bool is_type (string type);
		public bool is_virtual ();
		public unowned string need_secrets (out GLib.GenericArray<weak string> hints);
		public bool normalize (GLib.HashTable<string,void*>? parameters, out bool modified) throws GLib.Error;
		public void remove_setting (GLib.Type setting_type);
		public bool replace_settings (GLib.Variant new_settings) throws GLib.Error;
		public void replace_settings_from_connection (NM.Connection new_connection);
		public void set_path (string path);
		public unowned GLib.Variant to_dbus (NM.ConnectionSerializationFlags flags);
		public bool update_secrets (string setting_name, GLib.Variant secrets) throws GLib.Error;
		public bool verify () throws GLib.Error;
		[Version (since = "1.2")]
		public bool verify_secrets () throws GLib.Error;
		public virtual signal void changed ();
		public virtual signal void secrets_cleared ();
		public virtual signal void secrets_updated (string setting);
	}
	[CCode (cheader_filename = "NetworkManager.h", type_cname = "NMVpnEditorInterface", type_id = "nm_vpn_editor_get_type ()")]
	public interface VpnEditor : GLib.Object {
		public abstract unowned GLib.Object get_widget ();
		public abstract bool update_connection (NM.Connection connection) throws GLib.Error;
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "NetworkManager.h", type_cname = "NMVpnEditorPluginInterface", type_id = "nm_vpn_editor_plugin_get_type ()")]
	public interface VpnEditorPlugin : GLib.Object {
		public bool export (string path, NM.Connection connection) throws GLib.Error;
		[NoWrapper]
		public abstract bool export_to_file (string path, NM.Connection connection) throws GLib.Error;
		public abstract NM.VpnEditorPluginCapability get_capabilities ();
		public abstract NM.VpnEditor get_editor (NM.Connection connection) throws GLib.Error;
		[Version (since = "1.4")]
		public unowned NM.VpnPluginInfo get_plugin_info ();
		public abstract string get_suggested_filename (NM.Connection connection);
		[Version (since = "1.4")]
		public size_t get_vt (out unowned NM.VpnEditorPluginVT vt, size_t vt_size);
		public NM.Connection import (string path) throws GLib.Error;
		[Version (since = "1.4")]
		public static NM.VpnEditorPlugin load (string plugin_name, string check_service) throws GLib.Error;
		[Version (since = "1.2")]
		public static NM.VpnEditorPlugin load_from_file (string plugin_name, string check_service, int check_owner, NM.UtilsCheckFilePredicate check_file) throws GLib.Error;
		[NoWrapper]
		public abstract void notify_plugin_info_set (NM.VpnPluginInfo plugin_info);
		[Version (since = "1.4")]
		public void set_plugin_info (NM.VpnPluginInfo? plugin_info);
		[NoAccessorMethod]
		public abstract string description { owned get; }
		[NoAccessorMethod]
		public abstract string name { owned get; }
		[NoAccessorMethod]
		public abstract string service { owned get; }
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_802_11_AP_FLAGS_", type_id = "nm_802_11_ap_flags_get_type ()")]
	[Flags]
	public enum @80211ApFlags {
		NONE,
		PRIVACY,
		WPS,
		WPS_PBC,
		WPS_PIN
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_802_11_AP_SEC_", type_id = "nm_802_11_ap_security_flags_get_type ()")]
	[Flags]
	public enum @80211ApSecurityFlags {
		NONE,
		PAIR_WEP40,
		PAIR_WEP104,
		PAIR_TKIP,
		PAIR_CCMP,
		GROUP_WEP40,
		GROUP_WEP104,
		GROUP_TKIP,
		GROUP_CCMP,
		KEY_MGMT_PSK,
		KEY_MGMT_802_1X,
		KEY_MGMT_SAE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_802_11_MODE_", type_id = "nm_802_11_mode_get_type ()")]
	public enum @80211Mode {
		UNKNOWN,
		ADHOC,
		INFRA,
		AP,
		MESH
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_ACTIVATION_STATE_FLAG_", type_id = "nm_activation_state_flags_get_type ()")]
	[Flags]
	[Version (since = "1.10")]
	public enum ActivationStateFlags {
		NONE,
		IS_MASTER,
		IS_SLAVE,
		LAYER2_READY,
		IP4_READY,
		IP6_READY,
		MASTER_HAS_SLAVES,
		LIFETIME_BOUND_TO_PROFILE_VISIBILITY
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_ACTIVE_CONNECTION_STATE_", type_id = "nm_active_connection_state_get_type ()")]
	public enum ActiveConnectionState {
		UNKNOWN,
		ACTIVATING,
		ACTIVATED,
		DEACTIVATING,
		DEACTIVATED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_ACTIVE_CONNECTION_STATE_REASON_", type_id = "nm_active_connection_state_reason_get_type ()")]
	[Version (since = "1.8")]
	public enum ActiveConnectionStateReason {
		UNKNOWN,
		NONE,
		USER_DISCONNECTED,
		DEVICE_DISCONNECTED,
		SERVICE_STOPPED,
		IP_CONFIG_INVALID,
		CONNECT_TIMEOUT,
		SERVICE_START_TIMEOUT,
		SERVICE_START_FAILED,
		NO_SECRETS,
		LOGIN_FAILED,
		CONNECTION_REMOVED,
		DEPENDENCY_FAILED,
		DEVICE_REALIZE_FAILED,
		DEVICE_REMOVED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_BT_CAPABILITY_", type_id = "nm_bluetooth_capabilities_get_type ()")]
	[Flags]
	public enum BluetoothCapabilities {
		NONE,
		DUN,
		NAP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CAPABILITY_", type_id = "nm_capability_get_type ()")]
	public enum Capability {
		TEAM
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CHECKPOINT_CREATE_FLAG_", type_id = "nm_checkpoint_create_flags_get_type ()")]
	[Flags]
	[Version (since = "1.4")]
	public enum CheckpointCreateFlags {
		NONE,
		DESTROY_ALL,
		DELETE_NEW_CONNECTIONS,
		DISCONNECT_NEW_DEVICES,
		ALLOW_OVERLAPPING
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CLIENT_PERMISSION_", type_id = "nm_client_permission_get_type ()")]
	public enum ClientPermission {
		NONE,
		ENABLE_DISABLE_NETWORK,
		ENABLE_DISABLE_WIFI,
		ENABLE_DISABLE_WWAN,
		ENABLE_DISABLE_WIMAX,
		SLEEP_WAKE,
		NETWORK_CONTROL,
		WIFI_SHARE_PROTECTED,
		WIFI_SHARE_OPEN,
		SETTINGS_MODIFY_SYSTEM,
		SETTINGS_MODIFY_OWN,
		SETTINGS_MODIFY_HOSTNAME,
		SETTINGS_MODIFY_GLOBAL_DNS,
		RELOAD,
		CHECKPOINT_ROLLBACK,
		ENABLE_DISABLE_STATISTICS,
		ENABLE_DISABLE_CONNECTIVITY_CHECK,
		WIFI_SCAN,
		LAST
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CLIENT_PERMISSION_RESULT_", type_id = "nm_client_permission_result_get_type ()")]
	public enum ClientPermissionResult {
		UNKNOWN,
		YES,
		AUTH,
		NO
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CONNECTION_MULTI_CONNECT_", type_id = "nm_connection_multi_connect_get_type ()")]
	[Version (since = "1.14")]
	public enum ConnectionMultiConnect {
		DEFAULT,
		SINGLE,
		MANUAL_MULTIPLE,
		MULTIPLE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CONNECTION_SERIALIZE_", type_id = "nm_connection_serialization_flags_get_type ()")]
	[Flags]
	public enum ConnectionSerializationFlags {
		ALL,
		NO_SECRETS,
		ONLY_SECRETS,
		WITH_SECRETS_AGENT_OWNED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CONNECTIVITY_", type_id = "nm_connectivity_state_get_type ()")]
	public enum ConnectivityState {
		UNKNOWN,
		NONE,
		PORTAL,
		LIMITED,
		FULL
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_CAP_", type_id = "nm_device_capabilities_get_type ()")]
	[Flags]
	public enum DeviceCapabilities {
		NONE,
		NM_SUPPORTED,
		CARRIER_DETECT,
		IS_SOFTWARE,
		SRIOV
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_MODEM_CAPABILITY_", type_id = "nm_device_modem_capabilities_get_type ()")]
	[Flags]
	public enum DeviceModemCapabilities {
		NONE,
		POTS,
		CDMA_EVDO,
		GSM_UMTS,
		LTE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_STATE_", type_id = "nm_device_state_get_type ()")]
	public enum DeviceState {
		UNKNOWN,
		UNMANAGED,
		UNAVAILABLE,
		DISCONNECTED,
		PREPARE,
		CONFIG,
		NEED_AUTH,
		IP_CONFIG,
		IP_CHECK,
		SECONDARIES,
		ACTIVATED,
		DEACTIVATING,
		FAILED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_STATE_REASON_", type_id = "nm_device_state_reason_get_type ()")]
	public enum DeviceStateReason {
		NONE,
		UNKNOWN,
		NOW_MANAGED,
		NOW_UNMANAGED,
		CONFIG_FAILED,
		IP_CONFIG_UNAVAILABLE,
		IP_CONFIG_EXPIRED,
		NO_SECRETS,
		SUPPLICANT_DISCONNECT,
		SUPPLICANT_CONFIG_FAILED,
		SUPPLICANT_FAILED,
		SUPPLICANT_TIMEOUT,
		PPP_START_FAILED,
		PPP_DISCONNECT,
		PPP_FAILED,
		DHCP_START_FAILED,
		DHCP_ERROR,
		DHCP_FAILED,
		SHARED_START_FAILED,
		SHARED_FAILED,
		AUTOIP_START_FAILED,
		AUTOIP_ERROR,
		AUTOIP_FAILED,
		MODEM_BUSY,
		MODEM_NO_DIAL_TONE,
		MODEM_NO_CARRIER,
		MODEM_DIAL_TIMEOUT,
		MODEM_DIAL_FAILED,
		MODEM_INIT_FAILED,
		GSM_APN_FAILED,
		GSM_REGISTRATION_NOT_SEARCHING,
		GSM_REGISTRATION_DENIED,
		GSM_REGISTRATION_TIMEOUT,
		GSM_REGISTRATION_FAILED,
		GSM_PIN_CHECK_FAILED,
		FIRMWARE_MISSING,
		REMOVED,
		SLEEPING,
		CONNECTION_REMOVED,
		USER_REQUESTED,
		CARRIER,
		CONNECTION_ASSUMED,
		SUPPLICANT_AVAILABLE,
		MODEM_NOT_FOUND,
		BT_FAILED,
		GSM_SIM_NOT_INSERTED,
		GSM_SIM_PIN_REQUIRED,
		GSM_SIM_PUK_REQUIRED,
		GSM_SIM_WRONG,
		INFINIBAND_MODE,
		DEPENDENCY_FAILED,
		BR2684_FAILED,
		MODEM_MANAGER_UNAVAILABLE,
		SSID_NOT_FOUND,
		SECONDARY_CONNECTION_FAILED,
		DCB_FCOE_FAILED,
		TEAMD_CONTROL_FAILED,
		MODEM_FAILED,
		MODEM_AVAILABLE,
		SIM_PIN_INCORRECT,
		NEW_ACTIVATION,
		PARENT_CHANGED,
		PARENT_MANAGED_CHANGED,
		OVSDB_FAILED,
		IP_ADDRESS_DUPLICATE,
		IP_METHOD_UNSUPPORTED,
		SRIOV_CONFIGURATION_FAILED,
		PEER_NOT_FOUND
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_TYPE_", type_id = "nm_device_type_get_type ()")]
	public enum DeviceType {
		UNKNOWN,
		ETHERNET,
		WIFI,
		UNUSED1,
		UNUSED2,
		BT,
		OLPC_MESH,
		WIMAX,
		MODEM,
		INFINIBAND,
		BOND,
		VLAN,
		ADSL,
		BRIDGE,
		GENERIC,
		TEAM,
		TUN,
		IP_TUNNEL,
		MACVLAN,
		VXLAN,
		VETH,
		MACSEC,
		DUMMY,
		PPP,
		OVS_INTERFACE,
		OVS_PORT,
		OVS_BRIDGE,
		WPAN,
		@6LOWPAN,
		WIREGUARD,
		WIFI_P2P
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_WIFI_DEVICE_CAP_", type_id = "nm_device_wifi_capabilities_get_type ()")]
	[Flags]
	public enum DeviceWifiCapabilities {
		NONE,
		CIPHER_WEP40,
		CIPHER_WEP104,
		CIPHER_TKIP,
		CIPHER_CCMP,
		WPA,
		RSN,
		AP,
		ADHOC,
		FREQ_VALID,
		FREQ_2GHZ,
		FREQ_5GHZ,
		MESH
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_IP_ROUTING_RULE_AS_STRING_FLAGS_", type_id = "nm_ip_routing_rule_as_string_flags_get_type ()")]
	[Flags]
	[Version (since = "1.18")]
	public enum IPRoutingRuleAsStringFlags {
		NONE,
		AF_INET,
		AF_INET6,
		VALIDATE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_IP_TUNNEL_FLAG_", type_id = "nm_ip_tunnel_flags_get_type ()")]
	[Flags]
	public enum IPTunnelFlags {
		NONE,
		IP6_IGN_ENCAP_LIMIT,
		IP6_USE_ORIG_TCLASS,
		IP6_USE_ORIG_FLOWLABEL,
		IP6_MIP6_DEV,
		IP6_RCV_DSCP_COPY,
		IP6_USE_ORIG_FWMARK
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_IP_TUNNEL_MODE_", type_id = "nm_ip_tunnel_mode_get_type ()")]
	[Version (since = "1.2")]
	public enum IPTunnelMode {
		UNKNOWN,
		IPIP,
		GRE,
		SIT,
		ISATAP,
		VTI,
		IP6IP6,
		IPIP6,
		IP6GRE,
		VTI6,
		GRETAP,
		IP6GRETAP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_METERED_", type_id = "nm_metered_get_type ()")]
	[Version (since = "1.2")]
	public enum Metered {
		UNKNOWN,
		YES,
		NO,
		GUESS_YES,
		GUESS_NO
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_ROLLBACK_RESULT_", has_type_id = false)]
	[Version (since = "1.4")]
	public enum RollbackResult {
		OK,
		ERR_NO_DEVICE,
		ERR_DEVICE_UNMANAGED,
		ERR_FAILED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SECRET_AGENT_CAPABILITY_", type_id = "nm_secret_agent_capabilities_get_type ()")]
	[Flags]
	public enum SecretAgentCapabilities {
		NONE,
		VPN_HINTS,
		LAST
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SECRET_AGENT_GET_SECRETS_FLAG_", type_id = "nm_secret_agent_get_secrets_flags_get_type ()")]
	[Flags]
	public enum SecretAgentGetSecretsFlags {
		NONE,
		ALLOW_INTERACTION,
		REQUEST_NEW,
		USER_REQUESTED,
		WPS_PBC_ACTIVE,
		ONLY_SYSTEM,
		NO_ERRORS
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_802_1X_AUTH_FLAGS_", type_id = "nm_setting_802_1x_auth_flags_get_type ()")]
	[Version (since = "1.8")]
	public enum Setting8021xAuthFlags {
		NONE,
		TLS_1_0_DISABLE,
		TLS_1_1_DISABLE,
		TLS_1_2_DISABLE,
		ALL
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_802_1X_CK_FORMAT_", type_id = "nm_setting_802_1x_ck_format_get_type ()")]
	public enum Setting8021xCKFormat {
		UNKNOWN,
		X509,
		RAW_KEY,
		PKCS12
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_802_1X_CK_SCHEME_", type_id = "nm_setting_802_1x_ck_scheme_get_type ()")]
	public enum Setting8021xCKScheme {
		UNKNOWN,
		BLOB,
		PATH,
		PKCS11
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_COMPARE_FLAG_", type_id = "nm_setting_compare_flags_get_type ()")]
	public enum SettingCompareFlags {
		EXACT,
		FUZZY,
		IGNORE_ID,
		IGNORE_SECRETS,
		IGNORE_AGENT_OWNED_SECRETS,
		IGNORE_NOT_SAVED_SECRETS,
		DIFF_RESULT_WITH_DEFAULT,
		DIFF_RESULT_NO_DEFAULT,
		IGNORE_TIMESTAMP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_CONNECTION_AUTOCONNECT_SLAVES_", type_id = "nm_setting_connection_autoconnect_slaves_get_type ()")]
	public enum SettingConnectionAutoconnectSlaves {
		DEFAULT,
		NO,
		YES
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_CONNECTION_LLDP_", type_id = "nm_setting_connection_lldp_get_type ()")]
	public enum SettingConnectionLldp {
		DEFAULT,
		DISABLE,
		ENABLE_RX
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_CONNECTION_LLMNR_", type_id = "nm_setting_connection_llmnr_get_type ()")]
	[Version (since = "1.14")]
	public enum SettingConnectionLlmnr {
		DEFAULT,
		NO,
		RESOLVE,
		YES
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_CONNECTION_MDNS_", type_id = "nm_setting_connection_mdns_get_type ()")]
	[Version (since = "1.12")]
	public enum SettingConnectionMdns {
		DEFAULT,
		NO,
		RESOLVE,
		YES
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_DCB_FLAG_", type_id = "nm_setting_dcb_flags_get_type ()")]
	[Flags]
	public enum SettingDcbFlags {
		NONE,
		ENABLE,
		ADVERTISE,
		WILLING
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_DIFF_RESULT_", type_id = "nm_setting_diff_result_get_type ()")]
	public enum SettingDiffResult {
		UNKNOWN,
		IN_A,
		IN_B,
		IN_A_DEFAULT,
		IN_B_DEFAULT
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_IP6_CONFIG_ADDR_GEN_MODE_", type_id = "nm_setting_ip6_config_addr_gen_mode_get_type ()")]
	[Version (since = "1.2")]
	public enum SettingIP6ConfigAddrGenMode {
		EUI64,
		STABLE_PRIVACY
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_IP6_CONFIG_PRIVACY_", type_id = "nm_setting_ip6_config_privacy_get_type ()")]
	public enum SettingIP6ConfigPrivacy {
		UNKNOWN,
		DISABLED,
		PREFER_PUBLIC_ADDR,
		PREFER_TEMP_ADDR
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_MAC_RANDOMIZATION_", type_id = "nm_setting_mac_randomization_get_type ()")]
	public enum SettingMacRandomization {
		DEFAULT,
		NEVER,
		ALWAYS
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_MACSEC_MODE_", type_id = "nm_setting_macsec_mode_get_type ()")]
	[Version (since = "1.6")]
	public enum SettingMacsecMode {
		PSK,
		EAP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_MACSEC_VALIDATION_", type_id = "nm_setting_macsec_validation_get_type ()")]
	[Version (since = "1.6")]
	public enum SettingMacsecValidation {
		DISABLE,
		CHECK,
		STRICT
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_MACVLAN_MODE_", type_id = "nm_setting_macvlan_mode_get_type ()")]
	public enum SettingMacvlanMode {
		UNKNOWN,
		VEPA,
		BRIDGE,
		PRIVATE,
		PASSTHRU,
		SOURCE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_PROXY_METHOD_", type_id = "nm_setting_proxy_method_get_type ()")]
	[Version (since = "1.6")]
	public enum SettingProxyMethod {
		NONE,
		AUTO
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_SECRET_FLAG_", type_id = "nm_setting_secret_flags_get_type ()")]
	[Flags]
	public enum SettingSecretFlags {
		NONE,
		AGENT_OWNED,
		NOT_SAVED,
		NOT_REQUIRED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_SERIAL_PARITY_", type_id = "nm_setting_serial_parity_get_type ()")]
	public enum SettingSerialParity {
		NONE,
		EVEN,
		ODD
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_TUN_MODE_", type_id = "nm_setting_tun_mode_get_type ()")]
	public enum SettingTunMode {
		UNKNOWN,
		TUN,
		TAP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_WIRED_WAKE_ON_LAN_", type_id = "nm_setting_wired_wake_on_lan_get_type ()")]
	[Flags]
	[Version (since = "1.2")]
	public enum SettingWiredWakeOnLan {
		PHY,
		UNICAST,
		MULTICAST,
		BROADCAST,
		ARP,
		MAGIC,
		DEFAULT,
		IGNORE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_WIRELESS_POWERSAVE_", type_id = "nm_setting_wireless_powersave_get_type ()")]
	public enum SettingWirelessPowersave {
		DEFAULT,
		IGNORE,
		DISABLE,
		ENABLE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_WIRELESS_SECURITY_FILS_", type_id = "nm_setting_wireless_security_fils_get_type ()")]
	[Version (since = "1.12")]
	public enum SettingWirelessSecurityFils {
		DEFAULT,
		DISABLE,
		OPTIONAL,
		REQUIRED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_WIRELESS_SECURITY_PMF_", type_id = "nm_setting_wireless_security_pmf_get_type ()")]
	public enum SettingWirelessSecurityPmf {
		DEFAULT,
		DISABLE,
		OPTIONAL,
		REQUIRED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_WIRELESS_SECURITY_WPS_METHOD_", type_id = "nm_setting_wireless_security_wps_method_get_type ()")]
	[Flags]
	[Version (since = "1.10")]
	public enum SettingWirelessSecurityWpsMethod {
		DEFAULT,
		DISABLED,
		AUTO,
		PBC,
		PIN
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTING_WIRELESS_WAKE_ON_WLAN_", type_id = "nm_setting_wireless_wake_on_wlan_get_type ()")]
	[Flags]
	[Version (since = "1.12")]
	public enum SettingWirelessWakeOnWLan {
		ANY,
		DISCONNECT,
		MAGIC,
		GTK_REKEY_FAILURE,
		EAP_IDENTITY_REQUEST,
		@4WAY_HANDSHAKE,
		RFKILL_RELEASE,
		TCP,
		ALL,
		DEFAULT,
		IGNORE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTINGS_ADD_CONNECTION2_FLAG_", type_id = "nm_settings_add_connection2_flags_get_type ()")]
	[Flags]
	[Version (since = "1.20")]
	public enum SettingsAddConnection2Flags {
		NONE,
		TO_DISK,
		IN_MEMORY,
		BLOCK_AUTOCONNECT
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTINGS_CONNECTION_FLAG_", type_id = "nm_settings_connection_flags_get_type ()")]
	[Flags]
	[Version (since = "1.12")]
	public enum SettingsConnectionFlags {
		NONE,
		UNSAVED,
		NM_GENERATED,
		VOLATILE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTINGS_UPDATE2_FLAG_", type_id = "nm_settings_update2_flags_get_type ()")]
	[Flags]
	[Version (since = "1.12")]
	public enum SettingsUpdate2Flags {
		NONE,
		TO_DISK,
		IN_MEMORY,
		IN_MEMORY_DETACHED,
		IN_MEMORY_ONLY,
		VOLATILE,
		BLOCK_AUTOCONNECT,
		NO_REAPPLY
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SRIOV_VF_VLAN_PROTOCOL_802_", type_id = "nm_sriov_vf_vlan_protocol_get_type ()")]
	[Version (since = "1.14")]
	public enum SriovVFVlanProtocol {
		@1Q,
		@1AD
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_STATE_", type_id = "nm_state_get_type ()")]
	public enum State {
		UNKNOWN,
		ASLEEP,
		DISCONNECTED,
		DISCONNECTING,
		CONNECTING,
		CONNECTED_LOCAL,
		CONNECTED_SITE,
		CONNECTED_GLOBAL
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_TEAM_LINK_WATCHER_ARP_PING_FLAG_", type_id = "nm_team_link_watcher_arp_ping_flags_get_type ()")]
	[Flags]
	public enum TeamLinkWatcherArpPingFlags {
		VALIDATE_ACTIVE,
		VALIDATE_INACTIVE,
		SEND_ALWAYS
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_TERNARY_", type_id = "nm_ternary_get_type ()")]
	[Version (since = "1.14")]
	public enum Ternary {
		DEFAULT,
		FALSE,
		TRUE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VLAN_FLAG_", type_id = "nm_vlan_flags_get_type ()")]
	[Flags]
	public enum VlanFlags {
		REORDER_HEADERS,
		GVRP,
		LOOSE_BINDING,
		MVRP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VLAN_", type_id = "nm_vlan_priority_map_get_type ()")]
	public enum VlanPriorityMap {
		INGRESS_MAP,
		EGRESS_MAP
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VPN_CONNECTION_STATE_", type_id = "nm_vpn_connection_state_get_type ()")]
	public enum VpnConnectionState {
		UNKNOWN,
		PREPARE,
		NEED_AUTH,
		CONNECT,
		IP_CONFIG_GET,
		ACTIVATED,
		FAILED,
		DISCONNECTED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VPN_CONNECTION_STATE_REASON_", type_id = "nm_vpn_connection_state_reason_get_type ()")]
	public enum VpnConnectionStateReason {
		UNKNOWN,
		NONE,
		USER_DISCONNECTED,
		DEVICE_DISCONNECTED,
		SERVICE_STOPPED,
		IP_CONFIG_INVALID,
		CONNECT_TIMEOUT,
		SERVICE_START_TIMEOUT,
		SERVICE_START_FAILED,
		NO_SECRETS,
		LOGIN_FAILED,
		CONNECTION_REMOVED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VPN_EDITOR_PLUGIN_CAPABILITY_", type_id = "nm_vpn_editor_plugin_capability_get_type ()")]
	[Flags]
	public enum VpnEditorPluginCapability {
		NONE,
		IMPORT,
		EXPORT,
		IPV6
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VPN_PLUGIN_FAILURE_", type_id = "nm_vpn_plugin_failure_get_type ()")]
	public enum VpnPluginFailure {
		LOGIN_FAILED,
		CONNECT_FAILED,
		BAD_IP_CONFIG
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VPN_SERVICE_STATE_", type_id = "nm_vpn_service_state_get_type ()")]
	public enum VpnServiceState {
		UNKNOWN,
		INIT,
		SHUTDOWN,
		STARTING,
		STARTED,
		STOPPING,
		STOPPED
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_WEP_KEY_TYPE_", type_id = "nm_wep_key_type_get_type ()")]
	public enum WepKeyType {
		UNKNOWN,
		KEY,
		PASSPHRASE
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_WIMAX_NSP_NETWORK_TYPE_", type_id = "nm_wimax_nsp_network_type_get_type ()")]
	public enum WimaxNspNetworkType {
		UNKNOWN,
		HOME,
		PARTNER,
		ROAMING_PARTNER
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_AGENT_MANAGER_ERROR_")]
	public errordomain AgentManagerError {
		FAILED,
		[CCode (cname = "NM_AGENT_MANAGER_ERROR_PERMISSION_DENIED")]
		PERMISSIONDENIED,
		[CCode (cname = "NM_AGENT_MANAGER_ERROR_INVALID_IDENTIFIER")]
		INVALIDIDENTIFIER,
		[CCode (cname = "NM_AGENT_MANAGER_ERROR_NOT_REGISTERED")]
		NOTREGISTERED,
		[CCode (cname = "NM_AGENT_MANAGER_ERROR_NO_SECRETS")]
		NOSECRETS,
		[CCode (cname = "NM_AGENT_MANAGER_ERROR_USER_CANCELED")]
		USERCANCELED;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CLIENT_ERROR_")]
	public errordomain ClientError {
		FAILED,
		MANAGER_NOT_RUNNING,
		OBJECT_CREATION_FAILED;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CONNECTION_ERROR_")]
	public errordomain ConnectionError {
		FAILED,
		[CCode (cname = "NM_CONNECTION_ERROR_SETTING_NOT_FOUND")]
		SETTINGNOTFOUND,
		[CCode (cname = "NM_CONNECTION_ERROR_PROPERTY_NOT_FOUND")]
		PROPERTYNOTFOUND,
		[CCode (cname = "NM_CONNECTION_ERROR_PROPERTY_NOT_SECRET")]
		PROPERTYNOTSECRET,
		[CCode (cname = "NM_CONNECTION_ERROR_MISSING_SETTING")]
		MISSINGSETTING,
		[CCode (cname = "NM_CONNECTION_ERROR_INVALID_SETTING")]
		INVALIDSETTING,
		[CCode (cname = "NM_CONNECTION_ERROR_MISSING_PROPERTY")]
		MISSINGPROPERTY,
		[CCode (cname = "NM_CONNECTION_ERROR_INVALID_PROPERTY")]
		INVALIDPROPERTY
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_CRYPTO_ERROR_")]
	public errordomain CryptoError {
		FAILED,
		INVALID_DATA,
		INVALID_PASSWORD,
		UNKNOWN_CIPHER,
		DECRYPTION_FAILED,
		ENCRYPTION_FAILED;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_DEVICE_ERROR_")]
	public errordomain DeviceError {
		FAILED,
		[CCode (cname = "NM_DEVICE_ERROR_CREATION_FAILED")]
		CREATIONFAILED,
		[CCode (cname = "NM_DEVICE_ERROR_INVALID_CONNECTION")]
		INVALIDCONNECTION,
		[CCode (cname = "NM_DEVICE_ERROR_INCOMPATIBLE_CONNECTION")]
		INCOMPATIBLECONNECTION,
		[CCode (cname = "NM_DEVICE_ERROR_NOT_ACTIVE")]
		NOTACTIVE,
		[CCode (cname = "NM_DEVICE_ERROR_NOT_SOFTWARE")]
		NOTSOFTWARE,
		[CCode (cname = "NM_DEVICE_ERROR_NOT_ALLOWED")]
		NOTALLOWED,
		[CCode (cname = "NM_DEVICE_ERROR_SPECIFIC_OBJECT_NOT_FOUND")]
		SPECIFICOBJECTNOTFOUND,
		[CCode (cname = "NM_DEVICE_ERROR_VERSION_ID_MISMATCH")]
		VERSIONIDMISMATCH,
		[CCode (cname = "NM_DEVICE_ERROR_MISSING_DEPENDENCIES")]
		MISSINGDEPENDENCIES,
		[CCode (cname = "NM_DEVICE_ERROR_INVALID_ARGUMENT")]
		INVALIDARGUMENT;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_MANAGER_ERROR_")]
	public errordomain ManagerError {
		FAILED,
		[CCode (cname = "NM_MANAGER_ERROR_PERMISSION_DENIED")]
		PERMISSIONDENIED,
		[CCode (cname = "NM_MANAGER_ERROR_UNKNOWN_CONNECTION")]
		UNKNOWNCONNECTION,
		[CCode (cname = "NM_MANAGER_ERROR_UNKNOWN_DEVICE")]
		UNKNOWNDEVICE,
		[CCode (cname = "NM_MANAGER_ERROR_CONNECTION_NOT_AVAILABLE")]
		CONNECTIONNOTAVAILABLE,
		[CCode (cname = "NM_MANAGER_ERROR_CONNECTION_NOT_ACTIVE")]
		CONNECTIONNOTACTIVE,
		[CCode (cname = "NM_MANAGER_ERROR_CONNECTION_ALREADY_ACTIVE")]
		CONNECTIONALREADYACTIVE,
		[CCode (cname = "NM_MANAGER_ERROR_DEPENDENCY_FAILED")]
		DEPENDENCYFAILED,
		[CCode (cname = "NM_MANAGER_ERROR_ALREADY_ASLEEP_OR_AWAKE")]
		ALREADYASLEEPORAWAKE,
		[CCode (cname = "NM_MANAGER_ERROR_ALREADY_ENABLED_OR_DISABLED")]
		ALREADYENABLEDORDISABLED,
		[CCode (cname = "NM_MANAGER_ERROR_UNKNOWN_LOG_LEVEL")]
		UNKNOWNLOGLEVEL,
		[CCode (cname = "NM_MANAGER_ERROR_UNKNOWN_LOG_DOMAIN")]
		UNKNOWNLOGDOMAIN,
		[CCode (cname = "NM_MANAGER_ERROR_INVALID_ARGUMENTS")]
		INVALIDARGUMENTS,
		[CCode (cname = "NM_MANAGER_ERROR_MISSING_PLUGIN")]
		MISSINGPLUGIN;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SECRET_AGENT_ERROR_")]
	public errordomain SecretAgentError {
		FAILED,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_PERMISSION_DENIED")]
		PERMISSIONDENIED,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_INVALID_CONNECTION")]
		INVALIDCONNECTION,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_USER_CANCELED")]
		USERCANCELED,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_AGENT_CANCELED")]
		AGENTCANCELED,
		[CCode (cname = "NM_SECRET_AGENT_ERROR_NO_SECRETS")]
		NOSECRETS;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_SETTINGS_ERROR_")]
	public errordomain SettingsError {
		FAILED,
		[CCode (cname = "NM_SETTINGS_ERROR_PERMISSION_DENIED")]
		PERMISSIONDENIED,
		[CCode (cname = "NM_SETTINGS_ERROR_NOT_SUPPORTED")]
		NOTSUPPORTED,
		[CCode (cname = "NM_SETTINGS_ERROR_INVALID_CONNECTION")]
		INVALIDCONNECTION,
		[CCode (cname = "NM_SETTINGS_ERROR_READ_ONLY_CONNECTION")]
		READONLYCONNECTION,
		[CCode (cname = "NM_SETTINGS_ERROR_UUID_EXISTS")]
		UUIDEXISTS,
		[CCode (cname = "NM_SETTINGS_ERROR_INVALID_HOSTNAME")]
		INVALIDHOSTNAME,
		[CCode (cname = "NM_SETTINGS_ERROR_INVALID_ARGUMENTS")]
		INVALIDARGUMENTS;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", cprefix = "NM_VPN_PLUGIN_ERROR_")]
	public errordomain VpnPluginError {
		FAILED,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_STARTING_IN_PROGRESS")]
		STARTINGINPROGRESS,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_ALREADY_STARTED")]
		ALREADYSTARTED,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_STOPPING_IN_PROGRESS")]
		STOPPINGINPROGRESS,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_ALREADY_STOPPED")]
		ALREADYSTOPPED,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_WRONG_STATE")]
		WRONGSTATE,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_BAD_ARGUMENTS")]
		BADARGUMENTS,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_LAUNCH_FAILED")]
		LAUNCHFAILED,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_INVALID_CONNECTION")]
		INVALIDCONNECTION,
		[CCode (cname = "NM_VPN_PLUGIN_ERROR_INTERACTIVE_NOT_SUPPORTED")]
		INTERACTIVENOTSUPPORTED;
		[CCode (cheader_filename = "NetworkManager.h")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 3.9)]
	public delegate void SecretAgentOldDeleteSecretsFunc (NM.SecretAgentOld agent, NM.Connection connection, GLib.Error error);
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 4.9)]
	public delegate void SecretAgentOldGetSecretsFunc (NM.SecretAgentOld agent, NM.Connection connection, GLib.Variant secrets, GLib.Error error);
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 3.9)]
	public delegate void SecretAgentOldSaveSecretsFunc (NM.SecretAgentOld agent, NM.Connection connection, GLib.Error error);
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 3.9)]
	public delegate bool SettingClearSecretsWithFlagsFn (NM.Setting setting, string secret, NM.SettingSecretFlags flags);
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 4.9)]
	public delegate void SettingValueIterFn (NM.Setting setting, string key, GLib.Value value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 2.9)]
	public delegate bool UtilsCheckFilePredicate (string filename, void* stat) throws GLib.Error;
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 1.9)]
	public delegate bool UtilsFileSearchInPathsPredicate (string filename);
	[CCode (cheader_filename = "NetworkManager.h", instance_pos = 2.9)]
	public delegate void VpnIterFunc (string key, string value);
	[CCode (cheader_filename = "NetworkManager.h", cname = "_NMConnectionForEachSecretFunc", instance_pos = 1.9)]
	public delegate bool _ConnectionForEachSecretFunc (NM.SettingSecretFlags flags);
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_BRIDGE_VLAN_VID_MAX")]
	public const int BRIDGE_VLAN_VID_MAX;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_BRIDGE_VLAN_VID_MIN")]
	public const int BRIDGE_VLAN_VID_MIN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CHECKPOINT_CREATED")]
	public const string CHECKPOINT_CREATED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CHECKPOINT_DEVICES")]
	public const string CHECKPOINT_DEVICES;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CHECKPOINT_ROLLBACK_TIMEOUT")]
	public const string CHECKPOINT_ROLLBACK_TIMEOUT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CONNECTION_CHANGED")]
	public const string CONNECTION_CHANGED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CONNECTION_NORMALIZE_PARAM_IP6_CONFIG_METHOD")]
	public const string CONNECTION_NORMALIZE_PARAM_IP6_CONFIG_METHOD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CONNECTION_SECRETS_CLEARED")]
	public const string CONNECTION_SECRETS_CLEARED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_CONNECTION_SECRETS_UPDATED")]
	public const string CONNECTION_SECRETS_UPDATED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE")]
	public const string DBUS_INTERFACE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_DNS_MANAGER")]
	public const string DBUS_INTERFACE_DNS_MANAGER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_SETTINGS")]
	public const string DBUS_INTERFACE_SETTINGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_SETTINGS_CONNECTION")]
	public const string DBUS_INTERFACE_SETTINGS_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_SETTINGS_CONNECTION_SECRETS")]
	public const string DBUS_INTERFACE_SETTINGS_CONNECTION_SECRETS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_VPN")]
	public const string DBUS_INTERFACE_VPN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INTERFACE_VPN_CONNECTION")]
	public const string DBUS_INTERFACE_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_INVALID_VPN_CONNECTION")]
	public const string DBUS_INVALID_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_NO_ACTIVE_VPN_CONNECTION")]
	public const string DBUS_NO_ACTIVE_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_NO_VPN_CONNECTIONS")]
	public const string DBUS_NO_VPN_CONNECTIONS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH")]
	public const string DBUS_PATH;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_AGENT_MANAGER")]
	public const string DBUS_PATH_AGENT_MANAGER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_DNS_MANAGER")]
	public const string DBUS_PATH_DNS_MANAGER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_SECRET_AGENT")]
	public const string DBUS_PATH_SECRET_AGENT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_SETTINGS")]
	public const string DBUS_PATH_SETTINGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_SETTINGS_CONNECTION")]
	public const string DBUS_PATH_SETTINGS_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_VPN")]
	public const string DBUS_PATH_VPN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_PATH_VPN_CONNECTION")]
	public const string DBUS_PATH_VPN_CONNECTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_SERVICE")]
	public const string DBUS_SERVICE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_ALREADY_STARTED")]
	public const string DBUS_VPN_ALREADY_STARTED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_ALREADY_STOPPED")]
	public const string DBUS_VPN_ALREADY_STOPPED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_BAD_ARGUMENTS")]
	public const string DBUS_VPN_BAD_ARGUMENTS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_ERROR_PREFIX")]
	public const string DBUS_VPN_ERROR_PREFIX;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_INTERACTIVE_NOT_SUPPORTED")]
	public const string DBUS_VPN_INTERACTIVE_NOT_SUPPORTED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_CONNECT_FAILED")]
	public const string DBUS_VPN_SIGNAL_CONNECT_FAILED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_IP4_CONFIG")]
	public const string DBUS_VPN_SIGNAL_IP4_CONFIG;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_IP_CONFIG_BAD")]
	public const string DBUS_VPN_SIGNAL_IP_CONFIG_BAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_LAUNCH_FAILED")]
	public const string DBUS_VPN_SIGNAL_LAUNCH_FAILED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_LOGIN_BANNER")]
	public const string DBUS_VPN_SIGNAL_LOGIN_BANNER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_LOGIN_FAILED")]
	public const string DBUS_VPN_SIGNAL_LOGIN_FAILED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_STATE_CHANGE")]
	public const string DBUS_VPN_SIGNAL_STATE_CHANGE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_SIGNAL_VPN_CONFIG_BAD")]
	public const string DBUS_VPN_SIGNAL_VPN_CONFIG_BAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_STARTING_IN_PROGRESS")]
	public const string DBUS_VPN_STARTING_IN_PROGRESS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_STOPPING_IN_PROGRESS")]
	public const string DBUS_VPN_STOPPING_IN_PROGRESS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DBUS_VPN_WRONG_STATE")]
	public const string DBUS_VPN_WRONG_STATE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_DHCP_CONFIG_FAMILY")]
	public const string DHCP_CONFIG_FAMILY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_ESP_HW_OFFLOAD")]
	public const string ETHTOOL_OPTNAME_FEATURE_ESP_HW_OFFLOAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_ESP_TX_CSUM_HW_OFFLOAD")]
	public const string ETHTOOL_OPTNAME_FEATURE_ESP_TX_CSUM_HW_OFFLOAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_FCOE_MTU")]
	public const string ETHTOOL_OPTNAME_FEATURE_FCOE_MTU;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_GRO")]
	public const string ETHTOOL_OPTNAME_FEATURE_GRO;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_GSO")]
	public const string ETHTOOL_OPTNAME_FEATURE_GSO;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_HIGHDMA")]
	public const string ETHTOOL_OPTNAME_FEATURE_HIGHDMA;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_HW_TC_OFFLOAD")]
	public const string ETHTOOL_OPTNAME_FEATURE_HW_TC_OFFLOAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_L2_FWD_OFFLOAD")]
	public const string ETHTOOL_OPTNAME_FEATURE_L2_FWD_OFFLOAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_LOOPBACK")]
	public const string ETHTOOL_OPTNAME_FEATURE_LOOPBACK;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_LRO")]
	public const string ETHTOOL_OPTNAME_FEATURE_LRO;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_NTUPLE")]
	public const string ETHTOOL_OPTNAME_FEATURE_NTUPLE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RXHASH")]
	public const string ETHTOOL_OPTNAME_FEATURE_RXHASH;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RXVLAN")]
	public const string ETHTOOL_OPTNAME_FEATURE_RXVLAN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX_ALL")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX_ALL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX_FCS")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX_FCS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX_GRO_HW")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX_GRO_HW;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX_UDP_TUNNEL_PORT_OFFLOAD")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX_UDP_TUNNEL_PORT_OFFLOAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX_VLAN_FILTER")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX_VLAN_FILTER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX_VLAN_STAG_FILTER")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX_VLAN_STAG_FILTER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_RX_VLAN_STAG_HW_PARSE")]
	public const string ETHTOOL_OPTNAME_FEATURE_RX_VLAN_STAG_HW_PARSE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_SG")]
	public const string ETHTOOL_OPTNAME_FEATURE_SG;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TLS_HW_RECORD")]
	public const string ETHTOOL_OPTNAME_FEATURE_TLS_HW_RECORD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TLS_HW_TX_OFFLOAD")]
	public const string ETHTOOL_OPTNAME_FEATURE_TLS_HW_TX_OFFLOAD;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TSO")]
	public const string ETHTOOL_OPTNAME_FEATURE_TSO;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TXVLAN")]
	public const string ETHTOOL_OPTNAME_FEATURE_TXVLAN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_FCOE_CRC")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_FCOE_CRC;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_IPV4")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_IPV4;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_IPV6")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_IPV6;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_IP_GENERIC")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_IP_GENERIC;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_SCTP")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_CHECKSUM_SCTP;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_ESP_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_ESP_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_FCOE_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_FCOE_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_GRE_CSUM_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_GRE_CSUM_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_GRE_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_GRE_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_GSO_PARTIAL")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_GSO_PARTIAL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_GSO_ROBUST")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_GSO_ROBUST;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_IPXIP4_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_IPXIP4_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_IPXIP6_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_IPXIP6_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_NOCACHE_COPY")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_NOCACHE_COPY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_SCATTER_GATHER")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_SCATTER_GATHER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_SCATTER_GATHER_FRAGLIST")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_SCATTER_GATHER_FRAGLIST;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_SCTP_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_SCTP_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_TCP6_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_TCP6_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_TCP_ECN_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_TCP_ECN_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_TCP_MANGLEID_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_TCP_MANGLEID_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_TCP_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_TCP_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_UDP_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_UDP_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_UDP_TNL_CSUM_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_UDP_TNL_CSUM_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_UDP_TNL_SEGMENTATION")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_UDP_TNL_SEGMENTATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_ETHTOOL_OPTNAME_FEATURE_TX_VLAN_STAG_HW_INSERT")]
	public const string ETHTOOL_OPTNAME_FEATURE_TX_VLAN_STAG_HW_INSERT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ADDRESS_ATTRIBUTE_LABEL")]
	public const string IP_ADDRESS_ATTRIBUTE_LABEL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_CWND")]
	public const string IP_ROUTE_ATTRIBUTE_CWND;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_FROM")]
	public const string IP_ROUTE_ATTRIBUTE_FROM;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_INITCWND")]
	public const string IP_ROUTE_ATTRIBUTE_INITCWND;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_INITRWND")]
	public const string IP_ROUTE_ATTRIBUTE_INITRWND;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_LOCK_CWND")]
	public const string IP_ROUTE_ATTRIBUTE_LOCK_CWND;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_LOCK_INITCWND")]
	public const string IP_ROUTE_ATTRIBUTE_LOCK_INITCWND;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_LOCK_INITRWND")]
	public const string IP_ROUTE_ATTRIBUTE_LOCK_INITRWND;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_LOCK_MTU")]
	public const string IP_ROUTE_ATTRIBUTE_LOCK_MTU;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_LOCK_WINDOW")]
	public const string IP_ROUTE_ATTRIBUTE_LOCK_WINDOW;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_MTU")]
	public const string IP_ROUTE_ATTRIBUTE_MTU;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_ONLINK")]
	public const string IP_ROUTE_ATTRIBUTE_ONLINK;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_SRC")]
	public const string IP_ROUTE_ATTRIBUTE_SRC;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_TABLE")]
	public const string IP_ROUTE_ATTRIBUTE_TABLE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_TOS")]
	public const string IP_ROUTE_ATTRIBUTE_TOS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_IP_ROUTE_ATTRIBUTE_WINDOW")]
	public const string IP_ROUTE_ATTRIBUTE_WINDOW;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_CHASSIS_ID")]
	public const string LLDP_ATTR_CHASSIS_ID;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_CHASSIS_ID_TYPE")]
	public const string LLDP_ATTR_CHASSIS_ID_TYPE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_DESTINATION")]
	public const string LLDP_ATTR_DESTINATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_1_PPVID")]
	public const string LLDP_ATTR_IEEE_802_1_PPVID;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_1_PPVIDS")]
	public const string LLDP_ATTR_IEEE_802_1_PPVIDS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_1_PPVID_FLAGS")]
	public const string LLDP_ATTR_IEEE_802_1_PPVID_FLAGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_1_PVID")]
	public const string LLDP_ATTR_IEEE_802_1_PVID;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_1_VID")]
	public const string LLDP_ATTR_IEEE_802_1_VID;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_1_VLANS")]
	public const string LLDP_ATTR_IEEE_802_1_VLANS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_1_VLAN_NAME")]
	public const string LLDP_ATTR_IEEE_802_1_VLAN_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_3_MAC_PHY_CONF")]
	public const string LLDP_ATTR_IEEE_802_3_MAC_PHY_CONF;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_3_MAX_FRAME_SIZE")]
	public const string LLDP_ATTR_IEEE_802_3_MAX_FRAME_SIZE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_IEEE_802_3_POWER_VIA_MDI")]
	public const string LLDP_ATTR_IEEE_802_3_POWER_VIA_MDI;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_MANAGEMENT_ADDRESSES")]
	public const string LLDP_ATTR_MANAGEMENT_ADDRESSES;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_PORT_DESCRIPTION")]
	public const string LLDP_ATTR_PORT_DESCRIPTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_PORT_ID")]
	public const string LLDP_ATTR_PORT_ID;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_PORT_ID_TYPE")]
	public const string LLDP_ATTR_PORT_ID_TYPE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_SYSTEM_CAPABILITIES")]
	public const string LLDP_ATTR_SYSTEM_CAPABILITIES;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_SYSTEM_DESCRIPTION")]
	public const string LLDP_ATTR_SYSTEM_DESCRIPTION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_ATTR_SYSTEM_NAME")]
	public const string LLDP_ATTR_SYSTEM_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_DEST_NEAREST_BRIDGE")]
	public const string LLDP_DEST_NEAREST_BRIDGE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_DEST_NEAREST_CUSTOMER_BRIDGE")]
	public const string LLDP_DEST_NEAREST_CUSTOMER_BRIDGE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_LLDP_DEST_NEAREST_NON_TPMR_BRIDGE")]
	public const string LLDP_DEST_NEAREST_NON_TPMR_BRIDGE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SECRET_AGENT_OLD_AUTO_REGISTER")]
	public const string SECRET_AGENT_OLD_AUTO_REGISTER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SECRET_AGENT_OLD_CAPABILITIES")]
	public const string SECRET_AGENT_OLD_CAPABILITIES;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SECRET_AGENT_OLD_IDENTIFIER")]
	public const string SECRET_AGENT_OLD_IDENTIFIER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SECRET_AGENT_OLD_REGISTERED")]
	public const string SECRET_AGENT_OLD_REGISTERED;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_6LOWPAN_PARENT")]
	public const string SETTING_6LOWPAN_PARENT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_6LOWPAN_SETTING_NAME")]
	public const string SETTING_6LOWPAN_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_ATTEMPTS")]
	public const string SETTING_DNS_OPTION_ATTEMPTS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_DEBUG")]
	public const string SETTING_DNS_OPTION_DEBUG;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_EDNS0")]
	public const string SETTING_DNS_OPTION_EDNS0;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_INET6")]
	public const string SETTING_DNS_OPTION_INET6;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_IP6_BYTESTRING")]
	public const string SETTING_DNS_OPTION_IP6_BYTESTRING;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_IP6_DOTINT")]
	public const string SETTING_DNS_OPTION_IP6_DOTINT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_NDOTS")]
	public const string SETTING_DNS_OPTION_NDOTS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_NO_CHECK_NAMES")]
	public const string SETTING_DNS_OPTION_NO_CHECK_NAMES;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_NO_IP6_DOTINT")]
	public const string SETTING_DNS_OPTION_NO_IP6_DOTINT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_NO_TLD_QUERY")]
	public const string SETTING_DNS_OPTION_NO_TLD_QUERY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_ROTATE")]
	public const string SETTING_DNS_OPTION_ROTATE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_SINGLE_REQUEST")]
	public const string SETTING_DNS_OPTION_SINGLE_REQUEST;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_SINGLE_REQUEST_REOPEN")]
	public const string SETTING_DNS_OPTION_SINGLE_REQUEST_REOPEN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_TIMEOUT")]
	public const string SETTING_DNS_OPTION_TIMEOUT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DNS_OPTION_USE_VC")]
	public const string SETTING_DNS_OPTION_USE_VC;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_DUMMY_SETTING_NAME")]
	public const string SETTING_DUMMY_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_ETHTOOL_SETTING_NAME")]
	public const string SETTING_ETHTOOL_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_ENCRYPT")]
	public const string SETTING_MACSEC_ENCRYPT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_MKA_CAK")]
	public const string SETTING_MACSEC_MKA_CAK;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_MKA_CAK_FLAGS")]
	public const string SETTING_MACSEC_MKA_CAK_FLAGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_MKA_CAK_LENGTH")]
	public const int SETTING_MACSEC_MKA_CAK_LENGTH;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_MKA_CKN")]
	public const string SETTING_MACSEC_MKA_CKN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_MKA_CKN_LENGTH")]
	public const int SETTING_MACSEC_MKA_CKN_LENGTH;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_MODE")]
	public const string SETTING_MACSEC_MODE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_PARENT")]
	public const string SETTING_MACSEC_PARENT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_PORT")]
	public const string SETTING_MACSEC_PORT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_SEND_SCI")]
	public const string SETTING_MACSEC_SEND_SCI;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_SETTING_NAME")]
	public const string SETTING_MACSEC_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MACSEC_VALIDATION")]
	public const string SETTING_MACSEC_VALIDATION;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MATCH_INTERFACE_NAME")]
	public const string SETTING_MATCH_INTERFACE_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_MATCH_SETTING_NAME")]
	public const string SETTING_MATCH_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_NAME")]
	public const string SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_BRIDGE_DATAPATH_TYPE")]
	public const string SETTING_OVS_BRIDGE_DATAPATH_TYPE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_BRIDGE_FAIL_MODE")]
	public const string SETTING_OVS_BRIDGE_FAIL_MODE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_BRIDGE_MCAST_SNOOPING_ENABLE")]
	public const string SETTING_OVS_BRIDGE_MCAST_SNOOPING_ENABLE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_BRIDGE_RSTP_ENABLE")]
	public const string SETTING_OVS_BRIDGE_RSTP_ENABLE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_BRIDGE_SETTING_NAME")]
	public const string SETTING_OVS_BRIDGE_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_BRIDGE_STP_ENABLE")]
	public const string SETTING_OVS_BRIDGE_STP_ENABLE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_DPDK_DEVARGS")]
	public const string SETTING_OVS_DPDK_DEVARGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_DPDK_SETTING_NAME")]
	public const string SETTING_OVS_DPDK_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_INTERFACE_SETTING_NAME")]
	public const string SETTING_OVS_INTERFACE_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_INTERFACE_TYPE")]
	public const string SETTING_OVS_INTERFACE_TYPE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PATCH_PEER")]
	public const string SETTING_OVS_PATCH_PEER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PATCH_SETTING_NAME")]
	public const string SETTING_OVS_PATCH_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PORT_BOND_DOWNDELAY")]
	public const string SETTING_OVS_PORT_BOND_DOWNDELAY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PORT_BOND_MODE")]
	public const string SETTING_OVS_PORT_BOND_MODE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PORT_BOND_UPDELAY")]
	public const string SETTING_OVS_PORT_BOND_UPDELAY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PORT_LACP")]
	public const string SETTING_OVS_PORT_LACP;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PORT_SETTING_NAME")]
	public const string SETTING_OVS_PORT_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PORT_TAG")]
	public const string SETTING_OVS_PORT_TAG;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_OVS_PORT_VLAN_MODE")]
	public const string SETTING_OVS_PORT_VLAN_MODE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SRIOV_AUTOPROBE_DRIVERS")]
	public const string SETTING_SRIOV_AUTOPROBE_DRIVERS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SRIOV_SETTING_NAME")]
	public const string SETTING_SRIOV_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SRIOV_TOTAL_VFS")]
	public const string SETTING_SRIOV_TOTAL_VFS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_SRIOV_VFS")]
	public const string SETTING_SRIOV_VFS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TC_CONFIG_QDISCS")]
	public const string SETTING_TC_CONFIG_QDISCS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TC_CONFIG_SETTING_NAME")]
	public const string SETTING_TC_CONFIG_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_TC_CONFIG_TFILTERS")]
	public const string SETTING_TC_CONFIG_TFILTERS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_USER_DATA")]
	public const string SETTING_USER_DATA;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_USER_SETTING_NAME")]
	public const string SETTING_USER_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_FWMARK")]
	public const string SETTING_WIREGUARD_FWMARK;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_IP4_AUTO_DEFAULT_ROUTE")]
	public const string SETTING_WIREGUARD_IP4_AUTO_DEFAULT_ROUTE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_IP6_AUTO_DEFAULT_ROUTE")]
	public const string SETTING_WIREGUARD_IP6_AUTO_DEFAULT_ROUTE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_LISTEN_PORT")]
	public const string SETTING_WIREGUARD_LISTEN_PORT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_MTU")]
	public const string SETTING_WIREGUARD_MTU;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_PEERS")]
	public const string SETTING_WIREGUARD_PEERS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_PEER_ROUTES")]
	public const string SETTING_WIREGUARD_PEER_ROUTES;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_PRIVATE_KEY")]
	public const string SETTING_WIREGUARD_PRIVATE_KEY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_PRIVATE_KEY_FLAGS")]
	public const string SETTING_WIREGUARD_PRIVATE_KEY_FLAGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WIREGUARD_SETTING_NAME")]
	public const string SETTING_WIREGUARD_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_CHANNEL")]
	public const string SETTING_WPAN_CHANNEL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_CHANNEL_DEFAULT")]
	public const int SETTING_WPAN_CHANNEL_DEFAULT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_MAC_ADDRESS")]
	public const string SETTING_WPAN_MAC_ADDRESS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_PAGE")]
	public const string SETTING_WPAN_PAGE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_PAGE_DEFAULT")]
	public const int SETTING_WPAN_PAGE_DEFAULT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_PAN_ID")]
	public const string SETTING_WPAN_PAN_ID;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_SETTING_NAME")]
	public const string SETTING_WPAN_SETTING_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SETTING_WPAN_SHORT_ADDRESS")]
	public const string SETTING_WPAN_SHORT_ADDRESS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SRIOV_VF_ATTRIBUTE_MAC")]
	public const string SRIOV_VF_ATTRIBUTE_MAC;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SRIOV_VF_ATTRIBUTE_MAX_TX_RATE")]
	public const string SRIOV_VF_ATTRIBUTE_MAX_TX_RATE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SRIOV_VF_ATTRIBUTE_MIN_TX_RATE")]
	public const string SRIOV_VF_ATTRIBUTE_MIN_TX_RATE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SRIOV_VF_ATTRIBUTE_SPOOF_CHECK")]
	public const string SRIOV_VF_ATTRIBUTE_SPOOF_CHECK;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_SRIOV_VF_ATTRIBUTE_TRUST")]
	public const string SRIOV_VF_ATTRIBUTE_TRUST;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_TEAM_LINK_WATCHER_ARP_PING")]
	public const string TEAM_LINK_WATCHER_ARP_PING;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_TEAM_LINK_WATCHER_ETHTOOL")]
	public const string TEAM_LINK_WATCHER_ETHTOOL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_TEAM_LINK_WATCHER_NSNA_PING")]
	public const string TEAM_LINK_WATCHER_NSNA_PING;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_VLAN_FLAGS_ALL")]
	public const int VLAN_FLAGS_ALL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_FLAGS")]
	public const string WIFI_P2P_PEER_FLAGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_HW_ADDRESS")]
	public const string WIFI_P2P_PEER_HW_ADDRESS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_LAST_SEEN")]
	public const string WIFI_P2P_PEER_LAST_SEEN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_MANUFACTURER")]
	public const string WIFI_P2P_PEER_MANUFACTURER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_MODEL")]
	public const string WIFI_P2P_PEER_MODEL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_MODEL_NUMBER")]
	public const string WIFI_P2P_PEER_MODEL_NUMBER;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_NAME")]
	public const string WIFI_P2P_PEER_NAME;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_SERIAL")]
	public const string WIFI_P2P_PEER_SERIAL;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_STRENGTH")]
	public const string WIFI_P2P_PEER_STRENGTH;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIFI_P2P_PEER_WFD_IES")]
	public const string WIFI_P2P_PEER_WFD_IES;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_PEER_ATTR_ALLOWED_IPS")]
	public const string WIREGUARD_PEER_ATTR_ALLOWED_IPS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_PEER_ATTR_ENDPOINT")]
	public const string WIREGUARD_PEER_ATTR_ENDPOINT;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_PEER_ATTR_PERSISTENT_KEEPALIVE")]
	public const string WIREGUARD_PEER_ATTR_PERSISTENT_KEEPALIVE;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_PEER_ATTR_PRESHARED_KEY")]
	public const string WIREGUARD_PEER_ATTR_PRESHARED_KEY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_PEER_ATTR_PRESHARED_KEY_FLAGS")]
	public const string WIREGUARD_PEER_ATTR_PRESHARED_KEY_FLAGS;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_PEER_ATTR_PUBLIC_KEY")]
	public const string WIREGUARD_PEER_ATTR_PUBLIC_KEY;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_PUBLIC_KEY_LEN")]
	public const int WIREGUARD_PUBLIC_KEY_LEN;
	[CCode (cheader_filename = "NetworkManager.h", cname = "NM_WIREGUARD_SYMMETRIC_KEY_LEN")]
	public const int WIREGUARD_SYMMETRIC_KEY_LEN;
	[CCode (cheader_filename = "NetworkManager.h")]
	[Version (since = "1.20")]
	public static bool ethtool_optname_is_feature (string? optname);
	[CCode (cheader_filename = "NetworkManager.h")]
	[Version (since = "1.4")]
	public static NM.VpnEditorPlugin vpn_editor_plugin_load (string plugin_name, string check_service) throws GLib.Error;
	[CCode (cheader_filename = "NetworkManager.h")]
	[Version (since = "1.2")]
	public static NM.VpnEditorPlugin vpn_editor_plugin_load_from_file (string plugin_name, string check_service, int check_owner, NM.UtilsCheckFilePredicate check_file) throws GLib.Error;
}
