/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex2latex;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.L2LDoubleParam;
import com.dickimawbooks.texparserlib.L2LPar;
import com.dickimawbooks.texparserlib.L2LParam;
import com.dickimawbooks.texparserlib.L2LTab;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.Tab;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXReader;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.generic.BigOperator;
import com.dickimawbooks.texparserlib.generic.BinarySymbol;
import com.dickimawbooks.texparserlib.generic.GreekSymbol;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.generic.Symbol;
import com.dickimawbooks.texparserlib.latex.Input;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.Verb;
import com.dickimawbooks.texparserlib.latex.graphics.Epsfig;
import com.dickimawbooks.texparserlib.latex.graphics.GraphicsSty;
import com.dickimawbooks.texparserlib.latex.graphics.IncludeGraphics;
import com.dickimawbooks.texparserlib.latex.inputenc.InputEncSty;
import com.dickimawbooks.texparserlib.latex2latex.L2LActiveChar;
import com.dickimawbooks.texparserlib.latex2latex.L2LBegin;
import com.dickimawbooks.texparserlib.latex2latex.L2LBibliography;
import com.dickimawbooks.texparserlib.latex2latex.L2LBigOperator;
import com.dickimawbooks.texparserlib.latex2latex.L2LBinarySymbol;
import com.dickimawbooks.texparserlib.latex2latex.L2LComment;
import com.dickimawbooks.texparserlib.latex2latex.L2LControlSequence;
import com.dickimawbooks.texparserlib.latex2latex.L2LEnd;
import com.dickimawbooks.texparserlib.latex2latex.L2LEol;
import com.dickimawbooks.texparserlib.latex2latex.L2LGreekSymbol;
import com.dickimawbooks.texparserlib.latex2latex.L2LGroup;
import com.dickimawbooks.texparserlib.latex2latex.L2LIgnoreable;
import com.dickimawbooks.texparserlib.latex2latex.L2LMathDeclaration;
import com.dickimawbooks.texparserlib.latex2latex.L2LMathFontCommand;
import com.dickimawbooks.texparserlib.latex2latex.L2LMathGroup;
import com.dickimawbooks.texparserlib.latex2latex.L2LMathSymbol;
import com.dickimawbooks.texparserlib.latex2latex.L2LOther;
import com.dickimawbooks.texparserlib.latex2latex.L2LSkippedEols;
import com.dickimawbooks.texparserlib.latex2latex.L2LSkippedSpaces;
import com.dickimawbooks.texparserlib.latex2latex.L2LSpace;
import com.dickimawbooks.texparserlib.latex2latex.L2LSymbol;
import com.dickimawbooks.texparserlib.latex2latex.L2LVerbatim;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class LaTeX2LaTeX
extends LaTeXParserListener
implements Writeable {
    private Path outPath;
    private Path basePath;
    private PrintWriter writer;
    private Charset outCharset = null;
    private boolean replaceGraphicsPath = false;
    private TeXApp texApp;
    public static final String[] CHECK_CMDS = new String[]{"epsfig", "psfig", "centerline", "special", "rm", "tt", "sf", "bf", "it", "sl", "sc", "cal", "includegraphics", "usepackage", "graphicspath", "documentclass", "documentstyle", "begin", "end", "FRAME", "Qcb", "verb", "lstinline", "verbatim", "endverbatim", "lstlistings", "lstlistings*", "[", "]", "(", ")", "displaymath", "enddisplaymath", "math", "endmath", "equation", "endequation", "equation*", "endequation*", "align", "endalign", "align*", "endalign*", "input", "newcommand", "renewcommand", "providecommand", "bibliography"};
    public static final String[] SKIP_CMDS = new String[]{"bigskip"};

    public LaTeX2LaTeX(TeXApp teXApp, File file) throws IOException {
        this(teXApp, file, null, false);
    }

    public LaTeX2LaTeX(TeXApp teXApp, File file, Charset charset) throws IOException {
        this(teXApp, file, charset, false);
    }

    public LaTeX2LaTeX(TeXApp teXApp, File file, boolean bl) throws IOException {
        this(teXApp, file, null, bl);
    }

    public LaTeX2LaTeX(TeXApp teXApp, File file, Charset charset, boolean bl) throws IOException {
        super(null);
        this.outPath = file.toPath();
        this.texApp = teXApp;
        this.setReplaceGraphicsPath(bl);
        this.setWriteable(this);
    }

    public void setReplaceGraphicsPath(boolean bl) {
        this.replaceGraphicsPath = bl;
    }

    public boolean isReplaceGraphicsPathEnabled() {
        return this.replaceGraphicsPath;
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        this.putControlSequence(new L2LMathDeclaration("math"));
        L2LMathDeclaration l2LMathDeclaration = new L2LMathDeclaration("(");
        this.putControlSequence(l2LMathDeclaration);
        this.putControlSequence(new EndDeclaration(")", l2LMathDeclaration));
        L2LMathDeclaration l2LMathDeclaration2 = new L2LMathDeclaration("[", 2);
        this.putControlSequence(l2LMathDeclaration2);
        this.putControlSequence(new EndDeclaration("]", l2LMathDeclaration2));
        this.putControlSequence(new L2LMathDeclaration("displaymath", 2));
        this.putControlSequence(new L2LMathDeclaration("equation", 2, true));
        this.putControlSequence(new L2LMathDeclaration("equation*", 2));
        this.putControlSequence(new L2LMathDeclaration("align", 2, true));
        this.putControlSequence(new L2LMathDeclaration("align*", 2));
        this.putControlSequence(new L2LBibliography());
        this.putControlSequence(new L2LVerbatim());
        this.putControlSequence(new L2LVerbatim("verbatim*"));
        this.putControlSequence(new L2LVerbatim("lstlisting"));
        this.putControlSequence(new L2LBegin());
        this.putControlSequence(new L2LEnd());
        this.putControlSequence(new Verb("lstinline"));
        this.putControlSequence(new Input());
        this.putControlSequence(new Input("include"));
    }

    @Override
    protected void addMathFontCommand(String string, int n) {
        this.parser.putControlSequence(new L2LMathFontCommand(string, n));
    }

    @Override
    public ControlSequence getControlSequence(String string) {
        if (this.isSkipCmd(string)) {
            return new L2LIgnoreable(string);
        }
        if (this.isReplaceCmd(string)) {
            return super.getControlSequence(string);
        }
        return new L2LControlSequence(string);
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new L2LControlSequence(string);
    }

    @Override
    public Comment createComment() {
        return new L2LComment();
    }

    @Override
    public SkippedSpaces createSkippedSpaces() {
        return new L2LSkippedSpaces();
    }

    @Override
    public SkippedEols createSkippedEols() {
        return new L2LSkippedEols();
    }

    @Override
    public Eol getEol() {
        return new L2LEol();
    }

    @Override
    public Space getSpace() {
        return new L2LSpace();
    }

    @Override
    public ActiveChar getActiveChar(int n) {
        return new L2LActiveChar(n);
    }

    @Override
    public Param getParam(int n) {
        return new L2LParam(n);
    }

    @Override
    public DoubleParam getDoubleParam(Param param) {
        return new L2LDoubleParam((L2LParam)param);
    }

    @Override
    public Other getOther(int n) {
        return new L2LOther(n);
    }

    @Override
    public Par getPar() {
        return new L2LPar();
    }

    @Override
    public Tab getTab() {
        return new L2LTab();
    }

    @Override
    public BigOperator createBigOperator(String string, int n, int n2) {
        return new L2LBigOperator(string, n, n2);
    }

    @Override
    public Symbol createSymbol(String string, int n) {
        return new L2LSymbol(string, n);
    }

    @Override
    public ControlSequence createSymbol(String string, int n, FontEncoding fontEncoding) {
        return new L2LSymbol(string, n);
    }

    @Override
    public GreekSymbol createGreekSymbol(String string, int n) {
        return new L2LGreekSymbol(string, n);
    }

    @Override
    public BinarySymbol createBinarySymbol(String string, int n) {
        return new L2LBinarySymbol(string, n);
    }

    @Override
    public MathSymbol createMathSymbol(String string, int n) {
        return new L2LMathSymbol(string, n);
    }

    @Override
    public Group createGroup() {
        return new L2LGroup();
    }

    @Override
    public Group createGroup(String string) {
        return new L2LGroup(this, string);
    }

    @Override
    public MathGroup createMathGroup() {
        return new L2LMathGroup();
    }

    @Override
    public void beginDocument() throws IOException {
        super.beginDocument();
        this.writeCodePoint(this.parser.getEscChar());
        this.write("begin");
        this.writeCodePoint(this.parser.getBgChar());
        this.write("document");
        this.writeCodePoint(this.parser.getEgChar());
    }

    @Override
    public void endDocument() throws IOException {
        try {
            this.writeCodePoint(this.parser.getEscChar());
            this.write("end");
            this.writeCodePoint(this.parser.getBgChar());
            this.write("document");
            this.writeCodePoint(this.parser.getEgChar());
            this.writeln();
            super.endDocument();
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    @Override
    public void documentclass(KeyValList keyValList, String string, boolean bl) throws IOException {
        if (this.docCls != null) {
            throw new LaTeXSyntaxException(this.parser, "latex.error.multi_cls", new Object[0]);
        }
        this.docCls = this.getLaTeXCls(keyValList, string, bl);
        this.addFileReference(this.docCls);
        this.writeCodePoint(this.parser.getEscChar());
        this.write("documentclass");
        if (keyValList != null) {
            this.write('[');
            this.write(keyValList.toString(this.parser));
            this.write(']');
        }
        this.writeCodePoint(this.parser.getBgChar());
        this.write(string);
        this.writeCodePoint(this.parser.getEgChar());
    }

    @Override
    public LaTeXSty requirepackage(KeyValList keyValList, String string, boolean bl) throws IOException {
        LaTeXSty laTeXSty = this.getLaTeXSty(keyValList, string, bl);
        this.addFileReference(laTeXSty);
        this.loadedPackages.add(laTeXSty);
        this.writeCodePoint(this.parser.getEscChar());
        this.write("RequirePackage");
        if (keyValList != null) {
            this.write('[');
            this.write(keyValList.toString(this.parser));
            this.write(']');
        }
        this.writeCodePoint(this.parser.getBgChar());
        this.write(string);
        this.writeCodePoint(this.parser.getEgChar());
        return laTeXSty;
    }

    @Override
    public LaTeXSty usepackage(KeyValList keyValList, String string, boolean bl) throws IOException {
        if (this.isStyLoaded(string)) {
            return null;
        }
        GraphicsSty graphicsSty = null;
        if (string.equals("epsfig")) {
            graphicsSty = new GraphicsSty(keyValList, this, false);
            graphicsSty.registerControlSequence(new Epsfig("epsfig"));
            graphicsSty.registerControlSequence(new Epsfig("psfig"));
            this.getTeXApp().substituting(this.parser, string, "graphicx");
            string = "graphicx";
        } else if (string.equals("graphics")) {
            graphicsSty = new GraphicsSty(keyValList, this, false);
            this.getTeXApp().substituting(this.parser, string, "graphicx");
            string = "graphicx";
        } else if (string.equals("graphicx")) {
            graphicsSty = new GraphicsSty(keyValList, this, false);
        }
        if (graphicsSty != null) {
            graphicsSty.registerControlSequence(new IncludeGraphics(graphicsSty));
        }
        LaTeXSty laTeXSty = this.getLaTeXSty(keyValList, string, bl);
        this.addFileReference(laTeXSty);
        this.loadedPackages.add(laTeXSty);
        if (string.equals("inputenc")) {
            try {
                String string2 = InputEncSty.getOption(this.parser, this.outCharset == null ? Charset.defaultCharset() : this.outCharset);
                if (keyValList == null || keyValList.get(string2) == null) {
                    this.substituting(String.format("\\usepackage[%s]{inputenc}", keyValList == null ? "" : keyValList.toString(this.parser)), String.format("\\usepackage[%s]{inputenc}", string2));
                }
                this.writeCodePoint(this.parser.getEscChar());
                this.write("usepackage[");
                this.write(string2);
                this.write(']');
                this.writeCodePoint(this.parser.getBgChar());
                this.write(string);
                this.writeCodePoint(this.parser.getEgChar());
            }
            catch (LaTeXSyntaxException laTeXSyntaxException) {
                this.getTeXApp().error(laTeXSyntaxException);
            }
            return laTeXSty;
        }
        this.writeCodePoint(this.parser.getEscChar());
        this.write("usepackage");
        if (keyValList != null) {
            this.write('[');
            this.write(keyValList.toString(this.parser));
            this.write(']');
        }
        this.writeCodePoint(this.parser.getBgChar());
        this.write(string);
        this.writeCodePoint(this.parser.getEgChar());
        return laTeXSty;
    }

    @Override
    public void substituting(String string, String string2) throws IOException {
        this.getTeXApp().substituting(this.parser, string, string2);
    }

    protected void copyImageFile(File file, File file2) throws IOException, InterruptedException {
        File file3;
        this.getTeXApp().copyFile(file, file2);
        String string = file2.getName();
        if (string.toLowerCase().endsWith(".wmf")) {
            file3 = new File(file2.getParentFile(), string.substring(0, string.length() - 3) + "eps");
            this.getTeXApp().wmftoeps(file2, file3);
            file2 = file3;
            string = file2.getName();
        }
        if (string.toLowerCase().endsWith(".eps")) {
            file3 = new File(file2.getParentFile(), string.substring(0, string.length() - 3) + "pdf");
            this.getTeXApp().epstopdf(file2, file3);
        }
    }

    public Path copyImageFile(String[] stringArray, TeXPath teXPath) throws IOException, InterruptedException {
        if (stringArray == null) {
            File file = teXPath.getFile();
            if (file.exists()) {
                File file2 = this.outPath.resolve(teXPath.getRelative()).toFile();
                this.copyImageFile(file, file2);
                return teXPath.getRelative();
            }
        } else {
            Path path = teXPath.getBaseDir();
            for (int i = 0; i < stringArray.length; ++i) {
                Path path2 = new File(File.separatorChar == '/' ? stringArray[i] : stringArray[i].replaceAll("/", File.separator)).toPath().resolve(teXPath.getRelative());
                File file = (path == null ? path2 : path.resolve(path2)).toFile();
                if (!file.exists()) continue;
                File file3 = this.outPath.resolve(path2).toFile();
                this.copyImageFile(file, file3);
                return path2;
            }
        }
        return null;
    }

    @Override
    public void includegraphics(KeyValList keyValList, String string) throws IOException {
        Object object;
        Object object2;
        String[] stringArray = this.getGraphicsPaths();
        Path path = null;
        try {
            if (string.contains(".")) {
                object2 = new TeXPath(this.parser, string);
                path = this.copyImageFile(stringArray, (TeXPath)object2);
            } else {
                TeXPath teXPath;
                for (int i = 0; i < IMAGE_EXT.length && (path = this.copyImageFile(stringArray, teXPath = new TeXPath(this.parser, (String)(object = string + "." + IMAGE_EXT[i])))) == null; ++i) {
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.getTeXApp().error(interruptedException);
        }
        if (this.isReplaceGraphicsPathEnabled() && path != null) {
            object2 = new StringBuilder();
            object = path.iterator();
            while (object.hasNext()) {
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).append('/');
                }
                ((StringBuilder)object2).append(((Path)object.next()).toString());
            }
            string = ((StringBuilder)object2).toString();
        }
        this.writeCodePoint(this.parser.getEscChar());
        this.write("includegraphics");
        if (keyValList != null && keyValList.size() > 0) {
            this.write('[');
            this.write(keyValList.toString(this.parser));
            this.write(']');
        }
        this.writeCodePoint(this.parser.getBgChar());
        object2 = string.toLowerCase();
        if (((String)object2).endsWith(".eps") || ((String)object2).endsWith(".ps") || ((String)object2).endsWith(".wmf")) {
            this.write(string.substring(0, string.lastIndexOf(".")));
        } else {
            this.write(string);
        }
        this.writeCodePoint(this.parser.getEgChar());
    }

    @Override
    public void setGraphicsPath(TeXObjectList teXObjectList) throws IOException {
        super.setGraphicsPath(teXObjectList);
        if (!this.isReplaceGraphicsPathEnabled()) {
            this.writeCodePoint(this.parser.getEscChar());
            this.write("graphicspath");
            int n = this.parser.getBgChar();
            int n2 = this.parser.getEgChar();
            this.writeCodePoint(n);
            for (TeXObject teXObject : teXObjectList) {
                this.writeCodePoint(n);
                this.write(teXObject.toString(this.parser));
                this.writeCodePoint(n2);
            }
            this.writeCodePoint(n2);
        }
    }

    public void bibliography(TeXPath[] teXPathArray) throws IOException {
        for (int i = 0; i < teXPathArray.length; ++i) {
            File file;
            if (teXPathArray[i].wasFoundByKpsewhich() || !(file = teXPathArray[i].getFile()).exists()) continue;
            Path path = teXPathArray[i].getRelative();
            path = path.isAbsolute() ? this.outPath.resolve(teXPathArray[i].getLeaf()) : this.outPath.resolve(teXPathArray[i].getRelative());
            try {
                this.getTeXApp().copyFile(file, path.toFile());
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.getTeXApp().error(interruptedException);
            }
        }
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
        if (this.writer != null) {
            if (n <= 65535) {
                this.writer.print((char)n);
            } else {
                for (char c : Character.toChars(n)) {
                    this.writer.print(c);
                }
            }
        } else {
            this.getTeXApp().warning(this.getParser(), "null writer");
        }
    }

    @Override
    public void write(char c) throws IOException {
        if (this.writer != null) {
            this.writer.print(c);
        } else {
            this.getTeXApp().warning(this.getParser(), "null writer");
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (this.writer != null) {
            this.writer.print(string);
        } else {
            this.getTeXApp().warning(this.getParser(), "null writer");
        }
    }

    @Override
    public void writeln(String string) throws IOException {
        if (this.writer != null) {
            this.writer.println(string);
        } else {
            this.getTeXApp().warning(this.getParser(), "null writer");
        }
    }

    public void writeln(char c) throws IOException {
        if (this.writer != null) {
            this.writer.println(c);
        } else {
            this.getTeXApp().warning(this.getParser(), "null writer");
        }
    }

    public void writeln() throws IOException {
        if (this.writer != null) {
            this.writer.println();
        } else {
            this.getTeXApp().warning(this.getParser(), "null writer");
        }
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        int n = this.parser.getEscChar();
        int n2 = this.parser.getBgChar();
        int n3 = this.parser.getEgChar();
        if (teXObject instanceof Other && teXObject2 instanceof Other && ((Other)teXObject).getCharCode() == 46 && ((Other)teXObject2).getCharCode() == 46) {
            this.writeCodePoint(n);
            this.write("frac");
            this.writeCodePoint(n2);
            this.write(teXObject3.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject4.toString(this.parser));
            this.writeCodePoint(n3);
        } else if (this.isStyLoaded("amsmath")) {
            this.writeCodePoint(n);
            this.write("genfrac");
            this.writeCodePoint(n2);
            this.write(teXObject.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject2.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject3.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject4.toString(this.parser));
            this.writeCodePoint(n3);
        } else {
            this.writeCodePoint(n);
            this.write("left");
            this.write(teXObject.toString(this.parser));
            this.writeCodePoint(n);
            this.write("frac");
            this.writeCodePoint(n2);
            this.write(teXObject3.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject4.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n);
            this.write("right");
            this.write(teXObject2.toString(this.parser));
        }
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        int n = this.parser.getEscChar();
        int n2 = this.parser.getBgChar();
        int n3 = this.parser.getEgChar();
        if (this.isStyLoaded("amsmath")) {
            this.writeCodePoint(n);
            this.write("genfrac");
            this.writeCodePoint(n2);
            this.write(teXObject.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject2.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXDimension.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject3.toString(this.parser));
            this.writeCodePoint(n3);
            this.writeCodePoint(n2);
            this.write(teXObject4.toString(this.parser));
            this.writeCodePoint(n3);
        } else if (teXObject instanceof Other && teXObject2 instanceof Other && ((Other)teXObject).getCharCode() == 46 && ((Other)teXObject2).getCharCode() == 46) {
            this.writeCodePoint(n2);
            this.write(teXObject3.toString(this.parser));
            this.writeCodePoint(n);
            this.write("above ");
            this.write(teXDimension.toString(this.parser));
            this.write(teXObject4.toString(this.parser));
            this.writeCodePoint(n3);
        } else {
            this.writeCodePoint(n2);
            this.write(teXObject3.toString(this.parser));
            this.writeCodePoint(n);
            this.write("abovewithdelims ");
            this.write(teXObject.toString(this.parser));
            this.write(teXObject2.toString(this.parser));
            this.write(teXDimension.toString(this.parser));
            this.write(teXObject4.toString(this.parser));
            this.writeCodePoint(n3);
        }
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
        this.write(ignoreable.toString(this.getParser()));
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
        this.writeCodePoint(this.parser.getSbChar());
        this.writeCodePoint(this.parser.getBgChar());
        this.write(teXObject.toString(this.parser));
        this.writeCodePoint(this.parser.getEgChar());
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
        this.writeCodePoint(this.parser.getSpChar());
        this.writeCodePoint(this.parser.getBgChar());
        this.write(teXObject.toString(this.parser));
        this.writeCodePoint(this.parser.getEgChar());
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    public boolean isReplaceCmd(String string) {
        for (int i = 0; i < CHECK_CMDS.length; ++i) {
            if (!CHECK_CMDS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSkipCmd(String string) {
        for (int i = 0; i < SKIP_CMDS.length; ++i) {
            if (!SKIP_CMDS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        this.getTeXApp().message(this.getTeXApp().getMessage("message.reading", file));
        if (charset != null) {
            this.getTeXApp().message(this.getTeXApp().getMessage("message.charset", charset));
        }
        this.basePath = file.getParentFile().toPath();
        if (this.writer == null) {
            Files.createDirectories(this.outPath, new FileAttribute[0]);
            File file2 = new File(this.outPath.toFile(), this.getOutFileName(file));
            this.getTeXApp().message(this.getTeXApp().getMessage("message.writing", file2));
            if (this.outCharset == null) {
                this.writer = new PrintWriter(file2);
            } else {
                this.getTeXApp().message(this.getTeXApp().getMessage("message.charset", this.outCharset));
                this.writer = new PrintWriter(file2, this.outCharset.name());
            }
        }
    }

    public String getOutFileName(File file) {
        return file.getName();
    }

    @Override
    public void endParse(File file) throws IOException {
        TeXReader teXReader = this.getParser().getReader();
        if (teXReader != null) {
            teXReader = teXReader.getParent();
        }
        if (this.writer != null && teXReader == null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
        int n = this.parser.getBgChar();
        int n2 = this.parser.getEgChar();
        this.writeCodePoint(this.parser.getEscChar());
        this.write("href");
        this.writeCodePoint(n);
        this.write(string);
        this.writeCodePoint(n2);
        this.writeCodePoint(n);
        this.write(teXObject.toString(this.parser));
        this.writeCodePoint(n2);
    }

    @Override
    public void verb(String string, boolean bl, int n, String string2) throws IOException {
        this.writeCodePoint(this.parser.getEscChar());
        this.write(string);
        if (bl) {
            this.write("*");
        } else if (this.parser.isLetter(n)) {
            this.write(" ");
        }
        this.writeCodePoint(n);
        this.write(string2);
        this.writeCodePoint(n);
    }

    @Override
    public void newcommand(byte by, String string, String string2, boolean bl, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        String string3 = new String(Character.toChars(this.parser.getBgChar()));
        String string4 = new String(Character.toChars(this.parser.getEgChar()));
        String string5 = new String(Character.toChars(this.parser.getEscChar()));
        this.write(string5);
        this.write(string);
        if (bl) {
            this.write('*');
        }
        this.write(String.format("%s%s%s%s", string3, string5, string2, string4));
        if (n > 0) {
            this.write("[" + n + "]");
            if (teXObject != null) {
                this.write("[" + teXObject.toString(this.parser) + "]");
            }
        }
        this.write(String.format("%s%s%s", string3, teXObject2.toString(this.parser), string4));
    }
}

