/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.event.ProfilingStateAdapter;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.v2.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerPlugin;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.SessionStorage;
import org.openide.util.Lookup;

final class ProfilerPlugins {
    private final List<ProfilerPlugin> plugins;

    ProfilerPlugins(ProfilerSession profilerSession) {
        Collection collection = Lookup.getDefault().lookupAll(ProfilerPlugin.Provider.class);
        if (collection.isEmpty()) {
            this.plugins = null;
        } else {
            ArrayList<ProfilerPlugin> arrayList = new ArrayList<ProfilerPlugin>();
            Lookup.Provider provider = profilerSession.getProject();
            SessionStorage sessionStorage = profilerSession.getStorage();
            for (ProfilerPlugin.Provider provider2 : collection) {
                ProfilerPlugin profilerPlugin = null;
                try {
                    profilerPlugin = provider2.createPlugin(provider, sessionStorage);
                }
                catch (Throwable throwable) {
                    this.handleThrowable(profilerPlugin, throwable);
                }
                if (profilerPlugin == null) continue;
                arrayList.add(profilerPlugin);
            }
            if (arrayList.isEmpty()) {
                this.plugins = null;
            } else {
                profilerSession.addListener((ProfilingStateListener)new ProfilingStateAdapter(){

                    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
                        int n = profilingStateEvent.getNewState();
                        if (n == 2) {
                            ProfilerPlugins.this.notifyStarted();
                        } else if (n == 1) {
                            ProfilerPlugins.this.notifyStopped();
                        }
                    }
                });
                this.plugins = arrayList;
            }
        }
    }

    boolean hasPlugins() {
        return this.plugins != null;
    }

    List<JMenuItem> menuItems() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        if (this.plugins != null) {
            for (ProfilerPlugin profilerPlugin : this.plugins) {
                try {
                    JMenu jMenu = new JMenu(profilerPlugin.getName());
                    profilerPlugin.createMenu(jMenu);
                    if (jMenu.getItemCount() <= 0) continue;
                    arrayList.add(jMenu);
                }
                catch (Throwable throwable) {
                    this.handleThrowable(profilerPlugin, throwable);
                }
            }
        }
        return arrayList;
    }

    void notifyStarting() {
        if (this.plugins != null) {
            for (ProfilerPlugin profilerPlugin : this.plugins) {
                try {
                    profilerPlugin.sessionStarting();
                }
                catch (Throwable throwable) {
                    this.handleThrowable(profilerPlugin, throwable);
                }
            }
        }
    }

    void notifyStarted() {
        if (this.plugins != null) {
            for (ProfilerPlugin profilerPlugin : this.plugins) {
                try {
                    profilerPlugin.sessionStarted();
                }
                catch (Throwable throwable) {
                    this.handleThrowable(profilerPlugin, throwable);
                }
            }
        }
    }

    void notifyStopping() {
        if (this.plugins != null) {
            for (ProfilerPlugin profilerPlugin : this.plugins) {
                try {
                    profilerPlugin.sessionStopping();
                }
                catch (Throwable throwable) {
                    this.handleThrowable(profilerPlugin, throwable);
                }
            }
        }
    }

    void notifyStopped() {
        if (this.plugins != null) {
            for (ProfilerPlugin profilerPlugin : this.plugins) {
                try {
                    profilerPlugin.sessionStopped();
                }
                catch (Throwable throwable) {
                    this.handleThrowable(profilerPlugin, throwable);
                }
            }
        }
    }

    private void handleThrowable(final ProfilerPlugin profilerPlugin, final Throwable throwable) {
        throwable.printStackTrace(System.err);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = throwable.getLocalizedMessage();
                String string2 = profilerPlugin == null ? Bundle.ProfilerPlugins_PluginNotInitialized(string) : Bundle.ProfilerPlugins_PluginFailed(profilerPlugin.getName(), string);
                ProfilerDialogs.displayError((String)string2);
            }
        });
    }
}

