/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.FacetNotExistException;
import com.zeroc.Ice.FormatType;
import com.zeroc.Ice.IPConnectionInfo;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Instrumentation.CommunicatorObserver;
import com.zeroc.Ice.Instrumentation.DispatchObserver;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.MarshalException;
import com.zeroc.Ice.MarshaledResult;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.Request;
import com.zeroc.Ice.RequestFailedException;
import com.zeroc.Ice.ServantLocator;
import com.zeroc.Ice.SystemException;
import com.zeroc.Ice.UnknownException;
import com.zeroc.Ice.UnknownLocalException;
import com.zeroc.Ice.UnknownUserException;
import com.zeroc.Ice.UserException;
import com.zeroc.Ice.Util;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.Protocol;
import com.zeroc.IceInternal.ResponseHandler;
import com.zeroc.IceInternal.ServantError;
import com.zeroc.IceInternal.ServantManager;
import com.zeroc.IceUtilInternal.OutputBase;
import com.zeroc.IceUtilInternal.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public final class Incoming
implements Request {
    private Instance _instance;
    private Current _current;
    private Object _servant;
    private ServantLocator _locator;
    private java.lang.Object _cookie;
    private DispatchObserver _observer;
    private ResponseHandler _responseHandler;
    private boolean _response;
    private byte _compress;
    private FormatType _format = FormatType.DefaultFormat;
    private OutputStream _os;
    private InputStream _is;
    private int _inParamPos = -1;
    public Incoming next;

    public Incoming(Instance instance, ResponseHandler responseHandler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._instance = instance;
        this._responseHandler = responseHandler;
        this._response = response;
        this._compress = compress;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = connection;
        this._current.requestId = requestId;
        this._cookie = null;
    }

    public void reset(Instance instance, ResponseHandler handler, ConnectionI connection, ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        this._instance = instance;
        this._responseHandler = handler;
        this._response = response;
        this._compress = compress;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = adapter;
        this._current.con = connection;
        this._current.requestId = requestId;
        assert (this._cookie == null);
        this._inParamPos = -1;
    }

    public boolean reclaim() {
        if (this._responseHandler != null) {
            return false;
        }
        this._current = null;
        this._servant = null;
        this._locator = null;
        this._cookie = null;
        assert (this._observer == null);
        if (this._os != null) {
            this._os.reset();
        }
        this._is = null;
        assert (this._responseHandler == null);
        this._inParamPos = -1;
        return true;
    }

    @Override
    public Current getCurrent() {
        return this._current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(ServantManager servantManager, InputStream stream) {
        this._is = stream;
        int start = this._is.pos();
        this._current.id.ice_readMembers(this._is);
        String[] facetPath = this._is.readStringSeq();
        if (facetPath.length > 0) {
            if (facetPath.length > 1) {
                throw new MarshalException();
            }
            this._current.facet = facetPath[0];
        } else {
            this._current.facet = "";
        }
        this._current.operation = this._is.readString();
        this._current.mode = OperationMode.values()[this._is.readByte()];
        this._current.ctx = new HashMap<String, String>();
        int sz = this._is.readSize();
        while (sz-- > 0) {
            String first = this._is.readString();
            String second = this._is.readString();
            this._current.ctx.put(first, second);
        }
        CommunicatorObserver obsv = this._instance.initializationData().observer;
        if (obsv != null) {
            int size = this._is.readInt();
            this._is.pos(this._is.pos() - 4);
            this._observer = obsv.getDispatchObserver(this._current, this._is.pos() - start + size);
            if (this._observer != null) {
                this._observer.attach();
            }
        }
        if (servantManager != null) {
            this._servant = servantManager.findServant(this._current.id, this._current.facet);
            if (this._servant == null) {
                this._locator = servantManager.findServantLocator(this._current.id.category);
                if (this._locator == null && this._current.id.category.length() > 0) {
                    this._locator = servantManager.findServantLocator("");
                }
                if (this._locator != null) {
                    try {
                        ServantLocator.LocateResult r = this._locator.locate(this._current);
                        this._servant = r.returnValue;
                        this._cookie = r.cookie;
                    }
                    catch (Throwable ex2) {
                        this.skipReadParams();
                        this.handleException(ex2, false);
                        return;
                    }
                }
            }
        }
        if (this._servant == null) {
            try {
                if (servantManager != null && servantManager.hasServant(this._current.id)) {
                    throw new FacetNotExistException(this._current.id, this._current.facet, this._current.operation);
                }
                throw new ObjectNotExistException(this._current.id, this._current.facet, this._current.operation);
            }
            catch (Throwable ex3) {
                this.skipReadParams();
                this.handleException(ex3, false);
                return;
            }
        }
        try {
            if (this._instance.useApplicationClassLoader()) {
                Thread.currentThread().setContextClassLoader(this._servant.getClass().getClassLoader());
            }
            try {
                CompletionStage<OutputStream> f = this._servant._iceDispatch(this, this._current);
                if (f == null) {
                    this.completed(null, false);
                } else {
                    f.whenComplete((result, ex) -> {
                        if (ex != null) {
                            this.completed((Throwable)ex, true);
                        } else {
                            this._os = result;
                            this.completed(null, true);
                        }
                    });
                }
            }
            finally {
                if (this._instance.useApplicationClassLoader()) {
                    Thread.currentThread().setContextClassLoader(null);
                }
            }
        }
        catch (ServantError ex4) {
            throw ex4;
        }
        catch (Throwable ex5) {
            this.completed(ex5, false);
        }
    }

    public CompletionStage<OutputStream> setResult(OutputStream os) {
        this._os = os;
        return null;
    }

    public <T> CompletionStage<OutputStream> setResultFuture(CompletionStage<T> f, Write<T> write) {
        CompletableFuture<OutputStream> r = new CompletableFuture<OutputStream>();
        f.whenComplete((result, ex) -> {
            if (ex != null) {
                r.completeExceptionally((Throwable)ex);
            } else {
                OutputStream os = this.startWriteParams();
                write.write(os, result);
                this.endWriteParams(os);
                r.complete(os);
            }
        });
        return r;
    }

    public CompletionStage<OutputStream> setResultFuture(CompletionStage<Void> f) {
        CompletableFuture<OutputStream> r = new CompletableFuture<OutputStream>();
        f.whenComplete((result, ex) -> {
            if (ex != null) {
                r.completeExceptionally((Throwable)ex);
            } else {
                r.complete(this.writeEmptyParams());
            }
        });
        return r;
    }

    public CompletionStage<OutputStream> setMarshaledResult(MarshaledResult result) {
        this._os = result.getOutputStream();
        return null;
    }

    public <T extends MarshaledResult> CompletionStage<OutputStream> setMarshaledResultFuture(CompletionStage<T> f) {
        CompletableFuture<OutputStream> r = new CompletableFuture<OutputStream>();
        f.whenComplete((result, ex) -> {
            if (ex != null) {
                r.completeExceptionally((Throwable)ex);
            } else {
                r.complete(result.getOutputStream());
            }
        });
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(Throwable exc, boolean amd) {
        try {
            if (this._locator != null) {
                assert (this._locator != null && this._servant != null);
                try {
                    this._locator.finished(this._current, this._servant, this._cookie);
                }
                catch (Throwable ex) {
                    this.handleException(ex, amd);
                    if (this._observer != null) {
                        this._observer.detach();
                        this._observer = null;
                    }
                    this._responseHandler = null;
                    return;
                }
            }
            assert (this._responseHandler != null);
            if (exc != null) {
                this.handleException(exc, amd);
            } else if (this._response) {
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (LocalException ex) {
            this._responseHandler.invokeException(this._current.requestId, ex, 1, amd);
        }
        finally {
            if (this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            this._responseHandler = null;
        }
    }

    public final void startOver() {
        if (this._inParamPos == -1) {
            this._inParamPos = this._is.pos();
        } else {
            this._is.pos(this._inParamPos);
            this._os = null;
        }
    }

    public void skipReadParams() {
        this._current.encoding = this._is.skipEncapsulation();
    }

    public InputStream startReadParams() {
        this._current.encoding = this._is.startEncapsulation();
        return this._is;
    }

    public void endReadParams() {
        this._is.endEncapsulation();
    }

    public void readEmptyParams() {
        this._current.encoding = this._is.skipEmptyEncapsulation();
    }

    public byte[] readParamEncaps() {
        this._current.encoding = new EncodingVersion();
        return this._is.readEncapsulation(this._current.encoding);
    }

    public void setFormat(FormatType format) {
        if (format == null) {
            format = FormatType.DefaultFormat;
        }
        this._format = format;
    }

    public static OutputStream createResponseOutputStream(Current current) {
        OutputStream os = new OutputStream(current.adapter.getCommunicator(), Protocol.currentProtocolEncoding);
        os.writeBlob(Protocol.replyHdr);
        os.writeInt(current.requestId);
        os.writeByte((byte)0);
        return os;
    }

    public OutputStream startWriteParams() {
        if (!this._response) {
            throw new MarshalException("can't marshal out parameters for oneway dispatch");
        }
        OutputStream os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
        os.writeBlob(Protocol.replyHdr);
        os.writeInt(this._current.requestId);
        os.writeByte((byte)0);
        os.startEncapsulation(this._current.encoding, this._format);
        return os;
    }

    public void endWriteParams(OutputStream os) {
        if (this._response) {
            os.endEncapsulation();
        }
    }

    public OutputStream writeEmptyParams() {
        if (this._response) {
            OutputStream os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
            os.writeBlob(Protocol.replyHdr);
            os.writeInt(this._current.requestId);
            os.writeByte((byte)0);
            os.writeEmptyEncapsulation(this._current.encoding);
            return os;
        }
        return null;
    }

    public OutputStream writeParamEncaps(byte[] v, boolean ok) {
        if (!ok && this._observer != null) {
            this._observer.userException();
        }
        if (this._response) {
            OutputStream os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
            os.writeBlob(Protocol.replyHdr);
            os.writeInt(this._current.requestId);
            os.writeByte(ok ? (byte)0 : 1);
            if (v == null || v.length == 0) {
                os.writeEmptyEncapsulation(this._current.encoding);
            } else {
                os.writeEncapsulation(v);
            }
            return os;
        }
        return null;
    }

    private void warning(Throwable ex) {
        assert (this._instance != null);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        OutputBase out = new OutputBase(pw);
        out.setUseTab(false);
        out.print("dispatch exception:");
        out.print("\nidentity: " + Util.identityToString(this._current.id, this._instance.toStringMode()));
        out.print("\nfacet: " + StringUtil.escapeString(this._current.facet, "", this._instance.toStringMode()));
        out.print("\noperation: " + this._current.operation);
        if (this._current.con != null) {
            try {
                ConnectionInfo connInfo = this._current.con.getInfo();
                while (connInfo != null) {
                    if (connInfo instanceof IPConnectionInfo) {
                        IPConnectionInfo ipConnInfo = (IPConnectionInfo)connInfo;
                        out.print("\nremote host: " + ipConnInfo.remoteAddress + " remote port: " + ipConnInfo.remotePort);
                    }
                    connInfo = connInfo.underlying;
                }
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
        out.print("\n");
        ex.printStackTrace(pw);
        pw.flush();
        this._instance.initializationData().logger.warning(sw.toString());
    }

    private void handleException(Throwable exc, boolean amd) {
        block66: {
            assert (this._responseHandler != null);
            try {
                throw exc;
            }
            catch (RequestFailedException ex) {
                if (ex.id == null || ex.id.name == null || ex.id.name.isEmpty()) {
                    ex.id = this._current.id;
                }
                if (ex.facet == null || ex.facet.isEmpty()) {
                    ex.facet = this._current.facet;
                }
                if (ex.operation == null || ex.operation.length() == 0) {
                    ex.operation = this._current.operation;
                }
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    assert (this._responseHandler != null && this._current != null);
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    if (ex instanceof ObjectNotExistException) {
                        this._os.writeByte((byte)2);
                    } else if (ex instanceof FacetNotExistException) {
                        this._os.writeByte((byte)3);
                    } else if (ex instanceof OperationNotExistException) {
                        this._os.writeByte((byte)4);
                    } else assert (false);
                    ex.id.ice_writeMembers(this._os);
                    if (ex.facet == null || ex.facet.length() == 0) {
                        this._os.writeStringSeq(null);
                    } else {
                        String[] facetPath2 = new String[]{ex.facet};
                        this._os.writeStringSeq(facetPath2);
                    }
                    this._os.writeString(ex.operation);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UnknownLocalException ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    assert (this._responseHandler != null && this._current != null);
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)5);
                    this._os.writeString(ex.unknown);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UnknownUserException ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    assert (this._responseHandler != null && this._current != null);
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)6);
                    this._os.writeString(ex.unknown);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UnknownException ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    assert (this._responseHandler != null && this._current != null);
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)7);
                    this._os.writeString(ex.unknown);
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (UserException ex) {
                if (this._observer != null) {
                    this._observer.userException();
                }
                if (this._response) {
                    assert (this._responseHandler != null && this._current != null);
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)1);
                    this._os.startEncapsulation(this._current.encoding, this._format);
                    this._os.writeException(ex);
                    this._os.endEncapsulation();
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, false);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (Exception ex) {
                if (ex instanceof SystemException && this._responseHandler.systemException(this._current.requestId, (SystemException)ex, amd)) {
                    return;
                }
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.ice_id());
                }
                if (this._response) {
                    assert (this._responseHandler != null && this._current != null);
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)5);
                    StringWriter sw = new StringWriter();
                    sw.write(ex.ice_id() + "\n");
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._os.writeString(sw.toString());
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
            }
            catch (ExecutionException ex) {
                this.handleException(ex.getCause(), amd);
                return;
            }
            catch (Throwable ex) {
                if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                    this.warning(ex);
                }
                if (this._observer != null) {
                    this._observer.failed(ex.getClass().getName());
                }
                if (this._response) {
                    assert (this._responseHandler != null && this._current != null);
                    this._os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                    this._os.writeBlob(Protocol.replyHdr);
                    this._os.writeInt(this._current.requestId);
                    this._os.writeByte((byte)7);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._os.writeString(sw.toString());
                    if (this._observer != null) {
                        this._observer.reply(this._os.size() - 14 - 4);
                    }
                    this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, amd);
                } else {
                    this._responseHandler.sendNoResponse();
                }
                if (this._observer != null) {
                    this._observer.detach();
                    this._observer = null;
                }
                this._responseHandler = null;
                if (amd || !(ex instanceof Error)) break block66;
                throw new ServantError((Error)ex);
            }
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
    }

    @FunctionalInterface
    public static interface Write<T> {
        public void write(OutputStream var1, T var2);
    }
}

