/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor;

import com.google.common.collect.Lists;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeSourcePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.psi.IpnbPyFragment;

public class IpnbEditorUtil {
    public static final Dimension PROMPT_SIZE = new Dimension(80, 30);

    public static Editor createPythonCodeEditor(@NotNull Project project, @NotNull IpnbCodeSourcePanel codeSourcePanel) {
        if (project == null) {
            IpnbEditorUtil.$$$reportNull$$$0(0);
        }
        if (codeSourcePanel == null) {
            IpnbEditorUtil.$$$reportNull$$$0(1);
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        assert (editorFactory != null);
        String text = ((IpnbCodeCell)codeSourcePanel.getCell()).getSourceAsString();
        Module module = ProjectRootManagerEx.getInstanceEx((Project)project).getFileIndex().getModuleForFile(codeSourcePanel.getIpnbCodePanel().getFileEditor().getVirtualFile());
        IpnbPyFragment fragment = new IpnbPyFragment(project, text, true, codeSourcePanel);
        fragment.putUserData(ModuleUtilCore.KEY_MODULE, module);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        assert (document != null);
        EditorEx editor = (EditorEx)editorFactory.createEditor(document, project, fragment.getVirtualFile(), false);
        editor.setFile(fragment.getVirtualFile());
        IpnbEditorUtil.setupEditor(editor);
        return editor;
    }

    private static void setupEditor(@NotNull EditorEx editor) {
        if (editor == null) {
            IpnbEditorUtil.$$$reportNull$$$0(2);
        }
        editor.setBackgroundColor(IpnbEditorUtil.getEditablePanelBackground());
        IpnbEditorUtil.noScrolling(editor);
        editor.getScrollPane().setBorder(null);
        editor.setContextMenuGroupId(null);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalPageAtBottom(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(0);
        editorSettings.setRightMarginShown(false);
    }

    public static Color getEditablePanelBackground() {
        return !UIUtil.isUnderDarcula() ? Gray._247 : EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
    }

    public static Editor createPlainCodeEditor(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            IpnbEditorUtil.$$$reportNull$$$0(3);
        }
        if (text == null) {
            IpnbEditorUtil.$$$reportNull$$$0(4);
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        assert (editorFactory != null);
        Document document = editorFactory.createDocument((CharSequence)text);
        EditorEx editor = (EditorEx)editorFactory.createEditor(document, project);
        IpnbEditorUtil.setupEditor(editor);
        return editor;
    }

    private static void noScrolling(EditorEx editor) {
        editor.getScrollPane().setVerticalScrollBarPolicy(21);
        editor.getScrollPane().setHorizontalScrollBarPolicy(30);
        editor.getScrollPane().setWheelScrollingEnabled(false);
        ArrayList listeners = Lists.newArrayList((Object[])editor.getScrollPane().getMouseWheelListeners());
        for (MouseWheelListener l : listeners) {
            editor.getScrollPane().removeMouseWheelListener(l);
        }
    }

    public static JLabel createPromptComponent(@Nullable Integer promptNumber, @NotNull PromptType type) {
        if (type == null) {
            IpnbEditorUtil.$$$reportNull$$$0(5);
        }
        String promptText = IpnbEditorUtil.prompt(promptNumber, type);
        JLabel promptLabel = new JLabel(promptText);
        promptLabel.setHorizontalAlignment(4);
        promptLabel.setMinimumSize(PROMPT_SIZE);
        promptLabel.setPreferredSize(PROMPT_SIZE);
        Font font = promptLabel.getFont();
        assert (font != null);
        promptLabel.setFont(font.deriveFont(1));
        JBColor darkRed = new JBColor(new Color(210, 30, 50), new Color(210, 30, 50));
        promptLabel.setForeground((Color)(type == PromptType.In ? JBColor.BLUE : darkRed));
        promptLabel.setBackground(IpnbEditorUtil.getBackground());
        return promptLabel;
    }

    public static String prompt(@Nullable Integer promptNumber, @NotNull PromptType type) {
        if (type == null) {
            IpnbEditorUtil.$$$reportNull$$$0(6);
        }
        if (type == PromptType.In) {
            return promptNumber == null ? (Object)((Object)type) + " [ ]:" : (promptNumber > 0 ? String.format((Object)((Object)type) + " [%d]:", promptNumber) : (Object)((Object)type) + " [*]:");
        }
        if (type == PromptType.Out) {
            return promptNumber == null ? (Object)((Object)type) + "[ ]:" : (promptNumber > 0 ? String.format((Object)((Object)type) + "[%d]:", promptNumber) : (Object)((Object)type) + "[*]:");
        }
        return "";
    }

    public static Color getBackground() {
        return EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeSourcePanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/IpnbEditorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPythonCodeEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createPlainCodeEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createPromptComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "prompt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum PromptType {
        In,
        Out,
        None;

    }
}

