/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.dataframe;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.PyNumericViewUtil;
import com.jetbrains.python.debugger.dataframe.TableValueDescriptor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

class DataFrameTableCellRenderer
extends DefaultTableCellRenderer
implements ColoredCellRenderer {
    private boolean myColored = true;

    DataFrameTableCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(2);
        this.setVerticalAlignment(0);
    }

    @Override
    public void setColored(boolean colored) {
        this.myColored = colored;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        if (value != null) {
            this.setText(value.toString());
        }
        if (!(value instanceof TableValueDescriptor)) {
            return this;
        }
        TableValueDescriptor descriptor2 = (TableValueDescriptor)value;
        if (hasFocus) {
            this.setBorder(new LineBorder((Color)JBColor.BLUE, 2));
        }
        if (this.myColored) {
            try {
                double rangedValue = descriptor2.getRangedValue();
                if (!Double.isNaN(rangedValue)) {
                    this.setBackground(PyNumericViewUtil.rangedValueToColor(rangedValue));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.setBackground((Color)new JBColor(UIUtil.getBgFillColor((Component)table), UIUtil.getBgFillColor((Component)table)));
        }
        return this;
    }
}

