/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesCopyHandler
extends CopyHandlerDelegateBase {
    private static final Logger LOG = Logger.getInstance(PropertiesCopyHandler.class);

    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        String propertyName = null;
        for (PsiElement element : elements) {
            IProperty property = PropertiesImplUtil.getProperty(element);
            if (property == null) {
                return false;
            }
            if (propertyName == null) {
                propertyName = property.getKey();
                continue;
            }
            if (propertyName.equals(property.getKey())) continue;
            return false;
        }
        return propertyName != null;
    }

    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        IProperty representative = PropertiesImplUtil.getProperty(elements[0]);
        if (representative == null) {
            return;
        }
        String key = representative.getKey();
        if (key == null) {
            return;
        }
        ResourceBundle resourceBundle = representative.getPropertiesFile().getResourceBundle();
        List properties = ContainerUtil.mapNotNull(resourceBundle.getPropertiesFiles(), (Function)((NullableFunction)propertiesFile -> propertiesFile.findPropertyByKey(key)));
        PropertiesCopyDialog dlg = new PropertiesCopyDialog(properties, resourceBundle);
        if (!properties.isEmpty() && dlg.showAndGet()) {
            String propertyNewName = dlg.getCurrentPropertyName();
            ResourceBundle destinationResourceBundle = dlg.getCurrentResourceBundle();
            PropertiesCopyHandler.copyPropertyToAnotherBundle(properties, propertyNewName, destinationResourceBundle);
        }
    }

    public void doClone(PsiElement element) {
    }

    private static void copyPropertyToAnotherBundle(@NotNull Collection<? extends IProperty> properties, @NotNull String newName, @NotNull ResourceBundle targetResourceBundle) {
        if (properties == null) {
            PropertiesCopyHandler.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            PropertiesCopyHandler.$$$reportNull$$$0(1);
        }
        if (targetResourceBundle == null) {
            PropertiesCopyHandler.$$$reportNull$$$0(2);
        }
        HashMap propertiesFileMapping = new HashMap();
        for (IProperty iProperty : properties) {
            PropertiesFile containingFile = iProperty.getPropertiesFile();
            PropertiesFile matched = PropertiesCopyHandler.findWithMatchedSuffix(containingFile, targetResourceBundle);
            if (matched == null) continue;
            propertiesFileMapping.put(iProperty, matched);
        }
        Project project = targetResourceBundle.getProject();
        if (properties.size() != propertiesFileMapping.size() && 1 == Messages.showYesNoDialog((Project)project, (String)"Source and target resource bundles properties files are not matched correctly. Copy properties anyway?", (String)"Resource Bundles Are not Matched", null)) {
            return;
        }
        if (!propertiesFileMapping.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> PropertiesCopyHandler.lambda$copyPropertyToAnotherBundle$1((Map)propertiesFileMapping, newName));
            IProperty iProperty = (IProperty)ContainerUtil.getFirstItem(properties);
            LOG.assertTrue(iProperty != null);
            ResourceBundle sourceResourceBundle = iProperty.getPropertiesFile().getResourceBundle();
            if (sourceResourceBundle.equals(targetResourceBundle)) {
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                    FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
                    if (fileEditor instanceof ResourceBundleEditor) {
                        ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)fileEditor;
                        resourceBundleEditor.updateTreeRoot();
                        resourceBundleEditor.selectProperty(newName);
                    }
                });
            } else {
                for (FileEditor editor : FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new ResourceBundleAsVirtualFile(targetResourceBundle), true)) {
                    ((ResourceBundleEditor)editor).updateTreeRoot();
                    ((ResourceBundleEditor)editor).selectProperty(newName);
                }
            }
        }
    }

    @Nullable
    private static PropertiesFile findWithMatchedSuffix(@NotNull PropertiesFile searchFile, @NotNull ResourceBundle resourceBundle) {
        if (searchFile == null) {
            PropertiesCopyHandler.$$$reportNull$$$0(3);
        }
        if (resourceBundle == null) {
            PropertiesCopyHandler.$$$reportNull$$$0(4);
        }
        String targetSuffix = PropertiesCopyHandler.getPropertiesFileSuffix(searchFile, searchFile.getResourceBundle().getBaseName());
        String baseName = resourceBundle.getBaseName();
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (!PropertiesCopyHandler.getPropertiesFileSuffix(propertiesFile, baseName).equals(targetSuffix)) continue;
            return propertiesFile;
        }
        return null;
    }

    @NotNull
    private static String getPropertiesFileSuffix(PropertiesFile searchFile, String baseName) {
        String suffix = FileUtil.getNameWithoutExtension((String)searchFile.getContainingFile().getName());
        String string = suffix = StringUtil.trimStart((String)suffix, (String)baseName);
        if (string == null) {
            PropertiesCopyHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void lambda$copyPropertyToAnotherBundle$1(Map propertiesFileMapping, String newName) {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)ContainerUtil.map(propertiesFileMapping.values(), PropertiesFile::getContainingFile))) {
            return;
        }
        for (Map.Entry entry : propertiesFileMapping.entrySet()) {
            String value = ((IProperty)entry.getKey()).getValue();
            PropertiesFile target = (PropertiesFile)entry.getValue();
            target.addProperty(newName, value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetResourceBundle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/PropertiesCopyHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/PropertiesCopyHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFileSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertyToAnotherBundle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findWithMatchedSuffix";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResourceBundleAsFileSystemItem
    extends SyntheticFileSystemItem {
        private final ResourceBundle myResourceBundle;

        ResourceBundleAsFileSystemItem(@NotNull ResourceBundle resourceBundle) {
            if (resourceBundle == null) {
                ResourceBundleAsFileSystemItem.$$$reportNull$$$0(0);
            }
            super(resourceBundle.getProject());
            this.myResourceBundle = resourceBundle;
        }

        public ResourceBundle getResourceBundle() {
            return this.myResourceBundle;
        }

        @NotNull
        public String getName() {
            String string = this.myResourceBundle.getBaseName();
            if (string == null) {
                ResourceBundleAsFileSystemItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public PsiFileSystemItem getParent() {
            VirtualFile dir = this.myResourceBundle.getBaseDirectory();
            return dir == null ? null : PsiManager.getInstance((Project)this.getProject()).findDirectory(dir);
        }

        public VirtualFile getVirtualFile() {
            return new ResourceBundleAsVirtualFile(this.myResourceBundle);
        }

        public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
            for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles()) {
                if (propertiesFile.getContainingFile().processChildren(processor)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        public Icon getIcon(int flags) {
            return AllIcons.Nodes.ResourceBundle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResourceBundleAsFileSystemItem item = (ResourceBundleAsFileSystemItem)((Object)o);
            return this.myResourceBundle.equals(item.myResourceBundle);
        }

        public int hashCode() {
            return this.myResourceBundle.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceBundle";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/editor/PropertiesCopyHandler$ResourceBundleAsFileSystemItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/editor/PropertiesCopyHandler$ResourceBundleAsFileSystemItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PropertiesCopyDialog
    extends DialogWrapper {
        @NotNull
        private final List<? extends IProperty> myProperties;
        @NotNull
        private ResourceBundle myCurrentResourceBundle;
        private String myCurrentPropertyName;
        @NotNull
        private final Project myProject;
        private JBTextField myPropertyNameTextField;

        protected PropertiesCopyDialog(@NotNull List<? extends IProperty> properties, @NotNull ResourceBundle currentResourceBundle) {
            if (properties == null) {
                PropertiesCopyDialog.$$$reportNull$$$0(0);
            }
            if (currentResourceBundle == null) {
                PropertiesCopyDialog.$$$reportNull$$$0(1);
            }
            super(currentResourceBundle.getProject());
            this.myProperties = properties;
            this.myCurrentResourceBundle = currentResourceBundle;
            this.myCurrentPropertyName = ((IProperty)ContainerUtil.getFirstItem(properties)).getName();
            this.myProject = currentResourceBundle.getProject();
            this.init();
            this.initValidation();
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (StringUtil.isEmpty((String)this.myCurrentPropertyName)) {
                return new ValidationInfo("Property name must be not empty");
            }
            return PropertiesUtil.containsProperty(this.myCurrentResourceBundle, this.myCurrentPropertyName) ? new ValidationInfo(String.format("Property with name '%s' already exists", this.myCurrentPropertyName)) : null;
        }

        public String getCurrentPropertyName() {
            return this.myCurrentPropertyName;
        }

        @NotNull
        public ResourceBundle getCurrentResourceBundle() {
            ResourceBundle resourceBundle = this.myCurrentResourceBundle;
            if (resourceBundle == null) {
                PropertiesCopyDialog.$$$reportNull$$$0(2);
            }
            return resourceBundle;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JLabel informationalLabel = new JLabel();
            informationalLabel.setText("Copy property " + ((IProperty)ContainerUtil.getFirstItem(this.myProperties)).getName());
            informationalLabel.setFont(informationalLabel.getFont().deriveFont(1));
            ArrayList propertiesFiles = new ArrayList();
            GlobalSearchScope searchScope = ProjectScope.getContentScope((Project)this.myProject);
            PropertiesReferenceManager.getInstance(this.myProject).processPropertiesFiles(searchScope, (baseName, propertiesFile) -> {
                propertiesFiles.add(propertiesFile);
                return true;
            }, BundleNameEvaluator.BASE_NAME);
            Object[] resourceBundlesAsFileSystemItems = (PsiFileSystemItem[])propertiesFiles.stream().map(PropertiesFile::getResourceBundle).distinct().filter(b -> b.getBaseDirectory() != null).sorted(Comparator.comparing(ResourceBundle::getBaseName)).map(ResourceBundleAsFileSystemItem::new).toArray(PsiFileSystemItem[]::new);
            final ComboBox resourceBundleComboBox = new ComboBox(resourceBundlesAsFileSystemItems);
            new ComboboxSpeedSearch((JComboBox)resourceBundleComboBox){

                protected String getElementText(Object element) {
                    return ((PsiFileSystemItem)element).getName();
                }
            };
            resourceBundleComboBox.setRenderer((ListCellRenderer)new GotoFileCellRenderer(500){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    UIUtil.setBackgroundRecursively((Component)component, (Color)(isSelected ? UIUtil.getListSelectionBackground() : resourceBundleComboBox.getBackground()));
                    return component;
                }
            });
            resourceBundleComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(@NotNull ItemEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    myCurrentResourceBundle = ((ResourceBundleAsFileSystemItem)((Object)e.getItem())).getResourceBundle();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog$3", "itemStateChanged"));
                }
            });
            resourceBundleComboBox.setSelectedItem((Object)new ResourceBundleAsFileSystemItem(this.myCurrentResourceBundle));
            this.myPropertyNameTextField = new JBTextField(((IProperty)ContainerUtil.getFirstItem(this.myProperties)).getKey());
            this.myPropertyNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    myCurrentPropertyName = myPropertyNameTextField.getText();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog$4", "textChanged"));
                }
            });
            return FormBuilder.createFormBuilder().addComponent((JComponent)informationalLabel).addLabeledComponent("&New name:", (JComponent)this.myPropertyNameTextField, 12).addLabeledComponent("&Destination resource bundle:", (JComponent)resourceBundleComboBox).getPanel();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPropertyNameTextField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentResourceBundle";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentResourceBundle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

