/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomDictionariesPanel
extends JPanel {
    private final SpellCheckerSettings mySettings;
    @NotNull
    private final SpellCheckerManager myManager;
    private final CustomDictionariesTableView myCustomDictionariesTableView;
    private final List<String> removedDictionaries;
    private final List<String> defaultDictionaries;

    public CustomDictionariesPanel(@NotNull SpellCheckerSettings settings, final @NotNull Project project, final @NotNull SpellCheckerManager manager) {
        if (settings == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(2);
        }
        this.removedDictionaries = new ArrayList<String>();
        this.mySettings = settings;
        this.myManager = manager;
        this.defaultDictionaries = project.isDefault() ? new ArrayList<String>() : Arrays.asList(SpellCheckerBundle.message("app.dictionary", new Object[0]), SpellCheckerBundle.message("project.dictionary", new Object[0]));
        this.myCustomDictionariesTableView = new CustomDictionariesTableView(new ArrayList<String>(settings.getCustomDictionariesPaths()), this.defaultDictionaries, new ArrayList<String>(settings.getDisabledDictionariesPaths()));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)((Object)this.myCustomDictionariesTableView)).setAddActionName(SpellCheckerBundle.message("add.custom.dictionaries", new Object[0])).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CustomDictionariesPanel.this.myCustomDictionariesTableView.stopEditing();
                CustomDictionariesPanel.this.doChooseFiles(project, (Consumer<List<VirtualFile>>)files2 -> files2.stream().map(VirtualFile::getPath).map(PathUtil::toSystemDependentName).filter(path -> !CustomDictionariesPanel.this.myCustomDictionariesTableView.getItems().contains(path)).forEach(path -> CustomDictionariesPanel.this.myCustomDictionariesTableView.getListTableModel().addRow(path)));
            }
        }).setRemoveActionName(SpellCheckerBundle.message("remove.custom.dictionaries", new Object[0])).setRemoveAction(button -> {
            this.removedDictionaries.addAll(this.myCustomDictionariesTableView.getSelectedObjects());
            TableUtil.removeSelectedItems((JTable)((Object)this.myCustomDictionariesTableView));
        }).setRemoveActionUpdater(e -> !ContainerUtil.exists((Iterable)this.myCustomDictionariesTableView.getSelectedObjects(), this.defaultDictionaries::contains)).setEditActionName(SpellCheckerBundle.message("edit.custom.dictionary", new Object[0])).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String selectedDictionary = (String)CustomDictionariesPanel.this.myCustomDictionariesTableView.getSelectedObject();
                if (selectedDictionary == null) {
                    return;
                }
                if (CustomDictionariesPanel.this.defaultDictionaries.contains(selectedDictionary)) {
                    selectedDictionary = selectedDictionary.equals(SpellCheckerBundle.message("app.dictionary", new Object[0])) ? CustomDictionariesPanel.this.myManager.getAppDictionaryPath() : CustomDictionariesPanel.this.myManager.getProjectDictionaryPath();
                }
                manager.openDictionaryInEditor(selectedDictionary);
            }
        }).disableUpDownActions();
        this.myCustomDictionariesTableView.getEmptyText().setText(SpellCheckerBundle.message("no.custom.dictionaries", new Object[0]));
        this.setLayout(new BorderLayout());
        this.add((Component)decorator.createPanel(), "Center");
    }

    private void doChooseFiles(@NotNull Project project, @NotNull Consumer<List<VirtualFile>> consumer) {
        if (project == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            CustomDictionariesPanel.$$$reportNull$$$0(4);
        }
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileSelectable(VirtualFile file2) {
                return FileUtilRt.extensionEquals((String)file2.getPath(), (String)"dic");
            }
        };
        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor2, (Project)project, (Component)this.getParent(), (VirtualFile)project.getBaseDir(), consumer);
    }

    public List<String> getRemovedDictionaries() {
        return this.removedDictionaries;
    }

    public boolean isModified() {
        List<String> oldPaths = this.mySettings.getCustomDictionariesPaths();
        List newPaths = ContainerUtil.filter((Collection)this.myCustomDictionariesTableView.getItems(), o -> !this.defaultDictionaries.contains(o));
        if (oldPaths.size() != newPaths.size()) {
            return true;
        }
        Set<String> oldDisabled = this.mySettings.getDisabledDictionariesPaths();
        List newDisabled = this.myCustomDictionariesTableView.getDisabled();
        if (oldDisabled.size() != newDisabled.size()) {
            return true;
        }
        if (!newPaths.containsAll(oldPaths) || !oldPaths.containsAll(newPaths)) {
            return true;
        }
        return !newDisabled.containsAll(oldDisabled) || !oldDisabled.containsAll(newDisabled);
    }

    public void reset() {
        this.myCustomDictionariesTableView.getListTableModel().setItems(new ArrayList(ContainerUtil.concat(this.defaultDictionaries, this.mySettings.getCustomDictionariesPaths())));
        this.myCustomDictionariesTableView.setDisabled(new ArrayList<String>(this.mySettings.getDisabledDictionariesPaths()));
        this.removedDictionaries.clear();
    }

    public void apply() {
        this.mySettings.setCustomDictionariesPaths(new ArrayList<String>(ContainerUtil.filter((Collection)this.myCustomDictionariesTableView.getItems(), dict -> !this.defaultDictionaries.contains(dict))));
        this.mySettings.setDisabledDictionariesPaths(new HashSet<String>(this.myCustomDictionariesTableView.getDisabled()));
    }

    public List<String> getValues() {
        return this.myCustomDictionariesTableView.getItems();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doChooseFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CustomDictionariesTableView
    extends TableView<String> {
        @NotNull
        private final List<String> myDefaultDictionaries;
        @NotNull
        private List<String> myDisabled;
        final TableCellRenderer myTypeRenderer;

        private CustomDictionariesTableView(@NotNull List<String> dictionaries, @NotNull List<String> defaultDictionaries, @NotNull List<String> disabled) {
            if (dictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(0);
            }
            if (defaultDictionaries == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(1);
            }
            if (disabled == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(2);
            }
            this.myDefaultDictionaries = defaultDictionaries;
            this.myDisabled = disabled;
            this.myTypeRenderer = CustomDictionariesTableView.createTypeRenderer(this.myDefaultDictionaries);
            this.setModelAndUpdateColumns(new ListTableModel(this.createDictionaryColumnInfos(), ContainerUtil.concat(defaultDictionaries, dictionaries), 1));
            this.setAutoResizeMode(3);
            this.getColumnModel().getColumn(0).setResizable(false);
            this.setShowGrid(false);
            this.setShowVerticalLines(false);
            this.setGridColor(this.getForeground());
            this.setTableHeader(null);
            TableUtil.setupCheckboxColumn((TableColumn)this.getColumnModel().getColumn(0));
        }

        @NotNull
        private List<String> getDisabled() {
            List<String> list2 = this.myDisabled;
            if (list2 == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(3);
            }
            return list2;
        }

        public void setDisabled(@NotNull List<String> disabled) {
            if (disabled == null) {
                CustomDictionariesTableView.$$$reportNull$$$0(4);
            }
            this.myDisabled = disabled;
        }

        private static TableCellRenderer createTypeRenderer(final List<String> defaultDictionaries) {
            return new TableCellRenderer(){
                final SimpleColoredComponent myLabel = new SimpleColoredComponent();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
                    CustomDictionaryProvider provider;
                    this.myLabel.clear();
                    this.myLabel.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String type = defaultDictionaries.contains(value) ? SpellCheckerBundle.message("built.in.dictionary", new Object[0]) : ((provider = (CustomDictionaryProvider)CustomDictionaryProvider.EP_NAME.getExtensionList().stream().filter(dictionaryProvider -> dictionaryProvider.isApplicable((String)value)).findAny().orElse(null)) != null ? provider.getDictionaryType() : SpellCheckerBundle.message("words.list.dictionary", new Object[0]));
                    this.myLabel.append(" [" + type + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    return this.myLabel;
                }
            };
        }

        private ColumnInfo[] createDictionaryColumnInfos() {
            return new ColumnInfo[]{new ColumnInfo<String, Boolean>(" "){

                public Class<?> getColumnClass() {
                    return Boolean.class;
                }

                public void setValue(String s, Boolean value) {
                    if (value.booleanValue()) {
                        myDisabled.remove(s);
                    } else {
                        myDisabled.add(s);
                    }
                }

                public boolean isCellEditable(String s) {
                    return !myDefaultDictionaries.contains(s);
                }

                public Boolean valueOf(String o) {
                    return !myDisabled.contains(o);
                }
            }, new ColumnInfo<String, String>(SpellCheckerBundle.message("custom.dictionary.title", new Object[0])){

                public String valueOf(String info) {
                    return info;
                }

                @Nullable
                public TableCellRenderer getRenderer(String s) {
                    return myTypeRenderer;
                }
            }};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dictionaries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultDictionaries";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disabled";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/settings/CustomDictionariesPanel$CustomDictionariesTableView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/settings/CustomDictionariesPanel$CustomDictionariesTableView";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisabled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setDisabled";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

