/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.components.labels.SwingActionLink;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JLabel;

final class Banner
extends SimpleBanner {
    private final JLabel myProjectIcon = new JLabel();
    private final Breadcrumbs myBreadcrumbs = new Breadcrumbs(){

        protected int getFontStyle(Crumb crumb) {
            return 1;
        }
    };

    Banner(Action action) {
        this.myProjectIcon.setMinimumSize(new Dimension(0, 0));
        this.myProjectIcon.setIcon(AllIcons.General.ProjectConfigurable);
        this.myProjectIcon.setForeground((Color)JBColor.GRAY);
        this.myProjectIcon.setVisible(false);
        this.myLeftPanel.add((Component)this.myBreadcrumbs, 0);
        this.add("Center", this.myProjectIcon);
        this.add("East", RelativeFont.BOLD.install((Component)new SwingActionLink(action)));
    }

    void setText(Collection<String> names) {
        Transferable transferable = CopySettingsPathAction.createTransferable(names);
        ArrayList<Crumb.Impl> crumbs = new ArrayList<Crumb.Impl>();
        if (transferable != null) {
            Action action = CopySettingsPathAction.createSwingAction(() -> transferable);
            for (String name : names) {
                crumbs.add(new Crumb.Impl(null, name, null, new Action[]{action}));
            }
        }
        this.myBreadcrumbs.setCrumbs(crumbs);
    }

    void setProject(Project project) {
        if (project == null) {
            this.myProjectIcon.setVisible(false);
        } else {
            this.myProjectIcon.setVisible(true);
            String projectConceptName = IdeUICustomization.getInstance().getProjectConceptName();
            this.myProjectIcon.setText(project.isDefault() ? OptionsBundle.message((String)"configurable.default.project.tooltip", (Object[])new Object[]{projectConceptName}) : OptionsBundle.message((String)"configurable.current.project.tooltip", (Object[])new Object[]{projectConceptName}));
        }
    }

    @Override
    void setCenterComponent(Component component) {
        boolean addProjectIcon = this.myCenterComponent != null && component == null;
        super.setCenterComponent(component);
        if (addProjectIcon) {
            this.getLayout().addLayoutComponent("Center", this.myProjectIcon);
        }
    }

    @Override
    void setLeftComponent(Component component) {
        super.setLeftComponent(component);
        this.myBreadcrumbs.setVisible(component == null);
    }

    @Override
    void updateProgressBorder() {
    }

    @Override
    Component getBaselineTemplate() {
        return this.myBreadcrumbs;
    }
}

