/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.workarea;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.pdfsam.module.Module;
import org.pdfsam.module.UsageService;
import org.pdfsam.ui.workarea.ModuleButton;

class QuickbarModuleButtonsProvider {
    private static final int RECENT_MODULES = 3;
    private static final int MAX_MODULES = 8;
    private UsageService service;
    private List<Module> modules;

    @Inject
    QuickbarModuleButtonsProvider(UsageService service, List<Module> modules) {
        this.service = service;
        this.modules = new ArrayList<Module>(modules);
        this.modules.sort((a, b) -> Integer.compare(a.descriptor().getPriority(), b.descriptor().getPriority()));
    }

    public List<ModuleButton> buttons() {
        LinkedHashSet<Module> collected = new LinkedHashSet<Module>();
        this.fillWithMostRecentlyUsed(collected);
        this.fillWithMostUsed(collected);
        this.fillWithPrioritized(collected);
        return collected.stream().map(ModuleButton::new).collect(Collectors.toList());
    }

    private void fillWithMostUsed(Set<Module> collected) {
        for (Module current : this.service.getMostUsed()) {
            if (collected.size() >= 8) break;
            collected.add(current);
        }
    }

    private void fillWithMostRecentlyUsed(Set<Module> collected) {
        for (Module current : this.service.getMostRecentlyUsed()) {
            if (collected.size() >= 3) break;
            collected.add(current);
        }
    }

    private void fillWithPrioritized(Set<Module> collected) {
        for (Module current : this.modules) {
            if (collected.size() >= 8) break;
            collected.add(current);
        }
    }
}

