/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.PatternResourcesSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ContainerItemSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings,
SourcePanel {
    private Project project;
    private List<ChangeListener> listeners;
    private boolean resourceClassNameOveridden;
    private boolean containerUriOveridden;
    private boolean containerClassNameOveridden;
    private JLabel classLabel;
    private JTextField classTextField;
    private JLabel containerLabel;
    private JTextField containerRepresentationClassTextField;
    private JTextField containerTextField;
    private JLabel containerUriLabel;
    private JTextField containerUriTextField;
    private JLabel contentClassLabel;
    private JLabel contentClassLabel1;
    private JSeparator jSeparator1;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox medaTypeComboBox;
    private JLabel mediaTypeLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JTextField representationClassTextField;
    private JLabel resourceNameLabel;
    private JTextField resourceNameTextField;
    private JButton selectClassButton;
    private JButton selectClassButton1;
    private JLabel uriLabel;
    private JTextField uriTextField;
    public static final String DEFAULT_RESOURCE_NAME = "Item";

    public ContainerItemSetupPanelVisual(String name) {
        this.setName(name);
        this.listeners = new ArrayList<ChangeListener>();
        this.initComponents();
        this.packageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ContainerItemSetupPanelVisual.this.fireChange();
            }
        });
        this.classTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.compareClassNames();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.compareClassNames();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.compareClassNames();
            }
        });
        this.containerTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.compareClassNames();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.compareClassNames();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.compareClassNames();
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<Constants.MimeType>(GenericResourceBean.getSupportedMimeTypes()));
        ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ContainerItemSetupPanelVisual.this.fireChange();
            }
        });
    }

    private void compareClassNames() {
        String containerClassName;
        String className = this.classTextField.getText().trim();
        if (className.equals(containerClassName = this.containerTextField.getText().trim())) {
            this.fireChange();
        }
    }

    private void initComponents() {
        this.classLabel = new JLabel();
        this.uriLabel = new JLabel();
        this.uriTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.medaTypeComboBox = new JComboBox();
        this.mediaTypeLabel = new JLabel();
        this.contentClassLabel = new JLabel();
        this.selectClassButton = new JButton();
        this.representationClassTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.resourceNameLabel = new JLabel();
        this.resourceNameTextField = new JTextField();
        this.classTextField = new JTextField();
        this.containerLabel = new JLabel();
        this.containerTextField = new JTextField();
        this.containerUriLabel = new JLabel();
        this.containerUriTextField = new JTextField();
        this.contentClassLabel1 = new JLabel();
        this.containerRepresentationClassTextField = new JTextField();
        this.selectClassButton1 = new JButton();
        this.setPreferredSize(new Dimension(450, 312));
        this.classLabel.setLabelFor(this.classTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/rest/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)bundle.getString("LBL_ClassName"));
        this.uriLabel.setLabelFor(this.uriTextField);
        Mnemonics.setLocalizedText((JLabel)this.uriLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_UriTemplate"));
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.setMinimumSize(new Dimension(34, 20));
        this.locationComboBox.setPreferredSize(new Dimension(4, 25));
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContainerItemSetupPanelVisual.this.locationComboBoxActionPerformed(evt);
            }
        });
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.packageComboBox.setInheritsPopupMenu(true);
        this.packageComboBox.setMinimumSize(new Dimension(133, 20));
        this.packageComboBox.setPreferredSize(new Dimension(4, 25));
        this.packageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContainerItemSetupPanelVisual.this.packageChanged(evt);
            }
        });
        this.packageComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ContainerItemSetupPanelVisual.this.packageComboBoxKeyReleased(evt);
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.medaTypeComboBox.setMinimumSize(new Dimension(69, 20));
        this.mediaTypeLabel.setLabelFor(this.medaTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.mediaTypeLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_MimeType"));
        this.contentClassLabel.setLabelFor(this.representationClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.contentClassLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_RepresentationClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.selectClassButton, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Select"));
        this.selectClassButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ContainerItemSetupPanelVisual.this.mouseClickHandler(evt);
            }
        });
        this.selectClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContainerItemSetupPanelVisual.this.selectClassButtonActionPerformed(evt);
            }
        });
        this.representationClassTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ContainerItemSetupPanelVisual.this.representationClassChanged(evt);
            }
        });
        this.resourceNameLabel.setLabelFor(this.resourceNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.resourceNameLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ResourceName"));
        this.resourceNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ContainerItemSetupPanelVisual.this.resourceNameChanged(evt);
            }
        });
        this.classTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ContainerItemSetupPanelVisual.this.classTextFieldKeyReleased(evt);
            }
        });
        this.containerLabel.setLabelFor(this.containerTextField);
        Mnemonics.setLocalizedText((JLabel)this.containerLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ContainerClass"));
        this.containerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ContainerItemSetupPanelVisual.this.containerClassNameChanged(evt);
            }
        });
        this.containerUriLabel.setLabelFor(this.containerUriTextField);
        Mnemonics.setLocalizedText((JLabel)this.containerUriLabel, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ContainerUriTemplate"));
        this.contentClassLabel1.setLabelFor(this.containerRepresentationClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.contentClassLabel1, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ContainerRepresentationClass"));
        this.containerRepresentationClassTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ContainerItemSetupPanelVisual.this.containerRepresentationClassChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.selectClassButton1, (String)NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_SelectContainerRepresentationClass"));
        this.selectClassButton1.setActionCommand(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Select"));
        this.selectClassButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ContainerItemSetupPanelVisual.this.selectClassButtonMouseClickHandler(evt);
            }
        });
        this.selectClassButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContainerItemSetupPanelVisual.this.selectClassButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 449, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classLabel).addComponent(this.locationLabel).addComponent(this.projectLabel).addComponent(this.containerLabel).addComponent(this.resourceNameLabel).addComponent(this.packageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resourceNameTextField, -1, 281, Short.MAX_VALUE).addComponent(this.classTextField, -1, 281, Short.MAX_VALUE).addComponent(this.projectTextField, -1, 281, Short.MAX_VALUE).addComponent(this.locationComboBox, 0, 281, Short.MAX_VALUE).addComponent(this.containerTextField, GroupLayout.Alignment.TRAILING, -1, 281, Short.MAX_VALUE).addComponent(this.packageComboBox, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentClassLabel1).addComponent(this.contentClassLabel).addComponent(this.uriLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.uriTextField, GroupLayout.Alignment.LEADING, -1, 141, Short.MAX_VALUE).addComponent(this.representationClassTextField, GroupLayout.Alignment.LEADING, -1, 141, Short.MAX_VALUE).addComponent(this.containerRepresentationClassTextField, GroupLayout.Alignment.LEADING, -1, 141, Short.MAX_VALUE).addComponent(this.containerUriTextField, GroupLayout.Alignment.LEADING, -1, 141, Short.MAX_VALUE).addComponent(this.medaTypeComboBox, GroupLayout.Alignment.LEADING, 0, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.selectClassButton).addComponent(this.selectClassButton1))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.containerUriLabel).addComponent(this.mediaTypeLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resourceNameTextField, -2, -1, -2).addComponent(this.resourceNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classLabel).addComponent(this.classTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.containerLabel).addComponent(this.containerTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationComboBox, -2, 26, -2).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageComboBox, -2, 26, -2).addComponent(this.packageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uriLabel).addComponent(this.uriTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.containerUriLabel).addComponent(this.containerUriTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mediaTypeLabel).addComponent(this.medaTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectClassButton).addComponent(this.contentClassLabel).addComponent(this.representationClassTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contentClassLabel1).addComponent(this.selectClassButton1).addComponent(this.containerRepresentationClassTextField, -2, -1, -2))));
        this.classLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ClassName"));
        this.uriLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_UirTemplate"));
        this.uriTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"ItemUriTemplate"));
        this.uriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_Uri"));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_ProjectName"));
        this.locationComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_Location"));
        this.packageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Package"));
        this.packageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"ResourcePackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"MimeType"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_MimeType"));
        this.mediaTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_MimeType"));
        this.contentClassLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_RepresentationClass"));
        this.selectClassButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"SelectItemResourceRepresentation"));
        this.selectClassButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_SelectClass"));
        this.representationClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"ItemResourceRepresentationClass"));
        this.representationClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_RepresentationClass"));
        this.resourceNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ResourceName"));
        this.resourceNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"ResourceName"));
        this.resourceNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_ResourceName"));
        this.classTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"ClassName"));
        this.classTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_ClassName"));
        this.containerLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ContainerClass"));
        this.containerTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"ContainerClassName"));
        this.containerTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_ContainerClassName"));
        this.containerUriLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ContainerUriTemplate"));
        this.containerUriTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ContainerUriTemplate"));
        this.containerUriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_ContainerUriTemplate"));
        this.contentClassLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_ContainerRepresentationClass"));
        this.containerRepresentationClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"ContainerResourceRepresentationClass"));
        this.containerRepresentationClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_ContainerRepresentationClass"));
        this.selectClassButton1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"SelectContainerRepresentationClass"));
        this.selectClassButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"DESC_SelectContainerRepresentationClass"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ContainerItemSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
    }

    private void selectClassButton1ActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private void selectClassButtonMouseClickHandler(MouseEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle handle = TypeElementFinder.find((ClasspathInfo)Util.getClasspathInfo(ContainerItemSetupPanelVisual.this.project), (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
                    }

                    public boolean accept(ElementHandle<TypeElement> typeHandle) {
                        return true;
                    }
                });
                if (handle != null) {
                    ContainerItemSetupPanelVisual.this.containerRepresentationClassTextField.setText(handle.getQualifiedName());
                    ContainerItemSetupPanelVisual.this.fireChange();
                }
            }
        });
    }

    private void containerRepresentationClassChanged(KeyEvent evt) {
        this.fireChange();
    }

    private void resourceNameChanged(KeyEvent evt) {
        String newName = this.resourceNameTextField.getText();
        if (!this.resourceClassNameOveridden) {
            this.classTextField.setText(this.findFreeClassName(newName));
        }
        if (!this.containerClassNameOveridden) {
            this.containerTextField.setText(this.findFreeClassName(Util.pluralize(newName)));
        }
        if (!this.containerUriOveridden) {
            String newContainerName = Util.lowerFirstChar(newName);
            String currentUri = this.containerUriTextField.getText();
            this.containerUriTextField.setText(Util.deriveUri(newContainerName, currentUri));
        }
        this.fireChange();
    }

    private void containerTextFieldActionPerformed(ActionEvent evt) {
    }

    private void containerClassNameChanged(KeyEvent evt) {
        this.containerClassNameOveridden = true;
        this.fireChange();
    }

    private void representationClassChanged(KeyEvent evt) {
        this.fireChange();
    }

    private void selectClassButtonActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private void mouseClickHandler(MouseEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle handle = TypeElementFinder.find((ClasspathInfo)Util.getClasspathInfo(ContainerItemSetupPanelVisual.this.project), (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
                    }

                    public boolean accept(ElementHandle<TypeElement> typeHandle) {
                        return true;
                    }
                });
                if (handle != null) {
                    ContainerItemSetupPanelVisual.this.representationClassTextField.setText(handle.getQualifiedName());
                    ContainerItemSetupPanelVisual.this.fireChange();
                }
            }
        });
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void classTextFieldKeyReleased(KeyEvent evt) {
        this.resourceClassNameOveridden = true;
        this.fireChange();
    }

    private void packageComboBoxKeyReleased(KeyEvent evt) {
        this.fireChange();
    }

    private void packageChanged(ActionEvent evt) {
        this.fireChange();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    @Override
    public boolean valid(WizardDescriptor wizard) {
        AbstractPanel.clearErrorMessage(wizard);
        String resourceName = this.resourceNameTextField.getText().trim();
        String packageName = this.getPackage();
        String className = this.classTextField.getText().trim();
        String containerName = this.containerTextField.getText().trim();
        SourceGroup[] groups = SourceGroupSupport.getJavaSourceGroups(this.project);
        if (groups == null || groups.length < 1) {
            AbstractPanel.setErrorMessage(wizard, "MSG_NoJavaSourceRoots");
            return false;
        }
        if (resourceName.length() == 0 || !Utilities.isJavaIdentifier((String)resourceName)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidResourceName");
            return false;
        }
        if (className.equals(containerName)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_ClassNameEqualsContainerClassName");
            return false;
        }
        if (className.length() == 0 || !Utilities.isJavaIdentifier((String)className)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidResourceClassName");
            return false;
        }
        if (containerName.length() == 0 || !Utilities.isJavaIdentifier((String)containerName)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidContainerResourceClassName");
            return false;
        }
        if (this.uriTextField.getText().trim().length() == 0) {
            AbstractPanel.setErrorMessage(wizard, "MSG_EmptyUriTemplate");
            return false;
        }
        if (!Util.isValidUri(this.uriTextField.getText().trim())) {
            AbstractPanel.setErrorMessage(wizard, "MSG_IncorrectUriTemplate");
            return false;
        }
        if (this.containerUriTextField.getText().trim().length() == 0) {
            AbstractPanel.setErrorMessage(wizard, "MSG_EmptyContainerUriTemplate");
            return false;
        }
        if (!Util.isValidUri(this.containerUriTextField.getText().trim())) {
            AbstractPanel.setErrorMessage(wizard, "MSG_IncorrectUriTemplate");
            return false;
        }
        if (!Util.isValidPackageName(packageName)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidPackageName");
            return false;
        }
        if (this.getResourceClassFile() != null) {
            AbstractPanel.setErrorMessage(wizard, "MSG_ExistingClass");
            return false;
        }
        if (this.getContainerClassFile() != null) {
            AbstractPanel.setErrorMessage(wizard, "MSG_ExistingClass");
            return false;
        }
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getText();
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.fireChange();
    }

    private String getResourceName() {
        return this.resourceNameTextField.getText();
    }

    private String getResourceClassName() {
        return this.classTextField.getText();
    }

    private FileObject getResourceClassFile() {
        FileObject folder = null;
        try {
            folder = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (folder != null) {
                return folder.getFileObject(this.getResourceClassName(), "java");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getContainerClassName() {
        return this.containerTextField.getText();
    }

    private FileObject getContainerClassFile() {
        FileObject folder = null;
        try {
            folder = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (folder != null) {
                return folder.getFileObject(this.getContainerClassName(), "java");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void read(WizardDescriptor settings) {
        this.project = Templates.getProject((WizardDescriptor)settings);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)settings);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroupSupport.getJavaSourceGroups(this.project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroups);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        if (targetFolder != null) {
            SourceGroup targetSourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroups, targetFolder);
            if (targetSourceGroup != null) {
                this.locationComboBox.setSelectedItem(targetSourceGroup);
                String targetPackage = SourceGroupSupport.getPackageForFolder(targetSourceGroup, targetFolder);
                if (targetPackage != null) {
                    ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).setText(targetPackage);
                }
            }
        } else {
            String targetPackage = (String)settings.getProperty("targetPackage");
            if (targetPackage != null) {
                ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).setText(targetPackage);
            }
        }
        String value = (String)settings.getProperty("ItemResourceName");
        if (value == null || value.trim().length() == 0) {
            this.resourceNameTextField.setText(DEFAULT_RESOURCE_NAME);
            String containerName = Util.pluralize(this.getResourceName());
            this.classTextField.setText(this.findFreeClassName(this.getResourceName()));
            if (ContainerItemSetupPanelVisual.isClientControlledPattern(settings)) {
                this.uriTextField.setText("{name}");
            } else {
                this.uriTextField.setText("{id}");
            }
            this.containerTextField.setText(this.findFreeClassName(containerName));
            this.containerUriTextField.setText("/" + containerName);
            this.representationClassTextField.setText(GenericResourceBean.getDefaultRepresetationClass((Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())));
            this.containerRepresentationClassTextField.setText(GenericResourceBean.getDefaultRepresetationClass((Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())));
            this.uriTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ContainerItemSetupPanelVisual.this.fireChange();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ContainerItemSetupPanelVisual.this.fireChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ContainerItemSetupPanelVisual.this.fireChange();
                }
            });
            this.containerUriTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ContainerItemSetupPanelVisual.this.containerUriOveridden = true;
                    ContainerItemSetupPanelVisual.this.fireChange();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ContainerItemSetupPanelVisual.this.containerUriOveridden = true;
                    ContainerItemSetupPanelVisual.this.fireChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ContainerItemSetupPanelVisual.this.containerUriOveridden = true;
                    ContainerItemSetupPanelVisual.this.fireChange();
                }
            });
        } else {
            this.resourceNameTextField.setText(value);
            this.classTextField.setText((String)settings.getProperty("ItemResourceClass"));
            this.uriTextField.setText((String)settings.getProperty("ItemResourceURI"));
            this.medaTypeComboBox.setSelectedItem((Object)((Constants.MimeType[])settings.getProperty("ItemMimeTypes"))[0]);
            String[] types = (String[])settings.getProperty("RepresentationTypes");
            if (types != null && types.length > 0) {
                this.representationClassTextField.setText(types[0]);
            }
            this.containerTextField.setText((String)settings.getProperty("ContainerResourceClass"));
            this.containerUriTextField.setText((String)settings.getProperty("ContainerResourceURI"));
            types = (String[])settings.getProperty("ContainerRepresentationTypes");
            if (types != null && types.length > 0) {
                this.containerRepresentationClassTextField.setText(types[0]);
            }
        }
    }

    @Override
    public void store(WizardDescriptor settings) {
        settings.putProperty("resourcePackage", (Object)this.getPackage());
        settings.putProperty("ItemResourceName", (Object)this.resourceNameTextField.getText());
        settings.putProperty("ItemResourceClass", (Object)this.classTextField.getText());
        settings.putProperty("ItemResourceURI", (Object)this.uriTextField.getText());
        settings.putProperty("ContainerResourceClass", (Object)this.containerTextField.getText());
        settings.putProperty("ContainerResourceURI", (Object)this.containerUriTextField.getText());
        settings.putProperty("ItemMimeTypes", (Object)new Constants.MimeType[]{(Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())});
        settings.putProperty("sourceGroup", (Object)this.getLocationValue());
        String type = this.representationClassTextField.getText();
        if (type != null && type.length() > 0) {
            settings.putProperty("RepresentationTypes", (Object)new String[]{this.representationClassTextField.getText()});
        }
        if ((type = this.containerRepresentationClassTextField.getText()) != null && type.length() > 0) {
            settings.putProperty("ContainerRepresentationTypes", (Object)new String[]{this.containerRepresentationClassTextField.getText()});
        }
        try {
            FileObject packageFO = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage(), false);
            if (packageFO != null) {
                Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)packageFO);
            } else {
                Templates.setTargetFolder((WizardDescriptor)settings, null);
                settings.putProperty("targetPackage", (Object)this.getPackage());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public SourceGroup getSourceGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    @Override
    public String getPackageName() {
        return ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getText();
    }

    public double getRenderedHeight() {
        return this.selectClassButton1.getLocation().getY() + this.selectClassButton1.getSize().getHeight() + this.getGap();
    }

    private double getGap() {
        double gap = this.containerRepresentationClassTextField.getLocation().getY();
        return gap -= this.representationClassTextField.getLocation().getY() + (double)this.representationClassTextField.getHeight();
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.packageComboBox.setModel(model);
        }
    }

    private String findFreeClassName(String uri) {
        try {
            FileObject folder = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (folder != null) {
                return FileUtil.findFreeFileName((FileObject)folder, (String)Util.deriveResourceClassName(uri), (String)"java");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    static boolean isClientControlledPattern(WizardDescriptor settings) {
        PatternResourcesSetupPanel.Pattern p = (PatternResourcesSetupPanel.Pattern)((Object)settings.getProperty("SelectedPattern"));
        return p == PatternResourcesSetupPanel.Pattern.CLIENTCONTROLLED;
    }
}

