/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.print;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.openide.windows.OutputWriter;

public final class LineProcessors {
    private static final Logger LOGGER = Logger.getLogger(LineProcessors.class.getName());

    private LineProcessors() {
    }

    @NonNull
    public static LineProcessor printing(@NonNull OutputWriter out, boolean resetEnabled) {
        return LineProcessors.printing(out, null, resetEnabled);
    }

    @NonNull
    public static LineProcessor printing(@NonNull OutputWriter out, @NullAllowed LineConvertor convertor, boolean resetEnabled) {
        return new PrintingLineProcessor(out, convertor, resetEnabled);
    }

    private static class PrintingLineProcessor
    implements LineProcessor {
        private final OutputWriter out;
        private final LineConvertor convertor;
        private final boolean resetEnabled;
        private boolean closed;

        public PrintingLineProcessor(OutputWriter out, LineConvertor convertor, boolean resetEnabled) {
            assert (out != null);
            this.out = out;
            this.convertor = convertor;
            this.resetEnabled = resetEnabled;
        }

        public void processLine(String line) {
            assert (line != null);
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            LOGGER.log(Level.FINEST, line);
            if (this.convertor != null) {
                List<ConvertedLine> convertedLines = this.convertor.convert(line);
                if (convertedLines != null) {
                    for (ConvertedLine converted : convertedLines) {
                        if (converted.getListener() == null) {
                            this.out.println(converted.getText());
                            continue;
                        }
                        try {
                            this.out.println(converted.getText(), converted.getListener());
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                            this.out.println(converted.getText());
                        }
                    }
                } else {
                    this.out.println(line);
                }
            } else {
                this.out.println(line);
            }
            this.out.flush();
        }

        public void reset() {
            if (this.closed) {
                throw new IllegalStateException("Already closed processor");
            }
            if (!this.resetEnabled) {
                return;
            }
            try {
                this.out.reset();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }

        public void close() {
            this.closed = true;
            this.out.flush();
            this.out.close();
        }
    }
}

