/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.lang.annotation.Inherited;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.openide.util.Parameters;

public class AnnotationScanner {
    public static final Set<ElementKind> TYPE_KINDS = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE);
    private static final Logger LOGGER = Logger.getLogger(AnnotationScanner.class.getName());
    private final AnnotationHelper helper;

    AnnotationScanner(AnnotationHelper helper) {
        this.helper = helper;
    }

    public void findAnnotations(String searchedTypeName, Set<ElementKind> kinds, AnnotationHandler handler) throws InterruptedException {
        this.findAnnotations(searchedTypeName, kinds, handler, false);
    }

    public void findAnnotations(String searchedTypeName, Set<ElementKind> kinds, AnnotationHandler handler, boolean includeDerived) throws InterruptedException {
        boolean followDerived;
        Parameters.notNull((CharSequence)"searchedTypeName", (Object)searchedTypeName);
        Parameters.notNull((CharSequence)"kinds", kinds);
        Parameters.notNull((CharSequence)"handler", (Object)handler);
        LOGGER.log(Level.FINE, "findAnnotations called with {0} for {1}", new Object[]{searchedTypeName, kinds});
        if (kinds.isEmpty()) {
            LOGGER.log(Level.WARNING, "findAnnotations: no kinds given");
            return;
        }
        CompilationInfo controller = this.getHelper().getCompilationInfo();
        TypeElement searchedType = controller.getElements().getTypeElement(searchedTypeName);
        if (searchedType == null) {
            LOGGER.log(Level.FINE, "findAnnotations: could not find type {0}", searchedTypeName);
            return;
        }
        ElementHandle searchedTypeHandle = ElementHandle.create((Element)searchedType);
        Set elementHandles = this.getHelper().getCompilationInfo().getClasspathInfo().getClassIndex().getElements(searchedTypeHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (elementHandles == null) {
            throw new InterruptedException("ClassIndex.getElements() was interrupted");
        }
        EnumSet<ElementKind> nonTypeKinds = EnumSet.copyOf(kinds);
        nonTypeKinds.removeAll(TYPE_KINDS);
        EnumSet<ElementKind> typeKinds = EnumSet.copyOf(kinds);
        typeKinds.retainAll(TYPE_KINDS);
        boolean bl = followDerived = includeDerived || this.checkInheritance(searchedType);
        if (followDerived) {
            followDerived = typeKinds.size() > 0;
        }
        for (ElementHandle elementHandle : elementHandles) {
            LOGGER.log(Level.FINE, "found element {0}", elementHandle.getQualifiedName());
            TypeElement typeElement = (TypeElement)elementHandle.resolve(controller);
            if (typeElement == null) continue;
            if (!typeKinds.isEmpty()) {
                this.handleAnnotation(handler, typeElement, typeElement, searchedTypeName, typeKinds, followDerived);
            }
            if (nonTypeKinds.isEmpty()) continue;
            for (Element element : typeElement.getEnclosedElements()) {
                if (!nonTypeKinds.contains((Object)element.getKind())) continue;
                this.handleAnnotation(handler, typeElement, element, searchedTypeName, nonTypeKinds, false);
            }
        }
    }

    private void handleAnnotation(AnnotationHandler handler, TypeElement typeElement, Element element, String searchedTypeName, Set<ElementKind> kinds, boolean includeDerived) throws InterruptedException {
        List<? extends AnnotationMirror> fieldAnnotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : fieldAnnotationMirrors) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            String annotationTypeName = this.getHelper().getAnnotationTypeName(annotationType);
            if (searchedTypeName.equals(annotationTypeName)) {
                LOGGER.log(Level.FINE, "notifying type {0}, element {1}, annotation {2}", new Object[]{typeElement.getQualifiedName(), element.getSimpleName(), annotationMirror});
                if (kinds.contains((Object)element.getKind())) {
                    handler.handleAnnotation(typeElement, element, annotationMirror);
                }
                if (!includeDerived || element.getKind() != ElementKind.CLASS) continue;
                this.discoverHierarchy(typeElement, annotationMirror, handler, kinds);
                continue;
            }
            LOGGER.log(Level.FINE, "type name mismatch, ignoring type {0}, element {1}, annotation {2}", new Object[]{typeElement.getQualifiedName(), element.getSimpleName(), annotationMirror});
        }
    }

    private void discoverHierarchy(TypeElement typeElement, AnnotationMirror annotationMirror, AnnotationHandler handler, Set<ElementKind> kinds) throws InterruptedException {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        result.add(typeElement);
        HashSet<TypeElement> toProcess = new HashSet<TypeElement>();
        toProcess.add(typeElement);
        while (toProcess.size() > 0) {
            TypeElement element = (TypeElement)toProcess.iterator().next();
            toProcess.remove(element);
            Set<TypeElement> set = this.doDiscoverHierarchy(element, annotationMirror, handler, kinds);
            if (set.size() == 0) continue;
            result.addAll(set);
            for (TypeElement impl : set) {
                toProcess.add(impl);
            }
        }
        result.remove(typeElement);
        for (TypeElement derivedElement : result) {
            if (!kinds.contains((Object)derivedElement.getKind())) continue;
            handler.handleAnnotation(derivedElement, derivedElement, annotationMirror);
        }
    }

    private Set<TypeElement> doDiscoverHierarchy(TypeElement typeElement, AnnotationMirror annotationMirror, AnnotationHandler handler, Set<ElementKind> kinds) throws InterruptedException {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        ElementHandle handle = ElementHandle.create((Element)typeElement);
        Set handles = this.getHelper().getCompilationInfo().getClasspathInfo().getClassIndex().getElements(handle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (handles == null) {
            throw new InterruptedException("ClassIndex.getElements() was interrupted");
        }
        for (ElementHandle elementHandle : handles) {
            LOGGER.log(Level.FINE, "found derived element {0}", elementHandle.getQualifiedName());
            TypeElement derivedElement = (TypeElement)elementHandle.resolve(this.getHelper().getCompilationInfo());
            if (derivedElement == null) continue;
            result.add(derivedElement);
        }
        return result;
    }

    private boolean checkInheritance(TypeElement annotationType) {
        return this.getHelper().hasAnnotation(annotationType.getAnnotationMirrors(), Inherited.class.getCanonicalName());
    }

    private AnnotationHelper getHelper() {
        return this.helper;
    }
}

