/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;

public class ObjectArrayNode
extends ArrayNode {
    public ObjectArrayNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent) {
        super((Instance)instance, name, parent);
    }

    public ObjectArrayNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent, int mode) {
        super((Instance)instance, name, parent, mode);
    }

    public ObjectArrayInstance getInstance() {
        return (ObjectArrayInstance)super.getInstance();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            @Override
            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] children = null;
                if (ObjectArrayNode.this.getMode() == 1) {
                    int fieldsSize = ObjectArrayNode.this.getInstance().getLength();
                    if (fieldsSize == 0) {
                        children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(ObjectArrayNode.this)};
                    } else if (fieldsSize > 500) {
                        int childrenCount = fieldsSize;
                        BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(childrenCount);
                        int containersCount = groupingInfo.containersCount;
                        int collapseUnitSize = groupingInfo.collapseUnitSize;
                        children = new HeapWalkerNode[containersCount];
                        for (int i = 0; i < containersCount; ++i) {
                            int unitStartIndex = collapseUnitSize * i;
                            int unitEndIndex = Math.min(unitStartIndex + collapseUnitSize, childrenCount) - 1;
                            children[i] = HeapWalkerNodeFactory.createArrayItemContainerNode(ObjectArrayNode.this, unitStartIndex, unitEndIndex);
                        }
                    } else {
                        List fields = ObjectArrayNode.this.getInstance().getValues();
                        children = new HeapWalkerNode[fields.size()];
                        for (int i = 0; i < children.length; ++i) {
                            children[i] = HeapWalkerNodeFactory.createObjectArrayItemNode(ObjectArrayNode.this, i, (Instance)fields.get(i));
                        }
                    }
                } else if (ObjectArrayNode.this.getMode() == 2) {
                    children = HeapWalkerNodeFactory.createReferences(ObjectArrayNode.this);
                }
                return children;
            }
        };
    }

    public static abstract class RootNode
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent) {
            super(instance, name, parent);
        }

        public RootNode(ObjectArrayInstance instance, String name, HeapWalkerNode parent, int mode) {
            super(instance, name, parent, mode);
        }

        @Override
        public abstract void refreshView();
    }

    public static class ArrayItem
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private int itemIndex;
        private String nodeID;

        public ArrayItem(int itemIndex, ObjectArrayInstance instance, HeapWalkerNode parent) {
            this(itemIndex, instance, parent, parent == null ? 1 : parent.getMode());
        }

        public ArrayItem(int itemIndex, ObjectArrayInstance instance, HeapWalkerNode parent, int mode) {
            super(instance, null, parent, mode);
            this.itemIndex = itemIndex;
        }

        @Override
        public int getItemIndex() {
            return this.itemIndex;
        }

        @Override
        protected String computeName() {
            String name = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                return name + " " + Bundle.ObjectArrayNode_LoopToString(BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            return name;
        }

        @Override
        protected String computeType() {
            if (!this.hasInstance()) {
                return "<" + BrowserUtils.getArrayItemType(this.getType()) + ">";
            }
            return super.computeType();
        }

        @Override
        public Object getNodeID() {
            if (this.nodeID == null) {
                this.nodeID = this.itemIndex + "#" + (this.hasInstance() ? Long.valueOf(this.getInstance().getInstanceId()) : "null");
            }
            return this.nodeID;
        }
    }
}

