/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

class SourceLevelQueryImpl2
implements SourceLevelQueryImplementation2 {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private static final String JAVAC_SOURCE = "javac.source";
    private static final String JAVAC_TARGET = "javac.target";
    private static final String DEFAULT_SOURCE_LEVEL = "default.javac.source";
    private static final String DEFAULT_TARGET_LEVEL = "default.javac.target";
    private static final String JAVAC_PROFILE = "javac.profile";
    private static final Pattern SUPPORTS_PROFILES = Pattern.compile("(1\\.)?8");
    private final PropertyEvaluator eval;
    private final String platformType;
    private final SourceLevelQueryImplementation2.Result result;

    SourceLevelQueryImpl2(@NonNull PropertyEvaluator eval, @NonNull String platformType) {
        assert (eval != null);
        assert (platformType != null);
        this.eval = eval;
        this.platformType = platformType;
        this.result = new R();
    }

    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject javaFile) {
        return this.result;
    }

    @CheckForNull
    static String findSourceLevel(@NonNull PropertyEvaluator eval, @NonNull String platformType) {
        return SourceLevelQueryImpl2.findValue(eval, platformType, JAVAC_SOURCE, DEFAULT_SOURCE_LEVEL);
    }

    @CheckForNull
    private static String findTargetLevel(@NonNull PropertyEvaluator eval, @NonNull String platformType) {
        return SourceLevelQueryImpl2.findValue(eval, platformType, JAVAC_TARGET, DEFAULT_TARGET_LEVEL);
    }

    @CheckForNull
    private static String findValue(@NonNull PropertyEvaluator eval, @NonNull String platformType, @NonNull String prop, @NonNull String fallBack) {
        String activePlatform = eval.getProperty(PLATFORM_ACTIVE);
        if (CommonProjectUtils.getActivePlatform(activePlatform, platformType) != null) {
            String sl = eval.getProperty(prop);
            if (sl != null && !sl.isEmpty()) {
                return sl;
            }
            return null;
        }
        EditableProperties props = PropertyUtils.getGlobalProperties();
        String sl = props.get((Object)fallBack);
        if (sl != null && !sl.isEmpty()) {
            return sl;
        }
        return null;
    }

    private static SourceLevelQuery.Profile findProfile(@NonNull PropertyEvaluator eval, @NonNull String platformType) {
        String profile;
        SourceLevelQuery.Profile res;
        if (SourceLevelQueryImpl2.supportsProfiles(SourceLevelQueryImpl2.findTargetLevel(eval, platformType)) && (res = SourceLevelQuery.Profile.forName((String)(profile = eval.getProperty(JAVAC_PROFILE)))) != null) {
            return res;
        }
        res = SourceLevelQuery.Profile.DEFAULT;
        return res;
    }

    private static boolean supportsProfiles(@NullAllowed String sl) {
        return sl != null && SUPPORTS_PROFILES.matcher(sl).matches();
    }

    private class R
    implements SourceLevelQueryImplementation2.Result2,
    PropertyChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        private R() {
            SourceLevelQueryImpl2.this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourceLevelQueryImpl2.this.eval));
        }

        public String getSourceLevel() {
            return SourceLevelQueryImpl2.findSourceLevel(SourceLevelQueryImpl2.this.eval, SourceLevelQueryImpl2.this.platformType);
        }

        public SourceLevelQuery.Profile getProfile() {
            return SourceLevelQueryImpl2.findProfile(SourceLevelQueryImpl2.this.eval, SourceLevelQueryImpl2.this.platformType);
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == null || SourceLevelQueryImpl2.JAVAC_SOURCE.equals(name) || SourceLevelQueryImpl2.JAVAC_PROFILE.equals(name) || SourceLevelQueryImpl2.PLATFORM_ACTIVE.equals(name)) {
                this.cs.fireChange();
            }
        }

        public String toString() {
            String sl = this.getSourceLevel();
            return sl == null ? "" : sl.toString();
        }
    }
}

