/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript.gulp.exec.GulpExecutable;
import org.netbeans.modules.javascript.gulp.util.FileUtils;
import org.openide.util.NbPreferences;

public final class GulpOptions {
    private static final String GULP_PATH = "gulp.path";
    private static final String PREFERENCES_PATH = "gulp";
    private static final GulpOptions INSTANCE = new GulpOptions();
    private final Preferences preferences = NbPreferences.forModule(GulpOptions.class).node("gulp");
    private volatile boolean gulpSearched = false;

    private GulpOptions() {
    }

    public static GulpOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getGulp() {
        String path = this.preferences.get(GULP_PATH, null);
        if (path == null && !this.gulpSearched) {
            this.gulpSearched = true;
            List<String> files = FileUtils.findFileOnUsersPath(GulpExecutable.GULP_NAME);
            if (!files.isEmpty()) {
                path = files.get(0);
                this.setGulp(path);
            }
        }
        return path;
    }

    public void setGulp(String gulp) {
        this.preferences.put(GULP_PATH, gulp);
    }
}

