/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.nodes;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.project.ui.PathFinder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

class PathFinders {
    private PathFinders() {
        throw new IllegalStateException();
    }

    @NonNull
    static PathFinder createPathFinder() {
        return new SubNodesPathFinder();
    }

    @NonNull
    static PathFinder createDelegatingPathFinder(@NullAllowed PathFinder delegate) {
        RebasePathFinder res = new RebasePathFinder();
        res.setDelegate(delegate);
        return res;
    }

    static void updateDelegate(@NonNull PathFinder pathFinder, @NonNull PathFinder delegate) {
        if (!(pathFinder instanceof RebasePathFinder)) {
            throw new IllegalStateException();
        }
        ((RebasePathFinder)pathFinder).setDelegate(delegate);
    }

    private static final class RebasePathFinder
    implements PathFinder {
        private static final String JAVA = ".java";
        private static final String CLASS = ".class";
        private static URI currentKey;
        private static Set<URI> currentValues;
        private volatile PathFinder delegate;

        private RebasePathFinder() {
        }

        void setDelegate(@NullAllowed PathFinder delegate) {
            this.delegate = delegate;
        }

        public Node findPath(Node root, Object target) {
            Node result = null;
            PathFinder _delegate = this.delegate;
            if (_delegate != null && target instanceof FileObject) {
                FileObject newTarget;
                DataObject dobj;
                FileObject binRoot = (FileObject)root.getLookup().lookup(FileObject.class);
                if (binRoot == null && (dobj = (DataObject)root.getLookup().lookup(DataObject.class)) != null) {
                    binRoot = dobj.getPrimaryFile();
                }
                if (binRoot != null && (newTarget = RebasePathFinder.rebase(binRoot, (FileObject)target)) != null) {
                    result = _delegate.findPath(root, (Object)newTarget);
                }
            }
            return result;
        }

        @CheckForNull
        static FileObject rebase(@NonNull FileObject binRoot, @NonNull FileObject sourceTarget) {
            if (RebasePathFinder.shouldIgnore(sourceTarget.toURI(), binRoot.toURI())) {
                return null;
            }
            URL providedBinRootURL = (URL)sourceTarget.getAttribute("classfile-root");
            String providedBinaryName = (String)sourceTarget.getAttribute("classfile-binaryName");
            if (providedBinRootURL != null && providedBinaryName != null) {
                FileObject providedBinRoot = URLMapper.findFileObject((URL)providedBinRootURL);
                if (binRoot.equals(providedBinRoot)) {
                    return binRoot.getFileObject(providedBinaryName + CLASS);
                }
            } else {
                for (FileObject srcRoot : SourceForBinaryQuery.findSourceRoots((URL)binRoot.toURL()).getRoots()) {
                    FileObject newTarget;
                    if (!FileUtil.isParentOf((FileObject)srcRoot, (FileObject)sourceTarget)) continue;
                    String path = FileUtil.getRelativePath((FileObject)srcRoot, (FileObject)sourceTarget);
                    if (path.endsWith(JAVA)) {
                        path = path.substring(0, path.length() - JAVA.length()) + CLASS;
                    }
                    if ((newTarget = binRoot.getFileObject(path)) == null) continue;
                    return newTarget;
                }
            }
            RebasePathFinder.ignore(sourceTarget.toURI(), binRoot.toURI());
            return null;
        }

        private static synchronized boolean shouldIgnore(@NonNull URI key, @NonNull URI value) {
            if (!key.equals(currentKey)) {
                return false;
            }
            return currentValues.contains(value);
        }

        private static synchronized void ignore(@NonNull URI key, @NonNull URI value) {
            if (!key.equals(currentKey)) {
                currentKey = key;
                currentValues = new HashSet<URI>();
            }
            currentValues.add(value);
        }
    }

    private static final class SubNodesPathFinder
    implements PathFinder {
        private SubNodesPathFinder() {
        }

        public Node findPath(Node root, Object target) {
            Node node;
            PathFinder pf;
            Node result = null;
            Node[] nodeArray = root.getChildren().getNodes(true);
            int n = nodeArray.length;
            for (int i = 0; i < n && ((pf = (PathFinder)(node = nodeArray[i]).getLookup().lookup(PathFinder.class)) == null || (result = pf.findPath(node, target)) == null); ++i) {
            }
            return result;
        }
    }
}

