/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.util;

import java.text.ParseException;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openide.util.MapFormat;

public class CommandFormatter {
    Vector items;

    public static String format(String pattern, Map arguments) throws ParseException, IllegalArgumentException {
        CommandFormatter temp = new CommandFormatter(pattern);
        return temp.format(arguments);
    }

    public CommandFormatter(String pattern) throws ParseException {
        this(new StringTokenizer(pattern, "[]", true));
    }

    private CommandFormatter(StringTokenizer tok) throws ParseException {
        this.items = this.scan(tok);
    }

    private Vector scan(StringTokenizer tok) throws ParseException {
        Vector<Object> objvec = new Vector<Object>();
        while (tok.hasMoreTokens()) {
            String token = (String)tok.nextElement();
            Object obj = token;
            if (token.equals("[")) {
                obj = this.scan(tok);
            } else if (token.equals("]")) break;
            objvec.add(obj);
        }
        return objvec;
    }

    public String format(Map arguments) throws IllegalArgumentException {
        return this.format(this.items, arguments);
    }

    private String format(Vector itemvec, Map arguments) throws IllegalArgumentException {
        String retstr = "";
        Enumeration items_e = itemvec.elements();
        while (items_e.hasMoreElements()) {
            Object e_item = items_e.nextElement();
            if (e_item instanceof Vector) {
                try {
                    e_item = this.format((Vector)e_item, arguments);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(e_item instanceof String)) continue;
            MapFormat fmt = new MapFormat(arguments);
            fmt.setThrowExceptionIfKeyWasNotFound(true);
            String e_msg = fmt.format((Object)((String)e_item));
            if (e_msg != null) {
                retstr = retstr + e_msg;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return retstr;
    }
}

