/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.annotation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.Watch;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.web.javascript.debugger.annotation.ToolTipAnnotation;
import org.netbeans.modules.web.javascript.debugger.eval.Evaluator;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.AbstractExpandToolTipAction;
import org.netbeans.spi.debugger.ui.PinWatchUISupport;
import org.openide.util.RequestProcessor;

public class PinWatchValueProvider
implements PinWatchUISupport.ValueProvider,
Debugger.Listener {
    private static final RequestProcessor RP = new RequestProcessor(PinWatchValueProvider.class);
    private final Debugger dbg;
    private final Map<Watch, ValueListeners> valueListeners = new HashMap<Watch, ValueListeners>();

    public PinWatchValueProvider(ContextProvider lookupProvider) {
        this.dbg = (Debugger)lookupProvider.lookupFirst(null, Debugger.class);
        this.dbg.addListener((Debugger.Listener)this);
    }

    public String getId() {
        return "org.netbeans.modules.javascript2.debug.PIN_VALUE_PROVIDER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        return vl.valueString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEditableValue(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        return vl.valueOnlyString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] getHeadActions(Watch watch) {
        ValueListeners vl;
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            vl = this.valueListeners.get(watch);
        }
        if (vl == null) {
            return null;
        }
        VariablesModel.ScopedRemoteObject sr = vl.value;
        if (sr == null || !vl.hasChildren) {
            return null;
        }
        return new Action[]{new ExpandAction(sr, watch.getExpression())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangeListener(Watch watch, PinWatchUISupport.ValueProvider.ValueChangeListener chl) {
        ValueListeners vl = new ValueListeners(chl);
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.put(watch, vl);
        }
        this.updateValue(watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetChangeListener(Watch watch) {
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            this.valueListeners.remove(watch);
        }
    }

    void updateValue(Watch watch) {
        RP.post(() -> {
            if (!this.dbg.isSuspended()) {
                return;
            }
            CallFrame currentCallFrame = this.dbg.getCurrentCallFrame();
            if (currentCallFrame == null) {
                return;
            }
            VariablesModel.ScopedRemoteObject sv = Evaluator.evaluateExpression(currentCallFrame, watch.getExpression(), true);
            if (sv != null) {
                ValueListeners vl;
                Map<Watch, ValueListeners> map = this.valueListeners;
                synchronized (map) {
                    vl = this.valueListeners.get(watch);
                }
                if (vl != null) {
                    RemoteObject var = sv.getRemoteObject();
                    String value = ToolTipAnnotation.getStringValue(var);
                    RemoteObject.Type type = var.getType();
                    if (type == RemoteObject.Type.OBJECT) {
                        vl.value = sv;
                        boolean bl = vl.hasChildren = !var.getProperties().isEmpty();
                    }
                    if (type != RemoteObject.Type.UNDEFINED) {
                        vl.valueString = value;
                        if (type != RemoteObject.Type.OBJECT && type != RemoteObject.Type.FUNCTION) {
                            vl.valueOnlyString = var.getValueAsString();
                        }
                    } else {
                        vl.valueString = var.getDescription();
                    }
                    vl.listener.valueChanged(watch);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paused(List<CallFrame> callStack, String reason) {
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            for (Map.Entry<Watch, ValueListeners> wvl : this.valueListeners.entrySet()) {
                ValueListeners vl = wvl.getValue();
                vl.value = null;
                vl.hasChildren = false;
                vl.valueString = this.getEvaluatingText();
                vl.valueOnlyString = null;
                Watch w = wvl.getKey();
                vl.listener.valueChanged(w);
                this.updateValue(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumed() {
        Map<Watch, ValueListeners> map = this.valueListeners;
        synchronized (map) {
            for (Map.Entry<Watch, ValueListeners> wvl : this.valueListeners.entrySet()) {
                ValueListeners vl = wvl.getValue();
                vl.value = null;
                vl.hasChildren = false;
                vl.valueString = null;
                vl.valueOnlyString = null;
                vl.listener.valueChanged(wvl.getKey());
            }
        }
    }

    public void reset() {
    }

    public void enabled(boolean enabled) {
    }

    private class ExpandAction
    extends AbstractExpandToolTipAction {
        private final VariablesModel.ScopedRemoteObject sr;
        private final String expression;

        ExpandAction(VariablesModel.ScopedRemoteObject sr, String expression) {
            this.sr = sr;
            this.expression = expression;
        }

        protected void openTooltipView() {
            ToolTipSupport tts = this.openTooltipView(this.expression, this.sr);
            if (tts != null) {
                ToolTipAnnotation.handleToolTipClose(PinWatchValueProvider.this.dbg, tts);
            }
        }
    }

    private static final class ValueListeners {
        volatile String valueString = null;
        volatile VariablesModel.ScopedRemoteObject value = null;
        volatile String valueOnlyString = null;
        volatile boolean hasChildren = false;
        PinWatchUISupport.ValueProvider.ValueChangeListener listener;

        ValueListeners(PinWatchUISupport.ValueProvider.ValueChangeListener listener) {
            this.listener = listener;
        }
    }
}

