/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.jrjackson.RubyDateFormat;
import com.jrjackson.RubyUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubyTime;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyAnySerializer
extends JsonSerializer<IRubyObject> {
    public static final RubyAnySerializer instance = new RubyAnySerializer();
    private static final String HLT = "#<";
    private static final String CSP = ": ";
    private static final String GT = ">";
    private static final RUBYCLASS[] CLASS_NAMES = RUBYCLASS.values();

    private void serializeUnknownRubyObject(ThreadContext ctx, IRubyObject rubyObject, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyClass meta = rubyObject.getMetaClass();
        DynamicMethod method = meta.searchMethod("to_json_data");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_json_data");
            if (obj instanceof RubyString) {
                RubyUtils.writeBytes((IRubyObject)obj, jgen);
            } else {
                this.serialize((IRubyObject)obj, jgen, provider);
            }
            return;
        }
        method = meta.searchMethod("to_time");
        if (!method.isUndefined()) {
            RubyTime dt = (RubyTime)method.call(ctx, rubyObject, (RubyModule)meta, "to_time");
            this.serializeTime(dt, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_h");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_h");
            this.serializeHash((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_hash");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_hash");
            this.serializeHash((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_a");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_a");
            this.serializeArray((IRubyObject)obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_json");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_json");
            if (obj instanceof RubyString) {
                jgen.writeRawValue(obj.toString());
            } else {
                this.serialize((IRubyObject)obj, jgen, provider);
            }
            return;
        }
        if (!RubyUtils.isBasicObjectOrSubclass(rubyObject) && rubyObject.respondsTo("to_s")) {
            String result = rubyObject.toString();
            jgen.writeString(result);
        } else {
            String name = meta.getRealClass().getName();
            StringBuilder sb = new StringBuilder(2 + name.length());
            sb.append(HLT).append(name).append(GT);
            jgen.writeString(sb.toString());
        }
    }

    public void serialize(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        String rubyClassName = value.getType().getName();
        if (value.isNil()) {
            jgen.writeNull();
            return;
        }
        if (value instanceof JavaProxy) {
            provider.defaultSerializeValue(((JavaProxy)value).getObject(), jgen);
            return;
        }
        if (value instanceof RubyStruct) {
            IRubyObject obj = value.callMethod(value.getRuntime().getCurrentContext(), "to_a");
            this.serializeArray(obj, jgen, provider);
            return;
        }
        if (value instanceof RubyException) {
            RubyException re = (RubyException)value;
            String msg = re.message(value.getRuntime().getCurrentContext()).toString();
            StringBuilder sb = new StringBuilder(5 + rubyClassName.length() + msg.length());
            sb.append(HLT).append(rubyClassName).append(CSP).append(msg).append(GT);
            jgen.writeString(sb.toString());
            return;
        }
        if (value.isClass() || value.isModule()) {
            jgen.writeString(value.inspect().toString());
            return;
        }
        Enum clazz = null;
        for (RUBYCLASS v : CLASS_NAMES) {
            if (!rubyClassName.equals(v.name())) continue;
            clazz = v;
            break;
        }
        if (clazz == null) {
            this.serializeUnknownRubyObject(value.getRuntime().getCurrentContext(), value, jgen, provider);
            return;
        }
        switch (1.$SwitchMap$com$jrjackson$RubyAnySerializer$RUBYCLASS[clazz.ordinal()]) {
            case 1: {
                this.serializeHash(value, jgen, provider);
                break;
            }
            case 2: {
                this.serializeArray(value, jgen, provider);
                break;
            }
            case 3: {
                RubyUtils.writeBytes(value, jgen);
                break;
            }
            case 4: 
            case 5: {
                RubyString s = value.asString();
                jgen.writeUTF8String(s.getBytes(), 0, s.size());
                break;
            }
            case 6: 
            case 7: {
                jgen.writeBoolean(value.isTrue());
                break;
            }
            case 8: {
                jgen.writeNumber(RubyNumeric.num2dbl((IRubyObject)value));
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                if (value.getJavaClass() == Long.TYPE) {
                    jgen.writeNumber(((RubyNumeric)value).getLongValue());
                    break;
                }
                jgen.writeNumber(((RubyNumeric)value).getBigIntegerValue());
                break;
            }
            case 12: {
                jgen.writeNumber(((RubyBigDecimal)value).getBigDecimalValue());
                break;
            }
            case 13: {
                this.serializeTime((RubyTime)value, jgen, provider);
                break;
            }
            default: {
                this.serializeUnknownRubyObject(value.getRuntime().getCurrentContext(), value, jgen, provider);
            }
        }
    }

    private void serializeArray(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyArray arr = (RubyArray)value;
        IRubyObject[] a = arr.toJavaArray();
        jgen.writeStartArray();
        for (IRubyObject val : a) {
            this.serialize(val, jgen, provider);
        }
        jgen.writeEndArray();
    }

    private void serializeHash(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyHash h = (RubyHash)value;
        jgen.writeStartObject();
        for (Object o : h.directEntrySet()) {
            RubyHash.RubyHashEntry next = (RubyHash.RubyHashEntry)o;
            this.serializeKey((IRubyObject)next.getKey(), jgen, provider);
            this.serialize((IRubyObject)next.getValue(), jgen, provider);
        }
        jgen.writeEndObject();
    }

    private void serializeTime(RubyTime dt, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        DateFormat df = provider.getConfig().getDateFormat();
        if (df == null) {
            provider.defaultSerializeDateValue(dt.getJavaDate(), jgen);
        } else if (df instanceof RubyDateFormat) {
            RubyDateFormat rdf = (RubyDateFormat)df.clone();
            jgen.writeString(rdf.format(dt.getJavaDate()));
        } else {
            SimpleDateFormat sdf = (SimpleDateFormat)df.clone();
            jgen.writeString(df.format(dt.getJavaDate()));
        }
    }

    private void serializeKey(IRubyObject key, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (key instanceof RubyString) {
            jgen.writeFieldName(((RubyString)key).decodeString());
        } else {
            jgen.writeFieldName(key.toString());
        }
    }

    public void serializeWithType(IRubyObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar((Object)value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar((Object)value, jgen);
    }

    static enum RUBYCLASS {
        String,
        Fixnum,
        Integer,
        Hash,
        Array,
        Float,
        BigDecimal,
        Time,
        Bignum,
        Date,
        Symbol,
        TrueClass,
        FalseClass;

    }
}

