/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;

    private ByteArrayCharSequence(@NotNull byte[] chars) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(@NotNull byte[] chars, int start, int end) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(1);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, this.myStart, this.myEnd);
        }
        return h;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index2) {
        return (char)(this.myChars[index2 + this.myStart] & 0xFF);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        CharSequenceWithStringHash charSequenceWithStringHash = start == 0 && end == this.length() ? this : new CharSequenceSubSequence(this, start, end);
        if (charSequenceWithStringHash == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(2);
        }
        return charSequenceWithStringHash;
    }

    @Override
    @NotNull
    public String toString() {
        String string = new String(this.myChars, this.myStart, this.length(), CharsetToolkit.ISO_8859_1_CHARSET);
        if (string == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static CharSequence convertToBytesIfPossible(@NotNull CharSequence string) {
        if (string == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(6);
        }
        if (SystemInfo.IS_AT_LEAST_JAVA9) {
            CharSequence charSequence = string;
            if (charSequence == null) {
                ByteArrayCharSequence.$$$reportNull$$$0(7);
            }
            return charSequence;
        }
        if (string.length() == 0) {
            if ("" == null) {
                ByteArrayCharSequence.$$$reportNull$$$0(8);
            }
            return "";
        }
        if (string instanceof ByteArrayCharSequence) {
            CharSequence charSequence = string;
            if (charSequence == null) {
                ByteArrayCharSequence.$$$reportNull$$$0(9);
            }
            return charSequence;
        }
        byte[] bytes = ByteArrayCharSequence.toBytesIfPossible(string);
        CharSequence charSequence = bytes == null ? string : new ByteArrayCharSequence(bytes);
        if (charSequence == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(10);
        }
        return charSequence;
    }

    @NotNull
    byte[] getBytes() {
        byte[] byArray = this.myStart == 0 && this.myEnd == this.myChars.length ? this.myChars : Arrays.copyOfRange(this.myChars, this.myStart, this.myEnd);
        if (byArray == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(11);
        }
        return byArray;
    }

    @Nullable
    static byte[] toBytesIfPossible(CharSequence seq) {
        if (seq instanceof ByteArrayCharSequence) {
            return ((ByteArrayCharSequence)seq).getBytes();
        }
        byte[] bytes = new byte[seq.length()];
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(seq);
        if (chars == null) {
            for (int i = 0; i < bytes.length; ++i) {
                char c = seq.charAt(i);
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        } else {
            for (int i = 0; i < bytes.length; ++i) {
                char c = chars[i];
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        }
        return bytes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/ByteArrayCharSequence";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/ByteArrayCharSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBytesIfAsciiString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBytesIfPossible";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToBytesIfAsciiString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToBytesIfPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

